DACS.INSTALL(7)         DACS Miscellaneous Information         DACS.INSTALL(7)



[1mNAME[0m
       dacs.install - [1mDACS [22minstallation guide

[1mDESCRIPTION[0m
       This document describes how to configure and install this release of
       [1mDACS[22m. Please read it carefully.

           [1mImportant[0m
           +o   Installation requires the GNU [1mmake [22mcommand ([34m[1mgmake[0m[1m[22m[1]) and
               [34m[1mGCC[0m[1m[22m[2].

           +o   The examples here and in other [1mDACS [22mdocumentation assume that
               [1mDACS [22mis installed in its default location, /usr/local/dacs. If
               you specify a different location at build time, please keep
               this in mind as you read the documentation. This also applies
               to third-party packages, which you may install where
               convenient, provided you are careful not to mix different
               versions of the same package; in this document's examples we
               install them under /usr/local and unpack their source code
               under /local/src.

           +o   In some command line examples, long lines have been split to
               improve readability.

           +o   Whenever you upgrade to a more recent version of [1mDACS[22m, please
               do not forget to install the [1mmod_auth_dacs [22mmodule that comes
               with your new version of [1mDACS[22m.

           +o   Please pay careful attention to the descriptions of the
               third-party packages below. Our philosophy is that [1mDACS [22mshould
               be used with the most recent versions of third-party packages
               available at the time [1mDACS [22mis released. This helps to ensure
               that a [1mDACS [22mdeployment has the latest security features and bug
               fixes.

               You should build third-party packages in the order in which
               they are discussed below because packages that are discussed
               earlier may require some that appear later.

               For a few third-party packages, it is important that you use
               the [4mexact[24m [4mversion[24m that is mentioned. Do not use anything newer
               or older.

               For some third-party packages, a particular release is
               [4mrecommended[24m. It is less critical that you use the recommended
               release, but older releases may have important bugs, including
               security problems. A release newer than the one(s) specified
               will not have been tested with [1mDACS [22m- and a release older than
               the one(s) specified may not have been tested with [1mDACS [22m- so if
               you choose to use such a release you are on your own.

               You may save yourself time and headaches if you just use the
               recommended releases.

               Sometimes the recommended version of a third-party package will
               be fine on some platforms but will not build or is buggy on
               another platform. Whenever possible, the [1mDACS [22minstallation
               instructions suggest an alternative version, and you may
               proceed with that version, or a recent version of your choice -
               but keep the preceding comments regarding older releases in
               mind and ensure that a "[1mgmake test[22m" of [1mDACS [22mcompletes
               successfully.

           +o   On some systems it will be necessary to use [34m[1mldconfig(8)[0m[1m[22m[3] (or
               equivalent) so that your system finds the correct shared
               libraries for programs that are executed by the web server,
               including the [1mDACS [22mweb services.


   [1mTrying DACS[0m
       If at this time you only want to try [1mDACS [22mrather than doing a full
       install, review the information below regarding third-party packages
       and then proceed to follow the instructions you will find in
       [34m[1mdacs.quick(7)[0m[1m[22m[4], which is a step-by-step tutorial for installing and
       configuring [1mDACS[22m.

   [1mUpgrading DACS[0m
       If [1mDACS [22m1.4 is already installed on your system and you are not
       changing any third-party packages or installation options, for a "quick
       and dirty" upgrade you can often install a new release on top of a
       previous release. While this will leave your existing [1mDACS[0m
       configuration files alone, it will also leave files that are no longer
       needed by the new [1mDACS[22m. Be sure to check the new distribution's release
       notes and the rest of this manual page for any notable differences and
       incompatibilities - you may need to make some adjustments to your
       pre-existing installation.

       It is possible for minor, incompatible changes introduced by a new
       release to cause temporary, user-visible problems. For example, changes
       to the format of credentials might invalidate sessions (i.e., [1mDACS [22mHTTP
       cookies) issued by the earlier release, requiring users to
       reauthenticate.

        1. Make a backup copy of the previous install, just in case.  [4mIt[24m [4mis[0m
           [4mespecially[24m [4mimportant[24m [4mto[24m [4mmake[24m [4mcopies[24m [4mof[24m [4mall[24m [4mdata[24m [4mfiles[24m [4m(such[24m [4mas[24m [1mDACS[0m
           [4mpassword[24m [4mfiles,[24m [4mother[24m [4mkinds[24m [4mof[24m [4maccount[24m [4mfiles,[24m [4mencryption[24m [4mkeys)[24m [4mand[0m
           [4many[24m [4mcustom[24m [4mconfiguration[24m [4m(such[24m [4mas[24m [4maccess[24m [4mcontrol[24m [4mrules)[24m.

        2. Obtain and unpack the new distribution and [1mchdir [22mto it;

        3. Review [34m[1mdacs.readme(7)[0m[1m[22m[5] and the instructions in this document;

        4. Copy src/config.nice from your installed version to the new src
           directory, make any updates and corrections that are necessary, and
           configure [1mDACS[22m:

               % cd src; sh ./config.nice


        5. Build [1mDACS[22m:

               % gmake


        6. We recommend that you remove some of the files from the previous
           release in case they are no longer required or have been renamed.
           Unless you have put non-standard files in them or made non-standard
           customizations, it is safe to simply delete these directories and
           their contents:

               % rm -f -r /usr/local/dacs/{acls,bin,include,lib,man,www}


        7. Stop [1mhttpd[22m:

               % apachectl stop


        8. Install [1mDACS[22m:

               % gmake install


        9. Make and install the latest [1mmod_auth_dacs [22mmodule:

               % cd ../apache; gmake tag install


       10. Restart [1mhttpd[22m:

               % apachectl start

           or

               % apachectl startssl


       11. Check that [1mDACS [22mappears to be working correctly. You may find it
           handy to construct a set of links or bookmarks that you can use
           after installing or configuring [1mDACS [22mto invoke various [1mDACS [22mweb
           services with appropriate arguments; for instance, try
           [34m[1mdacs_authenticate(8)[0m[1m[22m[6] [34m[1mdacs_current_credentials(8)[0m[1m[22m[7],
           [34m[1mdacs_prenv(8)[0m[1m[22m[8], [34m[1mdacs_list_jurisdictions(8)[0m[1m[22m[9], [34m[1mdacs_conf(8)[0m[1m[22m[10],
           [34m[1mdacs_signout(8)[0m[1m[22m[11], and [34m[1mdacs_version(8)[0m[1m[22m[12]. Review the [1mDACS [22mlog
           file for any error messages or warnings.

   [1mDACS on Windows[0m
       [1mDACS [22mis not currently supported on Microsoft Windows platforms.
       [34m[1mCygwin[0m[1m[22m[13], which provides a GNU/Linux-like environment for Windows, is
       not an officially-supported platform, but [1mDACS [22mreleases usually build
       on it.

       To run [1mDACS [22mutilities and commands on Windows (such as [1mdacscheck[22m), it
       appears to be sufficient to install the binaries along with the Cygwin
       run-time libraries that they require, such as /bin/cygwin1.dll and
       /bin/cygcrypt-0.dll.

   [1mInstalling DACS[0m
       The following describes how to install [1mDACS[22m.

           [1mImportant[0m
           +o   If another release of [1mDACS [22mis present, rename your previous
               release, install the new release, and then copy any
               site-specific configuration files from the previous release to
               the new release.

           +o   Be careful not to mix [1mDACS [22mbinaries and support files from
               different releases; this can lead to strange behaviour that is
               often hard to resolve.

           +o   If you are installing or upgrading a third-party package, make
               sure that you are building against the include files and
               libraries from the correct version (i.e., that the [1mDACS [22mbuild
               is not finding an old version, or using include files from one
               version and library files from a different version). This can
               also cause strange problems.

        1. Unpack the [1mDACS [22mdistribution and move to its root directory.

        2. Familiarize yourself with the system by:

           +o   reading this document;

           +o   running:

                   % src/configure --help


           +o   browsing through the documentation (easily done by loading
               [34m[1mman/index.html[0m[1m[22m[14] into your browser);

           +o   deciding where you want the various components to be installed;
               and

           +o   considering which optional features you may want (you can
               easily make changes at any time, so do not be too concerned
               about this).

            3. A few third-party packages are [4mrequired[24m by [1mDACS [22mand must be
               built before [1mDACS [22mcan be configured and built. Please note
               carefully if any special exceptions apply to your particular
               platform and third-party package needs. Although you may have
               better luck, sometimes we experienced problems building the
               recommended packages (or combinations of packages) on certain
               platforms; whenever possible, we try to provide a workable
               alternative. Late-breaking updates are sometimes available in
               the release's [34m[1mPost-Release Notes[0m[1m[22m[15].

                   [1mImportant[0m
                   It is not necessary to actually [4minstall[24m these packages, you
                   only have to [4mbuild[24m them so that the [1mDACS [22mbuild can use
                   their libraries, include files, and so on, directly from
                   where you build the packages. You may chose to do this if
                   you do not want to upgrade an existing version of the
                   package, or if you are unable to do so.

                   Build these packages [4min[24m [4mthe[24m [4morder[24m [4min[24m [4mwhich[24m [4mthey[24m [4mare[24m [4mlisted[0m
                   [4mbelow[24m. If you install a package, you may need to be root or
                   use [34m[1msudo(8)[0m[1m[22m[16].

                   These packages are not distributed with [1mDACS [22mand have
                   licensing terms completely separate from those of [1mDACS [22mthat
                   are your responsibility.

                1. Install the Expat XML parser

                   This release of [1mDACS [22mhas been tested with [34m[1mExpat[0m[1m[22m[17] 2.0.1
                   and we recommend that you use that release.

                   For use with [1mDACS[22m, [1mExpat [22mcan either be built with
                   [1m-prefix=/usr/local [22mor something like
                   [1m-prefix=/usr/local/expat-2.0.1[22m, whichever you prefer. In
                   the former case, you can omit the [1m--with-expat [22mwhen
                   configuring [1mDACS [22mor use [1m--with-expat=/usr/local[22m, and in the
                   latter case you must use
                   [1m--with-expat=/usr/local/expat-2.0.1[22m. For the record, here
                   is an example of how we build [1mExpat [22mafter unpacking it:

                       % cd expat-2.0.1
                       % ./configure --prefix=/usr/local/expat-2.0.1
                       % make
                       (All should go well.)
                       % make install
                       (All should go well here, too.)


                       [1mNote[0m
                       On Win2K/Cygwin, only a static library is needed. From
                       the root of the [1mexpat [22mdistribution directory:

                           % cd lib; ar rv libexpat.a *.o; ranlib libexpat.a

                       If the build fails, reconfigure using
                       [1m--enable-shared=no [22mand [1m--enable-static=yes [22mand try to
                       build it again.

                2. Install [1mOpenSSL[0m

                   [1mDACS [22muses cryptographic functionality provided by
                   [34m[1mOpenSSL[0m[1m[22m[18]. This release of [1mDACS [22mhas been tested with
                   openssl-1.0.0h and we recommend that you use that release
                   with [1mDACS[22m.  [1mApache [22mshould be built using the version of
                   [1mOpenSSL [22mrecommended by the particular [1mApache [22mrelease -
                   using a more recent version of [1mOpenSSL [22mmay introduce build
                   problems or run-time bugs in [1mApache[22m.  [4mIt[24m [4mis[24m [4mnot[24m [4mnecessary[0m
                   [4mfor[24m [1mApache [4m[22mand[24m [1mDACS [4m[22mto[24m [4muse[24m [4mthe[24m [4msame[24m [4mrelease[24m [4mof[24m [1mOpenSSL[22m.

                       [1mNotes[0m
                       +o   Releases of [1mApache [22mprior to 2.0.55 do not work (as
                           shipped) with [1mOpenSSL [22m0.9.8 or newer.

                       +o   [1mDACS [22mwill work with openssl-1.0.0 but not with
                           openssl-0.9.8[mno] ("[1mgmake test[22m" fails);
                           openssl-0.9.8l is the last of the pre-openssl-1.0.0
                           releases known to work correctly with [1mDACS[22m.

                       +o   If you need InfoCard support and you have upgraded
                           to openssl-1.0.0 or newer, it may be necessary to
                           rebuild [34m[1mxmlsec1[0m[1m[22m[19] against the new library (if you
                           need to rebuild, "[1mgmake test[22m" will fail).

                       +o   When building openssl-0.9.8j on FreeBSD 7.0,
                           problems were encountered that caused "[1mmake[0m
                           [1minstall[22m" to fail; corrections to Makefiles under
                           the fips subdirectory solved the problem.

                       +o   On OpenSolaris, more serious problems building
                           openssl-0.9.8j and openssl-0.9.8k were found and
                           neither could be successfully completed; with the
                           same options and environment, openssl-0.9.8i and
                           openssl-0.9.8l built without incident, however, and
                           the latter was used for testing on that platform.
                           There were also problems forcing the runtime linker
                           to use [1mOpenSSL [22mlibraries other than the default
                           system versions, despite the guidance of the
                           relevant manual pages; it was necessary to set
                           [1mLD_LIBRARY_PATH [22mappropriately (use [1mdacsversion -v[0m
                           to verify that the expected libraries are being
                           used at runtime).

                       +o   If you are enabling [1mDACS [22msupport for Java, add the
                           [1m-fPIC [22mflag to [1mconfig [22mwhen you are building [1mOpenSSL[22m.

                       +o   In some configurations you may want or require
                           shared [1mOpenSSL [22mlibraries; if so, add the [1mshared[0m
                           command line flag to [1mconfig [22mwhen building [1mOpenSSL[22m.

                       +o   Solaris 8 (and perhaps other platforms) may require
                           [34m[1ma patch[0m[1m[22m[20] before [1mOpenSSL [22mwill work properly.
                           Please consult the latest [1mOpenSSL [22mdocumentation.

                       +o   For Solaris 10 x86, review [1mOpenSSL's [22mPROBLEMS file
                           to see if you must apply a patch before [1mOpenSSL[0m
                           will compile correctly with [1mGCC[22m.

                       +o   For the record, here is an example of how we build
                           [1mOpenSSL[22m:

                               % ./config --prefix=/usr/local/openssl-1.0.0h --openssldir=/usr/local/openssl-1.0.0h -fPIC shared


                       +o   On Mac OS X, however, it was necessary to
                           explicitly request a 64-bit build of [1mOpenSSL[22m:

                               % ./Configure darwin64-x86_64-cc --prefix=/usr/local/openssl-1.0.0h --openssldir=/usr/local/openssl-1.0.0h -fPIC shared


                    3. Install Apache 2.2.22 or 2.0.64

                       You will need an SSL-capable [34m[1mApache[0m[1m[22m[21] server (build
                       [1mApache [22mwith [1m--enable-ssl[22m) that uses a recent version of
                       [1mOpenSSL [22m(build [1mApache [22musing [1m--with-ssl=[4m[22mpath[24m, see
                       [34m[1mabove[0m[1m[22m[22]).

                           [1mTip[0m
                           You can install a subset of [1mDACS [22mthat does not
                           require [1mApache [22mand does not require [4many[24m [1mDACS[0m
                           configuration. These stand-alone, general-purpose
                           utility commands, such as [1mhttp [22mand [1msslclient[22m, might
                           be of interest to you even if you are not
                           interested in any other parts of [1mDACS[22m. Look for
                           BASIC_PROGS in Makefile.in to see which commands
                           will be installed.

                           To build this subset, use [1m--with-apache=omit [22mwhen
                           running [1mconfigure[22m. Please continue to review the
                           information about third-party packages in this
                           document, but you can ignore anything that follows
                           that is related to [1mApache [22mand [1mmod_auth_dacs[22m.
                       If you want to use [1mmod_auth_dacs [22mas a dynamic module,
                       which is the recommended configuration, make sure that
                       [1mmod_so [22mis built-in to your [1mhttpd [22m("httpd -l" displays a
                       list).

                           [1mImportant[0m
                           +o   This release of [1mDACS [22mhas been tested with both
                               [1mApache [22m2.0.64 and [1mApache [22m2.2.22. We strongly
                               recommend that you use either of those
                               versions. If necessary, [1mDACS [22mwill probably also
                               work with 2.0.51 and newer, or 2.2.2 and newer,
                               but not with releases older than that.

                           +o   When building [1mApache [22m2.2, we first build and
                               install APR (srclib/apr) and APR-UTIL
                               (srclib/apr-util), and then build [1mhttpd [22musing
                               the [1m--with-apr [22mand [1m--with-apr-util [22mflags. This
                               may be helpful to know if you run into
                               problems. Also, if you encounter problems
                               building [1mdacsversion[22m, it may be necessary for
                               you to go back and build APR with the
                               [1m--disable-lfs [22mflag to disable large file
                               support on your platform. When you build [1mDACS[0m
                               in an upcoming step, you will probably need to
                               use the [1m--with-apache [22mand [1m--with-apache-apr[0m
                               flags (see [34m[1mThird-party support options[0m[1m[22m[23]). If
                               you are going to use the [1m--with-berkeley-db[0m
                               flag when building APR-UTIL, you may want to
                               temporarily skip ahead to [34m[1mbuild Berkeley DB[0m[1m[22m[24]
                               before returning here to continue your [1mApache[0m
                               build.

                           +o   For the record, here is an example of how we
                               built [1mApache [22m2.2 after unpacking it:

                                   % cd httpd-2.2.22
                                   % cd srclib/apr
                                   % ./configure --prefix=/usr/local/apache2-2.2.22/apr-httpd --disable-lfs CFLAGS=-fPIC
                                   % make install
                                   % cd ../apr-util
                                   # See notes below for adding LDFLAGS
                                   % ./configure --prefix=/usr/local/apache2-2.2.22/apr-util-httpd
                                          --with-apr=/usr/local/apache2-2.2.22/apr-httpd
                                          --with-expat=/usr/local/expat-2.0.1
                                          --with-berkeley-db=/usr/local/BerkeleyDB.5.3
                                          --with-dbm=db50
                                   % make install
                                   % cd ../..
                                   # See notes below for adding LDFLAGS
                                   % ./configure --prefix=/usr/local/apache2-2.2.22 --enable-ssl
                                          --with-ssl=/usr/local/openssl-1.0.0h
                                          --with-apr=/usr/local/apache2-2.2.22/apr-httpd
                                          --with-apr-util=/usr/local/apache2-2.2.22/apr-util-httpd
                                          LDFLAGS="-rpath /usr/local/BerkeleyDB.5.3/lib -rpath /usr/local/openssl-1.0.0h/lib"
                                   % make install

                               This builds a very basic server; you can enable
                               other options if you want.

                               Because we deal with multiple versions of
                               third-party packages, each release is installed
                               separately, hence the version numbers in the
                               pathnames.

                               Your mileage may vary, but when doing the top
                               level [1mApache [22mconfiguration above on FreeBSD it
                               was necessary to add "-rpath
                               /usr/local/BerkeleyDB.5.3/lib -rpath
                               /usr/local/openssl-1.0.0h/lib" to [4mLDFLAGS[24m so
                               that Apache commands could find the shared
                               library at run time. On Linux, it was necessary
                               to add "-Wl,-rpath
                               /usr/local/BerkeleyDB.5.3/lib -Wl,-rpath
                               /usr/local/openssl-1.0.0h/lib" to [4mLDFLAGS[24m when
                               building apr-util and at the top level.
                               Alternatively, on either platform the [1mldconfig[0m
                               command or [1mLD_LIBRARY_PATH [22mmight be used. It
                               does not appear necessary to specify additional
                               linker flags on Mac OS X.

                           +o   One difference between the [1mApache [22m2.0 and 2.2
                               releases to be aware of is that the default
                               [1mApache [22mconfiguration with 2.2 may deny all
                               access by default; some [1mDACS [22mfiles should be
                               publicly accessible, however, so you may need
                               to explicitly allow this. For example, in
                               httpd.conf:

                                   <Directory /usr/local/dacs/www>
                                     Satisfy Any
                                     Allow from all
                                     Options Indexes FollowSymLinks
                                   </Directory>


                           +o   [1mApache [22m1.3 is [4mnot[24m supported; please consult the
                               [34m[1mFAQ[0m[1m[22m[25].  [1mDACS [22mhas not been tested with [1mApache[0m
                               2.3 or 2.4.

                           +o   We do not support using [1mmod_auth_dacs [22mwith a
                               non-source install of [1mApache[22m; we have received
                               feedback that it can be done manually without
                               much effort, however. In this case, we believe
                               that the install may go more smoothly if you
                               use the configure flag [1m--disable-shared[22m.

                           [1mTip[0m
                           Check that [1mApache [22mis working properly and that it
                           is actually using the version of [1mOpenSSL [22mthat you
                           are expecting. It is important to confirm that your
                           server is working correctly with your web resources
                           [4mbefore[24m [1mDACS [22mgets involved - doing so can save you
                           time and frustration.

                           You can see your [1mhttpd's [22mServer response-header by
                           connecting to your server (e.g., using [1mtelnet[22m) and
                           engaging in an interaction with it similar to the
                           following (note the last line of output):

                               % telnet localhost 80
                               Trying 127.0.0.1...
                               Connected to localhost
                               Escape character is '^]'.
                               GET / HTTP/1.0

                               HTTP/1.1 200 OK
                               Date: Tue, 30 Aug 2011 21:27:17 GMT
                               Server: Apache/2.2.22 (Unix) mod_auth_dacs/1.4.27(Release date w16-Feb-2012 00:00:01) mod_ssl/2.2.22 OpenSSL/1.0.0g

                4. A few third-party packages are [4moptional[24m and whether you
                   need them depends on which optional features of [1mDACS [22myou
                   require. These packages must be built before [1mDACS [22mcan be
                   configured and built. If you decide you want to add or
                   remove optional capabilities after building [1mDACS[22m, it is
                   easy to do so later.

                       [1mTip[0m
                       If you are new to [1mDACS[22m, it may be a good idea to first
                       build it without any optional packages. After you have
                       gotten the basic system working to your satisfaction,
                       rebuild [1mDACS [22mwith the optional components you need. Or,
                       if you are not sure at this time which optional
                       packages you need, return to this step later.

                    1. Berkeley DB, gdbm, ndbm DB (dbm-type databases)

                       If you want to be able to store [1mDACS [22mconfiguration
                       information in a database or need to access files
                       managed by [1mApache's mod_auth_dbm[22m, you may use [34m[1mBerkeley[0m
                       [1m[34mDB[0m[1m[22m[26] from [34m[1mOracle Corporation[0m[1m[22m[27] (Sleepy Cat Software
                       was acquired by Oracle in February, 2006). A suitable
                       version may already be installed on your system.
                       Version db-5.3.15 is being used for testing, but
                       somewhat older or newer versions should be fine. See
                       the [1mDACS [22mconfigure arguments: [34m[1m--enable-bdb[0m[1m[22m[28],
                       [34m[1m--disable-bdb[0m[1m[22m[29], and [34m[1m--with-bdb[0m[1m[22m[30].

                       The default is to use Berkeley DB if it is available,
                       but if you do not want to use Berkeley DB you can
                       disable it ([34m[1m--disable-bdb[0m[1m[22m[29]) and get similar
                       functionality from the NDBM library, or from GNU GDBM
                       (version 1.8.3 or 1.9.1) in its NDBM compatibility
                       mode. These libraries may already be installed on your
                       system. Get GDBM from [34m[1mftp://ftp.gnu.org/gnu/gdbm[0m[1m[22m[31].
                       See the [34m[1m--enable-ndbm[0m[1m[22m[32] and [34m[1m--enable-gdbm[0m[1m[22m[33]
                       configure flags.

                           [1mNotes[0m
                           +o   It may be necessary to create (or update) links
                               to the Berkeley DB installation directory to
                               avoid problems when building other packages.
                               For example, if you install it in
                               /usr/local/bdb-5.3.15:

                                   % ln -s /usr/local/bdb-5.3.15 /usr/local/BerkeleyDB.5.3
                                   % ln -s /usr/local/bdb-5.3.15 /usr/local/db53


                           +o   For the record, here is an example of how we
                               build Berkeley DB after unpacking it:

                                   % cd build_unix
                                   % ../dist/configure --prefix=/usr/local/bdb-5.3.15
                                   % make
                                   (All should go well.)
                                   % make install
                                   (All should go well here, too.)


                           +o   You cannot use both [1m--enable-ndbm [4m[22mand[0m
                               [1m--enable-gdbm[22m, but you can use either one along
                               with [1m--enable-bdb[22m.

                           +o   GNU GDBM 1.9.1 may not interoperate correctly
                               with databases created by earlier versions of
                               GNU GDBM; consult its source code and
                               documentation for details.

                           +o   A deficiency in configuration processing is
                               that the locations of the GNU GDBM and NDBM
                               libraries cannot be specified; the standard
                               configuration search path is used. A future
                               version should provide [1m--with-gdbm [22mand
                               [1m--with-ndbm [22mflags.

                           +o   The NDBM-workalike, [34m[1msdbm[0m[1m[22m[34], is not currently
                               supported. It may be added to a future release,
                               however, particularly if it is requested.

                    2. SQLite

                       The [34m[1mSQLite[0m[1m[22m[35] database, which can be used together
                       with the [34m[1mdbm-type databases[0m[1m[22m[24], is another option for
                       storing [1mDACS [22mconfiguration information. Version 3.7.10
                       is being used for testing (we use the "autoconf"
                       tarball). See the [1mDACS [22mconfigure arguments:
                       [34m[1m--enable-sqlite[0m[1m[22m[36], [34m[1m--disable-sqlite[0m[1m[22m[37], and
                       [34m[1m--with-sqlite[0m[1m[22m[38].

                    3. Microsoft NTLM

                       If you want to be able to authenticate against NTLM
                       (see [34m[1mlocal_ntlm_authenticate[0m[1m[22m[39]), you must obtain
                       [34m[1mSamba[0m[1m[22m[40]. This release of [1mDACS [22mhas been tested with
                       samba-3.6.3, and we strongly recommend that you use
                       that version. It is not known whether this release of
                       [1mDACS [22mwill work with any other version of [1mSamba [22m- we do
                       not officially support them.

                       [1mDACS [22mNTLM authentication has been tested against
                       Windows 2000 Server SP4.

                           [1mNote[0m
                           [1mDACS [22mrequires the [1mSamba [22msource distribution to be
                           [4mbuilt[24m but it does not matter if [1mSamba [22mis [4minstalled[24m.
                           The [1mDACS [22mbuild procedure looks for include files
                           and libraries relative to the [1mSamba [22mdistribution's
                           root directory.
                       To build [1mSamba [22mfor [1mDACS[22m, from your [1mSamba [22mdistribution's
                       ./source3 directory do:

                           % ./configure --enable-static=yes --with-ads=no --with-ldap=no --disable-swat --disable-cups --disable-pie \
                               --enable-external-libtalloc=no --enable-external-libtdb=no
                           % make

                       Then, when configuring [1mDACS[22m, specify the directory
                       where [1mSamba [22mwas unpacked, for example:

                           --with-samba=/local/src/samba-3.6.3

                       See the [1mDACS [22mconfigure arguments:
                       [34m[1m--enable-ntlm-auth[0m[1m[22m[41] and [34m[1m--with-samba[0m[1m[22m[42].

                    4. libxml2 and xmlsec1

                       If you need InfoCard support (see
                       [34m[1mlocal_infocard_authenticate[0m[1m[22m[43]), [34m[1mlibxml2[0m[1m[22m[44] and
                       [34m[1mxmlsec1[0m[1m[22m[19] are required. Build libxml2 and [1mOpenSSL[0m
                       first, because [34m[1mxmlsec1[0m[1m[22m[19] depends on both of them.
                       This release of [1mDACS [22mhas been tested with libxml2-2.7.8
                       and xmlsec1-1.2.18, and we strongly recommend that you
                       use those versions. It is not known whether this
                       release of [1mDACS [22mwill work with any other versions - we
                       do not officially support them.

                           [1mNotes[0m
                           +o   For the record, here is an example of how we
                               build xmlsec1:

                                   % ./configure --prefix=/usr/local/xmlsec1-1.2.18
                                       --with-libxml=/usr/local/libxml2-2.7.8
                                       --with-openssl=/usr/local/openssl-1.0.0h --with-gnu-ld
                                       --enable-static-linking  --disable-crypto-dl --disable-apps-crypto-dl

                               Except on Mac OS X:

                                   % ./configure --prefix=/usr/local/xmlsec1-1.2.18 \
                                         --with-libxml=/usr/local/libxml2-2.7.8 --with-gnu-ld --enable-static=yes \
                                         --enable-shared=yes --with-nss=/Applications/Firefox.app/Contents/MacOS \
                                         --with-nspr=/Applications/Firefox.app/Contents/MacOS \
                                         --with-openssl=/usr/local/openssl-1.0.0h


                           +o   Due to an apparent error in its build
                               procedure, we sometimes encountered the
                               following error message:

                                   *** Warning: Linking the shared library libxmlsec1-openssl.la against the
                                   *** static library /local/openssl-1.0.0h/lib/libcrypto.a is not portable!

                               After ensuring that libcrypto.so (or
                               libcrypto.dylib) had been installed when
                               building [1mOpenSSL[22m, to correct the xmlsec1 build
                               problem we did "[1mmake clean[22m", re-ran [1mconfigure[0m
                               as above, and edited src/openssl/Makefile under
                               the root of the xmlsec1 distribution directory
                               to change all occurrences of "libcrypto.a" to
                               "libcrypto.so". It was sometimes also necessary
                               to delete the -ldl flag on those same lines,
                               and in other Makefile files in the distribution
                               (and making sure the flag was not specified by
                               xmlsec1-config). After those changes, we ran
                               [1mmake [22magain. Additionally, it was sometimes
                               necessary to specify
                               CFLAGS="-I/usr/local/include -L/usr/local/lib".

                           +o   Another problem related to this library on a
                               CentOS platform resulted in an error message
                               similar to this:

                                   Cannot restore segment prot after reloc: Permission denied

                               The solution was to issue the command (adjust
                               the path as necessary):

                                   % chcon -t texrel_shlib_t /usr/local/xmlsec1-1.2.18/lib/libxmlsec1-openssl.so


                           +o   When including InfoCard support on Mac OS X, it
                               was necessary to tell the dynamic linker where
                               to find the xmlsec1 library (despite using the
                               [1m-rpath [22mflag during the build). To work around
                               this, do something like the following (or
                               equivalent):

                                   % setenv DYLD_LIBRARY_PATH /usr/local/xmlsec1-1.2.18/lib

                               Ensure that "[1mgmake test[22m" does not fail.

                           +o   Due to an apparent bug in configure.in, on
                               FreeBSD [1mconfigure [22mmay incorrectly use the [1m-ldl[0m
                               flag in generated Makefiles. Either edit all
                               Makefiles to remove all occurrences of the [1m-ldl[0m
                               flag, or edit configure.in, add a
                               "*-*-freebsd*" case like the others in the
                               "OpenSSL" section, run [1mautoconf [22mto regenerate
                               [1mconfigure[22m, and then "[1mmake clean[22m" and re-run
                               [1mconfigure[22m.

                           +o   Your experience may differ, but we found
                               xmlsec1 to not cooperate when we wanted to work
                               with multiple installations of libxml2 -
                               apparently if a libxml2 directory or link has
                               been installed, its build procedure seems to
                               use that version, regardless of what is
                               specified on the command line, requiring manual
                               editing of its Makefiles. Check that the
                               correct instance of [1mxml2-config [22mis being used.
                           The [1mDACS [22mbuild procedure uses [1mxmlsec1-config[22m, a
                           program that comes with xmlsec1. If InfoCard
                           support is enabled, the build procedure will look
                           in some standard places for this command. You can
                           specify its location with the
                           [34m[1m--with-xmlsec1-config[0m[1m[22m[45] flag.

                           See the [1mDACS [22mconfigure arguments:
                           [34m[1m--enable-infocard-auth[0m[1m[22m[46] and
                           [34m[1m--with-xmlsec1-config[0m[1m[22m[45]

                        5. LDAP or Microsoft Active Directory

                           Authentication through LDAP (see
                           [34m[1mlocal_ldap_authenticate[0m[1m[22m[47]) is implemented using
                           [34m[1mOpenLDAP[0m[1m[22m[48]. This release of [1mDACS [22mhas been tested
                           only with openldap-2.4.29 and we strongly recommend
                           that you use that version.

                           It is not known whether this release of [1mDACS [22mwill
                           work with any other version of [1mOpenLDAP [22m- we do not
                           support them.  [1mDACS [22mmay work properly with [1mOpenLDAP[0m
                           versions at least as old as 2.2.24, if you really
                           must use one of them.

                           [1mDACS [22mhas been tested against Windows 2000 Server
                           SP4.

                           If the [1m--with-ldap [22mflag is [4mnot[24m given (in which case
                           LDAP authentication must be enabled; e.g., via
                           [1m--enable-ldap-auth[22m), [1mconfigure [22mwill search for
                           [1mOpenLDAP [22mheaders and libraries; if found, it will
                           assume they are a suitable version and use them.

                           If [1m--with-ldap [22mis given (either because [1mOpenLDAP [22mis
                           not installed or an unsuitable version is
                           installed), headers and libraries relative to the
                           root of the specified directory will be used rather
                           than any installed [1mOpenLDAP [22mfiles; it is not
                           necessary to [4minstall[24m [1mOpenLDAP[22m, you only need to
                           [4mbuild[24m it - so you do not need to be concerned about
                           hassles associated with upgrading or any other
                           versions that might already be installed on your
                           system.

                           To build [1mOpenLDAP [22mfor [1mDACS[22m, from the root of your
                           [1mOpenLDAP [22mdistribution do:

                               % ./configure --disable-slapd --enable-static
                               % make

                           If so instructed, do a "[1mmake depend[22m" before the
                           [1mmake[22m.

                           See the [1mDACS [22mconfigure arguments:
                           [34m[1m--enable-ldap-auth[0m[1m[22m[49] and [34m[1m--with-ldap[0m[1m[22m[50]

                        6. Readline

                           The history and editing functionality provided by
                           the [34m[1mGNU Readline Library[0m[1m[22m[51] can be nice to have
                           when using [34m[1mdacsexpr(1)[0m[1m[22m[52] interactively. This
                           release of [1mDACS [22mhas been tested with version 6.2,
                           although we have used readline-6.0 and readline-6.1
                           with recent releases of [1mDACS[22m. Note that you may
                           need to compile Readline with the [1m-fPIC [22mflag ("[1mmake[0m
                           [1mCFLAGS=-fPIC[22m").

                           It is not necessary for you to [4minstall[24m readline,
                           you only need to [4mbuild[24m it - so you do not need to
                           be concerned about hassles associated with
                           upgrading or any other versions that might already
                           be installed on your system.

                               [1mNotes[0m
                               +o   When building on Mac OS X, it was necessary
                                   to fix a bug by editing shlib/Makefile and
                                   making this change:

                                       #SHOBJ_LDFLAGS = -dynamic
                                       SHOBJ_LDFLAGS = -dynamiclib

                               See the [1mDACS [22mconfigure arguments:
                               [34m[1m--with-readline[0m[1m[22m[53]

                        5. Configure and build [1mDACS [22mlibraries, services,
                           commands, and utilities

                           See [34m[1mBuild Options[0m[1m[22m[54] for build alternatives and
                           options to [1mconfigure[22m.

                               % cd src
                               % ./configure
                               % gmake

                           To confirm that [1mDACS [22mhas been built with the
                           third-party packages that you intended, from the
                           run:

                               % ./version -v

                           You should ensure that the [1msslclient [22mutility is
                           working correctly. From the src directory, you can
                           test it using the following command:

                               % perl -e 'printf "GET / HTTP/1.0\n\n";' | ./sslclient dacs.dss.ca:443

                           which should print the contents of
                           [34m[1mhttps://dacs.dss.ca [0m[1m[22mto the standard output. You
                           should repeat this test substituting the name of
                           your server and port.

                               [1mTip[0m
                               After building [1mDACS[22m, it is strongly recommended
                               that you run the self-tests (expression
                               evaluation, crypto code, string handling, and
                               so on) from the src directory:

                                   % gmake test

                               If any error occurs during testing, testing
                               will stop immediately and a message will be
                               displayed. In this event, first check that you
                               are using the recommended software packages and
                               that your build flags are correct. Most often,
                               problems are the result of mixing header files
                               or library files from different versions of a
                               third-party package (e.g., [1mOpenSSL[22m) or
                               incorrect file permissions. If you cannot find
                               anything wrong with your configuration, please
                               submit a bug report that includes the self test
                               output and describes your platform (you can
                               include the output of "./version -v").

                        6. If all looks good, install [1mDACS[0m

                               % gmake install


                               [1mNotes[0m
                               +o   If [1mgmake [22mcomplains about not being able to
                                   find [1mxsltproc[22m, docbook.xsl, or something
                                   that might be related to installing the
                                   documentation, try:

                                       % (cd ../man; gmake touch)
                                       % gmake install


                               +o   This will install the rules for the
                                   standard [1mDACS [22mweb services and run
                                   [34m[1mdacsacl(1)[0m[1m[22m[55] to create and install an
                                   index for them.

                               +o   You can specify [34m[1mDESTDIR[0m[1m[22m[56] to [1mgmake [22mwhen
                                   installing or uninstalling:

                                       % gmake DESTDIR=/tmp/mydacs install

                               The installation process may prompt you for the
                               owner name and group name to use for files and
                               directories; it will guess at reasonable
                               defaults for your platform. The appropriate
                               responses will depend on local conventions, but
                               to start with you might set the owner to your
                               login name or root, and the group name to the
                               same name that is used by [1mApache [22m(specified by
                               the [34m[1mGroup[0m[1m[22m[57] directive in httpd.conf).

                                   [1mTip[0m
                                   While running "[1mgmake install[22m", important
                                   instructions regarding manual installation
                                   steps may be displayed. A copy is written
                                   to .build_notes, truncating any previous
                                   contents.

                            7. As part of the installation procedure, the [1mDACS[0m
                               manual pages are copied into the [1mDACS [22mman
                               directory (default: /usr/local/dacs/man). If
                               you adjust your [1mMANPATH [22menvironment variable to
                               include that directory, try:

                                   % man dacs

                               While it is occasionally handy to view the
                               manual pages using the [1mman [22mcommand, the HTML
                               documentation is far superior.

                            8. Build a [1mDACS[22m-enabled [1mhttpd[0m

                               Please consult apache/README in the [1mDACS[0m
                               distribution for details and, from the apache
                               directory, do:

                                   % gmake help


                                   [1mSecurity[0m
                                   You can build the module with a full
                                   version tag ("[1mgmake tag[22m"), with a simple
                                   tag ("[1mgmake smalltag[22m"), or without a tag
                                   ("[1mgmake notag[22m" or "[1mgmake module[22m"). We
                                   recommend that you compile [1mmod_auth_dacs[0m
                                   with a tag so that [1mApache's[0m
                                   SERVER_SIGNATURE includes a [1mDACS [22mversion
                                   identifier stamp; this makes it easy to
                                   tell which version of [1mDACS [22mthe server is
                                   running and helps to detect mismatches. For
                                   servers that are subject to attack,
                                   however, identifying exactly which modules
                                   are in your [1mApache [22mserver is considered a
                                   security weakness - you may reasonably
                                   choose not to include the stamp.
                               If you want [1mmod_auth_dacs [22mto be a dynamic
                               module, which is recommended, do:

                                   % cd apache
                                   % gmake tag
                                   % gmake install

                               Check that your httpd.conf has the appropriate
                               LoadModule directive.

                               If you want [1mmod_auth_dacs [22mto be a static
                               module:

                                1. Copy apache/mod_auth_dacs.c to [1mApache's[0m
                                   modules/aaa directory

                                2. Re-run [1mApache[22m's configure, adding
                                   [1mmod_auth_dacs [22m([1m--with-module=aaa:auth_dacs[22m)

                                3. Reinstall [1mApache[22m:

                                       % make install


                                4. Verify that [1mmod_auth_dacs [22mappears in the
                                   list of [1mApache [22mmodules:

                                       % httpd -l


                                       [1mTip[0m
                                       Because [1mmod_auth_dacs [22mreferences
                                       symbols in [1mmod_ssl[22m, apparently those
                                       symbols must be loaded [4mbefore[0m
                                       [1mmod_auth_dacs [22mis loaded. This can be
                                       ensured by statically compiling [1mmod_ssl[0m
                                       into [1mhttpd [22m(configure [1mhttpd [22mwith
                                       [1m--enable-ssl [22mand verify with "[1mhttpd[0m
                                       [1m-l[22m") and using the following directive
                                       in httpd.conf to dynamically load the
                                       [1mmod_auth_dacs [22mmodule:

                                           LoadModule auth_dacs_module modules/mod_auth_dacs.so

                                       Alternatively, it may be sufficient to
                                       dynamically load [1mmod_ssl [4m[22mbefore[0m
                                       [1mmod_auth_dacs[22m.

                                       If [1mmod_ssl [22msymbols are unavailable when
                                       they are needed, you'll probably see a
                                       message like the following when you try
                                       to start [1mhttpd[22m:

                                           mod_auth_dacs.so: undefined symbol: ssl_hook_Fixup
                                   After you've installed [1mmod_auth_dacs[22m,
                                   restart [1mhttpd[22m.

                                   If you built the module with a tag, verify
                                   that the [1mDACS [22mversion identifier appears in
                                   SERVER_SIGNATURE. You can do this by
                                   hitting [1mApache's printenv [22mCGI program from
                                   your browser or using a command like:

                                       % http "http://[4mmyserver[24m:[4mmyserverport[24m/cgi-bin/printenv"

                                   (first making sure that [1mApache's printenv[0m
                                   CGI is executable) and examining the
                                   SERVER_SIGNATURE environment variable, or
                                   by running:

                                       % telnet [4mmyserver[24m [4mmyserverport[0m

                                   and typing:

                                       OPTIONS * HTTP/1.0

                                   followed by a blank line and examining the
                                   Server response header.

                                       [1mNote[0m
                                       +o   The URLs that follow will use http
                                           and omit [4mmyserverport[24m. Substitute
                                           https and/or include [4mmyserverport[0m
                                           as necessary for your
                                           configuration.

                                       +o   If you install a new version of
                                           [1mDACS[22m, please make sure that you use
                                           the [1mmod_auth_dacs [22mmodule that comes
                                           with it. Follow the instructions
                                           above.

                                9. An assortment of [1mDACS [22mfiles, including HTML
                                   documentation and CSS files, are copied
                                   into the [1mDACS [22mwww directory (default:
                                   /usr/local/dacs/www).

                                   While you can view the documentation simply
                                   by pointing your web browser at the [1mDACS[0m
                                   www directory, it is recommended that you
                                   make it available through [1mApache [22musing its
                                   [34m[1mAlias[0m[1m[22m[58] directive because the default
                                   site configuration (site.conf-std) expects
                                   handlers and DTDs to be available using
                                   certain URLs.

                                   Add lines like the following to your
                                   httpd.conf:

                                       Alias /dacs      "/usr/local/dacs/www/"
                                       Alias /css       "/usr/local/dacs/www/css/"
                                       Alias /dtd-xsd   "/usr/local/dacs/www/dtd-xsd/"
                                       Alias /examples  "/usr/local/dacs/www/examples/"
                                       Alias /handlers  "/usr/local/dacs/www/handlers/"
                                       Alias /infocards "/usr/local/dacs/www/infocards/"
                                       Alias /man       "/usr/local/dacs/www/man/"
                                       Alias /misc      "/usr/local/dacs/www/misc/"
                                       Alias /mod       "/usr/local/dacs/www/mod/"

                                   To see the [1mDACS [22mDTD files from your
                                   browser, you can also add:

                                       AddType text/plain      .dtd

                                   These .dtd files are only used to document
                                   XML structures and messages used by [1mDACS[0m
                                   and are cited in the documentation.

                                   You should also uncomment these two
                                   directives in your site.conf file:

                                       XSD_BASE_URL "/dacs/dtd-xsd"
                                       DTD_BASE_URL "/dacs/dtd-xsd"


                                       [1mTip[0m
                                       After restarting [1mhttpd[22m, you can view
                                       the documentation using a URL that
                                       looks like http://[4mmyserver[24m/dacs/man or
                                       simply http://[4mmyserver[24m/man.

                               10. Access to all [1mDACS [22mweb services (everything
                                   installed in the .../cgi-bin/dacs
                                   directory) [4mmust[24m be controlled by [1mDACS[22m; that
                                   is, they must be "[1mDACS[22m-wrapped". Assuming
                                   you are following the defaults for
                                   installing [1mDACS[22m, these are the only files
                                   that are required to be [1mDACS[22m-wrapped.

                                   [1mDACS[22m-wrapping a resource or set of related
                                   resources involves:

                                   +o   Configuring [1mApache [22mso that it uses [1mDACS[0m
                                       to manage access to the contents of a
                                       directory or portion of URL space and

                                   +o   Configuring one or more [1mDACS [22maccess
                                       control rules for the jurisdiction
                                       responsible for the resources (this is
                                       done for the [1mDACS [22mweb services by the
                                       default ACLs).
                                       Configuring [1mApache [22minvolves, at
                                       minimum, adding directives like the
                                       following to the appropriate
                                       VirtualHost section of httpd.conf:

                                           AddDACSAuth dacs-acs /usr/local/dacs/bin/dacs_acs "-t -v"
                                           SetDACSAuthMethod dacs-acs external
                                           SetDACSAuthConf dacs-acs "/usr/local/dacs/dacs.conf"
                                           <Location /cgi-bin/dacs>
                                              AuthType DACS
                                              AuthDACS dacs-acs
                                              Require valid-user
                                              Options ExecCGI
                                           </Location>


                                           [1mTip[0m
                                           Remember to restart [1mApache [22mafter
                                           making changes to httpd.conf.
                                       Some administrators may choose to make
                                       [4mall[24m content or [4mall[24m CGIs [1mDACS[22m-wrapped.
                                       That is probably a more secure
                                       approach, although of course it can be
                                       somewhat less efficient than segmenting
                                       the server's URL space into "secure"
                                       and "insecure" areas. Content that is
                                       not [1mDACS[22m-wrapped is totally oblivious
                                       to [1mDACS [22mand incurs no overhead due to
                                       [1mDACS[22m. Also, this approach may
                                       necessitate making "holes" in the URL
                                       space for non-access controlled
                                       resources, which must be done with
                                       care.

                                           [1mTip[0m
                                           If you decide to [1mDACS[22m-wrap
                                           everything, you will likely want to
                                           add rules to grant access to
                                           various public resources, such as
                                           CSS files, robots.txt, favicon.ico,
                                           and various public [1mDACS [22mresources,
                                           such as its man, dtd-xsd, etc.
                                           directories (see the instructions
                                           for the Alias directive above). The
                                           default ACL acl-stddocs.0 does this
                                           for some resources, but you may
                                           need to extend the list to grant
                                           access to additional public
                                           resources.

   [1mInitial Configuration[0m
           [1mTip[0m
           At this point, reviewing [34m[1mdacs.quick(7)[0m[1m[22m[4] is strongly recommended.
           It provides a detailed example of what needs to be done to make
           your [1mDACS [22moperational and how to do some basic testing.

           [1mTip[0m
           The interactive [1mdacsinit [22mutility can perform the steps described
           below quickly. You will find [1mdacsinit [22min the distribution's src
           directory. It can be run anytime after [1mDACS [22mhas been built and
           installed. It produces a directory structure for the federation,
           copies the distribution's site configuration file, creates a
           minimal dacs.conf for the federation and one jurisdiction, makes
           federation and jurisdiction encryption keys, and generates metadata
           for the jurisdiction. The resulting configuration can be used
           immediately by [1mDACS [22mcommands and by [1mDACS [22mweb services after [1mApache[0m
           has been configured for [1mDACS[22m.

           Passing the [1m-d [22mflag to [1mdacsinit [22mcauses it to append a string to
           certain paths and filenames so that, for debugging or test
           purposes, it is unlikely to overwrite any "real" configuration
           files. Passing it the [1m-n [22mflag causes it to display what it would do
           without performing any of the actions.

       Having installed [1mDACS[22m, the next major step is to do some initial
       configuration of your federation and jurisdiction(s). At each
       jurisdiction in your federation you will need to do the following:

        1. Install the default site configuration file. The distribution comes
           with a default site configuration file found in the distribution's
           conf/site.conf-std file. The installation procedure copies this
           file into the [1mDACS [22mfederations directory. After making a backup
           copy of any federations/site.conf file that is already there, copy
           federations/site.conf-std to federations/site.conf, applying any
           customizations you require (customizations are usually done in
           dacs.conf though, so that you can simply copy on top of the
           previous site.conf). Note that conf/site.conf-std may well change
           in a new release and you should use the latest version.

        2. As part of the installation procedure, a default set of access
           control rules is copied into the [1mDACS [22macls directory (default:
           /usr/local/dacs/acls). The default site.conf file (site.conf-std)
           configures [1mDACS [22mto look in that directory for the default rules.
           These rules control access to [1mDACS [22mweb services and are sufficient
           for proper operation.

               [1mTip[0m
               If your installed [1mDACS [22mweb services have a filename suffix
               (e.g., .cgi, you should probably build [1mDACS [22mwith an appropriate
               [1m--with-cgi-suffix [22mflag or customize the rules manually. If it
               is necessary to change the default rules, consider overriding
               them at the jurisdiction level instead of editing a default ACL
               file - this will make it easier for you to upgrade because you
               will not have to carry these changes forward to future releases
               of [1mDACS[22m.

               [1mSecurity[0m
               Access to some administrative and experimental [1mDACS [22mweb
               services is completely disabled or restricted by default;
               [4mchange[24m [4mthese[24m [4mwith[24m [4mcare[24m [4mand[24m [4mat[24m [4myour[24m [4mown[24m [4mrisk,[24m [4mparticularly[24m [4mif[0m
               [4myour[24m [4mweb[24m [4mserver[24m [4mis[24m [4mreachable[24m [4mfrom[24m [4mthe[24m [4mInternet[24m.

        3. Configure your dacs.conf file at each jurisdiction. At the very
           least, you must provide [34m[1mFEDERATION_DOMAIN[0m[1m[22m[59], [34m[1mFEDERATION_NAME[0m[1m[22m[60],
           and [34m[1mJURISDICTION_NAME[0m[1m[22m[61] directives; all other required directives
           will come from the site.conf file installed in an earlier step if
           you do not specify them.

        4. Use [34m[1mdacskey(1)[0m[1m[22m[62] to make encryption keys for the federation (if
           you are creating a new federation) or obtain a copy of the
           federation's encryption keys for each new jurisdiction (if you are
           joining an existing federation). Each jurisdiction in a federation
           must have a copy of the same federation keys.

        5. Use [34m[1mdacskey(1)[0m[1m[22m[62] to make encryption keys for each new
           jurisdiction (each jurisdiction will have different keys).

        6. Create a group definition that describes your jurisdictions - see
           [34m[1mdacs.groups(5)[0m[1m[22m[63] - and install an identical copy at each
           jurisdiction.

        7. Check ownership and permissions on [1mDACS [22mexecutables and data files.

               [1mSecurity[0m
               All access to [1mDACS [22mconfiguration files (dacs.conf, site.conf)
               and keys must be limited to the [1mDACS [22madministrator and the [1mDACS[0m
               CGI programs called by [1mApache[22m. The installation process tries
               to set this reasonably, but you should re-check now and after
               making changes because it is vital to maintain a secure system
               (e.g., ls -lR /usr/local/dacs).


   [1mInitial Testing[0m
       Having configured [1mApache [22mand [1mDACS[22m, you should try some basic [1mDACS [22mweb
       services to make sure that they are working properly before you go on
       to make customizations.

       For example, invoke [34m[1mdacs_version(8)[0m[1m[22m[12] from your browser to check that
       it is properly [1mDACS[22m-wrapped (adjust the URL for your environment):

           % http "http://[4mmyserver[24m/cgi-bin/dacs/dacs_version"

       Review the [1mDACS [22mlog files (default: /usr/local/dacs/logs/*) to see what
       happened. You can also try [34m[1mdacsversion(1)[0m[1m[22m[64] from the command line.

       You should verify that [34m[1mdacs_list_jurisdictions(8)[0m[1m[22m[9] works properly.

       The next step is to configure an authentication method - see
       [34m[1mdacs_authenticate(8)[0m[1m[22m[6] and try to authenticate. Once that appears to
       be working, you can try [34m[1mdacs_current_credentials(8)[0m[1m[22m[7],
       [34m[1mdacs_prenv(8)[0m[1m[22m[8], [34m[1mdacs_conf(8)[0m[1m[22m[10], and [34m[1mdacs_signout(8)[0m[1m[22m[11].

   [1mBuild Options[0m
       Running [1mconfigure [22mgenerates config.nice (over-writing any previous
       contents), which can be executed at some later time if you want to
       re-run [1mconfigure [22mwith the same arguments.

           [1mTip[0m
           After you are happy with your configuration, consider squirrelling
           away a copy of config.nice in case you want to reconfigure [1mDACS [22mor
           for use with later releases of [1mDACS[22m.

       It is possible to "bundle" several of the [1mDACS [22mutility programs
       together into a single binary called [1mdacs[22m. This is similar to what
       [1mOpenSSL [22mdoes with its [1mopenssl [22mcommand. Instead of running:

           % dacsacl ...

       you would run:

           % dacs dacsacl ...

       Running [1mdacs [22mwithout arguments displays the list of built-in utilities.
       Some utilities have multiple names that are equivalent; these appear in
       a comma-separated list. To build this combined command, add the flag
       bundle=yes to command lines when building and installing:

           % gmake bundle=yes
           % gmake bundle=yes install

       The commands that are bundled into the [1mdacs [22mcommand won't be built as
       separate programs. To build and install both bundled and unbundled
       commands:

           % gmake bundle=both
           % gmake bundle=both install

       Command: gmake or "[1mgmake build[22m"
           This will build libraries, services, and utilities in the source
           directory. By default, the build process will create shared
           libraries and binaries if they are supported on your platform.

               [1mTip[0m
               If you encounter problems while building [1mDACS [22mwith shared
               libraries, use [1m--disabled-shared [22mand [1m--enable-static [22mwith
               [1mconfigure [22mand try building it again.

       Command: "[1mgmake install[22m"
           This will install all [1mDACS [22mcomponents. We recommend that everything
           other than CGI binaries be put under /usr/local/dacs, which is the
           default. The CGI binaries are by default installed in
           .../[4myour-apache-dir[24m/cgi-bin/dacs. By default, [1mDACS [22mutilities will
           be installed in /usr/local/dacs/bin, which you may want to put on
           your [1mPATH [22mfor convenience.

       Command: "[1mgmake clean[22m"
           Removes binaries, object files, and other junk in the build
           directory

       Command: "[1mgmake distclean[22m"
           Does a "[1mgmake clean[22m" and cleans up so that [1mconfigure [22mcan be
           re-done.

       Command: "[1mgmake extraclean[22m"
           Does a "[1mgmake distclean[22m" and removes configure. After this, do:

               % autoconf -I../include

           and then run [1mconfigure[22m.

       Command: "[1mgmake uninstall[22m"
           Removes installed binaries, include files, and libraries

       Other useful build commands (these should be self-explanatory):


           % gmake build-services
           % gmake build-progs
           % gmake build-static
           % gmake build-shared
           % gmake build-static-services
           % gmake build-shared-services
           % gmake build-static-progs
           % gmake build-shared-progs
           % gmake build-shared-lib
           % gmake install-libs
           % gmake install-shared-lib
           % gmake install-static-lib
           % gmake install-progs
           % gmake install-services

       [1mConfigure Options[0m
           To verify that this documentation is up-to-date, please run:

               % configure --help

           This will also tell you which features are enabled (or disabled) by
           default.  Standard build and install options.PP

           [1m--prefix=[4m[22mPREFIX[0m
               The root for the installation hierarchy [/usr/local/dacs],
               which is referred to as the symbol and variable [34m[1mDACS_HOME[0m[1m[22m[65]

           [1m--exec-prefix=[4m[22mEPREFIX[0m
               The root for the architecture-dependent hierarchy [[4mPREFIX[24m]

           [1m--bindir=[4m[22mDIR[0m
               Where [1mDACS [22mutilities are installed [[4mEPREFIX[24m/bin]

           [1m--libdir=[4m[22mDIR[0m
               Where [1mDACS [22mlibraries are installed [[4mEPREFIX[24m/lib]

           [1m--includedir=[4m[22mDIR[0m
               Where [1mDACS [22minclude files are installed [[4mEPREFIX[24m/include]

           [1m--mandir=[4m[22mDIR[0m
               Where [1mDACS [22mmanual pages are installed [[4mEPREFIX[24m/man]

           [1m--enable-shared[0m
               Generate shared libraries

           [1m--enable-static[0m
               Generate static libraries

           [1m--disable-prefix-check[0m
               Disable prefix path check. The prefix path check does some
               sanity tests on [4mPREFIX[24m.
           Feature selection options.PP

           [1m--enable-access-tokens[0m
               Compile with the authorization caching feature

           [1m--enable-all-auth[0m
               Enable all authentication methods; you can use this flag and
               then individually disable methods (e.g., [1m--enable-all-auth[0m
               [1m--disable-apache-auth [22mwould enable all methods except [1mApache[0m
               password authentication

           [1m--enable-apache-auth[0m
               Enable [1mApache [22mpassword authentication directly through [1mDACS[0m

           [1m--enable-bdb[0m
               Enable Berkeley DB support (default is yes). If you don't want
               it, use [1m--disable-bdb[0m

           [1m--enable-cas-auth[0m
               Enable CAS authentication

           [1m--enable-cert-auth[0m
               Enable X.509 client certificate authentication

           [1m--enable-dacs-conf[0m
               Specify default [1mDACS [22mconfig file

           [1m--enable-dacs-log[0m
               Specify initial [1mDACS [22mlog file

           [1m--enable-debug[0m
               Compile with debugging

           [1m--enable-developer[0m
               Compile with development flags

           [1m--enable-fts[0m
               Use included [34m[1mfts(3)[0m[1m[22m[66] library

           [1m--enable-gdbm[0m
               Enable ndbm support using gdbm's compatibility API
               ([34m[1mgdbm(3)[0m[1m[22m[67])

           [1m--enable-grid-auth[0m
               Enable one-time password grid authentication

           [1m--enable-infocard-auth[0m
               Enable InfoCard authentication and support

           [1m--enable-java[0m
               Enable Java support

           [1m--enable-ldap-auth[0m
               Enable LDAP authentication and roles

           [1m--enable-local-roles[0m
               Enable private [1mDACS [22mroles module (enabled by default)

           [1m--enable-native-auth[0m
               Enable authentication via [1mApache [22mmodules

           [1m--enable-ndbm[0m
               Enable native Unix ndbm API support

           [1m--enable-ntlm-auth[0m
               Enable NTLM authentication

           [1m--enable-pam-auth[0m
               Enable PAM authentication

                   [1mImportant[0m
                   The PAM module should be considered experimental. Test it
                   carefully before production use.

           [1m--enable-passwd-auth[0m
               Enable DACS password-protected account authentication

           [1m--enable-simple-auth[0m
               Enable simple DACS account authentication

           [1m--enable-sqlite[0m
               Enable SQLite support (default is no). If you don't want it,
               use [1m--disable-sqlite[0m

           [1m--enable-token-auth[0m
               Enable one-time password token authentication

           [1m--enable-unix-roles[0m
               Enable Unix groups roles module (enabled by default on Unix
               platforms)

           [1m--enable-user-info[0m
               Compile with the user information reporting feature
           Third-party support options.PP

           [1m--with-apache=[4m[22mDIR[0m
               Root [1mApache [22minstall directory; if [4mDIR[24m is "omit", however, a
               basic subset of [1mDACS [22mwill be installed ([34m[1malso see above[0m[1m[22m[68])
               (example: if [1mApache [22mfiles have been installed in
               /usr/local/apache2.2/include, /usr/local/apache2.2/conf, etc.,
               use [1m--with-apache[22m=/usr/local/apache2.2)

           [1m--with-apache-apr=[4m[22mDIR[0m
               Root [1mApache [22mAPR install directory; required only when [1mApache[0m
               2.2 is used (example:
               [1m--with-apache-apr[22m=/usr/local/apache2.2/apr-httpd)

           [1m--with-apache-apr-config=[4m[22mPATH[0m
               [1mApache [22mAPR configuration program; required only when [1mApache [22m2.2
               is used and the correct program is not on the search path; this
               flag may be required if the build system has more than one
               instance of [1mApache [22minstalled or if you have installed [1mApache [22min
               a non-standard location (example:
               [1m--with-apache-apr-config[22m=/usr/local/apache2.2/apr-httpd/bin/apr-1-config)

           [1m--with-apache-apr-cpp-defs=[4m[22mFLAGS[0m
               Preprocessor flags required when compiling files that include
               [1mApache [22mAPR code; may be required with some "non-standard" cases
               when [1mApache [22m2.2 is used and "[1mapr-1-config --cppflags[22m" is
               unavailable or does not report the correct flags (example:
               [1m--with-apache-apr-cpp-defs[22m=-D_LARGEFILE64_SOURCE)

                   [1mNote[0m
                   It has been reported that on some GNU/Linux platforms, such
                   as Ubuntu, it is necessary to define these symbols when
                   building [1mDACS [22mcode that includes APR header files (such as
                   [1mdacsversion[22m):

                       #define LINUX 2
                       #define _REENTRANT
                       #define _GNU_SOURCE
                       #define _LARGEFILE64_SOURCE

           [1m--with-apache-apr-includes=[4m[22mDIR[0m
               [1mApache [22mAPR include files directory; required with some
               "non-standard" cases when [1mApache [22m2.2 is used and [1mapr-1-config[0m
               is unavailable or does not report the correct directory
               (example: [1m--with-apache-apr-includes[22m=/usr/bin/include/apr-1.0)

           [1m--with-apxs=[4m[22mPATH[0m
               By default, the build procedure expects the [1mApache apxs [22mutility
               to be bin/apxs, relative to [1mApache's [22minstallation directory. On
               systems where this is incorrect, you must specifically
               configure the path for [1mapxs[22m. (example:
               [1m--with-apxs[22m=/usr/sbin/apxs2)

           [1m--with-bdb=[4m[22mDIR[0m
               Location of the root of the installed Berkeley DB libraries,
               include files, etc.; for example
               [1m--with-bdb[22m=/usr/local/BerkeleyDB.5.3. This implies
               [1m--enable-bdb[22m.

           [1m--with-cgi-bin=[4m[22mDIR[0m
               Location of [1mApache [22mCGI files for [1mDACS [22mweb services. This will
               resolve to [4mDIR[24m/cgi-bin/dacs if it exists, or [4mDIR[24m/dacs if that
               exists, or [4mDIR[24m if its last component is "dacs".

           [1m--with-cgi-suffix=[4m[22mSUFFIX[0m
               When installing CGI executables, add [4mSUFFIX[24m as the file
               extension. A typical value for [4mSUFFIX[24m is ".cgi". The default
               access control rules for [1mDACS [22mweb services (via the VFS item
               type dacs_acls) respect this suffix. On Windows platforms,
               where ".exe" is the standard extension for programs, [4mSUFFIX[24m is
               set to that by default. Using a [4mSUFFIX[24m of "no" sets the
               extension to the null string.

           [1m--with-dacs-conf=[4m[22mPATH[0m
               Specify default [1mDACS [22mconfig file (default:
               [4mPREFIX[24m/federations/dacs.conf)

           [1m--with-dacs-log=[4m[22mPATH[0m
               Specify initial [1mDACS [22mlog file (default: [4mPREFIX[24m/logs/error_log)

           [1m--with-expat=[4m[22mDIR[0m
               Root directory of installed [1mExpat [22mlibraries and include files.
               If Expat files have been installed in /usr/local/expat/include,
               /usr/local/expat/lib, etc., use [1m--with-expat[22m=/usr/local/expat.

           [1m--with-federations-root=[4m[22mDIR[0m
               Location of [1mDACS [22mfederations root directory (default:
               [4mPREFIX[24m/federations)

           [1m--with-htdocs=[4m[22mDIR[0m
               Location of [1mApache DACS [22mfiles if not the htdocs subdirectory of
               the [1mApache [22minstall directory.

           [1m--with-iconv=[4m[22mDIR[0m
               Path to parent of iconv installation. This flag may be required
               if you are enabling [1mSamba [22msupport.

           [1m--with-jdk-bin[0m
               If Java support is enabled, this identifies the directory
               containing the [1mjava[22m, [1mjavac[22m, [1mjavah[22m, and [1mjar [22mcommands. If this
               flag is absent, [1mconfigure [22mwill look for those programs using
               the current [1mPATH [22mvariable. (Example:
               [1m--with-jdk-bin=/usr/local/java/bin[22m)

           [1m--with-jdk-includes[0m
               If Java support is enabled, this is a list of one or more [1mGCC[0m
               include flags for JDK include directories (Example:
               [1m--with-jdk-includes=-I/usr/local/jdk/include[0m
               [1m-I/usr/local/jdk/include/freebsd[22m)

           [1m--with-ldap=[4m[22mDIR[0m
               Location of [1mOpenLDAP [4m[22msource[24m files. This is the root directory
               for the OpenLDAP source distribution (Example:
               /local/src/openldap-2.2.28). This implies [1m--enable-ldap-auth[22m.

           [1m--with-mailer-prog=[4m[22mPATH[0m
               Location of a mailer program to use instead of [1msendmail[22m. This
               is only needed if email support is required. If
               [1m--with-mailer-args [22mis also specified, it will be used as the
               command line arguments. See [34m[1mdacsemail(1)[0m[1m[22m[69] for a description
               of how the mailer is expected to behave.

           [1m--with-mailer-args=[4m[22mSTRING[0m
               Command line arguments to use with the selected mailer program.
               This is only required if email support is required. See
               [34m[1mdacsemail(1)[0m[1m[22m[69] for a description of how the mailer is
               expected to behave.

           [1m--with-readline=[4m[22mLIB[0m
               Use [34m[1mGNU Readline[0m[1m[22m[51] when available. If [4mLIB[24m is given, it is the
               link flag to use or the pathname for the library (other flags
               may also be specified). (Example:
               [1m--with-readline=-Wl,-rpath,/local/src/readline-6.2/lib[0m
               [1m-L/local/src/readline-6.2/lib[0m
               [1m-I/local/src/readline-6.2/include[22m)

           [1m--with-samba=[4m[22mDIR[0m
               Location of Samba [4msource[24m files. This is the root directory for
               the Samba source distribution (Example:
               /local/src/samba-3.6.3). This implies [1m--enable-ntlm-auth[22m.

           [1m--with-sendmail=[4m[22mPATH[0m
               Location of [34m[1msendmail(8)[0m[1m[22m[70]. This is only needed if email
               support is required and the location of the [1msendmail [22mcommand
               found at configuration time must be overridden. If
               [1m--with-mailer-args [22mis also specified, it will be used instead
               of the default [1msendmail [22mcommand line arguments. See
               [34m[1mdacsemail(1)[0m[1m[22m[69] for additional details.

           [1m--with-sqlite=[4m[22mDIR[0m
               Location of the root of the installed SQLite libraries, include
               files, etc.; for example
               [1m--with-sqlite[22m=/usr/local/sqlite-3.7.10. This implies
               [1m--enable-sqlite[22m.

           [1m--with-ssl=[4m[22mDIR[0m
               Location of the root of the installed [1mOpenSSL [22mlibraries and
               include files. If [1mOpenSSL [22mfiles have been installed in
               /usr/local/openssl/include, /usr/local/openssl/lib, etc., use
               [1m--with-expat[22m=/usr/local/openssl.

           [1m--with-xmlsec1-config=[4m[22mPATH[0m
               If the build procedure cannot find [1mxmlsec1-config[22m, or if it
               finds the wrong one, you can specify its location as [4mPATH[24m. This
               may only be required if InfoCard authentication has been
               enabled.

           To specify additional flags for compiling or linking [1mDACS[22m, set
           [4mCFLAGS[24m or [4mLDFLAGS[24m, respectively.

           To specify additional flags for compiling or linking [1mmod_auth_dacs[22m,
           set [4mAPACHE_CFLAGS[24m or [4mAPACHE_LDFLAGS[24m, respectively. For example,
           this command will cause [1mmod_auth_dacs [22mto be built with the [1m-m64[0m
           flag and [1mDACS [22mto be built with both the [1m-m64 [22mflag and the [1m-O3 [22mflag:

               % ./configure "APACHE_CFLAGS=-m64" "CFLAGS=-O3 -m64" ...


[1mSEE ALSO[0m
       [34m[1mdacs(1)[0m[1m[22m[71], [34m[1mdacs.readme(7)[0m[1m[22m[5], [34m[1mdacs.quick(7)[0m[1m[22m[4]

[1mAUTHOR[0m
       Distributed Systems Software ([34m[1mwww.dss.ca[0m[1m[22m[72])

[1mCOPYING[0m
       Copyright (C) 2003-2012 Distributed Systems Software. See the
       [34m[1mLICENSE[0m[1m[22m[73] file that accompanies the distribution for licensing
       information.

[1mNOTES[0m
        1. gmake
           http://directory.fsf.org/project/make

        2. GCC
           http://gcc.gnu.org

        3. ldconfig(8)
           http://www.freebsd.org/cgi/man.cgi?query=ldconfig&apropos=0&sektion=8&manpath=FreeBSD+9.0-RELEASE&format=html

        4. dacs.quick(7)
           http://dacs.dss.ca/man/dacs.quick.7.html

        5. dacs.readme(7)
           http://dacs.dss.ca/man/dacs.readme.7.html

        6. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html

        7. dacs_current_credentials(8)
           http://dacs.dss.ca/man/dacs_current_credentials.8.html

        8. dacs_prenv(8)
           http://dacs.dss.ca/man/dacs_prenv.8.html

        9. dacs_list_jurisdictions(8)
           http://dacs.dss.ca/man/dacs_list_jurisdictions.8.html

       10. dacs_conf(8)
           http://dacs.dss.ca/man/dacs_conf.8.html

       11. dacs_signout(8)
           http://dacs.dss.ca/man/dacs_signout.8.html

       12. dacs_version(8)
           http://dacs.dss.ca/man/dacs_version.8.html

       13. Cygwin
           http://cygwin.com

       14. man/index.html
           http://dacs.dss.ca/man/index.html

       15. Post-Release Notes
           http://dacs.dss.ca/download.html

       16. sudo(8)
           http://www.freebsd.org/cgi/man.cgi?query=sudo&apropos=0&sektion=8&manpath=FreeBSD+9.0-RELEASE&format=html

       17. Expat
           http://expat.sourceforge.net

       18. OpenSSL
           http://www.openssl.org

       19. xmlsec1
           http://www.aleksey.com/xmlsec

       20. a patch
           http://www.openssl.org/support/faq.html#USER1

       21. Apache
           http://httpd.apache.org

       22. above
           http://dacs.dss.ca/man/#install_openssl

       23. Third-party support options
           http://dacs.dss.ca/man/#third-party-support-options

       24. build Berkeley DB
           http://dacs.dss.ca/man/#dbm-databases

       25. FAQ
           http://dacs.dss.ca/man//faq.html

       26. Berkeley DB
           http://www.oracle.com/technology/software/products/berkeley-db/index.html

       27. Oracle Corporation
           http://www.oracle.com

       28. --enable-bdb
           http://dacs.dss.ca/man/#build_flag_--enable-bdb

       29. --disable-bdb
           http://dacs.dss.ca/man/#build_flag_--disable-bdb

       30. --with-bdb
           http://dacs.dss.ca/man/#build_flag_--with-bdb

       31. ftp://ftp.gnu.org/gnu/gdbm
           ftp://ftp.gnu.org/gnu/gdbm/

       32. --enable-ndbm
           http://dacs.dss.ca/man/#build_flag_--enable-ndbm

       33. --enable-gdbm
           http://dacs.dss.ca/man/#build_flag_--enable-gdbm

       34. sdbm
           http://search.cpan.org/src/NWCLARK/perl-5.8.8/ext/SDBM_File/sdbm/README

       35. SQLite
           http://www.sqlite.org

       36. --enable-sqlite
           http://dacs.dss.ca/man/#build_flag_--enable-sqlite

       37. --disable-sqlite
           http://dacs.dss.ca/man/#build_flag_--disable-sqlite

       38. --with-sqlite
           http://dacs.dss.ca/man/#build_flag_--with-sqlite

       39. local_ntlm_authenticate
           http://dacs.dss.ca/man/dacs_authenticate.8.html#local_ntlm_authenticate

       40. Samba
           http://www.samba.org

       41. --enable-ntlm-auth
           http://dacs.dss.ca/man/#build_flag_--enable-ntlm-auth

       42. --with-samba
           http://dacs.dss.ca/man/#build_flag_--with-samba

       43. local_infocard_authenticate
           http://dacs.dss.ca/man/dacs_authenticate.8.html#local_infocard_authenticate

       44. libxml2
           http://xmlsoft.org

       45. --with-xmlsec1-config
           http://dacs.dss.ca/man/#build_flag_--with-xmlsec1-config

       46. --enable-infocard-auth
           http://dacs.dss.ca/man/#build_flag_--enable-infocard-auth

       47. local_ldap_authenticate
           http://dacs.dss.ca/man/dacs_authenticate.8.html#local_ldap_authenticate

       48. OpenLDAP
           http://www.openldap.org

       49. --enable-ldap-auth
           http://dacs.dss.ca/man/#build_flag_--enable-ldap-auth

       50. --with-ldap
           http://dacs.dss.ca/man/#build_flag_--with-ldap

       51. GNU Readline Library
           http://cnswww.cns.cwru.edu/php/chet/readline/rltop.html

       52. dacsexpr(1)
           http://dacs.dss.ca/man/dacsexpr.1.html

       53. --with-readline
           http://dacs.dss.ca/man/#build_flag_--with-readline

       54. Build Options
           http://dacs.dss.ca/man/#build_options

       55. dacsacl(1)
           http://dacs.dss.ca/man/dacsacl.1.html

       56. DESTDIR
           http://www.gnu.org/prep/standards/standards.html#DESTDIR

       57. Group
           http://httpd.apache.org/docs/2.2/mod/mpm_common.html#group

       58. Alias
           http://httpd.apache.org/docs/2.2/mod/mod_alias.html#alias

       59. FEDERATION_DOMAIN
           http://dacs.dss.ca/man/dacs.conf.5.html#FEDERATION_DOMAIN

       60. FEDERATION_NAME
           http://dacs.dss.ca/man/dacs.conf.5.html#FEDERATION_NAME

       61. JURISDICTION_NAME
           http://dacs.dss.ca/man/dacs.conf.5.html#JURISDICTION_NAME

       62. dacskey(1)
           http://dacs.dss.ca/man/dacskey.1.html

       63. dacs.groups(5)
           http://dacs.dss.ca/man/dacs.groups.5.html#dacs_metadata

       64. dacsversion(1)
           http://dacs.dss.ca/man/dacsversion.1.html

       65. DACS_HOME
           http://dacs.dss.ca/man/dacs.conf.5.html#var_dacs_home

       66. fts(3)
           http://www.freebsd.org/cgi/man.cgi?query=fts&apropos=0&sektion=3&manpath=FreeBSD+9.0-RELEASE&format=html

       67. gdbm(3)
           http://directory.fsf.org/gdbm.html

       68. also see above
           http://dacs.dss.ca/man/#building_subset

       69. dacsemail(1)
           http://dacs.dss.ca/man/dacsemail.1.html

       70. sendmail(8)
           http://www.freebsd.org/cgi/man.cgi?query=sendmail&apropos=0&sektion=8&manpath=FreeBSD+9.0-RELEASE&format=html

       71. dacs(1)
           http://dacs.dss.ca/man/dacs.1.html

       72. www.dss.ca
           http://www.dss.ca

       73. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27b                      03/19/2012                   DACS.INSTALL(7)
