DACS.JAVA(7)            DACS Miscellaneous Information            DACS.JAVA(7)



[1mNAME[0m
       dacs.java - [1mDACS [22mJava support

[1mDESCRIPTION[0m
       This document describes support for Java provided by [1mDACS[22m.

       To enable Java support, [1mDACS [22mmust be configured using the [1m--enable-java[0m
       flag. It may also be necessary to specify the location of the Java
       commands and include files. See [34m[1mdacs.install(7)[0m[1m[22m[1].

           [1mNote[0m
           Java support is currently very limited and should be considered
           experimental. It is currently only possible to call [34m[1mdacsauth(1)[0m[1m[22m[2]
           and [34m[1mdacscheck(1)[0m[1m[22m[3] using the Java Native Interface (JNI) provided.
           The command line arguments to both of these commands are exactly as
           documented in their manual pages. Each argument is passed as a
           [1mString[22m.

           The code is not thread-safe and is probably not suitable for being
           called many times within a particular process due to assumptions it
           makes about dynamic memory allocation.

           There are no immediate plans to improve or extend Java support.
           Using the existing capability to build the JNI layer, however, it
           should not be difficult for an experienced Java programmer to build
           upon the example Java code provided.

       With Java support enabled, building [1mDACS [22mwill copy the JNI shared
       library and a .jar file to the library directory (default:
       /usr/local/dacs/lib), and the JNI include files to the include
       directory (default: /usr/local/dacs/include).

       The tools/java/jni distribution directory contains a simple script
       called [1mjavarun [22mthat demonstrates how to run [1mdacsauth [22mor [1mdacscheck [22mas a
       Java application. For example, to validate the Unix password for user
       [4msomebody[24m, run (as root):

           ./javarun dacsauth -m unix suff -user [4msomebody[24m -prompt


[1mDIAGNOSTICS[0m
       The return codes are as documented in the command's manual page.

[1mAUTHOR[0m
       Distributed Systems Software ([34m[1mwww.dss.ca[0m[1m[22m[4])

[1mCOPYING[0m
       Copyright (C) 2003-2012 Distributed Systems Software. See the
       [34m[1mLICENSE[0m[1m[22m[5] file that accompanies the distribution for licensing
       information.

[1mNOTES[0m
        1. dacs.install(7)
           http://dacs.dss.ca/man/dacs.install.7.html

        2. dacsauth(1)
           http://dacs.dss.ca/man/dacsauth.1.html

        3. dacscheck(1)
           http://dacs.dss.ca/man/dacscheck.1.html

        4. www.dss.ca
           http://www.dss.ca

        5. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27b                      03/19/2012                      DACS.JAVA(7)
