DACSPASSWD(1)                DACS Commands Manual                DACSPASSWD(1)



[1mNAME[0m
       dacspasswd - manage [1mDACS [22maccounts

[1mSYNOPSIS[0m
       [1mdacspasswd [22m[[34m[1mdacsoptions[0m[1m[22m[1]] [[1m-p [4m[22mpassword[24m] [[1m-pf [4m[22mfile[24m] [[1m-simple[22m]
                  [[1m-vfs [4m[22mvfs_uri[24m]
                  [[4mop-spec[24m] [[1m--[22m] [[4musername[24m]

[1mDESCRIPTION[0m
       This program is part of the [1mDACS [22msuite.

       The [1mdacspasswd [22mcommand manages accounts that are used by the
       [34m[1mlocal_passwd_authenticate[0m[1m[22m[2] and [34m[1mlocal_simple_authenticate[0m[1m[22m[3],
       authentication modules. This utility serves a similar purpose for these
       authentication modules that [1mApache's [34mhtpasswd(1)[0m[1m[22m[4] command does for
       its [34m[1mmod_auth[0m[1m[22m[5] and [34m[1mmod_auth_dbm[0m[1m[22m[6] modules (or [34m[1mmod_auth_basic[0m[1m[22m[7] and
       [34m[1mmod_authn_dbm[0m[1m[22m[8]).

       Apart from their use by [1mlocal_passwd_authenticate [22mand
       [1mlocal_simple_authenticate[22m, [4mthese[24m [4maccounts[24m [4mare[24m [4mcompletely[24m [4mseparate[24m [4mfrom[0m
       [4many[24m [4mother[24m [4maccounts[24m [4mand[24m [4mpasswords[24m.

           [1mNote[0m
           Only lowercase usernames are permitted for these accounts.

       The command allows arbitrary data to be associated with each account.
       This "private" data is opaque to [1mDACS [22mand is not used by [1mDACS[22m. Custom,
       account-specific information can be stored, retrieved, and deleted.
       Data that is not printable text must be encoded. The information is
       automatically deleted when its account is removed. Using this feature,
       account administration programs might be developed to store:

       +o   the last time a password was changed;

       +o   hashes of previous password values (so that they are not reused);

       +o   a note that the account's password must be changed;

       +o   a password reminder question and answer;

       +o   information for mutual authentication, such as a small image
           provided by the user that is displayed at login time;

       +o   an encrypted representation of the password for recovery purposes
           (when absolutely necessary)

       +o   several security questions (with answers), one of which might be
           selected at random and presented to the user at login time; or

       +o   user preferences.

       Or instead, a pointer to any of this sort of information might be
       stored. There is no size limit for the data, but if relatively large
       amounts of data are being stored for a large number of accounts, the
       storage type should be chosen with care to ensure reasonable
       performance.

       Passwords are accessed using the [1mDACS [22mvirtual filestore through the
       passwds or simple item types. Each record in the file is keyed on the
       username. The information associated with each key consists of several
       fields separated by a "|" character, and includes a digest algorithm
       identifier, salt, the computed digest, and optional application data.

           [1mSecurity[0m
           The password digest algorithm used depends on the
           [34m[1mPASSWORD_DIGEST[0m[1m[22m[9] directive in effect. The
           [34m[1mPASSWORD_SALT_PREFIX[0m[1m[22m[10] directive is also used.

           [4mPlaintext[24m [4mpasswords[24m [4mare[24m [4mnot[24m [4mstored[24m [4mby[24m [1mdacspasswd[22m. This makes it
           more difficult for an attacker that gains access to the password
           file to discover plaintext passwords, but also means that forgotten
           passwords cannot be recovered (except by exhaustive search, which
           ought to be impractical).

           The salted hash of the password is stored, assuming salting has not
           been disabled, rather than the hash of the password itself. This
           makes a stolen password file more difficult for an attacker to use
           (see [34m[1mrainbow tables[0m[1m[22m[11]).

           Only a [1mDACS [22madministrator should be able to successfully run this
           program from the command line. Because [1mDACS [22mkeys and configuration
           files, including the file used to store passwords, must be
           restricted to an administrator, this will normally be the case, but
           a careful administrator will set file permissions to deny access to
           all other users. An ordinary user is able to change his own
           password using the [34m[1mdacs_passwd(8)[0m[1m[22m[12] web service.

           [1mTip[0m
           Even if the password file is stored as a plain text file, it is
           probably best to modify it only through this program or
           [1mdacs_passwd[22m.

           It is good administrative practice to store accounts with passwords
           separately from those without.

       This program is also available as a [1mDACS [22mweb service,
       [34m[1mdacs_passwd(8)[0m[1m[22m[12].

[1mOPTIONS[0m
       By default, the program will prompt for a new password if one is
       required by the selected operation.

       The [1mdacspasswd [22mcommand recognizes these command line flags:

       [1m-p [4m[22mpassword[0m
           Specify the password.

               [1mSecurity[0m
               A password given on the command line may be visible to other
               users on the same system.

       [1m-pdd[0m
           Delete the private data associated with [4musername[24m.

       [1m-pdg[0m
           Get the private data associated with [4musername[24m and print it to the
           standard output.

       [1m-pds [4m[22mstring[0m
           Set (or replace) [4mstring[24m as private data associated with [4musername[24m.

       [1m-pdsf [4m[22mfile[0m
           Set (or replace) the private data associated with [4musername[24m, reading
           it from [4mfile[24m. If [4mfile[24m is "-", then the data is read from the
           standard input. This flag and [1m-pf [22mcannot both be used to read from
           the standard input.

       [1m-pf [4m[22mfile[0m
           Read the password to use from [4mfile[24m. If [4mfile[24m is "-", then the
           password is read from the standard input without prompting. This
           flag and [1m-pdsf [22mcannot both be used to read from the standard input.

       [1m-simple[0m
           Use the simple item type expected by [1mlocal_simple_authenticate[0m
           instead of the default. The program will not prompt for passwords
           because these accounts do not use them.

       [1m-vfs [4m[22mvfs_uri[0m
           Add [4mvfs_uri[24m as a [34m[1mVFS[0m[1m[22m[13] configuration directive. By specifying the
           item type passwds, a location for the password file can be given,
           overriding any configuration file value. This is particularly
           useful in conjunction with [34m[1mdacsauth(1)[0m[1m[22m[14].

       [4mop-spec[0m
           The following operations are recognized. The [1m-enable[22m, [1m-disable[22m,
           [1m-pdd[22m, [1m-pds[22m, and [1m-pdsf [22mare the only operations that can be combined
           with another operation (for example, you can disable an account and
           set its private data at the same time).

           [1m-a[0m
           [1m-add[0m
               Add [4musername[24m to the password file. The entry must not already
               exist. By default, the user will be prompted for the password,
               which must be retyped for confirmation. This is the default
               operation.

           [1m-d[0m
           [1m-del[0m
           [1m-delete[0m
               Delete [4musername[24m from the password file.

           [1m-dis[0m
           [1m-disable[0m
               Disable the account for [4musername[24m so that authentication modules
               will not accept any password. If used with [1m-a[22m, [1m-s[22m, or [1m-u[22m, the
               account will also be disabled. The username may subsequently be
               enabled.

           [1m-en[0m
           [1m-ena[0m
           [1m-enable[0m
               Re-enable the account for [4musername[24m, which is currently
               disabled. The authentication modules will once again accept the
               password. If used with [1m-a[22m, [1m-s[22m, or [1m-u[22m, the account will also be
               enabled.

           [1m-g[0m
           [1m-get[0m
               Get the digest string for [4musername[24m and print it to the standard
               output. A script can validate a password by passing this digest
               string to [34m[1mpassword()[0m[1m[22m[15] along with the password obtained from
               the user.

           [1m-l[0m
           [1m-list[0m
               List [4musername[24m if it appears in the password file. If no
               [4musername[24m is provided, list all usernames. A disabled account is
               indicated by a '*' (which is not a valid character in a
               username).

           [1m-s[0m
           [1m-set[0m
               Set or reset the password for [4musername[24m, which must already
               exist in the password file. The enabled/disabled status is
               preserved unless overridden by a flag.

           [1m-test [4m[22mtestop[0m
               Test an entry for one of several attributes and report the
               outcome through the program's exit status. The [4mtestop[24m is one of
               the following keywords or abbreviated keywords:

               +o   [4menabled[24m, [4mena[24m, [4men[0m

                   Return an exit status of 0 if an account for [4musername[0m
                   exists [4mand[24m is enabled, or 1 if it does not exist or is
                   disabled.

               +o   [4mexists[24m, [4mex[0m

                   Return an exit status of 0 if an account for [4musername[0m
                   exists, or 1 if it does not exist.

               +o   [4mdata[0m

                   Return an exit status of 0 if an account for [4musername[0m
                   exists [4mand[24m has private data, or 1 if it does not exist or
                   does not have private data. If an entry's private data is
                   the empty string, it is considered to have private data.

               +o   [4mdisabled[24m, [4mdis[0m

                   Return an exit status of 0 if an account for [4musername[0m
                   exists [4mand[24m is disabled, or 1 if it does not exist or is
                   enabled.

               [1m-u[0m
               [1m-up[0m
               [1m-update[0m
                   Add [4musername[24m to the password file or update an existing
                   entry for [4musername[24m. By default, the user will be prompted
                   for the password, which must be retyped for confirmation.
                   If the entry exists, the enabled/disabled status is
                   preserved unless overridden by a flag.


           [1m--[0m
               This flag signals the end of the flag arguments; a [4musername[24m may
               follow, possibly beginning with a "[1m-[22m" character.

           Since only the administrator is allowed to use this command, no
           restrictions are imposed on the length or quality of the passwords
           that the administrator supplies; a warning message will be emitted,
           however, if the password is considered to be weak based on the
           [34m[1mPASSWORD_CONSTRAINTS[0m[1m[22m[16] directive that is configured.

[1mEXAMPLES[0m
       To list all of the accounts configured for the jurisdiction named
       EXAMPLE:

           % dacspasswd -uj EXAMPLE -list
           auggie
           bobo*
           booboo
           jj

       Note that the account for username bobo has been disabled.

       To re-enable bobo's account:

           % dacspasswd -uj EXAMPLE -ena bobo

       To test if bobo's account is enabled:

           % dacspasswd -uj EXAMPLE -test ena bobo
           % echo $status
           0

       To test if there are accounts for usernames booboo and bob:

           % dacspasswd -uj EXAMPLE -test exists booboo
           % echo $status
           0
           % dacspasswd -uj EXAMPLE -test exists bob
           % echo $status
           1

       To reset the password for username bobo interactively:

           % dacspasswd -uj EXAMPLE -set bobo
           New password for bobo?
           Re-type new password for bobo?

       Note that the password text is not displayed.

       To reset the password for username bobo using the program's standard
       input:

           % echo $newpasswd | dacspasswd -uj EXAMPLE -set -pf - bobo

       To create a new, disabled account for username bob and store the
       private data "On vacation":

           % dacspasswd -uj EXAMPLE -add -pf ./pwfile -dis -pds "On vacation" bob

       The password is read from the file ./pwfile.

       To get the private data for username bob:

           % set x=`dacspasswd -uj EXAMPLE -pdg bob`
           % echo "$x"
           On vacation


[1mDIAGNOSTICS[0m
       The program exits 0 if everything was fine, and non-zero otherwise. A
       "false" outcome from the [1m-test [22moperation is reflected by an exit status
       of 1. An error condition is indicated by an exit status of 2.

[1mBUGS[0m
       That password information is not represented externally as an XML
       document tends to haunt your humble narrator. The format is subject to
       change.

[1mSEE ALSO[0m
       [34m[1mdacs_passwd(8)[0m[1m[22m[12], [34m[1mdacsauth(1)[0m[1m[22m[14], [34m[1mdacs_authenticate(8)[0m[1m[22m[17],
       [34m[1mdacs_admin(8)[0m[1m[22m[18], [34m[1mdacs.conf(5)[0m[1m[22m[19]

[1mAUTHOR[0m
       Distributed Systems Software ([34m[1mwww.dss.ca[0m[1m[22m[20])

[1mCOPYING[0m
       Copyright (C) 2003-2012 Distributed Systems Software. See the
       [34m[1mLICENSE[0m[1m[22m[21] file that accompanies the distribution for licensing
       information.

[1mNOTES[0m
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. local_passwd_authenticate
           http://dacs.dss.ca/man/dacs_authenticate.8.html#local_passwd_authenticate

        3. local_simple_authenticate
           http://dacs.dss.ca/man/dacs_authenticate.8.html#local_simple_authenticate

        4. htpasswd(1)
           http://httpd.apache.org/docs/2.2/programs/htpasswd.html

        5. mod_auth
           http://httpd.apache.org/docs-2.0/mod/mod_auth.html

        6. mod_auth_dbm
           http://httpd.apache.org/docs-2.0/mod/mod_auth_dbm.html

        7. mod_auth_basic
           http://httpd.apache.org/docs-2.2/mod/mod_auth_basic.html

        8. mod_authn_dbm
           http://httpd.apache.org/docs-2.2/mod/mod_authn_dbm.html

        9. PASSWORD_DIGEST
           http://dacs.dss.ca/man/dacs.conf.5.html#PASSWORD_DIGEST

       10. PASSWORD_SALT_PREFIX
           http://dacs.dss.ca/man/dacs.conf.5.html#PASSWORD_SALT_PREFIX

       11. rainbow tables
           http://en.wikipedia.org/wiki/Rainbow_table

       12. dacs_passwd(8)
           http://dacs.dss.ca/man/dacs_passwd.8.html

       13. VFS
           http://dacs.dss.ca/man/dacs.conf.5.html#VFS

       14. dacsauth(1)
           http://dacs.dss.ca/man/dacsauth.1.html

       15. password()
           http://dacs.dss.ca/man/dacs.exprs.5.html#password

       16. PASSWORD_CONSTRAINTS
           http://dacs.dss.ca/man/dacs.conf.5.html#PASSWORD_CONSTRAINTS

       17. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html

       18. dacs_admin(8)
           http://dacs.dss.ca/man/dacs_admin.8.html

       19. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html

       20. www.dss.ca
           http://www.dss.ca

       21. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27b                      03/19/2012                     DACSPASSWD(1)
