/*
 *  /MathJax/config/MML_HTMLorMML.js
 *  
 *  Copyright (c) 2010-11 Design Science, Inc.
 *
 *  Part of the MathJax library.
 *  See http://www.mathjax.org for details.
 * 
 *  Licensed under the Apache License, Version 2.0;
 *  you may not use this file except in compliance with the License.
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 */

MathJax.Hub.Config({delayJaxRegistration: true});

MathJax.Ajax.Preloading(
  "[MathJax]/jax/input/MathML/config.js",
  "[MathJax]/jax/output/HTML-CSS/config.js",
  "[MathJax]/jax/output/NativeMML/config.js",
  "[MathJax]/config/MMLorHTML.js",
  "[MathJax]/extensions/mml2jax.js",
  "[MathJax]/extensions/MathZoom.js",
  "[MathJax]/extensions/MathMenu.js",
  "[MathJax]/jax/element/mml/jax.js",
  "[MathJax]/extensions/toMathML.js",
  "[MathJax]/jax/input/MathML/jax.js"
);

MathJax.Hub.Config({"v1.0-compatible":false});

MathJax.InputJax.MathML=MathJax.InputJax({id:"MathML",version:"1.1",directory:MathJax.InputJax.directory+"/MathML",extensionDir:MathJax.InputJax.extensionDir+"/MathML",entityDir:MathJax.InputJax.directory+"/MathML/entities",config:{useMathMLspacing:false}});MathJax.InputJax.MathML.Register("math/mml");MathJax.InputJax.MathML.loadComplete("config.js");

MathJax.OutputJax["HTML-CSS"]=MathJax.OutputJax({id:"HTML-CSS",version:"1.1",directory:MathJax.OutputJax.directory+"/HTML-CSS",extensionDir:MathJax.OutputJax.extensionDir+"/HTML-CSS",autoloadDir:MathJax.OutputJax.directory+"/HTML-CSS/autoload",fontDir:MathJax.OutputJax.directory+"/HTML-CSS/fonts",webfontDir:MathJax.OutputJax.fontDir+"/HTML-CSS",config:{scale:100,minScaleAdjust:50,availableFonts:["STIX","TeX"],preferredFont:"TeX",webFont:"TeX",imageFont:"TeX",showMathMenu:true,styles:{".MathJax_Display":{"text-align":"center",margin:"1em 0em"},".MathJax .merror":{"background-color":"#FFFF88",color:"#CC0000",border:"1px solid #CC0000",padding:"1px 3px","font-family":"serif","font-style":"normal","font-size":"90%"},".MathJax_Preview":{color:"#888888"},"#MathJax_Tooltip":{"background-color":"InfoBackground",color:"InfoText",border:"1px solid black","box-shadow":"2px 2px 5px #AAAAAA","-webkit-box-shadow":"2px 2px 5px #AAAAAA","-moz-box-shadow":"2px 2px 5px #AAAAAA","-khtml-box-shadow":"2px 2px 5px #AAAAAA",filter:"progid:DXImageTransform.Microsoft.dropshadow(OffX=2, OffY=2, Color='gray', Positive='true')",padding:"3px 4px"}}}});if(MathJax.Hub.Browser.isMSIE&&document.documentMode>=9){delete MathJax.OutputJax["HTML-CSS"].config.styles["#MathJax_Tooltip"].filter}if(!MathJax.Hub.config.delayJaxRegistration){MathJax.OutputJax["HTML-CSS"].Register("jax/mml")}MathJax.Hub.Register.StartupHook("End Config",[function(b,c){var a=b.Insert({minBrowserVersion:{Firefox:3,Opera:9.52,MSIE:6,Chrome:0.3,Safari:2,Konqueror:4},inlineMathDelimiters:["$","$"],displayMathDelimiters:["$$","$$"],multilineDisplay:true,minBrowserTranslate:function(f){var e=b.getJaxFor(f),k=["[Math]"],j;var h=document.createElement("span",{className:"MathJax_Preview"});if(e.inputJax.id==="TeX"){if(e.root.Get("displaystyle")){j=a.displayMathDelimiters;k=[j[0]+e.originalText+j[1]];if(a.multilineDisplay){k=k[0].split(/\n/)}}else{j=a.inlineMathDelimiters;k=[j[0]+e.originalText.replace(/^\s+/,"").replace(/\s+$/,"")+j[1]]}}for(var g=0,d=k.length;g<d;g++){h.appendChild(document.createTextNode(k[g]));if(g<d-1){h.appendChild(document.createElement("br"))}}f.parentNode.insertBefore(h,f)}},(b.config["HTML-CSS"]||{}));if(b.Browser.version!=="0.0"&&!b.Browser.versionAtLeast(a.minBrowserVersion[b.Browser]||0)){c.Translate=a.minBrowserTranslate;b.Config({showProcessingMessages:false});MathJax.Message.Set("Your browser does not support MathJax",null,4000);b.Startup.signal.Post("MathJax not supported")}},MathJax.Hub,MathJax.OutputJax["HTML-CSS"]]);MathJax.OutputJax["HTML-CSS"].loadComplete("config.js");

MathJax.OutputJax.NativeMML=MathJax.OutputJax({id:"NativeMML",version:"1.1",directory:MathJax.OutputJax.directory+"/NativeMML",extensionDir:MathJax.OutputJax.extensionDir+"/NativeMML",config:{scale:100,showMathMenu:true,showMathMenuMSIE:true,styles:{"DIV.MathJax_MathML":{"text-align":"center",margin:".75em 0px"}}}});if(!MathJax.Hub.config.delayJaxRegistration){MathJax.OutputJax.NativeMML.Register("jax/mml")}(function(b){if(b.isMSIE){var a=document.createElement("object");a.id="mathplayer";a.classid="clsid:32F66A20-7614-11D4-BD11-00104BD3F987";document.getElementsByTagName("head")[0].appendChild(a);document.namespaces.add("mjx","http://www.w3.org/1998/Math/MathML");document.namespaces.mjx.doImport("#mathplayer")}})(MathJax.Hub.Browser);MathJax.OutputJax.NativeMML.loadComplete("config.js");

(function(c){var h="1.1";var a=MathJax.Hub.CombineConfig("MMLorHTML",{prefer:{MSIE:"MML",Firefox:"MML",Opera:"HTML",other:"HTML"}});var e={Firefox:3,Opera:9.52,MSIE:6,Chrome:0.3,Safari:2,Konqueror:4};var b=(c.Browser.version==="0.0"||c.Browser.versionAtLeast(e[c.Browser]||0));var g=false;if(!c.Browser.isIE9){try{new ActiveXObject("MathPlayer.Factory.1");g=true}catch(f){}}var d=(c.Browser.isFirefox&&c.Browser.versionAtLeast("1.5"))||(c.Browser.isMSIE&&g)||(c.Browser.isOpera&&c.Browser.versionAtLeast("9.52"));c.Register.StartupHook("End Config",function(){var i=(a.prefer&&typeof(a.prefer)==="object"?a.prefer[MathJax.Hub.Browser]||a.prefer.other||"HTML":a.prefer);if(b||d){if(d&&(i==="MML"||!b)){if(MathJax.OutputJax.NativeMML){MathJax.OutputJax.NativeMML.Register("jax/mml")}else{c.config.jax.unshift("output/NativeMML")}}else{if(MathJax.OutputJax["HTML-CSS"]){MathJax.OutputJax["HTML-CSS"].Register("jax/mml")}else{c.config.jax.unshift("output/HTML-CSS")}}}else{c.PreProcess.disabled=true;c.prepareScripts.disabled=true;MathJax.Message.Set("Your browser does not support MathJax",null,4000);c.Startup.signal.Post("MathJax not supported")}})})(MathJax.Hub);MathJax.Ajax.loadComplete("[MathJax]/config/MMLorHTML.js");

MathJax.Extension.mml2jax={version:"1.1",config:{element:null,preview:"alttext"},MMLnamespace:"http://www.w3.org/1998/Math/MathML",PreProcess:function(e){if(!this.configured){this.config=MathJax.Hub.CombineConfig("mml2jax",this.config);if(this.config.Augment){MathJax.Hub.Insert(this,this.config.Augment)}this.InitBrowser();this.configured=true}if(typeof(e)==="string"){e=document.getElementById(e)}if(!e){e=this.config.element||document.body}this.ProcessMathArray(e.getElementsByTagName("math"));if(e.getElementsByTagNameNS){this.ProcessMathArray(e.getElementsByTagNameNS(this.MMLnamespace,"math"))}var d=document.getElementsByTagName("html")[0];if(d){for(var c=0,b=d.attributes.length;c<b;c++){var a=d.attributes[c];if(a.nodeName.substr(0,6)==="xmlns:"&&a.nodeValue===this.MMLnamespace){this.ProcessMathArray(e.getElementsByTagName(a.nodeName.substr(6)+":math"))}}}},ProcessMathArray:function(b){var a;if(b.length){if(this.msieMathTagBug){for(a=b.length-1;a>=0;a--){if(b[a].nodeName==="MATH"){this.msieProcessMath(b[a])}else{this.ProcessMath(b[a])}}}else{for(a=b.length-1;a>=0;a--){this.ProcessMath(b[a])}}}},ProcessMath:function(e){var d=e.parentNode;var a=document.createElement("script");a.type="math/mml";d.insertBefore(a,e);if(this.msieScriptBug){var b=this.msieOuterHTML(e);b=b.replace(/<\?import .*?>/i,"").replace(/<\?xml:namespace .*?\/>/i,"");MathJax.HTML.setScript(a,b.replace(/&nbsp;/g,"&#xA0;"));d.removeChild(e)}else{var c=MathJax.HTML.Element("span");c.appendChild(e);MathJax.HTML.setScript(a,c.innerHTML)}if(this.config.preview!=="none"){this.createPreview(e,a)}},msieProcessMath:function(e){var c=e.parentNode;var a=document.createElement("script");a.type="math/mml";c.insertBefore(a,e);var b="",d;while(e&&e.nodeName!=="/MATH"){d=e;e=e.nextSibling;b+=this.msieNodeHTML(d);d.parentNode.removeChild(d)}if(e&&e.nodeName==="/MATH"){e.parentNode.removeChild(e)}a.text=b+"</math>";if(this.config.preview!=="none"){this.createPreview(e,a)}},msieNodeHTML:function(d){var c,b,a;if(d.nodeName==="#text"){c=d.nodeValue.replace(/&/g,"&#x26;").replace(/</g,"&lt;").replace(/>/g,"&gt;")}else{if(d.nodeName==="#comment"){c="<!--"+d.nodeValue+"-->"}else{if(this.msieAttributeBug){c="<"+d.nodeName.toLowerCase();for(b=0,a=d.attributes.length;b<a;b++){if(d.attributes[b].specified){c+=" "+d.attributes[b].nodeName.toLowerCase()+"=";c+='"'+d.attributes[b].nodeValue.replace(/\"/g,'\\"')+'"'}}c+=">"}else{c=this.toLowerCase(d.outerHTML);var e=c.split(/\"/);for(b=0,a=e.length;b<a;b+=2){e[b]=e[b].toLowerCase()}c=e.join('"')}}}return c},msieOuterHTML:function(d){if(d.nodeName.charAt(0)==="#"){return this.msieNodeHTML(d)}if(!this.msieAttributeBug){return d.outerHTML}var c=this.msieNodeHTML(d);for(var b=0,a=d.childNodes.length;b<a;b++){c+=this.msieOuterHTML(d.childNodes[b])}c+="</"+d.nodeName.toLowerCase()+">";return c},createPreview:function(b,a){var c;if(this.config.preview==="alttext"){var d=b.getAttribute("alttext");if(d!=null){c=[this.filterText(d)]}}else{if(this.config.preview instanceof Array){c=this.config.preview}}if(c){c=MathJax.HTML.Element("span",{className:MathJax.Hub.config.preRemoveClass},c);a.parentNode.insertBefore(c,a)}},filterText:function(a){return a},InitBrowser:function(){MathJax.Hub.Browser.Select({MSIE:function(a){var b=MathJax.HTML.Element("span",{className:"mathjax"});MathJax.Hub.Insert(MathJax.Extension.mml2jax,{msieScriptBug:true,msieMathTagBug:(MathJax.HTML.Element("span",{innerHTML:"<math><mi>x</mi></math>"}).childNodes.length!==1),msieAttributeBug:(b.outerHTML.substr(12)!=='"')})}})}};MathJax.Hub.Register.PreProcessor(["PreProcess",MathJax.Extension.mml2jax]);MathJax.Ajax.loadComplete("[MathJax]/extensions/mml2jax.js");

(function(a,c,e,b,h){var i="1.1";var g=a.CombineConfig("MathZoom",{delay:400,styles:{"#MathJax_Zoom":{position:"absolute","background-color":"#F0F0F0",overflow:"auto",display:"block","z-index":301,padding:".5em",border:"1px solid black",margin:0,"font-family":"serif","font-size":"85%","font-weight":"normal","font-style":"normal","text-align":"left","text-indent":0,"text-transform":"none","line-height":"normal","letter-spacing":"normal","word-spacing":"normal","word-wrap":"normal","white-space":"nowrap","float":"none","box-shadow":"5px 5px 15px #AAAAAA","-webkit-box-shadow":"5px 5px 15px #AAAAAA","-moz-box-shadow":"5px 5px 15px #AAAAAA","-khtml-box-shadow":"5px 5px 15px #AAAAAA",filter:"progid:DXImageTransform.Microsoft.dropshadow(OffX=2, OffY=2, Color='gray', Positive='true')"},"#MathJax_ZoomOverlay":{position:"absolute",left:0,top:0,"z-index":300,display:"inline-block",width:"100%",height:"100%",border:0,padding:0,margin:0,"background-color":"white",opacity:0,filter:"alpha(opacity=0)"}}});var d=function(j){if(!j){j=window.event}if(j){if(j.preventDefault){j.preventDefault()}if(j.stopPropagation){j.stopPropagation()}j.cancelBubble=true;j.returnValue=false}return false};var f=MathJax.Extension.MathZoom={version:i,settings:a.config.menuSettings,HandleEvent:function(l,j,k){if(!l){l=window.event}if(f.settings.CTRL&&!l.ctrlKey){return true}if(f.settings.ALT&&!l.altKey){return true}if(f.settings.CMD&&!l.metaKey){return true}if(f.settings.Shift&&!l.shiftKey){return true}return f[j](l,k)},Click:function(k,j){if(this.settings.zoom==="Click"){return this.Zoom(j,k)}},DblClick:function(k,j){if(this.settings.zoom==="Double-Click"){return this.Zoom(j,k)}},Mouseover:function(k,j){if(this.settings.zoom==="Hover"){f.oldMouseOver=j.onmouseover;j.onmouseover=null;j.onmousemove=this.Mousemove;j.onmouseout=this.Mouseout;return f.Timer(k,j)}},Mouseout:function(j){this.onmouseover=f.oldMouseOver;delete f.oldMouseOver;this.onmousemove=this.onmouseout=null;f.ClearTimer();return d(j)},Mousemove:function(j){return f.Timer(j||window.event,this)},Timer:function(k,j){this.ClearTimer();this.timer=setTimeout(MathJax.Callback(["Zoom",this,j,{}]),g.delay);return d(k)},ClearTimer:function(){if(this.timer){clearTimeout(this.timer);delete this.timer}},Zoom:function(s,l){this.ClearTimer();this.Remove();var v=s.parentNode;if(v.className==="MathJax_MathContainer"){v=v.parentNode}if(v.parentNode.className==="MathJax_MathContainer"){v=v.parentNode.parentNode}var q=(String(v.className).match(/^MathJax_(MathML|Display)$/)?v:s).nextSibling;var m=a.getJaxFor(q),r=m.root;var o=(b&&m.outputJax.isa(b.constructor)?"HTMLCSS":(h&&m.outputJax.isa(h.constructor)?"MathML":null));if(!o){return}var j=Math.floor(0.85*document.body.clientWidth),p=Math.floor(0.85*document.body.clientHeight);var k=c.Element("span",{style:{position:"relative",display:"inline-block",height:0,width:0},id:"MathJax_ZoomFrame"},[["span",{id:"MathJax_ZoomOverlay",onmousedown:this.Remove}],["span",{id:"MathJax_Zoom",onclick:this.Remove,style:{visibility:"hidden",fontSize:this.settings.zscale,"max-width":j+"px","max-height":p+"px"}},[["span"]]]]);var x=k.lastChild,u=x.firstChild,n=k.firstChild;s.parentNode.insertBefore(k,s);if(this.msieZIndexBug){var t=c.Element("img",{src:"about:blank",id:"MathJax_ZoomTracker",style:{width:0,height:0,position:"relative"}});document.body.appendChild(k);k.style.position="absolute";k.style.zIndex=g.styles["#MathJax_ZoomOverlay"]["z-index"];k=t}var w=(this["Zoom"+o])(r,u,s);if(this.msiePositionBug){if(this.msieIE8Bug){u.style.position="absolute";x.style.height=u.offsetHeight;u.style.position="";if(x.offsetHeight<=p&&x.offsetWidth<=j){x.style.overflow="visible"}}if(this.msieWidthBug){x.style.width=Math.min(j,w.w)}else{if(w.w>j){x.style.width=j}}if(x.offsetHeight>p){x.style.Height=p+"px"}if(s.nextSibling){s.parentNode.insertBefore(k,s.nextSibling)}else{v.appendChild(k)}}else{if(this.operaPositionBug){x.style.width=Math.min(j,u.offsetWidth)+"px"}}this.Position(x,w,(o==="MathML"&&v.nodeName.toLowerCase()==="div"));x.style.visibility="";if(this.settings.zoom==="Hover"){n.onmouseover=this.Remove}if(window.addEventListener){addEventListener("resize",this.Resize,false)}else{if(window.attachEvent){attachEvent("onresize",this.Resize)}else{this.onresize=window.onresize;window.onresize=this.Resize}}return d(l)},ZoomHTMLCSS:function(o,q,p){q.className="MathJax";b.idPostfix="-zoom";b.getScales(q,q);o.toHTML(q,q);var r=o.HTMLspanElement().bbox;b.idPostfix="";if(r.width&&r.width!=="100%"){var j=Math.floor(0.85*document.body.clientWidth);q.style.width=j+"px";q.style.display="inline-block";var k=(o.id||"MathJax-Span-"+o.spanID)+"-zoom";var l=document.getElementById(k).firstChild;while(l&&l.style.width!==r.width){l=l.nextSibling}if(l){l.style.width="100%"}}q.appendChild(this.topImg);var n=this.topImg.offsetTop;q.removeChild(this.topImg);var m=(this.msieWidthBug?b.getW(p)*b.em:p.offsetWidth);return{w:r.w*b.em,Y:-n,W:m}},ZoomMathML:function(k,l,m){k.toNativeMML(l,l);var n;l.appendChild(this.topImg);n=this.topImg.offsetTop;l.removeChild(this.topImg);var j=(this.ffMMLwidthBug?m.parentNode:m).offsetWidth;return{w:l.offsetWidth,Y:-n,W:j}},Position:function(p,n,r){var k=this.Resize(),m=k.x,l=k.y,j=n.W;if(this.msiePositionBug){j=-j}if(r&&this.ffMMLcenterBug){j=0}var q=-Math.floor((p.offsetWidth-j)/2),o=n.Y;p.style.left=Math.max(q,20-m)+"px";p.style.top=Math.max(o,20-l)+"px"},Resize:function(l){if(f.onresize){f.onresize(l)}var j=0,o=0,n=document.getElementById("MathJax_ZoomFrame"),k=document.getElementById("MathJax_ZoomOverlay");var m=(f.msieZIndexBug?document.getElementById("MathJax_ZoomTracker"):n);if(f.operaPositionBug){n.style.border="1px solid"}if(m.offsetParent){do{j+=m.offsetLeft;o+=m.offsetTop}while(m=m.offsetParent)}if(f.operaPositionBug){n.style.border=""}if(f.msieZIndexBug){n.style.left=j+"px";n.style.top=o+"px"}k.style.left=(-j)+"px";k.style.top=(-o)+"px";if(f.msiePositionBug){setTimeout(f.SetWH,0)}else{f.SetWH()}return{x:j,y:o}},SetWH:function(){var j=document.getElementById("MathJax_ZoomOverlay");j.style.width=j.style.height="1px";j.style.width=document.body.scrollWidth+"px";j.style.height=document.body.scrollHeight+"px"},Remove:function(k){var l=document.getElementById("MathJax_ZoomFrame");if(l){l.parentNode.removeChild(l);l=document.getElementById("MathJax_ZoomTracker");if(l){l.parentNode.removeChild(l)}if(f.operaRefreshBug){var j=c.addElement(document.body,"div",{style:{position:"fixed",left:0,top:0,width:"100%",height:"100%",backgroundColor:"white",opacity:0},id:"MathJax_OperaDiv"});document.body.removeChild(j)}if(window.removeEventListener){removeEventListener("resize",f.Resize,false)}else{if(window.detachEvent){detachEvent("onresize",f.Resize)}else{window.onresize=f.onresize;delete f.onresize}}}return d(k)}};a.Register.StartupHook("HTML-CSS Jax Ready",function(){b=MathJax.OutputJax["HTML-CSS"];b.Augment({HandleEvent:f.HandleEvent})});a.Register.StartupHook("NativeMML Jax Ready",function(){h=MathJax.OutputJax.NativeMML;h.Augment({HandleEvent:f.HandleEvent,MSIEmouseup:function(l,k,j){if(this.trapUp){delete this.trapUp;return true}if(this.MSIEzoomKeys(l)){return true}return false},MSIEclick:function(l,k,j){if(this.trapClick){delete this.trapClick;return true}if(!this.MSIEzoomKeys(l)){return false}if(!this.settings.zoom.match(/Click/)){return false}return(f.Click(l,k)===false)},MSIEdblclick:function(l,k,j){if(!this.MSIEzoomKeys(l)){return false}return(f.DblClick(l,k)===false)},MSIEmouseover:function(l,k,j){if(this.settings.zoom!=="Hover"){return false}f.Timer(l,k);return true},MSIEmouseout:function(l,k,j){if(this.settings.zoom!=="Hover"){return false}f.ClearTimer();return true},MSIEmousemove:function(l,k,j){if(this.settings.zoom!=="Hover"){return false}f.Timer(l,k);return true},MSIEzoomKeys:function(j){if(this.settings.CTRL&&!j.ctrlKey){return false}if(this.settings.CMD&&!j.metaKey){return false}if(this.settings.ALT&&!j.altKey){return false}if(this.settings.Shift&&!j.shiftKey){return false}return true}})});a.Browser.Select({MSIE:function(j){var k=(document.compatMode==="BackCompat");var l=j.versionAtLeast("8.0")&&document.documentMode>7;f.msiePositionBug=true;f.msieWidthBug=!k;f.msieIE8Bug=l;f.msieZIndexBug=!l;f.msieInlineBlockAlignBug=(!l||k);if(document.documentMode>=9){delete g.styles["#MathJax_Zoom"].filter}},Opera:function(j){f.operaPositionBug=true;f.operaRefreshBug=true},Firefox:function(j){f.ffMMLwidthBug=true;f.ffMMLcenterBug=true}});f.topImg=(f.msieInlineBlockAlignBug?c.Element("img",{style:{width:0,height:0},src:"about:blank"}):c.Element("span",{style:{width:0,height:0,display:"inline-block"}}));if(f.operaPositionBug){f.topImg.style.border="1px solid"}MathJax.Callback.Queue(["Styles",e,g.styles],["Post",a.Startup.signal,"MathZoom Ready"],["loadComplete",e,"[MathJax]/extensions/MathZoom.js"])})(MathJax.Hub,MathJax.HTML,MathJax.Ajax,MathJax.OutputJax["HTML-CSS"],MathJax.OutputJax.NativeMML);

(function(b,c,f){var k="1.1";MathJax.Extension.MathMenu={version:k};var i=b.Browser.isPC,g=b.Browser.isMSIE;var e=(i?null:"5px");var j=b.CombineConfig("MathMenu",{delay:150,helpURL:"http://www.mathjax.org/help/user/",showRenderer:true,showFontMenu:false,showContext:false,windowSettings:{status:"no",toolbar:"no",locationbar:"no",menubar:"no",directories:"no",personalbar:"no",resizable:"yes",scrollbars:"yes",width:100,height:50},styles:{"#MathJax_About":{position:"fixed",left:"50%",width:"auto","text-align":"center",border:"3px outset",padding:"1em 2em","background-color":"#DDDDDD",cursor:"default","font-family":"message-box","font-size":"120%","font-style":"normal","text-indent":0,"text-transform":"none","line-height":"normal","letter-spacing":"normal","word-spacing":"normal","word-wrap":"normal","white-space":"nowrap","float":"none","z-index":201,"border-radius":"15px","-webkit-border-radius":"15px","-moz-border-radius":"15px","-khtml-border-radius":"15px","box-shadow":"0px 10px 20px #808080","-webkit-box-shadow":"0px 10px 20px #808080","-moz-box-shadow":"0px 10px 20px #808080","-khtml-box-shadow":"0px 10px 20px #808080",filter:"progid:DXImageTransform.Microsoft.dropshadow(OffX=2, OffY=2, Color='gray', Positive='true')"},".MathJax_Menu":{position:"absolute","background-color":"white",color:"black",width:"auto",padding:(i?"2px":"5px 0px"),border:"1px solid #CCCCCC",margin:0,cursor:"default",font:"menu","text-align":"left","text-indent":0,"text-transform":"none","line-height":"normal","letter-spacing":"normal","word-spacing":"normal","word-wrap":"normal","white-space":"nowrap","float":"none","z-index":201,"border-radius":e,"-webkit-border-radius":e,"-moz-border-radius":e,"-khtml-border-radius":e,"box-shadow":"0px 10px 20px #808080","-webkit-box-shadow":"0px 10px 20px #808080","-moz-box-shadow":"0px 10px 20px #808080","-khtml-box-shadow":"0px 10px 20px #808080",filter:"progid:DXImageTransform.Microsoft.dropshadow(OffX=2, OffY=2, Color='gray', Positive='true')"},".MathJax_MenuItem":{padding:(i?"2px 2em":"1px 2em"),background:"transparent"},".MathJax_MenuTitle":{"background-color":"#CCCCCC",margin:(i?"-1px -1px 1px -1px":"-5px 0 0 0"),"text-align":"center","font-style":"italic","font-size":"80%",color:"#444444",padding:"2px 0",overflow:"hidden"},".MathJax_MenuArrow":{position:"absolute",right:".5em",color:"#666666","font-family":(g?"'Arial unicode MS'":null)},".MathJax_MenuActive .MathJax_MenuArrow":{color:"white"},".MathJax_MenuCheck":{position:"absolute",left:".7em","font-family":(g?"'Arial unicode MS'":null)},".MathJax_MenuRadioCheck":{position:"absolute",left:(i?"1em":".7em")},".MathJax_MenuLabel":{padding:(i?"2px 2em 4px 1.33em":"1px 2em 3px 1.33em"),"font-style":"italic"},".MathJax_MenuRule":{"border-top":(i?"1px solid #CCCCCC":"1px solid #DDDDDD"),margin:(i?"4px 1px 0px":"4px 3px")},".MathJax_MenuDisabled":{color:"GrayText"},".MathJax_MenuActive":{"background-color":(i?"Highlight":"#606872"),color:(i?"HighlightText":"white")}}});var d=function(l){if(!l){l=window.event}if(l){if(l.preventDefault){l.preventDefault()}if(l.stopPropagation){l.stopPropagation()}l.cancelBubble=true;l.returnValue=false}return false};var a=MathJax.Menu=MathJax.Object.Subclass({version:k,items:[],posted:false,title:null,margin:5,Init:function(l){this.items=[].slice.call(arguments,0)},With:function(l){if(l){b.Insert(this,l)}return this},Post:function(n,v){if(!n){n=window.event}var t=(!this.title?null:[["div",{className:"MathJax_MenuTitle"},[this.title]]]);var l=document.getElementById("MathJax_MenuFrame");if(!l){l=a.Background(this)}var o=c.addElement(l,"div",{onmouseup:a.Mouseup,ondblclick:this.False,ondragstart:this.False,onselectstart:this.False,oncontextmenu:this.False,menuItem:this,className:"MathJax_Menu"},t);for(var q=0,p=this.items.length;q<p;q++){this.items[q].Create(o)}this.posted=true;o.style.width=(o.offsetWidth+2)+"px";var u=n.pageX,s=n.pageY;if(!u&&!s){u=n.clientX+document.body.scrollLeft+document.documentElement.scrollLeft;s=n.clientY+document.body.scrollTop+document.documentElement.scrollTop}if(!v){if(u+o.offsetWidth>document.body.offsetWidth-this.margin){u=document.body.offsetWidth-o.offsetWidth-this.margin}a.skipUp=true}else{var r="left",w=v.offsetWidth;u=v.offsetWidth-2;s=0;while(v&&v!==l){u+=v.offsetLeft;s+=v.offsetTop;v=v.parentNode}if(u+o.offsetWidth>document.body.offsetWidth-this.margin){r="right";u=Math.max(this.margin,u-w-o.offsetWidth+6)}if(!i){o.style["borderRadiusTop"+r]=0;o.style["WebkitBorderRadiusTop"+r]=0;o.style["MozBorderRadiusTop"+r]=0;o.style["KhtmlBorderRadiusTop"+r]=0}}o.style.left=u+"px";o.style.top=s+"px";if(document.selection&&document.selection.empty){document.selection.empty()}return this.False(n)},Remove:function(l,m){var n=document.getElementById("MathJax_MenuFrame");if(n){n.parentNode.removeChild(n);if(this.msieBackgroundBug){detachEvent("onresize",a.Resize)}}},Mouseup:function(l,m){if(a.skipUp){delete a.skipUp}else{this.Remove(l,m)}},False:d},{config:j,div:null,Remove:function(l){a.Event(l,this,"Remove")},Mouseover:function(l){a.Event(l,this,"Mouseover")},Mouseout:function(l){a.Event(l,this,"Mouseout")},Mousedown:function(l){a.Event(l,this,"Mousedown")},Mouseup:function(l){a.Event(l,this,"Mouseup")},Mousemove:function(l){a.Event(l,this,"Mousemove")},Event:function(n,o,l){if(!n){n=window.event}var m=o.menuItem;if(m&&m[l]){return m[l](n,o)}return null},BGSTYLE:{position:"absolute",left:0,top:0,"z-index":200,width:"100%",height:"100%",border:0,padding:0,margin:0},Background:function(m){var n=c.addElement(document.body,"div",{style:this.BGSTYLE,id:"MathJax_MenuFrame"},[["div",{style:this.BGSTYLE,menuItem:m,onmousedown:this.Remove}]]);var l=n.firstChild;if(m.msieBackgroundBug){l.style.backgroundColor="white";l.style.filter="alpha(opacity=0)";n.width=n.height=0;this.Resize();attachEvent("onresize",this.Resize)}else{l.style.position="fixed"}return n},Resize:function(){setTimeout(a.SetWH,0)},SetWH:function(){var l=document.getElementById("MathJax_MenuFrame");if(l){l=l.firstChild;l.style.width=l.style.height="1px";l.style.width=document.body.scrollWidth+"px";l.style.height=document.body.scrollHeight+"px"}},saveCookie:function(){c.Cookie.Set("menu",this.cookie)},getCookie:function(){this.cookie=c.Cookie.Get("menu")}});var h=a.ITEM=MathJax.Object.Subclass({name:"",Create:function(m){if(!this.hidden){var l={onmouseover:a.Mouseover,onmouseout:a.Mouseout,onmouseup:a.Mouseup,onmousedown:this.False,ondragstart:this.False,onselectstart:this.False,onselectend:this.False,className:"MathJax_MenuItem",menuItem:this};if(this.disabled){l.className+=" MathJax_MenuDisabled"}c.addElement(m,"div",l,this.Label(l,m))}},Mouseover:function(q,s){if(!this.disabled){this.Activate(s)}if(!this.menu||!this.menu.posted){var r=document.getElementById("MathJax_MenuFrame").childNodes,n=s.parentNode.childNodes;for(var o=0,l=n.length;o<l;o++){var p=n[o].menuItem;if(p&&p.menu&&p.menu.posted){p.Deactivate(n[o])}}l=r.length-1;while(l>=0&&s.parentNode.menuItem!==r[l].menuItem){r[l].menuItem.posted=false;r[l].parentNode.removeChild(r[l]);l--}if(this.Timer){this.Timer(q,s)}}},Mouseout:function(l,m){if(!this.menu||!this.menu.posted){this.Deactivate(m)}if(this.timer){clearTimeout(this.timer);delete this.timer}},Mouseup:function(l,m){return this.Remove(l,m)},Remove:function(l,m){m=m.parentNode.menuItem;return m.Remove(l,m)},Activate:function(l){this.Deactivate(l);l.className+=" MathJax_MenuActive"},Deactivate:function(l){l.className=l.className.replace(/ MathJax_MenuActive/,"")},With:function(l){if(l){b.Insert(this,l)}return this},False:d});a.ITEM.COMMAND=a.ITEM.Subclass({action:function(){},Init:function(l,n,m){this.name=l;this.action=n;this.With(m)},Label:function(l,m){return[this.name]},Mouseup:function(l,m){if(!this.disabled){this.Remove(l,m);this.action.call(this,l)}return this.False(l)}});a.ITEM.SUBMENU=a.ITEM.Subclass({menu:null,marker:(i&&!b.Browser.isSafari?"\u25B6":"\u25B8"),Init:function(l,n){this.name=l;var m=1;if(!(n instanceof a.ITEM)){this.With(n),m++}this.menu=a.apply(a,[].slice.call(arguments,m))},Label:function(l,m){l.onmousemove=a.Mousemove;this.menu.posted=false;return[this.name+" ",["span",{className:"MathJax_MenuArrow"},[this.marker]]]},Timer:function(l,m){if(this.timer){clearTimeout(this.timer)}l={clientX:l.clientX,clientY:l.clientY};this.timer=setTimeout(MathJax.Callback(["Mouseup",this,l,m]),j.delay)},Mouseup:function(n,p){if(!this.disabled){if(!this.menu.posted){if(this.timer){clearTimeout(this.timer);delete this.timer}this.menu.Post(n,p)}else{var o=document.getElementById("MathJax_MenuFrame").childNodes,l=o.length-1;while(l>=0){var q=o[l];q.menuItem.posted=false;q.parentNode.removeChild(q);if(q.menuItem===this.menu){break}l--}}}return this.False(n)}});a.ITEM.RADIO=a.ITEM.Subclass({variable:null,marker:(i?"\u25CF":"\u2713"),Init:function(m,l,n){this.name=m;this.variable=l;this.With(n);if(this.value==null){this.value=this.name}},Label:function(m,n){var l={className:"MathJax_MenuRadioCheck"};if(j.settings[this.variable]!==this.value){l={style:{display:"none"}}}return[["span",l,[this.marker]]," "+this.name]},Mouseup:function(p,q){if(!this.disabled){var r=q.parentNode.childNodes;for(var n=0,l=r.length;n<l;n++){var o=r[n].menuItem;if(o&&o.variable===this.variable){r[n].firstChild.style.display="none"}}q.firstChild.display="";j.settings[this.variable]=this.value;a.cookie[this.variable]=j.settings[this.variable];a.saveCookie();if(this.action){this.action.call(a)}}this.Remove(p,q);return this.False(p)}});a.ITEM.CHECKBOX=a.ITEM.Subclass({variable:null,marker:"\u2713",Init:function(m,l,n){this.name=m;this.variable=l;this.With(n)},Label:function(m,n){var l={className:"MathJax_MenuCheck"};if(!j.settings[this.variable]){l={style:{display:"none"}}}return[["span",l,[this.marker]]," "+this.name]},Mouseup:function(l,m){if(!this.disabled){m.firstChild.display=(j.settings[this.variable]?"none":"");j.settings[this.variable]=!j.settings[this.variable];a.cookie[this.variable]=j.settings[this.variable];a.saveCookie();if(this.action){this.action.call(a)}}this.Remove(l,m);return this.False(l)}});a.ITEM.LABEL=a.ITEM.Subclass({Init:function(l,m){this.name=l;this.With(m)},Label:function(l,m){delete l.onmouseover,delete l.onmouseout;delete l.onmousedown;l.className+=" MathJax_MenuLabel";return[this.name]}});a.ITEM.RULE=a.ITEM.Subclass({Label:function(l,m){delete l.onmouseover,delete l.onmouseout;delete l.onmousedown;l.className+=" MathJax_MenuRule";return null}});a.About=function(){var o=MathJax.OutputJax["HTML-CSS"]||{fontInUse:""};var q=(o.webFonts?"":"local "),m=(o.webFonts?" web":"");var n=(o.imgFonts?"Image":q+o.fontInUse+m)+" fonts";var l=[];a.About.GetJax(l,MathJax.InputJax,"Input Jax");a.About.GetJax(l,MathJax.OutputJax,"Output Jax");a.About.GetJax(l,MathJax.ElementJax,"Element Jax");l.push(["div",{style:{"border-top":"groove 2px",margin:".25em 0"}}]);a.About.GetJax(l,MathJax.Extension,"Extension",true);l.push(["div",{style:{"border-top":"groove 2px",margin:".25em 0"}}],["center",{},[b.Browser+" v"+b.Browser.version+(o.webFonts?" \u2014 "+o.allowWebFonts+" fonts":"")]]);a.About.div=a.Background(a.About);var r=MathJax.HTML.addElement(a.About.div,"div",{id:"MathJax_About",onclick:a.About.Remove},[["b",{style:{fontSize:"120%"}},["MathJax"]]," v"+MathJax.version,["br"],"using "+n,["br"],["br"],["span",{style:{display:"inline-block","text-align":"left","font-size":"80%","background-color":"#E4E4E4",padding:".4em .6em",border:"1px inset"}},l],["br"],["br"],["a",{href:"http://www.mathjax.org/"},["wwww.mathjax.org"]]]);var s=(document.documentElement||{});var p=window.innerHeight||s.clientHeight||s.scrollHeight||0;if(a.prototype.msieAboutBug){r.style.width="20em";r.style.position="absolute";r.style.left=Math.floor((document.documentElement.scrollWidth-r.offsetWidth)/2)+"px";r.style.top=(Math.floor((p-r.offsetHeight)/3)+document.body.scrollTop)+"px"}else{r.style.marginLeft=Math.floor(-r.offsetWidth/2)+"px";r.style.top=Math.floor((p-r.offsetHeight)/3)+"px"}};a.About.Remove=function(l){if(a.About.div){document.body.removeChild(a.About.div);delete a.About.div}};a.About.GetJax=function(l,o,n,m){for(var p in o){if(o.hasOwnProperty(p)&&o[p]){if((m&&o[p].version)||(o[p].isa&&o[p].isa(o))){l.push((o[p].id||p)+" "+n+" v"+o[p].version,["br"])}}}return l};a.Help=function(){window.open(j.helpURL,"MathJaxHelp")};a.ShowSource=function(n){if(!n){n=window.event}if(!a.jax){return}if(j.settings.format==="MathML"){var l=MathJax.ElementJax.mml;if(l&&typeof(l.mbase.prototype.toMathML)!=="undefined"){a.ShowSource.Text(a.jax.root.toMathML(),n)}else{if(!f.loadingToMathML){f.loadingToMathML=true;var m={screenX:n.screenX,screenY:n.screenY};a.ShowSource.Window(n);MathJax.Callback.Queue(f.Require("[MathJax]/extensions/toMathML.js"),function(){delete f.loadingToMathML},[this,arguments.callee,m]);return}}}else{if(a.jax.originalText==null){alert("No TeX form available");return}a.ShowSource.Text(a.jax.originalText,n)}};a.ShowSource.Window=function(m){if(!a.ShowSource.w){var n=[],l=j.windowSettings;for(var o in l){if(l.hasOwnProperty(o)){n.push(o+"="+l[o])}}a.ShowSource.w=window.open("","_blank",n.join(","))}return a.ShowSource.w};a.ShowSource.Text=function(r,q){var n=a.ShowSource.Window(q);r=r.replace(/^\s*/,"").replace(/\s*$/,"");r=r.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;");n.document.open();n.document.write("<html><head><title>MathJax Equation Source</title></head><body style='font-size:85%'>");n.document.write("<table><tr><td><pre>"+r+"</pre></td></tr></table>");n.document.write("</body></html>");n.document.close();var p=n.document.body.firstChild;var o=(n.outerHeight-n.innerHeight)||30,m=(n.outerWidth-n.innerWidth)||30;m=Math.min(Math.floor(0.5*screen.width),p.offsetWidth+m+25);o=Math.min(Math.floor(0.5*screen.height),p.offsetHeight+o+25);n.resizeTo(m,o);if(q&&q.screenX!=null){var l=Math.max(0,Math.min(q.screenX-Math.floor(m/2),screen.width-m-20)),s=Math.max(0,Math.min(q.screenY-Math.floor(o/2),screen.height-o-20));n.moveTo(l,s)}delete a.ShowSource.w};a.Scale=function(){var m=MathJax.OutputJax["HTML-CSS"],l=MathJax.OutputJax.NativeMML;var o=(m?m.config.scale:l.config.scale);var n=prompt("Scale all mathematics (compared to surrounding text) by",o+"%");if(n){if(n.match(/^\s*\d+\s*%?\s*$/)){n=parseInt(n);if(n){if(n!==o){if(m){m.config.scale=n}if(l){l.config.scale=n}a.cookie.scale=n;a.saveCookie();b.Reprocess()}}else{alert("The scale should not be zero")}}else{alert("The scale should be a perentage (e.g., 120%)")}}};a.Zoom=function(){if(!MathJax.Extension.MathZoom){f.Require("[MathJax]/extensions/MathZoom.js")}};a.Renderer=function(){var l=b.config.outputJax["jax/mml"];if(l[0]!==j.settings.renderer){MathJax.Callback.Queue(["Require",f,"[MathJax]/jax/output/"+j.settings.renderer+"/config.js"],[function(){var p=MathJax.OutputJax[j.settings.renderer];for(var o=0,n=l.length;o<n;o++){if(l[o]===p){l.splice(o,1);break}}l.unshift(p)}],["Reprocess",b])}};a.Font=function(){var l=MathJax.OutputJax["HTML-CSS"];if(!l){return}document.location.reload()};b.Browser.Select({MSIE:function(l){var m=(document.compatMode==="BackCompat");var n=l.versionAtLeast("8.0")&&document.documentMode>7;a.Augment({margin:20,msieBackgroundBug:(m||!n),msieAboutBug:m});if(document.documentMode>=9){delete j.styles["#MathJax_About"].filter;delete j.styles[".MathJax_Menu"].filter}}});b.Register.StartupHook("End Config",function(){j.settings=b.config.menuSettings;if(!j.settings.format){j.settings.format=(MathJax.InputJax.TeX?"Original":"MathML")}if(typeof(j.settings.showRenderer)!=="undefined"){j.showRenderer=j.settings.showRenderer}if(typeof(j.settings.showFontMenu)!=="undefined"){j.showFontMenu=j.settings.showFontMenu}if(typeof(j.settings.showContext)!=="undefined"){j.showContext=j.settings.showContext}a.getCookie();a.menu=a(h.COMMAND("Show Source",a.ShowSource),h.SUBMENU("Format",h.RADIO("MathML","format"),h.RADIO("Original","format",{value:"Original"})),h.RULE(),h.SUBMENU("Settings",h.SUBMENU("Zoom Trigger",h.RADIO("Hover","zoom",{action:a.Zoom}),h.RADIO("Click","zoom",{action:a.Zoom}),h.RADIO("Double-Click","zoom",{action:a.Zoom}),h.RADIO("No Zoom","zoom",{value:"None"}),h.RULE(),h.LABEL("Trigger Requires:"),h.CHECKBOX((b.Browser.isMac?"Option":"Alt"),"ALT"),h.CHECKBOX("Command","CMD",{hidden:!b.Browser.isMac}),h.CHECKBOX("Control","CTRL",{hidden:b.Browser.isMac}),h.CHECKBOX("Shift","Shift")),h.SUBMENU("Zoom Factor",h.RADIO("125%","zscale"),h.RADIO("133%","zscale"),h.RADIO("150%","zscale"),h.RADIO("175%","zscale"),h.RADIO("200%","zscale"),h.RADIO("250%","zscale"),h.RADIO("300%","zscale"),h.RADIO("400%","zscale")),h.RULE(),h.SUBMENU("Math Renderer",{hidden:!j.showRenderer},h.RADIO("HTML-CSS","renderer",{action:a.Renderer}),h.RADIO("MathML","renderer",{action:a.Renderer,value:"NativeMML"})),h.SUBMENU("Font Preference",{hidden:!j.showFontMenu},h.LABEL("For HTML-CSS:"),h.RADIO("Auto","font",{action:a.Font}),h.RULE(),h.RADIO("TeX (local)","font",{action:a.Font}),h.RADIO("TeX (web)","font",{action:a.Font}),h.RADIO("TeX (image)","font",{action:a.Font}),h.RULE(),h.RADIO("STIX (local)","font",{action:a.Font})),h.SUBMENU("Contextual Menu",{hidden:!j.showContext},h.RADIO("MathJax","context"),h.RADIO("Browser","context")),h.COMMAND("Scale All Math ...",a.Scale)),h.RULE(),h.COMMAND("About MathJax",a.About),h.COMMAND("MathJax Help",a.Help))});a.showRenderer=function(l){a.cookie.showRenderer=j.showRenderer=l;a.saveCookie();a.menu.items[3].menu.item[3].hidden=!l};a.showFontMenu=function(l){a.cookie.showFontMenu=j.showFontMenu=l;a.saveCookie();a.menu.items[3].menu.items[4].hidden=!l};a.showContext=function(l){a.cookie.showContext=j.showContext=l;a.saveCookie();a.menu.items[3].menu.items[5].hidden=!l};MathJax.Callback.Queue(["Styles",f,j.styles],["Post",b.Startup.signal,"MathMenu Ready"],["loadComplete",f,"[MathJax]/extensions/MathMenu.js"])})(MathJax.Hub,MathJax.HTML,MathJax.Ajax);

MathJax.ElementJax.mml=MathJax.ElementJax({mimeType:"jax/mml"},{id:"mml",version:"1.1",directory:MathJax.ElementJax.directory+"/mml",extensionDir:MathJax.ElementJax.extensionDir+"/mml",optableDir:MathJax.ElementJax.directory+"/mml/optable"});MathJax.ElementJax.mml.Augment({Init:function(){if(arguments.length===1&&arguments[0].type==="math"){this.root=arguments[0]}else{this.root=MathJax.ElementJax.mml.math.apply(this,arguments)}if(this.root.mode){if(!this.root.display&&this.root.mode==="display"){this.root.display="block"}delete this.root.mode}}},{INHERIT:"_inherit_",AUTO:"_auto_",SIZE:{INFINITY:"infinity",SMALL:"small",NORMAL:"normal",BIG:"big"},COLOR:{TRANSPARENT:"transparent"},VARIANT:{NORMAL:"normal",BOLD:"bold",ITALIC:"italic",BOLDITALIC:"bold-italic",DOUBLESTRUCK:"double-struck",FRAKTUR:"fraktur",BOLDFRAKTUR:"bold-fraktur",SCRIPT:"script",BOLDSCRIPT:"bold-script",SANSSERIF:"sans-serif",BOLDSANSSERIF:"bold-sans-serif",SANSSERIFITALIC:"sans-serif-italic",SANSSERIFBOLDITALIC:"sans-serif-bold-italic",MONOSPACE:"monospace",INITIAL:"inital",TAILED:"tailed",LOOPED:"looped",STRETCHED:"stretched",CALIGRAPHIC:"-tex-caligraphic",OLDSTYLE:"-tex-oldstyle"},FORM:{PREFIX:"prefix",INFIX:"infix",POSTFIX:"postfix"},LINEBREAK:{AUTO:"auto",NEWLINE:"newline",NOBREAK:"nobreak",GOODBREAK:"goodbreak",BADBREAK:"badbreak"},LINEBREAKSTYLE:{BEFORE:"before",AFTER:"after",DUPLICATE:"duplicate",INFIXLINBREAKSTYLE:"infixlinebreakstyle"},INDENTALIGN:{LEFT:"left",CENTER:"center",RIGHT:"right",AUTO:"auto",ID:"id",INDENTALIGN:"indentalign"},INDENTSHIFT:{INDENTSHIFT:"indentshift"},LINETHICKNESS:{THIN:"thin",MEDIUM:"medium",THICK:"thick"},NOTATION:{LONGDIV:"longdiv",ACTUARIAL:"actuarial",RADICAL:"radical",BOX:"box",ROUNDEDBOX:"roundedbox",CIRCLE:"circle",LEFT:"left",RIGHT:"right",TOP:"top",BOTTOM:"bottom",UPDIAGONALSTRIKE:"updiagonalstrike",DOWNDIAGONALSTRIKE:"downdiagonalstrike",VERTICALSTRIKE:"verticalstrike",HORIZONTALSTRIKE:"horizontalstrike",MADRUWB:"madruwb"},ALIGN:{TOP:"top",BOTTOM:"bottom",CENTER:"center",BASELINE:"baseline",AXIS:"axis",LEFT:"left",RIGHT:"right"},LINES:{NONE:"none",SOLID:"solid",DASHED:"dashed"},SIDE:{LEFT:"left",RIGHT:"right",LEFTOVERLAP:"leftoverlap",RIGHTOVERLAP:"rightoverlap"},WIDTH:{AUTO:"auto",FIT:"fit"},ACTIONTYPE:{TOGGLE:"toggle",STATUSLINE:"statusline",TOOLTIP:"tooltip",INPUT:"input"},LENGTH:{VERYVERYTHINMATHSPACE:"veryverythinmathspace",VERYTHINMATHSPACE:"verythinmathspace",THINMATHSPACE:"thinmathspace",MEDIUMMATHSPACE:"mediummathspace",THICKMATHSPACE:"thickmathspace",VERYTHICKMATHSPACE:"verythickmathspace",VERYVERYTHICKMATHSPACE:"veryverythickmathspace",NEGATIVEVERYVERYTHINMATHSPACE:"negativeveryverythinmathspace",NEGATIVEVERYTHINMATHSPACE:"negativeverythinmathspace",NEGATIVETHINMATHSPACE:"negativethinmathspace",NEGATIVEMEDIUMMATHSPACE:"negativemediummathspace",NEGATIVETHICKMATHSPACE:"negativethickmathspace",NEGATIVEVERYTHICKMATHSPACE:"negativeverythickmathspace",NEGATIVEVERYVERYTHICKMATHSPACE:"negativeveryverythickmathspace"},OVERFLOW:{LINBREAK:"linebreak",SCROLL:"scroll",ELIDE:"elide",TRUNCATE:"truncate",SCALE:"scale"},UNIT:{EM:"em",EX:"ex",PX:"px",IN:"in",CM:"cm",MM:"mm",PT:"pt",PC:"pc"},TEXCLASS:{ORD:0,OP:1,BIN:2,REL:3,OPEN:4,CLOSE:5,PUNCT:6,INNER:7,VCENTER:8,NONE:-1},PLANE1:String.fromCharCode(55349)});(function(a){var d=false;var b=true;a.mbase=MathJax.Object.Subclass({type:"base",isToken:d,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT},noInherit:{},Init:function(){this.data=[];if(this.inferRow&&!(arguments.length===1&&arguments[0].inferred)){this.Append(a.mrow().With({inferred:b}))}this.Append.apply(this,arguments)},With:function(f){for(var g in f){if(f.hasOwnProperty(g)){this[g]=f[g]}}return this},Append:function(){if(this.inferRow&&this.data.length){this.data[0].Append.apply(this.data[0],arguments)}else{for(var g=0,f=arguments.length;g<f;g++){this.SetData(this.data.length,arguments[g])}}},SetData:function(f,g){if(g!=null){if(!(g instanceof a.mbase)){g=(this.isToken?a.chars(g):a.mtext(g))}g.parent=this;g.setInherit(this.inheritFromMe?this:this.inherit)}this.data[f]=g},Parent:function(){var f=this.parent;while(f&&f.inferred){f=f.parent}return f},Get:function(g,k){if(typeof(this[g])!=="undefined"){return this[g]}var h=this.Parent();if(h&&h["adjustChild_"+g]!=null){return(h["adjustChild_"+g])(h.childPosition(this))}var j=this.inherit;var f=j;while(j){if(typeof(j[g])!=="undefined"){var i=j.noInherit[this.type];if(!(i&&i[g])){return j[g]}}f=j;j=j.inherit}if(!k){if(this.defaults[g]===a.AUTO){return this.autoDefault(g)}if(this.defaults[g]!==a.INHERIT&&this.defaults[g]!=null){return this.defaults[g]}if(f){return f.defaults[g]}}return null},hasValue:function(f){return(this.Get(f,true)!=null)},getValues:function(){var g={};for(var h=0,f=arguments.length;h<f;h++){g[arguments[h]]=this.Get(arguments[h])}return g},adjustChild_scriptlevel:function(f){return this.Get("scriptlevel")},adjustChild_displaystyle:function(f){return this.Get("displaystyle")},adjustChild_texprimestyle:function(f){return this.Get("texprimestyle")},childPosition:function(h){if(h.parent.inferred){h=h.parent}for(var g=0,f=this.data.length;g<f;g++){if(this.data[g]===h){return g}}return null},setInherit:function(h){if(h!==this.inherit&&this.inherit==null){this.inherit=h;for(var g=0,f=this.data.length;g<f;g++){if(this.data[g]&&this.data[g].setInherit){this.data[g].setInherit(h)}}}},setTeXclass:function(f){this.getPrevClass(f);return(typeof(this.texClass)!=="undefined"?this:f)},getPrevClass:function(f){if(f){this.prevClass=f.Get("texClass");this.prevLevel=f.Get("scriptlevel")}},updateTeXclass:function(f){if(f){this.prevClass=f.prevClass;delete f.prevClass;this.prevLevel=f.prevLevel;delete f.prevLevel;this.texClass=f.Get("texClass")}},texSpacing:function(){var g=(this.prevClass!=null?this.prevClass:a.TEXCLASS.NONE);var f=(this.Get("texClass")||a.TEXCLASS.ORD);if(g===a.TEXCLASS.NONE||f===a.TEXCLASS.NONE){return""}if(g===a.TEXCLASS.VCENTER){g=a.TEXCLASS.ORD}if(f===a.TEXCLASS.VCENTER){f=a.TEXCLASS.ORD}var h=this.TEXSPACE[g][f];if(this.prevLevel>0&&this.Get("scriptlevel")>0&&h>=0){return""}return this.TEXSPACELENGTH[Math.abs(h)]},TEXSPACELENGTH:["",a.LENGTH.THINMATHSPACE,a.LENGTH.MEDIUMMATHSPACE,a.LENGTH.THICKMATHSPACE],TEXSPACE:[[0,-1,2,3,0,0,0,1],[-1,-1,0,3,0,0,0,1],[2,2,0,0,2,0,0,2],[3,3,0,0,3,0,0,3],[0,0,0,0,0,0,0,0],[0,-1,2,3,0,0,0,1],[1,1,0,1,1,1,1,1],[1,-1,2,3,1,0,1,1]],autoDefault:function(f){return""},isSpacelike:function(){return d},isEmbellished:function(){return d},Core:function(){return this},CoreMO:function(){return this},lineBreak:function(){if(this.isEmbellished()){return this.CoreMO().lineBreak()}else{return"none"}},array:function(){if(this.inferred){return this.data}else{return[this]}},toString:function(){return this.type+"("+this.data.join(",")+")"}},{childrenSpacelike:function(){for(var f=0;f<this.data.length;f++){if(!this.data[f].isSpacelike()){return d}}return b},childEmbellished:function(){return(this.data[0]&&this.data[0].isEmbellished())},childCore:function(){return this.data[0]},childCoreMO:function(){return(this.data[0]?this.data[0].CoreMO():null)},setChildTeXclass:function(f){if(this.data[0]){f=this.data[0].setTeXclass(f);this.updateTeXclass(this.data[0])}return f},setBaseTeXclasses:function(h){this.getPrevClass(h);this.texClass=null;if(this.isEmbellished()){h=this.data[0].setTeXclass(h);this.updateTeXclass(this.Core())}else{if(this.data[0]){this.data[0].setTeXclass()}h=this}for(var g=1,f=this.data.length;g<f;g++){if(this.data[g]){this.data[g].setTeXclass()}}return h},setSeparateTeXclasses:function(h){this.getPrevClass(h);for(var g=0,f=this.data.length;g<f;g++){if(this.data[g]){this.data[g].setTeXclass()}}if(this.isEmbellished()){this.updateTeXclass(this.Core())}return this}});a.mi=a.mbase.Subclass({type:"mi",isToken:b,texClass:a.TEXCLASS.ORD,defaults:{mathvariant:a.AUTO,mathsize:a.INHERIT,mathbackground:a.INHERIT,mathcolor:a.INHERIT},autoDefault:function(g){if(g==="mathvariant"){var f=(this.data[0]||"").toString();return(f.length===1||(f.length===2&&f.charCodeAt(0)===this.PLANE1)?a.VARIANT.ITALIC:a.VARIANT.NORMAL)}return""}});a.mn=a.mbase.Subclass({type:"mn",isToken:b,texClass:a.TEXCLASS.ORD,defaults:{mathvariant:a.INHERIT,mathsize:a.INHERIT,mathbackground:a.INHERIT,mathcolor:a.INHERIT}});a.mo=a.mbase.Subclass({type:"mo",isToken:b,defaults:{mathvariant:a.INHERIT,mathsize:a.INHERIT,mathbackground:a.INHERIT,mathcolor:a.INHERIT,form:a.AUTO,fence:a.AUTO,separator:a.AUTO,lspace:a.AUTO,rspace:a.AUTO,stretchy:a.AUTO,symmetric:a.AUTO,maxsize:a.AUTO,minsize:a.AUTO,largeop:a.AUTO,movablelimits:a.AUTO,accent:a.AUTO,linebreak:a.LINEBREAK.AUTO,lineleading:a.INHERIT,linebreakstyle:a.AUTO,linebreakmultchar:a.INHERIT,indentalign:a.INHERIT,indentshift:a.INHERIT,indenttarget:a.INHERIT,indentalignfirst:a.INHERIT,indentshiftfirst:a.INHERIT,indentalignlast:a.INHERIT,indentshiftlast:a.INHERIT,texClass:a.AUTO},defaultDef:{form:a.FORM.INFIX,fence:d,separator:d,lspace:a.LENGTH.THICKMATHSPACE,rspace:a.LENGTH.THICKMATHSPACE,stretchy:d,symmetric:b,maxsize:a.SIZE.INFINITY,minsize:"0em",largeop:d,movablelimits:d,accent:d,linebreak:a.LINEBREAK.AUTO,lineleading:"1ex",linebreakstyle:"before",indentalign:a.INDENTALIGN.AUTO,indentshift:"0",indenttarget:"",indentalignfirst:a.INDENTALIGN.INDENTALIGN,indentshiftfirst:a.INDENTSHIFT.INDENTSHIFT,indentalignlast:a.INDENTALIGN.INDENTALIGN,indentshiftlast:a.INDENTSHIFT.INDENTSHIFT,texClass:a.TEXCLASS.REL},SPACE_ATTR:{lspace:1,rspace:2,form:4},useMMLspacing:7,autoDefault:function(h,o){var n=this.def;if(!n){if(h==="form"){this.useMMLspacing&=~this.SPACE_ATTR.form;return this.getForm()}var l=this.data.join("");var g=[this.Get("form"),a.FORM.INFIX,a.FORM.POSTFIX,a.FORM.PREFIX];for(var j=0,f=g.length;j<f;j++){var k=this.OPTABLE[g[j]][l];if(k){n=this.makeDef(k);break}}if(!n){n=this.CheckRange(l)}if(!n&&o){n={}}else{if(!n){n=MathJax.Hub.Insert({},this.defaultDef)}n.form=g[0];this.def=n}}this.useMMLspacing&=~(this.SPACE_ATTR[h]||0);if(n[h]!=null){return n[h]}else{if(!o){return this.defaultDef[h]}}return""},CheckRange:function(k){var l=k.charCodeAt(0);if(k.charAt(0)===a.PLANE1){l=k.charCodeAt(1)+119808-56320}for(var h=0,f=this.RANGES.length;h<f&&this.RANGES[h][0]<=l;h++){if(l<=this.RANGES[h][1]){if(this.RANGES[h][3]){var g=a.optableDir+"/"+this.RANGES[h][3]+".js";this.RANGES[h][3]=null;MathJax.Hub.RestartAfter(MathJax.Ajax.Require(g))}var j=(["ORD","OP","BIN","REL","OPEN","CLOSE","PUNCT","INNER"])[this.RANGES[h][2]];j=this.OPTABLE.infix[k]=a.mo.OPTYPES[j==="BIN"?"BIN3":j];return this.makeDef(j)}}return null},makeDef:function(g){if(g[2]==null){g[2]=this.defaultDef.texClass}if(!g[3]){g[3]={}}var f=MathJax.Hub.Insert({},g[3]);f.lspace=this.SPACE[g[0]];f.rspace=this.SPACE[g[1]];f.texClass=g[2];return f},getForm:function(){var f=this,h=this.parent,g=this.Parent();while(g&&g.isEmbellished()){f=h;h=g.parent;g=g.Parent()}if(h&&h.type==="mrow"&&h.NonSpaceLength()!==1){if(h.FirstNonSpace()===f){return a.FORM.PREFIX}if(h.LastNonSpace()===f){return a.FORM.POSTFIX}}return a.FORM.INFIX},isEmbellished:function(){return b},lineBreak:function(){var f=this.getValues("linebreak","linebreakstyle");if(f.linebreak===a.LINEBREAK.NEWLINE){if(f.linebreakstyle===a.LINEBREAKSTYLE.INFIXLINEBREAKSTYLE){f.linebreakstyle=this.Get("infixlinebreakstyle")}return f.linebreakstyle}return"none"},setTeXclass:function(f){this.getValues("lspace","rspace");if(this.useMMLspacing){this.texClass=a.TEXCLASS.NONE;return this}this.texClass=this.Get("texClass");if(f){this.prevClass=f.texClass||a.TEXCLASS.ORD;this.prevLevel=f.Get("scriptlevel")}else{this.prevClass=a.TEXCLASS.NONE}if(this.texClass===a.TEXCLASS.BIN&&(this.prevClass===a.TEXCLASS.NONE||this.prevClass===a.TEXCLASS.BIN||this.prevClass===a.TEXCLASS.OP||this.prevClass===a.TEXCLASS.REL||this.prevClass===a.TEXCLASS.OPEN||this.prevClass===a.TEXCLASS.PUNCT)){this.texClass=a.TEXCLASS.ORD}else{if(this.prevClass===a.TEXCLASS.BIN&&(this.texClass===a.TEXCLASS.REL||this.texClass===a.TEXCLASS.CLOSE||this.texClass===a.TEXCLASS.PUNCT)){f.texClass=this.prevClass=a.TEXCLASS.ORD}}return this}});a.mtext=a.mbase.Subclass({type:"mtext",isToken:b,isSpacelike:function(){return b},texClass:a.TEXCLASS.ORD,defaults:{mathvariant:a.INHERIT,mathsize:a.INHERIT,mathbackground:a.INHERIT,mathcolor:a.INHERIT}});a.mspace=a.mbase.Subclass({type:"mspace",isToken:b,isSpacelike:function(){return b},defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,width:"0em",height:"0ex",depth:"0ex",linebreak:a.LINEBREAK.AUTO},lineBreak:function(){return(this.Get("linebreak")===a.LINEBREAK.NEWLINE?a.LINEBREAKSTYLE.AFTER:"none")}});a.ms=a.mbase.Subclass({type:"ms",isToken:b,texClass:a.TEXCLASS.ORD,defaults:{mathvariant:a.INHERIT,mathsize:a.INHERIT,mathbackground:a.INHERIT,mathcolor:a.INHERIT,lquote:'"',rquote:'"'}});a.mglyph=a.mbase.Subclass({type:"mglyph",isToken:b,texClass:a.TEXCLASS.ORD,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,alt:"",src:"",width:a.AUTO,height:a.AUTO,valign:"0em"}});a.mrow=a.mbase.Subclass({type:"mrow",isSpacelike:a.mbase.childrenSpacelike,inferred:d,isEmbellished:function(){var g=d;for(var h=0,f=this.data.length;h<f;h++){if(this.data[h]==null){continue}if(this.data[h].isEmbellished()){if(g){return d}g=b;this.core=h}else{if(!this.data[h].isSpacelike()){return d}}}return g},NonSpaceLength:function(){var h=0;for(var g=0,f=this.data.length;g<f;g++){if(this.data[g]&&!this.data[g].isSpacelike()){h++}}return h},FirstNonSpace:function(){for(var g=0,f=this.data.length;g<f;g++){if(this.data[g]&&!this.data[g].isSpacelike()){return this.data[g]}}return null},LastNonSpace:function(){for(var f=this.data.length-1;f>=0;f--){if(this.data[0]&&!this.data[f].isSpacelike()){return this.data[f]}}return null},Core:function(){if(!(this.isEmbellished())||typeof(this.core)==="undefined"){return this}return this.data[this.core]},CoreMO:function(){if(!(this.isEmbellished())||typeof(this.core)==="undefined"){return this}return this.data[this.core].CoreMO()},toString:function(){if(this.inferred){return"["+this.data.join(",")+"]"}return this.SUPER(arguments).toString.call(this)},setTeXclass:function(h){for(var g=0,f=this.data.length;g<f;g++){if(this.data[g]){h=this.data[g].setTeXclass(h)}}if(this.data[0]){this.updateTeXclass(this.data[0])}return h}});a.mfrac=a.mbase.Subclass({type:"mfrac",num:0,den:1,texClass:a.TEXCLASS.INNER,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,linethickness:a.LINETHICKNESS.MEDIUM,numalign:a.ALIGN.CENTER,denomalign:a.ALIGN.CENTER,bevelled:d},adjustChild_displaystyle:function(f){return d},adjustChild_scriptlevel:function(g){var f=this.Get("scriptlevel");if(!this.Get("displaystyle")||f>0){f++}return f},adjustChild_texprimestyle:function(f){if(f==this.den){return true}return this.Get("texprimestyle")},setTeXclass:a.mbase.setSeparateTeXclasses});a.msqrt=a.mbase.Subclass({type:"msqrt",inferRow:b,texClass:a.TEXCLASS.ORD,setTeXclass:a.mbase.setSeparateTeXclasses,adjustChild_texprimestyle:function(f){return b}});a.mroot=a.mbase.Subclass({type:"mroot",texClass:a.TEXCLASS.ORD,adjustChild_displaystyle:function(f){if(f===1){return d}return this.Get("displaystyle")},adjustChild_scriptlevel:function(g){var f=this.Get("scriptlevel");if(g===1){f+=2}return f},adjustChild_texprimestyle:function(f){if(f===0){return b}return this.Get("texprimestyle")},setTeXclass:a.mbase.setSeparateTeXclasses});a.mstyle=a.mbase.Subclass({type:"mstyle",isSpacelike:a.mbase.childrenSpacelike,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,inferRow:b,defaults:{scriptlevel:a.INHERIT,displaystyle:a.INHERIT,scriptsizemultiplier:Math.sqrt(1/2),scriptminsize:"8pt",mathbackground:a.INHERIT,mathcolor:a.INHERIT,infixlinebreakstyle:a.LINEBREAKSTYLE.BEFORE,decimalseparator:"."},adjustChild_scriptlevel:function(h){var g=this.scriptlevel;if(g==null){g=this.Get("scriptlevel")}else{if(String(g).match(/^ *[-+]/)){delete this.scriptlevel;var f=this.Get("scriptlevel");this.scriptlevel=g;g=f+parseInt(g)}}return g},inheritFromMe:b,noInherit:{mpadded:{width:b,height:b,depth:b,lspace:b,voffset:b},mtable:{width:b,height:b,depth:b,align:b}},setTeXclass:a.mbase.setChildTeXclass});a.merror=a.mbase.Subclass({type:"merror",inferRow:b,texClass:a.TEXCLASS.ORD});a.mpadded=a.mbase.Subclass({type:"mpadded",inferRow:b,isSpacelike:a.mbase.childrenSpacelike,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,width:"",height:"",depth:"",lspace:0,voffset:0},setTeXclass:a.mbase.setChildTeXclass});a.mphantom=a.mbase.Subclass({type:"mphantom",texClass:a.TEXCLASS.ORD,inferRow:b,isSpacelike:a.mbase.childrenSpacelike,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,setTeXclass:a.mbase.setChildTeXclass});a.mfenced=a.mbase.Subclass({type:"mfenced",defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,open:"(",close:")",separators:","},texClass:a.TEXCLASS.OPEN,setTeXclass:function(j){this.getPrevClass(j);var g=this.getValues("open","close","separators");g.open=g.open.replace(/[ \t\n\r]/g,"");g.close=g.close.replace(/[ \t\n\r]/g,"");g.separators=g.separators.replace(/[ \t\n\r]/g,"");if(g.open!==""){this.SetData("open",a.mo(g.open).With({stretchy:true,texClass:a.TEXCLASS.OPEN}));j=this.data.open.setTeXclass(j)}if(g.separators!==""){while(g.separators.length<this.data.length){g.separators+=g.separators.charAt(g.separators.length-1)}}if(this.data[0]){j=this.data[0].setTeXclass(j)}for(var h=1,f=this.data.length;h<f;h++){if(this.data[h]){if(g.separators!==""){this.SetData("sep"+h,a.mo(g.separators.charAt(h-1)));j=this.data["sep"+h].setTeXclass(j)}j=this.data[h].setTeXclass(j)}}if(g.close!==""){this.SetData("close",a.mo(g.close).With({stretchy:true,texClass:a.TEXCLASS.CLOSE}));j=this.data.close.setTeXclass(j)}this.updateTeXclass(this.data.open);return j}});a.menclose=a.mbase.Subclass({type:"menclose",inferRow:b,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,notation:a.NOTATION.LONGDIV,texClass:a.TEXCLASS.ORD},setTeXclass:a.mbase.setSeparateTeXclasses});a.msubsup=a.mbase.Subclass({type:"msubsup",base:0,sub:1,sup:2,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,subscriptshift:"",superscriptshift:"",texClass:a.AUTO},autoDefault:function(f){if(f==="texClass"){return(this.isEmbellished()?this.CoreMO().Get(f):a.TEXCLASS.ORD)}return 0},adjustChild_displaystyle:function(f){if(f>0){return d}return this.Get("displaystyle")},adjustChild_scriptlevel:function(g){var f=this.Get("scriptlevel");if(g>0){f++}return f},adjustChild_texprimestyle:function(f){if(f===this.sub){return b}return this.Get("texprimestyle")},setTeXclass:a.mbase.setBaseTeXclasses});a.msub=a.msubsup.Subclass({type:"msub"});a.msup=a.msubsup.Subclass({type:"msup",sub:2,sup:1});a.mmultiscripts=a.msubsup.Subclass({type:"mmultiscripts",adjustChild_texprimestyle:function(f){if(f%2===1){return b}return this.Get("texprimestyle")}});a.mprescripts=a.mbase.Subclass({type:"mprescripts"});a.none=a.mbase.Subclass({type:"none"});a.munderover=a.mbase.Subclass({type:"munderover",base:0,under:1,over:2,sub:1,sup:2,ACCENTS:["","accentunder","accent"],isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,accent:a.AUTO,accentunder:a.AUTO,align:a.ALIGN.CENTER,texClass:a.AUTO,subscriptshift:"",superscriptshift:""},autoDefault:function(f){if(f==="texClass"){return(this.isEmbellished()?this.CoreMO().Get(f):a.TEXCLASS.ORD)}if(f==="accent"&&this.data[this.over]){return this.data[this.over].CoreMO().Get("accent")}if(f==="accentunder"&&this.data[this.under]){return this.data[this.under].CoreMO().Get("accent")}return d},adjustChild_displaystyle:function(f){if(f>0){return d}return this.Get("displaystyle")},adjustChild_scriptlevel:function(g){var f=this.Get("scriptlevel");if(g==this.under&&!this.Get("accentunder")){f++}if(g==this.over&&!this.Get("accent")){f++}return f},adjustChild_texprimestyle:function(f){if(f===this.base&&this.data[this.over]){return b}return this.Get("texprimestyle")},setTeXclass:a.mbase.setBaseTeXclasses});a.munder=a.munderover.Subclass({type:"munder"});a.mover=a.munderover.Subclass({type:"mover",over:1,under:2,sup:1,sub:2,ACCENTS:["","accent","accentunder"]});a.mtable=a.mbase.Subclass({type:"mtable",defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,align:a.ALIGN.AXIS,rowalign:a.ALIGN.BASELINE,columnalign:a.ALIGN.CENTER,groupalign:"{left}",alignmentscope:b,columnwidth:a.WIDTH.AUTO,width:a.WIDTH.AUTO,rowspacing:"1ex",columnspacing:".8em",rowlines:a.LINES.NONE,columnlines:a.LINES.NONE,frame:a.LINES.NONE,framespacing:"0.4em 0.5ex",equalrows:d,equalcolumns:d,displaystyle:d,side:a.SIDE.RIGHT,minlabelspacing:"0.8em",texClass:a.TEXCLASS.ORD,useHeight:1},inheritFromMe:b,noInherit:{mtable:{align:b,rowalign:b,columnalign:b,groupalign:b,alignmentscope:b,columnwidth:b,width:b,rowspacing:b,columnspacing:b,rowlines:b,columnlines:b,frame:b,framespacing:b,equalrows:b,equalcolumns:b,side:b,minlabelspacing:b,texClass:b,useHeight:1}},Append:function(){for(var g=0,f=arguments.length;g<f;g++){if(!((arguments[g] instanceof a.mtr)||(arguments[g] instanceof a.mlabeledtr))){arguments[g]=a.mtd(arguments[g])}}this.SUPER(arguments).Append.apply(this,arguments)},setTeXclass:a.mbase.setSeparateTeXclasses});a.mtr=a.mbase.Subclass({type:"mtr",defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,rowalign:a.INHERIT,columnalign:a.INHERIT,groupalign:a.INHERIT},inheritFromMe:b,noInherit:{mrow:{rowalign:b,columnalign:b,groupalign:b},mtable:{rowalign:b,columnalign:b,groupalign:b}},Append:function(){for(var g=0,f=arguments.length;g<f;g++){if(!(arguments[g] instanceof a.mtd)){arguments[g]=a.mtd(arguments[g])}}this.SUPER(arguments).Append.apply(this,arguments)},setTeXclass:a.mbase.setSeparateTeXclasses});a.mtd=a.mbase.Subclass({type:"mtd",inferRow:b,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,rowspan:1,columnspan:1,rowalign:a.INHERIT,columnalign:a.INHERIT,groupalign:a.INHERIT},setTeXclass:a.mbase.setSeparateTeXclasses});a.maligngroup=a.mbase.Subclass({type:"malign",isSpacelike:function(){return b},defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,groupalign:a.INHERIT},inheritFromMe:b,noInherit:{mrow:{groupalign:b},mtable:{groupalign:b}}});a.malignmark=a.mbase.Subclass({type:"malignmark",defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,edge:a.SIDE.LEFT},isSpacelike:function(){return b}});a.mlabeledtr=a.mtr.Subclass({type:"mlabeledtr"});a.maction=a.mbase.Subclass({type:"maction",defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,actiontype:a.ACTIONTYPE.TOGGLE,selection:1},selected:function(){return this.data[this.Get("selection")-1]||a.NULL},isEmbellished:function(){return this.selected().isEmbellished()},isSpacelike:function(){return this.selected().isSpacelike()},Core:function(){return this.selected().Core()},CoreMO:function(){return this.selected().CoreMO()},setTeXclass:function(f){return this.selected().setTeXclass(f)}});a.semantics=a.mbase.Subclass({type:"semantics",isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,defaults:{definitionURL:null,encoding:null},setTeXclass:a.mbase.setChildTeXclass});a.annotation=a.mbase.Subclass({type:"annotation",isToken:b,defaults:{definitionURL:null,encoding:null,cd:"mathmlkeys",name:"",src:null}});a["annotation-xml"]=a.mbase.Subclass({type:"annotation-xml",defaults:{definitionURL:null,encoding:null,cd:"mathmlkeys",name:"",src:null}});a.math=a.mstyle.Subclass({type:"math",defaults:{mathvariant:a.VARIANT.NORMAL,mathsize:a.SIZE.NORMAL,mathcolor:"",mathbackground:a.COLOR.TRANSPARENT,scriptlevel:0,displaystyle:a.AUTO,display:"inline",maxwidth:"",overflow:a.OVERFLOW.LINEBREAK,altimg:"","altimg-width":"","altimg-height":"","altimg-valign":"",alttext:"",cdgroup:"",scriptsizemultiplier:Math.sqrt(1/2),scriptminsize:"8px",infixlinebreakstyle:a.LINEBREAKSTYLE.BEFORE,lineleading:"1ex",indentshift:"auto",indentalign:a.INDENTALIGN.AUTO,indentalignfirst:a.INDENTALIGN.INDENTALIGN,indentshiftfirst:a.INDENTSHIFT.INDENTSHIFT,decimalseparator:".",texprimestyle:d},autoDefault:function(f){if(f==="displaystyle"){return this.Get("display")==="block"}return""},setTeXclass:a.mbase.setChildTeXclass});a.chars=a.mbase.Subclass({type:"chars",Append:function(){this.data.push.apply(this.data,arguments)},value:function(){return this.data.join("")},toString:function(){return this.data.join("")}});a.entity=a.mbase.Subclass({type:"entity",Append:function(){this.data.push.apply(this.data,arguments)},value:function(){if(this.data[0].substr(0,2)==="#x"){return parseInt(this.data[0].substr(2),16)}else{if(this.data[0].substr(0,1)==="#"){return parseInt(this.data[0].substr(1))}else{return 0}}},toString:function(){var f=this.value();if(f<=65535){return String.fromCharCode(f)}return this.PLANE1+String.fromCharCode(f-119808+56320)}});a.TeXAtom=a.mbase.Subclass({type:"texatom",inferRow:b,texClass:a.TEXCLASS.ORD,setTeXclass:function(f){this.getPrevClass(f);this.data[0].setTeXclass();return this}});a.NULL=a.mbase().With({type:"null"});var c=a.TEXCLASS;var e={ORD:[0,0,c.ORD],ORD11:[1,1,c.ORD],ORD21:[2,1,c.ORD],ORD02:[0,2,c.ORD],ORD55:[5,5,c.ORD],OP:[1,2,c.OP,{largeop:true,movablelimits:true,symmetric:true}],OPFIXED:[1,2,c.OP,{largeop:true,movablelimits:true}],INTEGRAL:[0,1,c.OP,{largeop:true,symmetric:true}],INTEGRAL2:[1,2,c.OP,{largeop:true,symmetric:true}],BIN3:[3,3,c.BIN],BIN4:[4,4,c.BIN],BIN01:[0,1,c.BIN],TALLBIN:[4,4,c.BIN,{stretchy:true}],BINOP:[4,4,c.BIN,{largeop:true,movablelimits:true}],REL:[5,5,c.REL],REL1:[1,1,c.REL,{stretchy:true}],REL4:[4,4,c.REL],WIDEREL:[5,5,c.REL,{stretchy:true}],RELACCENT:[5,5,c.REL,{accent:true,stretchy:true}],OPEN:[0,0,c.OPEN,{fence:true,stretchy:true,symmetric:true}],CLOSE:[0,0,c.CLOSE,{fence:true,stretchy:true,symmetric:true}],INNER:[0,0,c.INNER],PUNCT:[0,3,c.PUNCT],ACCENT:[0,0,c.ORD,{accent:true}],WIDEACCENT:[0,0,c.ORD,{accent:true,stretchy:true}]};a.mo.Augment({SPACE:["0em","0.1111em","0.1667em","0.2222em","0.2667em","0.3333em"],RANGES:[[32,127,c.REL,"BasicLatin"],[160,255,c.ORD,"Latin1Supplement"],[256,383,c.ORD],[384,591,c.ORD],[688,767,c.ORD,"SpacingModLetters"],[768,879,c.ORD,"CombDiacritMarks"],[880,1023,c.ORD,"GreekAndCoptic"],[7680,7935,c.ORD],[8192,8303,c.PUNCT,"GeneralPunctuation"],[8304,8351,c.ORD],[8352,8399,c.ORD],[8400,8447,c.ORD,"CombDiactForSymbols"],[8448,8527,c.ORD,"LetterlikeSymbols"],[8528,8591,c.ORD],[8592,8703,c.REL,"Arrows"],[8704,8959,c.BIN,"MathOperators"],[8960,9215,c.ORD,"MiscTechnical"],[9312,9471,c.ORD],[9632,9727,c.ORD,"GeometricShapes"],[9984,10175,c.ORD,"Dingbats"],[10176,10223,c.ORD,"MiscMathSymbolsA"],[10496,10623,c.REL,"SupplementalArrowsB"],[10624,10751,c.ORD,"MiscMathSymbolsB"],[10752,11007,c.BIN,"SuppMathOperators"],[11008,11263,c.ORD],[119808,120831,c.ORD]],OPTABLE:{prefix:{"\u2111":e.ORD11,"\u2113":e.ORD11,"\u211C":e.ORD11,"\u2200":e.ORD21,"\u2202":e.ORD21,"\u2203":e.ORD21,"\u2207":e.ORD21,"\u220F":e.OP,"\u2210":e.OP,"\u2211":e.OP,"\u2212":e.BIN01,"\u2213":e.BIN01,"\u221A":[1,1,c.ORD,{stretchy:true}],"\u2220":e.ORD,"\u222B":e.INTEGRAL,"\u222E":e.INTEGRAL,"\u22C0":e.OP,"\u22C1":e.OP,"\u22C2":e.OP,"\u22C3":e.OP,"\u2308":e.OPEN,"\u230A":e.OPEN,"\u27E8":e.OPEN,"\u2A00":e.OP,"\u2A01":e.OP,"\u2A02":e.OP,"\u2A04":e.OP,"\u2A06":e.OP,"\u00AC":e.ORD21,"\u00B1":e.BIN01,"(":e.OPEN,"+":e.BIN01,"-":e.BIN01,"[":e.OPEN,"{":e.OPEN,"|":e.OPEN},postfix:{"!":[1,0,c.CLOSE],"&":e.ORD,"\u2032":e.ORD02,"\u203E":e.WIDEACCENT,"\u2309":e.CLOSE,"\u230B":e.CLOSE,"\u23DE":e.WIDEACCENT,"\u23DF":e.WIDEACCENT,"\u266D":e.ORD02,"\u266E":e.ORD02,"\u266F":e.ORD02,"\u27E9":e.CLOSE,"\u02C6":e.WIDEACCENT,"\u02C7":e.WIDEACCENT,"\u02D8":e.ACCENT,"\u02D9":e.ACCENT,"\u02DC":e.WIDEACCENT,"\u0302":e.ACCENT,"\u00A8":e.ACCENT,"\u00AF":e.WIDEACCENT,")":e.CLOSE,"]":e.CLOSE,"^":e.WIDEACCENT,_:e.WIDEACCENT,"`":e.ACCENT,"|":e.CLOSE,"}":e.CLOSE,"~":e.WIDEACCENT},infix:{"%":[3,3,c.ORD],"\u2022":e.BIN4,"\u2026":e.INNER,"\u2044":e.TALLBIN,"\u2061":e.ORD,"\u2062":e.ORD,"\u2063":[0,0,c.ORD,{separator:true}],"\u2064":e.ORD,"\u2190":e.RELACCENT,"\u2191":e.WIDEREL,"\u2192":e.RELACCENT,"\u2193":e.WIDEREL,"\u2194":e.RELACCENT,"\u2195":e.WIDEREL,"\u2196":e.WIDEREL,"\u2197":e.WIDEREL,"\u2198":e.WIDEREL,"\u2199":e.WIDEREL,"\u21A6":e.WIDEREL,"\u21A9":e.WIDEREL,"\u21AA":e.WIDEREL,"\u21BC":e.RELACCENT,"\u21BD":e.WIDEREL,"\u21C0":e.RELACCENT,"\u21C1":e.WIDEREL,"\u21CC":e.WIDEREL,"\u21D0":e.WIDEREL,"\u21D1":e.WIDEREL,"\u21D2":e.WIDEREL,"\u21D3":e.WIDEREL,"\u21D4":e.WIDEREL,"\u21D5":e.WIDEREL,"\u2208":e.REL,"\u2209":e.REL,"\u220B":e.REL,"\u2212":e.BIN4,"\u2213":e.BIN4,"\u2215":e.TALLBIN,"\u2216":e.BIN4,"\u2217":e.BIN4,"\u2218":e.BIN4,"\u2219":e.BIN4,"\u221D":e.REL,"\u2223":e.REL,"\u2225":e.REL,"\u2227":e.BIN4,"\u2228":e.BIN4,"\u2229":e.BIN4,"\u222A":e.BIN4,"\u223C":e.REL,"\u2240":e.BIN4,"\u2243":e.REL,"\u2245":e.REL,"\u2248":e.REL,"\u224D":e.REL,"\u2250":e.REL,"\u2260":e.REL,"\u2261":e.REL,"\u2264":e.REL,"\u2265":e.REL,"\u226A":e.REL,"\u226B":e.REL,"\u227A":e.REL,"\u227B":e.REL,"\u2282":e.REL,"\u2283":e.REL,"\u2286":e.REL,"\u2287":e.REL,"\u228E":e.BIN4,"\u2291":e.REL,"\u2292":e.REL,"\u2293":e.BIN4,"\u2294":e.BIN4,"\u2295":e.BIN4,"\u2296":e.BIN4,"\u2297":e.BIN4,"\u2298":e.BIN4,"\u2299":e.BIN4,"\u22A2":e.REL,"\u22A3":e.REL,"\u22A4":e.ORD55,"\u22A5":e.REL,"\u22A8":e.REL,"\u22C4":e.BIN4,"\u22C5":e.BIN4,"\u22C6":e.BIN4,"\u22C8":e.REL,"\u22EE":e.ORD55,"\u22EF":e.INNER,"\u22F1":[5,5,c.INNER],"\u2500":[0,0,c.ORD,{stretchy:true}],"\u25B3":e.BIN4,"\u25B5":e.BIN4,"\u25B9":e.BIN4,"\u25BD":e.BIN4,"\u25BF":e.BIN4,"\u25C3":e.BIN4,"\u2758":[4,4,c.REL,{fence:true,stretchy:true,symmetric:true}],"\u27F5":e.REL1,"\u27F6":e.REL1,"\u27F7":e.REL1,"\u27F8":e.REL1,"\u27F9":e.REL1,"\u27FA":e.REL1,"\u2A2F":e.BIN4,"\u2A3F":e.BIN4,"\u2AAF":e.REL,"\u2AB0":e.REL,"\u00B1":e.BIN4,"\u00B7":e.BIN4,"\u00D7":e.BIN4,"\u00F7":e.BIN4,"*":e.BIN3,"+":e.BIN4,",":[0,3,c.PUNCT,{separator:true}],"-":e.BIN4,".":[3,3,c.ORD],"/":e.ORD11,":":[1,2,c.REL],";":[0,3,c.PUNCT,{separator:true}],"<":e.REL,"=":e.REL,">":e.REL,"?":[1,1,c.CLOSE],"\\":e.ORD,_:e.ORD11,"|":[2,2,c.ORD,{fence:true,stretchy:true,symmetric:true}],"#":e.ORD,"$":e.ORD,"\u002E":[0,3,c.PUNCT,{separator:true}],"\u02B9":e.ORD,"\u02C9":e.ACCENT,"\u02CA":e.ACCENT,"\u02CB":e.ACCENT,"\u0300":e.ACCENT,"\u0301":e.ACCENT,"\u0303":e.WIDEACCENT,"\u0304":e.ACCENT,"\u0306":e.ACCENT,"\u0307":e.ACCENT,"\u0308":e.ACCENT,"\u030C":e.ACCENT,"\u0332":e.WIDEACCENT,"\u0338":e.REL4,"\u2015":[0,0,c.ORD,{stretchy:true}],"\u2017":[0,0,c.ORD,{stretchy:true}],"\u2020":e.BIN3,"\u2021":e.BIN3,"\u20D7":e.ACCENT,"\u2118":e.ORD,"\u2205":e.ORD,"\u221E":e.ORD,"\u2305":e.BIN3,"\u2306":e.BIN3,"\u2322":e.REL4,"\u2323":e.REL4,"\u2329":e.OPEN,"\u232A":e.CLOSE,"\u23AA":e.ORD,"\u23AF":[0,0,c.ORD,{stretchy:true}],"\u23B0":e.OPEN,"\u23B1":e.CLOSE,"\u25EF":e.BIN3,"\u2660":e.ORD,"\u2661":e.ORD,"\u2662":e.ORD,"\u2663":e.ORD,"\u27EE":e.OPEN,"\u27EF":e.CLOSE,"\u27FC":e.REL4,"\u3008":e.OPEN,"\u3009":e.CLOSE,"\uFE37":e.WIDEACCENT,"\uFE38":e.WIDEACCENT}}},{OPTYPES:e})})(MathJax.ElementJax.mml);MathJax.ElementJax.mml.loadComplete("jax.js");

MathJax.Hub.Register.LoadHook("[MathJax]/jax/element/mml/jax.js",function(){var b="1.1";var a=MathJax.ElementJax.mml;a.mbase.Augment({toMathML:function(k){var g=(this.inferred&&this.parent.inferRow);if(k==null){k=""}var e=this.type,d=this.MathMLattributes();if(e==="mspace"){return k+"<"+e+d+" />"}var j=[];var h=(this.isToken?"":k+(g?"":"  "));for(var f=0,c=this.data.length;f<c;f++){if(this.data[f]){j.push(this.data[f].toMathML(h))}else{if(!this.isToken){j.push(h+"<mrow />")}}}if(this.isToken){return k+"<"+e+d+">"+j.join("")+"</"+e+">"}if(g){return j.join("\n")}if(j.length===0||(j.length===1&&j[0]==="")){return k+"<"+e+d+" />"}return k+"<"+e+d+">\n"+j.join("\n")+"\n"+k+"</"+e+">"},MathMLattributes:function(){var j=[],g=this.defaults;var c=this.copyAttributes,l=this.skipAttributes;if(this.type==="math"){j.push('xmlns="http://www.w3.org/1998/Math/MathML"')}if(this.type==="mstyle"){g=a.math.prototype.defaults}for(var d in g){if(!l[d]&&g.hasOwnProperty(d)){var e=(d==="open"||d==="close");if(this[d]!=null&&(e||this[d]!==g[d])){var k=this[d];delete this[d];if(e||this.Get(d)!==k){j.push(d+'="'+this.quoteHTML(k)+'"')}this[d]=k}}}for(var h=0,f=c.length;h<f;h++){if(this[c[h]]!=null){j.push(c[h]+'="'+this.quoteHTML(this[c[h]])+'"')}}if(j.length){return" "+j.join(" ")}else{return""}},copyAttributes:["fontfamily","fontsize","fontweight","fontstyle","color","background","id","class","href","style"],skipAttributes:{texClass:1,useHeight:1,texprimestyle:1},quoteHTML:function(e){e=String(e).split("");for(var f=0,d=e.length;f<d;f++){var h=e[f].charCodeAt(0);if(h<32||h>126){e[f]="&#x"+h.toString(16).toUpperCase()+";"}else{var g={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;"}[e[f]];if(g){e[f]=g}}}return e.join("")}});a.msubsup.Augment({toMathML:function(h){var e=this.type;if(this.data[this.sup]==null){e="msub"}if(this.data[this.sub]==null){e="msup"}var d=this.MathMLattributes();delete this.data[0].inferred;var g=[];for(var f=0,c=this.data.length;f<c;f++){if(this.data[f]){g.push(this.data[f].toMathML(h+"  "))}}return h+"<"+e+d+">\n"+g.join("\n")+"\n"+h+"</"+e+">"}});a.munderover.Augment({toMathML:function(h){var e=this.type;if(this.data[this.under]==null){e="mover"}if(this.data[this.over]==null){e="munder"}var d=this.MathMLattributes();delete this.data[0].inferred;var g=[];for(var f=0,c=this.data.length;f<c;f++){if(this.data[f]){g.push(this.data[f].toMathML(h+"  "))}}return h+"<"+e+d+">\n"+g.join("\n")+"\n"+h+"</"+e+">"}});a.TeXAtom.Augment({toMathML:function(c){return c+"<mrow>\n"+this.data[0].toMathML(c+"  ")+"\n"+c+"</mrow>"}});a.chars.Augment({toMathML:function(c){return(c||"")+this.quoteHTML(this.toString())}});a.entity.Augment({toMathML:function(c){return(c||"")+"&"+this.data[0]+";<!-- "+this.toString()+" -->"}});MathJax.Hub.Register.StartupHook("TeX mathchoice Ready",function(){a.TeXmathchoice.Augment({toMathML:function(c){return this.Core().toMathML(c)}})});MathJax.Hub.Startup.signal.Post("toMathML Ready")});MathJax.Ajax.loadComplete("[MathJax]/extensions/toMathML.js");

(function(b,c){var a;b.Parse=MathJax.Object.Subclass({Init:function(d){this.Parse(d)},Parse:function(f){var g;if(typeof f!=="string"){g=f.parentNode}else{if(f.match(/^<[a-z]+:/i)&&!f.match(/^<[^<>]* xmlns:/)){f=f.replace(/^<([a-z]+)(:math)/i,'<$1$2 xmlns:$1="http://www.w3.org/1998/Math/MathML"')}f=f.replace(/^\s*(?:\/\/)?<!(--)?\[CDATA\[((.|\n)*)(\/\/)?\]\]\1>\s*$/,"$2");f=f.replace(/&([a-z]+);/ig,this.replaceEntity);g=b.ParseXML(f);if(g==null){b.Error("Error parsing MathML")}}var e=g.getElementsByTagName("parsererror")[0];if(e){b.Error("Error parsing MathML: "+e.textContent.replace(/This page.*?errors:|XML Parsing Error: |Below is a rendering of the page.*/g,""))}if(g.childNodes.length!==1){b.Error("MathML must be formed by a single element")}if(g.firstChild.nodeName.toLowerCase()==="html"){var d=g.getElementsByTagName("h1")[0];if(d&&d.textContent==="XML parsing error"&&d.nextSibling){b.Error("Error parsing MathML: "+String(d.nextSibling.nodeValue).replace(/fatal parsing error: /,""))}}if(g.firstChild.nodeName.toLowerCase().replace(/^[a-z]+:/,"")!=="math"){b.Error("MathML must be formed by a <math> element, not <"+g.firstChild.nodeName+">")}this.mml=this.MakeMML(g.firstChild)},MakeMML:function(g){var k=g.nodeName.toLowerCase().replace(/^[a-z]+:/,"");if(!(a[k]&&a[k].isa&&a[k].isa(a.mbase))){return a.merror("Unknown node type: "+k)}var d=a[k](),j,h,l;for(j=0,h=g.attributes.length;j<h;j++){l=g.attributes[j].value;if(l.toLowerCase()==="true"){l=true}else{if(l.toLowerCase()==="false"){l=false}}d[g.attributes[j].name]=l}for(j=0,h=g.childNodes.length;j<h;j++){var e=g.childNodes[j];if(e.nodeName==="#comment"){continue}if(e.nodeName==="#text"){if(d.isToken&&!d.mmlSelfClosing){var n=this.trimSpace(e.nodeValue);if(d.isa(a.mo)&&n.length===1&&this.Remap[n.charAt(0)]){n=this.Remap[n.charAt(0)]}n=n.replace(/&([a-z]+);/ig,this.replaceEntity);d.Append(a.chars(n))}else{if(e.nodeValue.match(/\S/)){b.Error("Unexpected text node: '"+e.nodeValue+"'")}}}else{var f=this.MakeMML(e);d.Append(f);if(f.mmlSelfClosing&&f.data.length){d.Append.apply(d,f.data);f.data=[]}}}if(b.config.useMathMLspacing){d.useMMLspacing=8}return d},trimSpace:function(d){return d.replace(/^[ \t\n\r]+/,"").replace(/[ \t\n\r]+$/,"").replace(/[ \t\n\r][ \t\n\r]+/g," ")},replaceEntity:function(f,e){if(e==="lt"||e==="amp"){return f}if(b.Parse.Entity[e]){return b.Parse.Entity[e]}var g=e.charAt(0).toLowerCase();var d=e.match(/^[a-zA-Z](fr|scr|opf)$/);if(d){g=d[1]}if(!b.Parse.loaded[g]){b.Parse.loaded[g]=true;MathJax.Hub.RestartAfter(MathJax.Ajax.Require(b.entityDir+"/"+g+".js"))}return f},Remap:{"\u0027":"\u2032","\u002A":"\u2217","\u002D":"\u2212"}},{loaded:[]});b.Augment({Translate:function(d){var e,g;if(d.firstChild&&d.firstChild.nodeName.toLowerCase().replace(/^[a-z]+:/,"")==="math"){g=this.prefilterMathML(d.firstChild)}else{g=d.innerHTML.replace(/^\s+/,"").replace(/\s+$/,"");if(c.isMSIE){g=g.replace(/(&nbsp;)+$/,"")}else{if(c.isKonqueror){g=g.replace(/&lt;/g,"<").replace(/&gt;/g,">").replace(/&amp;/g,"&")}}g=this.prefilterMath(g,d)}try{e=b.Parse(g).mml}catch(f){if(!f.mathmlError){throw f}e=this.formatError(f,g,d)}return a(e)},prefilterMath:function(e,d){return e},prefilterMathML:function(d){return d},formatError:function(f,e,d){return a.merror(f.message.replace(/\n.*/,""))},Error:function(d){throw MathJax.Hub.Insert(Error(d),{mathmlError:true})},parseDOM:function(d){return this.parser.parseFromString(d,"text/xml")},parseMS:function(d){return(this.parser.loadXML(d)?this.parser:null)},parseDIV:function(d){this.div.innerHTML=d.replace(/<([a-z]+)([^>]*)\/>/g,"<$1$2></$1>");return this.div},Startup:function(){a=MathJax.ElementJax.mml;a.mspace.Augment({mmlSelfClosing:true});a.none.Augment({mmlSelfClosing:true});a.mprescripts.Augment({mmlSelfClossing:true});if(window.DOMParser){this.parser=new DOMParser();this.ParseXML=this.parseDOM}else{if(window.ActiveXObject){var e=["MSXML2.DOMDocument.6.0","MSXML2.DOMDocument.5.0","MSXML2.DOMDocument.4.0","MSXML2.DOMDocument.3.0","MSXML2.DOMDocument.2.0","Microsoft.XMLDOM"];for(var f=0,d=e.length;f<d&&!this.parser;f++){try{this.parser=new ActiveXObject(e[f])}catch(g){}}if(!this.parser){b.Error("Can't create XML parser for MathML")}this.parser.async=false;this.ParseXML=this.parseMS}else{this.div=MathJax.Hub.Insert(document.createElement("div"),{style:{visibility:"hidden",overflow:"hidden",height:"1px",position:"absolute",top:0}});if(!document.body.firstChild){document.body.appendChild(this.div)}else{document.body.insertBefore(this.div,document.body.firstChild)}this.ParseXML=this.parseDIV}}}});b.Parse.Entity={ApplyFunction:"\u2061",Backslash:"\u2216",Because:"\u2235",Breve:"\u02D8",Cap:"\u22D2",CenterDot:"\u00B7",CircleDot:"\u2299",CircleMinus:"\u2296",CirclePlus:"\u2295",CircleTimes:"\u2297",Congruent:"\u2261",ContourIntegral:"\u222E",Coproduct:"\u2210",Cross:"\u2A2F",Cup:"\u22D3",CupCap:"\u224D",Dagger:"\u2021",Del:"\u2207",Delta:"\u0394",Diamond:"\u22C4",DifferentialD:"\u2146",DotEqual:"\u2250",DoubleDot:"\u00A8",DoubleRightTee:"\u22A8",DoubleVerticalBar:"\u2225",DownArrow:"\u2193",DownLeftVector:"\u21BD",DownRightVector:"\u21C1",DownTee:"\u22A4",Downarrow:"\u21D3",Element:"\u2208",EqualTilde:"\u2242",Equilibrium:"\u21CC",Exists:"\u2203",ExponentialE:"\u2147",FilledVerySmallSquare:"\u25AA",ForAll:"\u2200",Gamma:"\u0393",Gg:"\u22D9",GreaterEqual:"\u2265",GreaterEqualLess:"\u22DB",GreaterFullEqual:"\u2267",GreaterLess:"\u2277",GreaterSlantEqual:"\u2A7E",GreaterTilde:"\u2273",Hacek:"\u02C7",Hat:"\u005E",HumpDownHump:"\u224E",HumpEqual:"\u224F",Im:"\u2111",ImaginaryI:"\u2148",Integral:"\u222B",Intersection:"\u22C2",InvisibleComma:"\u2063",InvisibleTimes:"\u2062",Lambda:"\u039B",Larr:"\u219E",LeftAngleBracket:"\u2329",LeftArrow:"\u2190",LeftArrowRightArrow:"\u21C6",LeftCeiling:"\u2308",LeftDownVector:"\u21C3",LeftFloor:"\u230A",LeftRightArrow:"\u2194",LeftTee:"\u22A3",LeftTriangle:"\u22B2",LeftTriangleEqual:"\u22B4",LeftUpVector:"\u21BF",LeftVector:"\u21BC",Leftarrow:"\u21D0",Leftrightarrow:"\u21D4",LessEqualGreater:"\u22DA",LessFullEqual:"\u2266",LessGreater:"\u2276",LessSlantEqual:"\u2A7D",LessTilde:"\u2272",Ll:"\u22D8",Lleftarrow:"\u21DA",LongLeftArrow:"\u27F5",LongLeftRightArrow:"\u27F7",LongRightArrow:"\u27F6",Longleftarrow:"\u27F8",Longleftrightarrow:"\u27FA",Longrightarrow:"\u27F9",Lsh:"\u21B0",MinusPlus:"\u2213",NestedGreaterGreater:"\u226B",NestedLessLess:"\u226A",NotDoubleVerticalBar:"\u2226",NotElement:"\u2209",NotEqual:"\u2260",NotExists:"\u2204",NotGreater:"\u226F",NotGreaterEqual:"\u2271",NotLeftTriangle:"\u22EA",NotLeftTriangleEqual:"\u22EC",NotLess:"\u226E",NotLessEqual:"\u2270",NotPrecedes:"\u2280",NotPrecedesSlantEqual:"\u22E0",NotRightTriangle:"\u22EB",NotRightTriangleEqual:"\u22ED",NotSubsetEqual:"\u2288",NotSucceeds:"\u2281",NotSucceedsSlantEqual:"\u22E1",NotSupersetEqual:"\u2289",NotTilde:"\u2241",NotVerticalBar:"\u2224",Omega:"\u03A9",OverBar:"\u00AF",OverBrace:"\uFE37",PartialD:"\u2202",Phi:"\u03A6",Pi:"\u03A0",PlusMinus:"\u00B1",Precedes:"\u227A",PrecedesEqual:"\u2AAF",PrecedesSlantEqual:"\u227C",PrecedesTilde:"\u227E",Product:"\u220F",Proportional:"\u221D",Psi:"\u03A8",Rarr:"\u21A0",Re:"\u211C",ReverseEquilibrium:"\u21CB",RightAngleBracket:"\u232A",RightArrow:"\u2192",RightArrowLeftArrow:"\u21C4",RightCeiling:"\u2309",RightDownVector:"\u21C2",RightFloor:"\u230B",RightTee:"\u22A2",RightTeeArrow:"\u21A6",RightTriangle:"\u22B3",RightTriangleEqual:"\u22B5",RightUpVector:"\u21BE",RightVector:"\u21C0",Rightarrow:"\u21D2",Rrightarrow:"\u21DB",Rsh:"\u21B1",Sigma:"\u03A3",SmallCircle:"\u2218",Sqrt:"\u221A",Square:"\u25A1",SquareIntersection:"\u2293",SquareSubset:"\u228F",SquareSubsetEqual:"\u2291",SquareSuperset:"\u2290",SquareSupersetEqual:"\u2292",SquareUnion:"\u2294",Star:"\u22C6",Subset:"\u22D0",SubsetEqual:"\u2286",Succeeds:"\u227B",SucceedsEqual:"\u2AB0",SucceedsSlantEqual:"\u227D",SucceedsTilde:"\u227F",SuchThat:"\u220B",Sum:"\u2211",Superset:"\u2283",SupersetEqual:"\u2287",Supset:"\u22D1",Therefore:"\u2234",Theta:"\u0398",Tilde:"\u223C",TildeEqual:"\u2243",TildeFullEqual:"\u2245",TildeTilde:"\u2248",UnderBar:"\u0332",UnderBrace:"\uFE38",Union:"\u22C3",UnionPlus:"\u228E",UpArrow:"\u2191",UpDownArrow:"\u2195",UpTee:"\u22A5",Uparrow:"\u21D1",Updownarrow:"\u21D5",Upsilon:"\u03A5",Vdash:"\u22A9",Vee:"\u22C1",VerticalBar:"\u2223",VerticalTilde:"\u2240",Vvdash:"\u22AA",Wedge:"\u22C0",Xi:"\u039E",acute:"\u00B4",aleph:"\u2135",alpha:"\u03B1",amalg:"\u2A3F",and:"\u2227",ang:"\u2220",angmsd:"\u2221",angsph:"\u2222",ape:"\u224A",backprime:"\u2035",backsim:"\u223D",backsimeq:"\u22CD",beta:"\u03B2",beth:"\u2136",between:"\u226C",bigcirc:"\u25EF",bigodot:"\u2A00",bigoplus:"\u2A01",bigotimes:"\u2A02",bigsqcup:"\u2A06",bigstar:"\u2605",bigtriangledown:"\u25BD",bigtriangleup:"\u25B3",biguplus:"\u2A04",blacklozenge:"\u29EB",blacktriangle:"\u25B4",blacktriangledown:"\u25BE",blacktriangleleft:"\u25C2",bowtie:"\u22C8",boxdl:"\u2510",boxdr:"\u250C",boxminus:"\u229F",boxplus:"\u229E",boxtimes:"\u22A0",boxul:"\u2518",boxur:"\u2514",bsol:"\u005C",bull:"\u2022",cap:"\u2229",check:"\u2713",chi:"\u03C7",circ:"\u02C6",circeq:"\u2257",circlearrowleft:"\u21BA",circlearrowright:"\u21BB",circledR:"\u00AE",circledS:"\u24C8",circledast:"\u229B",circledcirc:"\u229A",circleddash:"\u229D",clubs:"\u2663",colon:"\u003A",comp:"\u2201",ctdot:"\u22EF",cuepr:"\u22DE",cuesc:"\u22DF",cularr:"\u21B6",cup:"\u222A",curarr:"\u21B7",curlyvee:"\u22CE",curlywedge:"\u22CF",dagger:"\u2020",daleth:"\u2138",ddarr:"\u21CA",deg:"\u00B0",delta:"\u03B4",digamma:"\u03DD",div:"\u00F7",divideontimes:"\u22C7",dot:"\u02D9",doteqdot:"\u2251",dotplus:"\u2214",dotsquare:"\u22A1",dtdot:"\u22F1",ecir:"\u2256",efDot:"\u2252",egs:"\u2A96",ell:"\u2113",els:"\u2A95",empty:"\u2205",epsi:"\u03F5",epsiv:"\u03B5",erDot:"\u2253",eta:"\u03B7",eth:"\u00F0",flat:"\u266D",fork:"\u22D4",frown:"\u2322",gEl:"\u2A8C",gamma:"\u03B3",gap:"\u2A86",gimel:"\u2137",gnE:"\u2269",gnap:"\u2A8A",gne:"\u2A88",gnsim:"\u22E7",gt:"\u003E",gtdot:"\u22D7",harrw:"\u21AD",hbar:"\u210F",hellip:"\u2026",hookleftarrow:"\u21A9",hookrightarrow:"\u21AA",imath:"\u0131",infin:"\u221E",intcal:"\u22BA",iota:"\u03B9",kappa:"\u03BA",kappav:"\u03F0",lEg:"\u2A8B",lambda:"\u03BB",lap:"\u2A85",larrlp:"\u21AB",larrtl:"\u21A2",lbrace:"\u007B",lbrack:"\u005B",le:"\u2264",leftleftarrows:"\u21C7",leftthreetimes:"\u22CB",lessdot:"\u22D6",lmoust:"\u23B0",lnE:"\u2268",lnap:"\u2A89",lne:"\u2A87",lnsim:"\u22E6",longmapsto:"\u27FC",looparrowright:"\u21AC",lowast:"\u2217",lowbar:"\u005F",loz:"\u25CA",lt:"\u003C",ltimes:"\u22C9",ltri:"\u25C3",malt:"\u2720",mho:"\u2127",mu:"\u03BC",multimap:"\u22B8",nVDash:"\u22AF",nVdash:"\u22AE",natur:"\u266E",nearr:"\u2197",nhArr:"\u21CE",nharr:"\u21AE",nlArr:"\u21CD",nlarr:"\u219A",not:"\u00AC",nrArr:"\u21CF",nrarr:"\u219B",nu:"\u03BD",nvDash:"\u22AD",nvdash:"\u22AC",nwarr:"\u2196",omega:"\u03C9",or:"\u2228",osol:"\u2298",period:"\u002E",phi:"\u03D5",phiv:"\u03C6",pi:"\u03C0",piv:"\u03D6",prap:"\u2AB7",precnapprox:"\u2AB9",precneqq:"\u2AB5",precnsim:"\u22E8",prime:"\u2032",psi:"\u03C8",rarrtl:"\u21A3",rbrace:"\u007D",rbrack:"\u005D",rho:"\u03C1",rhov:"\u03F1",rightrightarrows:"\u21C9",rightthreetimes:"\u22CC",ring:"\u02DA",rmoust:"\u23B1",rtimes:"\u22CA",rtri:"\u25B9",scap:"\u2AB8",scnE:"\u2AB6",scnap:"\u2ABA",scnsim:"\u22E9",sdot:"\u22C5",searr:"\u2198",sect:"\u00A7",sharp:"\u266F",sigma:"\u03C3",sigmav:"\u03C2",simne:"\u2246",smile:"\u2323",spades:"\u2660",sub:"\u2282",subE:"\u2AC5",subnE:"\u2ACB",subne:"\u228A",supE:"\u2AC6",supnE:"\u2ACC",supne:"\u228B",swarr:"\u2199",tau:"\u03C4",theta:"\u03B8",thetav:"\u03D1",tilde:"\u02DC",times:"\u00D7",triangle:"\u25B5",triangleq:"\u225C",upsi:"\u03C5",upuparrows:"\u21C8",veebar:"\u22BB",vellip:"\u22EE",weierp:"\u2118",xi:"\u03BE",yen:"\u00A5",zeta:"\u03B6",zigrarr:"\u21DD"};b.loadComplete("jax.js")})(MathJax.InputJax.MathML,MathJax.Hub.Browser);

MathJax.Ajax.loadComplete("[MathJax]/config/MML_HTMLorMML.js");
