#!/usr/bin/env perl
# BEGIN BPS TAGGED BLOCK {{{
#
# COPYRIGHT:
#
# This software is Copyright (c) 1996-2012 Best Practical Solutions, LLC
#                                          <sales@bestpractical.com>
#
# (Except where explicitly superseded by other copyright notices)
#
#
# LICENSE:
#
# This work is made available to you under the terms of Version 2 of
# the GNU General Public License. A copy of that license should have
# been provided with this software, but in any event can be snarfed
# from www.gnu.org.
#
# This work is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
# 02110-1301 or visit their web page on the internet at
# http://www.gnu.org/licenses/old-licenses/gpl-2.0.html.
#
#
# CONTRIBUTION SUBMISSION POLICY:
#
# (The following paragraph is not intended to limit the rights granted
# to you to modify and distribute this software under the terms of
# the GNU General Public License and is only of importance to you if
# you choose to contribute your changes and enhancements to the
# community by submitting them to Best Practical Solutions, LLC.)
#
# By intentionally submitting any modifications, corrections or
# derivatives to this work, or any other work intended for use with
# Request Tracker, to Best Practical Solutions, LLC, you confirm that
# you are the copyright holder for those contributions and you grant
# Best Practical Solutions,  LLC a nonexclusive, worldwide, irrevocable,
# royalty-free, perpetual, license to use, copy, create derivative
# works based on those contributions, and sublicense and distribute
# those contributions and any derivatives thereof.
#
# END BPS TAGGED BLOCK }}}
use 5.8.3;
use strict;
use warnings;

use RT;
RT::LoadConfig();
RT->Config->Set('LogToScreen' => 'debug');
RT::Init();

use RT::CachedGroupMembers;
my $cgms = RT::CachedGroupMembers->new( RT->SystemUser );
$cgms->Limit(
    FIELD => 'id',
    OPERATOR => '!=',
    VALUE => 'main.Via',
    QUOTEVALUE => 0,
    ENTRYAGGREGATOR => 'AND',
);
$cgms->FindAllRows;

my $alias = $cgms->Join(
    TYPE   => 'LEFT',
    FIELD1 => 'Via',
    TABLE2 => 'CachedGroupMembers',
    FIELD2 => 'id',
);
$cgms->Limit(
    ALIAS => $alias,
    FIELD => 'MemberId',
    OPERATOR => '=',
    VALUE => $alias .'.GroupId',
    QUOTEVALUE => 0,
    ENTRYAGGREGATOR => 'AND',
);
$cgms->Limit(
    ALIAS => $alias,
    FIELD => 'id',
    OPERATOR => '=',
    VALUE => $alias .'.Via',
    QUOTEVALUE => 0,
    ENTRYAGGREGATOR => 'AND',
);

$| = 1;
my $total = $cgms->Count;
my $i = 0;

FetchNext( $cgms, 'init' );
while ( my $rec = FetchNext( $cgms ) ) {
    $i++;
    printf("\r%0.2f %%", 100 * $i / $total);
    $RT::Handle->BeginTransaction;
    my ($status) = $rec->Delete;
    unless ($status) {
        print STDERR "Couldn't delete CGM #". $rec->id;
        exit 1;
    }
    $RT::Handle->Commit;
}

use constant PAGE_SIZE => 1000;
sub FetchNext {
    my ($objs, $init) = @_;
    if ( $init ) {
        $objs->RowsPerPage( PAGE_SIZE );
        $objs->FirstPage;
        return;
    }

    my $obj = $objs->Next;
    return $obj if $obj;
    $objs->RedoSearch;
    $objs->FirstPage;
    return $objs->Next;
}

