/* SPDX-License-Identifier: GPL-2.0-or-later */

#include <arch/pirq_routing.h>
#include <device/pci_def.h>

static const struct irq_routing_table intel_irq_routing_table = {
	PIRQ_SIGNATURE,
	PIRQ_VERSION,
	32 + 16 * CONFIG_IRQ_SLOT_COUNT,/* Max. number of devices on the bus */
	0x00,			/* Interrupt router bus */
	PCI_DEVFN(0x04, 0),	/* Interrupt router device */
	0,			/* IRQs devoted exclusively to PCI usage */
	0x8086,			/* Vendor */
	0x122e,			/* Device */
	0,			/* Miniport data */
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, /* u8 rfu[11] */
	0x54,			/* Checksum */
	/* clang-format off */
	{
	       /* bus, PCI_DEVFN(dev, fn),  {link, bitmap}, {link, bitmap}, {link, bitmap}, {link, bitmap}, slot, rfu */
		{0x00, PCI_DEVFN(0x0c, 0), {{0x60, 0x1eb8}, {0x61, 0x1eb8}, {0x62, 0x1eb8}, {0x63, 0x1eb8}}, 0x1, 0x0},
		{0x00, PCI_DEVFN(0x0b, 0), {{0x61, 0x1eb8}, {0x62, 0x1eb8}, {0x63, 0x1eb8}, {0x60, 0x1eb8}}, 0x2, 0x0},
		{0x00, PCI_DEVFN(0x0a, 0), {{0x62, 0x1eb8}, {0x63, 0x1eb8}, {0x60, 0x1eb8}, {0x61, 0x1eb8}}, 0x3, 0x0},
		{0x00, PCI_DEVFN(0x09, 0), {{0x63, 0x1eb8}, {0x60, 0x1eb8}, {0x61, 0x1eb8}, {0x62, 0x1eb8}}, 0x4, 0x0},
		{0x00, PCI_DEVFN(0x04, 0), {{0x60, 0x1eb8}, {0x61, 0x1eb8}, {0x62, 0x1eb8}, {0x63, 0x1eb8}}, 0x0, 0x0},
		{0x00, PCI_DEVFN(0x01, 0), {{0x60, 0x1eb8}, {0x61, 0x1eb8}, {0x62, 0x1eb8}, {0x63, 0x1eb8}}, 0x0, 0x0},
	}
	/* clang-format on */
};

unsigned long write_pirq_routing_table(unsigned long addr)
{
	return copy_pirq_routing_table(addr, &intel_irq_routing_table);
}
