/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef CFG_GPIO_H
#define CFG_GPIO_H

#include <gpio.h>

/* PAD configuration was generated automatically using intelp2m utility */
static const struct pad_config gpio_table[] = {
	/* ------- GPIO Community 0 ------- */

	/* ------- GPIO Group GPP_B ------- */

	/* GPP_B0 - PMC_CORE_VID0 */
	/* DW0: 0x44000700, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPP_B0, NONE, DEEP, NF1),

	/* GPP_B1 - PMC_CORE_VID1 */
	/* DW0: 0x44000700, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPP_B1, NONE, DEEP, NF1),

	/* GPP_B2 - ESPI_ALERT2_N */
	/* DW0: 0x44001302, DW1: 0x00003000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1) - IGNORED */
	PAD_CFG_NF(GPP_B2, UP_20K, DEEP, NF4),

	/* GPP_B3 - ESPI_ALERT0_N */
	/* DW0: 0x44001302, DW1: 0x00003000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1) - IGNORED */
	PAD_CFG_NF(GPP_B3, UP_20K, DEEP, NF4),

	PAD_NC(GPP_B4, NONE),
	PAD_NC(GPP_B5, NONE),
	PAD_NC(GPP_B6, NONE),
	PAD_NC(GPP_B7, NONE),
	PAD_NC(GPP_B8, NONE),
	PAD_NC(GPP_B9, NONE),

	/* GPP_B10 - ESPI_ALERT3_N */
	/* DW0: 0x44001302, DW1: 0x00003000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1) - IGNORED */
	PAD_CFG_NF(GPP_B10, UP_20K, DEEP, NF4),

	PAD_NC(GPP_B11, NONE),

	/* GPP_B12 - PMC_SLP_S0_N */
	/* DW0: 0x44000700, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPP_B12, NONE, DEEP, NF1),

	/* GPP_B13 - PMC_PLTRST_N */
	/* DW0: 0x44000700, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPP_B13, NONE, DEEP, NF1),

	/* GPP_B14 - SPKR */
	/* DW0: 0x84000700, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPP_B14, NONE, PLTRST, NF1),

	PAD_NC(GPP_B15, NONE),
	PAD_NC(GPP_B16, NONE),
	PAD_NC(GPP_B17, NONE),
	PAD_NC(GPP_B18, NONE),
	PAD_NC(GPP_B19, NONE),
	PAD_NC(GPP_B20, NONE),
	PAD_NC(GPP_B21, NONE),
	PAD_NC(GPP_B22, NONE),
	PAD_NC(GPP_B23, NONE),

	/* GPIO_RSVD_0 - n/a */
	/* DW0: 0x40000700, DW1: 0x00000000 */
	/* DW0: PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPIO_RSVD_0, NONE, DEEP, NF1),

	/* GPIO_RSVD_1 - n/a */
	/* DW0: 0x40000700, DW1: 0x00000000 */
	/* DW0: PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPIO_RSVD_1, NONE, DEEP, NF1),

	/* ------- GPIO Group GPP_T ------- */

	/* GPP_T0 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_T0, NONE),

	/* GPP_T1 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_T1, NONE),

	/* GPP_T2 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_T2, NONE),

	/* GPP_T3 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_T3, NONE),

	/* GPP_T4 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_T4, NONE),

	/* GPP_T5 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_T5, NONE),

	/* GPP_T6 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_T6, NONE),

	/* GPP_T7 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_T7, NONE),

	/* GPP_T8 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_T8, NONE),

	/* GPP_T9 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_T9, NONE),

	/* GPP_T10 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_T10, NONE),

	/* GPP_T11 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_T11, NONE),

	/* GPP_T12 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_T12, NONE),

	/* GPP_T13 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_T13, NONE),

	/* GPP_T14 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_T14, NONE),

	/* GPP_T15 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_T15, NONE),

	/* ------- GPIO Group GPP_G ------- */

	/* GPP_G0 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_G0, NONE),

	/* GPP_G1 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_G1, NONE),

	/* GPP_G2 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_G2, NONE),

	/* GPP_G3 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_G3, NONE),

	/* GPP_G4 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_G4, NONE),

	/* GPP_G5 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_G5, NONE),

	/* GPP_G6 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_G6, NONE),

	/* GPP_G7 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_G7, NONE),

	/* GPP_G8 - RSVD */
	/* DW0: 0x44000b00, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_NC(GPP_G8, NONE),

	/* GPP_G9 - RSVD */
	/* DW0: 0x44000b00, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_NC(GPP_G9, NONE),

	/* GPP_G10 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_G10, NONE),

	/* GPP_G11 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_G11, NONE),

	/* GPP_G12 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_G12, NONE),

	/* GPP_G13 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_G13, NONE),

	/* GPP_G14 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_G14, NONE),

	/* GPP_G15 - ESPI_IO0 */
	/* DW0: 0x44000700, DW1: 0x00003000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPP_G15, UP_20K, DEEP, NF1),

	/* GPP_G16 - ESPI_IO1 */
	/* DW0: 0x44000702, DW1: 0x00003000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1) - IGNORED */
	PAD_CFG_NF(GPP_G16, UP_20K, DEEP, NF1),

	/* GPP_G17 - ESPI_IO2 */
	/* DW0: 0x44000700, DW1: 0x00003000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPP_G17, UP_20K, DEEP, NF1),

	/* GPP_G18 - ESPI_IO3 */
	/* DW0: 0x44000700, DW1: 0x00003000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPP_G18, UP_20K, DEEP, NF1),

	/* GPP_G19 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_CFG_GPI_APIC_LOCK(GPP_G19, NONE, LEVEL, INVERT, LOCK_CONFIG),

	/* GPP_G20 - ESPI_CS0_N */
	/* DW0: 0x44000700, DW1: 0x00003000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPP_G20, UP_20K, DEEP, NF1),

	/* GPP_G21 - ESPI_CLK */
	/* DW0: 0x44000700, DW1: 0x00001000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPP_G21, DN_20K, DEEP, NF1),

	/* GPP_G22 - ESPI_RST0_N */
	/* DW0: 0x44000700, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPP_G22, NONE, DEEP, NF1),

	/* GPP_G23 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_G23, NONE),

	/* GPIO_RSVD_2 - n/a */
	/* DW0: 0x40000700, DW1: 0x00000000 */
	/* DW0: PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPIO_RSVD_2, NONE, DEEP, NF1),

	/* ------- GPIO Community 1 ------- */

	/* ------- GPIO Group GPP_V ------- */

	/* GPP_V0 - EMMC_CMD */
	/* DW0: 0x44000700, DW1: 0x00003000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPP_V0, UP_20K, DEEP, NF1),

	/* GPP_V1 - EMMC_DATA0 */
	/* DW0: 0x44000700, DW1: 0x00003000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPP_V1, UP_20K, DEEP, NF1),

	/* GPP_V2 - EMMC_DATA1 */
	/* DW0: 0x44000700, DW1: 0x00003000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPP_V2, UP_20K, DEEP, NF1),

	/* GPP_V3 - EMMC_DATA2 */
	/* DW0: 0x44000700, DW1: 0x00003000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPP_V3, UP_20K, DEEP, NF1),

	/* GPP_V4 - EMMC_DATA3 */
	/* DW0: 0x44000700, DW1: 0x00003000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPP_V4, UP_20K, DEEP, NF1),

	/* GPP_V5 - EMMC_DATA4 */
	/* DW0: 0x44000700, DW1: 0x00003000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPP_V5, UP_20K, DEEP, NF1),

	/* GPP_V6 - EMMC_DATA5 */
	/* DW0: 0x44000700, DW1: 0x00003000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPP_V6, UP_20K, DEEP, NF1),

	/* GPP_V7 - EMMC_DATA6 */
	/* DW0: 0x44000700, DW1: 0x00003000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPP_V7, UP_20K, DEEP, NF1),

	/* GPP_V8 - EMMC_DATA7 */
	/* DW0: 0x44000700, DW1: 0x00003000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPP_V8, UP_20K, DEEP, NF1),

	/* GPP_V9 - EMMC_RCLK */
	/* DW0: 0x44000700, DW1: 0x00001000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPP_V9, DN_20K, DEEP, NF1),

	/* GPP_V10 - EMMC_CLK */
	/* DW0: 0x44000700, DW1: 0x00001000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPP_V10, DN_20K, DEEP, NF1),

	/* GPP_V11 - EMMC_RST_N */
	/* DW0: 0x44000700, DW1: 0x00003000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPP_V11, UP_20K, DEEP, NF1),

	/* GPP_V12 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_V12, NONE),

	/* GPP_V13 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_V13, NONE),

	/* GPP_V14 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_V14, NONE),

	/* GPP_V15 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_V15, NONE),

	/* ------- GPIO Group GPP_H ------- */

	/* GPP_H0 - GPIO */
	/* DW0: 0x44000200, DW1: 0x00000000 */
	PAD_NC(GPP_H0, NONE),

	/* GPP_H1 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_H1, NONE),

	/* GPP_H2 - GPIO */
	/* DW0: 0x44000200, DW1: 0x00000000 */
	PAD_NC(GPP_H2, NONE),

	/* GPP_H3 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_H3, NONE),

	/* GPP_H4 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_H4, NONE),

	/* GPP_H5 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_H5, NONE),

	/* GPP_H6 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_H6, NONE),

	/* GPP_H7 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_H7, NONE),

	/* GPP_H8 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_H8, NONE),

	/* GPP_H9 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_H9, NONE),

	/* GPP_H10 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_CFG_GPIO_HI_Z(GPP_H10, NONE, DEEP, TxLASTRxE, SAME),

	/* GPP_H11 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_CFG_GPIO_HI_Z(GPP_H11, NONE, DEEP, TxLASTRxE, SAME),

	/* GPP_H12 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_H12, NONE),

	/* GPP_H13 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_H13, NONE),

	/* GPP_H14 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_H14, NONE),

	/* GPP_H15 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_H15, NONE),

	/* GPP_H16 - DDI2_DDC_SCL */
	/* DW0: 0x44000b02, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1) - IGNORED */
	PAD_CFG_NF(GPP_H16, NONE, DEEP, NF2),

	/* GPP_H17 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_H17, NONE),

	/* GPP_H18 - PMC_CPU_C10_GATE_N */
	/* DW0: 0x44000700, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_NC(GPP_H18, NONE),

	/* GPP_H19 - DDI2_DDC_SDA */
	/* DW0: 0x44000b02, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1) - IGNORED */
	PAD_CFG_NF(GPP_H19, NONE, DEEP, NF2),

	/* GPP_H20 - DDI2_HPD */
	/* DW0: 0x44000b02, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1) - IGNORED */
	PAD_CFG_NF(GPP_H20, NONE, DEEP, NF2),

	/* GPP_H21 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_H21, NONE),

	/* GPP_H22 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_H22, NONE),

	/* GPP_H23 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_H23, NONE),

	/* ------- GPIO Group GPP_D ------- */

	/* GPP_D0 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_D0, NONE),

	/* GPP_D1 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_D1, NONE),

	/* GPP_D2 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_D2, NONE),

	/* GPP_D3 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_D3, NONE),

	/* GPP_D4 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_D4, NONE),

	/* GPP_D5 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_D5, NONE),

	/* GPP_D6 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_D6, NONE),

	/* GPP_D7 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_D7, NONE),

	/* GPP_D8 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_D8, NONE),

	/* GPP_D9 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_D9, NONE),

	/* GPP_D10 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_D10, NONE),

	/* GPP_D11 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_D11, NONE),

	/* GPP_D12 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_D12, NONE),

	/* GPP_D13 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_D13, NONE),

	/* GPP_D14 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_D14, NONE),

	/* GPP_D15 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_D15, NONE),

	/* GPP_D16 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_D16, NONE),

	/* GPP_D17 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_D17, NONE),

	/* GPP_D18 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_D18, NONE),

	/* GPP_D19 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_D19, NONE),

	/* GPIO_RSVD_3 - n/a */
	/* DW0: 0x40000700, DW1: 0x00000000 */
	/* DW0: PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPIO_RSVD_3, NONE, DEEP, NF1),

	/* ------- GPIO Group GPP_U ------- */

	/* GPP_U0 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_U0, NONE),

	/* GPP_U1 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_U1, NONE),

	/* GPP_U2 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_U2, NONE),

	/* GPP_U3 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_U3, NONE),

	/* GPP_U4 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_U4, NONE),

	/* GPP_U5 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_U5, NONE),

	/* GPP_U6 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_U6, NONE),

	/* GPP_U7 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_U7, NONE),

	/* GPP_U8 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_U8, NONE),

	/* GPP_U9 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_U9, NONE),

	/* GPP_U10 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_U10, NONE),

	/* GPP_U11 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_U11, NONE),

	/* GPP_U12 - ISI_CHX_OKNOK_0 */
	/* DW0: 0x44000700, DW1: 0x00001000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_NC(GPP_U12, NONE),

	/* GPP_U13 - ISI_CHX_OKNOK_1 */
	/* DW0: 0x44000700, DW1: 0x00001000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_NC(GPP_U13, NONE),

	/* GPP_U14 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_U14, NONE),

	/* GPP_U15 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_U15, NONE),

	/* GPP_U16 - ISI_OKNOK_0 */
	/* DW0: 0x44600702, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1) - IGNORED */
	PAD_NC(GPP_U16, NONE),

	/* GPP_U17 - ISI_OKNOK_1 */
	/* DW0: 0x44600702, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1) - IGNORED */
	PAD_NC(GPP_U17, NONE),

	/* GPP_U18 - ISI_ALERT_N */
	/* DW0: 0x44600702, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1) - IGNORED */
	PAD_NC(GPP_U18, NONE),

	/* GPP_U19 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_U19, NONE),


	/* GPIO_RSVD_4 - n/a */
	/* DW0: 0x40000700, DW1: 0x00000000 */
	/* DW0: PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPIO_RSVD_4, NONE, DEEP, NF1),

	/* GPIO_RSVD_5 - n/a */
	/* DW0: 0x40000700, DW1: 0x00000000 */
	/* DW0: PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPIO_RSVD_5, NONE, DEEP, NF1),

	/* GPIO_RSVD_6 - n/a */
	/* DW0: 0x40000700, DW1: 0x00000000 */
	/* DW0: PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPIO_RSVD_6, NONE, DEEP, NF1),

	/* GPIO_RSVD_7 - n/a */
	/* DW0: 0x40000700, DW1: 0x00000000 */
	/* DW0: PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPIO_RSVD_7, NONE, DEEP, NF1),

	/* ------- GPIO Group GPP_VGPIO ------- */

	/* VGPIO_0 - GPIO */
	/* DW0: 0x40000000, DW1: 0x00000000 */
	PAD_CFG_GPIO_BIDIRECT(VGPIO_0, 0, NONE, DEEP, LEVEL, ACPI),

	/* VGPIO_4 - GPIO */
	/* DW0: 0x44000100, DW1: 0x00000000 */
	PAD_CFG_GPI_TRIG_OWN(VGPIO_4, NONE, DEEP, OFF, ACPI),

	/* VGPIO_5 - GPIO */
	/* DW0: 0x40000003, DW1: 0x00000000 */
	/* DW0: (1 << 1) - IGNORED */
	PAD_CFG_GPIO_BIDIRECT(VGPIO_5, 1, NONE, DEEP, LEVEL, ACPI),

	/* VGPIO_6 - GPIO */
	/* DW0: 0x40000000, DW1: 0x00000000 */
	PAD_CFG_GPIO_BIDIRECT(VGPIO_6, 0, NONE, DEEP, LEVEL, ACPI),

	/* VGPIO_7 - GPIO */
	/* DW0: 0x40000000, DW1: 0x00000000 */
	PAD_CFG_GPIO_BIDIRECT(VGPIO_7, 0, NONE, DEEP, LEVEL, ACPI),

	/* VGPIO_8 - GPIO */
	/* DW0: 0x40000000, DW1: 0x00000000 */
	PAD_CFG_GPIO_BIDIRECT(VGPIO_8, 0, NONE, DEEP, LEVEL, ACPI),

	/* VGPIO_9 - GPIO */
	/* DW0: 0x40000000, DW1: 0x00000000 */
	PAD_CFG_GPIO_BIDIRECT(VGPIO_9, 0, NONE, DEEP, LEVEL, ACPI),

	/* VGPIO_10 - GPIO */
	/* DW0: 0x40000000, DW1: 0x00000000 */
	PAD_CFG_GPIO_BIDIRECT(VGPIO_10, 0, NONE, DEEP, LEVEL, ACPI),

	/* VGPIO_11 - GPIO */
	/* DW0: 0x40000000, DW1: 0x00000000 */
	PAD_CFG_GPIO_BIDIRECT(VGPIO_11, 0, NONE, DEEP, LEVEL, ACPI),

	/* VGPIO_12 - GPIO */
	/* DW0: 0x40000000, DW1: 0x00000000 */
	PAD_CFG_GPIO_BIDIRECT(VGPIO_12, 0, NONE, DEEP, LEVEL, ACPI),

	/* VGPIO_13 - GPIO */
	/* DW0: 0x40000000, DW1: 0x00000000 */
	PAD_CFG_GPIO_BIDIRECT(VGPIO_13, 0, NONE, DEEP, LEVEL, ACPI),

	/* VGPIO_18 - GPIO */
	/* DW0: 0x40000000, DW1: 0x00000000 */
	PAD_CFG_GPIO_BIDIRECT(VGPIO_18, 0, NONE, DEEP, LEVEL, ACPI),

	/* VGPIO_19 - GPIO */
	/* DW0: 0x40000000, DW1: 0x00000000 */
	PAD_CFG_GPIO_BIDIRECT(VGPIO_19, 0, NONE, DEEP, LEVEL, ACPI),

	/* VGPIO_20 - GPIO */
	/* DW0: 0x40000000, DW1: 0x00000000 */
	PAD_CFG_GPIO_BIDIRECT(VGPIO_20, 0, NONE, DEEP, LEVEL, ACPI),

	/* VGPIO_21 - GPIO */
	/* DW0: 0x40000000, DW1: 0x00000000 */
	PAD_CFG_GPIO_BIDIRECT(VGPIO_21, 0, NONE, DEEP, LEVEL, ACPI),

	/* VGPIO_22 - GPIO */
	/* DW0: 0x40000000, DW1: 0x00000000 */
	PAD_CFG_GPIO_BIDIRECT(VGPIO_22, 0, NONE, DEEP, LEVEL, ACPI),

	/* VGPIO_23 - GPIO */
	/* DW0: 0x40000000, DW1: 0x00000000 */
	PAD_CFG_GPIO_BIDIRECT(VGPIO_23, 0, NONE, DEEP, LEVEL, ACPI),

	/* VGPIO_24 - GPIO */
	/* DW0: 0x40000000, DW1: 0x00000000 */
	PAD_CFG_GPIO_BIDIRECT(VGPIO_24, 0, NONE, DEEP, LEVEL, ACPI),

	/* VGPIO_25 - GPIO */
	/* DW0: 0x40000000, DW1: 0x00000000 */
	PAD_CFG_GPIO_BIDIRECT(VGPIO_25, 0, NONE, DEEP, LEVEL, ACPI),

	/* VGPIO_30 - GPIO */
	/* DW0: 0x40000000, DW1: 0x00000000 */
	PAD_CFG_GPIO_BIDIRECT(VGPIO_30, 0, NONE, DEEP, LEVEL, ACPI),

	/* VGPIO_31 - GPIO */
	/* DW0: 0x40000000, DW1: 0x00000000 */
	PAD_CFG_GPIO_BIDIRECT(VGPIO_31, 0, NONE, DEEP, LEVEL, ACPI),

	/* VGPIO_32 - GPIO */
	/* DW0: 0x40000000, DW1: 0x00000000 */
	PAD_CFG_GPIO_BIDIRECT(VGPIO_32, 0, NONE, DEEP, LEVEL, ACPI),

	/* VGPIO_33 - GPIO */
	/* DW0: 0x40000000, DW1: 0x00000000 */
	PAD_CFG_GPIO_BIDIRECT(VGPIO_33, 0, NONE, DEEP, LEVEL, ACPI),

	/* VGPIO_34 - GPIO */
	/* DW0: 0x40000000, DW1: 0x00000000 */
	PAD_CFG_GPIO_BIDIRECT(VGPIO_34, 0, NONE, DEEP, LEVEL, ACPI),

	/* VGPIO_35 - GPIO */
	/* DW0: 0x40000000, DW1: 0x00000000 */
	PAD_CFG_GPIO_BIDIRECT(VGPIO_35, 0, NONE, DEEP, LEVEL, ACPI),

	/* VGPIO_36 - GPIO */
	/* DW0: 0x40000000, DW1: 0x00000000 */
	PAD_CFG_GPIO_BIDIRECT(VGPIO_36, 0, NONE, DEEP, LEVEL, ACPI),

	/* VGPIO_37 - GPIO */
	/* DW0: 0x40000000, DW1: 0x00000000 */
	PAD_CFG_GPIO_BIDIRECT(VGPIO_37, 0, NONE, DEEP, LEVEL, ACPI),

	/* VGPIO_39 - GPIO */
	/* DW0: 0x44000000, DW1: 0x00000000 */
	PAD_CFG_GPIO_BIDIRECT(VGPIO_39, 0, NONE, DEEP, OFF, ACPI),

	/* ------- GPIO Community 2 ------- */

	/* ------- GPIO Group GPD ------- */

	/* GPD0 - GPIO */
	/* DW0: 0x04000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_CFG_GPIO_HI_Z(GPD0, NONE, PWROK, TxLASTRxE, SAME),

	/* GPD1 - PMC_ACPRESENT */
	/* DW0: 0x04000702, DW1: 0x00003c00 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1) - IGNORED */
	PAD_CFG_NF(GPD1, NATIVE, PWROK, NF1),

	/* GPD2 - RSVD */
	/* DW0: 0x04000702, DW1: 0x00003c00 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1) - IGNORED */
	PAD_CFG_NF(GPD2, NATIVE, PWROK, NF1),

	/* GPD3 - PMC_PWRBTN_N */
	/* DW0: 0x04000702, DW1: 0x00003000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1) - IGNORED */
	PAD_CFG_NF(GPD3, UP_20K, PWROK, NF1),

	/* GPD4 - PMC_SLP_S3_N */
	/* DW0: 0x04000600, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPD4, NONE, PWROK, NF1),

	/* GPD5 - PMC_SLP_S4_N */
	/* DW0: 0x04000600, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPD5, NONE, PWROK, NF1),

	/* GPD7 - n/a */
	/* DW0: 0x04000600, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPD7, NONE, PWROK, NF1),

	/* GPD8 - GPIO */
	/* DW0: 0x04000200, DW1: 0x00000000 */
	PAD_CFG_GPO(GPD8, 0, PWROK),

	/* GPD9 - RSVD */
	/* DW0: 0x04000700, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPD9, NONE, PWROK, NF1),

	/* GPD10 - GPIO */
	/* DW0: 0x04000200, DW1: 0x00000000 */
	PAD_CFG_GPO(GPD10, 0, PWROK),

	/* GPD11 - RSVD */
	/* DW0: 0x04000600, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPD11, NONE, PWROK, NF1),

	/* GPIO_RSVD_8 - GPIO */
	/* DW0: 0x04000200, DW1: 0x00000000 */
	PAD_CFG_GPO(GPIO_RSVD_8, 0, PWROK),

	/* GPIO_RSVD_9 - n/a */
	/* DW0: 0x00000700, DW1: 0x00000000 */
	/* DW0: PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPIO_RSVD_9, NONE, PWROK, NF1),

	/* GPIO_RSVD_10 - n/a */
	/* DW0: 0x00000700, DW1: 0x00000000 */
	/* DW0: PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPIO_RSVD_10, NONE, PWROK, NF1),

	/* GPIO_RSVD_11 - n/a */
	/* DW0: 0x00000700, DW1: 0x00000000 */
	/* DW0: PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPIO_RSVD_11, NONE, PWROK, NF1),

	/* GPIO_RSVD_12 - n/a */
	/* DW0: 0x00000702, DW1: 0x00000000 */
	/* DW0: PAD_BUF(TX_RX_DISABLE) | (1 << 1) - IGNORED */
	PAD_CFG_NF(GPIO_RSVD_12, NONE, PWROK, NF1),

	/* ------- GPIO Community 3 ------- */

	/* ------- GPIO Group GPP_S ------- */

	/* GPIO_RSVD_13 - n/a */
	/* DW0: 0x40000700, DW1: 0x00003c00 */
	/* DW0: PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPIO_RSVD_13, NATIVE, DEEP, NF1),

	/* GPIO_RSVD_14 - n/a */
	/* DW0: 0x40000700, DW1: 0x00003c00 */
	/* DW0: PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPIO_RSVD_14, NATIVE, DEEP, NF1),

	/* GPIO_RSVD_15 - n/a */
	/* DW0: 0x40000700, DW1: 0x00000000 */
	/* DW0: PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPIO_RSVD_15, NONE, DEEP, NF1),

	/* GPIO_RSVD_16 - n/a */
	/* DW0: 0x40000700, DW1: 0x00000000 */
	/* DW0: PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPIO_RSVD_16, NONE, DEEP, NF1),

	/* GPIO_RSVD_17 - GPIO */
	/* DW0: 0x40000300, DW1: 0x00000000 */
	PAD_CFG_GPIO_HI_Z(GPIO_RSVD_17, NONE, DEEP, TxLASTRxE, SAME),

	/* GPIO_RSVD_18 - n/a */
	/* DW0: 0x40000700, DW1: 0x00000000 */
	/* DW0: PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPIO_RSVD_18, NONE, DEEP, NF1),

	/* GPIO_RSVD_19 - n/a */
	/* DW0: 0x40000702, DW1: 0x00000000 */
	/* DW0: PAD_BUF(TX_RX_DISABLE) | (1 << 1) - IGNORED */
	PAD_CFG_NF(GPIO_RSVD_19, NONE, DEEP, NF1),

	/* GPIO_RSVD_20 - n/a */
	/* DW0: 0x40000700, DW1: 0x00000000 */
	/* DW0: PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPIO_RSVD_20, NONE, DEEP, NF1),

	/* GPIO_RSVD_21 - n/a */
	/* DW0: 0x40000700, DW1: 0x00000000 */
	/* DW0: PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPIO_RSVD_21, NONE, DEEP, NF1),

	/* GPIO_RSVD_22 - n/a */
	/* DW0: 0x40000700, DW1: 0x0003d000 */
	/* DW0: PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF_IOSTANDBY_IGNORE(GPIO_RSVD_22, DN_20K, DEEP, NF1),

	/* GPIO_RSVD_23 - n/a */
	/* DW0: 0x40000700, DW1: 0x0003d000 */
	/* DW0: PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF_IOSTANDBY_IGNORE(GPIO_RSVD_23, DN_20K, DEEP, NF1),

	/* GPIO_RSVD_24 - n/a */
	/* DW0: 0x40000700, DW1: 0x00000000 */
	/* DW0: PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPIO_RSVD_24, NONE, DEEP, NF1),

	/* GPIO_RSVD_25 - n/a */
	/* DW0: 0x40000700, DW1: 0x00000000 */
	/* DW0: PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPIO_RSVD_25, NONE, DEEP, NF1),

	/* GPIO_RSVD_26 - n/a */
	/* DW0: 0x40000700, DW1: 0x00000000 */
	/* DW0: PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPIO_RSVD_26, NONE, DEEP, NF1),

	/* GPIO_RSVD_27 - GPIO */
	/* DW0: 0x40000300, DW1: 0x00000000 */
	PAD_CFG_GPIO_HI_Z(GPIO_RSVD_27, NONE, DEEP, TxLASTRxE, SAME),

	/* GPIO_RSVD_28 - n/a */
	/* DW0: 0x40000702, DW1: 0x00000000 */
	/* DW0: PAD_BUF(TX_RX_DISABLE) | (1 << 1) - IGNORED */
	PAD_CFG_NF(GPIO_RSVD_28, NONE, DEEP, NF1),

	/* GPIO_RSVD_29 - n/a */
	/* DW0: 0x40000702, DW1: 0x00000000 */
	/* DW0: PAD_BUF(TX_RX_DISABLE) | (1 << 1) - IGNORED */
	PAD_CFG_NF(GPIO_RSVD_29, NONE, DEEP, NF1),

	/* GPP_S0 - n/a */
	/* DW0: 0x40000700, DW1: 0x00001000 */
	/* DW0: PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPP_S0, DN_20K, DEEP, NF1),

	/* GPP_S1 - n/a */
	/* DW0: 0x40000700, DW1: 0x00001000 */
	/* DW0: PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPP_S1, DN_20K, DEEP, NF1),

	/* ------- GPIO Group GPP_A ------- */

	/* GPP_A0 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_CFG_GPIO_HI_Z(GPP_A0, NONE, DEEP, TxLASTRxE, SAME),

	/* GPP_A1 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_CFG_GPIO_HI_Z(GPP_A1, NONE, DEEP, TxLASTRxE, SAME),

	/* GPP_A2 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_CFG_GPIO_HI_Z(GPP_A2, NONE, DEEP, TxLASTRxE, SAME),

	/* GPP_A3 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_CFG_GPIO_HI_Z(GPP_A3, NONE, DEEP, TxLASTRxE, SAME),

	/* GPP_A4 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_A4, NONE),

	/* GPP_A5 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_A5, NONE),

	/* GPP_A6 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_A6, NONE),

	/* GPP_A7 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_A7, NONE),

	/* GPP_A8 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_A8, NONE),

	/* GPP_A9 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_A9, NONE),

	/* GPP_A10 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_A10, NONE),

	/* GPP_A11 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_A11, NONE),

	/* GPP_A12 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_A12, NONE),

	/* GPP_A13 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_A13, NONE),

	/* GPP_A14 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_A14, NONE),

	/* GPP_A15 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_A15, NONE),

	/* GPP_A16 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_A16, NONE),

	/* GPP_A17 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_A17, NONE),

	/* GPP_A18 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_A18, NONE),

	/* GPP_A19 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_A19, NONE),

	/* GPP_A20 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_A20, NONE),

	/* GPP_A21 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_A21, NONE),

	/* GPP_A22 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_A22, NONE),

	/* GPP_A23 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_A23, NONE),

	/* ------- GPIO Group GPP_VGPIO_USB ------- */

	/* VGPIO_USB_0 - n/a */
	/* DW0: 0x40000400, DW1: 0x00000000 */
	PAD_CFG_NF(VGPIO_USB_0, NONE, DEEP, NF1),

	/* VGPIO_USB_1 - n/a */
	/* DW0: 0x40000400, DW1: 0x00000000 */
	PAD_CFG_NF(VGPIO_USB_1, NONE, DEEP, NF1),

	/* VGPIO_USB_2 - n/a */
	/* DW0: 0x40000400, DW1: 0x00000000 */
	PAD_CFG_NF(VGPIO_USB_2, NONE, DEEP, NF1),

	/* VGPIO_USB_3 - n/a */
	/* DW0: 0x40000400, DW1: 0x00000000 */
	PAD_CFG_NF(VGPIO_USB_3, NONE, DEEP, NF1),

	/* ------- GPIO Community 4 ------- */

	/* ------- GPIO Group GPP_C ------- */

	/* GPP_C0 - SMB_CLK */
	/* DW0: 0x44000702, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1) - IGNORED */
	PAD_CFG_NF(GPP_C0, NONE, DEEP, NF1),

	/* GPP_C1 - SMB_DATA */
	/* DW0: 0x44000702, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1) - IGNORED */
	PAD_CFG_NF(GPP_C1, NONE, DEEP, NF1),

	/* GPP_C2 - SMB_ALERT_N */
	/* DW0: 0x44000a02, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(RX_DISABLE) | (1 << 1) - IGNORED */
	PAD_CFG_NF(GPP_C2, NONE, DEEP, NF2),

	/* GPP_C3 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_C3, NONE),

	/* GPP_C4 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_C4, NONE),

	/* GPP_C5 - GPIO */
	/* DW0: 0x44000200, DW1: 0x00000000 */
	PAD_NC(GPP_C5, NONE),

	/* GPP_C6 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_C6, NONE),

	/* GPP_C7 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_C7, NONE),

	/* GPP_C8 - DNX_FORCE_RELOAD */
	/* DW0: 0x44000b00, DW1: 0x00001000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_NC(GPP_C8, NONE),

	/* GPP_C9 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_C9, NONE),

	/* GPP_C10 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_C10, NONE),

	/* GPP_C11 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_C11, NONE),

	/* GPP_C12 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_C12, NONE),

	/* GPP_C13 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_C13, NONE),

	/* GPP_C14 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_C14, NONE),

	/* GPP_C15 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_C15, NONE),

	/* GPP_C16 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_C16, NONE),

	/* GPP_C17 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_C17, NONE),

	/* GPP_C18 - SML_DATA0 */
	/* DW0: 0x04000f02, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1) - IGNORED */
	PAD_NC(GPP_C18, NONE),

	/* GPP_C19 - SML_CLK0 */
	/* DW0: 0x04000f02, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1) - IGNORED */
	PAD_NC(GPP_C19, NONE),

	/* GPP_C20 - SIO_UART2_RXD */
	/* DW0: 0x44001302, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1) - IGNORED */
	PAD_NC(GPP_C20, NONE),

	/* GPP_C21 - SIO_UART2_TXD */
	/* DW0: 0x44001300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_NC(GPP_C21, NONE),

	/* GPP_C22 - SIO_UART2_RTS_N */
	/* DW0: 0x44001300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_NC(GPP_C22, NONE),

	/* GPP_C23 - SIO_UART2_CTS_N */
	/* DW0: 0x44001302, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1) - IGNORED */
	PAD_NC(GPP_C23, NONE),

	/* ------- GPIO Group GPP_F ------- */

	/* GPP_F0 - RSVD */
	/* DW0: 0x44000700, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_NC(GPP_F0, NONE),

	/* GPP_F1 - RSVD */
	/* DW0: 0x44000700, DW1: 0x00003000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_NC(GPP_F1, NONE),

	/* GPP_F2 - RSVD */
	/* DW0: 0x44000700, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_NC(GPP_F2, NONE),

	/* GPP_F3 - RSVD */
	/* DW0: 0x44000700, DW1: 0x00003000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_NC(GPP_F3, NONE),

	/* GPP_F4 - RSVD */
	/* DW0: 0x44000700, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_NC(GPP_F4, NONE),

	/* GPP_F5 - RSVD */
	/* DW0: 0x44000700, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_NC(GPP_F5, NONE),

	/* GPP_F6 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_F6, NONE),

	/* GPP_F7 - GPIO */
	/* DW0: 0x44000200, DW1: 0x00000000 */
	PAD_NC(GPP_F7, NONE),

	/* GPP_F8 - ISI_TRACEDATA_0 */
	/* DW0: 0x44001700, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_NC(GPP_F8, NONE),

	/* GPP_F9 - BOOT_PWR_EN */
	/* DW0: 0x44000700, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_NC(GPP_F9, NONE),

	/* GPP_F10 - GPIO */
	/* DW0: 0x44000200, DW1: 0x00000000 */
	PAD_NC(GPP_F10, NONE),

	/* GPP_F11 - ISI_TRACECLK */
	/* DW0: 0x44001700, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_NC(GPP_F11, NONE),

	/* GPP_F12 - ISI_TRACESWO */
	/* DW0: 0x44001700, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_NC(GPP_F12, NONE),

	/* GPP_F13 - ISI_SWDIO */
	/* DW0: 0x44001702, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1) - IGNORED */
	PAD_NC(GPP_F13, NONE),

	/* GPP_F14 - ISI_TRACEDATA_1 */
	/* DW0: 0x44001700, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_NC(GPP_F14, NONE),

	/* GPP_F15 - ISI_TRACEDATA_2 */
	/* DW0: 0x44001700, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_NC(GPP_F15, NONE),

	/* GPP_F16 - ISI_SWCLK */
	/* DW0: 0x44001702, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1) - IGNORED */
	PAD_NC(GPP_F16, NONE),

	/* GPP_F17 - ISI_TRACEDATA_3 */
	/* DW0: 0x44001700, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_NC(GPP_F17, NONE),

	/* GPP_F18 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_F18, NONE),

	/* GPP_F19 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_F19, NONE),

	/* GPP_F20 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_F20, NONE),

	/* GPP_F21 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_F21, NONE),

	/* GPP_F22 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_F22, NONE),

	/* GPP_F23 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_F23, NONE),

	/* GPIO_RSVD_30 - n/a */
	/* DW0: 0x40000f00, DW1: 0x00000000 */
	/* DW0: PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPIO_RSVD_30, NONE, DEEP, NF3),

	/* GPIO_RSVD_31 - n/a */
	/* DW0: 0x40000700, DW1: 0x00000000 */
	/* DW0: PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPIO_RSVD_31, NONE, DEEP, NF1),

	/* GPIO_RSVD_32 - n/a */
	/* DW0: 0x40000700, DW1: 0x00000000 */
	/* DW0: PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPIO_RSVD_32, NONE, DEEP, NF1),

	/* GPIO_RSVD_33 - n/a */
	/* DW0: 0x40000700, DW1: 0x00000000 */
	/* DW0: PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPIO_RSVD_33, NONE, DEEP, NF1),

	/* GPIO_RSVD_34 - n/a */
	/* DW0: 0x40000702, DW1: 0x00000000 */
	/* DW0: PAD_BUF(TX_RX_DISABLE) | (1 << 1) - IGNORED */
	PAD_CFG_NF(GPIO_RSVD_34, NONE, DEEP, NF1),

	/* GPIO_RSVD_35 - n/a */
	/* DW0: 0x40000702, DW1: 0x00000000 */
	/* DW0: PAD_BUF(TX_RX_DISABLE) | (1 << 1) - IGNORED */
	PAD_CFG_NF(GPIO_RSVD_35, NONE, DEEP, NF1),

	/* GPIO_RSVD_36 - GPIO */
	/* DW0: 0x40000300, DW1: 0x00000000 */
	PAD_CFG_GPIO_HI_Z(GPIO_RSVD_36, NONE, DEEP, TxLASTRxE, SAME),

	/* ------- GPIO Group GPP_E ------- */

	/* GPP_E0 - SATA_LED_N */
	/* DW0: 0x84000700, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPP_E0, NONE, PLTRST, NF1),

	/* GPP_E1 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_E1, NONE),

	/* GPP_E2 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_E2, NONE),

	/* GPP_E3 - DDI1_HPD */
	/* DW0: 0x44000700, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPP_E3, NONE, DEEP, NF1),

	/* GPP_E4 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_E4, NONE),

	/* GPP_E5 - DDI1_DDC_SDA */
	/* DW0: 0x44000702, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1) - IGNORED */
	PAD_CFG_NF(GPP_E5, NONE, DEEP, NF1),

	/* GPP_E6 - GPIO */
	/* DW0: 0x44000200, DW1: 0x00000000 */
	PAD_NC(GPP_E6, NONE),

	/* GPP_E7 - DDI1_DDC_SCL */
	/* DW0: 0x44000700, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPP_E7, NONE, DEEP, NF1),

	/* GPP_E8 - SATA_1_DEVSLP */
	/* DW0: 0x04000b00, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_NC(GPP_E8, NONE),

	/* GPP_E9 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_E9, NONE),

	/* GPP_E10 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_E10, NONE),

	/* GPP_E11 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_E11, NONE),

	/* GPP_E12 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_E12, NONE),

	/* GPP_E13 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_E13, NONE),

	/* GPP_E14 - DDI0_HPD */
	/* DW0: 0x44000702, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1) - IGNORED */
	PAD_CFG_NF(GPP_E14, NONE, DEEP, NF1),

	/* GPP_E15 - RSVD */
	/* DW0: 0x44000b00, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_NC(GPP_E15, NONE),

	/* GPP_E16 - RSVD */
	/* DW0: 0x44000b00, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_NC(GPP_E16, NONE),

	/* GPP_E17 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_E17, NONE),

	/* GPP_E18 - DDI0_DDC_SDA */
	/* DW0: 0x44000702, DW1: 0x00003c00 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1) - IGNORED */
	PAD_CFG_NF(GPP_E18, NATIVE, DEEP, NF1),

	/* GPP_E19 - DDI0_DDC_SCL */
	/* DW0: 0x44000600, DW1: 0x00003c00 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPP_E19, NATIVE, DEEP, NF1),

	/* GPP_E20 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_E20, NONE),

	/* GPP_E21 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_E21, NONE),

	/* GPP_E22 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_E22, NONE),

	/* GPP_E23 - GPIO */
	/* DW0: 0x44000200, DW1: 0x00000000 */
	PAD_NC(GPP_E23, NONE),

	/* ------- GPIO Community 5 ------- */

	/* ------- GPIO Group GPP_R ------- */

	/* GPP_R0 - HDA_BCLK */
	/* DW0: 0x44000700, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPP_R0, NONE, DEEP, NF1),

	/* GPP_R1 - HDA_SYNC */
	/* DW0: 0x44000700, DW1: 0x00003c00 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPP_R1, NATIVE, DEEP, NF1),

	/* GPP_R2 - HDA_SDO */
	/* DW0: 0x44000600, DW1: 0x00003c00 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPP_R2, NATIVE, DEEP, NF1),

	/* GPP_R3 - HDA_SDI0 */
	/* DW0: 0x44000700, DW1: 0x00003c00 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPP_R3, NATIVE, DEEP, NF1),

	/* GPP_R4 - HDA_RST_N */
	/* DW0: 0x44000700, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) - IGNORED */
	PAD_CFG_NF(GPP_R4, NONE, DEEP, NF1),

	/* GPP_R5 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_R5, NONE),

	/* GPP_R6 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_R6, NONE),

	/* GPP_R7 - GPIO */
	/* DW0: 0x44000300, DW1: 0x00000000 */
	/* DW0: PAD_TRIG(OFF) - IGNORED */
	PAD_NC(GPP_R7, NONE),

};

#endif /* CFG_GPIO_H */
