//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/logz/armlogz"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
)

// SubAccountServer is a fake server for instances of the armlogz.SubAccountClient type.
type SubAccountServer struct {
	// BeginCreate is the fake for method SubAccountClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreate func(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, options *armlogz.SubAccountClientBeginCreateOptions) (resp azfake.PollerResponder[armlogz.SubAccountClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method SubAccountClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, options *armlogz.SubAccountClientBeginDeleteOptions) (resp azfake.PollerResponder[armlogz.SubAccountClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method SubAccountClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, options *armlogz.SubAccountClientGetOptions) (resp azfake.Responder[armlogz.SubAccountClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method SubAccountClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, monitorName string, options *armlogz.SubAccountClientListOptions) (resp azfake.PagerResponder[armlogz.SubAccountClientListResponse])

	// NewListMonitoredResourcesPager is the fake for method SubAccountClient.NewListMonitoredResourcesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListMonitoredResourcesPager func(resourceGroupName string, monitorName string, subAccountName string, options *armlogz.SubAccountClientListMonitoredResourcesOptions) (resp azfake.PagerResponder[armlogz.SubAccountClientListMonitoredResourcesResponse])

	// NewListVMHostUpdatePager is the fake for method SubAccountClient.NewListVMHostUpdatePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListVMHostUpdatePager func(resourceGroupName string, monitorName string, subAccountName string, options *armlogz.SubAccountClientListVMHostUpdateOptions) (resp azfake.PagerResponder[armlogz.SubAccountClientListVMHostUpdateResponse])

	// NewListVMHostsPager is the fake for method SubAccountClient.NewListVMHostsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListVMHostsPager func(resourceGroupName string, monitorName string, subAccountName string, options *armlogz.SubAccountClientListVMHostsOptions) (resp azfake.PagerResponder[armlogz.SubAccountClientListVMHostsResponse])

	// Update is the fake for method SubAccountClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, options *armlogz.SubAccountClientUpdateOptions) (resp azfake.Responder[armlogz.SubAccountClientUpdateResponse], errResp azfake.ErrorResponder)

	// VMHostPayload is the fake for method SubAccountClient.VMHostPayload
	// HTTP status codes to indicate success: http.StatusOK
	VMHostPayload func(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, options *armlogz.SubAccountClientVMHostPayloadOptions) (resp azfake.Responder[armlogz.SubAccountClientVMHostPayloadResponse], errResp azfake.ErrorResponder)
}

// NewSubAccountServerTransport creates a new instance of SubAccountServerTransport with the provided implementation.
// The returned SubAccountServerTransport instance is connected to an instance of armlogz.SubAccountClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSubAccountServerTransport(srv *SubAccountServer) *SubAccountServerTransport {
	return &SubAccountServerTransport{
		srv:                            srv,
		beginCreate:                    newTracker[azfake.PollerResponder[armlogz.SubAccountClientCreateResponse]](),
		beginDelete:                    newTracker[azfake.PollerResponder[armlogz.SubAccountClientDeleteResponse]](),
		newListPager:                   newTracker[azfake.PagerResponder[armlogz.SubAccountClientListResponse]](),
		newListMonitoredResourcesPager: newTracker[azfake.PagerResponder[armlogz.SubAccountClientListMonitoredResourcesResponse]](),
		newListVMHostUpdatePager:       newTracker[azfake.PagerResponder[armlogz.SubAccountClientListVMHostUpdateResponse]](),
		newListVMHostsPager:            newTracker[azfake.PagerResponder[armlogz.SubAccountClientListVMHostsResponse]](),
	}
}

// SubAccountServerTransport connects instances of armlogz.SubAccountClient to instances of SubAccountServer.
// Don't use this type directly, use NewSubAccountServerTransport instead.
type SubAccountServerTransport struct {
	srv                            *SubAccountServer
	beginCreate                    *tracker[azfake.PollerResponder[armlogz.SubAccountClientCreateResponse]]
	beginDelete                    *tracker[azfake.PollerResponder[armlogz.SubAccountClientDeleteResponse]]
	newListPager                   *tracker[azfake.PagerResponder[armlogz.SubAccountClientListResponse]]
	newListMonitoredResourcesPager *tracker[azfake.PagerResponder[armlogz.SubAccountClientListMonitoredResourcesResponse]]
	newListVMHostUpdatePager       *tracker[azfake.PagerResponder[armlogz.SubAccountClientListVMHostUpdateResponse]]
	newListVMHostsPager            *tracker[azfake.PagerResponder[armlogz.SubAccountClientListVMHostsResponse]]
}

// Do implements the policy.Transporter interface for SubAccountServerTransport.
func (s *SubAccountServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SubAccountClient.BeginCreate":
		resp, err = s.dispatchBeginCreate(req)
	case "SubAccountClient.BeginDelete":
		resp, err = s.dispatchBeginDelete(req)
	case "SubAccountClient.Get":
		resp, err = s.dispatchGet(req)
	case "SubAccountClient.NewListPager":
		resp, err = s.dispatchNewListPager(req)
	case "SubAccountClient.NewListMonitoredResourcesPager":
		resp, err = s.dispatchNewListMonitoredResourcesPager(req)
	case "SubAccountClient.NewListVMHostUpdatePager":
		resp, err = s.dispatchNewListVMHostUpdatePager(req)
	case "SubAccountClient.NewListVMHostsPager":
		resp, err = s.dispatchNewListVMHostsPager(req)
	case "SubAccountClient.Update":
		resp, err = s.dispatchUpdate(req)
	case "SubAccountClient.VMHostPayload":
		resp, err = s.dispatchVMHostPayload(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SubAccountServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if s.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := s.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Logz/monitors/(?P<monitorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/accounts/(?P<subAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armlogz.MonitorResource](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		monitorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("monitorName")])
		if err != nil {
			return nil, err
		}
		subAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("subAccountName")])
		if err != nil {
			return nil, err
		}
		var options *armlogz.SubAccountClientBeginCreateOptions
		if !reflect.ValueOf(body).IsZero() {
			options = &armlogz.SubAccountClientBeginCreateOptions{
				Body: &body,
			}
		}
		respr, errRespr := s.srv.BeginCreate(req.Context(), resourceGroupNameParam, monitorNameParam, subAccountNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		s.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		s.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		s.beginCreate.remove(req)
	}

	return resp, nil
}

func (s *SubAccountServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if s.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := s.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Logz/monitors/(?P<monitorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/accounts/(?P<subAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		monitorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("monitorName")])
		if err != nil {
			return nil, err
		}
		subAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("subAccountName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginDelete(req.Context(), resourceGroupNameParam, monitorNameParam, subAccountNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		s.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		s.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		s.beginDelete.remove(req)
	}

	return resp, nil
}

func (s *SubAccountServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Logz/monitors/(?P<monitorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/accounts/(?P<subAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	monitorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("monitorName")])
	if err != nil {
		return nil, err
	}
	subAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("subAccountName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), resourceGroupNameParam, monitorNameParam, subAccountNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).MonitorResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SubAccountServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := s.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Logz/monitors/(?P<monitorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/accounts`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		monitorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("monitorName")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListPager(resourceGroupNameParam, monitorNameParam, nil)
		newListPager = &resp
		s.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armlogz.SubAccountClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		s.newListPager.remove(req)
	}
	return resp, nil
}

func (s *SubAccountServerTransport) dispatchNewListMonitoredResourcesPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListMonitoredResourcesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListMonitoredResourcesPager not implemented")}
	}
	newListMonitoredResourcesPager := s.newListMonitoredResourcesPager.get(req)
	if newListMonitoredResourcesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Logz/monitors/(?P<monitorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/accounts/(?P<subAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listMonitoredResources`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		monitorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("monitorName")])
		if err != nil {
			return nil, err
		}
		subAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("subAccountName")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListMonitoredResourcesPager(resourceGroupNameParam, monitorNameParam, subAccountNameParam, nil)
		newListMonitoredResourcesPager = &resp
		s.newListMonitoredResourcesPager.add(req, newListMonitoredResourcesPager)
		server.PagerResponderInjectNextLinks(newListMonitoredResourcesPager, req, func(page *armlogz.SubAccountClientListMonitoredResourcesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListMonitoredResourcesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListMonitoredResourcesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListMonitoredResourcesPager) {
		s.newListMonitoredResourcesPager.remove(req)
	}
	return resp, nil
}

func (s *SubAccountServerTransport) dispatchNewListVMHostUpdatePager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListVMHostUpdatePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListVMHostUpdatePager not implemented")}
	}
	newListVMHostUpdatePager := s.newListVMHostUpdatePager.get(req)
	if newListVMHostUpdatePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Logz/monitors/(?P<monitorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/accounts/(?P<subAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/vmHostUpdate`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armlogz.VMHostUpdateRequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		monitorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("monitorName")])
		if err != nil {
			return nil, err
		}
		subAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("subAccountName")])
		if err != nil {
			return nil, err
		}
		var options *armlogz.SubAccountClientListVMHostUpdateOptions
		if !reflect.ValueOf(body).IsZero() {
			options = &armlogz.SubAccountClientListVMHostUpdateOptions{
				Body: &body,
			}
		}
		resp := s.srv.NewListVMHostUpdatePager(resourceGroupNameParam, monitorNameParam, subAccountNameParam, options)
		newListVMHostUpdatePager = &resp
		s.newListVMHostUpdatePager.add(req, newListVMHostUpdatePager)
		server.PagerResponderInjectNextLinks(newListVMHostUpdatePager, req, func(page *armlogz.SubAccountClientListVMHostUpdateResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListVMHostUpdatePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListVMHostUpdatePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListVMHostUpdatePager) {
		s.newListVMHostUpdatePager.remove(req)
	}
	return resp, nil
}

func (s *SubAccountServerTransport) dispatchNewListVMHostsPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListVMHostsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListVMHostsPager not implemented")}
	}
	newListVMHostsPager := s.newListVMHostsPager.get(req)
	if newListVMHostsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Logz/monitors/(?P<monitorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/accounts/(?P<subAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listVMHosts`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		monitorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("monitorName")])
		if err != nil {
			return nil, err
		}
		subAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("subAccountName")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListVMHostsPager(resourceGroupNameParam, monitorNameParam, subAccountNameParam, nil)
		newListVMHostsPager = &resp
		s.newListVMHostsPager.add(req, newListVMHostsPager)
		server.PagerResponderInjectNextLinks(newListVMHostsPager, req, func(page *armlogz.SubAccountClientListVMHostsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListVMHostsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListVMHostsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListVMHostsPager) {
		s.newListVMHostsPager.remove(req)
	}
	return resp, nil
}

func (s *SubAccountServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if s.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Logz/monitors/(?P<monitorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/accounts/(?P<subAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armlogz.MonitorResourceUpdateParameters](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	monitorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("monitorName")])
	if err != nil {
		return nil, err
	}
	subAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("subAccountName")])
	if err != nil {
		return nil, err
	}
	var options *armlogz.SubAccountClientUpdateOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armlogz.SubAccountClientUpdateOptions{
			Body: &body,
		}
	}
	respr, errRespr := s.srv.Update(req.Context(), resourceGroupNameParam, monitorNameParam, subAccountNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).MonitorResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SubAccountServerTransport) dispatchVMHostPayload(req *http.Request) (*http.Response, error) {
	if s.srv.VMHostPayload == nil {
		return nil, &nonRetriableError{errors.New("fake for method VMHostPayload not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Logz/monitors/(?P<monitorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/accounts/(?P<subAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/vmHostPayload`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	monitorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("monitorName")])
	if err != nil {
		return nil, err
	}
	subAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("subAccountName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.VMHostPayload(req.Context(), resourceGroupNameParam, monitorNameParam, subAccountNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).VMExtensionPayload, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
