//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/managedservices/armmanagedservices"
	"net/http"
	"net/url"
	"regexp"
)

// MarketplaceRegistrationDefinitionsWithoutScopeServer is a fake server for instances of the armmanagedservices.MarketplaceRegistrationDefinitionsWithoutScopeClient type.
type MarketplaceRegistrationDefinitionsWithoutScopeServer struct {
	// Get is the fake for method MarketplaceRegistrationDefinitionsWithoutScopeClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, marketplaceIdentifier string, options *armmanagedservices.MarketplaceRegistrationDefinitionsWithoutScopeClientGetOptions) (resp azfake.Responder[armmanagedservices.MarketplaceRegistrationDefinitionsWithoutScopeClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method MarketplaceRegistrationDefinitionsWithoutScopeClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armmanagedservices.MarketplaceRegistrationDefinitionsWithoutScopeClientListOptions) (resp azfake.PagerResponder[armmanagedservices.MarketplaceRegistrationDefinitionsWithoutScopeClientListResponse])
}

// NewMarketplaceRegistrationDefinitionsWithoutScopeServerTransport creates a new instance of MarketplaceRegistrationDefinitionsWithoutScopeServerTransport with the provided implementation.
// The returned MarketplaceRegistrationDefinitionsWithoutScopeServerTransport instance is connected to an instance of armmanagedservices.MarketplaceRegistrationDefinitionsWithoutScopeClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewMarketplaceRegistrationDefinitionsWithoutScopeServerTransport(srv *MarketplaceRegistrationDefinitionsWithoutScopeServer) *MarketplaceRegistrationDefinitionsWithoutScopeServerTransport {
	return &MarketplaceRegistrationDefinitionsWithoutScopeServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armmanagedservices.MarketplaceRegistrationDefinitionsWithoutScopeClientListResponse]](),
	}
}

// MarketplaceRegistrationDefinitionsWithoutScopeServerTransport connects instances of armmanagedservices.MarketplaceRegistrationDefinitionsWithoutScopeClient to instances of MarketplaceRegistrationDefinitionsWithoutScopeServer.
// Don't use this type directly, use NewMarketplaceRegistrationDefinitionsWithoutScopeServerTransport instead.
type MarketplaceRegistrationDefinitionsWithoutScopeServerTransport struct {
	srv          *MarketplaceRegistrationDefinitionsWithoutScopeServer
	newListPager *tracker[azfake.PagerResponder[armmanagedservices.MarketplaceRegistrationDefinitionsWithoutScopeClientListResponse]]
}

// Do implements the policy.Transporter interface for MarketplaceRegistrationDefinitionsWithoutScopeServerTransport.
func (m *MarketplaceRegistrationDefinitionsWithoutScopeServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "MarketplaceRegistrationDefinitionsWithoutScopeClient.Get":
		resp, err = m.dispatchGet(req)
	case "MarketplaceRegistrationDefinitionsWithoutScopeClient.NewListPager":
		resp, err = m.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (m *MarketplaceRegistrationDefinitionsWithoutScopeServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if m.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/providers/Microsoft\.ManagedServices/marketplaceRegistrationDefinitions/(?P<marketplaceIdentifier>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	marketplaceIdentifierParam, err := url.PathUnescape(matches[regex.SubexpIndex("marketplaceIdentifier")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.Get(req.Context(), marketplaceIdentifierParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).MarketplaceRegistrationDefinition, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *MarketplaceRegistrationDefinitionsWithoutScopeServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := m.newListPager.get(req)
	if newListPager == nil {
		qp := req.URL.Query()
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armmanagedservices.MarketplaceRegistrationDefinitionsWithoutScopeClientListOptions
		if filterParam != nil {
			options = &armmanagedservices.MarketplaceRegistrationDefinitionsWithoutScopeClientListOptions{
				Filter: filterParam,
			}
		}
		resp := m.srv.NewListPager(options)
		newListPager = &resp
		m.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armmanagedservices.MarketplaceRegistrationDefinitionsWithoutScopeClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		m.newListPager.remove(req)
	}
	return resp, nil
}
