//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/managementgroups/armmanagementgroups"
	"net/http"
	"net/url"
	"regexp"
)

// ManagementGroupSubscriptionsServer is a fake server for instances of the armmanagementgroups.ManagementGroupSubscriptionsClient type.
type ManagementGroupSubscriptionsServer struct {
	// Create is the fake for method ManagementGroupSubscriptionsClient.Create
	// HTTP status codes to indicate success: http.StatusOK
	Create func(ctx context.Context, groupID string, subscriptionID string, options *armmanagementgroups.ManagementGroupSubscriptionsClientCreateOptions) (resp azfake.Responder[armmanagementgroups.ManagementGroupSubscriptionsClientCreateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method ManagementGroupSubscriptionsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, groupID string, subscriptionID string, options *armmanagementgroups.ManagementGroupSubscriptionsClientDeleteOptions) (resp azfake.Responder[armmanagementgroups.ManagementGroupSubscriptionsClientDeleteResponse], errResp azfake.ErrorResponder)

	// GetSubscription is the fake for method ManagementGroupSubscriptionsClient.GetSubscription
	// HTTP status codes to indicate success: http.StatusOK
	GetSubscription func(ctx context.Context, groupID string, subscriptionID string, options *armmanagementgroups.ManagementGroupSubscriptionsClientGetSubscriptionOptions) (resp azfake.Responder[armmanagementgroups.ManagementGroupSubscriptionsClientGetSubscriptionResponse], errResp azfake.ErrorResponder)

	// NewGetSubscriptionsUnderManagementGroupPager is the fake for method ManagementGroupSubscriptionsClient.NewGetSubscriptionsUnderManagementGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewGetSubscriptionsUnderManagementGroupPager func(groupID string, options *armmanagementgroups.ManagementGroupSubscriptionsClientGetSubscriptionsUnderManagementGroupOptions) (resp azfake.PagerResponder[armmanagementgroups.ManagementGroupSubscriptionsClientGetSubscriptionsUnderManagementGroupResponse])
}

// NewManagementGroupSubscriptionsServerTransport creates a new instance of ManagementGroupSubscriptionsServerTransport with the provided implementation.
// The returned ManagementGroupSubscriptionsServerTransport instance is connected to an instance of armmanagementgroups.ManagementGroupSubscriptionsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewManagementGroupSubscriptionsServerTransport(srv *ManagementGroupSubscriptionsServer) *ManagementGroupSubscriptionsServerTransport {
	return &ManagementGroupSubscriptionsServerTransport{
		srv: srv,
		newGetSubscriptionsUnderManagementGroupPager: newTracker[azfake.PagerResponder[armmanagementgroups.ManagementGroupSubscriptionsClientGetSubscriptionsUnderManagementGroupResponse]](),
	}
}

// ManagementGroupSubscriptionsServerTransport connects instances of armmanagementgroups.ManagementGroupSubscriptionsClient to instances of ManagementGroupSubscriptionsServer.
// Don't use this type directly, use NewManagementGroupSubscriptionsServerTransport instead.
type ManagementGroupSubscriptionsServerTransport struct {
	srv                                          *ManagementGroupSubscriptionsServer
	newGetSubscriptionsUnderManagementGroupPager *tracker[azfake.PagerResponder[armmanagementgroups.ManagementGroupSubscriptionsClientGetSubscriptionsUnderManagementGroupResponse]]
}

// Do implements the policy.Transporter interface for ManagementGroupSubscriptionsServerTransport.
func (m *ManagementGroupSubscriptionsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ManagementGroupSubscriptionsClient.Create":
		resp, err = m.dispatchCreate(req)
	case "ManagementGroupSubscriptionsClient.Delete":
		resp, err = m.dispatchDelete(req)
	case "ManagementGroupSubscriptionsClient.GetSubscription":
		resp, err = m.dispatchGetSubscription(req)
	case "ManagementGroupSubscriptionsClient.NewGetSubscriptionsUnderManagementGroupPager":
		resp, err = m.dispatchNewGetSubscriptionsUnderManagementGroupPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (m *ManagementGroupSubscriptionsServerTransport) dispatchCreate(req *http.Request) (*http.Response, error) {
	if m.srv.Create == nil {
		return nil, &nonRetriableError{errors.New("fake for method Create not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Management/managementGroups/(?P<groupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	groupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("groupId")])
	if err != nil {
		return nil, err
	}
	subscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("subscriptionId")])
	if err != nil {
		return nil, err
	}
	cacheControlParam := getOptional(getHeaderValue(req.Header, "Cache-Control"))
	var options *armmanagementgroups.ManagementGroupSubscriptionsClientCreateOptions
	if cacheControlParam != nil {
		options = &armmanagementgroups.ManagementGroupSubscriptionsClientCreateOptions{
			CacheControl: cacheControlParam,
		}
	}
	respr, errRespr := m.srv.Create(req.Context(), groupIDParam, subscriptionIDParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SubscriptionUnderManagementGroup, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagementGroupSubscriptionsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if m.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Management/managementGroups/(?P<groupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	groupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("groupId")])
	if err != nil {
		return nil, err
	}
	subscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("subscriptionId")])
	if err != nil {
		return nil, err
	}
	cacheControlParam := getOptional(getHeaderValue(req.Header, "Cache-Control"))
	var options *armmanagementgroups.ManagementGroupSubscriptionsClientDeleteOptions
	if cacheControlParam != nil {
		options = &armmanagementgroups.ManagementGroupSubscriptionsClientDeleteOptions{
			CacheControl: cacheControlParam,
		}
	}
	respr, errRespr := m.srv.Delete(req.Context(), groupIDParam, subscriptionIDParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagementGroupSubscriptionsServerTransport) dispatchGetSubscription(req *http.Request) (*http.Response, error) {
	if m.srv.GetSubscription == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetSubscription not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Management/managementGroups/(?P<groupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	groupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("groupId")])
	if err != nil {
		return nil, err
	}
	subscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("subscriptionId")])
	if err != nil {
		return nil, err
	}
	cacheControlParam := getOptional(getHeaderValue(req.Header, "Cache-Control"))
	var options *armmanagementgroups.ManagementGroupSubscriptionsClientGetSubscriptionOptions
	if cacheControlParam != nil {
		options = &armmanagementgroups.ManagementGroupSubscriptionsClientGetSubscriptionOptions{
			CacheControl: cacheControlParam,
		}
	}
	respr, errRespr := m.srv.GetSubscription(req.Context(), groupIDParam, subscriptionIDParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SubscriptionUnderManagementGroup, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagementGroupSubscriptionsServerTransport) dispatchNewGetSubscriptionsUnderManagementGroupPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewGetSubscriptionsUnderManagementGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewGetSubscriptionsUnderManagementGroupPager not implemented")}
	}
	newGetSubscriptionsUnderManagementGroupPager := m.newGetSubscriptionsUnderManagementGroupPager.get(req)
	if newGetSubscriptionsUnderManagementGroupPager == nil {
		const regexStr = `/providers/Microsoft\.Management/managementGroups/(?P<groupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/subscriptions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		groupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("groupId")])
		if err != nil {
			return nil, err
		}
		skiptokenUnescaped, err := url.QueryUnescape(qp.Get("$skiptoken"))
		if err != nil {
			return nil, err
		}
		skiptokenParam := getOptional(skiptokenUnescaped)
		var options *armmanagementgroups.ManagementGroupSubscriptionsClientGetSubscriptionsUnderManagementGroupOptions
		if skiptokenParam != nil {
			options = &armmanagementgroups.ManagementGroupSubscriptionsClientGetSubscriptionsUnderManagementGroupOptions{
				Skiptoken: skiptokenParam,
			}
		}
		resp := m.srv.NewGetSubscriptionsUnderManagementGroupPager(groupIDParam, options)
		newGetSubscriptionsUnderManagementGroupPager = &resp
		m.newGetSubscriptionsUnderManagementGroupPager.add(req, newGetSubscriptionsUnderManagementGroupPager)
		server.PagerResponderInjectNextLinks(newGetSubscriptionsUnderManagementGroupPager, req, func(page *armmanagementgroups.ManagementGroupSubscriptionsClientGetSubscriptionsUnderManagementGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newGetSubscriptionsUnderManagementGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newGetSubscriptionsUnderManagementGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newGetSubscriptionsUnderManagementGroupPager) {
		m.newGetSubscriptionsUnderManagementGroupPager.remove(req)
	}
	return resp, nil
}
