//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armorbital

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	credential     azcore.TokenCredential
	options        *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID, credential: credential,
		options: options.Clone(),
	}, nil
}

// NewAvailableGroundStationsClient creates a new instance of AvailableGroundStationsClient.
func (c *ClientFactory) NewAvailableGroundStationsClient() *AvailableGroundStationsClient {
	subClient, _ := NewAvailableGroundStationsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewContactProfilesClient creates a new instance of ContactProfilesClient.
func (c *ClientFactory) NewContactProfilesClient() *ContactProfilesClient {
	subClient, _ := NewContactProfilesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewContactsClient creates a new instance of ContactsClient.
func (c *ClientFactory) NewContactsClient() *ContactsClient {
	subClient, _ := NewContactsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	subClient, _ := NewOperationsClient(c.credential, c.options)
	return subClient
}

// NewOperationsResultsClient creates a new instance of OperationsResultsClient.
func (c *ClientFactory) NewOperationsResultsClient() *OperationsResultsClient {
	subClient, _ := NewOperationsResultsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSpacecraftsClient creates a new instance of SpacecraftsClient.
func (c *ClientFactory) NewSpacecraftsClient() *SpacecraftsClient {
	subClient, _ := NewSpacecraftsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}
