/*
 * Copyright 2019 The libgav1 Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef LIBGAV1_SRC_DSP_X86_INTRAPRED_SSE4_H_
#define LIBGAV1_SRC_DSP_X86_INTRAPRED_SSE4_H_

#include "src/dsp/dsp.h"
#include "src/utils/cpu.h"

namespace libgav1 {
namespace dsp {

// Initializes Dsp::intra_predictors. See the defines below for specifics.
// These functions are not thread-safe.
void IntraPredInit_SSE4_1();

}  // namespace dsp
}  // namespace libgav1

// If sse4 is enabled and the baseline isn't set due to a higher level of
// optimization being enabled, signal the sse4 implementation should be used.
#if LIBGAV1_TARGETING_SSE4_1
#ifndef LIBGAV1_Dsp8bpp_TransformSize4x4_IntraPredictorDcTop
#define LIBGAV1_Dsp8bpp_TransformSize4x4_IntraPredictorDcTop LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize4x8_IntraPredictorDcTop
#define LIBGAV1_Dsp8bpp_TransformSize4x8_IntraPredictorDcTop LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize4x16_IntraPredictorDcTop
#define LIBGAV1_Dsp8bpp_TransformSize4x16_IntraPredictorDcTop LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize8x4_IntraPredictorDcTop
#define LIBGAV1_Dsp8bpp_TransformSize8x4_IntraPredictorDcTop LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize8x8_IntraPredictorDcTop
#define LIBGAV1_Dsp8bpp_TransformSize8x8_IntraPredictorDcTop LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize8x16_IntraPredictorDcTop
#define LIBGAV1_Dsp8bpp_TransformSize8x16_IntraPredictorDcTop LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize8x32_IntraPredictorDcTop
#define LIBGAV1_Dsp8bpp_TransformSize8x32_IntraPredictorDcTop LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize16x4_IntraPredictorDcTop
#define LIBGAV1_Dsp8bpp_TransformSize16x4_IntraPredictorDcTop LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize16x8_IntraPredictorDcTop
#define LIBGAV1_Dsp8bpp_TransformSize16x8_IntraPredictorDcTop LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize16x16_IntraPredictorDcTop
#define LIBGAV1_Dsp8bpp_TransformSize16x16_IntraPredictorDcTop \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize16x32_IntraPredictorDcTop
#define LIBGAV1_Dsp8bpp_TransformSize16x32_IntraPredictorDcTop \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize16x64_IntraPredictorDcTop
#define LIBGAV1_Dsp8bpp_TransformSize16x64_IntraPredictorDcTop \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize32x8_IntraPredictorDcTop
#define LIBGAV1_Dsp8bpp_TransformSize32x8_IntraPredictorDcTop LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize32x16_IntraPredictorDcTop
#define LIBGAV1_Dsp8bpp_TransformSize32x16_IntraPredictorDcTop \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize32x32_IntraPredictorDcTop
#define LIBGAV1_Dsp8bpp_TransformSize32x32_IntraPredictorDcTop \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize32x64_IntraPredictorDcTop
#define LIBGAV1_Dsp8bpp_TransformSize32x64_IntraPredictorDcTop \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize64x16_IntraPredictorDcTop
#define LIBGAV1_Dsp8bpp_TransformSize64x16_IntraPredictorDcTop \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize64x32_IntraPredictorDcTop
#define LIBGAV1_Dsp8bpp_TransformSize64x32_IntraPredictorDcTop \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize64x64_IntraPredictorDcTop
#define LIBGAV1_Dsp8bpp_TransformSize64x64_IntraPredictorDcTop \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize4x4_IntraPredictorDcLeft
#define LIBGAV1_Dsp8bpp_TransformSize4x4_IntraPredictorDcLeft LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize4x8_IntraPredictorDcLeft
#define LIBGAV1_Dsp8bpp_TransformSize4x8_IntraPredictorDcLeft LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize4x16_IntraPredictorDcLeft
#define LIBGAV1_Dsp8bpp_TransformSize4x16_IntraPredictorDcLeft \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize8x4_IntraPredictorDcLeft
#define LIBGAV1_Dsp8bpp_TransformSize8x4_IntraPredictorDcLeft LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize8x8_IntraPredictorDcLeft
#define LIBGAV1_Dsp8bpp_TransformSize8x8_IntraPredictorDcLeft LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize8x16_IntraPredictorDcLeft
#define LIBGAV1_Dsp8bpp_TransformSize8x16_IntraPredictorDcLeft \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize8x32_IntraPredictorDcLeft
#define LIBGAV1_Dsp8bpp_TransformSize8x32_IntraPredictorDcLeft \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize16x4_IntraPredictorDcLeft
#define LIBGAV1_Dsp8bpp_TransformSize16x4_IntraPredictorDcLeft \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize16x8_IntraPredictorDcLeft
#define LIBGAV1_Dsp8bpp_TransformSize16x8_IntraPredictorDcLeft \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize16x16_IntraPredictorDcLeft
#define LIBGAV1_Dsp8bpp_TransformSize16x16_IntraPredictorDcLeft \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize16x32_IntraPredictorDcLeft
#define LIBGAV1_Dsp8bpp_TransformSize16x32_IntraPredictorDcLeft \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize16x64_IntraPredictorDcLeft
#define LIBGAV1_Dsp8bpp_TransformSize16x64_IntraPredictorDcLeft \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize32x8_IntraPredictorDcLeft
#define LIBGAV1_Dsp8bpp_TransformSize32x8_IntraPredictorDcLeft \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize32x16_IntraPredictorDcLeft
#define LIBGAV1_Dsp8bpp_TransformSize32x16_IntraPredictorDcLeft \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize32x32_IntraPredictorDcLeft
#define LIBGAV1_Dsp8bpp_TransformSize32x32_IntraPredictorDcLeft \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize32x64_IntraPredictorDcLeft
#define LIBGAV1_Dsp8bpp_TransformSize32x64_IntraPredictorDcLeft \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize64x16_IntraPredictorDcLeft
#define LIBGAV1_Dsp8bpp_TransformSize64x16_IntraPredictorDcLeft \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize64x32_IntraPredictorDcLeft
#define LIBGAV1_Dsp8bpp_TransformSize64x32_IntraPredictorDcLeft \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize64x64_IntraPredictorDcLeft
#define LIBGAV1_Dsp8bpp_TransformSize64x64_IntraPredictorDcLeft \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize4x4_IntraPredictorDc
#define LIBGAV1_Dsp8bpp_TransformSize4x4_IntraPredictorDc LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize4x8_IntraPredictorDc
#define LIBGAV1_Dsp8bpp_TransformSize4x8_IntraPredictorDc LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize4x16_IntraPredictorDc
#define LIBGAV1_Dsp8bpp_TransformSize4x16_IntraPredictorDc LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize8x4_IntraPredictorDc
#define LIBGAV1_Dsp8bpp_TransformSize8x4_IntraPredictorDc LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize8x8_IntraPredictorDc
#define LIBGAV1_Dsp8bpp_TransformSize8x8_IntraPredictorDc LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize8x16_IntraPredictorDc
#define LIBGAV1_Dsp8bpp_TransformSize8x16_IntraPredictorDc LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize8x32_IntraPredictorDc
#define LIBGAV1_Dsp8bpp_TransformSize8x32_IntraPredictorDc LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize16x4_IntraPredictorDc
#define LIBGAV1_Dsp8bpp_TransformSize16x4_IntraPredictorDc LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize16x8_IntraPredictorDc
#define LIBGAV1_Dsp8bpp_TransformSize16x8_IntraPredictorDc LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize16x16_IntraPredictorDc
#define LIBGAV1_Dsp8bpp_TransformSize16x16_IntraPredictorDc LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize16x32_IntraPredictorDc
#define LIBGAV1_Dsp8bpp_TransformSize16x32_IntraPredictorDc LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize16x64_IntraPredictorDc
#define LIBGAV1_Dsp8bpp_TransformSize16x64_IntraPredictorDc LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize32x8_IntraPredictorDc
#define LIBGAV1_Dsp8bpp_TransformSize32x8_IntraPredictorDc LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize32x16_IntraPredictorDc
#define LIBGAV1_Dsp8bpp_TransformSize32x16_IntraPredictorDc LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize32x32_IntraPredictorDc
#define LIBGAV1_Dsp8bpp_TransformSize32x32_IntraPredictorDc LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize32x64_IntraPredictorDc
#define LIBGAV1_Dsp8bpp_TransformSize32x64_IntraPredictorDc LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize64x16_IntraPredictorDc
#define LIBGAV1_Dsp8bpp_TransformSize64x16_IntraPredictorDc LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize64x32_IntraPredictorDc
#define LIBGAV1_Dsp8bpp_TransformSize64x32_IntraPredictorDc LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize64x64_IntraPredictorDc
#define LIBGAV1_Dsp8bpp_TransformSize64x64_IntraPredictorDc LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize4x4_IntraPredictorPaeth
#define LIBGAV1_Dsp8bpp_TransformSize4x4_IntraPredictorPaeth LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize4x8_IntraPredictorPaeth
#define LIBGAV1_Dsp8bpp_TransformSize4x8_IntraPredictorPaeth LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize4x16_IntraPredictorPaeth
#define LIBGAV1_Dsp8bpp_TransformSize4x16_IntraPredictorPaeth LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize8x4_IntraPredictorPaeth
#define LIBGAV1_Dsp8bpp_TransformSize8x4_IntraPredictorPaeth LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize8x8_IntraPredictorPaeth
#define LIBGAV1_Dsp8bpp_TransformSize8x8_IntraPredictorPaeth LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize8x16_IntraPredictorPaeth
#define LIBGAV1_Dsp8bpp_TransformSize8x16_IntraPredictorPaeth LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize8x32_IntraPredictorPaeth
#define LIBGAV1_Dsp8bpp_TransformSize8x32_IntraPredictorPaeth LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize16x4_IntraPredictorPaeth
#define LIBGAV1_Dsp8bpp_TransformSize16x4_IntraPredictorPaeth LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize16x8_IntraPredictorPaeth
#define LIBGAV1_Dsp8bpp_TransformSize16x8_IntraPredictorPaeth LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize16x16_IntraPredictorPaeth
#define LIBGAV1_Dsp8bpp_TransformSize16x16_IntraPredictorPaeth \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize16x32_IntraPredictorPaeth
#define LIBGAV1_Dsp8bpp_TransformSize16x32_IntraPredictorPaeth \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize16x64_IntraPredictorPaeth
#define LIBGAV1_Dsp8bpp_TransformSize16x64_IntraPredictorPaeth \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize32x8_IntraPredictorPaeth
#define LIBGAV1_Dsp8bpp_TransformSize32x8_IntraPredictorPaeth LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize32x16_IntraPredictorPaeth
#define LIBGAV1_Dsp8bpp_TransformSize32x16_IntraPredictorPaeth \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize32x32_IntraPredictorPaeth
#define LIBGAV1_Dsp8bpp_TransformSize32x32_IntraPredictorPaeth \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize32x64_IntraPredictorPaeth
#define LIBGAV1_Dsp8bpp_TransformSize32x64_IntraPredictorPaeth \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize64x16_IntraPredictorPaeth
#define LIBGAV1_Dsp8bpp_TransformSize64x16_IntraPredictorPaeth \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize64x32_IntraPredictorPaeth
#define LIBGAV1_Dsp8bpp_TransformSize64x32_IntraPredictorPaeth \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize64x64_IntraPredictorPaeth
#define LIBGAV1_Dsp8bpp_TransformSize64x64_IntraPredictorPaeth \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize4x4_IntraPredictorHorizontal
#define LIBGAV1_Dsp8bpp_TransformSize4x4_IntraPredictorHorizontal \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize4x8_IntraPredictorHorizontal
#define LIBGAV1_Dsp8bpp_TransformSize4x8_IntraPredictorHorizontal \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize4x16_IntraPredictorHorizontal
#define LIBGAV1_Dsp8bpp_TransformSize4x16_IntraPredictorHorizontal \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize8x4_IntraPredictorHorizontal
#define LIBGAV1_Dsp8bpp_TransformSize8x4_IntraPredictorHorizontal \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize8x8_IntraPredictorHorizontal
#define LIBGAV1_Dsp8bpp_TransformSize8x8_IntraPredictorHorizontal \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize8x16_IntraPredictorHorizontal
#define LIBGAV1_Dsp8bpp_TransformSize8x16_IntraPredictorHorizontal \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize8x32_IntraPredictorHorizontal
#define LIBGAV1_Dsp8bpp_TransformSize8x32_IntraPredictorHorizontal \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize16x4_IntraPredictorHorizontal
#define LIBGAV1_Dsp8bpp_TransformSize16x4_IntraPredictorHorizontal \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize16x8_IntraPredictorHorizontal
#define LIBGAV1_Dsp8bpp_TransformSize16x8_IntraPredictorHorizontal \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize16x16_IntraPredictorHorizontal
#define LIBGAV1_Dsp8bpp_TransformSize16x16_IntraPredictorHorizontal \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize16x32_IntraPredictorHorizontal
#define LIBGAV1_Dsp8bpp_TransformSize16x32_IntraPredictorHorizontal \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize16x64_IntraPredictorHorizontal
#define LIBGAV1_Dsp8bpp_TransformSize16x64_IntraPredictorHorizontal \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize32x8_IntraPredictorHorizontal
#define LIBGAV1_Dsp8bpp_TransformSize32x8_IntraPredictorHorizontal \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize32x16_IntraPredictorHorizontal
#define LIBGAV1_Dsp8bpp_TransformSize32x16_IntraPredictorHorizontal \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize32x16_IntraPredictorHorizontal
#define LIBGAV1_Dsp8bpp_TransformSize32x16_IntraPredictorHorizontal \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize32x32_IntraPredictorHorizontal
#define LIBGAV1_Dsp8bpp_TransformSize32x32_IntraPredictorHorizontal \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize32x64_IntraPredictorHorizontal
#define LIBGAV1_Dsp8bpp_TransformSize32x64_IntraPredictorHorizontal \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize64x16_IntraPredictorHorizontal
#define LIBGAV1_Dsp8bpp_TransformSize64x16_IntraPredictorHorizontal \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize64x32_IntraPredictorHorizontal
#define LIBGAV1_Dsp8bpp_TransformSize64x32_IntraPredictorHorizontal \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp8bpp_TransformSize64x64_IntraPredictorHorizontal
#define LIBGAV1_Dsp8bpp_TransformSize64x64_IntraPredictorHorizontal \
  LIBGAV1_CPU_SSE4_1
#endif

//------------------------------------------------------------------------------
// 10bpp

#ifndef LIBGAV1_Dsp10bpp_TransformSize4x4_IntraPredictorDcTop
#define LIBGAV1_Dsp10bpp_TransformSize4x4_IntraPredictorDcTop LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp10bpp_TransformSize4x4_IntraPredictorDcLeft
#define LIBGAV1_Dsp10bpp_TransformSize4x4_IntraPredictorDcLeft \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp10bpp_TransformSize4x4_IntraPredictorDc
#define LIBGAV1_Dsp10bpp_TransformSize4x4_IntraPredictorDc LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp10bpp_TransformSize4x4_IntraPredictorHorizontal
#define LIBGAV1_Dsp10bpp_TransformSize4x4_IntraPredictorHorizontal \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp10bpp_TransformSize4x8_IntraPredictorHorizontal
#define LIBGAV1_Dsp10bpp_TransformSize4x8_IntraPredictorHorizontal \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp10bpp_TransformSize4x16_IntraPredictorHorizontal
#define LIBGAV1_Dsp10bpp_TransformSize4x16_IntraPredictorHorizontal \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp10bpp_TransformSize8x4_IntraPredictorHorizontal
#define LIBGAV1_Dsp10bpp_TransformSize8x4_IntraPredictorHorizontal \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp10bpp_TransformSize8x8_IntraPredictorHorizontal
#define LIBGAV1_Dsp10bpp_TransformSize8x8_IntraPredictorHorizontal \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp10bpp_TransformSize8x16_IntraPredictorHorizontal
#define LIBGAV1_Dsp10bpp_TransformSize8x16_IntraPredictorHorizontal \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp10bpp_TransformSize8x32_IntraPredictorHorizontal
#define LIBGAV1_Dsp10bpp_TransformSize8x32_IntraPredictorHorizontal \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp10bpp_TransformSize16x4_IntraPredictorHorizontal
#define LIBGAV1_Dsp10bpp_TransformSize16x4_IntraPredictorHorizontal \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp10bpp_TransformSize16x8_IntraPredictorHorizontal
#define LIBGAV1_Dsp10bpp_TransformSize16x8_IntraPredictorHorizontal \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp10bpp_TransformSize16x16_IntraPredictorHorizontal
#define LIBGAV1_Dsp10bpp_TransformSize16x16_IntraPredictorHorizontal \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp10bpp_TransformSize16x32_IntraPredictorHorizontal
#define LIBGAV1_Dsp10bpp_TransformSize16x32_IntraPredictorHorizontal \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp10bpp_TransformSize16x64_IntraPredictorHorizontal
#define LIBGAV1_Dsp10bpp_TransformSize16x64_IntraPredictorHorizontal \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp10bpp_TransformSize32x8_IntraPredictorHorizontal
#define LIBGAV1_Dsp10bpp_TransformSize32x8_IntraPredictorHorizontal \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp10bpp_TransformSize32x16_IntraPredictorHorizontal
#define LIBGAV1_Dsp10bpp_TransformSize32x16_IntraPredictorHorizontal \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp10bpp_TransformSize32x16_IntraPredictorHorizontal
#define LIBGAV1_Dsp10bpp_TransformSize32x16_IntraPredictorHorizontal \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp10bpp_TransformSize32x32_IntraPredictorHorizontal
#define LIBGAV1_Dsp10bpp_TransformSize32x32_IntraPredictorHorizontal \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp10bpp_TransformSize32x64_IntraPredictorHorizontal
#define LIBGAV1_Dsp10bpp_TransformSize32x64_IntraPredictorHorizontal \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp10bpp_TransformSize64x16_IntraPredictorHorizontal
#define LIBGAV1_Dsp10bpp_TransformSize64x16_IntraPredictorHorizontal \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp10bpp_TransformSize64x32_IntraPredictorHorizontal
#define LIBGAV1_Dsp10bpp_TransformSize64x32_IntraPredictorHorizontal \
  LIBGAV1_CPU_SSE4_1
#endif

#ifndef LIBGAV1_Dsp10bpp_TransformSize64x64_IntraPredictorHorizontal
#define LIBGAV1_Dsp10bpp_TransformSize64x64_IntraPredictorHorizontal \
  LIBGAV1_CPU_SSE4_1
#endif

#endif  // LIBGAV1_TARGETING_SSE4_1

#endif  // LIBGAV1_SRC_DSP_X86_INTRAPRED_SSE4_H_
