# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from collections.abc import MutableMapping
import datetime
from typing import Any, Literal, Optional, TYPE_CHECKING, Union

from .._utils import serialization as _serialization

if TYPE_CHECKING:
    from .. import models as _models
JSON = MutableMapping[str, Any]


class AccessControlRules(_serialization.Model):
    """This is the Access Control Rules specification for an inVMAccessControlProfile version.

    :ivar privileges: A list of privileges.
    :vartype privileges: list[~azure.mgmt.compute.models.AccessControlRulesPrivilege]
    :ivar roles: A list of roles.
    :vartype roles: list[~azure.mgmt.compute.models.AccessControlRulesRole]
    :ivar identities: A list of identities.
    :vartype identities: list[~azure.mgmt.compute.models.AccessControlRulesIdentity]
    :ivar role_assignments: A list of role assignments.
    :vartype role_assignments: list[~azure.mgmt.compute.models.AccessControlRulesRoleAssignment]
    """

    _attribute_map = {
        "privileges": {"key": "privileges", "type": "[AccessControlRulesPrivilege]"},
        "roles": {"key": "roles", "type": "[AccessControlRulesRole]"},
        "identities": {"key": "identities", "type": "[AccessControlRulesIdentity]"},
        "role_assignments": {"key": "roleAssignments", "type": "[AccessControlRulesRoleAssignment]"},
    }

    def __init__(
        self,
        *,
        privileges: Optional[list["_models.AccessControlRulesPrivilege"]] = None,
        roles: Optional[list["_models.AccessControlRulesRole"]] = None,
        identities: Optional[list["_models.AccessControlRulesIdentity"]] = None,
        role_assignments: Optional[list["_models.AccessControlRulesRoleAssignment"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword privileges: A list of privileges.
        :paramtype privileges: list[~azure.mgmt.compute.models.AccessControlRulesPrivilege]
        :keyword roles: A list of roles.
        :paramtype roles: list[~azure.mgmt.compute.models.AccessControlRulesRole]
        :keyword identities: A list of identities.
        :paramtype identities: list[~azure.mgmt.compute.models.AccessControlRulesIdentity]
        :keyword role_assignments: A list of role assignments.
        :paramtype role_assignments: list[~azure.mgmt.compute.models.AccessControlRulesRoleAssignment]
        """
        super().__init__(**kwargs)
        self.privileges = privileges
        self.roles = roles
        self.identities = identities
        self.role_assignments = role_assignments


class AccessControlRulesIdentity(_serialization.Model):
    """The properties of an Access Control Rule Identity.

    All required parameters must be populated in order to send to server.

    :ivar name: The name of the identity. Required.
    :vartype name: str
    :ivar user_name: The username corresponding to this identity.
    :vartype user_name: str
    :ivar group_name: The groupName corresponding to this identity.
    :vartype group_name: str
    :ivar exe_path: The path to the executable.
    :vartype exe_path: str
    :ivar process_name: The process name of the executable.
    :vartype process_name: str
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "user_name": {"key": "userName", "type": "str"},
        "group_name": {"key": "groupName", "type": "str"},
        "exe_path": {"key": "exePath", "type": "str"},
        "process_name": {"key": "processName", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        user_name: Optional[str] = None,
        group_name: Optional[str] = None,
        exe_path: Optional[str] = None,
        process_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the identity. Required.
        :paramtype name: str
        :keyword user_name: The username corresponding to this identity.
        :paramtype user_name: str
        :keyword group_name: The groupName corresponding to this identity.
        :paramtype group_name: str
        :keyword exe_path: The path to the executable.
        :paramtype exe_path: str
        :keyword process_name: The process name of the executable.
        :paramtype process_name: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.user_name = user_name
        self.group_name = group_name
        self.exe_path = exe_path
        self.process_name = process_name


class AccessControlRulesPrivilege(_serialization.Model):
    """The properties of an Access Control Rule Privilege.

    All required parameters must be populated in order to send to server.

    :ivar name: The name of the privilege. Required.
    :vartype name: str
    :ivar path: The HTTP path corresponding to the privilege. Required.
    :vartype path: str
    :ivar query_parameters: The query parameters to match in the path.
    :vartype query_parameters: dict[str, str]
    """

    _validation = {
        "name": {"required": True},
        "path": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "path": {"key": "path", "type": "str"},
        "query_parameters": {"key": "queryParameters", "type": "{str}"},
    }

    def __init__(
        self, *, name: str, path: str, query_parameters: Optional[dict[str, str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the privilege. Required.
        :paramtype name: str
        :keyword path: The HTTP path corresponding to the privilege. Required.
        :paramtype path: str
        :keyword query_parameters: The query parameters to match in the path.
        :paramtype query_parameters: dict[str, str]
        """
        super().__init__(**kwargs)
        self.name = name
        self.path = path
        self.query_parameters = query_parameters


class AccessControlRulesRole(_serialization.Model):
    """The properties of an Access Control Rule Role.

    All required parameters must be populated in order to send to server.

    :ivar name: The name of the role. Required.
    :vartype name: str
    :ivar privileges: A list of privileges needed by this role. Required.
    :vartype privileges: list[str]
    """

    _validation = {
        "name": {"required": True},
        "privileges": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "privileges": {"key": "privileges", "type": "[str]"},
    }

    def __init__(self, *, name: str, privileges: list[str], **kwargs: Any) -> None:
        """
        :keyword name: The name of the role. Required.
        :paramtype name: str
        :keyword privileges: A list of privileges needed by this role. Required.
        :paramtype privileges: list[str]
        """
        super().__init__(**kwargs)
        self.name = name
        self.privileges = privileges


class AccessControlRulesRoleAssignment(_serialization.Model):
    """The properties of an Access Control Rule RoleAssignment.

    All required parameters must be populated in order to send to server.

    :ivar role: The name of the role. Required.
    :vartype role: str
    :ivar identities: A list of identities that can access the privileges defined by the role.
     Required.
    :vartype identities: list[str]
    """

    _validation = {
        "role": {"required": True},
        "identities": {"required": True},
    }

    _attribute_map = {
        "role": {"key": "role", "type": "str"},
        "identities": {"key": "identities", "type": "[str]"},
    }

    def __init__(self, *, role: str, identities: list[str], **kwargs: Any) -> None:
        """
        :keyword role: The name of the role. Required.
        :paramtype role: str
        :keyword identities: A list of identities that can access the privileges defined by the role.
         Required.
        :paramtype identities: list[str]
        """
        super().__init__(**kwargs)
        self.role = role
        self.identities = identities


class AccessUri(_serialization.Model):
    """A disk access SAS uri.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar access_sas: A SAS uri for accessing a disk.
    :vartype access_sas: str
    :ivar security_data_access_sas: A SAS uri for accessing a VM guest state.
    :vartype security_data_access_sas: str
    :ivar security_metadata_access_sas: A SAS uri for accessing a VM metadata.
    :vartype security_metadata_access_sas: str
    """

    _validation = {
        "access_sas": {"readonly": True},
        "security_data_access_sas": {"readonly": True},
        "security_metadata_access_sas": {"readonly": True},
    }

    _attribute_map = {
        "access_sas": {"key": "accessSAS", "type": "str"},
        "security_data_access_sas": {"key": "securityDataAccessSAS", "type": "str"},
        "security_metadata_access_sas": {"key": "securityMetadataAccessSAS", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.access_sas: Optional[str] = None
        self.security_data_access_sas: Optional[str] = None
        self.security_metadata_access_sas: Optional[str] = None


class AdditionalCapabilities(_serialization.Model):
    """Enables or disables a capability on the virtual machine or virtual machine scale set.

    :ivar ultra_ssd_enabled: The flag that enables or disables a capability to have one or more
     managed data disks with UltraSSD_LRS storage account type on the VM or VMSS. Managed disks with
     storage account type UltraSSD_LRS can be added to a virtual machine or virtual machine scale
     set only if this property is enabled.
    :vartype ultra_ssd_enabled: bool
    :ivar hibernation_enabled: The flag that enables or disables hibernation capability on the VM.
    :vartype hibernation_enabled: bool
    """

    _attribute_map = {
        "ultra_ssd_enabled": {"key": "ultraSSDEnabled", "type": "bool"},
        "hibernation_enabled": {"key": "hibernationEnabled", "type": "bool"},
    }

    def __init__(
        self, *, ultra_ssd_enabled: Optional[bool] = None, hibernation_enabled: Optional[bool] = None, **kwargs: Any
    ) -> None:
        """
        :keyword ultra_ssd_enabled: The flag that enables or disables a capability to have one or more
         managed data disks with UltraSSD_LRS storage account type on the VM or VMSS. Managed disks with
         storage account type UltraSSD_LRS can be added to a virtual machine or virtual machine scale
         set only if this property is enabled.
        :paramtype ultra_ssd_enabled: bool
        :keyword hibernation_enabled: The flag that enables or disables hibernation capability on the
         VM.
        :paramtype hibernation_enabled: bool
        """
        super().__init__(**kwargs)
        self.ultra_ssd_enabled = ultra_ssd_enabled
        self.hibernation_enabled = hibernation_enabled


class AdditionalReplicaSet(_serialization.Model):
    """Describes the additional replica set information.

    :ivar storage_account_type: Specifies the storage account type to be used to create the direct
     drive replicas. Known values are: "Standard_LRS", "Standard_ZRS", "Premium_LRS", and
     "PremiumV2_LRS".
    :vartype storage_account_type: str or ~azure.mgmt.compute.models.StorageAccountType
    :ivar regional_replica_count: The number of direct drive replicas of the Image Version to be
     created.This Property is updatable.
    :vartype regional_replica_count: int
    """

    _attribute_map = {
        "storage_account_type": {"key": "storageAccountType", "type": "str"},
        "regional_replica_count": {"key": "regionalReplicaCount", "type": "int"},
    }

    def __init__(
        self,
        *,
        storage_account_type: Optional[Union[str, "_models.StorageAccountType"]] = None,
        regional_replica_count: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword storage_account_type: Specifies the storage account type to be used to create the
         direct drive replicas. Known values are: "Standard_LRS", "Standard_ZRS", "Premium_LRS", and
         "PremiumV2_LRS".
        :paramtype storage_account_type: str or ~azure.mgmt.compute.models.StorageAccountType
        :keyword regional_replica_count: The number of direct drive replicas of the Image Version to be
         created.This Property is updatable.
        :paramtype regional_replica_count: int
        """
        super().__init__(**kwargs)
        self.storage_account_type = storage_account_type
        self.regional_replica_count = regional_replica_count


class AdditionalUnattendContent(_serialization.Model):
    """Specifies additional XML formatted information that can be included in the Unattend.xml file,
    which is used by Windows Setup. Contents are defined by setting name, component name, and the
    pass in which the content is applied.

    :ivar pass_name: The pass name. Currently, the only allowable value is OobeSystem. Default
     value is "OobeSystem".
    :vartype pass_name: str
    :ivar component_name: The component name. Currently, the only allowable value is
     Microsoft-Windows-Shell-Setup. Default value is "Microsoft-Windows-Shell-Setup".
    :vartype component_name: str
    :ivar setting_name: Specifies the name of the setting to which the content applies. Possible
     values are: FirstLogonCommands and AutoLogon. Known values are: "AutoLogon" and
     "FirstLogonCommands".
    :vartype setting_name: str or ~azure.mgmt.compute.models.SettingNames
    :ivar content: Specifies the XML formatted content that is added to the unattend.xml file for
     the specified path and component. The XML must be less than 4KB and must include the root
     element for the setting or feature that is being inserted.
    :vartype content: str
    """

    _attribute_map = {
        "pass_name": {"key": "passName", "type": "str"},
        "component_name": {"key": "componentName", "type": "str"},
        "setting_name": {"key": "settingName", "type": "str"},
        "content": {"key": "content", "type": "str"},
    }

    def __init__(
        self,
        *,
        pass_name: Optional[Literal["OobeSystem"]] = None,
        component_name: Optional[Literal["Microsoft-Windows-Shell-Setup"]] = None,
        setting_name: Optional[Union[str, "_models.SettingNames"]] = None,
        content: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword pass_name: The pass name. Currently, the only allowable value is OobeSystem. Default
         value is "OobeSystem".
        :paramtype pass_name: str
        :keyword component_name: The component name. Currently, the only allowable value is
         Microsoft-Windows-Shell-Setup. Default value is "Microsoft-Windows-Shell-Setup".
        :paramtype component_name: str
        :keyword setting_name: Specifies the name of the setting to which the content applies. Possible
         values are: FirstLogonCommands and AutoLogon. Known values are: "AutoLogon" and
         "FirstLogonCommands".
        :paramtype setting_name: str or ~azure.mgmt.compute.models.SettingNames
        :keyword content: Specifies the XML formatted content that is added to the unattend.xml file
         for the specified path and component. The XML must be less than 4KB and must include the root
         element for the setting or feature that is being inserted.
        :paramtype content: str
        """
        super().__init__(**kwargs)
        self.pass_name = pass_name
        self.component_name = component_name
        self.setting_name = setting_name
        self.content = content


class AllInstancesDown(_serialization.Model):
    """Specifies if Scheduled Events should be auto-approved when all instances are down.

    :ivar automatically_approve: Specifies if Scheduled Events should be auto-approved when all
     instances are down.
     its default value is true.
    :vartype automatically_approve: bool
    """

    _attribute_map = {
        "automatically_approve": {"key": "automaticallyApprove", "type": "bool"},
    }

    def __init__(self, *, automatically_approve: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword automatically_approve: Specifies if Scheduled Events should be auto-approved when all
         instances are down.
         its default value is true.
        :paramtype automatically_approve: bool
        """
        super().__init__(**kwargs)
        self.automatically_approve = automatically_approve


class AlternativeOption(_serialization.Model):
    """Describes the alternative option specified by the Publisher for this image when this image is
    deprecated.

    :ivar type: Describes the type of the alternative option. Known values are: "None", "Offer",
     and "Plan".
    :vartype type: str or ~azure.mgmt.compute.models.AlternativeType
    :ivar value: Indicates the alternative option value specified by the Publisher. This is the
     Offer name when the type is Offer or the Plan name when the type is Plan.
    :vartype value: str
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.AlternativeType"]] = None,
        value: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Describes the type of the alternative option. Known values are: "None", "Offer",
         and "Plan".
        :paramtype type: str or ~azure.mgmt.compute.models.AlternativeType
        :keyword value: Indicates the alternative option value specified by the Publisher. This is the
         Offer name when the type is Offer or the Plan name when the type is Plan.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.value = value


class ApiEntityReference(_serialization.Model):
    """The API entity reference.

    :ivar id: The ARM resource id in the form of
     /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: The ARM resource id in the form of
         /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class ApiError(_serialization.Model):
    """Api error.

    :ivar details: The Api error details.
    :vartype details: list[~azure.mgmt.compute.models.ApiErrorBase]
    :ivar innererror: The Api inner error.
    :vartype innererror: ~azure.mgmt.compute.models.InnerError
    :ivar code: The error code.
    :vartype code: str
    :ivar target: The target of the particular error.
    :vartype target: str
    :ivar message: The error message.
    :vartype message: str
    """

    _attribute_map = {
        "details": {"key": "details", "type": "[ApiErrorBase]"},
        "innererror": {"key": "innererror", "type": "InnerError"},
        "code": {"key": "code", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self,
        *,
        details: Optional[list["_models.ApiErrorBase"]] = None,
        innererror: Optional["_models.InnerError"] = None,
        code: Optional[str] = None,
        target: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword details: The Api error details.
        :paramtype details: list[~azure.mgmt.compute.models.ApiErrorBase]
        :keyword innererror: The Api inner error.
        :paramtype innererror: ~azure.mgmt.compute.models.InnerError
        :keyword code: The error code.
        :paramtype code: str
        :keyword target: The target of the particular error.
        :paramtype target: str
        :keyword message: The error message.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.details = details
        self.innererror = innererror
        self.code = code
        self.target = target
        self.message = message


class ApiErrorBase(_serialization.Model):
    """Api error base.

    :ivar code: The error code.
    :vartype code: str
    :ivar target: The target of the particular error.
    :vartype target: str
    :ivar message: The error message.
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self, *, code: Optional[str] = None, target: Optional[str] = None, message: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword code: The error code.
        :paramtype code: str
        :keyword target: The target of the particular error.
        :paramtype target: str
        :keyword message: The error message.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.target = target
        self.message = message


class ApplicationProfile(_serialization.Model):
    """Contains the list of gallery applications that should be made available to the VM/VMSS.

    :ivar gallery_applications: Specifies the gallery applications that should be made available to
     the VM/VMSS.
    :vartype gallery_applications: list[~azure.mgmt.compute.models.VMGalleryApplication]
    """

    _attribute_map = {
        "gallery_applications": {"key": "galleryApplications", "type": "[VMGalleryApplication]"},
    }

    def __init__(
        self, *, gallery_applications: Optional[list["_models.VMGalleryApplication"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword gallery_applications: Specifies the gallery applications that should be made available
         to the VM/VMSS.
        :paramtype gallery_applications: list[~azure.mgmt.compute.models.VMGalleryApplication]
        """
        super().__init__(**kwargs)
        self.gallery_applications = gallery_applications


class AttachDetachDataDisksRequest(_serialization.Model):
    """Specifies the input for attaching and detaching a list of managed data disks.

    :ivar data_disks_to_attach: The list of managed data disks to be attached.
    :vartype data_disks_to_attach: list[~azure.mgmt.compute.models.DataDisksToAttach]
    :ivar data_disks_to_detach: The list of managed data disks to be detached.
    :vartype data_disks_to_detach: list[~azure.mgmt.compute.models.DataDisksToDetach]
    """

    _validation = {
        "data_disks_to_attach": {"min_items": 1},
        "data_disks_to_detach": {"min_items": 1},
    }

    _attribute_map = {
        "data_disks_to_attach": {"key": "dataDisksToAttach", "type": "[DataDisksToAttach]"},
        "data_disks_to_detach": {"key": "dataDisksToDetach", "type": "[DataDisksToDetach]"},
    }

    def __init__(
        self,
        *,
        data_disks_to_attach: Optional[list["_models.DataDisksToAttach"]] = None,
        data_disks_to_detach: Optional[list["_models.DataDisksToDetach"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword data_disks_to_attach: The list of managed data disks to be attached.
        :paramtype data_disks_to_attach: list[~azure.mgmt.compute.models.DataDisksToAttach]
        :keyword data_disks_to_detach: The list of managed data disks to be detached.
        :paramtype data_disks_to_detach: list[~azure.mgmt.compute.models.DataDisksToDetach]
        """
        super().__init__(**kwargs)
        self.data_disks_to_attach = data_disks_to_attach
        self.data_disks_to_detach = data_disks_to_detach


class AutomaticOSUpgradePolicy(_serialization.Model):
    """The configuration parameters used for performing automatic OS upgrade.

    :ivar enable_automatic_os_upgrade: Indicates whether OS upgrades should automatically be
     applied to scale set instances in a rolling fashion when a newer version of the OS image
     becomes available. Default value is false. If this is set to true for Windows based scale sets,
     `enableAutomaticUpdates
     <https://docs.microsoft.com/dotnet/api/microsoft.azure.management.compute.models.windowsconfiguration.enableautomaticupdates?view=azure-dotnet>`_
     is automatically set to false and cannot be set to true.
    :vartype enable_automatic_os_upgrade: bool
    :ivar disable_automatic_rollback: Whether OS image rollback feature should be disabled. Default
     value is false.
    :vartype disable_automatic_rollback: bool
    :ivar use_rolling_upgrade_policy: Indicates whether rolling upgrade policy should be used
     during Auto OS Upgrade. Default value is false. Auto OS Upgrade will fallback to the default
     policy if no policy is defined on the VMSS.
    :vartype use_rolling_upgrade_policy: bool
    :ivar os_rolling_upgrade_deferral: Indicates whether Auto OS Upgrade should undergo deferral.
     Deferred OS upgrades will send advanced notifications on a per-VM basis that an OS upgrade from
     rolling upgrades is incoming, via the IMDS tag 'Platform.PendingOSUpgrade'. The upgrade then
     defers until the upgrade is approved via an ApproveRollingUpgrade call.
    :vartype os_rolling_upgrade_deferral: bool
    """

    _attribute_map = {
        "enable_automatic_os_upgrade": {"key": "enableAutomaticOSUpgrade", "type": "bool"},
        "disable_automatic_rollback": {"key": "disableAutomaticRollback", "type": "bool"},
        "use_rolling_upgrade_policy": {"key": "useRollingUpgradePolicy", "type": "bool"},
        "os_rolling_upgrade_deferral": {"key": "osRollingUpgradeDeferral", "type": "bool"},
    }

    def __init__(
        self,
        *,
        enable_automatic_os_upgrade: Optional[bool] = None,
        disable_automatic_rollback: Optional[bool] = None,
        use_rolling_upgrade_policy: Optional[bool] = None,
        os_rolling_upgrade_deferral: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enable_automatic_os_upgrade: Indicates whether OS upgrades should automatically be
         applied to scale set instances in a rolling fashion when a newer version of the OS image
         becomes available. Default value is false. If this is set to true for Windows based scale sets,
         `enableAutomaticUpdates
         <https://docs.microsoft.com/dotnet/api/microsoft.azure.management.compute.models.windowsconfiguration.enableautomaticupdates?view=azure-dotnet>`_
         is automatically set to false and cannot be set to true.
        :paramtype enable_automatic_os_upgrade: bool
        :keyword disable_automatic_rollback: Whether OS image rollback feature should be disabled.
         Default value is false.
        :paramtype disable_automatic_rollback: bool
        :keyword use_rolling_upgrade_policy: Indicates whether rolling upgrade policy should be used
         during Auto OS Upgrade. Default value is false. Auto OS Upgrade will fallback to the default
         policy if no policy is defined on the VMSS.
        :paramtype use_rolling_upgrade_policy: bool
        :keyword os_rolling_upgrade_deferral: Indicates whether Auto OS Upgrade should undergo
         deferral. Deferred OS upgrades will send advanced notifications on a per-VM basis that an OS
         upgrade from rolling upgrades is incoming, via the IMDS tag 'Platform.PendingOSUpgrade'. The
         upgrade then defers until the upgrade is approved via an ApproveRollingUpgrade call.
        :paramtype os_rolling_upgrade_deferral: bool
        """
        super().__init__(**kwargs)
        self.enable_automatic_os_upgrade = enable_automatic_os_upgrade
        self.disable_automatic_rollback = disable_automatic_rollback
        self.use_rolling_upgrade_policy = use_rolling_upgrade_policy
        self.os_rolling_upgrade_deferral = os_rolling_upgrade_deferral


class AutomaticOSUpgradeProperties(_serialization.Model):
    """Describes automatic OS upgrade properties on the image.

    All required parameters must be populated in order to send to server.

    :ivar automatic_os_upgrade_supported: Specifies whether automatic OS upgrade is supported on
     the image. Required.
    :vartype automatic_os_upgrade_supported: bool
    """

    _validation = {
        "automatic_os_upgrade_supported": {"required": True},
    }

    _attribute_map = {
        "automatic_os_upgrade_supported": {"key": "automaticOSUpgradeSupported", "type": "bool"},
    }

    def __init__(self, *, automatic_os_upgrade_supported: bool, **kwargs: Any) -> None:
        """
        :keyword automatic_os_upgrade_supported: Specifies whether automatic OS upgrade is supported on
         the image. Required.
        :paramtype automatic_os_upgrade_supported: bool
        """
        super().__init__(**kwargs)
        self.automatic_os_upgrade_supported = automatic_os_upgrade_supported


class AutomaticRepairsPolicy(_serialization.Model):
    """Specifies the configuration parameters for automatic repairs on the virtual machine scale set.

    :ivar enabled: Specifies whether automatic repairs should be enabled on the virtual machine
     scale set. The default value is false.
    :vartype enabled: bool
    :ivar grace_period: The amount of time for which automatic repairs are suspended due to a state
     change on VM. The grace time starts after the state change has completed. This helps avoid
     premature or accidental repairs. The time duration should be specified in ISO 8601 format. The
     minimum allowed grace period is 10 minutes (PT10M), which is also the default value. The
     maximum allowed grace period is 90 minutes (PT90M).
    :vartype grace_period: str
    :ivar repair_action: Type of repair action (replace, restart, reimage) that will be used for
     repairing unhealthy virtual machines in the scale set. Default value is replace. Known values
     are: "Replace", "Restart", and "Reimage".
    :vartype repair_action: str or ~azure.mgmt.compute.models.RepairAction
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "grace_period": {"key": "gracePeriod", "type": "str"},
        "repair_action": {"key": "repairAction", "type": "str"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        grace_period: Optional[str] = None,
        repair_action: Optional[Union[str, "_models.RepairAction"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Specifies whether automatic repairs should be enabled on the virtual machine
         scale set. The default value is false.
        :paramtype enabled: bool
        :keyword grace_period: The amount of time for which automatic repairs are suspended due to a
         state change on VM. The grace time starts after the state change has completed. This helps
         avoid premature or accidental repairs. The time duration should be specified in ISO 8601
         format. The minimum allowed grace period is 10 minutes (PT10M), which is also the default
         value. The maximum allowed grace period is 90 minutes (PT90M).
        :paramtype grace_period: str
        :keyword repair_action: Type of repair action (replace, restart, reimage) that will be used for
         repairing unhealthy virtual machines in the scale set. Default value is replace. Known values
         are: "Replace", "Restart", and "Reimage".
        :paramtype repair_action: str or ~azure.mgmt.compute.models.RepairAction
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.grace_period = grace_period
        self.repair_action = repair_action


class AutomaticZoneRebalancingPolicy(_serialization.Model):
    """The configuration parameters used while performing automatic AZ balancing.

    :ivar enabled: Specifies whether Automatic AZ Balancing should be enabled on the virtual
     machine scale set. The default value is false.
    :vartype enabled: bool
    :ivar rebalance_strategy: Type of rebalance strategy that will be used for rebalancing virtual
     machines in the scale set across availability zones. Default and only supported value for now
     is Recreate. "Recreate"
    :vartype rebalance_strategy: str or ~azure.mgmt.compute.models.RebalanceStrategy
    :ivar rebalance_behavior: Type of rebalance behavior that will be used for recreating virtual
     machines in the scale set across availability zones. Default and only supported value for now
     is CreateBeforeDelete. "CreateBeforeDelete"
    :vartype rebalance_behavior: str or ~azure.mgmt.compute.models.RebalanceBehavior
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "rebalance_strategy": {"key": "rebalanceStrategy", "type": "str"},
        "rebalance_behavior": {"key": "rebalanceBehavior", "type": "str"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        rebalance_strategy: Optional[Union[str, "_models.RebalanceStrategy"]] = None,
        rebalance_behavior: Optional[Union[str, "_models.RebalanceBehavior"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Specifies whether Automatic AZ Balancing should be enabled on the virtual
         machine scale set. The default value is false.
        :paramtype enabled: bool
        :keyword rebalance_strategy: Type of rebalance strategy that will be used for rebalancing
         virtual machines in the scale set across availability zones. Default and only supported value
         for now is Recreate. "Recreate"
        :paramtype rebalance_strategy: str or ~azure.mgmt.compute.models.RebalanceStrategy
        :keyword rebalance_behavior: Type of rebalance behavior that will be used for recreating
         virtual machines in the scale set across availability zones. Default and only supported value
         for now is CreateBeforeDelete. "CreateBeforeDelete"
        :paramtype rebalance_behavior: str or ~azure.mgmt.compute.models.RebalanceBehavior
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.rebalance_strategy = rebalance_strategy
        self.rebalance_behavior = rebalance_behavior


class AvailabilityPolicy(_serialization.Model):
    """In the case of an availability or connectivity issue with the data disk, specify the behavior
    of your VM.

    :ivar action_on_disk_delay: Determines on how to handle disks with slow I/O. Known values are:
     "None" and "AutomaticReattach".
    :vartype action_on_disk_delay: str or ~azure.mgmt.compute.models.AvailabilityPolicyDiskDelay
    """

    _attribute_map = {
        "action_on_disk_delay": {"key": "actionOnDiskDelay", "type": "str"},
    }

    def __init__(
        self, *, action_on_disk_delay: Optional[Union[str, "_models.AvailabilityPolicyDiskDelay"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword action_on_disk_delay: Determines on how to handle disks with slow I/O. Known values
         are: "None" and "AutomaticReattach".
        :paramtype action_on_disk_delay: str or ~azure.mgmt.compute.models.AvailabilityPolicyDiskDelay
        """
        super().__init__(**kwargs)
        self.action_on_disk_delay = action_on_disk_delay


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.compute.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.system_data: Optional["_models.SystemData"] = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.compute.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class AvailabilitySet(TrackedResource):
    """Specifies information about the availability set that the virtual machine should be assigned
    to. Virtual machines specified in the same availability set are allocated to different nodes to
    maximize availability. For more information about availability sets, see `Availability sets
    overview <https://docs.microsoft.com/azure/virtual-machines/availability-set-overview>`_. For
    more information on Azure planned maintenance, see `Maintenance and updates for Virtual
    Machines in Azure
    <https://docs.microsoft.com/azure/virtual-machines/maintenance-and-updates>`_. Currently, a VM
    can only be added to an availability set at creation time. An existing VM cannot be added to an
    availability set.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.compute.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar sku: Sku of the availability set, only name is required to be set. See
     AvailabilitySetSkuTypes for possible set of values. Use 'Aligned' for virtual machines with
     managed disks and 'Classic' for virtual machines with unmanaged disks. Default value is
     'Classic'.
    :vartype sku: ~azure.mgmt.compute.models.Sku
    :ivar platform_update_domain_count: Update Domain count.
    :vartype platform_update_domain_count: int
    :ivar platform_fault_domain_count: Fault Domain count.
    :vartype platform_fault_domain_count: int
    :ivar virtual_machines: A list of references to all virtual machines in the availability set.
    :vartype virtual_machines: list[~azure.mgmt.compute.models.SubResource]
    :ivar proximity_placement_group: Specifies information about the proximity placement group that
     the availability set should be assigned to. Minimum api-version: 2018-04-01.
    :vartype proximity_placement_group: ~azure.mgmt.compute.models.SubResource
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.models.InstanceViewStatus]
    :ivar scheduled_events_policy: Specifies Redeploy, Reboot and
     ScheduledEventsAdditionalPublishingTargets Scheduled Event related configurations for the
     availability set.
    :vartype scheduled_events_policy: ~azure.mgmt.compute.models.ScheduledEventsPolicy
    :ivar virtual_machine_scale_set_migration_info: Describes the migration properties on the
     Availability Set.
    :vartype virtual_machine_scale_set_migration_info:
     ~azure.mgmt.compute.models.VirtualMachineScaleSetMigrationInfo
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "statuses": {"readonly": True},
        "virtual_machine_scale_set_migration_info": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
        "platform_update_domain_count": {"key": "properties.platformUpdateDomainCount", "type": "int"},
        "platform_fault_domain_count": {"key": "properties.platformFaultDomainCount", "type": "int"},
        "virtual_machines": {"key": "properties.virtualMachines", "type": "[SubResource]"},
        "proximity_placement_group": {"key": "properties.proximityPlacementGroup", "type": "SubResource"},
        "statuses": {"key": "properties.statuses", "type": "[InstanceViewStatus]"},
        "scheduled_events_policy": {"key": "properties.scheduledEventsPolicy", "type": "ScheduledEventsPolicy"},
        "virtual_machine_scale_set_migration_info": {
            "key": "properties.virtualMachineScaleSetMigrationInfo",
            "type": "VirtualMachineScaleSetMigrationInfo",
        },
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        sku: Optional["_models.Sku"] = None,
        platform_update_domain_count: Optional[int] = None,
        platform_fault_domain_count: Optional[int] = None,
        virtual_machines: Optional[list["_models.SubResource"]] = None,
        proximity_placement_group: Optional["_models.SubResource"] = None,
        scheduled_events_policy: Optional["_models.ScheduledEventsPolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword sku: Sku of the availability set, only name is required to be set. See
         AvailabilitySetSkuTypes for possible set of values. Use 'Aligned' for virtual machines with
         managed disks and 'Classic' for virtual machines with unmanaged disks. Default value is
         'Classic'.
        :paramtype sku: ~azure.mgmt.compute.models.Sku
        :keyword platform_update_domain_count: Update Domain count.
        :paramtype platform_update_domain_count: int
        :keyword platform_fault_domain_count: Fault Domain count.
        :paramtype platform_fault_domain_count: int
        :keyword virtual_machines: A list of references to all virtual machines in the availability
         set.
        :paramtype virtual_machines: list[~azure.mgmt.compute.models.SubResource]
        :keyword proximity_placement_group: Specifies information about the proximity placement group
         that the availability set should be assigned to. Minimum api-version: 2018-04-01.
        :paramtype proximity_placement_group: ~azure.mgmt.compute.models.SubResource
        :keyword scheduled_events_policy: Specifies Redeploy, Reboot and
         ScheduledEventsAdditionalPublishingTargets Scheduled Event related configurations for the
         availability set.
        :paramtype scheduled_events_policy: ~azure.mgmt.compute.models.ScheduledEventsPolicy
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.sku = sku
        self.platform_update_domain_count = platform_update_domain_count
        self.platform_fault_domain_count = platform_fault_domain_count
        self.virtual_machines = virtual_machines
        self.proximity_placement_group = proximity_placement_group
        self.statuses: Optional[list["_models.InstanceViewStatus"]] = None
        self.scheduled_events_policy = scheduled_events_policy
        self.virtual_machine_scale_set_migration_info: Optional["_models.VirtualMachineScaleSetMigrationInfo"] = None


class AvailabilitySetListResult(_serialization.Model):
    """The List Availability Set operation response.

    All required parameters must be populated in order to send to server.

    :ivar value: The list of availability sets. Required.
    :vartype value: list[~azure.mgmt.compute.models.AvailabilitySet]
    :ivar next_link: The URI to fetch the next page of AvailabilitySets. Call ListNext() with this
     URI to fetch the next page of AvailabilitySets.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AvailabilitySet]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: list["_models.AvailabilitySet"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of availability sets. Required.
        :paramtype value: list[~azure.mgmt.compute.models.AvailabilitySet]
        :keyword next_link: The URI to fetch the next page of AvailabilitySets. Call ListNext() with
         this URI to fetch the next page of AvailabilitySets.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class UpdateResource(_serialization.Model):
    """The Update Resource model definition.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class AvailabilitySetUpdate(UpdateResource):
    """Specifies information about the availability set that the virtual machine should be assigned
    to. Only tags may be updated.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: Sku of the availability set.
    :vartype sku: ~azure.mgmt.compute.models.Sku
    :ivar platform_update_domain_count: Update Domain count.
    :vartype platform_update_domain_count: int
    :ivar platform_fault_domain_count: Fault Domain count.
    :vartype platform_fault_domain_count: int
    :ivar virtual_machines: A list of references to all virtual machines in the availability set.
    :vartype virtual_machines: list[~azure.mgmt.compute.models.SubResource]
    :ivar proximity_placement_group: Specifies information about the proximity placement group that
     the availability set should be assigned to. Minimum api-version: 2018-04-01.
    :vartype proximity_placement_group: ~azure.mgmt.compute.models.SubResource
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.models.InstanceViewStatus]
    :ivar scheduled_events_policy: Specifies Redeploy, Reboot and
     ScheduledEventsAdditionalPublishingTargets Scheduled Event related configurations for the
     availability set.
    :vartype scheduled_events_policy: ~azure.mgmt.compute.models.ScheduledEventsPolicy
    :ivar virtual_machine_scale_set_migration_info: Describes the migration properties on the
     Availability Set.
    :vartype virtual_machine_scale_set_migration_info:
     ~azure.mgmt.compute.models.VirtualMachineScaleSetMigrationInfo
    """

    _validation = {
        "statuses": {"readonly": True},
        "virtual_machine_scale_set_migration_info": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "Sku"},
        "platform_update_domain_count": {"key": "properties.platformUpdateDomainCount", "type": "int"},
        "platform_fault_domain_count": {"key": "properties.platformFaultDomainCount", "type": "int"},
        "virtual_machines": {"key": "properties.virtualMachines", "type": "[SubResource]"},
        "proximity_placement_group": {"key": "properties.proximityPlacementGroup", "type": "SubResource"},
        "statuses": {"key": "properties.statuses", "type": "[InstanceViewStatus]"},
        "scheduled_events_policy": {"key": "properties.scheduledEventsPolicy", "type": "ScheduledEventsPolicy"},
        "virtual_machine_scale_set_migration_info": {
            "key": "properties.virtualMachineScaleSetMigrationInfo",
            "type": "VirtualMachineScaleSetMigrationInfo",
        },
    }

    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
        sku: Optional["_models.Sku"] = None,
        platform_update_domain_count: Optional[int] = None,
        platform_fault_domain_count: Optional[int] = None,
        virtual_machines: Optional[list["_models.SubResource"]] = None,
        proximity_placement_group: Optional["_models.SubResource"] = None,
        scheduled_events_policy: Optional["_models.ScheduledEventsPolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: Sku of the availability set.
        :paramtype sku: ~azure.mgmt.compute.models.Sku
        :keyword platform_update_domain_count: Update Domain count.
        :paramtype platform_update_domain_count: int
        :keyword platform_fault_domain_count: Fault Domain count.
        :paramtype platform_fault_domain_count: int
        :keyword virtual_machines: A list of references to all virtual machines in the availability
         set.
        :paramtype virtual_machines: list[~azure.mgmt.compute.models.SubResource]
        :keyword proximity_placement_group: Specifies information about the proximity placement group
         that the availability set should be assigned to. Minimum api-version: 2018-04-01.
        :paramtype proximity_placement_group: ~azure.mgmt.compute.models.SubResource
        :keyword scheduled_events_policy: Specifies Redeploy, Reboot and
         ScheduledEventsAdditionalPublishingTargets Scheduled Event related configurations for the
         availability set.
        :paramtype scheduled_events_policy: ~azure.mgmt.compute.models.ScheduledEventsPolicy
        """
        super().__init__(tags=tags, **kwargs)
        self.sku = sku
        self.platform_update_domain_count = platform_update_domain_count
        self.platform_fault_domain_count = platform_fault_domain_count
        self.virtual_machines = virtual_machines
        self.proximity_placement_group = proximity_placement_group
        self.statuses: Optional[list["_models.InstanceViewStatus"]] = None
        self.scheduled_events_policy = scheduled_events_policy
        self.virtual_machine_scale_set_migration_info: Optional["_models.VirtualMachineScaleSetMigrationInfo"] = None


class AvailablePatchSummary(_serialization.Model):
    """Describes the properties of an virtual machine instance view for available patch summary.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The overall success or failure status of the operation. It remains "InProgress"
     until the operation completes. At that point it will become "Unknown", "Failed", "Succeeded",
     or "CompletedWithWarnings.". Known values are: "Unknown", "InProgress", "Failed", "Succeeded",
     and "CompletedWithWarnings".
    :vartype status: str or ~azure.mgmt.compute.models.PatchOperationStatus
    :ivar assessment_activity_id: The activity ID of the operation that produced this result. It is
     used to correlate across CRP and extension logs.
    :vartype assessment_activity_id: str
    :ivar reboot_pending: The overall reboot status of the VM. It will be true when partially
     installed patches require a reboot to complete installation but the reboot has not yet
     occurred.
    :vartype reboot_pending: bool
    :ivar critical_and_security_patch_count: The number of critical or security patches that have
     been detected as available and not yet installed.
    :vartype critical_and_security_patch_count: int
    :ivar other_patch_count: The number of all available patches excluding critical and security.
    :vartype other_patch_count: int
    :ivar start_time: The UTC timestamp when the operation began.
    :vartype start_time: ~datetime.datetime
    :ivar last_modified_time: The UTC timestamp when the operation began.
    :vartype last_modified_time: ~datetime.datetime
    :ivar error: The errors that were encountered during execution of the operation. The details
     array contains the list of them.
    :vartype error: ~azure.mgmt.compute.models.ApiError
    """

    _validation = {
        "status": {"readonly": True},
        "assessment_activity_id": {"readonly": True},
        "reboot_pending": {"readonly": True},
        "critical_and_security_patch_count": {"readonly": True},
        "other_patch_count": {"readonly": True},
        "start_time": {"readonly": True},
        "last_modified_time": {"readonly": True},
        "error": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "assessment_activity_id": {"key": "assessmentActivityId", "type": "str"},
        "reboot_pending": {"key": "rebootPending", "type": "bool"},
        "critical_and_security_patch_count": {"key": "criticalAndSecurityPatchCount", "type": "int"},
        "other_patch_count": {"key": "otherPatchCount", "type": "int"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "last_modified_time": {"key": "lastModifiedTime", "type": "iso-8601"},
        "error": {"key": "error", "type": "ApiError"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.status: Optional[Union[str, "_models.PatchOperationStatus"]] = None
        self.assessment_activity_id: Optional[str] = None
        self.reboot_pending: Optional[bool] = None
        self.critical_and_security_patch_count: Optional[int] = None
        self.other_patch_count: Optional[int] = None
        self.start_time: Optional[datetime.datetime] = None
        self.last_modified_time: Optional[datetime.datetime] = None
        self.error: Optional["_models.ApiError"] = None


class BillingProfile(_serialization.Model):
    """Specifies the billing related details of a Azure Spot VM or VMSS. Minimum api-version:
    2019-03-01.

    :ivar max_price: Specifies the maximum price you are willing to pay for a Azure Spot VM/VMSS.
     This price is in US Dollars. :code:`<br>`\\ :code:`<br>` This price will be compared with the
     current Azure Spot price for the VM size. Also, the prices are compared at the time of
     create/update of Azure Spot VM/VMSS and the operation will only succeed if  the maxPrice is
     greater than the current Azure Spot price. :code:`<br>`\\ :code:`<br>` The maxPrice will also
     be used for evicting a Azure Spot VM/VMSS if the current Azure Spot price goes beyond the
     maxPrice after creation of VM/VMSS. :code:`<br>`\\ :code:`<br>` Possible values are:
     :code:`<br>`\\ :code:`<br>` - Any decimal value greater than zero. Example: 0.01538
     :code:`<br>`\\ :code:`<br>` -1 – indicates default price to be up-to on-demand. :code:`<br>`\\
     :code:`<br>` You can set the maxPrice to -1 to indicate that the Azure Spot VM/VMSS should not
     be evicted for price reasons. Also, the default max price is -1 if it is not provided by you.
     :code:`<br>`\\ :code:`<br>`Minimum api-version: 2019-03-01.
    :vartype max_price: float
    """

    _attribute_map = {
        "max_price": {"key": "maxPrice", "type": "float"},
    }

    def __init__(self, *, max_price: Optional[float] = None, **kwargs: Any) -> None:
        """
        :keyword max_price: Specifies the maximum price you are willing to pay for a Azure Spot
         VM/VMSS. This price is in US Dollars. :code:`<br>`\\ :code:`<br>` This price will be compared
         with the current Azure Spot price for the VM size. Also, the prices are compared at the time of
         create/update of Azure Spot VM/VMSS and the operation will only succeed if  the maxPrice is
         greater than the current Azure Spot price. :code:`<br>`\\ :code:`<br>` The maxPrice will also
         be used for evicting a Azure Spot VM/VMSS if the current Azure Spot price goes beyond the
         maxPrice after creation of VM/VMSS. :code:`<br>`\\ :code:`<br>` Possible values are:
         :code:`<br>`\\ :code:`<br>` - Any decimal value greater than zero. Example: 0.01538
         :code:`<br>`\\ :code:`<br>` -1 – indicates default price to be up-to on-demand. :code:`<br>`\\
         :code:`<br>` You can set the maxPrice to -1 to indicate that the Azure Spot VM/VMSS should not
         be evicted for price reasons. Also, the default max price is -1 if it is not provided by you.
         :code:`<br>`\\ :code:`<br>`Minimum api-version: 2019-03-01.
        :paramtype max_price: float
        """
        super().__init__(**kwargs)
        self.max_price = max_price


class BootDiagnostics(_serialization.Model):
    """Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot
    to diagnose VM status. You can easily view the output of your console log. Azure also enables
    you to see a screenshot of the VM from the hypervisor.

    :ivar enabled: Whether boot diagnostics should be enabled on the Virtual Machine.
    :vartype enabled: bool
    :ivar storage_uri: Uri of the storage account to use for placing the console output and
     screenshot. If storageUri is not specified while enabling boot diagnostics, managed storage
     will be used.
    :vartype storage_uri: str
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "storage_uri": {"key": "storageUri", "type": "str"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, storage_uri: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Whether boot diagnostics should be enabled on the Virtual Machine.
        :paramtype enabled: bool
        :keyword storage_uri: Uri of the storage account to use for placing the console output and
         screenshot. If storageUri is not specified while enabling boot diagnostics, managed storage
         will be used.
        :paramtype storage_uri: str
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.storage_uri = storage_uri


class BootDiagnosticsInstanceView(_serialization.Model):
    """The instance view of a virtual machine boot diagnostics.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar console_screenshot_blob_uri: The console screenshot blob URI. **Note:** This will **not**
     be set if boot diagnostics is currently enabled with managed storage.
    :vartype console_screenshot_blob_uri: str
    :ivar serial_console_log_blob_uri: The serial console log blob Uri. **Note:** This will **not**
     be set if boot diagnostics is currently enabled with managed storage.
    :vartype serial_console_log_blob_uri: str
    :ivar status: The boot diagnostics status information for the VM. **Note:** It will be set only
     if there are errors encountered in enabling boot diagnostics.
    :vartype status: ~azure.mgmt.compute.models.InstanceViewStatus
    """

    _validation = {
        "console_screenshot_blob_uri": {"readonly": True},
        "serial_console_log_blob_uri": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "console_screenshot_blob_uri": {"key": "consoleScreenshotBlobUri", "type": "str"},
        "serial_console_log_blob_uri": {"key": "serialConsoleLogBlobUri", "type": "str"},
        "status": {"key": "status", "type": "InstanceViewStatus"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.console_screenshot_blob_uri: Optional[str] = None
        self.serial_console_log_blob_uri: Optional[str] = None
        self.status: Optional["_models.InstanceViewStatus"] = None


class CapacityReservation(TrackedResource):
    """Specifies information about the capacity reservation.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.compute.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar sku: SKU of the resource for which capacity needs be reserved. The SKU name and capacity
     is required to be set.  For Block capacity reservations, sku.capacity can only accept values 1,
     2, 4, 8, 16, 32, 64. Currently VM Skus with the capability called
     'CapacityReservationSupported' set to true are supported. When 'CapacityReservationSupported'
     is true, the SKU capability also specifies the 'SupportedCapacityReservationTypes', which lists
     the types of capacity reservations (such as Targeted or Block) that the SKU supports. Refer to
     List Microsoft.Compute SKUs in a region
     (https://docs.microsoft.com/rest/api/compute/resourceskus/list) for supported values. Required.
    :vartype sku: ~azure.mgmt.compute.models.Sku
    :ivar zones: The availability zones.
    :vartype zones: list[str]
    :ivar reservation_id: A unique id generated and assigned to the capacity reservation by the
     platform which does not change throughout the lifetime of the resource.
    :vartype reservation_id: str
    :ivar platform_fault_domain_count: Specifies the value of fault domain count that Capacity
     Reservation supports for requested VM size. **Note:** The fault domain count specified for a
     resource (like virtual machines scale set) must be less than or equal to this value if it
     deploys using capacity reservation. Minimum api-version: 2022-08-01.
    :vartype platform_fault_domain_count: int
    :ivar virtual_machines_associated: A list of all virtual machine resource ids that are
     associated with the capacity reservation.
    :vartype virtual_machines_associated: list[~azure.mgmt.compute.models.SubResourceReadOnly]
    :ivar provisioning_time: The date time when the capacity reservation was last updated.
    :vartype provisioning_time: ~datetime.datetime
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar instance_view: The Capacity reservation instance view.
    :vartype instance_view: ~azure.mgmt.compute.models.CapacityReservationInstanceView
    :ivar time_created: Specifies the time at which the Capacity Reservation resource was created.
     Minimum api-version: 2021-11-01.
    :vartype time_created: ~datetime.datetime
    :ivar schedule_profile: Defines the schedule for Block-type capacity reservations. Specifies
     the schedule during which capacity reservation is active and VM or VMSS resource can be
     allocated using reservation. This property is required and only supported when the capacity
     reservation group type is 'Block'. The scheduleProfile, start, and end fields are immutable
     after creation. Minimum API version: 2025-04-01. Please refer to
     https://aka.ms/blockcapacityreservation for more details.
    :vartype schedule_profile: ~azure.mgmt.compute.models.ScheduleProfile
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "sku": {"required": True},
        "reservation_id": {"readonly": True},
        "platform_fault_domain_count": {"readonly": True},
        "virtual_machines_associated": {"readonly": True},
        "provisioning_time": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "instance_view": {"readonly": True},
        "time_created": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
        "zones": {"key": "zones", "type": "[str]"},
        "reservation_id": {"key": "properties.reservationId", "type": "str"},
        "platform_fault_domain_count": {"key": "properties.platformFaultDomainCount", "type": "int"},
        "virtual_machines_associated": {"key": "properties.virtualMachinesAssociated", "type": "[SubResourceReadOnly]"},
        "provisioning_time": {"key": "properties.provisioningTime", "type": "iso-8601"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "instance_view": {"key": "properties.instanceView", "type": "CapacityReservationInstanceView"},
        "time_created": {"key": "properties.timeCreated", "type": "iso-8601"},
        "schedule_profile": {"key": "properties.scheduleProfile", "type": "ScheduleProfile"},
    }

    def __init__(
        self,
        *,
        location: str,
        sku: "_models.Sku",
        tags: Optional[dict[str, str]] = None,
        zones: Optional[list[str]] = None,
        schedule_profile: Optional["_models.ScheduleProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword sku: SKU of the resource for which capacity needs be reserved. The SKU name and
         capacity is required to be set.  For Block capacity reservations, sku.capacity can only accept
         values 1, 2, 4, 8, 16, 32, 64. Currently VM Skus with the capability called
         'CapacityReservationSupported' set to true are supported. When 'CapacityReservationSupported'
         is true, the SKU capability also specifies the 'SupportedCapacityReservationTypes', which lists
         the types of capacity reservations (such as Targeted or Block) that the SKU supports. Refer to
         List Microsoft.Compute SKUs in a region
         (https://docs.microsoft.com/rest/api/compute/resourceskus/list) for supported values. Required.
        :paramtype sku: ~azure.mgmt.compute.models.Sku
        :keyword zones: The availability zones.
        :paramtype zones: list[str]
        :keyword schedule_profile: Defines the schedule for Block-type capacity reservations. Specifies
         the schedule during which capacity reservation is active and VM or VMSS resource can be
         allocated using reservation. This property is required and only supported when the capacity
         reservation group type is 'Block'. The scheduleProfile, start, and end fields are immutable
         after creation. Minimum API version: 2025-04-01. Please refer to
         https://aka.ms/blockcapacityreservation for more details.
        :paramtype schedule_profile: ~azure.mgmt.compute.models.ScheduleProfile
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.sku = sku
        self.zones = zones
        self.reservation_id: Optional[str] = None
        self.platform_fault_domain_count: Optional[int] = None
        self.virtual_machines_associated: Optional[list["_models.SubResourceReadOnly"]] = None
        self.provisioning_time: Optional[datetime.datetime] = None
        self.provisioning_state: Optional[str] = None
        self.instance_view: Optional["_models.CapacityReservationInstanceView"] = None
        self.time_created: Optional[datetime.datetime] = None
        self.schedule_profile = schedule_profile


class CapacityReservationGroup(TrackedResource):
    """Specifies information about the capacity reservation group that the capacity reservations
    should be assigned to. Currently, a capacity reservation can only be added to a capacity
    reservation group at creation time. An existing capacity reservation cannot be added or moved
    to another capacity reservation group.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.compute.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar zones: The availability zones.
    :vartype zones: list[str]
    :ivar capacity_reservations: A list of all capacity reservation resource ids that belong to
     capacity reservation group.
    :vartype capacity_reservations: list[~azure.mgmt.compute.models.SubResourceReadOnly]
    :ivar virtual_machines_associated: A list of references to all virtual machines associated to
     the capacity reservation group.
    :vartype virtual_machines_associated: list[~azure.mgmt.compute.models.SubResourceReadOnly]
    :ivar instance_view: The capacity reservation group instance view which has the list of
     instance views for all the capacity reservations that belong to the capacity reservation group.
    :vartype instance_view: ~azure.mgmt.compute.models.CapacityReservationGroupInstanceView
    :ivar sharing_profile: Specifies the settings to enable sharing across subscriptions for the
     capacity reservation group resource. The capacity reservation group resource can generally be
     shared across subscriptions belonging to a single Azure AAD tenant or across AAD tenants if
     there is a trust relationship established between the tenants.  Block capacity reservation does
     not support sharing across subscriptions. **Note:** Minimum api-version: 2023-09-01. Please
     refer to https://aka.ms/computereservationsharing for more details.
    :vartype sharing_profile: ~azure.mgmt.compute.models.ResourceSharingProfile
    :ivar reservation_type: Indicates the type of capacity reservation. Allowed values are 'Block'
     for block capacity reservations and 'Targeted' for reservations that enable a VM to consume a
     specific capacity reservation when a capacity reservation group is provided. The reservation
     type is immutable and cannot be changed after it is assigned. Known values are: "Targeted" and
     "Block".
    :vartype reservation_type: str or ~azure.mgmt.compute.models.ReservationType
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "capacity_reservations": {"readonly": True},
        "virtual_machines_associated": {"readonly": True},
        "instance_view": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "zones": {"key": "zones", "type": "[str]"},
        "capacity_reservations": {"key": "properties.capacityReservations", "type": "[SubResourceReadOnly]"},
        "virtual_machines_associated": {"key": "properties.virtualMachinesAssociated", "type": "[SubResourceReadOnly]"},
        "instance_view": {"key": "properties.instanceView", "type": "CapacityReservationGroupInstanceView"},
        "sharing_profile": {"key": "properties.sharingProfile", "type": "ResourceSharingProfile"},
        "reservation_type": {"key": "properties.reservationType", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        zones: Optional[list[str]] = None,
        sharing_profile: Optional["_models.ResourceSharingProfile"] = None,
        reservation_type: Optional[Union[str, "_models.ReservationType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword zones: The availability zones.
        :paramtype zones: list[str]
        :keyword sharing_profile: Specifies the settings to enable sharing across subscriptions for the
         capacity reservation group resource. The capacity reservation group resource can generally be
         shared across subscriptions belonging to a single Azure AAD tenant or across AAD tenants if
         there is a trust relationship established between the tenants.  Block capacity reservation does
         not support sharing across subscriptions. **Note:** Minimum api-version: 2023-09-01. Please
         refer to https://aka.ms/computereservationsharing for more details.
        :paramtype sharing_profile: ~azure.mgmt.compute.models.ResourceSharingProfile
        :keyword reservation_type: Indicates the type of capacity reservation. Allowed values are
         'Block' for block capacity reservations and 'Targeted' for reservations that enable a VM to
         consume a specific capacity reservation when a capacity reservation group is provided. The
         reservation type is immutable and cannot be changed after it is assigned. Known values are:
         "Targeted" and "Block".
        :paramtype reservation_type: str or ~azure.mgmt.compute.models.ReservationType
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.zones = zones
        self.capacity_reservations: Optional[list["_models.SubResourceReadOnly"]] = None
        self.virtual_machines_associated: Optional[list["_models.SubResourceReadOnly"]] = None
        self.instance_view: Optional["_models.CapacityReservationGroupInstanceView"] = None
        self.sharing_profile = sharing_profile
        self.reservation_type = reservation_type


class CapacityReservationGroupInstanceView(_serialization.Model):
    """CapacityReservationGroupInstanceView.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar capacity_reservations: List of instance view of the capacity reservations under the
     capacity reservation group.
    :vartype capacity_reservations:
     list[~azure.mgmt.compute.models.CapacityReservationInstanceViewWithName]
    :ivar shared_subscription_ids: List of the subscriptions that the capacity reservation group is
     shared with. **Note:** Minimum api-version: 2023-09-01. Please refer to
     https://aka.ms/computereservationsharing for more details.
    :vartype shared_subscription_ids: list[~azure.mgmt.compute.models.SubResourceReadOnly]
    """

    _validation = {
        "capacity_reservations": {"readonly": True},
        "shared_subscription_ids": {"readonly": True},
    }

    _attribute_map = {
        "capacity_reservations": {"key": "capacityReservations", "type": "[CapacityReservationInstanceViewWithName]"},
        "shared_subscription_ids": {"key": "sharedSubscriptionIds", "type": "[SubResourceReadOnly]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.capacity_reservations: Optional[list["_models.CapacityReservationInstanceViewWithName"]] = None
        self.shared_subscription_ids: Optional[list["_models.SubResourceReadOnly"]] = None


class CapacityReservationGroupListResult(_serialization.Model):
    """The List capacity reservation group with resource group response.

    All required parameters must be populated in order to send to server.

    :ivar value: The list of capacity reservation groups. Required.
    :vartype value: list[~azure.mgmt.compute.models.CapacityReservationGroup]
    :ivar next_link: The URI to fetch the next page of capacity reservation groups. Call ListNext()
     with this URI to fetch the next page of capacity reservation groups.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CapacityReservationGroup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: list["_models.CapacityReservationGroup"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of capacity reservation groups. Required.
        :paramtype value: list[~azure.mgmt.compute.models.CapacityReservationGroup]
        :keyword next_link: The URI to fetch the next page of capacity reservation groups. Call
         ListNext() with this URI to fetch the next page of capacity reservation groups.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class CapacityReservationGroupUpdate(UpdateResource):
    """Specifies information about the capacity reservation group. Only tags can be updated.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar capacity_reservations: A list of all capacity reservation resource ids that belong to
     capacity reservation group.
    :vartype capacity_reservations: list[~azure.mgmt.compute.models.SubResourceReadOnly]
    :ivar virtual_machines_associated: A list of references to all virtual machines associated to
     the capacity reservation group.
    :vartype virtual_machines_associated: list[~azure.mgmt.compute.models.SubResourceReadOnly]
    :ivar instance_view: The capacity reservation group instance view which has the list of
     instance views for all the capacity reservations that belong to the capacity reservation group.
    :vartype instance_view: ~azure.mgmt.compute.models.CapacityReservationGroupInstanceView
    :ivar sharing_profile: Specifies the settings to enable sharing across subscriptions for the
     capacity reservation group resource. The capacity reservation group resource can generally be
     shared across subscriptions belonging to a single Azure AAD tenant or across AAD tenants if
     there is a trust relationship established between the tenants.  Block capacity reservation does
     not support sharing across subscriptions. **Note:** Minimum api-version: 2023-09-01. Please
     refer to https://aka.ms/computereservationsharing for more details.
    :vartype sharing_profile: ~azure.mgmt.compute.models.ResourceSharingProfile
    :ivar reservation_type: Indicates the type of capacity reservation. Allowed values are 'Block'
     for block capacity reservations and 'Targeted' for reservations that enable a VM to consume a
     specific capacity reservation when a capacity reservation group is provided. The reservation
     type is immutable and cannot be changed after it is assigned. Known values are: "Targeted" and
     "Block".
    :vartype reservation_type: str or ~azure.mgmt.compute.models.ReservationType
    """

    _validation = {
        "capacity_reservations": {"readonly": True},
        "virtual_machines_associated": {"readonly": True},
        "instance_view": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "capacity_reservations": {"key": "properties.capacityReservations", "type": "[SubResourceReadOnly]"},
        "virtual_machines_associated": {"key": "properties.virtualMachinesAssociated", "type": "[SubResourceReadOnly]"},
        "instance_view": {"key": "properties.instanceView", "type": "CapacityReservationGroupInstanceView"},
        "sharing_profile": {"key": "properties.sharingProfile", "type": "ResourceSharingProfile"},
        "reservation_type": {"key": "properties.reservationType", "type": "str"},
    }

    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
        sharing_profile: Optional["_models.ResourceSharingProfile"] = None,
        reservation_type: Optional[Union[str, "_models.ReservationType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sharing_profile: Specifies the settings to enable sharing across subscriptions for the
         capacity reservation group resource. The capacity reservation group resource can generally be
         shared across subscriptions belonging to a single Azure AAD tenant or across AAD tenants if
         there is a trust relationship established between the tenants.  Block capacity reservation does
         not support sharing across subscriptions. **Note:** Minimum api-version: 2023-09-01. Please
         refer to https://aka.ms/computereservationsharing for more details.
        :paramtype sharing_profile: ~azure.mgmt.compute.models.ResourceSharingProfile
        :keyword reservation_type: Indicates the type of capacity reservation. Allowed values are
         'Block' for block capacity reservations and 'Targeted' for reservations that enable a VM to
         consume a specific capacity reservation when a capacity reservation group is provided. The
         reservation type is immutable and cannot be changed after it is assigned. Known values are:
         "Targeted" and "Block".
        :paramtype reservation_type: str or ~azure.mgmt.compute.models.ReservationType
        """
        super().__init__(tags=tags, **kwargs)
        self.capacity_reservations: Optional[list["_models.SubResourceReadOnly"]] = None
        self.virtual_machines_associated: Optional[list["_models.SubResourceReadOnly"]] = None
        self.instance_view: Optional["_models.CapacityReservationGroupInstanceView"] = None
        self.sharing_profile = sharing_profile
        self.reservation_type = reservation_type


class CapacityReservationInstanceView(_serialization.Model):
    """The instance view of a capacity reservation that provides as snapshot of the runtime properties
    of the capacity reservation that is managed by the platform and can change outside of control
    plane operations.

    :ivar utilization_info: Unutilized capacity of the capacity reservation.
    :vartype utilization_info: ~azure.mgmt.compute.models.CapacityReservationUtilization
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.models.InstanceViewStatus]
    """

    _attribute_map = {
        "utilization_info": {"key": "utilizationInfo", "type": "CapacityReservationUtilization"},
        "statuses": {"key": "statuses", "type": "[InstanceViewStatus]"},
    }

    def __init__(
        self,
        *,
        utilization_info: Optional["_models.CapacityReservationUtilization"] = None,
        statuses: Optional[list["_models.InstanceViewStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword utilization_info: Unutilized capacity of the capacity reservation.
        :paramtype utilization_info: ~azure.mgmt.compute.models.CapacityReservationUtilization
        :keyword statuses: The resource status information.
        :paramtype statuses: list[~azure.mgmt.compute.models.InstanceViewStatus]
        """
        super().__init__(**kwargs)
        self.utilization_info = utilization_info
        self.statuses = statuses


class CapacityReservationInstanceViewWithName(CapacityReservationInstanceView):
    """The instance view of a capacity reservation that includes the name of the capacity reservation.
    It is used for the response to the instance view of a capacity reservation group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar utilization_info: Unutilized capacity of the capacity reservation.
    :vartype utilization_info: ~azure.mgmt.compute.models.CapacityReservationUtilization
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.models.InstanceViewStatus]
    :ivar name: The name of the capacity reservation.
    :vartype name: str
    """

    _validation = {
        "name": {"readonly": True},
    }

    _attribute_map = {
        "utilization_info": {"key": "utilizationInfo", "type": "CapacityReservationUtilization"},
        "statuses": {"key": "statuses", "type": "[InstanceViewStatus]"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        utilization_info: Optional["_models.CapacityReservationUtilization"] = None,
        statuses: Optional[list["_models.InstanceViewStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword utilization_info: Unutilized capacity of the capacity reservation.
        :paramtype utilization_info: ~azure.mgmt.compute.models.CapacityReservationUtilization
        :keyword statuses: The resource status information.
        :paramtype statuses: list[~azure.mgmt.compute.models.InstanceViewStatus]
        """
        super().__init__(utilization_info=utilization_info, statuses=statuses, **kwargs)
        self.name: Optional[str] = None


class CapacityReservationListResult(_serialization.Model):
    """The list capacity reservation operation response.

    All required parameters must be populated in order to send to server.

    :ivar value: The list of capacity reservations. Required.
    :vartype value: list[~azure.mgmt.compute.models.CapacityReservation]
    :ivar next_link: The URI to fetch the next page of capacity reservations. Call ListNext() with
     this URI to fetch the next page of capacity reservations.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CapacityReservation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: list["_models.CapacityReservation"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of capacity reservations. Required.
        :paramtype value: list[~azure.mgmt.compute.models.CapacityReservation]
        :keyword next_link: The URI to fetch the next page of capacity reservations. Call ListNext()
         with this URI to fetch the next page of capacity reservations.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class CapacityReservationProfile(_serialization.Model):
    """The parameters of a capacity reservation Profile.

    :ivar capacity_reservation_group: Specifies the capacity reservation group resource id that
     should be used for allocating the virtual machine or scaleset vm instances provided enough
     capacity has been reserved. Please refer to https://aka.ms/CapacityReservation for more
     details.
    :vartype capacity_reservation_group: ~azure.mgmt.compute.models.SubResource
    """

    _attribute_map = {
        "capacity_reservation_group": {"key": "capacityReservationGroup", "type": "SubResource"},
    }

    def __init__(self, *, capacity_reservation_group: Optional["_models.SubResource"] = None, **kwargs: Any) -> None:
        """
        :keyword capacity_reservation_group: Specifies the capacity reservation group resource id that
         should be used for allocating the virtual machine or scaleset vm instances provided enough
         capacity has been reserved. Please refer to https://aka.ms/CapacityReservation for more
         details.
        :paramtype capacity_reservation_group: ~azure.mgmt.compute.models.SubResource
        """
        super().__init__(**kwargs)
        self.capacity_reservation_group = capacity_reservation_group


class CapacityReservationUpdate(UpdateResource):
    """Specifies information about the capacity reservation. sku.capacity cannot be updated for Block
    Capacity Reservation. Tags can be update for all Capacity Reservation Types.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: SKU of the resource for which capacity needs be reserved. The SKU name and capacity
     is required to be set. Currently VM Skus with the capability called
     'CapacityReservationSupported' set to true are supported. When 'CapacityReservationSupported'
     is true, the SKU capability also specifies the 'SupportedCapacityReservationTypes', which lists
     the types of capacity reservations (such as Targeted or Block) that the SKU supports. Refer to
     List Microsoft.Compute SKUs in a region
     (https://docs.microsoft.com/rest/api/compute/resourceskus/list) for supported values. **Note:**
     The SKU name and capacity cannot be updated for Block capacity reservations.
    :vartype sku: ~azure.mgmt.compute.models.Sku
    :ivar reservation_id: A unique id generated and assigned to the capacity reservation by the
     platform which does not change throughout the lifetime of the resource.
    :vartype reservation_id: str
    :ivar platform_fault_domain_count: Specifies the value of fault domain count that Capacity
     Reservation supports for requested VM size. **Note:** The fault domain count specified for a
     resource (like virtual machines scale set) must be less than or equal to this value if it
     deploys using capacity reservation. Minimum api-version: 2022-08-01.
    :vartype platform_fault_domain_count: int
    :ivar virtual_machines_associated: A list of all virtual machine resource ids that are
     associated with the capacity reservation.
    :vartype virtual_machines_associated: list[~azure.mgmt.compute.models.SubResourceReadOnly]
    :ivar provisioning_time: The date time when the capacity reservation was last updated.
    :vartype provisioning_time: ~datetime.datetime
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar instance_view: The Capacity reservation instance view.
    :vartype instance_view: ~azure.mgmt.compute.models.CapacityReservationInstanceView
    :ivar time_created: Specifies the time at which the Capacity Reservation resource was created.
     Minimum api-version: 2021-11-01.
    :vartype time_created: ~datetime.datetime
    :ivar schedule_profile: Defines the schedule for Block-type capacity reservations. Specifies
     the schedule during which capacity reservation is active and VM or VMSS resource can be
     allocated using reservation. This property is required and only supported when the capacity
     reservation group type is 'Block'. The scheduleProfile, start, and end fields are immutable
     after creation. Minimum API version: 2025-04-01. Please refer to
     https://aka.ms/blockcapacityreservation for more details.
    :vartype schedule_profile: ~azure.mgmt.compute.models.ScheduleProfile
    """

    _validation = {
        "reservation_id": {"readonly": True},
        "platform_fault_domain_count": {"readonly": True},
        "virtual_machines_associated": {"readonly": True},
        "provisioning_time": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "instance_view": {"readonly": True},
        "time_created": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "Sku"},
        "reservation_id": {"key": "properties.reservationId", "type": "str"},
        "platform_fault_domain_count": {"key": "properties.platformFaultDomainCount", "type": "int"},
        "virtual_machines_associated": {"key": "properties.virtualMachinesAssociated", "type": "[SubResourceReadOnly]"},
        "provisioning_time": {"key": "properties.provisioningTime", "type": "iso-8601"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "instance_view": {"key": "properties.instanceView", "type": "CapacityReservationInstanceView"},
        "time_created": {"key": "properties.timeCreated", "type": "iso-8601"},
        "schedule_profile": {"key": "properties.scheduleProfile", "type": "ScheduleProfile"},
    }

    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
        sku: Optional["_models.Sku"] = None,
        schedule_profile: Optional["_models.ScheduleProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: SKU of the resource for which capacity needs be reserved. The SKU name and
         capacity is required to be set. Currently VM Skus with the capability called
         'CapacityReservationSupported' set to true are supported. When 'CapacityReservationSupported'
         is true, the SKU capability also specifies the 'SupportedCapacityReservationTypes', which lists
         the types of capacity reservations (such as Targeted or Block) that the SKU supports. Refer to
         List Microsoft.Compute SKUs in a region
         (https://docs.microsoft.com/rest/api/compute/resourceskus/list) for supported values. **Note:**
         The SKU name and capacity cannot be updated for Block capacity reservations.
        :paramtype sku: ~azure.mgmt.compute.models.Sku
        :keyword schedule_profile: Defines the schedule for Block-type capacity reservations. Specifies
         the schedule during which capacity reservation is active and VM or VMSS resource can be
         allocated using reservation. This property is required and only supported when the capacity
         reservation group type is 'Block'. The scheduleProfile, start, and end fields are immutable
         after creation. Minimum API version: 2025-04-01. Please refer to
         https://aka.ms/blockcapacityreservation for more details.
        :paramtype schedule_profile: ~azure.mgmt.compute.models.ScheduleProfile
        """
        super().__init__(tags=tags, **kwargs)
        self.sku = sku
        self.reservation_id: Optional[str] = None
        self.platform_fault_domain_count: Optional[int] = None
        self.virtual_machines_associated: Optional[list["_models.SubResourceReadOnly"]] = None
        self.provisioning_time: Optional[datetime.datetime] = None
        self.provisioning_state: Optional[str] = None
        self.instance_view: Optional["_models.CapacityReservationInstanceView"] = None
        self.time_created: Optional[datetime.datetime] = None
        self.schedule_profile = schedule_profile


class CapacityReservationUtilization(_serialization.Model):
    """Represents the capacity reservation utilization in terms of resources allocated.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar current_capacity: The value provides the current capacity of the VM size which was
     reserved successfully and for which the customer is getting billed. Minimum api-version:
     2022-08-01.
    :vartype current_capacity: int
    :ivar virtual_machines_allocated: A list of all virtual machines resource ids allocated against
     the capacity reservation.
    :vartype virtual_machines_allocated: list[~azure.mgmt.compute.models.SubResourceReadOnly]
    """

    _validation = {
        "current_capacity": {"readonly": True},
        "virtual_machines_allocated": {"readonly": True},
    }

    _attribute_map = {
        "current_capacity": {"key": "currentCapacity", "type": "int"},
        "virtual_machines_allocated": {"key": "virtualMachinesAllocated", "type": "[SubResourceReadOnly]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.current_capacity: Optional[int] = None
        self.virtual_machines_allocated: Optional[list["_models.SubResourceReadOnly"]] = None


class CloudService(_serialization.Model):
    """Describes the cloud service.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: Cloud service properties.
    :vartype properties: ~azure.mgmt.compute.models.CloudServiceProperties
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.compute.models.SystemData
    :ivar zones: List of logical availability zone of the resource. List should contain only 1 zone
     where cloud service should be provisioned. This field is optional.
    :vartype zones: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "properties": {"key": "properties", "type": "CloudServiceProperties"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "zones": {"key": "zones", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.CloudServiceProperties"] = None,
        zones: Optional[list[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword properties: Cloud service properties.
        :paramtype properties: ~azure.mgmt.compute.models.CloudServiceProperties
        :keyword zones: List of logical availability zone of the resource. List should contain only 1
         zone where cloud service should be provisioned. This field is optional.
        :paramtype zones: list[str]
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.location = location
        self.tags = tags
        self.properties = properties
        self.system_data: Optional["_models.SystemData"] = None
        self.zones = zones


class CloudServiceExtensionProfile(_serialization.Model):
    """Describes a cloud service extension profile.

    :ivar extensions: List of extensions for the cloud service.
    :vartype extensions: list[~azure.mgmt.compute.models.Extension]
    """

    _attribute_map = {
        "extensions": {"key": "extensions", "type": "[Extension]"},
    }

    def __init__(self, *, extensions: Optional[list["_models.Extension"]] = None, **kwargs: Any) -> None:
        """
        :keyword extensions: List of extensions for the cloud service.
        :paramtype extensions: list[~azure.mgmt.compute.models.Extension]
        """
        super().__init__(**kwargs)
        self.extensions = extensions


class CloudServiceExtensionProperties(_serialization.Model):
    """Extension Properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar publisher: The name of the extension handler publisher.
    :vartype publisher: str
    :ivar type: Specifies the type of the extension.
    :vartype type: str
    :ivar type_handler_version: Specifies the version of the extension. Specifies the version of
     the extension. If this element is not specified or an asterisk (*) is used as the value, the
     latest version of the extension is used. If the value is specified with a major version number
     and an asterisk as the minor version number (X.), the latest minor version of the specified
     major version is selected. If a major version number and a minor version number are specified
     (X.Y), the specific extension version is selected. If a version is specified, an auto-upgrade
     is performed on the role instance.
    :vartype type_handler_version: str
    :ivar auto_upgrade_minor_version: Explicitly specify whether platform can automatically upgrade
     typeHandlerVersion to higher minor versions when they become available.
    :vartype auto_upgrade_minor_version: bool
    :ivar settings: Public settings for the extension. For JSON extensions, this is the JSON
     settings for the extension. For XML Extension (like RDP), this is the XML setting for the
     extension.
    :vartype settings: JSON
    :ivar protected_settings: Protected settings for the extension which are encrypted before sent
     to the role instance.
    :vartype protected_settings: JSON
    :ivar protected_settings_from_key_vault: Protected settings for the extension, referenced using
     KeyVault which are encrypted before sent to the role instance.
    :vartype protected_settings_from_key_vault:
     ~azure.mgmt.compute.models.CloudServiceVaultAndSecretReference
    :ivar force_update_tag: Tag to force apply the provided public and protected settings.
     Changing the tag value allows for re-running the extension without changing any of the public
     or protected settings.
     If forceUpdateTag is not changed, updates to public or protected settings would still be
     applied by the handler.
     If neither forceUpdateTag nor any of public or protected settings change, extension would flow
     to the role instance with the same sequence-number, and
     it is up to handler implementation whether to re-run it or not.
    :vartype force_update_tag: str
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar roles_applied_to: Optional list of roles to apply this extension. If property is not
     specified or '*' is specified, extension is applied to all roles in the cloud service.
    :vartype roles_applied_to: list[str]
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "publisher": {"key": "publisher", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "type_handler_version": {"key": "typeHandlerVersion", "type": "str"},
        "auto_upgrade_minor_version": {"key": "autoUpgradeMinorVersion", "type": "bool"},
        "settings": {"key": "settings", "type": "object"},
        "protected_settings": {"key": "protectedSettings", "type": "object"},
        "protected_settings_from_key_vault": {
            "key": "protectedSettingsFromKeyVault",
            "type": "CloudServiceVaultAndSecretReference",
        },
        "force_update_tag": {"key": "forceUpdateTag", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "roles_applied_to": {"key": "rolesAppliedTo", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        publisher: Optional[str] = None,
        type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        auto_upgrade_minor_version: Optional[bool] = None,
        settings: Optional[JSON] = None,
        protected_settings: Optional[JSON] = None,
        protected_settings_from_key_vault: Optional["_models.CloudServiceVaultAndSecretReference"] = None,
        force_update_tag: Optional[str] = None,
        roles_applied_to: Optional[list[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword publisher: The name of the extension handler publisher.
        :paramtype publisher: str
        :keyword type: Specifies the type of the extension.
        :paramtype type: str
        :keyword type_handler_version: Specifies the version of the extension. Specifies the version of
         the extension. If this element is not specified or an asterisk (*) is used as the value, the
         latest version of the extension is used. If the value is specified with a major version number
         and an asterisk as the minor version number (X.), the latest minor version of the specified
         major version is selected. If a major version number and a minor version number are specified
         (X.Y), the specific extension version is selected. If a version is specified, an auto-upgrade
         is performed on the role instance.
        :paramtype type_handler_version: str
        :keyword auto_upgrade_minor_version: Explicitly specify whether platform can automatically
         upgrade typeHandlerVersion to higher minor versions when they become available.
        :paramtype auto_upgrade_minor_version: bool
        :keyword settings: Public settings for the extension. For JSON extensions, this is the JSON
         settings for the extension. For XML Extension (like RDP), this is the XML setting for the
         extension.
        :paramtype settings: JSON
        :keyword protected_settings: Protected settings for the extension which are encrypted before
         sent to the role instance.
        :paramtype protected_settings: JSON
        :keyword protected_settings_from_key_vault: Protected settings for the extension, referenced
         using KeyVault which are encrypted before sent to the role instance.
        :paramtype protected_settings_from_key_vault:
         ~azure.mgmt.compute.models.CloudServiceVaultAndSecretReference
        :keyword force_update_tag: Tag to force apply the provided public and protected settings.
         Changing the tag value allows for re-running the extension without changing any of the public
         or protected settings.
         If forceUpdateTag is not changed, updates to public or protected settings would still be
         applied by the handler.
         If neither forceUpdateTag nor any of public or protected settings change, extension would flow
         to the role instance with the same sequence-number, and
         it is up to handler implementation whether to re-run it or not.
        :paramtype force_update_tag: str
        :keyword roles_applied_to: Optional list of roles to apply this extension. If property is not
         specified or '*' is specified, extension is applied to all roles in the cloud service.
        :paramtype roles_applied_to: list[str]
        """
        super().__init__(**kwargs)
        self.publisher = publisher
        self.type = type
        self.type_handler_version = type_handler_version
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.settings = settings
        self.protected_settings = protected_settings
        self.protected_settings_from_key_vault = protected_settings_from_key_vault
        self.force_update_tag = force_update_tag
        self.provisioning_state: Optional[str] = None
        self.roles_applied_to = roles_applied_to


class CloudServiceInstanceView(_serialization.Model):
    """InstanceView of CloudService as a whole.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar role_instance: Instance view statuses.
    :vartype role_instance: ~azure.mgmt.compute.models.InstanceViewStatusesSummary
    :ivar sdk_version: The version of the SDK that was used to generate the package for the cloud
     service.
    :vartype sdk_version: str
    :ivar private_ids: Specifies a list of unique identifiers generated internally for the cloud
     service. :code:`<br />`\\ :code:`<br />` NOTE: If you are using Azure Diagnostics extension,
     this property can be used as 'DeploymentId' for querying details.
    :vartype private_ids: list[str]
    :ivar statuses:
    :vartype statuses: list[~azure.mgmt.compute.models.ResourceInstanceViewStatus]
    """

    _validation = {
        "sdk_version": {"readonly": True},
        "private_ids": {"readonly": True},
        "statuses": {"readonly": True},
    }

    _attribute_map = {
        "role_instance": {"key": "roleInstance", "type": "InstanceViewStatusesSummary"},
        "sdk_version": {"key": "sdkVersion", "type": "str"},
        "private_ids": {"key": "privateIds", "type": "[str]"},
        "statuses": {"key": "statuses", "type": "[ResourceInstanceViewStatus]"},
    }

    def __init__(self, *, role_instance: Optional["_models.InstanceViewStatusesSummary"] = None, **kwargs: Any) -> None:
        """
        :keyword role_instance: Instance view statuses.
        :paramtype role_instance: ~azure.mgmt.compute.models.InstanceViewStatusesSummary
        """
        super().__init__(**kwargs)
        self.role_instance = role_instance
        self.sdk_version: Optional[str] = None
        self.private_ids: Optional[list[str]] = None
        self.statuses: Optional[list["_models.ResourceInstanceViewStatus"]] = None


class CloudServiceListResult(_serialization.Model):
    """The list operation result.

    All required parameters must be populated in order to send to server.

    :ivar value: The list of resources. Required.
    :vartype value: list[~azure.mgmt.compute.models.CloudService]
    :ivar next_link: The URI to fetch the next page of resources. Use this to get the next page of
     resources. Do this till nextLink is null to fetch all the resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CloudService]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: list["_models.CloudService"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of resources. Required.
        :paramtype value: list[~azure.mgmt.compute.models.CloudService]
        :keyword next_link: The URI to fetch the next page of resources. Use this to get the next page
         of resources. Do this till nextLink is null to fetch all the resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class CloudServiceNetworkProfile(_serialization.Model):
    """Network Profile for the cloud service.

    :ivar load_balancer_configurations: List of Load balancer configurations. Cloud service can
     have up to two load balancer configurations, corresponding to a Public Load Balancer and an
     Internal Load Balancer.
    :vartype load_balancer_configurations:
     list[~azure.mgmt.compute.models.LoadBalancerConfiguration]
    :ivar slot_type: Slot type for the cloud service.
     Possible values are :code:`<br />`\\ :code:`<br />`\\ **Production**\\ :code:`<br />`\\
     :code:`<br />`\\ **Staging**\\ :code:`<br />`\\ :code:`<br />`
     If not specified, the default value is Production. Known values are: "Production" and
     "Staging".
    :vartype slot_type: str or ~azure.mgmt.compute.models.CloudServiceSlotType
    :ivar swappable_cloud_service: The id reference of the cloud service containing the target IP
     with which the subject cloud service can perform a swap. This property cannot be updated once
     it is set. The swappable cloud service referred by this id must be present otherwise an error
     will be thrown.
    :vartype swappable_cloud_service: ~azure.mgmt.compute.models.SubResource
    """

    _attribute_map = {
        "load_balancer_configurations": {"key": "loadBalancerConfigurations", "type": "[LoadBalancerConfiguration]"},
        "slot_type": {"key": "slotType", "type": "str"},
        "swappable_cloud_service": {"key": "swappableCloudService", "type": "SubResource"},
    }

    def __init__(
        self,
        *,
        load_balancer_configurations: Optional[list["_models.LoadBalancerConfiguration"]] = None,
        slot_type: Optional[Union[str, "_models.CloudServiceSlotType"]] = None,
        swappable_cloud_service: Optional["_models.SubResource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword load_balancer_configurations: List of Load balancer configurations. Cloud service can
         have up to two load balancer configurations, corresponding to a Public Load Balancer and an
         Internal Load Balancer.
        :paramtype load_balancer_configurations:
         list[~azure.mgmt.compute.models.LoadBalancerConfiguration]
        :keyword slot_type: Slot type for the cloud service.
         Possible values are :code:`<br />`\\ :code:`<br />`\\ **Production**\\ :code:`<br />`\\
         :code:`<br />`\\ **Staging**\\ :code:`<br />`\\ :code:`<br />`
         If not specified, the default value is Production. Known values are: "Production" and
         "Staging".
        :paramtype slot_type: str or ~azure.mgmt.compute.models.CloudServiceSlotType
        :keyword swappable_cloud_service: The id reference of the cloud service containing the target
         IP with which the subject cloud service can perform a swap. This property cannot be updated
         once it is set. The swappable cloud service referred by this id must be present otherwise an
         error will be thrown.
        :paramtype swappable_cloud_service: ~azure.mgmt.compute.models.SubResource
        """
        super().__init__(**kwargs)
        self.load_balancer_configurations = load_balancer_configurations
        self.slot_type = slot_type
        self.swappable_cloud_service = swappable_cloud_service


class CloudServiceOsProfile(_serialization.Model):
    """Describes the OS profile for the cloud service.

    :ivar secrets: Specifies set of certificates that should be installed onto the role instances.
    :vartype secrets: list[~azure.mgmt.compute.models.CloudServiceVaultSecretGroup]
    """

    _attribute_map = {
        "secrets": {"key": "secrets", "type": "[CloudServiceVaultSecretGroup]"},
    }

    def __init__(
        self, *, secrets: Optional[list["_models.CloudServiceVaultSecretGroup"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword secrets: Specifies set of certificates that should be installed onto the role
         instances.
        :paramtype secrets: list[~azure.mgmt.compute.models.CloudServiceVaultSecretGroup]
        """
        super().__init__(**kwargs)
        self.secrets = secrets


class CloudServiceProperties(_serialization.Model):
    """Cloud service properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar package_url: Specifies a URL that refers to the location of the service package in the
     Blob service. The service package URL can be Shared Access Signature (SAS) URI from any storage
     account.
     This is a write-only property and is not returned in GET calls.
    :vartype package_url: str
    :ivar configuration: Specifies the XML service configuration (.cscfg) for the cloud service.
    :vartype configuration: str
    :ivar configuration_url: Specifies a URL that refers to the location of the service
     configuration in the Blob service. The service package URL  can be Shared Access Signature
     (SAS) URI from any storage account.
     This is a write-only property and is not returned in GET calls.
    :vartype configuration_url: str
    :ivar start_cloud_service: (Optional) Indicates whether to start the cloud service immediately
     after it is created. The default value is ``true``.
     If false, the service model is still deployed, but the code is not run immediately. Instead,
     the service is PoweredOff until you call Start, at which time the service will be started. A
     deployed service still incurs charges, even if it is poweredoff.
    :vartype start_cloud_service: bool
    :ivar allow_model_override: (Optional) Indicates whether the role sku properties
     (roleProfile.roles.sku) specified in the model/template should override the role instance count
     and vm size specified in the .cscfg and .csdef respectively.
     The default value is ``false``.
    :vartype allow_model_override: bool
    :ivar upgrade_mode: Update mode for the cloud service. Role instances are allocated to update
     domains when the service is deployed. Updates can be initiated manually in each update domain
     or initiated automatically in all update domains.
     Possible Values are :code:`<br />`\\ :code:`<br />`\\ **Auto**\\ :code:`<br />`\\ :code:`<br
     />`\\ **Manual** :code:`<br />`\\ :code:`<br />`\\ **Simultaneous**\\ :code:`<br />`\\
     :code:`<br />`
     If not specified, the default value is Auto. If set to Manual, PUT UpdateDomain must be called
     to apply the update. If set to Auto, the update is automatically applied to each update domain
     in sequence. Known values are: "Auto", "Manual", and "Simultaneous".
    :vartype upgrade_mode: str or ~azure.mgmt.compute.models.CloudServiceUpgradeMode
    :ivar role_profile: Describes the role profile for the cloud service.
    :vartype role_profile: ~azure.mgmt.compute.models.CloudServiceRoleProfile
    :ivar os_profile: Describes the OS profile for the cloud service.
    :vartype os_profile: ~azure.mgmt.compute.models.CloudServiceOsProfile
    :ivar network_profile: Network Profile for the cloud service.
    :vartype network_profile: ~azure.mgmt.compute.models.CloudServiceNetworkProfile
    :ivar extension_profile: Describes a cloud service extension profile.
    :vartype extension_profile: ~azure.mgmt.compute.models.CloudServiceExtensionProfile
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar unique_id: The unique identifier for the cloud service.
    :vartype unique_id: str
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "unique_id": {"readonly": True},
    }

    _attribute_map = {
        "package_url": {"key": "packageUrl", "type": "str"},
        "configuration": {"key": "configuration", "type": "str"},
        "configuration_url": {"key": "configurationUrl", "type": "str"},
        "start_cloud_service": {"key": "startCloudService", "type": "bool"},
        "allow_model_override": {"key": "allowModelOverride", "type": "bool"},
        "upgrade_mode": {"key": "upgradeMode", "type": "str"},
        "role_profile": {"key": "roleProfile", "type": "CloudServiceRoleProfile"},
        "os_profile": {"key": "osProfile", "type": "CloudServiceOsProfile"},
        "network_profile": {"key": "networkProfile", "type": "CloudServiceNetworkProfile"},
        "extension_profile": {"key": "extensionProfile", "type": "CloudServiceExtensionProfile"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "unique_id": {"key": "uniqueId", "type": "str"},
    }

    def __init__(
        self,
        *,
        package_url: Optional[str] = None,
        configuration: Optional[str] = None,
        configuration_url: Optional[str] = None,
        start_cloud_service: Optional[bool] = None,
        allow_model_override: Optional[bool] = None,
        upgrade_mode: Optional[Union[str, "_models.CloudServiceUpgradeMode"]] = None,
        role_profile: Optional["_models.CloudServiceRoleProfile"] = None,
        os_profile: Optional["_models.CloudServiceOsProfile"] = None,
        network_profile: Optional["_models.CloudServiceNetworkProfile"] = None,
        extension_profile: Optional["_models.CloudServiceExtensionProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword package_url: Specifies a URL that refers to the location of the service package in the
         Blob service. The service package URL can be Shared Access Signature (SAS) URI from any storage
         account.
         This is a write-only property and is not returned in GET calls.
        :paramtype package_url: str
        :keyword configuration: Specifies the XML service configuration (.cscfg) for the cloud service.
        :paramtype configuration: str
        :keyword configuration_url: Specifies a URL that refers to the location of the service
         configuration in the Blob service. The service package URL  can be Shared Access Signature
         (SAS) URI from any storage account.
         This is a write-only property and is not returned in GET calls.
        :paramtype configuration_url: str
        :keyword start_cloud_service: (Optional) Indicates whether to start the cloud service
         immediately after it is created. The default value is ``true``.
         If false, the service model is still deployed, but the code is not run immediately. Instead,
         the service is PoweredOff until you call Start, at which time the service will be started. A
         deployed service still incurs charges, even if it is poweredoff.
        :paramtype start_cloud_service: bool
        :keyword allow_model_override: (Optional) Indicates whether the role sku properties
         (roleProfile.roles.sku) specified in the model/template should override the role instance count
         and vm size specified in the .cscfg and .csdef respectively.
         The default value is ``false``.
        :paramtype allow_model_override: bool
        :keyword upgrade_mode: Update mode for the cloud service. Role instances are allocated to
         update domains when the service is deployed. Updates can be initiated manually in each update
         domain or initiated automatically in all update domains.
         Possible Values are :code:`<br />`\\ :code:`<br />`\\ **Auto**\\ :code:`<br />`\\ :code:`<br
         />`\\ **Manual** :code:`<br />`\\ :code:`<br />`\\ **Simultaneous**\\ :code:`<br />`\\
         :code:`<br />`
         If not specified, the default value is Auto. If set to Manual, PUT UpdateDomain must be called
         to apply the update. If set to Auto, the update is automatically applied to each update domain
         in sequence. Known values are: "Auto", "Manual", and "Simultaneous".
        :paramtype upgrade_mode: str or ~azure.mgmt.compute.models.CloudServiceUpgradeMode
        :keyword role_profile: Describes the role profile for the cloud service.
        :paramtype role_profile: ~azure.mgmt.compute.models.CloudServiceRoleProfile
        :keyword os_profile: Describes the OS profile for the cloud service.
        :paramtype os_profile: ~azure.mgmt.compute.models.CloudServiceOsProfile
        :keyword network_profile: Network Profile for the cloud service.
        :paramtype network_profile: ~azure.mgmt.compute.models.CloudServiceNetworkProfile
        :keyword extension_profile: Describes a cloud service extension profile.
        :paramtype extension_profile: ~azure.mgmt.compute.models.CloudServiceExtensionProfile
        """
        super().__init__(**kwargs)
        self.package_url = package_url
        self.configuration = configuration
        self.configuration_url = configuration_url
        self.start_cloud_service = start_cloud_service
        self.allow_model_override = allow_model_override
        self.upgrade_mode = upgrade_mode
        self.role_profile = role_profile
        self.os_profile = os_profile
        self.network_profile = network_profile
        self.extension_profile = extension_profile
        self.provisioning_state: Optional[str] = None
        self.unique_id: Optional[str] = None


class CloudServiceRole(_serialization.Model):
    """Describes a role of the cloud service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar sku: Describes the cloud service role sku.
    :vartype sku: ~azure.mgmt.compute.models.CloudServiceRoleSku
    :ivar properties: The cloud service role properties.
    :vartype properties: ~azure.mgmt.compute.models.CloudServiceRoleProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "sku": {"key": "sku", "type": "CloudServiceRoleSku"},
        "properties": {"key": "properties", "type": "CloudServiceRoleProperties"},
    }

    def __init__(
        self,
        *,
        sku: Optional["_models.CloudServiceRoleSku"] = None,
        properties: Optional["_models.CloudServiceRoleProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword sku: Describes the cloud service role sku.
        :paramtype sku: ~azure.mgmt.compute.models.CloudServiceRoleSku
        :keyword properties: The cloud service role properties.
        :paramtype properties: ~azure.mgmt.compute.models.CloudServiceRoleProperties
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.location: Optional[str] = None
        self.sku = sku
        self.properties = properties


class CloudServiceRoleListResult(_serialization.Model):
    """The list operation result.

    All required parameters must be populated in order to send to server.

    :ivar value: The list of resources. Required.
    :vartype value: list[~azure.mgmt.compute.models.CloudServiceRole]
    :ivar next_link: The URI to fetch the next page of resources. Use this to get the next page of
     resources. Do this till nextLink is null to fetch all the resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CloudServiceRole]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: list["_models.CloudServiceRole"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of resources. Required.
        :paramtype value: list[~azure.mgmt.compute.models.CloudServiceRole]
        :keyword next_link: The URI to fetch the next page of resources. Use this to get the next page
         of resources. Do this till nextLink is null to fetch all the resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class CloudServiceRoleProfile(_serialization.Model):
    """Describes the role profile for the cloud service.

    :ivar roles: List of roles for the cloud service.
    :vartype roles: list[~azure.mgmt.compute.models.CloudServiceRoleProfileProperties]
    """

    _attribute_map = {
        "roles": {"key": "roles", "type": "[CloudServiceRoleProfileProperties]"},
    }

    def __init__(
        self, *, roles: Optional[list["_models.CloudServiceRoleProfileProperties"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword roles: List of roles for the cloud service.
        :paramtype roles: list[~azure.mgmt.compute.models.CloudServiceRoleProfileProperties]
        """
        super().__init__(**kwargs)
        self.roles = roles


class CloudServiceRoleProfileProperties(_serialization.Model):
    """Describes the role properties.

    :ivar name: Resource name.
    :vartype name: str
    :ivar sku: Describes the cloud service role sku.
    :vartype sku: ~azure.mgmt.compute.models.CloudServiceRoleSku
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "sku": {"key": "sku", "type": "CloudServiceRoleSku"},
    }

    def __init__(
        self, *, name: Optional[str] = None, sku: Optional["_models.CloudServiceRoleSku"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: Resource name.
        :paramtype name: str
        :keyword sku: Describes the cloud service role sku.
        :paramtype sku: ~azure.mgmt.compute.models.CloudServiceRoleSku
        """
        super().__init__(**kwargs)
        self.name = name
        self.sku = sku


class CloudServiceRoleProperties(_serialization.Model):
    """The cloud service role properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar unique_id: Specifies the ID which uniquely identifies a cloud service role.
    :vartype unique_id: str
    """

    _validation = {
        "unique_id": {"readonly": True},
    }

    _attribute_map = {
        "unique_id": {"key": "uniqueId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.unique_id: Optional[str] = None


class CloudServiceRoleSku(_serialization.Model):
    """Describes the cloud service role sku.

    :ivar name: The sku name. NOTE: If the new SKU is not supported on the hardware the cloud
     service is currently on, you need to delete and recreate the cloud service or move back to the
     old sku.
    :vartype name: str
    :ivar tier: Specifies the tier of the cloud service. Possible Values are :code:`<br />`\\
     :code:`<br />` **Standard** :code:`<br />`\\ :code:`<br />` **Basic**.
    :vartype tier: str
    :ivar capacity: Specifies the number of role instances in the cloud service.
    :vartype capacity: int
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
    }

    def __init__(
        self, *, name: Optional[str] = None, tier: Optional[str] = None, capacity: Optional[int] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: The sku name. NOTE: If the new SKU is not supported on the hardware the cloud
         service is currently on, you need to delete and recreate the cloud service or move back to the
         old sku.
        :paramtype name: str
        :keyword tier: Specifies the tier of the cloud service. Possible Values are :code:`<br />`\\
         :code:`<br />` **Standard** :code:`<br />`\\ :code:`<br />` **Basic**.
        :paramtype tier: str
        :keyword capacity: Specifies the number of role instances in the cloud service.
        :paramtype capacity: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.capacity = capacity


class CloudServiceUpdate(_serialization.Model):
    """CloudServiceUpdate.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class CloudServiceVaultAndSecretReference(_serialization.Model):
    """Protected settings for the extension, referenced using KeyVault which are encrypted before sent
    to the role instance.

    :ivar source_vault: The ARM Resource ID of the Key Vault.
    :vartype source_vault: ~azure.mgmt.compute.models.SubResource
    :ivar secret_url: Secret URL which contains the protected settings of the extension.
    :vartype secret_url: str
    """

    _attribute_map = {
        "source_vault": {"key": "sourceVault", "type": "SubResource"},
        "secret_url": {"key": "secretUrl", "type": "str"},
    }

    def __init__(
        self, *, source_vault: Optional["_models.SubResource"] = None, secret_url: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword source_vault: The ARM Resource ID of the Key Vault.
        :paramtype source_vault: ~azure.mgmt.compute.models.SubResource
        :keyword secret_url: Secret URL which contains the protected settings of the extension.
        :paramtype secret_url: str
        """
        super().__init__(**kwargs)
        self.source_vault = source_vault
        self.secret_url = secret_url


class CloudServiceVaultCertificate(_serialization.Model):
    """Describes a single certificate reference in a Key Vault, and where the certificate should
    reside on the role instance.

    :ivar certificate_url: This is the URL of a certificate that has been uploaded to Key Vault as
     a secret.
    :vartype certificate_url: str
    :ivar is_bootstrap_certificate: Flag indicating if the certificate provided is a bootstrap
     certificate to be used by the Key Vault Extension to fetch the remaining certificates.
    :vartype is_bootstrap_certificate: bool
    """

    _attribute_map = {
        "certificate_url": {"key": "certificateUrl", "type": "str"},
        "is_bootstrap_certificate": {"key": "isBootstrapCertificate", "type": "bool"},
    }

    def __init__(
        self, *, certificate_url: Optional[str] = None, is_bootstrap_certificate: Optional[bool] = None, **kwargs: Any
    ) -> None:
        """
        :keyword certificate_url: This is the URL of a certificate that has been uploaded to Key Vault
         as a secret.
        :paramtype certificate_url: str
        :keyword is_bootstrap_certificate: Flag indicating if the certificate provided is a bootstrap
         certificate to be used by the Key Vault Extension to fetch the remaining certificates.
        :paramtype is_bootstrap_certificate: bool
        """
        super().__init__(**kwargs)
        self.certificate_url = certificate_url
        self.is_bootstrap_certificate = is_bootstrap_certificate


class CloudServiceVaultSecretGroup(_serialization.Model):
    """Describes a set of certificates which are all in the same Key Vault.

    :ivar source_vault: The relative URL of the Key Vault containing all of the certificates in
     VaultCertificates.
    :vartype source_vault: ~azure.mgmt.compute.models.SubResource
    :ivar vault_certificates: The list of key vault references in SourceVault which contain
     certificates.
    :vartype vault_certificates: list[~azure.mgmt.compute.models.CloudServiceVaultCertificate]
    """

    _attribute_map = {
        "source_vault": {"key": "sourceVault", "type": "SubResource"},
        "vault_certificates": {"key": "vaultCertificates", "type": "[CloudServiceVaultCertificate]"},
    }

    def __init__(
        self,
        *,
        source_vault: Optional["_models.SubResource"] = None,
        vault_certificates: Optional[list["_models.CloudServiceVaultCertificate"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source_vault: The relative URL of the Key Vault containing all of the certificates in
         VaultCertificates.
        :paramtype source_vault: ~azure.mgmt.compute.models.SubResource
        :keyword vault_certificates: The list of key vault references in SourceVault which contain
         certificates.
        :paramtype vault_certificates: list[~azure.mgmt.compute.models.CloudServiceVaultCertificate]
        """
        super().__init__(**kwargs)
        self.source_vault = source_vault
        self.vault_certificates = vault_certificates


class PirCommunityGalleryResource(_serialization.Model):
    """Base information about the community gallery resource in azure compute gallery.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Resource name.
    :vartype name: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar unique_id: The unique id of this community gallery.
    :vartype unique_id: str
    """

    _validation = {
        "name": {"readonly": True},
        "location": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "unique_id": {"key": "identifier.uniqueId", "type": "str"},
    }

    def __init__(self, *, unique_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword unique_id: The unique id of this community gallery.
        :paramtype unique_id: str
        """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.location: Optional[str] = None
        self.type: Optional[str] = None
        self.unique_id = unique_id


class CommunityGallery(PirCommunityGalleryResource):
    """Specifies information about the Community Gallery that you want to create or update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Resource name.
    :vartype name: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar unique_id: The unique id of this community gallery.
    :vartype unique_id: str
    :ivar disclaimer: The disclaimer for a community gallery resource.
    :vartype disclaimer: str
    :ivar artifact_tags: The artifact tags of a community gallery resource.
    :vartype artifact_tags: dict[str, str]
    :ivar community_metadata: The metadata of community gallery.
    :vartype community_metadata: ~azure.mgmt.compute.models.CommunityGalleryMetadata
    """

    _validation = {
        "name": {"readonly": True},
        "location": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "unique_id": {"key": "identifier.uniqueId", "type": "str"},
        "disclaimer": {"key": "properties.disclaimer", "type": "str"},
        "artifact_tags": {"key": "properties.artifactTags", "type": "{str}"},
        "community_metadata": {"key": "properties.communityMetadata", "type": "CommunityGalleryMetadata"},
    }

    def __init__(
        self,
        *,
        unique_id: Optional[str] = None,
        disclaimer: Optional[str] = None,
        artifact_tags: Optional[dict[str, str]] = None,
        community_metadata: Optional["_models.CommunityGalleryMetadata"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword unique_id: The unique id of this community gallery.
        :paramtype unique_id: str
        :keyword disclaimer: The disclaimer for a community gallery resource.
        :paramtype disclaimer: str
        :keyword artifact_tags: The artifact tags of a community gallery resource.
        :paramtype artifact_tags: dict[str, str]
        :keyword community_metadata: The metadata of community gallery.
        :paramtype community_metadata: ~azure.mgmt.compute.models.CommunityGalleryMetadata
        """
        super().__init__(unique_id=unique_id, **kwargs)
        self.disclaimer = disclaimer
        self.artifact_tags = artifact_tags
        self.community_metadata = community_metadata


class CommunityGalleryImage(PirCommunityGalleryResource):
    """Specifies information about the gallery image definition that you want to create or update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Resource name.
    :vartype name: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar unique_id: The unique id of this community gallery.
    :vartype unique_id: str
    :ivar os_type: This property allows you to specify the type of the OS that is included in the
     disk when creating a VM from a managed image. Possible values are: **Windows,** **Linux.**.
     Known values are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
    :ivar os_state: This property allows the user to specify whether the virtual machines created
     under this image are 'Generalized' or 'Specialized'. Known values are: "Generalized" and
     "Specialized".
    :vartype os_state: str or ~azure.mgmt.compute.models.OperatingSystemStateTypes
    :ivar end_of_life_date: The end of life date of the gallery image definition. This property can
     be used for decommissioning purposes. This property is updatable.
    :vartype end_of_life_date: ~datetime.datetime
    :ivar identifier: This is the community gallery image definition identifier.
    :vartype identifier: ~azure.mgmt.compute.models.CommunityGalleryImageIdentifier
    :ivar recommended: The properties describe the recommended machine configuration for this Image
     Definition. These properties are updatable.
    :vartype recommended: ~azure.mgmt.compute.models.RecommendedMachineConfiguration
    :ivar disallowed: Describes the disallowed disk types.
    :vartype disallowed: ~azure.mgmt.compute.models.Disallowed
    :ivar hyper_v_generation: The hypervisor generation of the Virtual Machine. Applicable to OS
     disks only. Known values are: "V1" and "V2".
    :vartype hyper_v_generation: str or ~azure.mgmt.compute.models.HyperVGeneration
    :ivar features: A list of gallery image features.
    :vartype features: list[~azure.mgmt.compute.models.GalleryImageFeature]
    :ivar purchase_plan: Describes the gallery image definition purchase plan. This is used by
     marketplace images.
    :vartype purchase_plan: ~azure.mgmt.compute.models.ImagePurchasePlan
    :ivar architecture: The architecture of the image. Applicable to OS disks only. Known values
     are: "x64" and "Arm64".
    :vartype architecture: str or ~azure.mgmt.compute.models.Architecture
    :ivar privacy_statement_uri: Privacy statement URI for the current community gallery image.
    :vartype privacy_statement_uri: str
    :ivar eula: The end-user license agreement for the current community gallery image.
    :vartype eula: str
    :ivar disclaimer: The disclaimer for a community gallery resource.
    :vartype disclaimer: str
    :ivar artifact_tags: The artifact tags of a community gallery resource.
    :vartype artifact_tags: dict[str, str]
    """

    _validation = {
        "name": {"readonly": True},
        "location": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "unique_id": {"key": "identifier.uniqueId", "type": "str"},
        "os_type": {"key": "properties.osType", "type": "str"},
        "os_state": {"key": "properties.osState", "type": "str"},
        "end_of_life_date": {"key": "properties.endOfLifeDate", "type": "iso-8601"},
        "identifier": {"key": "properties.identifier", "type": "CommunityGalleryImageIdentifier"},
        "recommended": {"key": "properties.recommended", "type": "RecommendedMachineConfiguration"},
        "disallowed": {"key": "properties.disallowed", "type": "Disallowed"},
        "hyper_v_generation": {"key": "properties.hyperVGeneration", "type": "str"},
        "features": {"key": "properties.features", "type": "[GalleryImageFeature]"},
        "purchase_plan": {"key": "properties.purchasePlan", "type": "ImagePurchasePlan"},
        "architecture": {"key": "properties.architecture", "type": "str"},
        "privacy_statement_uri": {"key": "properties.privacyStatementUri", "type": "str"},
        "eula": {"key": "properties.eula", "type": "str"},
        "disclaimer": {"key": "properties.disclaimer", "type": "str"},
        "artifact_tags": {"key": "properties.artifactTags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        unique_id: Optional[str] = None,
        os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None,
        os_state: Optional[Union[str, "_models.OperatingSystemStateTypes"]] = None,
        end_of_life_date: Optional[datetime.datetime] = None,
        identifier: Optional["_models.CommunityGalleryImageIdentifier"] = None,
        recommended: Optional["_models.RecommendedMachineConfiguration"] = None,
        disallowed: Optional["_models.Disallowed"] = None,
        hyper_v_generation: Optional[Union[str, "_models.HyperVGeneration"]] = None,
        features: Optional[list["_models.GalleryImageFeature"]] = None,
        purchase_plan: Optional["_models.ImagePurchasePlan"] = None,
        architecture: Optional[Union[str, "_models.Architecture"]] = None,
        privacy_statement_uri: Optional[str] = None,
        eula: Optional[str] = None,
        disclaimer: Optional[str] = None,
        artifact_tags: Optional[dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword unique_id: The unique id of this community gallery.
        :paramtype unique_id: str
        :keyword os_type: This property allows you to specify the type of the OS that is included in
         the disk when creating a VM from a managed image. Possible values are: **Windows,** **Linux.**.
         Known values are: "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
        :keyword os_state: This property allows the user to specify whether the virtual machines
         created under this image are 'Generalized' or 'Specialized'. Known values are: "Generalized"
         and "Specialized".
        :paramtype os_state: str or ~azure.mgmt.compute.models.OperatingSystemStateTypes
        :keyword end_of_life_date: The end of life date of the gallery image definition. This property
         can be used for decommissioning purposes. This property is updatable.
        :paramtype end_of_life_date: ~datetime.datetime
        :keyword identifier: This is the community gallery image definition identifier.
        :paramtype identifier: ~azure.mgmt.compute.models.CommunityGalleryImageIdentifier
        :keyword recommended: The properties describe the recommended machine configuration for this
         Image Definition. These properties are updatable.
        :paramtype recommended: ~azure.mgmt.compute.models.RecommendedMachineConfiguration
        :keyword disallowed: Describes the disallowed disk types.
        :paramtype disallowed: ~azure.mgmt.compute.models.Disallowed
        :keyword hyper_v_generation: The hypervisor generation of the Virtual Machine. Applicable to OS
         disks only. Known values are: "V1" and "V2".
        :paramtype hyper_v_generation: str or ~azure.mgmt.compute.models.HyperVGeneration
        :keyword features: A list of gallery image features.
        :paramtype features: list[~azure.mgmt.compute.models.GalleryImageFeature]
        :keyword purchase_plan: Describes the gallery image definition purchase plan. This is used by
         marketplace images.
        :paramtype purchase_plan: ~azure.mgmt.compute.models.ImagePurchasePlan
        :keyword architecture: The architecture of the image. Applicable to OS disks only. Known values
         are: "x64" and "Arm64".
        :paramtype architecture: str or ~azure.mgmt.compute.models.Architecture
        :keyword privacy_statement_uri: Privacy statement URI for the current community gallery image.
        :paramtype privacy_statement_uri: str
        :keyword eula: The end-user license agreement for the current community gallery image.
        :paramtype eula: str
        :keyword disclaimer: The disclaimer for a community gallery resource.
        :paramtype disclaimer: str
        :keyword artifact_tags: The artifact tags of a community gallery resource.
        :paramtype artifact_tags: dict[str, str]
        """
        super().__init__(unique_id=unique_id, **kwargs)
        self.os_type = os_type
        self.os_state = os_state
        self.end_of_life_date = end_of_life_date
        self.identifier = identifier
        self.recommended = recommended
        self.disallowed = disallowed
        self.hyper_v_generation = hyper_v_generation
        self.features = features
        self.purchase_plan = purchase_plan
        self.architecture = architecture
        self.privacy_statement_uri = privacy_statement_uri
        self.eula = eula
        self.disclaimer = disclaimer
        self.artifact_tags = artifact_tags


class CommunityGalleryImageIdentifier(_serialization.Model):
    """This is the community gallery image definition identifier.

    :ivar publisher: The name of the gallery image definition publisher.
    :vartype publisher: str
    :ivar offer: The name of the gallery image definition offer.
    :vartype offer: str
    :ivar sku: The name of the gallery image definition SKU.
    :vartype sku: str
    """

    _attribute_map = {
        "publisher": {"key": "publisher", "type": "str"},
        "offer": {"key": "offer", "type": "str"},
        "sku": {"key": "sku", "type": "str"},
    }

    def __init__(
        self, *, publisher: Optional[str] = None, offer: Optional[str] = None, sku: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword publisher: The name of the gallery image definition publisher.
        :paramtype publisher: str
        :keyword offer: The name of the gallery image definition offer.
        :paramtype offer: str
        :keyword sku: The name of the gallery image definition SKU.
        :paramtype sku: str
        """
        super().__init__(**kwargs)
        self.publisher = publisher
        self.offer = offer
        self.sku = sku


class CommunityGalleryImageList(_serialization.Model):
    """The List Community Gallery Images operation response.

    All required parameters must be populated in order to send to server.

    :ivar value: A list of community gallery images. Required.
    :vartype value: list[~azure.mgmt.compute.models.CommunityGalleryImage]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CommunityGalleryImage]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: list["_models.CommunityGalleryImage"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of community gallery images. Required.
        :paramtype value: list[~azure.mgmt.compute.models.CommunityGalleryImage]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class CommunityGalleryImageVersion(PirCommunityGalleryResource):
    """Specifies information about the gallery image version that you want to create or update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Resource name.
    :vartype name: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar unique_id: The unique id of this community gallery.
    :vartype unique_id: str
    :ivar published_date: The published date of the gallery image version Definition. This property
     can be used for decommissioning purposes. This property is updatable.
    :vartype published_date: ~datetime.datetime
    :ivar end_of_life_date: The end of life date of the gallery image version Definition. This
     property can be used for decommissioning purposes. This property is updatable.
    :vartype end_of_life_date: ~datetime.datetime
    :ivar exclude_from_latest: If set to true, Virtual Machines deployed from the latest version of
     the Image Definition won't use this Image Version.
    :vartype exclude_from_latest: bool
    :ivar storage_profile: Describes the storage profile of the image version.
    :vartype storage_profile: ~azure.mgmt.compute.models.SharedGalleryImageVersionStorageProfile
    :ivar disclaimer: The disclaimer for a community gallery resource.
    :vartype disclaimer: str
    :ivar artifact_tags: The artifact tags of a community gallery resource.
    :vartype artifact_tags: dict[str, str]
    """

    _validation = {
        "name": {"readonly": True},
        "location": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "unique_id": {"key": "identifier.uniqueId", "type": "str"},
        "published_date": {"key": "properties.publishedDate", "type": "iso-8601"},
        "end_of_life_date": {"key": "properties.endOfLifeDate", "type": "iso-8601"},
        "exclude_from_latest": {"key": "properties.excludeFromLatest", "type": "bool"},
        "storage_profile": {"key": "properties.storageProfile", "type": "SharedGalleryImageVersionStorageProfile"},
        "disclaimer": {"key": "properties.disclaimer", "type": "str"},
        "artifact_tags": {"key": "properties.artifactTags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        unique_id: Optional[str] = None,
        published_date: Optional[datetime.datetime] = None,
        end_of_life_date: Optional[datetime.datetime] = None,
        exclude_from_latest: Optional[bool] = None,
        storage_profile: Optional["_models.SharedGalleryImageVersionStorageProfile"] = None,
        disclaimer: Optional[str] = None,
        artifact_tags: Optional[dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword unique_id: The unique id of this community gallery.
        :paramtype unique_id: str
        :keyword published_date: The published date of the gallery image version Definition. This
         property can be used for decommissioning purposes. This property is updatable.
        :paramtype published_date: ~datetime.datetime
        :keyword end_of_life_date: The end of life date of the gallery image version Definition. This
         property can be used for decommissioning purposes. This property is updatable.
        :paramtype end_of_life_date: ~datetime.datetime
        :keyword exclude_from_latest: If set to true, Virtual Machines deployed from the latest version
         of the Image Definition won't use this Image Version.
        :paramtype exclude_from_latest: bool
        :keyword storage_profile: Describes the storage profile of the image version.
        :paramtype storage_profile: ~azure.mgmt.compute.models.SharedGalleryImageVersionStorageProfile
        :keyword disclaimer: The disclaimer for a community gallery resource.
        :paramtype disclaimer: str
        :keyword artifact_tags: The artifact tags of a community gallery resource.
        :paramtype artifact_tags: dict[str, str]
        """
        super().__init__(unique_id=unique_id, **kwargs)
        self.published_date = published_date
        self.end_of_life_date = end_of_life_date
        self.exclude_from_latest = exclude_from_latest
        self.storage_profile = storage_profile
        self.disclaimer = disclaimer
        self.artifact_tags = artifact_tags


class CommunityGalleryImageVersionList(_serialization.Model):
    """The List Community Gallery Image versions operation response.

    All required parameters must be populated in order to send to server.

    :ivar value: A list of community gallery image versions. Required.
    :vartype value: list[~azure.mgmt.compute.models.CommunityGalleryImageVersion]
    :ivar next_link: The URI to fetch the next page of community gallery image versions. Call
     ListNext() with this to fetch the next page of community gallery image versions.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CommunityGalleryImageVersion]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: list["_models.CommunityGalleryImageVersion"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of community gallery image versions. Required.
        :paramtype value: list[~azure.mgmt.compute.models.CommunityGalleryImageVersion]
        :keyword next_link: The URI to fetch the next page of community gallery image versions. Call
         ListNext() with this to fetch the next page of community gallery image versions.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class CommunityGalleryInfo(_serialization.Model):
    """Information of community gallery if current gallery is shared to community.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar publisher_uri: The link to the publisher website. Visible to all users.
    :vartype publisher_uri: str
    :ivar publisher_contact: Community gallery publisher support email. The email address of the
     publisher. Visible to all users.
    :vartype publisher_contact: str
    :ivar eula: End-user license agreement for community gallery image.
    :vartype eula: str
    :ivar public_name_prefix: The prefix of the gallery name that will be displayed publicly.
     Visible to all users.
    :vartype public_name_prefix: str
    :ivar community_gallery_enabled: Contains info about whether community gallery sharing is
     enabled.
    :vartype community_gallery_enabled: bool
    :ivar public_names: Community gallery public name list.
    :vartype public_names: list[str]
    """

    _validation = {
        "community_gallery_enabled": {"readonly": True},
        "public_names": {"readonly": True},
    }

    _attribute_map = {
        "publisher_uri": {"key": "publisherUri", "type": "str"},
        "publisher_contact": {"key": "publisherContact", "type": "str"},
        "eula": {"key": "eula", "type": "str"},
        "public_name_prefix": {"key": "publicNamePrefix", "type": "str"},
        "community_gallery_enabled": {"key": "communityGalleryEnabled", "type": "bool"},
        "public_names": {"key": "publicNames", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        publisher_uri: Optional[str] = None,
        publisher_contact: Optional[str] = None,
        eula: Optional[str] = None,
        public_name_prefix: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword publisher_uri: The link to the publisher website. Visible to all users.
        :paramtype publisher_uri: str
        :keyword publisher_contact: Community gallery publisher support email. The email address of the
         publisher. Visible to all users.
        :paramtype publisher_contact: str
        :keyword eula: End-user license agreement for community gallery image.
        :paramtype eula: str
        :keyword public_name_prefix: The prefix of the gallery name that will be displayed publicly.
         Visible to all users.
        :paramtype public_name_prefix: str
        """
        super().__init__(**kwargs)
        self.publisher_uri = publisher_uri
        self.publisher_contact = publisher_contact
        self.eula = eula
        self.public_name_prefix = public_name_prefix
        self.community_gallery_enabled: Optional[bool] = None
        self.public_names: Optional[list[str]] = None


class CommunityGalleryMetadata(_serialization.Model):
    """The metadata of community gallery.

    All required parameters must be populated in order to send to server.

    :ivar publisher_uri: The publisher URI of this community gallery.
    :vartype publisher_uri: str
    :ivar publisher_contact: The publisher email id of this community gallery. Required.
    :vartype publisher_contact: str
    :ivar eula: The end-user license agreement for this community gallery.
    :vartype eula: str
    :ivar public_names: A list of public names the gallery has. Required.
    :vartype public_names: list[str]
    :ivar privacy_statement_uri: The link for the privacy statement of this community gallery from
     the gallery publisher.
    :vartype privacy_statement_uri: str
    """

    _validation = {
        "publisher_contact": {"required": True},
        "public_names": {"required": True},
    }

    _attribute_map = {
        "publisher_uri": {"key": "publisherUri", "type": "str"},
        "publisher_contact": {"key": "publisherContact", "type": "str"},
        "eula": {"key": "eula", "type": "str"},
        "public_names": {"key": "publicNames", "type": "[str]"},
        "privacy_statement_uri": {"key": "privacyStatementUri", "type": "str"},
    }

    def __init__(
        self,
        *,
        publisher_contact: str,
        public_names: list[str],
        publisher_uri: Optional[str] = None,
        eula: Optional[str] = None,
        privacy_statement_uri: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword publisher_uri: The publisher URI of this community gallery.
        :paramtype publisher_uri: str
        :keyword publisher_contact: The publisher email id of this community gallery. Required.
        :paramtype publisher_contact: str
        :keyword eula: The end-user license agreement for this community gallery.
        :paramtype eula: str
        :keyword public_names: A list of public names the gallery has. Required.
        :paramtype public_names: list[str]
        :keyword privacy_statement_uri: The link for the privacy statement of this community gallery
         from the gallery publisher.
        :paramtype privacy_statement_uri: str
        """
        super().__init__(**kwargs)
        self.publisher_uri = publisher_uri
        self.publisher_contact = publisher_contact
        self.eula = eula
        self.public_names = public_names
        self.privacy_statement_uri = privacy_statement_uri


class ConvertToVirtualMachineScaleSetInput(_serialization.Model):
    """Describes the Virtual Machine Scale Set to convert from Availability Set.

    :ivar virtual_machine_scale_set_name: Specifies information about the Virtual Machine Scale Set
     that the Availability Set should be converted to.
    :vartype virtual_machine_scale_set_name: str
    """

    _attribute_map = {
        "virtual_machine_scale_set_name": {"key": "virtualMachineScaleSetName", "type": "str"},
    }

    def __init__(self, *, virtual_machine_scale_set_name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword virtual_machine_scale_set_name: Specifies information about the Virtual Machine Scale
         Set that the Availability Set should be converted to.
        :paramtype virtual_machine_scale_set_name: str
        """
        super().__init__(**kwargs)
        self.virtual_machine_scale_set_name = virtual_machine_scale_set_name


class CopyCompletionError(_serialization.Model):
    """Indicates the error details if the background copy of a resource created via the CopyStart
    operation fails.

    All required parameters must be populated in order to send to server.

    :ivar error_code: Indicates the error code if the background copy of a resource created via the
     CopyStart operation fails. Required. "CopySourceNotFound"
    :vartype error_code: str or ~azure.mgmt.compute.models.CopyCompletionErrorReason
    :ivar error_message: Indicates the error message if the background copy of a resource created
     via the CopyStart operation fails. Required.
    :vartype error_message: str
    """

    _validation = {
        "error_code": {"required": True},
        "error_message": {"required": True},
    }

    _attribute_map = {
        "error_code": {"key": "errorCode", "type": "str"},
        "error_message": {"key": "errorMessage", "type": "str"},
    }

    def __init__(
        self, *, error_code: Union[str, "_models.CopyCompletionErrorReason"], error_message: str, **kwargs: Any
    ) -> None:
        """
        :keyword error_code: Indicates the error code if the background copy of a resource created via
         the CopyStart operation fails. Required. "CopySourceNotFound"
        :paramtype error_code: str or ~azure.mgmt.compute.models.CopyCompletionErrorReason
        :keyword error_message: Indicates the error message if the background copy of a resource
         created via the CopyStart operation fails. Required.
        :paramtype error_message: str
        """
        super().__init__(**kwargs)
        self.error_code = error_code
        self.error_message = error_message


class CreationData(_serialization.Model):
    """Data used when creating a disk.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar create_option: This enumerates the possible sources of a disk's creation. Required. Known
     values are: "Empty", "Attach", "FromImage", "Import", "Copy", "Restore", "Upload", "CopyStart",
     "ImportSecure", "UploadPreparedSecure", "CopyFromSanSnapshot", and "Import".
    :vartype create_option: str or ~azure.mgmt.compute.models.DiskCreateOption
    :ivar storage_account_id: Required if createOption is Import. The Azure Resource Manager
     identifier of the storage account containing the blob to import as a disk.
    :vartype storage_account_id: str
    :ivar image_reference: Disk source information for PIR or user images.
    :vartype image_reference: ~azure.mgmt.compute.models.ImageDiskReference
    :ivar gallery_image_reference: Required if creating from a Gallery Image. The
     id/sharedGalleryImageId/communityGalleryImageId of the ImageDiskReference will be the ARM id of
     the shared galley image version from which to create a disk.
    :vartype gallery_image_reference: ~azure.mgmt.compute.models.ImageDiskReference
    :ivar source_uri: If createOption is Import, this is the URI of a blob to be imported into a
     managed disk.
    :vartype source_uri: str
    :ivar source_resource_id: If createOption is Copy, this is the ARM id of the source snapshot or
     disk.
    :vartype source_resource_id: str
    :ivar source_unique_id: If this field is set, this is the unique id identifying the source of
     this resource.
    :vartype source_unique_id: str
    :ivar upload_size_bytes: If createOption is Upload, this is the size of the contents of the
     upload including the VHD footer. This value should be between 20972032 (20 MiB + 512 bytes for
     the VHD footer) and 35183298347520 bytes (32 TiB + 512 bytes for the VHD footer).
    :vartype upload_size_bytes: int
    :ivar logical_sector_size: Logical sector size in bytes for Ultra disks. Supported values are
     512 ad 4096. 4096 is the default.
    :vartype logical_sector_size: int
    :ivar security_data_uri: If createOption is ImportSecure, this is the URI of a blob to be
     imported into VM guest state.
    :vartype security_data_uri: str
    :ivar security_metadata_uri: If createOption is ImportSecure, this is the URI of a blob to be
     imported into VM metadata for Confidential VM.
    :vartype security_metadata_uri: str
    :ivar performance_plus: Set this flag to true to get a boost on the performance target of the
     disk deployed, see here on the respective performance target. This flag can only be set on disk
     creation time and cannot be disabled after enabled.
    :vartype performance_plus: bool
    :ivar elastic_san_resource_id: Required if createOption is CopyFromSanSnapshot. This is the ARM
     id of the source elastic san volume snapshot.
    :vartype elastic_san_resource_id: str
    :ivar provisioned_bandwidth_copy_speed: If this field is set on a snapshot and createOption is
     CopyStart, the snapshot will be copied at a quicker speed. Known values are: "None" and
     "Enhanced".
    :vartype provisioned_bandwidth_copy_speed: str or
     ~azure.mgmt.compute.models.ProvisionedBandwidthCopyOption
    :ivar instant_access_duration_minutes: For snapshots created from Premium SSD v2 or Ultra disk,
     this property determines the time in minutes the snapshot is retained for instant access to
     enable faster restore.
    :vartype instant_access_duration_minutes: int
    """

    _validation = {
        "create_option": {"required": True},
        "source_unique_id": {"readonly": True},
        "instant_access_duration_minutes": {"minimum": 1},
    }

    _attribute_map = {
        "create_option": {"key": "createOption", "type": "str"},
        "storage_account_id": {"key": "storageAccountId", "type": "str"},
        "image_reference": {"key": "imageReference", "type": "ImageDiskReference"},
        "gallery_image_reference": {"key": "galleryImageReference", "type": "ImageDiskReference"},
        "source_uri": {"key": "sourceUri", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "source_unique_id": {"key": "sourceUniqueId", "type": "str"},
        "upload_size_bytes": {"key": "uploadSizeBytes", "type": "int"},
        "logical_sector_size": {"key": "logicalSectorSize", "type": "int"},
        "security_data_uri": {"key": "securityDataUri", "type": "str"},
        "security_metadata_uri": {"key": "securityMetadataUri", "type": "str"},
        "performance_plus": {"key": "performancePlus", "type": "bool"},
        "elastic_san_resource_id": {"key": "elasticSanResourceId", "type": "str"},
        "provisioned_bandwidth_copy_speed": {"key": "provisionedBandwidthCopySpeed", "type": "str"},
        "instant_access_duration_minutes": {"key": "instantAccessDurationMinutes", "type": "int"},
    }

    def __init__(
        self,
        *,
        create_option: Union[str, "_models.DiskCreateOption"],
        storage_account_id: Optional[str] = None,
        image_reference: Optional["_models.ImageDiskReference"] = None,
        gallery_image_reference: Optional["_models.ImageDiskReference"] = None,
        source_uri: Optional[str] = None,
        source_resource_id: Optional[str] = None,
        upload_size_bytes: Optional[int] = None,
        logical_sector_size: Optional[int] = None,
        security_data_uri: Optional[str] = None,
        security_metadata_uri: Optional[str] = None,
        performance_plus: Optional[bool] = None,
        elastic_san_resource_id: Optional[str] = None,
        provisioned_bandwidth_copy_speed: Optional[Union[str, "_models.ProvisionedBandwidthCopyOption"]] = None,
        instant_access_duration_minutes: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword create_option: This enumerates the possible sources of a disk's creation. Required.
         Known values are: "Empty", "Attach", "FromImage", "Import", "Copy", "Restore", "Upload",
         "CopyStart", "ImportSecure", "UploadPreparedSecure", "CopyFromSanSnapshot", and "Import".
        :paramtype create_option: str or ~azure.mgmt.compute.models.DiskCreateOption
        :keyword storage_account_id: Required if createOption is Import. The Azure Resource Manager
         identifier of the storage account containing the blob to import as a disk.
        :paramtype storage_account_id: str
        :keyword image_reference: Disk source information for PIR or user images.
        :paramtype image_reference: ~azure.mgmt.compute.models.ImageDiskReference
        :keyword gallery_image_reference: Required if creating from a Gallery Image. The
         id/sharedGalleryImageId/communityGalleryImageId of the ImageDiskReference will be the ARM id of
         the shared galley image version from which to create a disk.
        :paramtype gallery_image_reference: ~azure.mgmt.compute.models.ImageDiskReference
        :keyword source_uri: If createOption is Import, this is the URI of a blob to be imported into a
         managed disk.
        :paramtype source_uri: str
        :keyword source_resource_id: If createOption is Copy, this is the ARM id of the source snapshot
         or disk.
        :paramtype source_resource_id: str
        :keyword upload_size_bytes: If createOption is Upload, this is the size of the contents of the
         upload including the VHD footer. This value should be between 20972032 (20 MiB + 512 bytes for
         the VHD footer) and 35183298347520 bytes (32 TiB + 512 bytes for the VHD footer).
        :paramtype upload_size_bytes: int
        :keyword logical_sector_size: Logical sector size in bytes for Ultra disks. Supported values
         are 512 ad 4096. 4096 is the default.
        :paramtype logical_sector_size: int
        :keyword security_data_uri: If createOption is ImportSecure, this is the URI of a blob to be
         imported into VM guest state.
        :paramtype security_data_uri: str
        :keyword security_metadata_uri: If createOption is ImportSecure, this is the URI of a blob to
         be imported into VM metadata for Confidential VM.
        :paramtype security_metadata_uri: str
        :keyword performance_plus: Set this flag to true to get a boost on the performance target of
         the disk deployed, see here on the respective performance target. This flag can only be set on
         disk creation time and cannot be disabled after enabled.
        :paramtype performance_plus: bool
        :keyword elastic_san_resource_id: Required if createOption is CopyFromSanSnapshot. This is the
         ARM id of the source elastic san volume snapshot.
        :paramtype elastic_san_resource_id: str
        :keyword provisioned_bandwidth_copy_speed: If this field is set on a snapshot and createOption
         is CopyStart, the snapshot will be copied at a quicker speed. Known values are: "None" and
         "Enhanced".
        :paramtype provisioned_bandwidth_copy_speed: str or
         ~azure.mgmt.compute.models.ProvisionedBandwidthCopyOption
        :keyword instant_access_duration_minutes: For snapshots created from Premium SSD v2 or Ultra
         disk, this property determines the time in minutes the snapshot is retained for instant access
         to enable faster restore.
        :paramtype instant_access_duration_minutes: int
        """
        super().__init__(**kwargs)
        self.create_option = create_option
        self.storage_account_id = storage_account_id
        self.image_reference = image_reference
        self.gallery_image_reference = gallery_image_reference
        self.source_uri = source_uri
        self.source_resource_id = source_resource_id
        self.source_unique_id: Optional[str] = None
        self.upload_size_bytes = upload_size_bytes
        self.logical_sector_size = logical_sector_size
        self.security_data_uri = security_data_uri
        self.security_metadata_uri = security_metadata_uri
        self.performance_plus = performance_plus
        self.elastic_san_resource_id = elastic_san_resource_id
        self.provisioned_bandwidth_copy_speed = provisioned_bandwidth_copy_speed
        self.instant_access_duration_minutes = instant_access_duration_minutes


class DataDisk(_serialization.Model):
    """Describes a data disk.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar lun: Specifies the logical unit number of the data disk. This value is used to identify
     data disks within the VM and therefore must be unique for each data disk attached to a VM.
     Required.
    :vartype lun: int
    :ivar name: The disk name.
    :vartype name: str
    :ivar vhd: The virtual hard disk.
    :vartype vhd: ~azure.mgmt.compute.models.VirtualHardDisk
    :ivar image: The source user image virtual hard disk. The virtual hard disk will be copied
     before being attached to the virtual machine. If SourceImage is provided, the destination
     virtual hard drive must not exist.
    :vartype image: ~azure.mgmt.compute.models.VirtualHardDisk
    :ivar caching: Specifies the caching requirements. Possible values are: **None,** **ReadOnly,**
     **ReadWrite.** The defaulting behavior is: **None for Standard storage. ReadOnly for Premium
     storage.**. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype caching: str or ~azure.mgmt.compute.models.CachingTypes
    :ivar write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
     disabled on the disk.
    :vartype write_accelerator_enabled: bool
    :ivar create_option: Specifies how the virtual machine disk should be created. Possible values
     are **Attach:** This value is used when you are using a specialized disk to create the virtual
     machine. **FromImage:** This value is used when you are using an image to create the virtual
     machine data disk. If you are using a platform image, you should also use the imageReference
     element described above. If you are using a marketplace image, you should also use the plan
     element previously described. **Empty:** This value is used when creating an empty data disk.
     **Copy:** This value is used to create a data disk from a snapshot or another disk.
     **Restore:** This value is used to create a data disk from a disk restore point. Required.
     Known values are: "FromImage", "Empty", "Attach", "Copy", and "Restore".
    :vartype create_option: str or ~azure.mgmt.compute.models.DiskCreateOptionTypes
    :ivar disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can be
     used to overwrite the size of the disk in a virtual machine image. The property 'diskSizeGB' is
     the number of bytes x 1024^3 for the disk and the value cannot be larger than 1023.
    :vartype disk_size_gb: int
    :ivar managed_disk: The managed disk parameters.
    :vartype managed_disk: ~azure.mgmt.compute.models.ManagedDiskParameters
    :ivar source_resource: The source resource identifier. It can be a snapshot, or disk restore
     point from which to create a disk.
    :vartype source_resource: ~azure.mgmt.compute.models.ApiEntityReference
    :ivar to_be_detached: Specifies whether the data disk is in process of detachment from the
     VirtualMachine/VirtualMachineScaleset.
    :vartype to_be_detached: bool
    :ivar disk_iops_read_write: Specifies the Read-Write IOPS for the managed disk when
     StorageAccountType is UltraSSD_LRS. Returned only for VirtualMachine ScaleSet VM disks. Can be
     updated only via updates to the VirtualMachine Scale Set.
    :vartype disk_iops_read_write: int
    :ivar disk_m_bps_read_write: Specifies the bandwidth in MB per second for the managed disk when
     StorageAccountType is UltraSSD_LRS. Returned only for VirtualMachine ScaleSet VM disks. Can be
     updated only via updates to the VirtualMachine Scale Set.
    :vartype disk_m_bps_read_write: int
    :ivar detach_option: Specifies the detach behavior to be used while detaching a disk or which
     is already in the process of detachment from the virtual machine. Supported values:
     **ForceDetach.** detachOption: **ForceDetach** is applicable only for managed data disks. If a
     previous detachment attempt of the data disk did not complete due to an unexpected failure from
     the virtual machine and the disk is still not released then use force-detach as a last resort
     option to detach the disk forcibly from the VM. All writes might not have been flushed when
     using this detach behavior. **This feature is still in preview**. To force-detach a data disk
     update toBeDetached to 'true' along with setting detachOption: 'ForceDetach'. "ForceDetach"
    :vartype detach_option: str or ~azure.mgmt.compute.models.DiskDetachOptionTypes
    :ivar delete_option: Specifies whether data disk should be deleted or detached upon VM
     deletion. Possible values are: **Delete.** If this value is used, the data disk is deleted when
     VM is deleted. **Detach.** If this value is used, the data disk is retained after VM is
     deleted. The default value is set to **Detach**. Known values are: "Delete" and "Detach".
    :vartype delete_option: str or ~azure.mgmt.compute.models.DiskDeleteOptionTypes
    """

    _validation = {
        "lun": {"required": True},
        "create_option": {"required": True},
        "disk_iops_read_write": {"readonly": True},
        "disk_m_bps_read_write": {"readonly": True},
    }

    _attribute_map = {
        "lun": {"key": "lun", "type": "int"},
        "name": {"key": "name", "type": "str"},
        "vhd": {"key": "vhd", "type": "VirtualHardDisk"},
        "image": {"key": "image", "type": "VirtualHardDisk"},
        "caching": {"key": "caching", "type": "str"},
        "write_accelerator_enabled": {"key": "writeAcceleratorEnabled", "type": "bool"},
        "create_option": {"key": "createOption", "type": "str"},
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
        "managed_disk": {"key": "managedDisk", "type": "ManagedDiskParameters"},
        "source_resource": {"key": "sourceResource", "type": "ApiEntityReference"},
        "to_be_detached": {"key": "toBeDetached", "type": "bool"},
        "disk_iops_read_write": {"key": "diskIOPSReadWrite", "type": "int"},
        "disk_m_bps_read_write": {"key": "diskMBpsReadWrite", "type": "int"},
        "detach_option": {"key": "detachOption", "type": "str"},
        "delete_option": {"key": "deleteOption", "type": "str"},
    }

    def __init__(
        self,
        *,
        lun: int,
        create_option: Union[str, "_models.DiskCreateOptionTypes"],
        name: Optional[str] = None,
        vhd: Optional["_models.VirtualHardDisk"] = None,
        image: Optional["_models.VirtualHardDisk"] = None,
        caching: Optional[Union[str, "_models.CachingTypes"]] = None,
        write_accelerator_enabled: Optional[bool] = None,
        disk_size_gb: Optional[int] = None,
        managed_disk: Optional["_models.ManagedDiskParameters"] = None,
        source_resource: Optional["_models.ApiEntityReference"] = None,
        to_be_detached: Optional[bool] = None,
        detach_option: Optional[Union[str, "_models.DiskDetachOptionTypes"]] = None,
        delete_option: Optional[Union[str, "_models.DiskDeleteOptionTypes"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword lun: Specifies the logical unit number of the data disk. This value is used to
         identify data disks within the VM and therefore must be unique for each data disk attached to a
         VM. Required.
        :paramtype lun: int
        :keyword name: The disk name.
        :paramtype name: str
        :keyword vhd: The virtual hard disk.
        :paramtype vhd: ~azure.mgmt.compute.models.VirtualHardDisk
        :keyword image: The source user image virtual hard disk. The virtual hard disk will be copied
         before being attached to the virtual machine. If SourceImage is provided, the destination
         virtual hard drive must not exist.
        :paramtype image: ~azure.mgmt.compute.models.VirtualHardDisk
        :keyword caching: Specifies the caching requirements. Possible values are: **None,**
         **ReadOnly,** **ReadWrite.** The defaulting behavior is: **None for Standard storage. ReadOnly
         for Premium storage.**. Known values are: "None", "ReadOnly", and "ReadWrite".
        :paramtype caching: str or ~azure.mgmt.compute.models.CachingTypes
        :keyword write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
         disabled on the disk.
        :paramtype write_accelerator_enabled: bool
        :keyword create_option: Specifies how the virtual machine disk should be created. Possible
         values are **Attach:** This value is used when you are using a specialized disk to create the
         virtual machine. **FromImage:** This value is used when you are using an image to create the
         virtual machine data disk. If you are using a platform image, you should also use the
         imageReference element described above. If you are using a marketplace image, you should also
         use the plan element previously described. **Empty:** This value is used when creating an empty
         data disk. **Copy:** This value is used to create a data disk from a snapshot or another disk.
         **Restore:** This value is used to create a data disk from a disk restore point. Required.
         Known values are: "FromImage", "Empty", "Attach", "Copy", and "Restore".
        :paramtype create_option: str or ~azure.mgmt.compute.models.DiskCreateOptionTypes
        :keyword disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can
         be used to overwrite the size of the disk in a virtual machine image. The property 'diskSizeGB'
         is the number of bytes x 1024^3 for the disk and the value cannot be larger than 1023.
        :paramtype disk_size_gb: int
        :keyword managed_disk: The managed disk parameters.
        :paramtype managed_disk: ~azure.mgmt.compute.models.ManagedDiskParameters
        :keyword source_resource: The source resource identifier. It can be a snapshot, or disk restore
         point from which to create a disk.
        :paramtype source_resource: ~azure.mgmt.compute.models.ApiEntityReference
        :keyword to_be_detached: Specifies whether the data disk is in process of detachment from the
         VirtualMachine/VirtualMachineScaleset.
        :paramtype to_be_detached: bool
        :keyword detach_option: Specifies the detach behavior to be used while detaching a disk or
         which is already in the process of detachment from the virtual machine. Supported values:
         **ForceDetach.** detachOption: **ForceDetach** is applicable only for managed data disks. If a
         previous detachment attempt of the data disk did not complete due to an unexpected failure from
         the virtual machine and the disk is still not released then use force-detach as a last resort
         option to detach the disk forcibly from the VM. All writes might not have been flushed when
         using this detach behavior. **This feature is still in preview**. To force-detach a data disk
         update toBeDetached to 'true' along with setting detachOption: 'ForceDetach'. "ForceDetach"
        :paramtype detach_option: str or ~azure.mgmt.compute.models.DiskDetachOptionTypes
        :keyword delete_option: Specifies whether data disk should be deleted or detached upon VM
         deletion. Possible values are: **Delete.** If this value is used, the data disk is deleted when
         VM is deleted. **Detach.** If this value is used, the data disk is retained after VM is
         deleted. The default value is set to **Detach**. Known values are: "Delete" and "Detach".
        :paramtype delete_option: str or ~azure.mgmt.compute.models.DiskDeleteOptionTypes
        """
        super().__init__(**kwargs)
        self.lun = lun
        self.name = name
        self.vhd = vhd
        self.image = image
        self.caching = caching
        self.write_accelerator_enabled = write_accelerator_enabled
        self.create_option = create_option
        self.disk_size_gb = disk_size_gb
        self.managed_disk = managed_disk
        self.source_resource = source_resource
        self.to_be_detached = to_be_detached
        self.disk_iops_read_write: Optional[int] = None
        self.disk_m_bps_read_write: Optional[int] = None
        self.detach_option = detach_option
        self.delete_option = delete_option


class DataDiskImage(_serialization.Model):
    """Contains the data disk images information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar lun: Specifies the logical unit number of the data disk. This value is used to identify
     data disks within the VM and therefore must be unique for each data disk attached to a VM.
    :vartype lun: int
    """

    _validation = {
        "lun": {"readonly": True},
    }

    _attribute_map = {
        "lun": {"key": "lun", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.lun: Optional[int] = None


class DiskImageEncryption(_serialization.Model):
    """This is the disk image encryption base class.

    :ivar disk_encryption_set_id: A relative URI containing the resource ID of the disk encryption
     set.
    :vartype disk_encryption_set_id: str
    """

    _attribute_map = {
        "disk_encryption_set_id": {"key": "diskEncryptionSetId", "type": "str"},
    }

    def __init__(self, *, disk_encryption_set_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword disk_encryption_set_id: A relative URI containing the resource ID of the disk
         encryption set.
        :paramtype disk_encryption_set_id: str
        """
        super().__init__(**kwargs)
        self.disk_encryption_set_id = disk_encryption_set_id


class DataDiskImageEncryption(DiskImageEncryption):
    """Contains encryption settings for a data disk image.

    All required parameters must be populated in order to send to server.

    :ivar disk_encryption_set_id: A relative URI containing the resource ID of the disk encryption
     set.
    :vartype disk_encryption_set_id: str
    :ivar lun: This property specifies the logical unit number of the data disk. This value is used
     to identify data disks within the Virtual Machine and therefore must be unique for each data
     disk attached to the Virtual Machine. Required.
    :vartype lun: int
    """

    _validation = {
        "lun": {"required": True},
    }

    _attribute_map = {
        "disk_encryption_set_id": {"key": "diskEncryptionSetId", "type": "str"},
        "lun": {"key": "lun", "type": "int"},
    }

    def __init__(self, *, lun: int, disk_encryption_set_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword disk_encryption_set_id: A relative URI containing the resource ID of the disk
         encryption set.
        :paramtype disk_encryption_set_id: str
        :keyword lun: This property specifies the logical unit number of the data disk. This value is
         used to identify data disks within the Virtual Machine and therefore must be unique for each
         data disk attached to the Virtual Machine. Required.
        :paramtype lun: int
        """
        super().__init__(disk_encryption_set_id=disk_encryption_set_id, **kwargs)
        self.lun = lun


class DataDisksToAttach(_serialization.Model):
    """Describes the data disk to be attached.

    All required parameters must be populated in order to send to server.

    :ivar disk_id: ID of the managed data disk. Required.
    :vartype disk_id: str
    :ivar lun: The logical unit number of the data disk. This value is used to identify data disks
     within the VM and therefore must be unique for each data disk attached to a VM. If not
     specified, lun would be auto assigned.
    :vartype lun: int
    :ivar caching: Specifies the caching requirements. Possible values are: **None,** **ReadOnly,**
     **ReadWrite.** The defaulting behavior is: **None for Standard storage. ReadOnly for Premium
     storage.**. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype caching: str or ~azure.mgmt.compute.models.CachingTypes
    :ivar delete_option: Specifies whether data disk should be deleted or detached upon VM
     deletion. Possible values are: **Delete.** If this value is used, the data disk is deleted when
     VM is deleted. **Detach.** If this value is used, the data disk is retained after VM is
     deleted. The default value is set to **Detach**. Known values are: "Delete" and "Detach".
    :vartype delete_option: str or ~azure.mgmt.compute.models.DiskDeleteOptionTypes
    :ivar disk_encryption_set: Specifies the customer managed disk encryption set resource id for
     the managed disk.
    :vartype disk_encryption_set: ~azure.mgmt.compute.models.DiskEncryptionSetParameters
    :ivar write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
     disabled on the disk.
    :vartype write_accelerator_enabled: bool
    """

    _validation = {
        "disk_id": {"required": True},
    }

    _attribute_map = {
        "disk_id": {"key": "diskId", "type": "str"},
        "lun": {"key": "lun", "type": "int"},
        "caching": {"key": "caching", "type": "str"},
        "delete_option": {"key": "deleteOption", "type": "str"},
        "disk_encryption_set": {"key": "diskEncryptionSet", "type": "DiskEncryptionSetParameters"},
        "write_accelerator_enabled": {"key": "writeAcceleratorEnabled", "type": "bool"},
    }

    def __init__(
        self,
        *,
        disk_id: str,
        lun: Optional[int] = None,
        caching: Optional[Union[str, "_models.CachingTypes"]] = None,
        delete_option: Optional[Union[str, "_models.DiskDeleteOptionTypes"]] = None,
        disk_encryption_set: Optional["_models.DiskEncryptionSetParameters"] = None,
        write_accelerator_enabled: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword disk_id: ID of the managed data disk. Required.
        :paramtype disk_id: str
        :keyword lun: The logical unit number of the data disk. This value is used to identify data
         disks within the VM and therefore must be unique for each data disk attached to a VM. If not
         specified, lun would be auto assigned.
        :paramtype lun: int
        :keyword caching: Specifies the caching requirements. Possible values are: **None,**
         **ReadOnly,** **ReadWrite.** The defaulting behavior is: **None for Standard storage. ReadOnly
         for Premium storage.**. Known values are: "None", "ReadOnly", and "ReadWrite".
        :paramtype caching: str or ~azure.mgmt.compute.models.CachingTypes
        :keyword delete_option: Specifies whether data disk should be deleted or detached upon VM
         deletion. Possible values are: **Delete.** If this value is used, the data disk is deleted when
         VM is deleted. **Detach.** If this value is used, the data disk is retained after VM is
         deleted. The default value is set to **Detach**. Known values are: "Delete" and "Detach".
        :paramtype delete_option: str or ~azure.mgmt.compute.models.DiskDeleteOptionTypes
        :keyword disk_encryption_set: Specifies the customer managed disk encryption set resource id
         for the managed disk.
        :paramtype disk_encryption_set: ~azure.mgmt.compute.models.DiskEncryptionSetParameters
        :keyword write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
         disabled on the disk.
        :paramtype write_accelerator_enabled: bool
        """
        super().__init__(**kwargs)
        self.disk_id = disk_id
        self.lun = lun
        self.caching = caching
        self.delete_option = delete_option
        self.disk_encryption_set = disk_encryption_set
        self.write_accelerator_enabled = write_accelerator_enabled


class DataDisksToDetach(_serialization.Model):
    """Describes the data disk to be detached.

    All required parameters must be populated in order to send to server.

    :ivar disk_id: ID of the managed data disk. Required.
    :vartype disk_id: str
    :ivar detach_option: Supported options available for Detach of a disk from a VM. Refer to
     DetachOption object reference for more details. "ForceDetach"
    :vartype detach_option: str or ~azure.mgmt.compute.models.DiskDetachOptionTypes
    """

    _validation = {
        "disk_id": {"required": True},
    }

    _attribute_map = {
        "disk_id": {"key": "diskId", "type": "str"},
        "detach_option": {"key": "detachOption", "type": "str"},
    }

    def __init__(
        self,
        *,
        disk_id: str,
        detach_option: Optional[Union[str, "_models.DiskDetachOptionTypes"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword disk_id: ID of the managed data disk. Required.
        :paramtype disk_id: str
        :keyword detach_option: Supported options available for Detach of a disk from a VM. Refer to
         DetachOption object reference for more details. "ForceDetach"
        :paramtype detach_option: str or ~azure.mgmt.compute.models.DiskDetachOptionTypes
        """
        super().__init__(**kwargs)
        self.disk_id = disk_id
        self.detach_option = detach_option


class DedicatedHost(TrackedResource):
    """Specifies information about the Dedicated host.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.compute.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar sku: SKU of the dedicated host for Hardware Generation and VM family. Only name is
     required to be set. List Microsoft.Compute SKUs for a list of possible values. Required.
    :vartype sku: ~azure.mgmt.compute.models.Sku
    :ivar platform_fault_domain: Fault domain of the dedicated host within a dedicated host group.
    :vartype platform_fault_domain: int
    :ivar auto_replace_on_failure: Specifies whether the dedicated host should be replaced
     automatically in case of a failure. The value is defaulted to 'true' when not provided.
    :vartype auto_replace_on_failure: bool
    :ivar host_id: A unique id generated and assigned to the dedicated host by the platform. Does
     not change throughout the lifetime of the host.
    :vartype host_id: str
    :ivar virtual_machines: A list of references to all virtual machines in the Dedicated Host.
    :vartype virtual_machines: list[~azure.mgmt.compute.models.SubResourceReadOnly]
    :ivar license_type: Specifies the software license type that will be applied to the VMs
     deployed on the dedicated host. Possible values are: **None,** **Windows_Server_Hybrid,**
     **Windows_Server_Perpetual.** The default value is: **None.**. Known values are: "None",
     "Windows_Server_Hybrid", and "Windows_Server_Perpetual".
    :vartype license_type: str or ~azure.mgmt.compute.models.DedicatedHostLicenseTypes
    :ivar provisioning_time: The date when the host was first provisioned.
    :vartype provisioning_time: ~datetime.datetime
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar instance_view: The dedicated host instance view.
    :vartype instance_view: ~azure.mgmt.compute.models.DedicatedHostInstanceView
    :ivar time_created: Specifies the time at which the Dedicated Host resource was created.
     Minimum api-version: 2021-11-01.
    :vartype time_created: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "sku": {"required": True},
        "host_id": {"readonly": True},
        "virtual_machines": {"readonly": True},
        "provisioning_time": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "instance_view": {"readonly": True},
        "time_created": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
        "platform_fault_domain": {"key": "properties.platformFaultDomain", "type": "int"},
        "auto_replace_on_failure": {"key": "properties.autoReplaceOnFailure", "type": "bool"},
        "host_id": {"key": "properties.hostId", "type": "str"},
        "virtual_machines": {"key": "properties.virtualMachines", "type": "[SubResourceReadOnly]"},
        "license_type": {"key": "properties.licenseType", "type": "str"},
        "provisioning_time": {"key": "properties.provisioningTime", "type": "iso-8601"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "instance_view": {"key": "properties.instanceView", "type": "DedicatedHostInstanceView"},
        "time_created": {"key": "properties.timeCreated", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        location: str,
        sku: "_models.Sku",
        tags: Optional[dict[str, str]] = None,
        platform_fault_domain: Optional[int] = None,
        auto_replace_on_failure: Optional[bool] = None,
        license_type: Optional[Union[str, "_models.DedicatedHostLicenseTypes"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword sku: SKU of the dedicated host for Hardware Generation and VM family. Only name is
         required to be set. List Microsoft.Compute SKUs for a list of possible values. Required.
        :paramtype sku: ~azure.mgmt.compute.models.Sku
        :keyword platform_fault_domain: Fault domain of the dedicated host within a dedicated host
         group.
        :paramtype platform_fault_domain: int
        :keyword auto_replace_on_failure: Specifies whether the dedicated host should be replaced
         automatically in case of a failure. The value is defaulted to 'true' when not provided.
        :paramtype auto_replace_on_failure: bool
        :keyword license_type: Specifies the software license type that will be applied to the VMs
         deployed on the dedicated host. Possible values are: **None,** **Windows_Server_Hybrid,**
         **Windows_Server_Perpetual.** The default value is: **None.**. Known values are: "None",
         "Windows_Server_Hybrid", and "Windows_Server_Perpetual".
        :paramtype license_type: str or ~azure.mgmt.compute.models.DedicatedHostLicenseTypes
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.sku = sku
        self.platform_fault_domain = platform_fault_domain
        self.auto_replace_on_failure = auto_replace_on_failure
        self.host_id: Optional[str] = None
        self.virtual_machines: Optional[list["_models.SubResourceReadOnly"]] = None
        self.license_type = license_type
        self.provisioning_time: Optional[datetime.datetime] = None
        self.provisioning_state: Optional[str] = None
        self.instance_view: Optional["_models.DedicatedHostInstanceView"] = None
        self.time_created: Optional[datetime.datetime] = None


class DedicatedHostAllocatableVM(_serialization.Model):
    """Represents the dedicated host unutilized capacity in terms of a specific VM size.

    :ivar vm_size: VM size in terms of which the unutilized capacity is represented.
    :vartype vm_size: str
    :ivar count: Maximum number of VMs of size vmSize that can fit in the dedicated host's
     remaining capacity.
    :vartype count: float
    """

    _attribute_map = {
        "vm_size": {"key": "vmSize", "type": "str"},
        "count": {"key": "count", "type": "float"},
    }

    def __init__(self, *, vm_size: Optional[str] = None, count: Optional[float] = None, **kwargs: Any) -> None:
        """
        :keyword vm_size: VM size in terms of which the unutilized capacity is represented.
        :paramtype vm_size: str
        :keyword count: Maximum number of VMs of size vmSize that can fit in the dedicated host's
         remaining capacity.
        :paramtype count: float
        """
        super().__init__(**kwargs)
        self.vm_size = vm_size
        self.count = count


class DedicatedHostAvailableCapacity(_serialization.Model):
    """Dedicated host unutilized capacity.

    :ivar allocatable_v_ms: The unutilized capacity of the dedicated host represented in terms of
     each VM size that is allowed to be deployed to the dedicated host.
    :vartype allocatable_v_ms: list[~azure.mgmt.compute.models.DedicatedHostAllocatableVM]
    """

    _attribute_map = {
        "allocatable_v_ms": {"key": "allocatableVMs", "type": "[DedicatedHostAllocatableVM]"},
    }

    def __init__(
        self, *, allocatable_v_ms: Optional[list["_models.DedicatedHostAllocatableVM"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword allocatable_v_ms: The unutilized capacity of the dedicated host represented in terms
         of each VM size that is allowed to be deployed to the dedicated host.
        :paramtype allocatable_v_ms: list[~azure.mgmt.compute.models.DedicatedHostAllocatableVM]
        """
        super().__init__(**kwargs)
        self.allocatable_v_ms = allocatable_v_ms


class DedicatedHostGroup(TrackedResource):
    """Specifies information about the dedicated host group that the dedicated hosts should be
    assigned to. Currently, a dedicated host can only be added to a dedicated host group at
    creation time. An existing dedicated host cannot be added to another dedicated host group.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.compute.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar zones: The availability zones.
    :vartype zones: list[str]
    :ivar platform_fault_domain_count: Number of fault domains that the host group can span.
    :vartype platform_fault_domain_count: int
    :ivar hosts: A list of references to all dedicated hosts in the dedicated host group.
    :vartype hosts: list[~azure.mgmt.compute.models.SubResourceReadOnly]
    :ivar instance_view: The dedicated host group instance view, which has the list of instance
     view of the dedicated hosts under the dedicated host group.
    :vartype instance_view: ~azure.mgmt.compute.models.DedicatedHostGroupInstanceView
    :ivar support_automatic_placement: Specifies whether virtual machines or virtual machine scale
     sets can be placed automatically on the dedicated host group. Automatic placement means
     resources are allocated on dedicated hosts, that are chosen by Azure, under the dedicated host
     group. The value is defaulted to 'false' when not provided. Minimum api-version: 2020-06-01.
    :vartype support_automatic_placement: bool
    :ivar additional_capabilities: Enables or disables a capability on the dedicated host group.
     Minimum api-version: 2022-03-01.
    :vartype additional_capabilities:
     ~azure.mgmt.compute.models.DedicatedHostGroupPropertiesAdditionalCapabilities
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "platform_fault_domain_count": {"minimum": 1},
        "hosts": {"readonly": True},
        "instance_view": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "zones": {"key": "zones", "type": "[str]"},
        "platform_fault_domain_count": {"key": "properties.platformFaultDomainCount", "type": "int"},
        "hosts": {"key": "properties.hosts", "type": "[SubResourceReadOnly]"},
        "instance_view": {"key": "properties.instanceView", "type": "DedicatedHostGroupInstanceView"},
        "support_automatic_placement": {"key": "properties.supportAutomaticPlacement", "type": "bool"},
        "additional_capabilities": {
            "key": "properties.additionalCapabilities",
            "type": "DedicatedHostGroupPropertiesAdditionalCapabilities",
        },
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        zones: Optional[list[str]] = None,
        platform_fault_domain_count: Optional[int] = None,
        support_automatic_placement: Optional[bool] = None,
        additional_capabilities: Optional["_models.DedicatedHostGroupPropertiesAdditionalCapabilities"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword zones: The availability zones.
        :paramtype zones: list[str]
        :keyword platform_fault_domain_count: Number of fault domains that the host group can span.
        :paramtype platform_fault_domain_count: int
        :keyword support_automatic_placement: Specifies whether virtual machines or virtual machine
         scale sets can be placed automatically on the dedicated host group. Automatic placement means
         resources are allocated on dedicated hosts, that are chosen by Azure, under the dedicated host
         group. The value is defaulted to 'false' when not provided. Minimum api-version: 2020-06-01.
        :paramtype support_automatic_placement: bool
        :keyword additional_capabilities: Enables or disables a capability on the dedicated host group.
         Minimum api-version: 2022-03-01.
        :paramtype additional_capabilities:
         ~azure.mgmt.compute.models.DedicatedHostGroupPropertiesAdditionalCapabilities
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.zones = zones
        self.platform_fault_domain_count = platform_fault_domain_count
        self.hosts: Optional[list["_models.SubResourceReadOnly"]] = None
        self.instance_view: Optional["_models.DedicatedHostGroupInstanceView"] = None
        self.support_automatic_placement = support_automatic_placement
        self.additional_capabilities = additional_capabilities


class DedicatedHostGroupInstanceView(_serialization.Model):
    """DedicatedHostGroupInstanceView.

    :ivar hosts: List of instance view of the dedicated hosts under the dedicated host group.
    :vartype hosts: list[~azure.mgmt.compute.models.DedicatedHostInstanceViewWithName]
    """

    _attribute_map = {
        "hosts": {"key": "hosts", "type": "[DedicatedHostInstanceViewWithName]"},
    }

    def __init__(
        self, *, hosts: Optional[list["_models.DedicatedHostInstanceViewWithName"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword hosts: List of instance view of the dedicated hosts under the dedicated host group.
        :paramtype hosts: list[~azure.mgmt.compute.models.DedicatedHostInstanceViewWithName]
        """
        super().__init__(**kwargs)
        self.hosts = hosts


class DedicatedHostGroupListResult(_serialization.Model):
    """The List Dedicated Host Group with resource group response.

    All required parameters must be populated in order to send to server.

    :ivar value: The list of dedicated host groups. Required.
    :vartype value: list[~azure.mgmt.compute.models.DedicatedHostGroup]
    :ivar next_link: The URI to fetch the next page of Dedicated Host Groups. Call ListNext() with
     this URI to fetch the next page of Dedicated Host Groups.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DedicatedHostGroup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: list["_models.DedicatedHostGroup"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of dedicated host groups. Required.
        :paramtype value: list[~azure.mgmt.compute.models.DedicatedHostGroup]
        :keyword next_link: The URI to fetch the next page of Dedicated Host Groups. Call ListNext()
         with this URI to fetch the next page of Dedicated Host Groups.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DedicatedHostGroupPropertiesAdditionalCapabilities(_serialization.Model):  # pylint: disable=name-too-long
    """Enables or disables a capability on the dedicated host group. Minimum api-version: 2022-03-01.

    :ivar ultra_ssd_enabled: The flag that enables or disables a capability to have UltraSSD
     Enabled Virtual Machines on Dedicated Hosts of the Dedicated Host Group. For the Virtual
     Machines to be UltraSSD Enabled, UltraSSDEnabled flag for the resource needs to be set true as
     well. The value is defaulted to 'false' when not provided. Please refer to
     https://docs.microsoft.com/en-us/azure/virtual-machines/disks-enable-ultra-ssd for more details
     on Ultra SSD feature. **Note:** The ultraSSDEnabled setting can only be enabled for Host Groups
     that are created as zonal. Minimum api-version: 2022-03-01.
    :vartype ultra_ssd_enabled: bool
    """

    _attribute_map = {
        "ultra_ssd_enabled": {"key": "ultraSSDEnabled", "type": "bool"},
    }

    def __init__(self, *, ultra_ssd_enabled: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword ultra_ssd_enabled: The flag that enables or disables a capability to have UltraSSD
         Enabled Virtual Machines on Dedicated Hosts of the Dedicated Host Group. For the Virtual
         Machines to be UltraSSD Enabled, UltraSSDEnabled flag for the resource needs to be set true as
         well. The value is defaulted to 'false' when not provided. Please refer to
         https://docs.microsoft.com/en-us/azure/virtual-machines/disks-enable-ultra-ssd for more details
         on Ultra SSD feature. **Note:** The ultraSSDEnabled setting can only be enabled for Host Groups
         that are created as zonal. Minimum api-version: 2022-03-01.
        :paramtype ultra_ssd_enabled: bool
        """
        super().__init__(**kwargs)
        self.ultra_ssd_enabled = ultra_ssd_enabled


class DedicatedHostGroupUpdate(UpdateResource):
    """Specifies information about the dedicated host group that the dedicated host should be assigned
    to. Only tags may be updated.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar zones: Availability Zone to use for this host group. Only single zone is supported. The
     zone can be assigned only during creation. If not provided, the group supports all zones in the
     region. If provided, enforces each host in the group to be in the same zone.
    :vartype zones: list[str]
    :ivar platform_fault_domain_count: Number of fault domains that the host group can span.
    :vartype platform_fault_domain_count: int
    :ivar hosts: A list of references to all dedicated hosts in the dedicated host group.
    :vartype hosts: list[~azure.mgmt.compute.models.SubResourceReadOnly]
    :ivar instance_view: The dedicated host group instance view, which has the list of instance
     view of the dedicated hosts under the dedicated host group.
    :vartype instance_view: ~azure.mgmt.compute.models.DedicatedHostGroupInstanceView
    :ivar support_automatic_placement: Specifies whether virtual machines or virtual machine scale
     sets can be placed automatically on the dedicated host group. Automatic placement means
     resources are allocated on dedicated hosts, that are chosen by Azure, under the dedicated host
     group. The value is defaulted to 'false' when not provided. Minimum api-version: 2020-06-01.
    :vartype support_automatic_placement: bool
    :ivar additional_capabilities: Enables or disables a capability on the dedicated host group.
     Minimum api-version: 2022-03-01.
    :vartype additional_capabilities:
     ~azure.mgmt.compute.models.DedicatedHostGroupPropertiesAdditionalCapabilities
    """

    _validation = {
        "platform_fault_domain_count": {"minimum": 1},
        "hosts": {"readonly": True},
        "instance_view": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "zones": {"key": "zones", "type": "[str]"},
        "platform_fault_domain_count": {"key": "properties.platformFaultDomainCount", "type": "int"},
        "hosts": {"key": "properties.hosts", "type": "[SubResourceReadOnly]"},
        "instance_view": {"key": "properties.instanceView", "type": "DedicatedHostGroupInstanceView"},
        "support_automatic_placement": {"key": "properties.supportAutomaticPlacement", "type": "bool"},
        "additional_capabilities": {
            "key": "properties.additionalCapabilities",
            "type": "DedicatedHostGroupPropertiesAdditionalCapabilities",
        },
    }

    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
        zones: Optional[list[str]] = None,
        platform_fault_domain_count: Optional[int] = None,
        support_automatic_placement: Optional[bool] = None,
        additional_capabilities: Optional["_models.DedicatedHostGroupPropertiesAdditionalCapabilities"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword zones: Availability Zone to use for this host group. Only single zone is supported.
         The zone can be assigned only during creation. If not provided, the group supports all zones in
         the region. If provided, enforces each host in the group to be in the same zone.
        :paramtype zones: list[str]
        :keyword platform_fault_domain_count: Number of fault domains that the host group can span.
        :paramtype platform_fault_domain_count: int
        :keyword support_automatic_placement: Specifies whether virtual machines or virtual machine
         scale sets can be placed automatically on the dedicated host group. Automatic placement means
         resources are allocated on dedicated hosts, that are chosen by Azure, under the dedicated host
         group. The value is defaulted to 'false' when not provided. Minimum api-version: 2020-06-01.
        :paramtype support_automatic_placement: bool
        :keyword additional_capabilities: Enables or disables a capability on the dedicated host group.
         Minimum api-version: 2022-03-01.
        :paramtype additional_capabilities:
         ~azure.mgmt.compute.models.DedicatedHostGroupPropertiesAdditionalCapabilities
        """
        super().__init__(tags=tags, **kwargs)
        self.zones = zones
        self.platform_fault_domain_count = platform_fault_domain_count
        self.hosts: Optional[list["_models.SubResourceReadOnly"]] = None
        self.instance_view: Optional["_models.DedicatedHostGroupInstanceView"] = None
        self.support_automatic_placement = support_automatic_placement
        self.additional_capabilities = additional_capabilities


class DedicatedHostInstanceView(_serialization.Model):
    """The instance view of a dedicated host.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar asset_id: Specifies the unique id of the dedicated physical machine on which the
     dedicated host resides.
    :vartype asset_id: str
    :ivar available_capacity: Unutilized capacity of the dedicated host.
    :vartype available_capacity: ~azure.mgmt.compute.models.DedicatedHostAvailableCapacity
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.models.InstanceViewStatus]
    """

    _validation = {
        "asset_id": {"readonly": True},
    }

    _attribute_map = {
        "asset_id": {"key": "assetId", "type": "str"},
        "available_capacity": {"key": "availableCapacity", "type": "DedicatedHostAvailableCapacity"},
        "statuses": {"key": "statuses", "type": "[InstanceViewStatus]"},
    }

    def __init__(
        self,
        *,
        available_capacity: Optional["_models.DedicatedHostAvailableCapacity"] = None,
        statuses: Optional[list["_models.InstanceViewStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword available_capacity: Unutilized capacity of the dedicated host.
        :paramtype available_capacity: ~azure.mgmt.compute.models.DedicatedHostAvailableCapacity
        :keyword statuses: The resource status information.
        :paramtype statuses: list[~azure.mgmt.compute.models.InstanceViewStatus]
        """
        super().__init__(**kwargs)
        self.asset_id: Optional[str] = None
        self.available_capacity = available_capacity
        self.statuses = statuses


class DedicatedHostInstanceViewWithName(DedicatedHostInstanceView):
    """The instance view of a dedicated host that includes the name of the dedicated host. It is used
    for the response to the instance view of a dedicated host group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar asset_id: Specifies the unique id of the dedicated physical machine on which the
     dedicated host resides.
    :vartype asset_id: str
    :ivar available_capacity: Unutilized capacity of the dedicated host.
    :vartype available_capacity: ~azure.mgmt.compute.models.DedicatedHostAvailableCapacity
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.models.InstanceViewStatus]
    :ivar name: The name of the dedicated host.
    :vartype name: str
    """

    _validation = {
        "asset_id": {"readonly": True},
        "name": {"readonly": True},
    }

    _attribute_map = {
        "asset_id": {"key": "assetId", "type": "str"},
        "available_capacity": {"key": "availableCapacity", "type": "DedicatedHostAvailableCapacity"},
        "statuses": {"key": "statuses", "type": "[InstanceViewStatus]"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        available_capacity: Optional["_models.DedicatedHostAvailableCapacity"] = None,
        statuses: Optional[list["_models.InstanceViewStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword available_capacity: Unutilized capacity of the dedicated host.
        :paramtype available_capacity: ~azure.mgmt.compute.models.DedicatedHostAvailableCapacity
        :keyword statuses: The resource status information.
        :paramtype statuses: list[~azure.mgmt.compute.models.InstanceViewStatus]
        """
        super().__init__(available_capacity=available_capacity, statuses=statuses, **kwargs)
        self.name: Optional[str] = None


class DedicatedHostListResult(_serialization.Model):
    """The list dedicated host operation response.

    All required parameters must be populated in order to send to server.

    :ivar value: The list of dedicated hosts. Required.
    :vartype value: list[~azure.mgmt.compute.models.DedicatedHost]
    :ivar next_link: The URI to fetch the next page of dedicated hosts. Call ListNext() with this
     URI to fetch the next page of dedicated hosts.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DedicatedHost]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: list["_models.DedicatedHost"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of dedicated hosts. Required.
        :paramtype value: list[~azure.mgmt.compute.models.DedicatedHost]
        :keyword next_link: The URI to fetch the next page of dedicated hosts. Call ListNext() with
         this URI to fetch the next page of dedicated hosts.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DedicatedHostSizeListResult(_serialization.Model):
    """The List Dedicated Host sizes operation response.

    :ivar value: The list of dedicated host sizes.
    :vartype value: list[str]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[str]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[list[str]] = None, next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of dedicated host sizes.
        :paramtype value: list[str]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DedicatedHostUpdate(UpdateResource):
    """Specifies information about the dedicated host. Only tags, autoReplaceOnFailure and licenseType
    may be updated.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: [List all available dedicated host sizes for resizing]
     (https://docs.microsoft.com/rest/api/compute/dedicated-hosts/listavailablesizes). Resizing can
     be only used to scale up DedicatedHost. Only name is required to be set.
    :vartype sku: ~azure.mgmt.compute.models.Sku
    :ivar platform_fault_domain: Fault domain of the dedicated host within a dedicated host group.
    :vartype platform_fault_domain: int
    :ivar auto_replace_on_failure: Specifies whether the dedicated host should be replaced
     automatically in case of a failure. The value is defaulted to 'true' when not provided.
    :vartype auto_replace_on_failure: bool
    :ivar host_id: A unique id generated and assigned to the dedicated host by the platform. Does
     not change throughout the lifetime of the host.
    :vartype host_id: str
    :ivar virtual_machines: A list of references to all virtual machines in the Dedicated Host.
    :vartype virtual_machines: list[~azure.mgmt.compute.models.SubResourceReadOnly]
    :ivar license_type: Specifies the software license type that will be applied to the VMs
     deployed on the dedicated host. Possible values are: **None,** **Windows_Server_Hybrid,**
     **Windows_Server_Perpetual.** The default value is: **None.**. Known values are: "None",
     "Windows_Server_Hybrid", and "Windows_Server_Perpetual".
    :vartype license_type: str or ~azure.mgmt.compute.models.DedicatedHostLicenseTypes
    :ivar provisioning_time: The date when the host was first provisioned.
    :vartype provisioning_time: ~datetime.datetime
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar instance_view: The dedicated host instance view.
    :vartype instance_view: ~azure.mgmt.compute.models.DedicatedHostInstanceView
    :ivar time_created: Specifies the time at which the Dedicated Host resource was created.
     Minimum api-version: 2021-11-01.
    :vartype time_created: ~datetime.datetime
    """

    _validation = {
        "host_id": {"readonly": True},
        "virtual_machines": {"readonly": True},
        "provisioning_time": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "instance_view": {"readonly": True},
        "time_created": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "Sku"},
        "platform_fault_domain": {"key": "properties.platformFaultDomain", "type": "int"},
        "auto_replace_on_failure": {"key": "properties.autoReplaceOnFailure", "type": "bool"},
        "host_id": {"key": "properties.hostId", "type": "str"},
        "virtual_machines": {"key": "properties.virtualMachines", "type": "[SubResourceReadOnly]"},
        "license_type": {"key": "properties.licenseType", "type": "str"},
        "provisioning_time": {"key": "properties.provisioningTime", "type": "iso-8601"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "instance_view": {"key": "properties.instanceView", "type": "DedicatedHostInstanceView"},
        "time_created": {"key": "properties.timeCreated", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
        sku: Optional["_models.Sku"] = None,
        platform_fault_domain: Optional[int] = None,
        auto_replace_on_failure: Optional[bool] = None,
        license_type: Optional[Union[str, "_models.DedicatedHostLicenseTypes"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: [List all available dedicated host sizes for resizing]
         (https://docs.microsoft.com/rest/api/compute/dedicated-hosts/listavailablesizes). Resizing can
         be only used to scale up DedicatedHost. Only name is required to be set.
        :paramtype sku: ~azure.mgmt.compute.models.Sku
        :keyword platform_fault_domain: Fault domain of the dedicated host within a dedicated host
         group.
        :paramtype platform_fault_domain: int
        :keyword auto_replace_on_failure: Specifies whether the dedicated host should be replaced
         automatically in case of a failure. The value is defaulted to 'true' when not provided.
        :paramtype auto_replace_on_failure: bool
        :keyword license_type: Specifies the software license type that will be applied to the VMs
         deployed on the dedicated host. Possible values are: **None,** **Windows_Server_Hybrid,**
         **Windows_Server_Perpetual.** The default value is: **None.**. Known values are: "None",
         "Windows_Server_Hybrid", and "Windows_Server_Perpetual".
        :paramtype license_type: str or ~azure.mgmt.compute.models.DedicatedHostLicenseTypes
        """
        super().__init__(tags=tags, **kwargs)
        self.sku = sku
        self.platform_fault_domain = platform_fault_domain
        self.auto_replace_on_failure = auto_replace_on_failure
        self.host_id: Optional[str] = None
        self.virtual_machines: Optional[list["_models.SubResourceReadOnly"]] = None
        self.license_type = license_type
        self.provisioning_time: Optional[datetime.datetime] = None
        self.provisioning_state: Optional[str] = None
        self.instance_view: Optional["_models.DedicatedHostInstanceView"] = None
        self.time_created: Optional[datetime.datetime] = None


class DefaultVirtualMachineScaleSetInfo(_serialization.Model):
    """Indicates the target Virtual Machine ScaleSet properties upon triggering a seamless migration
    without downtime of the VMs via the ConvertToVirtualMachineScaleSet API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar constrained_maximum_capacity: Indicates if the the maximum capacity of the default
     migrated Virtual Machine Scale Set after its migration will be constrained to a limited number
     of VMs.
    :vartype constrained_maximum_capacity: bool
    :ivar default_virtual_machine_scale_set: The default Virtual Machine ScaleSet Uri that the
     Availability Set will be moved to upon triggering a seamless migration via the
     ConvertToVirtualMachineScaleSet API.
    :vartype default_virtual_machine_scale_set: ~azure.mgmt.compute.models.SubResource
    """

    _validation = {
        "constrained_maximum_capacity": {"readonly": True},
        "default_virtual_machine_scale_set": {"readonly": True},
    }

    _attribute_map = {
        "constrained_maximum_capacity": {"key": "constrainedMaximumCapacity", "type": "bool"},
        "default_virtual_machine_scale_set": {"key": "defaultVirtualMachineScaleSet", "type": "SubResource"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.constrained_maximum_capacity: Optional[bool] = None
        self.default_virtual_machine_scale_set: Optional["_models.SubResource"] = None


class DiagnosticsProfile(_serialization.Model):
    """Specifies the boot diagnostic settings state. Minimum api-version: 2015-06-15.

    :ivar boot_diagnostics: Boot Diagnostics is a debugging feature which allows you to view
     Console Output and Screenshot to diagnose VM status. **NOTE**\\ : If storageUri is being
     specified then ensure that the storage account is in the same region and subscription as the
     VM. You can easily view the output of your console log. Azure also enables you to see a
     screenshot of the VM from the hypervisor.
    :vartype boot_diagnostics: ~azure.mgmt.compute.models.BootDiagnostics
    """

    _attribute_map = {
        "boot_diagnostics": {"key": "bootDiagnostics", "type": "BootDiagnostics"},
    }

    def __init__(self, *, boot_diagnostics: Optional["_models.BootDiagnostics"] = None, **kwargs: Any) -> None:
        """
        :keyword boot_diagnostics: Boot Diagnostics is a debugging feature which allows you to view
         Console Output and Screenshot to diagnose VM status. **NOTE**\\ : If storageUri is being
         specified then ensure that the storage account is in the same region and subscription as the
         VM. You can easily view the output of your console log. Azure also enables you to see a
         screenshot of the VM from the hypervisor.
        :paramtype boot_diagnostics: ~azure.mgmt.compute.models.BootDiagnostics
        """
        super().__init__(**kwargs)
        self.boot_diagnostics = boot_diagnostics


class DiffDiskSettings(_serialization.Model):
    """Describes the parameters of ephemeral disk settings that can be specified for operating system
    disk. **Note:** The ephemeral disk settings can only be specified for managed disk.

    :ivar option: Specifies the ephemeral disk settings for operating system disk. "Local"
    :vartype option: str or ~azure.mgmt.compute.models.DiffDiskOptions
    :ivar placement: Specifies the ephemeral disk placement for operating system disk. Possible
     values are: **CacheDisk,** **ResourceDisk,** **NvmeDisk.** The defaulting behavior is:
     **CacheDisk** if one is configured for the VM size otherwise **ResourceDisk** or **NvmeDisk**
     is used. Refer to the VM size documentation for Windows VM at
     https://docs.microsoft.com/azure/virtual-machines/windows/sizes and Linux VM at
     https://docs.microsoft.com/azure/virtual-machines/linux/sizes to check which VM sizes exposes a
     cache disk. Minimum api-version for NvmeDisk: 2024-03-01. Known values are: "CacheDisk",
     "ResourceDisk", and "NvmeDisk".
    :vartype placement: str or ~azure.mgmt.compute.models.DiffDiskPlacement
    """

    _attribute_map = {
        "option": {"key": "option", "type": "str"},
        "placement": {"key": "placement", "type": "str"},
    }

    def __init__(
        self,
        *,
        option: Optional[Union[str, "_models.DiffDiskOptions"]] = None,
        placement: Optional[Union[str, "_models.DiffDiskPlacement"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword option: Specifies the ephemeral disk settings for operating system disk. "Local"
        :paramtype option: str or ~azure.mgmt.compute.models.DiffDiskOptions
        :keyword placement: Specifies the ephemeral disk placement for operating system disk. Possible
         values are: **CacheDisk,** **ResourceDisk,** **NvmeDisk.** The defaulting behavior is:
         **CacheDisk** if one is configured for the VM size otherwise **ResourceDisk** or **NvmeDisk**
         is used. Refer to the VM size documentation for Windows VM at
         https://docs.microsoft.com/azure/virtual-machines/windows/sizes and Linux VM at
         https://docs.microsoft.com/azure/virtual-machines/linux/sizes to check which VM sizes exposes a
         cache disk. Minimum api-version for NvmeDisk: 2024-03-01. Known values are: "CacheDisk",
         "ResourceDisk", and "NvmeDisk".
        :paramtype placement: str or ~azure.mgmt.compute.models.DiffDiskPlacement
        """
        super().__init__(**kwargs)
        self.option = option
        self.placement = placement


class Disallowed(_serialization.Model):
    """Describes the disallowed disk types.

    :ivar disk_types: A list of disk types.
    :vartype disk_types: list[str]
    """

    _attribute_map = {
        "disk_types": {"key": "diskTypes", "type": "[str]"},
    }

    def __init__(self, *, disk_types: Optional[list[str]] = None, **kwargs: Any) -> None:
        """
        :keyword disk_types: A list of disk types.
        :paramtype disk_types: list[str]
        """
        super().__init__(**kwargs)
        self.disk_types = disk_types


class DisallowedConfiguration(_serialization.Model):
    """Specifies the disallowed configuration for a virtual machine image.

    :ivar vm_disk_type: VM disk types which are disallowed. Known values are: "None" and
     "Unmanaged".
    :vartype vm_disk_type: str or ~azure.mgmt.compute.models.VmDiskTypes
    """

    _attribute_map = {
        "vm_disk_type": {"key": "vmDiskType", "type": "str"},
    }

    def __init__(self, *, vm_disk_type: Optional[Union[str, "_models.VmDiskTypes"]] = None, **kwargs: Any) -> None:
        """
        :keyword vm_disk_type: VM disk types which are disallowed. Known values are: "None" and
         "Unmanaged".
        :paramtype vm_disk_type: str or ~azure.mgmt.compute.models.VmDiskTypes
        """
        super().__init__(**kwargs)
        self.vm_disk_type = vm_disk_type


class Disk(TrackedResource):
    """Disk resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.compute.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar managed_by: A relative URI containing the ID of the VM that has the disk attached.
    :vartype managed_by: str
    :ivar managed_by_extended: List of relative URIs containing the IDs of the VMs that have the
     disk attached. maxShares should be set to a value greater than one for disks to allow attaching
     them to multiple VMs.
    :vartype managed_by_extended: list[str]
    :ivar sku: The disks sku name. Can be Standard_LRS, Premium_LRS, StandardSSD_LRS, UltraSSD_LRS,
     Premium_ZRS, StandardSSD_ZRS, or PremiumV2_LRS.
    :vartype sku: ~azure.mgmt.compute.models.DiskSku
    :ivar zones: The Logical zone list for Disk.
    :vartype zones: list[str]
    :ivar extended_location: The extended location where the disk will be created. Extended
     location cannot be changed.
    :vartype extended_location: ~azure.mgmt.compute.models.ExtendedLocation
    :ivar time_created: The time when the disk was created.
    :vartype time_created: ~datetime.datetime
    :ivar os_type: The Operating System type. Known values are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
    :ivar hyper_v_generation: The hypervisor generation of the Virtual Machine. Applicable to OS
     disks only. Known values are: "V1" and "V2".
    :vartype hyper_v_generation: str or ~azure.mgmt.compute.models.HyperVGeneration
    :ivar purchase_plan: Purchase plan information for the the image from which the OS disk was
     created. E.g. - {name: 2019-Datacenter, publisher: MicrosoftWindowsServer, product:
     WindowsServer}.
    :vartype purchase_plan: ~azure.mgmt.compute.models.DiskPurchasePlan
    :ivar supported_capabilities: List of supported capabilities for the image from which the OS
     disk was created.
    :vartype supported_capabilities: ~azure.mgmt.compute.models.SupportedCapabilities
    :ivar creation_data: Disk source information. CreationData information cannot be changed after
     the disk has been created.
    :vartype creation_data: ~azure.mgmt.compute.models.CreationData
    :ivar disk_size_gb: If creationData.createOption is Empty, this field is mandatory and it
     indicates the size of the disk to create. If this field is present for updates or creation with
     other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a
     running VM, and can only increase the disk's size.
    :vartype disk_size_gb: int
    :ivar disk_size_bytes: The size of the disk in bytes. This field is read only.
    :vartype disk_size_bytes: int
    :ivar unique_id: Unique Guid identifying the resource.
    :vartype unique_id: str
    :ivar encryption_settings_collection: Encryption settings collection used for Azure Disk
     Encryption, can contain multiple encryption settings per disk or snapshot.
    :vartype encryption_settings_collection:
     ~azure.mgmt.compute.models.EncryptionSettingsCollection
    :ivar provisioning_state: The disk provisioning state.
    :vartype provisioning_state: str
    :ivar disk_iops_read_write: The number of IOPS allowed for this disk; only settable for
     UltraSSD disks. One operation can transfer between 4k and 256k bytes.
    :vartype disk_iops_read_write: int
    :ivar disk_m_bps_read_write: The bandwidth allowed for this disk; only settable for UltraSSD
     disks. MBps means millions of bytes per second - MB here uses the ISO notation, of powers of
     10.
    :vartype disk_m_bps_read_write: int
    :ivar disk_iops_read_only: The total number of IOPS that will be allowed across all VMs
     mounting the shared disk as ReadOnly. One operation can transfer between 4k and 256k bytes.
    :vartype disk_iops_read_only: int
    :ivar disk_m_bps_read_only: The total throughput (MBps) that will be allowed across all VMs
     mounting the shared disk as ReadOnly. MBps means millions of bytes per second - MB here uses
     the ISO notation, of powers of 10.
    :vartype disk_m_bps_read_only: int
    :ivar disk_state: The state of the disk. Known values are: "Unattached", "Attached",
     "Reserved", "Frozen", "ActiveSAS", "ActiveSASFrozen", "ReadyToUpload", and "ActiveUpload".
    :vartype disk_state: str or ~azure.mgmt.compute.models.DiskState
    :ivar encryption: Encryption property can be used to encrypt data at rest with customer managed
     keys or platform managed keys.
    :vartype encryption: ~azure.mgmt.compute.models.Encryption
    :ivar max_shares: The maximum number of VMs that can attach to the disk at the same time. Value
     greater than one indicates a disk that can be mounted on multiple VMs at the same time.
    :vartype max_shares: int
    :ivar share_info: Details of the list of all VMs that have the disk attached. maxShares should
     be set to a value greater than one for disks to allow attaching them to multiple VMs.
    :vartype share_info: list[~azure.mgmt.compute.models.ShareInfoElement]
    :ivar network_access_policy: Policy for accessing the disk via network. Known values are:
     "AllowAll", "AllowPrivate", and "DenyAll".
    :vartype network_access_policy: str or ~azure.mgmt.compute.models.NetworkAccessPolicy
    :ivar disk_access_id: ARM id of the DiskAccess resource for using private endpoints on disks.
    :vartype disk_access_id: str
    :ivar bursting_enabled_time: Latest time when bursting was last enabled on a disk.
    :vartype bursting_enabled_time: ~datetime.datetime
    :ivar tier: Performance tier of the disk (e.g, P4, S10) as described here:
     https://azure.microsoft.com/en-us/pricing/details/managed-disks/. Does not apply to Ultra
     disks.
    :vartype tier: str
    :ivar bursting_enabled: Set to true to enable bursting beyond the provisioned performance
     target of the disk. Bursting is disabled by default. Does not apply to Ultra disks.
    :vartype bursting_enabled: bool
    :ivar property_updates_in_progress: Properties of the disk for which update is pending.
    :vartype property_updates_in_progress: ~azure.mgmt.compute.models.PropertyUpdatesInProgress
    :ivar supports_hibernation: Indicates the OS on a disk supports hibernation.
    :vartype supports_hibernation: bool
    :ivar security_profile: Contains the security related information for the resource.
    :vartype security_profile: ~azure.mgmt.compute.models.DiskSecurityProfile
    :ivar completion_percent: Percentage complete for the background copy when a resource is
     created via the CopyStart operation.
    :vartype completion_percent: float
    :ivar public_network_access: Policy for controlling export on the disk. Known values are:
     "Enabled" and "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.compute.models.PublicNetworkAccess
    :ivar data_access_auth_mode: Additional authentication requirements when exporting or uploading
     to a disk or snapshot. Known values are: "AzureActiveDirectory" and "None".
    :vartype data_access_auth_mode: str or ~azure.mgmt.compute.models.DataAccessAuthMode
    :ivar optimized_for_frequent_attach: Setting this property to true improves reliability and
     performance of data disks that are frequently (more than 5 times a day) by detached from one
     virtual machine and attached to another. This property should not be set for disks that are not
     detached and attached frequently as it causes the disks to not align with the fault domain of
     the virtual machine.
    :vartype optimized_for_frequent_attach: bool
    :ivar last_ownership_update_time: The UTC time when the ownership state of the disk was last
     changed i.e., the time the disk was last attached or detached from a VM or the time when the VM
     to which the disk was attached was deallocated or started.
    :vartype last_ownership_update_time: ~datetime.datetime
    :ivar availability_policy: Determines how platform treats disk failures.
    :vartype availability_policy: ~azure.mgmt.compute.models.AvailabilityPolicy
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "managed_by": {"readonly": True},
        "managed_by_extended": {"readonly": True},
        "time_created": {"readonly": True},
        "disk_size_bytes": {"readonly": True},
        "unique_id": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "disk_state": {"readonly": True},
        "share_info": {"readonly": True},
        "bursting_enabled_time": {"readonly": True},
        "property_updates_in_progress": {"readonly": True},
        "last_ownership_update_time": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "managed_by": {"key": "managedBy", "type": "str"},
        "managed_by_extended": {"key": "managedByExtended", "type": "[str]"},
        "sku": {"key": "sku", "type": "DiskSku"},
        "zones": {"key": "zones", "type": "[str]"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "time_created": {"key": "properties.timeCreated", "type": "iso-8601"},
        "os_type": {"key": "properties.osType", "type": "str"},
        "hyper_v_generation": {"key": "properties.hyperVGeneration", "type": "str"},
        "purchase_plan": {"key": "properties.purchasePlan", "type": "DiskPurchasePlan"},
        "supported_capabilities": {"key": "properties.supportedCapabilities", "type": "SupportedCapabilities"},
        "creation_data": {"key": "properties.creationData", "type": "CreationData"},
        "disk_size_gb": {"key": "properties.diskSizeGB", "type": "int"},
        "disk_size_bytes": {"key": "properties.diskSizeBytes", "type": "int"},
        "unique_id": {"key": "properties.uniqueId", "type": "str"},
        "encryption_settings_collection": {
            "key": "properties.encryptionSettingsCollection",
            "type": "EncryptionSettingsCollection",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "disk_iops_read_write": {"key": "properties.diskIOPSReadWrite", "type": "int"},
        "disk_m_bps_read_write": {"key": "properties.diskMBpsReadWrite", "type": "int"},
        "disk_iops_read_only": {"key": "properties.diskIOPSReadOnly", "type": "int"},
        "disk_m_bps_read_only": {"key": "properties.diskMBpsReadOnly", "type": "int"},
        "disk_state": {"key": "properties.diskState", "type": "str"},
        "encryption": {"key": "properties.encryption", "type": "Encryption"},
        "max_shares": {"key": "properties.maxShares", "type": "int"},
        "share_info": {"key": "properties.shareInfo", "type": "[ShareInfoElement]"},
        "network_access_policy": {"key": "properties.networkAccessPolicy", "type": "str"},
        "disk_access_id": {"key": "properties.diskAccessId", "type": "str"},
        "bursting_enabled_time": {"key": "properties.burstingEnabledTime", "type": "iso-8601"},
        "tier": {"key": "properties.tier", "type": "str"},
        "bursting_enabled": {"key": "properties.burstingEnabled", "type": "bool"},
        "property_updates_in_progress": {
            "key": "properties.propertyUpdatesInProgress",
            "type": "PropertyUpdatesInProgress",
        },
        "supports_hibernation": {"key": "properties.supportsHibernation", "type": "bool"},
        "security_profile": {"key": "properties.securityProfile", "type": "DiskSecurityProfile"},
        "completion_percent": {"key": "properties.completionPercent", "type": "float"},
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "data_access_auth_mode": {"key": "properties.dataAccessAuthMode", "type": "str"},
        "optimized_for_frequent_attach": {"key": "properties.optimizedForFrequentAttach", "type": "bool"},
        "last_ownership_update_time": {"key": "properties.LastOwnershipUpdateTime", "type": "iso-8601"},
        "availability_policy": {"key": "properties.availabilityPolicy", "type": "AvailabilityPolicy"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        sku: Optional["_models.DiskSku"] = None,
        zones: Optional[list[str]] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None,
        hyper_v_generation: Optional[Union[str, "_models.HyperVGeneration"]] = None,
        purchase_plan: Optional["_models.DiskPurchasePlan"] = None,
        supported_capabilities: Optional["_models.SupportedCapabilities"] = None,
        creation_data: Optional["_models.CreationData"] = None,
        disk_size_gb: Optional[int] = None,
        encryption_settings_collection: Optional["_models.EncryptionSettingsCollection"] = None,
        disk_iops_read_write: Optional[int] = None,
        disk_m_bps_read_write: Optional[int] = None,
        disk_iops_read_only: Optional[int] = None,
        disk_m_bps_read_only: Optional[int] = None,
        encryption: Optional["_models.Encryption"] = None,
        max_shares: Optional[int] = None,
        network_access_policy: Optional[Union[str, "_models.NetworkAccessPolicy"]] = None,
        disk_access_id: Optional[str] = None,
        tier: Optional[str] = None,
        bursting_enabled: Optional[bool] = None,
        supports_hibernation: Optional[bool] = None,
        security_profile: Optional["_models.DiskSecurityProfile"] = None,
        completion_percent: Optional[float] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        data_access_auth_mode: Optional[Union[str, "_models.DataAccessAuthMode"]] = None,
        optimized_for_frequent_attach: Optional[bool] = None,
        availability_policy: Optional["_models.AvailabilityPolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword sku: The disks sku name. Can be Standard_LRS, Premium_LRS, StandardSSD_LRS,
         UltraSSD_LRS, Premium_ZRS, StandardSSD_ZRS, or PremiumV2_LRS.
        :paramtype sku: ~azure.mgmt.compute.models.DiskSku
        :keyword zones: The Logical zone list for Disk.
        :paramtype zones: list[str]
        :keyword extended_location: The extended location where the disk will be created. Extended
         location cannot be changed.
        :paramtype extended_location: ~azure.mgmt.compute.models.ExtendedLocation
        :keyword os_type: The Operating System type. Known values are: "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
        :keyword hyper_v_generation: The hypervisor generation of the Virtual Machine. Applicable to OS
         disks only. Known values are: "V1" and "V2".
        :paramtype hyper_v_generation: str or ~azure.mgmt.compute.models.HyperVGeneration
        :keyword purchase_plan: Purchase plan information for the the image from which the OS disk was
         created. E.g. - {name: 2019-Datacenter, publisher: MicrosoftWindowsServer, product:
         WindowsServer}.
        :paramtype purchase_plan: ~azure.mgmt.compute.models.DiskPurchasePlan
        :keyword supported_capabilities: List of supported capabilities for the image from which the OS
         disk was created.
        :paramtype supported_capabilities: ~azure.mgmt.compute.models.SupportedCapabilities
        :keyword creation_data: Disk source information. CreationData information cannot be changed
         after the disk has been created.
        :paramtype creation_data: ~azure.mgmt.compute.models.CreationData
        :keyword disk_size_gb: If creationData.createOption is Empty, this field is mandatory and it
         indicates the size of the disk to create. If this field is present for updates or creation with
         other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a
         running VM, and can only increase the disk's size.
        :paramtype disk_size_gb: int
        :keyword encryption_settings_collection: Encryption settings collection used for Azure Disk
         Encryption, can contain multiple encryption settings per disk or snapshot.
        :paramtype encryption_settings_collection:
         ~azure.mgmt.compute.models.EncryptionSettingsCollection
        :keyword disk_iops_read_write: The number of IOPS allowed for this disk; only settable for
         UltraSSD disks. One operation can transfer between 4k and 256k bytes.
        :paramtype disk_iops_read_write: int
        :keyword disk_m_bps_read_write: The bandwidth allowed for this disk; only settable for UltraSSD
         disks. MBps means millions of bytes per second - MB here uses the ISO notation, of powers of
         10.
        :paramtype disk_m_bps_read_write: int
        :keyword disk_iops_read_only: The total number of IOPS that will be allowed across all VMs
         mounting the shared disk as ReadOnly. One operation can transfer between 4k and 256k bytes.
        :paramtype disk_iops_read_only: int
        :keyword disk_m_bps_read_only: The total throughput (MBps) that will be allowed across all VMs
         mounting the shared disk as ReadOnly. MBps means millions of bytes per second - MB here uses
         the ISO notation, of powers of 10.
        :paramtype disk_m_bps_read_only: int
        :keyword encryption: Encryption property can be used to encrypt data at rest with customer
         managed keys or platform managed keys.
        :paramtype encryption: ~azure.mgmt.compute.models.Encryption
        :keyword max_shares: The maximum number of VMs that can attach to the disk at the same time.
         Value greater than one indicates a disk that can be mounted on multiple VMs at the same time.
        :paramtype max_shares: int
        :keyword network_access_policy: Policy for accessing the disk via network. Known values are:
         "AllowAll", "AllowPrivate", and "DenyAll".
        :paramtype network_access_policy: str or ~azure.mgmt.compute.models.NetworkAccessPolicy
        :keyword disk_access_id: ARM id of the DiskAccess resource for using private endpoints on
         disks.
        :paramtype disk_access_id: str
        :keyword tier: Performance tier of the disk (e.g, P4, S10) as described here:
         https://azure.microsoft.com/en-us/pricing/details/managed-disks/. Does not apply to Ultra
         disks.
        :paramtype tier: str
        :keyword bursting_enabled: Set to true to enable bursting beyond the provisioned performance
         target of the disk. Bursting is disabled by default. Does not apply to Ultra disks.
        :paramtype bursting_enabled: bool
        :keyword supports_hibernation: Indicates the OS on a disk supports hibernation.
        :paramtype supports_hibernation: bool
        :keyword security_profile: Contains the security related information for the resource.
        :paramtype security_profile: ~azure.mgmt.compute.models.DiskSecurityProfile
        :keyword completion_percent: Percentage complete for the background copy when a resource is
         created via the CopyStart operation.
        :paramtype completion_percent: float
        :keyword public_network_access: Policy for controlling export on the disk. Known values are:
         "Enabled" and "Disabled".
        :paramtype public_network_access: str or ~azure.mgmt.compute.models.PublicNetworkAccess
        :keyword data_access_auth_mode: Additional authentication requirements when exporting or
         uploading to a disk or snapshot. Known values are: "AzureActiveDirectory" and "None".
        :paramtype data_access_auth_mode: str or ~azure.mgmt.compute.models.DataAccessAuthMode
        :keyword optimized_for_frequent_attach: Setting this property to true improves reliability and
         performance of data disks that are frequently (more than 5 times a day) by detached from one
         virtual machine and attached to another. This property should not be set for disks that are not
         detached and attached frequently as it causes the disks to not align with the fault domain of
         the virtual machine.
        :paramtype optimized_for_frequent_attach: bool
        :keyword availability_policy: Determines how platform treats disk failures.
        :paramtype availability_policy: ~azure.mgmt.compute.models.AvailabilityPolicy
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.managed_by: Optional[str] = None
        self.managed_by_extended: Optional[list[str]] = None
        self.sku = sku
        self.zones = zones
        self.extended_location = extended_location
        self.time_created: Optional[datetime.datetime] = None
        self.os_type = os_type
        self.hyper_v_generation = hyper_v_generation
        self.purchase_plan = purchase_plan
        self.supported_capabilities = supported_capabilities
        self.creation_data = creation_data
        self.disk_size_gb = disk_size_gb
        self.disk_size_bytes: Optional[int] = None
        self.unique_id: Optional[str] = None
        self.encryption_settings_collection = encryption_settings_collection
        self.provisioning_state: Optional[str] = None
        self.disk_iops_read_write = disk_iops_read_write
        self.disk_m_bps_read_write = disk_m_bps_read_write
        self.disk_iops_read_only = disk_iops_read_only
        self.disk_m_bps_read_only = disk_m_bps_read_only
        self.disk_state: Optional[Union[str, "_models.DiskState"]] = None
        self.encryption = encryption
        self.max_shares = max_shares
        self.share_info: Optional[list["_models.ShareInfoElement"]] = None
        self.network_access_policy = network_access_policy
        self.disk_access_id = disk_access_id
        self.bursting_enabled_time: Optional[datetime.datetime] = None
        self.tier = tier
        self.bursting_enabled = bursting_enabled
        self.property_updates_in_progress: Optional["_models.PropertyUpdatesInProgress"] = None
        self.supports_hibernation = supports_hibernation
        self.security_profile = security_profile
        self.completion_percent = completion_percent
        self.public_network_access = public_network_access
        self.data_access_auth_mode = data_access_auth_mode
        self.optimized_for_frequent_attach = optimized_for_frequent_attach
        self.last_ownership_update_time: Optional[datetime.datetime] = None
        self.availability_policy = availability_policy


class DiskAccess(TrackedResource):
    """disk access resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.compute.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar extended_location: The extended location where the disk access will be created. Extended
     location cannot be changed.
    :vartype extended_location: ~azure.mgmt.compute.models.ExtendedLocation
    :ivar private_endpoint_connections: A readonly collection of private endpoint connections
     created on the disk. Currently only one endpoint connection is supported.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.compute.models.PrivateEndpointConnection]
    :ivar provisioning_state: The disk access resource provisioning state.
    :vartype provisioning_state: str
    :ivar time_created: The time when the disk access was created.
    :vartype time_created: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "private_endpoint_connections": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "time_created": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "private_endpoint_connections": {
            "key": "properties.privateEndpointConnections",
            "type": "[PrivateEndpointConnection]",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "time_created": {"key": "properties.timeCreated", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword extended_location: The extended location where the disk access will be created.
         Extended location cannot be changed.
        :paramtype extended_location: ~azure.mgmt.compute.models.ExtendedLocation
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.extended_location = extended_location
        self.private_endpoint_connections: Optional[list["_models.PrivateEndpointConnection"]] = None
        self.provisioning_state: Optional[str] = None
        self.time_created: Optional[datetime.datetime] = None


class DiskAccessList(_serialization.Model):
    """The List disk access operation response.

    All required parameters must be populated in order to send to server.

    :ivar value: The DiskAccess items on this page. Required.
    :vartype value: list[~azure.mgmt.compute.models.DiskAccess]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DiskAccess]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: list["_models.DiskAccess"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The DiskAccess items on this page. Required.
        :paramtype value: list[~azure.mgmt.compute.models.DiskAccess]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DiskAccessUpdate(_serialization.Model):
    """Used for updating a disk access resource.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class DiskEncryptionSet(TrackedResource):
    """disk encryption set resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.compute.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar identity: The managed identity for the disk encryption set. It should be given permission
     on the key vault before it can be used to encrypt disks.
    :vartype identity: ~azure.mgmt.compute.models.EncryptionSetIdentity
    :ivar encryption_type: The type of key used to encrypt the data of the disk. Known values are:
     "EncryptionAtRestWithCustomerKey", "EncryptionAtRestWithPlatformAndCustomerKeys", and
     "ConfidentialVmEncryptedWithCustomerKey".
    :vartype encryption_type: str or ~azure.mgmt.compute.models.DiskEncryptionSetType
    :ivar active_key: The key vault key which is currently used by this disk encryption set.
    :vartype active_key: ~azure.mgmt.compute.models.KeyForDiskEncryptionSet
    :ivar previous_keys: A readonly collection of key vault keys previously used by this disk
     encryption set while a key rotation is in progress. It will be empty if there is no ongoing key
     rotation.
    :vartype previous_keys: list[~azure.mgmt.compute.models.KeyForDiskEncryptionSet]
    :ivar provisioning_state: The disk encryption set provisioning state.
    :vartype provisioning_state: str
    :ivar rotation_to_latest_key_version_enabled: Set this flag to true to enable auto-updating of
     this disk encryption set to the latest key version.
    :vartype rotation_to_latest_key_version_enabled: bool
    :ivar last_key_rotation_timestamp: The time when the active key of this disk encryption set was
     updated.
    :vartype last_key_rotation_timestamp: ~datetime.datetime
    :ivar auto_key_rotation_error: The error that was encountered during auto-key rotation. If an
     error is present, then auto-key rotation will not be attempted until the error on this disk
     encryption set is fixed.
    :vartype auto_key_rotation_error: ~azure.mgmt.compute.models.ApiError
    :ivar federated_client_id: Multi-tenant application client id to access key vault in a
     different tenant. Setting the value to 'None' will clear the property.
    :vartype federated_client_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "previous_keys": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "last_key_rotation_timestamp": {"readonly": True},
        "auto_key_rotation_error": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "identity": {"key": "identity", "type": "EncryptionSetIdentity"},
        "encryption_type": {"key": "properties.encryptionType", "type": "str"},
        "active_key": {"key": "properties.activeKey", "type": "KeyForDiskEncryptionSet"},
        "previous_keys": {"key": "properties.previousKeys", "type": "[KeyForDiskEncryptionSet]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "rotation_to_latest_key_version_enabled": {
            "key": "properties.rotationToLatestKeyVersionEnabled",
            "type": "bool",
        },
        "last_key_rotation_timestamp": {"key": "properties.lastKeyRotationTimestamp", "type": "iso-8601"},
        "auto_key_rotation_error": {"key": "properties.autoKeyRotationError", "type": "ApiError"},
        "federated_client_id": {"key": "properties.federatedClientId", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        identity: Optional["_models.EncryptionSetIdentity"] = None,
        encryption_type: Optional[Union[str, "_models.DiskEncryptionSetType"]] = None,
        active_key: Optional["_models.KeyForDiskEncryptionSet"] = None,
        rotation_to_latest_key_version_enabled: Optional[bool] = None,
        federated_client_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword identity: The managed identity for the disk encryption set. It should be given
         permission on the key vault before it can be used to encrypt disks.
        :paramtype identity: ~azure.mgmt.compute.models.EncryptionSetIdentity
        :keyword encryption_type: The type of key used to encrypt the data of the disk. Known values
         are: "EncryptionAtRestWithCustomerKey", "EncryptionAtRestWithPlatformAndCustomerKeys", and
         "ConfidentialVmEncryptedWithCustomerKey".
        :paramtype encryption_type: str or ~azure.mgmt.compute.models.DiskEncryptionSetType
        :keyword active_key: The key vault key which is currently used by this disk encryption set.
        :paramtype active_key: ~azure.mgmt.compute.models.KeyForDiskEncryptionSet
        :keyword rotation_to_latest_key_version_enabled: Set this flag to true to enable auto-updating
         of this disk encryption set to the latest key version.
        :paramtype rotation_to_latest_key_version_enabled: bool
        :keyword federated_client_id: Multi-tenant application client id to access key vault in a
         different tenant. Setting the value to 'None' will clear the property.
        :paramtype federated_client_id: str
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.encryption_type = encryption_type
        self.active_key = active_key
        self.previous_keys: Optional[list["_models.KeyForDiskEncryptionSet"]] = None
        self.provisioning_state: Optional[str] = None
        self.rotation_to_latest_key_version_enabled = rotation_to_latest_key_version_enabled
        self.last_key_rotation_timestamp: Optional[datetime.datetime] = None
        self.auto_key_rotation_error: Optional["_models.ApiError"] = None
        self.federated_client_id = federated_client_id


class DiskEncryptionSetList(_serialization.Model):
    """The List disk encryption set operation response.

    All required parameters must be populated in order to send to server.

    :ivar value: The DiskEncryptionSet items on this page. Required.
    :vartype value: list[~azure.mgmt.compute.models.DiskEncryptionSet]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DiskEncryptionSet]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: list["_models.DiskEncryptionSet"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The DiskEncryptionSet items on this page. Required.
        :paramtype value: list[~azure.mgmt.compute.models.DiskEncryptionSet]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SubResource(_serialization.Model):
    """SubResource.

    :ivar id: Resource Id.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource Id.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class DiskEncryptionSetParameters(SubResource):
    """Describes the parameter of customer managed disk encryption set resource id that can be
    specified for disk. **Note:** The disk encryption set resource id can only be specified for
    managed disk. Please refer https://aka.ms/mdssewithcmkoverview for more details.

    :ivar id: Resource Id.
    :vartype id: str
    """


class DiskEncryptionSettings(_serialization.Model):
    """Describes a Encryption Settings for a Disk.

    :ivar disk_encryption_key: Specifies the location of the disk encryption key, which is a Key
     Vault Secret.
    :vartype disk_encryption_key: ~azure.mgmt.compute.models.KeyVaultSecretReference
    :ivar key_encryption_key: Specifies the location of the key encryption key in Key Vault.
    :vartype key_encryption_key: ~azure.mgmt.compute.models.KeyVaultKeyReference
    :ivar enabled: Specifies whether disk encryption should be enabled on the virtual machine.
    :vartype enabled: bool
    """

    _attribute_map = {
        "disk_encryption_key": {"key": "diskEncryptionKey", "type": "KeyVaultSecretReference"},
        "key_encryption_key": {"key": "keyEncryptionKey", "type": "KeyVaultKeyReference"},
        "enabled": {"key": "enabled", "type": "bool"},
    }

    def __init__(
        self,
        *,
        disk_encryption_key: Optional["_models.KeyVaultSecretReference"] = None,
        key_encryption_key: Optional["_models.KeyVaultKeyReference"] = None,
        enabled: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword disk_encryption_key: Specifies the location of the disk encryption key, which is a Key
         Vault Secret.
        :paramtype disk_encryption_key: ~azure.mgmt.compute.models.KeyVaultSecretReference
        :keyword key_encryption_key: Specifies the location of the key encryption key in Key Vault.
        :paramtype key_encryption_key: ~azure.mgmt.compute.models.KeyVaultKeyReference
        :keyword enabled: Specifies whether disk encryption should be enabled on the virtual machine.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.disk_encryption_key = disk_encryption_key
        self.key_encryption_key = key_encryption_key
        self.enabled = enabled


class DiskEncryptionSetUpdate(_serialization.Model):
    """disk encryption set update resource.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar identity: The managed identity for the disk encryption set. It should be given permission
     on the key vault before it can be used to encrypt disks.
    :vartype identity: ~azure.mgmt.compute.models.EncryptionSetIdentity
    :ivar encryption_type: The type of key used to encrypt the data of the disk. Known values are:
     "EncryptionAtRestWithCustomerKey", "EncryptionAtRestWithPlatformAndCustomerKeys", and
     "ConfidentialVmEncryptedWithCustomerKey".
    :vartype encryption_type: str or ~azure.mgmt.compute.models.DiskEncryptionSetType
    :ivar active_key: Key Vault Key Url to be used for server side encryption of Managed Disks and
     Snapshots.
    :vartype active_key: ~azure.mgmt.compute.models.KeyForDiskEncryptionSet
    :ivar rotation_to_latest_key_version_enabled: Set this flag to true to enable auto-updating of
     this disk encryption set to the latest key version.
    :vartype rotation_to_latest_key_version_enabled: bool
    :ivar federated_client_id: Multi-tenant application client id to access key vault in a
     different tenant. Setting the value to 'None' will clear the property.
    :vartype federated_client_id: str
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "EncryptionSetIdentity"},
        "encryption_type": {"key": "properties.encryptionType", "type": "str"},
        "active_key": {"key": "properties.activeKey", "type": "KeyForDiskEncryptionSet"},
        "rotation_to_latest_key_version_enabled": {
            "key": "properties.rotationToLatestKeyVersionEnabled",
            "type": "bool",
        },
        "federated_client_id": {"key": "properties.federatedClientId", "type": "str"},
    }

    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
        identity: Optional["_models.EncryptionSetIdentity"] = None,
        encryption_type: Optional[Union[str, "_models.DiskEncryptionSetType"]] = None,
        active_key: Optional["_models.KeyForDiskEncryptionSet"] = None,
        rotation_to_latest_key_version_enabled: Optional[bool] = None,
        federated_client_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword identity: The managed identity for the disk encryption set. It should be given
         permission on the key vault before it can be used to encrypt disks.
        :paramtype identity: ~azure.mgmt.compute.models.EncryptionSetIdentity
        :keyword encryption_type: The type of key used to encrypt the data of the disk. Known values
         are: "EncryptionAtRestWithCustomerKey", "EncryptionAtRestWithPlatformAndCustomerKeys", and
         "ConfidentialVmEncryptedWithCustomerKey".
        :paramtype encryption_type: str or ~azure.mgmt.compute.models.DiskEncryptionSetType
        :keyword active_key: Key Vault Key Url to be used for server side encryption of Managed Disks
         and Snapshots.
        :paramtype active_key: ~azure.mgmt.compute.models.KeyForDiskEncryptionSet
        :keyword rotation_to_latest_key_version_enabled: Set this flag to true to enable auto-updating
         of this disk encryption set to the latest key version.
        :paramtype rotation_to_latest_key_version_enabled: bool
        :keyword federated_client_id: Multi-tenant application client id to access key vault in a
         different tenant. Setting the value to 'None' will clear the property.
        :paramtype federated_client_id: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.identity = identity
        self.encryption_type = encryption_type
        self.active_key = active_key
        self.rotation_to_latest_key_version_enabled = rotation_to_latest_key_version_enabled
        self.federated_client_id = federated_client_id


class DiskInstanceView(_serialization.Model):
    """The instance view of the disk.

    :ivar name: The disk name.
    :vartype name: str
    :ivar encryption_settings: Specifies the encryption settings for the OS Disk. :code:`<br>`\\
     :code:`<br>` Minimum api-version: 2015-06-15.
    :vartype encryption_settings: list[~azure.mgmt.compute.models.DiskEncryptionSettings]
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.models.InstanceViewStatus]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "encryption_settings": {"key": "encryptionSettings", "type": "[DiskEncryptionSettings]"},
        "statuses": {"key": "statuses", "type": "[InstanceViewStatus]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        encryption_settings: Optional[list["_models.DiskEncryptionSettings"]] = None,
        statuses: Optional[list["_models.InstanceViewStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The disk name.
        :paramtype name: str
        :keyword encryption_settings: Specifies the encryption settings for the OS Disk. :code:`<br>`\\
         :code:`<br>` Minimum api-version: 2015-06-15.
        :paramtype encryption_settings: list[~azure.mgmt.compute.models.DiskEncryptionSettings]
        :keyword statuses: The resource status information.
        :paramtype statuses: list[~azure.mgmt.compute.models.InstanceViewStatus]
        """
        super().__init__(**kwargs)
        self.name = name
        self.encryption_settings = encryption_settings
        self.statuses = statuses


class DiskList(_serialization.Model):
    """The List Disks operation response.

    All required parameters must be populated in order to send to server.

    :ivar value: The Disk items on this page. Required.
    :vartype value: list[~azure.mgmt.compute.models.Disk]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Disk]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: list["_models.Disk"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The Disk items on this page. Required.
        :paramtype value: list[~azure.mgmt.compute.models.Disk]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DiskPurchasePlan(_serialization.Model):
    """Used for establishing the purchase context of any 3rd Party artifact through MarketPlace.

    All required parameters must be populated in order to send to server.

    :ivar name: The plan ID. Required.
    :vartype name: str
    :ivar publisher: The publisher ID. Required.
    :vartype publisher: str
    :ivar product: Specifies the product of the image from the marketplace. This is the same value
     as Offer under the imageReference element. Required.
    :vartype product: str
    :ivar promotion_code: The Offer Promotion Code.
    :vartype promotion_code: str
    """

    _validation = {
        "name": {"required": True},
        "publisher": {"required": True},
        "product": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "publisher": {"key": "publisher", "type": "str"},
        "product": {"key": "product", "type": "str"},
        "promotion_code": {"key": "promotionCode", "type": "str"},
    }

    def __init__(
        self, *, name: str, publisher: str, product: str, promotion_code: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: The plan ID. Required.
        :paramtype name: str
        :keyword publisher: The publisher ID. Required.
        :paramtype publisher: str
        :keyword product: Specifies the product of the image from the marketplace. This is the same
         value as Offer under the imageReference element. Required.
        :paramtype product: str
        :keyword promotion_code: The Offer Promotion Code.
        :paramtype promotion_code: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.publisher = publisher
        self.product = product
        self.promotion_code = promotion_code


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.compute.models.SystemData
    """


class DiskRestorePoint(ProxyResource):
    """Properties of disk restore point.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.compute.models.SystemData
    :ivar time_created: The timestamp of restorePoint creation.
    :vartype time_created: ~datetime.datetime
    :ivar source_resource_id: arm id of source disk or source disk restore point.
    :vartype source_resource_id: str
    :ivar os_type: The Operating System type. Known values are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
    :ivar hyper_v_generation: The hypervisor generation of the Virtual Machine. Applicable to OS
     disks only. Known values are: "V1" and "V2".
    :vartype hyper_v_generation: str or ~azure.mgmt.compute.models.HyperVGeneration
    :ivar purchase_plan: Purchase plan information for the the image from which the OS disk was
     created.
    :vartype purchase_plan: ~azure.mgmt.compute.models.DiskPurchasePlan
    :ivar supported_capabilities: List of supported capabilities for the image from which the OS
     disk was created.
    :vartype supported_capabilities: ~azure.mgmt.compute.models.SupportedCapabilities
    :ivar family_id: id of the backing snapshot's MIS family.
    :vartype family_id: str
    :ivar source_unique_id: unique incarnation id of the source disk.
    :vartype source_unique_id: str
    :ivar encryption: Encryption property can be used to encrypt data at rest with customer managed
     keys or platform managed keys.
    :vartype encryption: ~azure.mgmt.compute.models.Encryption
    :ivar supports_hibernation: Indicates the OS on a disk supports hibernation.
    :vartype supports_hibernation: bool
    :ivar network_access_policy: Policy for accessing the disk via network. Known values are:
     "AllowAll", "AllowPrivate", and "DenyAll".
    :vartype network_access_policy: str or ~azure.mgmt.compute.models.NetworkAccessPolicy
    :ivar public_network_access: Policy for controlling export on the disk. Known values are:
     "Enabled" and "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.compute.models.PublicNetworkAccess
    :ivar disk_access_id: ARM id of the DiskAccess resource for using private endpoints on disks.
    :vartype disk_access_id: str
    :ivar completion_percent: Percentage complete for the background copy of disk restore point
     when source resource is from a different region.
    :vartype completion_percent: float
    :ivar replication_state: Replication state of disk restore point when source resource is from a
     different region.
    :vartype replication_state: str
    :ivar source_resource_location: Location of source disk or source disk restore point when
     source resource is from a different region.
    :vartype source_resource_location: str
    :ivar security_profile: Contains the security related information for the resource.
    :vartype security_profile: ~azure.mgmt.compute.models.DiskSecurityProfile
    :ivar logical_sector_size: Logical sector size in bytes for disk restore points of UltraSSD_LRS
     and PremiumV2_LRS disks. Supported values are 512 and 4096. 4096 is the default.
    :vartype logical_sector_size: int
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "time_created": {"readonly": True},
        "source_resource_id": {"readonly": True},
        "os_type": {"readonly": True},
        "family_id": {"readonly": True},
        "source_unique_id": {"readonly": True},
        "encryption": {"readonly": True},
        "replication_state": {"readonly": True},
        "source_resource_location": {"readonly": True},
        "logical_sector_size": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "time_created": {"key": "properties.timeCreated", "type": "iso-8601"},
        "source_resource_id": {"key": "properties.sourceResourceId", "type": "str"},
        "os_type": {"key": "properties.osType", "type": "str"},
        "hyper_v_generation": {"key": "properties.hyperVGeneration", "type": "str"},
        "purchase_plan": {"key": "properties.purchasePlan", "type": "DiskPurchasePlan"},
        "supported_capabilities": {"key": "properties.supportedCapabilities", "type": "SupportedCapabilities"},
        "family_id": {"key": "properties.familyId", "type": "str"},
        "source_unique_id": {"key": "properties.sourceUniqueId", "type": "str"},
        "encryption": {"key": "properties.encryption", "type": "Encryption"},
        "supports_hibernation": {"key": "properties.supportsHibernation", "type": "bool"},
        "network_access_policy": {"key": "properties.networkAccessPolicy", "type": "str"},
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "disk_access_id": {"key": "properties.diskAccessId", "type": "str"},
        "completion_percent": {"key": "properties.completionPercent", "type": "float"},
        "replication_state": {"key": "properties.replicationState", "type": "str"},
        "source_resource_location": {"key": "properties.sourceResourceLocation", "type": "str"},
        "security_profile": {"key": "properties.securityProfile", "type": "DiskSecurityProfile"},
        "logical_sector_size": {"key": "properties.logicalSectorSize", "type": "int"},
    }

    def __init__(
        self,
        *,
        hyper_v_generation: Optional[Union[str, "_models.HyperVGeneration"]] = None,
        purchase_plan: Optional["_models.DiskPurchasePlan"] = None,
        supported_capabilities: Optional["_models.SupportedCapabilities"] = None,
        supports_hibernation: Optional[bool] = None,
        network_access_policy: Optional[Union[str, "_models.NetworkAccessPolicy"]] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        disk_access_id: Optional[str] = None,
        completion_percent: Optional[float] = None,
        security_profile: Optional["_models.DiskSecurityProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword hyper_v_generation: The hypervisor generation of the Virtual Machine. Applicable to OS
         disks only. Known values are: "V1" and "V2".
        :paramtype hyper_v_generation: str or ~azure.mgmt.compute.models.HyperVGeneration
        :keyword purchase_plan: Purchase plan information for the the image from which the OS disk was
         created.
        :paramtype purchase_plan: ~azure.mgmt.compute.models.DiskPurchasePlan
        :keyword supported_capabilities: List of supported capabilities for the image from which the OS
         disk was created.
        :paramtype supported_capabilities: ~azure.mgmt.compute.models.SupportedCapabilities
        :keyword supports_hibernation: Indicates the OS on a disk supports hibernation.
        :paramtype supports_hibernation: bool
        :keyword network_access_policy: Policy for accessing the disk via network. Known values are:
         "AllowAll", "AllowPrivate", and "DenyAll".
        :paramtype network_access_policy: str or ~azure.mgmt.compute.models.NetworkAccessPolicy
        :keyword public_network_access: Policy for controlling export on the disk. Known values are:
         "Enabled" and "Disabled".
        :paramtype public_network_access: str or ~azure.mgmt.compute.models.PublicNetworkAccess
        :keyword disk_access_id: ARM id of the DiskAccess resource for using private endpoints on
         disks.
        :paramtype disk_access_id: str
        :keyword completion_percent: Percentage complete for the background copy of disk restore point
         when source resource is from a different region.
        :paramtype completion_percent: float
        :keyword security_profile: Contains the security related information for the resource.
        :paramtype security_profile: ~azure.mgmt.compute.models.DiskSecurityProfile
        """
        super().__init__(**kwargs)
        self.time_created: Optional[datetime.datetime] = None
        self.source_resource_id: Optional[str] = None
        self.os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None
        self.hyper_v_generation = hyper_v_generation
        self.purchase_plan = purchase_plan
        self.supported_capabilities = supported_capabilities
        self.family_id: Optional[str] = None
        self.source_unique_id: Optional[str] = None
        self.encryption: Optional["_models.Encryption"] = None
        self.supports_hibernation = supports_hibernation
        self.network_access_policy = network_access_policy
        self.public_network_access = public_network_access
        self.disk_access_id = disk_access_id
        self.completion_percent = completion_percent
        self.replication_state: Optional[str] = None
        self.source_resource_location: Optional[str] = None
        self.security_profile = security_profile
        self.logical_sector_size: Optional[int] = None


class SubResourceReadOnly(_serialization.Model):
    """SubResourceReadOnly.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None


class DiskRestorePointAttributes(SubResourceReadOnly):
    """Disk Restore Point details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar encryption: Encryption at rest settings for disk restore point. It is an optional
     property that can be specified in the input while creating a restore point.
    :vartype encryption: ~azure.mgmt.compute.models.RestorePointEncryption
    :ivar source_disk_restore_point: Resource Id of the source disk restore point.
    :vartype source_disk_restore_point: ~azure.mgmt.compute.models.ApiEntityReference
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "encryption": {"key": "encryption", "type": "RestorePointEncryption"},
        "source_disk_restore_point": {"key": "sourceDiskRestorePoint", "type": "ApiEntityReference"},
    }

    def __init__(
        self,
        *,
        encryption: Optional["_models.RestorePointEncryption"] = None,
        source_disk_restore_point: Optional["_models.ApiEntityReference"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword encryption: Encryption at rest settings for disk restore point. It is an optional
         property that can be specified in the input while creating a restore point.
        :paramtype encryption: ~azure.mgmt.compute.models.RestorePointEncryption
        :keyword source_disk_restore_point: Resource Id of the source disk restore point.
        :paramtype source_disk_restore_point: ~azure.mgmt.compute.models.ApiEntityReference
        """
        super().__init__(**kwargs)
        self.encryption = encryption
        self.source_disk_restore_point = source_disk_restore_point


class DiskRestorePointInstanceView(_serialization.Model):
    """The instance view of a disk restore point.

    :ivar id: Disk restore point Id.
    :vartype id: str
    :ivar replication_status: The disk restore point replication status information.
    :vartype replication_status: ~azure.mgmt.compute.models.DiskRestorePointReplicationStatus
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "replication_status": {"key": "replicationStatus", "type": "DiskRestorePointReplicationStatus"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        replication_status: Optional["_models.DiskRestorePointReplicationStatus"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Disk restore point Id.
        :paramtype id: str
        :keyword replication_status: The disk restore point replication status information.
        :paramtype replication_status: ~azure.mgmt.compute.models.DiskRestorePointReplicationStatus
        """
        super().__init__(**kwargs)
        self.id = id
        self.replication_status = replication_status


class DiskRestorePointList(_serialization.Model):
    """The List Disk Restore Points operation response.

    All required parameters must be populated in order to send to server.

    :ivar value: The DiskRestorePoint items on this page. Required.
    :vartype value: list[~azure.mgmt.compute.models.DiskRestorePoint]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DiskRestorePoint]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: list["_models.DiskRestorePoint"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The DiskRestorePoint items on this page. Required.
        :paramtype value: list[~azure.mgmt.compute.models.DiskRestorePoint]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DiskRestorePointReplicationStatus(_serialization.Model):
    """The instance view of a disk restore point.

    :ivar status: The resource status information.
    :vartype status: ~azure.mgmt.compute.models.InstanceViewStatus
    :ivar completion_percent: Replication completion percentage.
    :vartype completion_percent: int
    """

    _attribute_map = {
        "status": {"key": "status", "type": "InstanceViewStatus"},
        "completion_percent": {"key": "completionPercent", "type": "int"},
    }

    def __init__(
        self,
        *,
        status: Optional["_models.InstanceViewStatus"] = None,
        completion_percent: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: The resource status information.
        :paramtype status: ~azure.mgmt.compute.models.InstanceViewStatus
        :keyword completion_percent: Replication completion percentage.
        :paramtype completion_percent: int
        """
        super().__init__(**kwargs)
        self.status = status
        self.completion_percent = completion_percent


class DiskSecurityProfile(_serialization.Model):
    """Contains the security related information for the resource.

    :ivar security_type: Specifies the SecurityType of the VM. Applicable for OS disks only. Known
     values are: "TrustedLaunch", "ConfidentialVM_VMGuestStateOnlyEncryptedWithPlatformKey",
     "ConfidentialVM_DiskEncryptedWithPlatformKey", "ConfidentialVM_DiskEncryptedWithCustomerKey",
     and "ConfidentialVM_NonPersistedTPM".
    :vartype security_type: str or ~azure.mgmt.compute.models.DiskSecurityTypes
    :ivar secure_vm_disk_encryption_set_id: ResourceId of the disk encryption set associated to
     Confidential VM supported disk encrypted with customer managed key.
    :vartype secure_vm_disk_encryption_set_id: str
    """

    _attribute_map = {
        "security_type": {"key": "securityType", "type": "str"},
        "secure_vm_disk_encryption_set_id": {"key": "secureVMDiskEncryptionSetId", "type": "str"},
    }

    def __init__(
        self,
        *,
        security_type: Optional[Union[str, "_models.DiskSecurityTypes"]] = None,
        secure_vm_disk_encryption_set_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword security_type: Specifies the SecurityType of the VM. Applicable for OS disks only.
         Known values are: "TrustedLaunch", "ConfidentialVM_VMGuestStateOnlyEncryptedWithPlatformKey",
         "ConfidentialVM_DiskEncryptedWithPlatformKey", "ConfidentialVM_DiskEncryptedWithCustomerKey",
         and "ConfidentialVM_NonPersistedTPM".
        :paramtype security_type: str or ~azure.mgmt.compute.models.DiskSecurityTypes
        :keyword secure_vm_disk_encryption_set_id: ResourceId of the disk encryption set associated to
         Confidential VM supported disk encrypted with customer managed key.
        :paramtype secure_vm_disk_encryption_set_id: str
        """
        super().__init__(**kwargs)
        self.security_type = security_type
        self.secure_vm_disk_encryption_set_id = secure_vm_disk_encryption_set_id


class DiskSku(_serialization.Model):
    """The disks sku name. Can be Standard_LRS, Premium_LRS, StandardSSD_LRS, UltraSSD_LRS,
    Premium_ZRS, StandardSSD_ZRS, or PremiumV2_LRS.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The sku name. Known values are: "Standard_LRS", "Premium_LRS", "StandardSSD_LRS",
     "UltraSSD_LRS", "Premium_ZRS", "StandardSSD_ZRS", and "PremiumV2_LRS".
    :vartype name: str or ~azure.mgmt.compute.models.DiskStorageAccountTypes
    :ivar tier: The sku tier.
    :vartype tier: str
    """

    _validation = {
        "tier": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
    }

    def __init__(self, *, name: Optional[Union[str, "_models.DiskStorageAccountTypes"]] = None, **kwargs: Any) -> None:
        """
        :keyword name: The sku name. Known values are: "Standard_LRS", "Premium_LRS",
         "StandardSSD_LRS", "UltraSSD_LRS", "Premium_ZRS", "StandardSSD_ZRS", and "PremiumV2_LRS".
        :paramtype name: str or ~azure.mgmt.compute.models.DiskStorageAccountTypes
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier: Optional[str] = None


class DiskUpdate(_serialization.Model):
    """Disk update resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: The disks sku name. Can be Standard_LRS, Premium_LRS, StandardSSD_LRS, UltraSSD_LRS,
     Premium_ZRS, StandardSSD_ZRS, or PremiumV2_LRS.
    :vartype sku: ~azure.mgmt.compute.models.DiskSku
    :ivar os_type: the Operating System type. Known values are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
    :ivar disk_size_gb: If creationData.createOption is Empty, this field is mandatory and it
     indicates the size of the disk to create. If this field is present for updates or creation with
     other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a
     running VM, and can only increase the disk's size.
    :vartype disk_size_gb: int
    :ivar encryption_settings_collection: Encryption settings collection used be Azure Disk
     Encryption, can contain multiple encryption settings per disk or snapshot.
    :vartype encryption_settings_collection:
     ~azure.mgmt.compute.models.EncryptionSettingsCollection
    :ivar disk_iops_read_write: The number of IOPS allowed for this disk; only settable for
     UltraSSD disks. One operation can transfer between 4k and 256k bytes.
    :vartype disk_iops_read_write: int
    :ivar disk_m_bps_read_write: The bandwidth allowed for this disk; only settable for UltraSSD
     disks. MBps means millions of bytes per second - MB here uses the ISO notation, of powers of
     10.
    :vartype disk_m_bps_read_write: int
    :ivar disk_iops_read_only: The total number of IOPS that will be allowed across all VMs
     mounting the shared disk as ReadOnly. One operation can transfer between 4k and 256k bytes.
    :vartype disk_iops_read_only: int
    :ivar disk_m_bps_read_only: The total throughput (MBps) that will be allowed across all VMs
     mounting the shared disk as ReadOnly. MBps means millions of bytes per second - MB here uses
     the ISO notation, of powers of 10.
    :vartype disk_m_bps_read_only: int
    :ivar max_shares: The maximum number of VMs that can attach to the disk at the same time. Value
     greater than one indicates a disk that can be mounted on multiple VMs at the same time.
    :vartype max_shares: int
    :ivar encryption: Encryption property can be used to encrypt data at rest with customer managed
     keys or platform managed keys.
    :vartype encryption: ~azure.mgmt.compute.models.Encryption
    :ivar network_access_policy: Policy for accessing the disk via network. Known values are:
     "AllowAll", "AllowPrivate", and "DenyAll".
    :vartype network_access_policy: str or ~azure.mgmt.compute.models.NetworkAccessPolicy
    :ivar disk_access_id: ARM id of the DiskAccess resource for using private endpoints on disks.
    :vartype disk_access_id: str
    :ivar tier: Performance tier of the disk (e.g, P4, S10) as described here:
     https://azure.microsoft.com/en-us/pricing/details/managed-disks/. Does not apply to Ultra
     disks.
    :vartype tier: str
    :ivar bursting_enabled: Set to true to enable bursting beyond the provisioned performance
     target of the disk. Bursting is disabled by default. Does not apply to Ultra disks.
    :vartype bursting_enabled: bool
    :ivar purchase_plan: Purchase plan information to be added on the OS disk.
    :vartype purchase_plan: ~azure.mgmt.compute.models.DiskPurchasePlan
    :ivar supported_capabilities: List of supported capabilities to be added on the OS disk.
    :vartype supported_capabilities: ~azure.mgmt.compute.models.SupportedCapabilities
    :ivar property_updates_in_progress: Properties of the disk for which update is pending.
    :vartype property_updates_in_progress: ~azure.mgmt.compute.models.PropertyUpdatesInProgress
    :ivar supports_hibernation: Indicates the OS on a disk supports hibernation.
    :vartype supports_hibernation: bool
    :ivar public_network_access: Policy for controlling export on the disk. Known values are:
     "Enabled" and "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.compute.models.PublicNetworkAccess
    :ivar data_access_auth_mode: Additional authentication requirements when exporting or uploading
     to a disk or snapshot. Known values are: "AzureActiveDirectory" and "None".
    :vartype data_access_auth_mode: str or ~azure.mgmt.compute.models.DataAccessAuthMode
    :ivar optimized_for_frequent_attach: Setting this property to true improves reliability and
     performance of data disks that are frequently (more than 5 times a day) by detached from one
     virtual machine and attached to another. This property should not be set for disks that are not
     detached and attached frequently as it causes the disks to not align with the fault domain of
     the virtual machine.
    :vartype optimized_for_frequent_attach: bool
    :ivar availability_policy: Determines how platform treats disk failures.
    :vartype availability_policy: ~azure.mgmt.compute.models.AvailabilityPolicy
    """

    _validation = {
        "property_updates_in_progress": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "DiskSku"},
        "os_type": {"key": "properties.osType", "type": "str"},
        "disk_size_gb": {"key": "properties.diskSizeGB", "type": "int"},
        "encryption_settings_collection": {
            "key": "properties.encryptionSettingsCollection",
            "type": "EncryptionSettingsCollection",
        },
        "disk_iops_read_write": {"key": "properties.diskIOPSReadWrite", "type": "int"},
        "disk_m_bps_read_write": {"key": "properties.diskMBpsReadWrite", "type": "int"},
        "disk_iops_read_only": {"key": "properties.diskIOPSReadOnly", "type": "int"},
        "disk_m_bps_read_only": {"key": "properties.diskMBpsReadOnly", "type": "int"},
        "max_shares": {"key": "properties.maxShares", "type": "int"},
        "encryption": {"key": "properties.encryption", "type": "Encryption"},
        "network_access_policy": {"key": "properties.networkAccessPolicy", "type": "str"},
        "disk_access_id": {"key": "properties.diskAccessId", "type": "str"},
        "tier": {"key": "properties.tier", "type": "str"},
        "bursting_enabled": {"key": "properties.burstingEnabled", "type": "bool"},
        "purchase_plan": {"key": "properties.purchasePlan", "type": "DiskPurchasePlan"},
        "supported_capabilities": {"key": "properties.supportedCapabilities", "type": "SupportedCapabilities"},
        "property_updates_in_progress": {
            "key": "properties.propertyUpdatesInProgress",
            "type": "PropertyUpdatesInProgress",
        },
        "supports_hibernation": {"key": "properties.supportsHibernation", "type": "bool"},
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "data_access_auth_mode": {"key": "properties.dataAccessAuthMode", "type": "str"},
        "optimized_for_frequent_attach": {"key": "properties.optimizedForFrequentAttach", "type": "bool"},
        "availability_policy": {"key": "properties.availabilityPolicy", "type": "AvailabilityPolicy"},
    }

    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
        sku: Optional["_models.DiskSku"] = None,
        os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None,
        disk_size_gb: Optional[int] = None,
        encryption_settings_collection: Optional["_models.EncryptionSettingsCollection"] = None,
        disk_iops_read_write: Optional[int] = None,
        disk_m_bps_read_write: Optional[int] = None,
        disk_iops_read_only: Optional[int] = None,
        disk_m_bps_read_only: Optional[int] = None,
        max_shares: Optional[int] = None,
        encryption: Optional["_models.Encryption"] = None,
        network_access_policy: Optional[Union[str, "_models.NetworkAccessPolicy"]] = None,
        disk_access_id: Optional[str] = None,
        tier: Optional[str] = None,
        bursting_enabled: Optional[bool] = None,
        purchase_plan: Optional["_models.DiskPurchasePlan"] = None,
        supported_capabilities: Optional["_models.SupportedCapabilities"] = None,
        supports_hibernation: Optional[bool] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        data_access_auth_mode: Optional[Union[str, "_models.DataAccessAuthMode"]] = None,
        optimized_for_frequent_attach: Optional[bool] = None,
        availability_policy: Optional["_models.AvailabilityPolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: The disks sku name. Can be Standard_LRS, Premium_LRS, StandardSSD_LRS,
         UltraSSD_LRS, Premium_ZRS, StandardSSD_ZRS, or PremiumV2_LRS.
        :paramtype sku: ~azure.mgmt.compute.models.DiskSku
        :keyword os_type: the Operating System type. Known values are: "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
        :keyword disk_size_gb: If creationData.createOption is Empty, this field is mandatory and it
         indicates the size of the disk to create. If this field is present for updates or creation with
         other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a
         running VM, and can only increase the disk's size.
        :paramtype disk_size_gb: int
        :keyword encryption_settings_collection: Encryption settings collection used be Azure Disk
         Encryption, can contain multiple encryption settings per disk or snapshot.
        :paramtype encryption_settings_collection:
         ~azure.mgmt.compute.models.EncryptionSettingsCollection
        :keyword disk_iops_read_write: The number of IOPS allowed for this disk; only settable for
         UltraSSD disks. One operation can transfer between 4k and 256k bytes.
        :paramtype disk_iops_read_write: int
        :keyword disk_m_bps_read_write: The bandwidth allowed for this disk; only settable for UltraSSD
         disks. MBps means millions of bytes per second - MB here uses the ISO notation, of powers of
         10.
        :paramtype disk_m_bps_read_write: int
        :keyword disk_iops_read_only: The total number of IOPS that will be allowed across all VMs
         mounting the shared disk as ReadOnly. One operation can transfer between 4k and 256k bytes.
        :paramtype disk_iops_read_only: int
        :keyword disk_m_bps_read_only: The total throughput (MBps) that will be allowed across all VMs
         mounting the shared disk as ReadOnly. MBps means millions of bytes per second - MB here uses
         the ISO notation, of powers of 10.
        :paramtype disk_m_bps_read_only: int
        :keyword max_shares: The maximum number of VMs that can attach to the disk at the same time.
         Value greater than one indicates a disk that can be mounted on multiple VMs at the same time.
        :paramtype max_shares: int
        :keyword encryption: Encryption property can be used to encrypt data at rest with customer
         managed keys or platform managed keys.
        :paramtype encryption: ~azure.mgmt.compute.models.Encryption
        :keyword network_access_policy: Policy for accessing the disk via network. Known values are:
         "AllowAll", "AllowPrivate", and "DenyAll".
        :paramtype network_access_policy: str or ~azure.mgmt.compute.models.NetworkAccessPolicy
        :keyword disk_access_id: ARM id of the DiskAccess resource for using private endpoints on
         disks.
        :paramtype disk_access_id: str
        :keyword tier: Performance tier of the disk (e.g, P4, S10) as described here:
         https://azure.microsoft.com/en-us/pricing/details/managed-disks/. Does not apply to Ultra
         disks.
        :paramtype tier: str
        :keyword bursting_enabled: Set to true to enable bursting beyond the provisioned performance
         target of the disk. Bursting is disabled by default. Does not apply to Ultra disks.
        :paramtype bursting_enabled: bool
        :keyword purchase_plan: Purchase plan information to be added on the OS disk.
        :paramtype purchase_plan: ~azure.mgmt.compute.models.DiskPurchasePlan
        :keyword supported_capabilities: List of supported capabilities to be added on the OS disk.
        :paramtype supported_capabilities: ~azure.mgmt.compute.models.SupportedCapabilities
        :keyword supports_hibernation: Indicates the OS on a disk supports hibernation.
        :paramtype supports_hibernation: bool
        :keyword public_network_access: Policy for controlling export on the disk. Known values are:
         "Enabled" and "Disabled".
        :paramtype public_network_access: str or ~azure.mgmt.compute.models.PublicNetworkAccess
        :keyword data_access_auth_mode: Additional authentication requirements when exporting or
         uploading to a disk or snapshot. Known values are: "AzureActiveDirectory" and "None".
        :paramtype data_access_auth_mode: str or ~azure.mgmt.compute.models.DataAccessAuthMode
        :keyword optimized_for_frequent_attach: Setting this property to true improves reliability and
         performance of data disks that are frequently (more than 5 times a day) by detached from one
         virtual machine and attached to another. This property should not be set for disks that are not
         detached and attached frequently as it causes the disks to not align with the fault domain of
         the virtual machine.
        :paramtype optimized_for_frequent_attach: bool
        :keyword availability_policy: Determines how platform treats disk failures.
        :paramtype availability_policy: ~azure.mgmt.compute.models.AvailabilityPolicy
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.sku = sku
        self.os_type = os_type
        self.disk_size_gb = disk_size_gb
        self.encryption_settings_collection = encryption_settings_collection
        self.disk_iops_read_write = disk_iops_read_write
        self.disk_m_bps_read_write = disk_m_bps_read_write
        self.disk_iops_read_only = disk_iops_read_only
        self.disk_m_bps_read_only = disk_m_bps_read_only
        self.max_shares = max_shares
        self.encryption = encryption
        self.network_access_policy = network_access_policy
        self.disk_access_id = disk_access_id
        self.tier = tier
        self.bursting_enabled = bursting_enabled
        self.purchase_plan = purchase_plan
        self.supported_capabilities = supported_capabilities
        self.property_updates_in_progress: Optional["_models.PropertyUpdatesInProgress"] = None
        self.supports_hibernation = supports_hibernation
        self.public_network_access = public_network_access
        self.data_access_auth_mode = data_access_auth_mode
        self.optimized_for_frequent_attach = optimized_for_frequent_attach
        self.availability_policy = availability_policy


class Encryption(_serialization.Model):
    """Encryption at rest settings for disk or snapshot.

    :ivar disk_encryption_set_id: ResourceId of the disk encryption set to use for enabling
     encryption at rest.
    :vartype disk_encryption_set_id: str
    :ivar type: The type of key used to encrypt the data of the disk. Known values are:
     "EncryptionAtRestWithPlatformKey", "EncryptionAtRestWithCustomerKey", and
     "EncryptionAtRestWithPlatformAndCustomerKeys".
    :vartype type: str or ~azure.mgmt.compute.models.EncryptionType
    """

    _attribute_map = {
        "disk_encryption_set_id": {"key": "diskEncryptionSetId", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        disk_encryption_set_id: Optional[str] = None,
        type: Optional[Union[str, "_models.EncryptionType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword disk_encryption_set_id: ResourceId of the disk encryption set to use for enabling
         encryption at rest.
        :paramtype disk_encryption_set_id: str
        :keyword type: The type of key used to encrypt the data of the disk. Known values are:
         "EncryptionAtRestWithPlatformKey", "EncryptionAtRestWithCustomerKey", and
         "EncryptionAtRestWithPlatformAndCustomerKeys".
        :paramtype type: str or ~azure.mgmt.compute.models.EncryptionType
        """
        super().__init__(**kwargs)
        self.disk_encryption_set_id = disk_encryption_set_id
        self.type = type


class EncryptionIdentity(_serialization.Model):
    """Specifies the Managed Identity used by ADE to get access token for keyvault operations.

    :ivar user_assigned_identity_resource_id: Specifies ARM Resource ID of one of the user
     identities associated with the VM.
    :vartype user_assigned_identity_resource_id: str
    """

    _attribute_map = {
        "user_assigned_identity_resource_id": {"key": "userAssignedIdentityResourceId", "type": "str"},
    }

    def __init__(self, *, user_assigned_identity_resource_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword user_assigned_identity_resource_id: Specifies ARM Resource ID of one of the user
         identities associated with the VM.
        :paramtype user_assigned_identity_resource_id: str
        """
        super().__init__(**kwargs)
        self.user_assigned_identity_resource_id = user_assigned_identity_resource_id


class EncryptionImages(_serialization.Model):
    """Optional. Allows users to provide customer managed keys for encrypting the OS and data disks in
    the gallery artifact.

    :ivar os_disk_image: Contains encryption settings for an OS disk image.
    :vartype os_disk_image: ~azure.mgmt.compute.models.OSDiskImageEncryption
    :ivar data_disk_images: A list of encryption specifications for data disk images.
    :vartype data_disk_images: list[~azure.mgmt.compute.models.DataDiskImageEncryption]
    """

    _attribute_map = {
        "os_disk_image": {"key": "osDiskImage", "type": "OSDiskImageEncryption"},
        "data_disk_images": {"key": "dataDiskImages", "type": "[DataDiskImageEncryption]"},
    }

    def __init__(
        self,
        *,
        os_disk_image: Optional["_models.OSDiskImageEncryption"] = None,
        data_disk_images: Optional[list["_models.DataDiskImageEncryption"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword os_disk_image: Contains encryption settings for an OS disk image.
        :paramtype os_disk_image: ~azure.mgmt.compute.models.OSDiskImageEncryption
        :keyword data_disk_images: A list of encryption specifications for data disk images.
        :paramtype data_disk_images: list[~azure.mgmt.compute.models.DataDiskImageEncryption]
        """
        super().__init__(**kwargs)
        self.os_disk_image = os_disk_image
        self.data_disk_images = data_disk_images


class EncryptionSetIdentity(_serialization.Model):
    """The managed identity for the disk encryption set. It should be given permission on the key
    vault before it can be used to encrypt disks.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of Managed Identity used by the DiskEncryptionSet. Only SystemAssigned is
     supported for new creations. Disk Encryption Sets can be updated with Identity type None during
     migration of subscription to a new Azure Active Directory tenant; it will cause the encrypted
     resources to lose access to the keys. Known values are: "SystemAssigned", "UserAssigned",
     "SystemAssigned, UserAssigned", and "None".
    :vartype type: str or ~azure.mgmt.compute.models.DiskEncryptionSetIdentityType
    :ivar principal_id: The object id of the Managed Identity Resource. This will be sent to the RP
     from ARM via the x-ms-identity-principal-id header in the PUT request if the resource has a
     systemAssigned(implicit) identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id of the Managed Identity Resource. This will be sent to the RP
     from ARM via the x-ms-client-tenant-id header in the PUT request if the resource has a
     systemAssigned(implicit) identity.
    :vartype tenant_id: str
    :ivar user_assigned_identities: The list of user identities associated with the disk encryption
     set. The user identity dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.compute.models.UserAssignedIdentitiesValue]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedIdentitiesValue}"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.DiskEncryptionSetIdentityType"]] = None,
        user_assigned_identities: Optional[dict[str, "_models.UserAssignedIdentitiesValue"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The type of Managed Identity used by the DiskEncryptionSet. Only SystemAssigned
         is supported for new creations. Disk Encryption Sets can be updated with Identity type None
         during migration of subscription to a new Azure Active Directory tenant; it will cause the
         encrypted resources to lose access to the keys. Known values are: "SystemAssigned",
         "UserAssigned", "SystemAssigned, UserAssigned", and "None".
        :paramtype type: str or ~azure.mgmt.compute.models.DiskEncryptionSetIdentityType
        :keyword user_assigned_identities: The list of user identities associated with the disk
         encryption set. The user identity dictionary key references will be ARM resource ids in the
         form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.compute.models.UserAssignedIdentitiesValue]
        """
        super().__init__(**kwargs)
        self.type = type
        self.principal_id: Optional[str] = None
        self.tenant_id: Optional[str] = None
        self.user_assigned_identities = user_assigned_identities


class EncryptionSettingsCollection(_serialization.Model):
    """Encryption settings for disk or snapshot.

    All required parameters must be populated in order to send to server.

    :ivar enabled: Set this flag to true and provide DiskEncryptionKey and optional
     KeyEncryptionKey to enable encryption. Set this flag to false and remove DiskEncryptionKey and
     KeyEncryptionKey to disable encryption. If EncryptionSettings is null in the request object,
     the existing settings remain unchanged. Required.
    :vartype enabled: bool
    :ivar encryption_settings: A collection of encryption settings, one for each disk volume.
    :vartype encryption_settings: list[~azure.mgmt.compute.models.EncryptionSettingsElement]
    :ivar encryption_settings_version: Describes what type of encryption is used for the disks.
     Once this field is set, it cannot be overwritten. '1.0' corresponds to Azure Disk Encryption
     with AAD app.'1.1' corresponds to Azure Disk Encryption.
    :vartype encryption_settings_version: str
    """

    _validation = {
        "enabled": {"required": True},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "encryption_settings": {"key": "encryptionSettings", "type": "[EncryptionSettingsElement]"},
        "encryption_settings_version": {"key": "encryptionSettingsVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        enabled: bool,
        encryption_settings: Optional[list["_models.EncryptionSettingsElement"]] = None,
        encryption_settings_version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Set this flag to true and provide DiskEncryptionKey and optional
         KeyEncryptionKey to enable encryption. Set this flag to false and remove DiskEncryptionKey and
         KeyEncryptionKey to disable encryption. If EncryptionSettings is null in the request object,
         the existing settings remain unchanged. Required.
        :paramtype enabled: bool
        :keyword encryption_settings: A collection of encryption settings, one for each disk volume.
        :paramtype encryption_settings: list[~azure.mgmt.compute.models.EncryptionSettingsElement]
        :keyword encryption_settings_version: Describes what type of encryption is used for the disks.
         Once this field is set, it cannot be overwritten. '1.0' corresponds to Azure Disk Encryption
         with AAD app.'1.1' corresponds to Azure Disk Encryption.
        :paramtype encryption_settings_version: str
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.encryption_settings = encryption_settings
        self.encryption_settings_version = encryption_settings_version


class EncryptionSettingsElement(_serialization.Model):
    """Encryption settings for one disk volume.

    :ivar disk_encryption_key: Key Vault Secret Url and vault id of the disk encryption key.
    :vartype disk_encryption_key: ~azure.mgmt.compute.models.KeyVaultAndSecretReference
    :ivar key_encryption_key: Key Vault Key Url and vault id of the key encryption key.
     KeyEncryptionKey is optional and when provided is used to unwrap the disk encryption key.
    :vartype key_encryption_key: ~azure.mgmt.compute.models.KeyVaultAndKeyReference
    """

    _attribute_map = {
        "disk_encryption_key": {"key": "diskEncryptionKey", "type": "KeyVaultAndSecretReference"},
        "key_encryption_key": {"key": "keyEncryptionKey", "type": "KeyVaultAndKeyReference"},
    }

    def __init__(
        self,
        *,
        disk_encryption_key: Optional["_models.KeyVaultAndSecretReference"] = None,
        key_encryption_key: Optional["_models.KeyVaultAndKeyReference"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword disk_encryption_key: Key Vault Secret Url and vault id of the disk encryption key.
        :paramtype disk_encryption_key: ~azure.mgmt.compute.models.KeyVaultAndSecretReference
        :keyword key_encryption_key: Key Vault Key Url and vault id of the key encryption key.
         KeyEncryptionKey is optional and when provided is used to unwrap the disk encryption key.
        :paramtype key_encryption_key: ~azure.mgmt.compute.models.KeyVaultAndKeyReference
        """
        super().__init__(**kwargs)
        self.disk_encryption_key = disk_encryption_key
        self.key_encryption_key = key_encryption_key


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.info: Optional[JSON] = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.compute.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.compute.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None
        self.target: Optional[str] = None
        self.details: Optional[list["_models.ErrorDetail"]] = None
        self.additional_info: Optional[list["_models.ErrorAdditionalInfo"]] = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.compute.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.compute.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class EventGridAndResourceGraph(_serialization.Model):
    """Specifies eventGridAndResourceGraph related Scheduled Event related configurations.

    :ivar enable: Specifies if event grid and resource graph is enabled for Scheduled event related
     configurations.
    :vartype enable: bool
    :ivar scheduled_events_api_version: Specifies the api-version to determine which Scheduled
     Events configuration schema version will be delivered.
    :vartype scheduled_events_api_version: str
    """

    _attribute_map = {
        "enable": {"key": "enable", "type": "bool"},
        "scheduled_events_api_version": {"key": "scheduledEventsApiVersion", "type": "str"},
    }

    def __init__(
        self, *, enable: Optional[bool] = None, scheduled_events_api_version: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword enable: Specifies if event grid and resource graph is enabled for Scheduled event
         related configurations.
        :paramtype enable: bool
        :keyword scheduled_events_api_version: Specifies the api-version to determine which Scheduled
         Events configuration schema version will be delivered.
        :paramtype scheduled_events_api_version: str
        """
        super().__init__(**kwargs)
        self.enable = enable
        self.scheduled_events_api_version = scheduled_events_api_version


class ExecutedValidation(_serialization.Model):
    """This is the executed Validation.

    :ivar type: This property specifies the type of image version validation.
    :vartype type: str
    :ivar status: This property specifies the status of the validationProfile of the image version.
     Known values are: "Unknown", "Failed", and "Succeeded".
    :vartype status: str or ~azure.mgmt.compute.models.ValidationStatus
    :ivar version: This property specifies the valid version of the validation.
    :vartype version: str
    :ivar execution_time: This property specifies the starting timestamp.
    :vartype execution_time: ~datetime.datetime
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "execution_time": {"key": "executionTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        type: Optional[str] = None,
        status: Optional[Union[str, "_models.ValidationStatus"]] = None,
        version: Optional[str] = None,
        execution_time: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: This property specifies the type of image version validation.
        :paramtype type: str
        :keyword status: This property specifies the status of the validationProfile of the image
         version. Known values are: "Unknown", "Failed", and "Succeeded".
        :paramtype status: str or ~azure.mgmt.compute.models.ValidationStatus
        :keyword version: This property specifies the valid version of the validation.
        :paramtype version: str
        :keyword execution_time: This property specifies the starting timestamp.
        :paramtype execution_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.type = type
        self.status = status
        self.version = version
        self.execution_time = execution_time


class ExtendedLocation(_serialization.Model):
    """The complex type of the extended location.

    :ivar name: The name of the extended location.
    :vartype name: str
    :ivar type: The type of the extended location. "EdgeZone"
    :vartype type: str or ~azure.mgmt.compute.models.ExtendedLocationTypes
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[Union[str, "_models.ExtendedLocationTypes"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the extended location.
        :paramtype name: str
        :keyword type: The type of the extended location. "EdgeZone"
        :paramtype type: str or ~azure.mgmt.compute.models.ExtendedLocationTypes
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type


class Extension(_serialization.Model):
    """Describes a cloud service Extension.

    :ivar name: The name of the extension.
    :vartype name: str
    :ivar properties: Extension Properties.
    :vartype properties: ~azure.mgmt.compute.models.CloudServiceExtensionProperties
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "properties": {"key": "properties", "type": "CloudServiceExtensionProperties"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        properties: Optional["_models.CloudServiceExtensionProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the extension.
        :paramtype name: str
        :keyword properties: Extension Properties.
        :paramtype properties: ~azure.mgmt.compute.models.CloudServiceExtensionProperties
        """
        super().__init__(**kwargs)
        self.name = name
        self.properties = properties


class Gallery(TrackedResource):
    """Specifies information about the Shared Image Gallery that you want to create or update.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.compute.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar identity: The identity of the gallery, if configured.
    :vartype identity: ~azure.mgmt.compute.models.GalleryIdentity
    :ivar description: The description of this Shared Image Gallery resource. This property is
     updatable.
    :vartype description: str
    :ivar identifier: Describes the gallery unique name.
    :vartype identifier: ~azure.mgmt.compute.models.GalleryIdentifier
    :ivar provisioning_state: The provisioning state, which only appears in the response. Known
     values are: "Creating", "Updating", "Failed", "Succeeded", "Deleting", and "Migrating".
    :vartype provisioning_state: str or ~azure.mgmt.compute.models.GalleryProvisioningState
    :ivar sharing_profile: Profile for gallery sharing to subscription or tenant.
    :vartype sharing_profile: ~azure.mgmt.compute.models.SharingProfile
    :ivar soft_delete_policy: Contains information about the soft deletion policy of the gallery.
    :vartype soft_delete_policy: ~azure.mgmt.compute.models.SoftDeletePolicy
    :ivar sharing_status: Sharing status of current gallery.
    :vartype sharing_status: ~azure.mgmt.compute.models.SharingStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "sharing_status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "identity": {"key": "identity", "type": "GalleryIdentity"},
        "description": {"key": "properties.description", "type": "str"},
        "identifier": {"key": "properties.identifier", "type": "GalleryIdentifier"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "sharing_profile": {"key": "properties.sharingProfile", "type": "SharingProfile"},
        "soft_delete_policy": {"key": "properties.softDeletePolicy", "type": "SoftDeletePolicy"},
        "sharing_status": {"key": "properties.sharingStatus", "type": "SharingStatus"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        identity: Optional["_models.GalleryIdentity"] = None,
        description: Optional[str] = None,
        identifier: Optional["_models.GalleryIdentifier"] = None,
        sharing_profile: Optional["_models.SharingProfile"] = None,
        soft_delete_policy: Optional["_models.SoftDeletePolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword identity: The identity of the gallery, if configured.
        :paramtype identity: ~azure.mgmt.compute.models.GalleryIdentity
        :keyword description: The description of this Shared Image Gallery resource. This property is
         updatable.
        :paramtype description: str
        :keyword identifier: Describes the gallery unique name.
        :paramtype identifier: ~azure.mgmt.compute.models.GalleryIdentifier
        :keyword sharing_profile: Profile for gallery sharing to subscription or tenant.
        :paramtype sharing_profile: ~azure.mgmt.compute.models.SharingProfile
        :keyword soft_delete_policy: Contains information about the soft deletion policy of the
         gallery.
        :paramtype soft_delete_policy: ~azure.mgmt.compute.models.SoftDeletePolicy
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.description = description
        self.identifier = identifier
        self.provisioning_state: Optional[Union[str, "_models.GalleryProvisioningState"]] = None
        self.sharing_profile = sharing_profile
        self.soft_delete_policy = soft_delete_policy
        self.sharing_status: Optional["_models.SharingStatus"] = None


class GalleryApplication(TrackedResource):
    """Specifies information about the gallery Application Definition that you want to create or
    update.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.compute.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar description: The description of this gallery Application Definition resource. This
     property is updatable.
    :vartype description: str
    :ivar eula: The Eula agreement for the gallery Application Definition.
    :vartype eula: str
    :ivar privacy_statement_uri: The privacy statement uri.
    :vartype privacy_statement_uri: str
    :ivar release_note_uri: The release note uri.
    :vartype release_note_uri: str
    :ivar end_of_life_date: The end of life date of the gallery Application Definition. This
     property can be used for decommissioning purposes. This property is updatable.
    :vartype end_of_life_date: ~datetime.datetime
    :ivar supported_os_type: This property allows you to specify the supported type of the OS that
     application is built for. Possible values are: **Windows,** **Linux.**. Known values are:
     "Windows" and "Linux".
    :vartype supported_os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
    :ivar custom_actions: A list of custom actions that can be performed with all of the Gallery
     Application Versions within this Gallery Application.
    :vartype custom_actions: list[~azure.mgmt.compute.models.GalleryApplicationCustomAction]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "eula": {"key": "properties.eula", "type": "str"},
        "privacy_statement_uri": {"key": "properties.privacyStatementUri", "type": "str"},
        "release_note_uri": {"key": "properties.releaseNoteUri", "type": "str"},
        "end_of_life_date": {"key": "properties.endOfLifeDate", "type": "iso-8601"},
        "supported_os_type": {"key": "properties.supportedOSType", "type": "str"},
        "custom_actions": {"key": "properties.customActions", "type": "[GalleryApplicationCustomAction]"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        description: Optional[str] = None,
        eula: Optional[str] = None,
        privacy_statement_uri: Optional[str] = None,
        release_note_uri: Optional[str] = None,
        end_of_life_date: Optional[datetime.datetime] = None,
        supported_os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None,
        custom_actions: Optional[list["_models.GalleryApplicationCustomAction"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword description: The description of this gallery Application Definition resource. This
         property is updatable.
        :paramtype description: str
        :keyword eula: The Eula agreement for the gallery Application Definition.
        :paramtype eula: str
        :keyword privacy_statement_uri: The privacy statement uri.
        :paramtype privacy_statement_uri: str
        :keyword release_note_uri: The release note uri.
        :paramtype release_note_uri: str
        :keyword end_of_life_date: The end of life date of the gallery Application Definition. This
         property can be used for decommissioning purposes. This property is updatable.
        :paramtype end_of_life_date: ~datetime.datetime
        :keyword supported_os_type: This property allows you to specify the supported type of the OS
         that application is built for. Possible values are: **Windows,** **Linux.**. Known values are:
         "Windows" and "Linux".
        :paramtype supported_os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
        :keyword custom_actions: A list of custom actions that can be performed with all of the Gallery
         Application Versions within this Gallery Application.
        :paramtype custom_actions: list[~azure.mgmt.compute.models.GalleryApplicationCustomAction]
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.description = description
        self.eula = eula
        self.privacy_statement_uri = privacy_statement_uri
        self.release_note_uri = release_note_uri
        self.end_of_life_date = end_of_life_date
        self.supported_os_type = supported_os_type
        self.custom_actions = custom_actions


class GalleryApplicationCustomAction(_serialization.Model):
    """A custom action that can be performed with a Gallery Application Version.

    All required parameters must be populated in order to send to server.

    :ivar name: The name of the custom action.  Must be unique within the Gallery Application
     Version. Required.
    :vartype name: str
    :ivar script: The script to run when executing this custom action. Required.
    :vartype script: str
    :ivar description: Description to help the users understand what this custom action does.
    :vartype description: str
    :ivar parameters: The parameters that this custom action uses.
    :vartype parameters: list[~azure.mgmt.compute.models.GalleryApplicationCustomActionParameter]
    """

    _validation = {
        "name": {"required": True},
        "script": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "script": {"key": "script", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "parameters": {"key": "parameters", "type": "[GalleryApplicationCustomActionParameter]"},
    }

    def __init__(
        self,
        *,
        name: str,
        script: str,
        description: Optional[str] = None,
        parameters: Optional[list["_models.GalleryApplicationCustomActionParameter"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the custom action.  Must be unique within the Gallery Application
         Version. Required.
        :paramtype name: str
        :keyword script: The script to run when executing this custom action. Required.
        :paramtype script: str
        :keyword description: Description to help the users understand what this custom action does.
        :paramtype description: str
        :keyword parameters: The parameters that this custom action uses.
        :paramtype parameters: list[~azure.mgmt.compute.models.GalleryApplicationCustomActionParameter]
        """
        super().__init__(**kwargs)
        self.name = name
        self.script = script
        self.description = description
        self.parameters = parameters


class GalleryApplicationCustomActionParameter(_serialization.Model):
    """The definition of a parameter that can be passed to a custom action of a Gallery Application
    Version.

    All required parameters must be populated in order to send to server.

    :ivar name: The name of the custom action.  Must be unique within the Gallery Application
     Version. Required.
    :vartype name: str
    :ivar required: Indicates whether this parameter must be passed when running the custom action.
    :vartype required: bool
    :ivar type: Specifies the type of the custom action parameter. Possible values are: String,
     ConfigurationDataBlob or LogOutputBlob. Known values are: "String", "ConfigurationDataBlob",
     and "LogOutputBlob".
    :vartype type: str or ~azure.mgmt.compute.models.GalleryApplicationCustomActionParameterType
    :ivar default_value: The default value of the parameter.  Only applies to string types.
    :vartype default_value: str
    :ivar description: A description to help users understand what this parameter means.
    :vartype description: str
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "required": {"key": "required", "type": "bool"},
        "type": {"key": "type", "type": "str"},
        "default_value": {"key": "defaultValue", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        required: Optional[bool] = None,
        type: Optional[Union[str, "_models.GalleryApplicationCustomActionParameterType"]] = None,
        default_value: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the custom action.  Must be unique within the Gallery Application
         Version. Required.
        :paramtype name: str
        :keyword required: Indicates whether this parameter must be passed when running the custom
         action.
        :paramtype required: bool
        :keyword type: Specifies the type of the custom action parameter. Possible values are: String,
         ConfigurationDataBlob or LogOutputBlob. Known values are: "String", "ConfigurationDataBlob",
         and "LogOutputBlob".
        :paramtype type: str or ~azure.mgmt.compute.models.GalleryApplicationCustomActionParameterType
        :keyword default_value: The default value of the parameter.  Only applies to string types.
        :paramtype default_value: str
        :keyword description: A description to help users understand what this parameter means.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.required = required
        self.type = type
        self.default_value = default_value
        self.description = description


class GalleryApplicationList(_serialization.Model):
    """The List Gallery Applications operation response.

    All required parameters must be populated in order to send to server.

    :ivar value: The GalleryApplication items on this page. Required.
    :vartype value: list[~azure.mgmt.compute.models.GalleryApplication]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[GalleryApplication]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: list["_models.GalleryApplication"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The GalleryApplication items on this page. Required.
        :paramtype value: list[~azure.mgmt.compute.models.GalleryApplication]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class UpdateResourceDefinition(_serialization.Model):
    """The Update Resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.tags = tags


class GalleryApplicationUpdate(UpdateResourceDefinition):
    """Specifies information about the gallery Application Definition that you want to update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar description: The description of this gallery Application Definition resource. This
     property is updatable.
    :vartype description: str
    :ivar eula: The Eula agreement for the gallery Application Definition.
    :vartype eula: str
    :ivar privacy_statement_uri: The privacy statement uri.
    :vartype privacy_statement_uri: str
    :ivar release_note_uri: The release note uri.
    :vartype release_note_uri: str
    :ivar end_of_life_date: The end of life date of the gallery Application Definition. This
     property can be used for decommissioning purposes. This property is updatable.
    :vartype end_of_life_date: ~datetime.datetime
    :ivar supported_os_type: This property allows you to specify the supported type of the OS that
     application is built for. Possible values are: **Windows,** **Linux.**. Known values are:
     "Windows" and "Linux".
    :vartype supported_os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
    :ivar custom_actions: A list of custom actions that can be performed with all of the Gallery
     Application Versions within this Gallery Application.
    :vartype custom_actions: list[~azure.mgmt.compute.models.GalleryApplicationCustomAction]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "description": {"key": "properties.description", "type": "str"},
        "eula": {"key": "properties.eula", "type": "str"},
        "privacy_statement_uri": {"key": "properties.privacyStatementUri", "type": "str"},
        "release_note_uri": {"key": "properties.releaseNoteUri", "type": "str"},
        "end_of_life_date": {"key": "properties.endOfLifeDate", "type": "iso-8601"},
        "supported_os_type": {"key": "properties.supportedOSType", "type": "str"},
        "custom_actions": {"key": "properties.customActions", "type": "[GalleryApplicationCustomAction]"},
    }

    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
        description: Optional[str] = None,
        eula: Optional[str] = None,
        privacy_statement_uri: Optional[str] = None,
        release_note_uri: Optional[str] = None,
        end_of_life_date: Optional[datetime.datetime] = None,
        supported_os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None,
        custom_actions: Optional[list["_models.GalleryApplicationCustomAction"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword description: The description of this gallery Application Definition resource. This
         property is updatable.
        :paramtype description: str
        :keyword eula: The Eula agreement for the gallery Application Definition.
        :paramtype eula: str
        :keyword privacy_statement_uri: The privacy statement uri.
        :paramtype privacy_statement_uri: str
        :keyword release_note_uri: The release note uri.
        :paramtype release_note_uri: str
        :keyword end_of_life_date: The end of life date of the gallery Application Definition. This
         property can be used for decommissioning purposes. This property is updatable.
        :paramtype end_of_life_date: ~datetime.datetime
        :keyword supported_os_type: This property allows you to specify the supported type of the OS
         that application is built for. Possible values are: **Windows,** **Linux.**. Known values are:
         "Windows" and "Linux".
        :paramtype supported_os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
        :keyword custom_actions: A list of custom actions that can be performed with all of the Gallery
         Application Versions within this Gallery Application.
        :paramtype custom_actions: list[~azure.mgmt.compute.models.GalleryApplicationCustomAction]
        """
        super().__init__(tags=tags, **kwargs)
        self.description = description
        self.eula = eula
        self.privacy_statement_uri = privacy_statement_uri
        self.release_note_uri = release_note_uri
        self.end_of_life_date = end_of_life_date
        self.supported_os_type = supported_os_type
        self.custom_actions = custom_actions


class GalleryApplicationVersion(TrackedResource):
    """Specifies information about the gallery Application Version that you want to create or update.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.compute.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar publishing_profile: The publishing profile of a gallery image version.
    :vartype publishing_profile:
     ~azure.mgmt.compute.models.GalleryApplicationVersionPublishingProfile
    :ivar safety_profile: The safety profile of the Gallery Application Version.
    :vartype safety_profile: ~azure.mgmt.compute.models.GalleryApplicationVersionSafetyProfile
    :ivar provisioning_state: The provisioning state, which only appears in the response. Known
     values are: "Creating", "Updating", "Failed", "Succeeded", "Deleting", and "Migrating".
    :vartype provisioning_state: str or ~azure.mgmt.compute.models.GalleryProvisioningState
    :ivar replication_status: This is the replication status of the gallery image version.
    :vartype replication_status: ~azure.mgmt.compute.models.ReplicationStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "replication_status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "publishing_profile": {
            "key": "properties.publishingProfile",
            "type": "GalleryApplicationVersionPublishingProfile",
        },
        "safety_profile": {"key": "properties.safetyProfile", "type": "GalleryApplicationVersionSafetyProfile"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "replication_status": {"key": "properties.replicationStatus", "type": "ReplicationStatus"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        publishing_profile: Optional["_models.GalleryApplicationVersionPublishingProfile"] = None,
        safety_profile: Optional["_models.GalleryApplicationVersionSafetyProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword publishing_profile: The publishing profile of a gallery image version.
        :paramtype publishing_profile:
         ~azure.mgmt.compute.models.GalleryApplicationVersionPublishingProfile
        :keyword safety_profile: The safety profile of the Gallery Application Version.
        :paramtype safety_profile: ~azure.mgmt.compute.models.GalleryApplicationVersionSafetyProfile
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.publishing_profile = publishing_profile
        self.safety_profile = safety_profile
        self.provisioning_state: Optional[Union[str, "_models.GalleryProvisioningState"]] = None
        self.replication_status: Optional["_models.ReplicationStatus"] = None


class GalleryApplicationVersionList(_serialization.Model):
    """The List Gallery Application version operation response.

    All required parameters must be populated in order to send to server.

    :ivar value: A list of gallery Application Versions. Required.
    :vartype value: list[~azure.mgmt.compute.models.GalleryApplicationVersion]
    :ivar next_link: The uri to fetch the next page of gallery Application Versions. Call
     ListNext() with this to fetch the next page of gallery Application Versions.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[GalleryApplicationVersion]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: list["_models.GalleryApplicationVersion"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of gallery Application Versions. Required.
        :paramtype value: list[~azure.mgmt.compute.models.GalleryApplicationVersion]
        :keyword next_link: The uri to fetch the next page of gallery Application Versions. Call
         ListNext() with this to fetch the next page of gallery Application Versions.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class GalleryArtifactPublishingProfileBase(_serialization.Model):
    """Describes the basic gallery artifact publishing profile.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar target_regions: The target regions where the Image Version is going to be replicated to.
     This property is updatable.
    :vartype target_regions: list[~azure.mgmt.compute.models.TargetRegion]
    :ivar replica_count: The number of replicas of the Image Version to be created per region. This
     property would take effect for a region when regionalReplicaCount is not specified. This
     property is updatable.
    :vartype replica_count: int
    :ivar exclude_from_latest: If set to true, Virtual Machines deployed from the latest version of
     the Image Definition won't use this Image Version.
    :vartype exclude_from_latest: bool
    :ivar published_date: The timestamp for when the gallery image version is published.
    :vartype published_date: ~datetime.datetime
    :ivar end_of_life_date: The end of life date of the gallery image version. This property can be
     used for decommissioning purposes. This property is updatable.
    :vartype end_of_life_date: ~datetime.datetime
    :ivar storage_account_type: Specifies the storage account type to be used to store the image.
     This property is not updatable. Known values are: "Standard_LRS", "Standard_ZRS",
     "Premium_LRS", and "PremiumV2_LRS".
    :vartype storage_account_type: str or ~azure.mgmt.compute.models.StorageAccountType
    :ivar replication_mode: Optional parameter which specifies the mode to be used for replication.
     This property is not updatable. Known values are: "Full" and "Shallow".
    :vartype replication_mode: str or ~azure.mgmt.compute.models.ReplicationMode
    :ivar target_extended_locations: The target extended locations where the Image Version is going
     to be replicated to. This property is updatable.
    :vartype target_extended_locations:
     list[~azure.mgmt.compute.models.GalleryTargetExtendedLocation]
    """

    _validation = {
        "published_date": {"readonly": True},
    }

    _attribute_map = {
        "target_regions": {"key": "targetRegions", "type": "[TargetRegion]"},
        "replica_count": {"key": "replicaCount", "type": "int"},
        "exclude_from_latest": {"key": "excludeFromLatest", "type": "bool"},
        "published_date": {"key": "publishedDate", "type": "iso-8601"},
        "end_of_life_date": {"key": "endOfLifeDate", "type": "iso-8601"},
        "storage_account_type": {"key": "storageAccountType", "type": "str"},
        "replication_mode": {"key": "replicationMode", "type": "str"},
        "target_extended_locations": {"key": "targetExtendedLocations", "type": "[GalleryTargetExtendedLocation]"},
    }

    def __init__(
        self,
        *,
        target_regions: Optional[list["_models.TargetRegion"]] = None,
        replica_count: Optional[int] = None,
        exclude_from_latest: Optional[bool] = None,
        end_of_life_date: Optional[datetime.datetime] = None,
        storage_account_type: Optional[Union[str, "_models.StorageAccountType"]] = None,
        replication_mode: Optional[Union[str, "_models.ReplicationMode"]] = None,
        target_extended_locations: Optional[list["_models.GalleryTargetExtendedLocation"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword target_regions: The target regions where the Image Version is going to be replicated
         to. This property is updatable.
        :paramtype target_regions: list[~azure.mgmt.compute.models.TargetRegion]
        :keyword replica_count: The number of replicas of the Image Version to be created per region.
         This property would take effect for a region when regionalReplicaCount is not specified. This
         property is updatable.
        :paramtype replica_count: int
        :keyword exclude_from_latest: If set to true, Virtual Machines deployed from the latest version
         of the Image Definition won't use this Image Version.
        :paramtype exclude_from_latest: bool
        :keyword end_of_life_date: The end of life date of the gallery image version. This property can
         be used for decommissioning purposes. This property is updatable.
        :paramtype end_of_life_date: ~datetime.datetime
        :keyword storage_account_type: Specifies the storage account type to be used to store the
         image. This property is not updatable. Known values are: "Standard_LRS", "Standard_ZRS",
         "Premium_LRS", and "PremiumV2_LRS".
        :paramtype storage_account_type: str or ~azure.mgmt.compute.models.StorageAccountType
        :keyword replication_mode: Optional parameter which specifies the mode to be used for
         replication. This property is not updatable. Known values are: "Full" and "Shallow".
        :paramtype replication_mode: str or ~azure.mgmt.compute.models.ReplicationMode
        :keyword target_extended_locations: The target extended locations where the Image Version is
         going to be replicated to. This property is updatable.
        :paramtype target_extended_locations:
         list[~azure.mgmt.compute.models.GalleryTargetExtendedLocation]
        """
        super().__init__(**kwargs)
        self.target_regions = target_regions
        self.replica_count = replica_count
        self.exclude_from_latest = exclude_from_latest
        self.published_date: Optional[datetime.datetime] = None
        self.end_of_life_date = end_of_life_date
        self.storage_account_type = storage_account_type
        self.replication_mode = replication_mode
        self.target_extended_locations = target_extended_locations


class GalleryApplicationVersionPublishingProfile(GalleryArtifactPublishingProfileBase):  # pylint: disable=name-too-long
    """The publishing profile of a gallery image version.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar target_regions: The target regions where the Image Version is going to be replicated to.
     This property is updatable.
    :vartype target_regions: list[~azure.mgmt.compute.models.TargetRegion]
    :ivar replica_count: The number of replicas of the Image Version to be created per region. This
     property would take effect for a region when regionalReplicaCount is not specified. This
     property is updatable.
    :vartype replica_count: int
    :ivar exclude_from_latest: If set to true, Virtual Machines deployed from the latest version of
     the Image Definition won't use this Image Version.
    :vartype exclude_from_latest: bool
    :ivar published_date: The timestamp for when the gallery image version is published.
    :vartype published_date: ~datetime.datetime
    :ivar end_of_life_date: The end of life date of the gallery image version. This property can be
     used for decommissioning purposes. This property is updatable.
    :vartype end_of_life_date: ~datetime.datetime
    :ivar storage_account_type: Specifies the storage account type to be used to store the image.
     This property is not updatable. Known values are: "Standard_LRS", "Standard_ZRS",
     "Premium_LRS", and "PremiumV2_LRS".
    :vartype storage_account_type: str or ~azure.mgmt.compute.models.StorageAccountType
    :ivar replication_mode: Optional parameter which specifies the mode to be used for replication.
     This property is not updatable. Known values are: "Full" and "Shallow".
    :vartype replication_mode: str or ~azure.mgmt.compute.models.ReplicationMode
    :ivar target_extended_locations: The target extended locations where the Image Version is going
     to be replicated to. This property is updatable.
    :vartype target_extended_locations:
     list[~azure.mgmt.compute.models.GalleryTargetExtendedLocation]
    :ivar source: The source image from which the Image Version is going to be created. Required.
    :vartype source: ~azure.mgmt.compute.models.UserArtifactSource
    :ivar manage_actions:
    :vartype manage_actions: ~azure.mgmt.compute.models.UserArtifactManage
    :ivar settings: Additional settings for the VM app that contains the target package and config
     file name when it is deployed to target VM or VM scale set.
    :vartype settings: ~azure.mgmt.compute.models.UserArtifactSettings
    :ivar advanced_settings: Optional. Additional settings to pass to the vm-application-manager
     extension. For advanced use only.
    :vartype advanced_settings: dict[str, str]
    :ivar enable_health_check: Optional. Whether or not this application reports health.
    :vartype enable_health_check: bool
    :ivar custom_actions: A list of custom actions that can be performed with this Gallery
     Application Version.
    :vartype custom_actions: list[~azure.mgmt.compute.models.GalleryApplicationCustomAction]
    """

    _validation = {
        "published_date": {"readonly": True},
        "source": {"required": True},
    }

    _attribute_map = {
        "target_regions": {"key": "targetRegions", "type": "[TargetRegion]"},
        "replica_count": {"key": "replicaCount", "type": "int"},
        "exclude_from_latest": {"key": "excludeFromLatest", "type": "bool"},
        "published_date": {"key": "publishedDate", "type": "iso-8601"},
        "end_of_life_date": {"key": "endOfLifeDate", "type": "iso-8601"},
        "storage_account_type": {"key": "storageAccountType", "type": "str"},
        "replication_mode": {"key": "replicationMode", "type": "str"},
        "target_extended_locations": {"key": "targetExtendedLocations", "type": "[GalleryTargetExtendedLocation]"},
        "source": {"key": "source", "type": "UserArtifactSource"},
        "manage_actions": {"key": "manageActions", "type": "UserArtifactManage"},
        "settings": {"key": "settings", "type": "UserArtifactSettings"},
        "advanced_settings": {"key": "advancedSettings", "type": "{str}"},
        "enable_health_check": {"key": "enableHealthCheck", "type": "bool"},
        "custom_actions": {"key": "customActions", "type": "[GalleryApplicationCustomAction]"},
    }

    def __init__(
        self,
        *,
        source: "_models.UserArtifactSource",
        target_regions: Optional[list["_models.TargetRegion"]] = None,
        replica_count: Optional[int] = None,
        exclude_from_latest: Optional[bool] = None,
        end_of_life_date: Optional[datetime.datetime] = None,
        storage_account_type: Optional[Union[str, "_models.StorageAccountType"]] = None,
        replication_mode: Optional[Union[str, "_models.ReplicationMode"]] = None,
        target_extended_locations: Optional[list["_models.GalleryTargetExtendedLocation"]] = None,
        manage_actions: Optional["_models.UserArtifactManage"] = None,
        settings: Optional["_models.UserArtifactSettings"] = None,
        advanced_settings: Optional[dict[str, str]] = None,
        enable_health_check: Optional[bool] = None,
        custom_actions: Optional[list["_models.GalleryApplicationCustomAction"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword target_regions: The target regions where the Image Version is going to be replicated
         to. This property is updatable.
        :paramtype target_regions: list[~azure.mgmt.compute.models.TargetRegion]
        :keyword replica_count: The number of replicas of the Image Version to be created per region.
         This property would take effect for a region when regionalReplicaCount is not specified. This
         property is updatable.
        :paramtype replica_count: int
        :keyword exclude_from_latest: If set to true, Virtual Machines deployed from the latest version
         of the Image Definition won't use this Image Version.
        :paramtype exclude_from_latest: bool
        :keyword end_of_life_date: The end of life date of the gallery image version. This property can
         be used for decommissioning purposes. This property is updatable.
        :paramtype end_of_life_date: ~datetime.datetime
        :keyword storage_account_type: Specifies the storage account type to be used to store the
         image. This property is not updatable. Known values are: "Standard_LRS", "Standard_ZRS",
         "Premium_LRS", and "PremiumV2_LRS".
        :paramtype storage_account_type: str or ~azure.mgmt.compute.models.StorageAccountType
        :keyword replication_mode: Optional parameter which specifies the mode to be used for
         replication. This property is not updatable. Known values are: "Full" and "Shallow".
        :paramtype replication_mode: str or ~azure.mgmt.compute.models.ReplicationMode
        :keyword target_extended_locations: The target extended locations where the Image Version is
         going to be replicated to. This property is updatable.
        :paramtype target_extended_locations:
         list[~azure.mgmt.compute.models.GalleryTargetExtendedLocation]
        :keyword source: The source image from which the Image Version is going to be created.
         Required.
        :paramtype source: ~azure.mgmt.compute.models.UserArtifactSource
        :keyword manage_actions:
        :paramtype manage_actions: ~azure.mgmt.compute.models.UserArtifactManage
        :keyword settings: Additional settings for the VM app that contains the target package and
         config file name when it is deployed to target VM or VM scale set.
        :paramtype settings: ~azure.mgmt.compute.models.UserArtifactSettings
        :keyword advanced_settings: Optional. Additional settings to pass to the vm-application-manager
         extension. For advanced use only.
        :paramtype advanced_settings: dict[str, str]
        :keyword enable_health_check: Optional. Whether or not this application reports health.
        :paramtype enable_health_check: bool
        :keyword custom_actions: A list of custom actions that can be performed with this Gallery
         Application Version.
        :paramtype custom_actions: list[~azure.mgmt.compute.models.GalleryApplicationCustomAction]
        """
        super().__init__(
            target_regions=target_regions,
            replica_count=replica_count,
            exclude_from_latest=exclude_from_latest,
            end_of_life_date=end_of_life_date,
            storage_account_type=storage_account_type,
            replication_mode=replication_mode,
            target_extended_locations=target_extended_locations,
            **kwargs
        )
        self.source = source
        self.manage_actions = manage_actions
        self.settings = settings
        self.advanced_settings = advanced_settings
        self.enable_health_check = enable_health_check
        self.custom_actions = custom_actions


class GalleryArtifactSafetyProfileBase(_serialization.Model):
    """This is the safety profile of the Gallery Artifact Version.

    :ivar allow_deletion_of_replicated_locations: Indicates whether or not removing this Gallery
     Image Version from replicated regions is allowed.
    :vartype allow_deletion_of_replicated_locations: bool
    """

    _attribute_map = {
        "allow_deletion_of_replicated_locations": {"key": "allowDeletionOfReplicatedLocations", "type": "bool"},
    }

    def __init__(self, *, allow_deletion_of_replicated_locations: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword allow_deletion_of_replicated_locations: Indicates whether or not removing this Gallery
         Image Version from replicated regions is allowed.
        :paramtype allow_deletion_of_replicated_locations: bool
        """
        super().__init__(**kwargs)
        self.allow_deletion_of_replicated_locations = allow_deletion_of_replicated_locations


class GalleryApplicationVersionSafetyProfile(GalleryArtifactSafetyProfileBase):
    """The safety profile of the Gallery Application Version.

    :ivar allow_deletion_of_replicated_locations: Indicates whether or not removing this Gallery
     Image Version from replicated regions is allowed.
    :vartype allow_deletion_of_replicated_locations: bool
    """


class GalleryApplicationVersionUpdate(UpdateResourceDefinition):
    """Specifies information about the gallery Application Version that you want to update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar publishing_profile: The publishing profile of a gallery image version.
    :vartype publishing_profile:
     ~azure.mgmt.compute.models.GalleryApplicationVersionPublishingProfile
    :ivar safety_profile: The safety profile of the Gallery Application Version.
    :vartype safety_profile: ~azure.mgmt.compute.models.GalleryApplicationVersionSafetyProfile
    :ivar provisioning_state: The provisioning state, which only appears in the response. Known
     values are: "Creating", "Updating", "Failed", "Succeeded", "Deleting", and "Migrating".
    :vartype provisioning_state: str or ~azure.mgmt.compute.models.GalleryProvisioningState
    :ivar replication_status: This is the replication status of the gallery image version.
    :vartype replication_status: ~azure.mgmt.compute.models.ReplicationStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "replication_status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "publishing_profile": {
            "key": "properties.publishingProfile",
            "type": "GalleryApplicationVersionPublishingProfile",
        },
        "safety_profile": {"key": "properties.safetyProfile", "type": "GalleryApplicationVersionSafetyProfile"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "replication_status": {"key": "properties.replicationStatus", "type": "ReplicationStatus"},
    }

    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
        publishing_profile: Optional["_models.GalleryApplicationVersionPublishingProfile"] = None,
        safety_profile: Optional["_models.GalleryApplicationVersionSafetyProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword publishing_profile: The publishing profile of a gallery image version.
        :paramtype publishing_profile:
         ~azure.mgmt.compute.models.GalleryApplicationVersionPublishingProfile
        :keyword safety_profile: The safety profile of the Gallery Application Version.
        :paramtype safety_profile: ~azure.mgmt.compute.models.GalleryApplicationVersionSafetyProfile
        """
        super().__init__(tags=tags, **kwargs)
        self.publishing_profile = publishing_profile
        self.safety_profile = safety_profile
        self.provisioning_state: Optional[Union[str, "_models.GalleryProvisioningState"]] = None
        self.replication_status: Optional["_models.ReplicationStatus"] = None


class GalleryArtifactVersionSource(_serialization.Model):
    """The gallery artifact version source.

    :ivar id: The id of the gallery artifact version source.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: The id of the gallery artifact version source.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class GalleryArtifactVersionFullSource(GalleryArtifactVersionSource):
    """The source of the gallery artifact version.

    :ivar id: The id of the gallery artifact version source.
    :vartype id: str
    :ivar community_gallery_image_id: The resource Id of the source Community Gallery Image.  Only
     required when using Community Gallery Image as a source.
    :vartype community_gallery_image_id: str
    :ivar virtual_machine_id: The resource Id of the source virtual machine.  Only required when
     capturing a virtual machine to source this Gallery Image Version.
    :vartype virtual_machine_id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "community_gallery_image_id": {"key": "communityGalleryImageId", "type": "str"},
        "virtual_machine_id": {"key": "virtualMachineId", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        community_gallery_image_id: Optional[str] = None,
        virtual_machine_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The id of the gallery artifact version source.
        :paramtype id: str
        :keyword community_gallery_image_id: The resource Id of the source Community Gallery Image.
         Only required when using Community Gallery Image as a source.
        :paramtype community_gallery_image_id: str
        :keyword virtual_machine_id: The resource Id of the source virtual machine.  Only required when
         capturing a virtual machine to source this Gallery Image Version.
        :paramtype virtual_machine_id: str
        """
        super().__init__(id=id, **kwargs)
        self.community_gallery_image_id = community_gallery_image_id
        self.virtual_machine_id = virtual_machine_id


class GalleryDiskImage(_serialization.Model):
    """This is the disk image base class.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar size_in_gb: This property indicates the size of the VHD to be created.
    :vartype size_in_gb: int
    :ivar host_caching: The host caching of the disk. Valid values are 'None', 'ReadOnly', and
     'ReadWrite'. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype host_caching: str or ~azure.mgmt.compute.models.HostCaching
    :ivar source: The source for the disk image.
    :vartype source: ~azure.mgmt.compute.models.GalleryDiskImageSource
    """

    _validation = {
        "size_in_gb": {"readonly": True},
    }

    _attribute_map = {
        "size_in_gb": {"key": "sizeInGB", "type": "int"},
        "host_caching": {"key": "hostCaching", "type": "str"},
        "source": {"key": "source", "type": "GalleryDiskImageSource"},
    }

    def __init__(
        self,
        *,
        host_caching: Optional[Union[str, "_models.HostCaching"]] = None,
        source: Optional["_models.GalleryDiskImageSource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword host_caching: The host caching of the disk. Valid values are 'None', 'ReadOnly', and
         'ReadWrite'. Known values are: "None", "ReadOnly", and "ReadWrite".
        :paramtype host_caching: str or ~azure.mgmt.compute.models.HostCaching
        :keyword source: The source for the disk image.
        :paramtype source: ~azure.mgmt.compute.models.GalleryDiskImageSource
        """
        super().__init__(**kwargs)
        self.size_in_gb: Optional[int] = None
        self.host_caching = host_caching
        self.source = source


class GalleryDataDiskImage(GalleryDiskImage):
    """This is the data disk image.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar size_in_gb: This property indicates the size of the VHD to be created.
    :vartype size_in_gb: int
    :ivar host_caching: The host caching of the disk. Valid values are 'None', 'ReadOnly', and
     'ReadWrite'. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype host_caching: str or ~azure.mgmt.compute.models.HostCaching
    :ivar source: The source for the disk image.
    :vartype source: ~azure.mgmt.compute.models.GalleryDiskImageSource
    :ivar lun: This property specifies the logical unit number of the data disk. This value is used
     to identify data disks within the Virtual Machine and therefore must be unique for each data
     disk attached to the Virtual Machine. Required.
    :vartype lun: int
    """

    _validation = {
        "size_in_gb": {"readonly": True},
        "lun": {"required": True},
    }

    _attribute_map = {
        "size_in_gb": {"key": "sizeInGB", "type": "int"},
        "host_caching": {"key": "hostCaching", "type": "str"},
        "source": {"key": "source", "type": "GalleryDiskImageSource"},
        "lun": {"key": "lun", "type": "int"},
    }

    def __init__(
        self,
        *,
        lun: int,
        host_caching: Optional[Union[str, "_models.HostCaching"]] = None,
        source: Optional["_models.GalleryDiskImageSource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword host_caching: The host caching of the disk. Valid values are 'None', 'ReadOnly', and
         'ReadWrite'. Known values are: "None", "ReadOnly", and "ReadWrite".
        :paramtype host_caching: str or ~azure.mgmt.compute.models.HostCaching
        :keyword source: The source for the disk image.
        :paramtype source: ~azure.mgmt.compute.models.GalleryDiskImageSource
        :keyword lun: This property specifies the logical unit number of the data disk. This value is
         used to identify data disks within the Virtual Machine and therefore must be unique for each
         data disk attached to the Virtual Machine. Required.
        :paramtype lun: int
        """
        super().__init__(host_caching=host_caching, source=source, **kwargs)
        self.lun = lun


class GalleryDiskImageSource(GalleryArtifactVersionSource):
    """The source for the disk image.

    :ivar id: The id of the gallery artifact version source.
    :vartype id: str
    :ivar uri: The uri of the gallery artifact version source. Currently used to specify vhd/blob
     source.
    :vartype uri: str
    :ivar storage_account_id: The Storage Account Id that contains the vhd blob being used as a
     source for this artifact version.
    :vartype storage_account_id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "uri": {"key": "uri", "type": "str"},
        "storage_account_id": {"key": "storageAccountId", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        uri: Optional[str] = None,
        storage_account_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The id of the gallery artifact version source.
        :paramtype id: str
        :keyword uri: The uri of the gallery artifact version source. Currently used to specify
         vhd/blob source.
        :paramtype uri: str
        :keyword storage_account_id: The Storage Account Id that contains the vhd blob being used as a
         source for this artifact version.
        :paramtype storage_account_id: str
        """
        super().__init__(id=id, **kwargs)
        self.uri = uri
        self.storage_account_id = storage_account_id


class GalleryExtendedLocation(_serialization.Model):
    """The name of the extended location.

    :ivar name:
    :vartype name: str
    :ivar type: It is type of the extended location. Known values are: "EdgeZone" and "Unknown".
    :vartype type: str or ~azure.mgmt.compute.models.GalleryExtendedLocationType
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[Union[str, "_models.GalleryExtendedLocationType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name:
        :paramtype name: str
        :keyword type: It is type of the extended location. Known values are: "EdgeZone" and "Unknown".
        :paramtype type: str or ~azure.mgmt.compute.models.GalleryExtendedLocationType
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type


class GalleryIdentifier(_serialization.Model):
    """Describes the gallery unique name.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar unique_name: The unique name of the Shared Image Gallery. This name is generated
     automatically by Azure.
    :vartype unique_name: str
    """

    _validation = {
        "unique_name": {"readonly": True},
    }

    _attribute_map = {
        "unique_name": {"key": "uniqueName", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.unique_name: Optional[str] = None


class GalleryIdentity(_serialization.Model):
    """Identity for the virtual machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of the gallery identity. This property will only be
     provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The AAD tenant id of the gallery identity. This property will only be provided
     for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: The type of identity used for the gallery. The type 'SystemAssigned, UserAssigned'
     includes both an implicitly created identity and a set of user assigned identities. The type
     'None' will remove all identities from the gallery. Known values are: "SystemAssigned",
     "UserAssigned", "SystemAssigned, UserAssigned", and "None".
    :vartype type: str or ~azure.mgmt.compute.models.ResourceIdentityType
    :ivar user_assigned_identities: The list of user identities associated with the gallery. The
     user identity dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.compute.models.UserAssignedIdentitiesValue]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedIdentitiesValue}"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ResourceIdentityType"]] = None,
        user_assigned_identities: Optional[dict[str, "_models.UserAssignedIdentitiesValue"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The type of identity used for the gallery. The type 'SystemAssigned,
         UserAssigned' includes both an implicitly created identity and a set of user assigned
         identities. The type 'None' will remove all identities from the gallery. Known values are:
         "SystemAssigned", "UserAssigned", "SystemAssigned, UserAssigned", and "None".
        :paramtype type: str or ~azure.mgmt.compute.models.ResourceIdentityType
        :keyword user_assigned_identities: The list of user identities associated with the gallery. The
         user identity dictionary key references will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.compute.models.UserAssignedIdentitiesValue]
        """
        super().__init__(**kwargs)
        self.principal_id: Optional[str] = None
        self.tenant_id: Optional[str] = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class GalleryImage(TrackedResource):
    """Specifies information about the gallery image definition that you want to create or update.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.compute.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar description: The description of this gallery image definition resource. This property is
     updatable.
    :vartype description: str
    :ivar eula: The Eula agreement for the gallery image definition.
    :vartype eula: str
    :ivar privacy_statement_uri: The privacy statement uri.
    :vartype privacy_statement_uri: str
    :ivar release_note_uri: The release note uri.
    :vartype release_note_uri: str
    :ivar os_type: This property allows you to specify the type of the OS that is included in the
     disk when creating a VM from a managed image. Possible values are: **Windows,** **Linux.**.
     Known values are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
    :ivar os_state: This property allows the user to specify whether the virtual machines created
     under this image are 'Generalized' or 'Specialized'. Known values are: "Generalized" and
     "Specialized".
    :vartype os_state: str or ~azure.mgmt.compute.models.OperatingSystemStateTypes
    :ivar hyper_v_generation: The hypervisor generation of the Virtual Machine. Applicable to OS
     disks only. Known values are: "V1" and "V2".
    :vartype hyper_v_generation: str or ~azure.mgmt.compute.models.HyperVGeneration
    :ivar end_of_life_date: The end of life date of the gallery image definition. This property can
     be used for decommissioning purposes. This property is updatable.
    :vartype end_of_life_date: ~datetime.datetime
    :ivar identifier: This is the gallery image definition identifier.
    :vartype identifier: ~azure.mgmt.compute.models.GalleryImageIdentifier
    :ivar recommended: The properties describe the recommended machine configuration for this Image
     Definition. These properties are updatable.
    :vartype recommended: ~azure.mgmt.compute.models.RecommendedMachineConfiguration
    :ivar disallowed: Describes the disallowed disk types.
    :vartype disallowed: ~azure.mgmt.compute.models.Disallowed
    :ivar purchase_plan: Describes the gallery image definition purchase plan. This is used by
     marketplace images.
    :vartype purchase_plan: ~azure.mgmt.compute.models.ImagePurchasePlan
    :ivar provisioning_state: The provisioning state, which only appears in the response. Known
     values are: "Creating", "Updating", "Failed", "Succeeded", "Deleting", and "Migrating".
    :vartype provisioning_state: str or ~azure.mgmt.compute.models.GalleryProvisioningState
    :ivar features: A list of gallery image features.
    :vartype features: list[~azure.mgmt.compute.models.GalleryImageFeature]
    :ivar architecture: The architecture of the image. Applicable to OS disks only. Known values
     are: "x64" and "Arm64".
    :vartype architecture: str or ~azure.mgmt.compute.models.Architecture
    :ivar allow_update_image: Optional. Must be set to true if the gallery image features are being
     updated.
    :vartype allow_update_image: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "eula": {"key": "properties.eula", "type": "str"},
        "privacy_statement_uri": {"key": "properties.privacyStatementUri", "type": "str"},
        "release_note_uri": {"key": "properties.releaseNoteUri", "type": "str"},
        "os_type": {"key": "properties.osType", "type": "str"},
        "os_state": {"key": "properties.osState", "type": "str"},
        "hyper_v_generation": {"key": "properties.hyperVGeneration", "type": "str"},
        "end_of_life_date": {"key": "properties.endOfLifeDate", "type": "iso-8601"},
        "identifier": {"key": "properties.identifier", "type": "GalleryImageIdentifier"},
        "recommended": {"key": "properties.recommended", "type": "RecommendedMachineConfiguration"},
        "disallowed": {"key": "properties.disallowed", "type": "Disallowed"},
        "purchase_plan": {"key": "properties.purchasePlan", "type": "ImagePurchasePlan"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "features": {"key": "properties.features", "type": "[GalleryImageFeature]"},
        "architecture": {"key": "properties.architecture", "type": "str"},
        "allow_update_image": {"key": "properties.allowUpdateImage", "type": "bool"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        description: Optional[str] = None,
        eula: Optional[str] = None,
        privacy_statement_uri: Optional[str] = None,
        release_note_uri: Optional[str] = None,
        os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None,
        os_state: Optional[Union[str, "_models.OperatingSystemStateTypes"]] = None,
        hyper_v_generation: Optional[Union[str, "_models.HyperVGeneration"]] = None,
        end_of_life_date: Optional[datetime.datetime] = None,
        identifier: Optional["_models.GalleryImageIdentifier"] = None,
        recommended: Optional["_models.RecommendedMachineConfiguration"] = None,
        disallowed: Optional["_models.Disallowed"] = None,
        purchase_plan: Optional["_models.ImagePurchasePlan"] = None,
        features: Optional[list["_models.GalleryImageFeature"]] = None,
        architecture: Optional[Union[str, "_models.Architecture"]] = None,
        allow_update_image: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword description: The description of this gallery image definition resource. This property
         is updatable.
        :paramtype description: str
        :keyword eula: The Eula agreement for the gallery image definition.
        :paramtype eula: str
        :keyword privacy_statement_uri: The privacy statement uri.
        :paramtype privacy_statement_uri: str
        :keyword release_note_uri: The release note uri.
        :paramtype release_note_uri: str
        :keyword os_type: This property allows you to specify the type of the OS that is included in
         the disk when creating a VM from a managed image. Possible values are: **Windows,** **Linux.**.
         Known values are: "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
        :keyword os_state: This property allows the user to specify whether the virtual machines
         created under this image are 'Generalized' or 'Specialized'. Known values are: "Generalized"
         and "Specialized".
        :paramtype os_state: str or ~azure.mgmt.compute.models.OperatingSystemStateTypes
        :keyword hyper_v_generation: The hypervisor generation of the Virtual Machine. Applicable to OS
         disks only. Known values are: "V1" and "V2".
        :paramtype hyper_v_generation: str or ~azure.mgmt.compute.models.HyperVGeneration
        :keyword end_of_life_date: The end of life date of the gallery image definition. This property
         can be used for decommissioning purposes. This property is updatable.
        :paramtype end_of_life_date: ~datetime.datetime
        :keyword identifier: This is the gallery image definition identifier.
        :paramtype identifier: ~azure.mgmt.compute.models.GalleryImageIdentifier
        :keyword recommended: The properties describe the recommended machine configuration for this
         Image Definition. These properties are updatable.
        :paramtype recommended: ~azure.mgmt.compute.models.RecommendedMachineConfiguration
        :keyword disallowed: Describes the disallowed disk types.
        :paramtype disallowed: ~azure.mgmt.compute.models.Disallowed
        :keyword purchase_plan: Describes the gallery image definition purchase plan. This is used by
         marketplace images.
        :paramtype purchase_plan: ~azure.mgmt.compute.models.ImagePurchasePlan
        :keyword features: A list of gallery image features.
        :paramtype features: list[~azure.mgmt.compute.models.GalleryImageFeature]
        :keyword architecture: The architecture of the image. Applicable to OS disks only. Known values
         are: "x64" and "Arm64".
        :paramtype architecture: str or ~azure.mgmt.compute.models.Architecture
        :keyword allow_update_image: Optional. Must be set to true if the gallery image features are
         being updated.
        :paramtype allow_update_image: bool
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.description = description
        self.eula = eula
        self.privacy_statement_uri = privacy_statement_uri
        self.release_note_uri = release_note_uri
        self.os_type = os_type
        self.os_state = os_state
        self.hyper_v_generation = hyper_v_generation
        self.end_of_life_date = end_of_life_date
        self.identifier = identifier
        self.recommended = recommended
        self.disallowed = disallowed
        self.purchase_plan = purchase_plan
        self.provisioning_state: Optional[Union[str, "_models.GalleryProvisioningState"]] = None
        self.features = features
        self.architecture = architecture
        self.allow_update_image = allow_update_image


class GalleryImageFeature(_serialization.Model):
    """A feature for gallery image.

    :ivar name: The name of the gallery image feature.
    :vartype name: str
    :ivar value: The value of the gallery image feature.
    :vartype value: str
    :ivar starts_at_version: The minimum gallery image version which supports this feature.
    :vartype starts_at_version: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "starts_at_version": {"key": "startsAtVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
        starts_at_version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the gallery image feature.
        :paramtype name: str
        :keyword value: The value of the gallery image feature.
        :paramtype value: str
        :keyword starts_at_version: The minimum gallery image version which supports this feature.
        :paramtype starts_at_version: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value
        self.starts_at_version = starts_at_version


class GalleryImageIdentifier(_serialization.Model):
    """This is the gallery image definition identifier.

    All required parameters must be populated in order to send to server.

    :ivar publisher: The name of the gallery image definition publisher. Required.
    :vartype publisher: str
    :ivar offer: The name of the gallery image definition offer. Required.
    :vartype offer: str
    :ivar sku: The name of the gallery image definition SKU. Required.
    :vartype sku: str
    """

    _validation = {
        "publisher": {"required": True},
        "offer": {"required": True},
        "sku": {"required": True},
    }

    _attribute_map = {
        "publisher": {"key": "publisher", "type": "str"},
        "offer": {"key": "offer", "type": "str"},
        "sku": {"key": "sku", "type": "str"},
    }

    def __init__(self, *, publisher: str, offer: str, sku: str, **kwargs: Any) -> None:
        """
        :keyword publisher: The name of the gallery image definition publisher. Required.
        :paramtype publisher: str
        :keyword offer: The name of the gallery image definition offer. Required.
        :paramtype offer: str
        :keyword sku: The name of the gallery image definition SKU. Required.
        :paramtype sku: str
        """
        super().__init__(**kwargs)
        self.publisher = publisher
        self.offer = offer
        self.sku = sku


class GalleryImageList(_serialization.Model):
    """The List Gallery Images operation response.

    All required parameters must be populated in order to send to server.

    :ivar value: A list of Shared Image Gallery images. Required.
    :vartype value: list[~azure.mgmt.compute.models.GalleryImage]
    :ivar next_link: The uri to fetch the next page of Image Definitions in the Shared Image
     Gallery. Call ListNext() with this to fetch the next page of gallery image definitions.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[GalleryImage]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: list["_models.GalleryImage"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of Shared Image Gallery images. Required.
        :paramtype value: list[~azure.mgmt.compute.models.GalleryImage]
        :keyword next_link: The uri to fetch the next page of Image Definitions in the Shared Image
         Gallery. Call ListNext() with this to fetch the next page of gallery image definitions.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class GalleryImageUpdate(UpdateResourceDefinition):
    """Specifies information about the gallery image definition that you want to update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar description: The description of this gallery image definition resource. This property is
     updatable.
    :vartype description: str
    :ivar eula: The Eula agreement for the gallery image definition.
    :vartype eula: str
    :ivar privacy_statement_uri: The privacy statement uri.
    :vartype privacy_statement_uri: str
    :ivar release_note_uri: The release note uri.
    :vartype release_note_uri: str
    :ivar os_type: This property allows you to specify the type of the OS that is included in the
     disk when creating a VM from a managed image. Possible values are: **Windows,** **Linux.**.
     Known values are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
    :ivar os_state: This property allows the user to specify whether the virtual machines created
     under this image are 'Generalized' or 'Specialized'. Known values are: "Generalized" and
     "Specialized".
    :vartype os_state: str or ~azure.mgmt.compute.models.OperatingSystemStateTypes
    :ivar hyper_v_generation: The hypervisor generation of the Virtual Machine. Applicable to OS
     disks only. Known values are: "V1" and "V2".
    :vartype hyper_v_generation: str or ~azure.mgmt.compute.models.HyperVGeneration
    :ivar end_of_life_date: The end of life date of the gallery image definition. This property can
     be used for decommissioning purposes. This property is updatable.
    :vartype end_of_life_date: ~datetime.datetime
    :ivar identifier: This is the gallery image definition identifier.
    :vartype identifier: ~azure.mgmt.compute.models.GalleryImageIdentifier
    :ivar recommended: The properties describe the recommended machine configuration for this Image
     Definition. These properties are updatable.
    :vartype recommended: ~azure.mgmt.compute.models.RecommendedMachineConfiguration
    :ivar disallowed: Describes the disallowed disk types.
    :vartype disallowed: ~azure.mgmt.compute.models.Disallowed
    :ivar purchase_plan: Describes the gallery image definition purchase plan. This is used by
     marketplace images.
    :vartype purchase_plan: ~azure.mgmt.compute.models.ImagePurchasePlan
    :ivar provisioning_state: The provisioning state, which only appears in the response. Known
     values are: "Creating", "Updating", "Failed", "Succeeded", "Deleting", and "Migrating".
    :vartype provisioning_state: str or ~azure.mgmt.compute.models.GalleryProvisioningState
    :ivar features: A list of gallery image features.
    :vartype features: list[~azure.mgmt.compute.models.GalleryImageFeature]
    :ivar architecture: The architecture of the image. Applicable to OS disks only. Known values
     are: "x64" and "Arm64".
    :vartype architecture: str or ~azure.mgmt.compute.models.Architecture
    :ivar allow_update_image: Optional. Must be set to true if the gallery image features are being
     updated.
    :vartype allow_update_image: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "description": {"key": "properties.description", "type": "str"},
        "eula": {"key": "properties.eula", "type": "str"},
        "privacy_statement_uri": {"key": "properties.privacyStatementUri", "type": "str"},
        "release_note_uri": {"key": "properties.releaseNoteUri", "type": "str"},
        "os_type": {"key": "properties.osType", "type": "str"},
        "os_state": {"key": "properties.osState", "type": "str"},
        "hyper_v_generation": {"key": "properties.hyperVGeneration", "type": "str"},
        "end_of_life_date": {"key": "properties.endOfLifeDate", "type": "iso-8601"},
        "identifier": {"key": "properties.identifier", "type": "GalleryImageIdentifier"},
        "recommended": {"key": "properties.recommended", "type": "RecommendedMachineConfiguration"},
        "disallowed": {"key": "properties.disallowed", "type": "Disallowed"},
        "purchase_plan": {"key": "properties.purchasePlan", "type": "ImagePurchasePlan"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "features": {"key": "properties.features", "type": "[GalleryImageFeature]"},
        "architecture": {"key": "properties.architecture", "type": "str"},
        "allow_update_image": {"key": "properties.allowUpdateImage", "type": "bool"},
    }

    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
        description: Optional[str] = None,
        eula: Optional[str] = None,
        privacy_statement_uri: Optional[str] = None,
        release_note_uri: Optional[str] = None,
        os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None,
        os_state: Optional[Union[str, "_models.OperatingSystemStateTypes"]] = None,
        hyper_v_generation: Optional[Union[str, "_models.HyperVGeneration"]] = None,
        end_of_life_date: Optional[datetime.datetime] = None,
        identifier: Optional["_models.GalleryImageIdentifier"] = None,
        recommended: Optional["_models.RecommendedMachineConfiguration"] = None,
        disallowed: Optional["_models.Disallowed"] = None,
        purchase_plan: Optional["_models.ImagePurchasePlan"] = None,
        features: Optional[list["_models.GalleryImageFeature"]] = None,
        architecture: Optional[Union[str, "_models.Architecture"]] = None,
        allow_update_image: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword description: The description of this gallery image definition resource. This property
         is updatable.
        :paramtype description: str
        :keyword eula: The Eula agreement for the gallery image definition.
        :paramtype eula: str
        :keyword privacy_statement_uri: The privacy statement uri.
        :paramtype privacy_statement_uri: str
        :keyword release_note_uri: The release note uri.
        :paramtype release_note_uri: str
        :keyword os_type: This property allows you to specify the type of the OS that is included in
         the disk when creating a VM from a managed image. Possible values are: **Windows,** **Linux.**.
         Known values are: "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
        :keyword os_state: This property allows the user to specify whether the virtual machines
         created under this image are 'Generalized' or 'Specialized'. Known values are: "Generalized"
         and "Specialized".
        :paramtype os_state: str or ~azure.mgmt.compute.models.OperatingSystemStateTypes
        :keyword hyper_v_generation: The hypervisor generation of the Virtual Machine. Applicable to OS
         disks only. Known values are: "V1" and "V2".
        :paramtype hyper_v_generation: str or ~azure.mgmt.compute.models.HyperVGeneration
        :keyword end_of_life_date: The end of life date of the gallery image definition. This property
         can be used for decommissioning purposes. This property is updatable.
        :paramtype end_of_life_date: ~datetime.datetime
        :keyword identifier: This is the gallery image definition identifier.
        :paramtype identifier: ~azure.mgmt.compute.models.GalleryImageIdentifier
        :keyword recommended: The properties describe the recommended machine configuration for this
         Image Definition. These properties are updatable.
        :paramtype recommended: ~azure.mgmt.compute.models.RecommendedMachineConfiguration
        :keyword disallowed: Describes the disallowed disk types.
        :paramtype disallowed: ~azure.mgmt.compute.models.Disallowed
        :keyword purchase_plan: Describes the gallery image definition purchase plan. This is used by
         marketplace images.
        :paramtype purchase_plan: ~azure.mgmt.compute.models.ImagePurchasePlan
        :keyword features: A list of gallery image features.
        :paramtype features: list[~azure.mgmt.compute.models.GalleryImageFeature]
        :keyword architecture: The architecture of the image. Applicable to OS disks only. Known values
         are: "x64" and "Arm64".
        :paramtype architecture: str or ~azure.mgmt.compute.models.Architecture
        :keyword allow_update_image: Optional. Must be set to true if the gallery image features are
         being updated.
        :paramtype allow_update_image: bool
        """
        super().__init__(tags=tags, **kwargs)
        self.description = description
        self.eula = eula
        self.privacy_statement_uri = privacy_statement_uri
        self.release_note_uri = release_note_uri
        self.os_type = os_type
        self.os_state = os_state
        self.hyper_v_generation = hyper_v_generation
        self.end_of_life_date = end_of_life_date
        self.identifier = identifier
        self.recommended = recommended
        self.disallowed = disallowed
        self.purchase_plan = purchase_plan
        self.provisioning_state: Optional[Union[str, "_models.GalleryProvisioningState"]] = None
        self.features = features
        self.architecture = architecture
        self.allow_update_image = allow_update_image


class GalleryImageVersion(TrackedResource):
    """Specifies information about the gallery image version that you want to create or update.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.compute.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar publishing_profile: The publishing profile of a gallery image Version.
    :vartype publishing_profile: ~azure.mgmt.compute.models.GalleryImageVersionPublishingProfile
    :ivar provisioning_state: The provisioning state, which only appears in the response. Known
     values are: "Creating", "Updating", "Failed", "Succeeded", "Deleting", and "Migrating".
    :vartype provisioning_state: str or ~azure.mgmt.compute.models.GalleryProvisioningState
    :ivar storage_profile: This is the storage profile of a Gallery Image Version.
    :vartype storage_profile: ~azure.mgmt.compute.models.GalleryImageVersionStorageProfile
    :ivar safety_profile: This is the safety profile of the Gallery Image Version.
    :vartype safety_profile: ~azure.mgmt.compute.models.GalleryImageVersionSafetyProfile
    :ivar replication_status: This is the replication status of the gallery image version.
    :vartype replication_status: ~azure.mgmt.compute.models.ReplicationStatus
    :ivar security_profile: The security profile of a gallery image version.
    :vartype security_profile: ~azure.mgmt.compute.models.ImageVersionSecurityProfile
    :ivar restore: Indicates if this is a soft-delete resource restoration request.
    :vartype restore: bool
    :ivar validations_profile: This is the validations profile of a Gallery Image Version.
    :vartype validations_profile: ~azure.mgmt.compute.models.ValidationsProfile
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "replication_status": {"readonly": True},
        "validations_profile": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "publishing_profile": {"key": "properties.publishingProfile", "type": "GalleryImageVersionPublishingProfile"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "storage_profile": {"key": "properties.storageProfile", "type": "GalleryImageVersionStorageProfile"},
        "safety_profile": {"key": "properties.safetyProfile", "type": "GalleryImageVersionSafetyProfile"},
        "replication_status": {"key": "properties.replicationStatus", "type": "ReplicationStatus"},
        "security_profile": {"key": "properties.securityProfile", "type": "ImageVersionSecurityProfile"},
        "restore": {"key": "properties.restore", "type": "bool"},
        "validations_profile": {"key": "properties.validationsProfile", "type": "ValidationsProfile"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        publishing_profile: Optional["_models.GalleryImageVersionPublishingProfile"] = None,
        storage_profile: Optional["_models.GalleryImageVersionStorageProfile"] = None,
        safety_profile: Optional["_models.GalleryImageVersionSafetyProfile"] = None,
        security_profile: Optional["_models.ImageVersionSecurityProfile"] = None,
        restore: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword publishing_profile: The publishing profile of a gallery image Version.
        :paramtype publishing_profile: ~azure.mgmt.compute.models.GalleryImageVersionPublishingProfile
        :keyword storage_profile: This is the storage profile of a Gallery Image Version.
        :paramtype storage_profile: ~azure.mgmt.compute.models.GalleryImageVersionStorageProfile
        :keyword safety_profile: This is the safety profile of the Gallery Image Version.
        :paramtype safety_profile: ~azure.mgmt.compute.models.GalleryImageVersionSafetyProfile
        :keyword security_profile: The security profile of a gallery image version.
        :paramtype security_profile: ~azure.mgmt.compute.models.ImageVersionSecurityProfile
        :keyword restore: Indicates if this is a soft-delete resource restoration request.
        :paramtype restore: bool
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.publishing_profile = publishing_profile
        self.provisioning_state: Optional[Union[str, "_models.GalleryProvisioningState"]] = None
        self.storage_profile = storage_profile
        self.safety_profile = safety_profile
        self.replication_status: Optional["_models.ReplicationStatus"] = None
        self.security_profile = security_profile
        self.restore = restore
        self.validations_profile: Optional["_models.ValidationsProfile"] = None


class GalleryImageVersionList(_serialization.Model):
    """The List Gallery Image version operation response.

    All required parameters must be populated in order to send to server.

    :ivar value: A list of gallery image versions. Required.
    :vartype value: list[~azure.mgmt.compute.models.GalleryImageVersion]
    :ivar next_link: The uri to fetch the next page of gallery image versions. Call ListNext() with
     this to fetch the next page of gallery image versions.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[GalleryImageVersion]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: list["_models.GalleryImageVersion"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of gallery image versions. Required.
        :paramtype value: list[~azure.mgmt.compute.models.GalleryImageVersion]
        :keyword next_link: The uri to fetch the next page of gallery image versions. Call ListNext()
         with this to fetch the next page of gallery image versions.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class GalleryImageVersionPublishingProfile(GalleryArtifactPublishingProfileBase):
    """The publishing profile of a gallery image Version.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar target_regions: The target regions where the Image Version is going to be replicated to.
     This property is updatable.
    :vartype target_regions: list[~azure.mgmt.compute.models.TargetRegion]
    :ivar replica_count: The number of replicas of the Image Version to be created per region. This
     property would take effect for a region when regionalReplicaCount is not specified. This
     property is updatable.
    :vartype replica_count: int
    :ivar exclude_from_latest: If set to true, Virtual Machines deployed from the latest version of
     the Image Definition won't use this Image Version.
    :vartype exclude_from_latest: bool
    :ivar published_date: The timestamp for when the gallery image version is published.
    :vartype published_date: ~datetime.datetime
    :ivar end_of_life_date: The end of life date of the gallery image version. This property can be
     used for decommissioning purposes. This property is updatable.
    :vartype end_of_life_date: ~datetime.datetime
    :ivar storage_account_type: Specifies the storage account type to be used to store the image.
     This property is not updatable. Known values are: "Standard_LRS", "Standard_ZRS",
     "Premium_LRS", and "PremiumV2_LRS".
    :vartype storage_account_type: str or ~azure.mgmt.compute.models.StorageAccountType
    :ivar replication_mode: Optional parameter which specifies the mode to be used for replication.
     This property is not updatable. Known values are: "Full" and "Shallow".
    :vartype replication_mode: str or ~azure.mgmt.compute.models.ReplicationMode
    :ivar target_extended_locations: The target extended locations where the Image Version is going
     to be replicated to. This property is updatable.
    :vartype target_extended_locations:
     list[~azure.mgmt.compute.models.GalleryTargetExtendedLocation]
    """


class GalleryImageVersionSafetyProfile(GalleryArtifactSafetyProfileBase):
    """This is the safety profile of the Gallery Image Version.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar allow_deletion_of_replicated_locations: Indicates whether or not removing this Gallery
     Image Version from replicated regions is allowed.
    :vartype allow_deletion_of_replicated_locations: bool
    :ivar reported_for_policy_violation: Indicates whether this image has been reported as
     violating Microsoft's policies.
    :vartype reported_for_policy_violation: bool
    :ivar policy_violations: A list of Policy Violations that have been reported for this Gallery
     Image Version.
    :vartype policy_violations: list[~azure.mgmt.compute.models.PolicyViolation]
    :ivar block_deletion_before_end_of_life: Indicates whether or not the deletion is blocked for
     this Gallery Image Version if its End Of Life has not expired.
    :vartype block_deletion_before_end_of_life: bool
    """

    _validation = {
        "reported_for_policy_violation": {"readonly": True},
        "policy_violations": {"readonly": True},
    }

    _attribute_map = {
        "allow_deletion_of_replicated_locations": {"key": "allowDeletionOfReplicatedLocations", "type": "bool"},
        "reported_for_policy_violation": {"key": "reportedForPolicyViolation", "type": "bool"},
        "policy_violations": {"key": "policyViolations", "type": "[PolicyViolation]"},
        "block_deletion_before_end_of_life": {"key": "blockDeletionBeforeEndOfLife", "type": "bool"},
    }

    def __init__(
        self,
        *,
        allow_deletion_of_replicated_locations: Optional[bool] = None,
        block_deletion_before_end_of_life: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword allow_deletion_of_replicated_locations: Indicates whether or not removing this Gallery
         Image Version from replicated regions is allowed.
        :paramtype allow_deletion_of_replicated_locations: bool
        :keyword block_deletion_before_end_of_life: Indicates whether or not the deletion is blocked
         for this Gallery Image Version if its End Of Life has not expired.
        :paramtype block_deletion_before_end_of_life: bool
        """
        super().__init__(allow_deletion_of_replicated_locations=allow_deletion_of_replicated_locations, **kwargs)
        self.reported_for_policy_violation: Optional[bool] = None
        self.policy_violations: Optional[list["_models.PolicyViolation"]] = None
        self.block_deletion_before_end_of_life = block_deletion_before_end_of_life


class GalleryImageVersionStorageProfile(_serialization.Model):
    """This is the storage profile of a Gallery Image Version.

    :ivar source: The source of the gallery artifact version.
    :vartype source: ~azure.mgmt.compute.models.GalleryArtifactVersionFullSource
    :ivar os_disk_image: This is the OS disk image.
    :vartype os_disk_image: ~azure.mgmt.compute.models.GalleryOSDiskImage
    :ivar data_disk_images: A list of data disk images.
    :vartype data_disk_images: list[~azure.mgmt.compute.models.GalleryDataDiskImage]
    """

    _attribute_map = {
        "source": {"key": "source", "type": "GalleryArtifactVersionFullSource"},
        "os_disk_image": {"key": "osDiskImage", "type": "GalleryOSDiskImage"},
        "data_disk_images": {"key": "dataDiskImages", "type": "[GalleryDataDiskImage]"},
    }

    def __init__(
        self,
        *,
        source: Optional["_models.GalleryArtifactVersionFullSource"] = None,
        os_disk_image: Optional["_models.GalleryOSDiskImage"] = None,
        data_disk_images: Optional[list["_models.GalleryDataDiskImage"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source: The source of the gallery artifact version.
        :paramtype source: ~azure.mgmt.compute.models.GalleryArtifactVersionFullSource
        :keyword os_disk_image: This is the OS disk image.
        :paramtype os_disk_image: ~azure.mgmt.compute.models.GalleryOSDiskImage
        :keyword data_disk_images: A list of data disk images.
        :paramtype data_disk_images: list[~azure.mgmt.compute.models.GalleryDataDiskImage]
        """
        super().__init__(**kwargs)
        self.source = source
        self.os_disk_image = os_disk_image
        self.data_disk_images = data_disk_images


class GalleryImageVersionUefiSettings(_serialization.Model):
    """Contains UEFI settings for the image version.

    :ivar signature_template_names: The name of the template(s) that contains default UEFI key
     signatures that will be added to the image.
    :vartype signature_template_names: list[str or
     ~azure.mgmt.compute.models.UefiSignatureTemplateName]
    :ivar additional_signatures: Additional UEFI key signatures that will be added to the image in
     addition to the signature templates.
    :vartype additional_signatures: ~azure.mgmt.compute.models.UefiKeySignatures
    """

    _attribute_map = {
        "signature_template_names": {"key": "signatureTemplateNames", "type": "[str]"},
        "additional_signatures": {"key": "additionalSignatures", "type": "UefiKeySignatures"},
    }

    def __init__(
        self,
        *,
        signature_template_names: Optional[list[Union[str, "_models.UefiSignatureTemplateName"]]] = None,
        additional_signatures: Optional["_models.UefiKeySignatures"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword signature_template_names: The name of the template(s) that contains default UEFI key
         signatures that will be added to the image.
        :paramtype signature_template_names: list[str or
         ~azure.mgmt.compute.models.UefiSignatureTemplateName]
        :keyword additional_signatures: Additional UEFI key signatures that will be added to the image
         in addition to the signature templates.
        :paramtype additional_signatures: ~azure.mgmt.compute.models.UefiKeySignatures
        """
        super().__init__(**kwargs)
        self.signature_template_names = signature_template_names
        self.additional_signatures = additional_signatures


class GalleryImageVersionUpdate(UpdateResourceDefinition):
    """Specifies information about the gallery image version that you want to update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar publishing_profile: The publishing profile of a gallery image Version.
    :vartype publishing_profile: ~azure.mgmt.compute.models.GalleryImageVersionPublishingProfile
    :ivar provisioning_state: The provisioning state, which only appears in the response. Known
     values are: "Creating", "Updating", "Failed", "Succeeded", "Deleting", and "Migrating".
    :vartype provisioning_state: str or ~azure.mgmt.compute.models.GalleryProvisioningState
    :ivar storage_profile: This is the storage profile of a Gallery Image Version.
    :vartype storage_profile: ~azure.mgmt.compute.models.GalleryImageVersionStorageProfile
    :ivar safety_profile: This is the safety profile of the Gallery Image Version.
    :vartype safety_profile: ~azure.mgmt.compute.models.GalleryImageVersionSafetyProfile
    :ivar replication_status: This is the replication status of the gallery image version.
    :vartype replication_status: ~azure.mgmt.compute.models.ReplicationStatus
    :ivar security_profile: The security profile of a gallery image version.
    :vartype security_profile: ~azure.mgmt.compute.models.ImageVersionSecurityProfile
    :ivar restore: Indicates if this is a soft-delete resource restoration request.
    :vartype restore: bool
    :ivar validations_profile: This is the validations profile of a Gallery Image Version.
    :vartype validations_profile: ~azure.mgmt.compute.models.ValidationsProfile
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "replication_status": {"readonly": True},
        "validations_profile": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "publishing_profile": {"key": "properties.publishingProfile", "type": "GalleryImageVersionPublishingProfile"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "storage_profile": {"key": "properties.storageProfile", "type": "GalleryImageVersionStorageProfile"},
        "safety_profile": {"key": "properties.safetyProfile", "type": "GalleryImageVersionSafetyProfile"},
        "replication_status": {"key": "properties.replicationStatus", "type": "ReplicationStatus"},
        "security_profile": {"key": "properties.securityProfile", "type": "ImageVersionSecurityProfile"},
        "restore": {"key": "properties.restore", "type": "bool"},
        "validations_profile": {"key": "properties.validationsProfile", "type": "ValidationsProfile"},
    }

    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
        publishing_profile: Optional["_models.GalleryImageVersionPublishingProfile"] = None,
        storage_profile: Optional["_models.GalleryImageVersionStorageProfile"] = None,
        safety_profile: Optional["_models.GalleryImageVersionSafetyProfile"] = None,
        security_profile: Optional["_models.ImageVersionSecurityProfile"] = None,
        restore: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword publishing_profile: The publishing profile of a gallery image Version.
        :paramtype publishing_profile: ~azure.mgmt.compute.models.GalleryImageVersionPublishingProfile
        :keyword storage_profile: This is the storage profile of a Gallery Image Version.
        :paramtype storage_profile: ~azure.mgmt.compute.models.GalleryImageVersionStorageProfile
        :keyword safety_profile: This is the safety profile of the Gallery Image Version.
        :paramtype safety_profile: ~azure.mgmt.compute.models.GalleryImageVersionSafetyProfile
        :keyword security_profile: The security profile of a gallery image version.
        :paramtype security_profile: ~azure.mgmt.compute.models.ImageVersionSecurityProfile
        :keyword restore: Indicates if this is a soft-delete resource restoration request.
        :paramtype restore: bool
        """
        super().__init__(tags=tags, **kwargs)
        self.publishing_profile = publishing_profile
        self.provisioning_state: Optional[Union[str, "_models.GalleryProvisioningState"]] = None
        self.storage_profile = storage_profile
        self.safety_profile = safety_profile
        self.replication_status: Optional["_models.ReplicationStatus"] = None
        self.security_profile = security_profile
        self.restore = restore
        self.validations_profile: Optional["_models.ValidationsProfile"] = None


class GalleryInVMAccessControlProfile(TrackedResource):
    """Specifies information about the gallery inVMAccessControlProfile that you want to create or
    update.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.compute.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: Describes the properties of a gallery inVMAccessControlProfile.
    :vartype properties: ~azure.mgmt.compute.models.GalleryInVMAccessControlProfileProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "GalleryInVMAccessControlProfileProperties"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.GalleryInVMAccessControlProfileProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword properties: Describes the properties of a gallery inVMAccessControlProfile.
        :paramtype properties: ~azure.mgmt.compute.models.GalleryInVMAccessControlProfileProperties
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.properties = properties


class GalleryInVMAccessControlProfileList(_serialization.Model):
    """The List Gallery InVMAccessControlProfiles operation response.

    All required parameters must be populated in order to send to server.

    :ivar value: The GalleryInVMAccessControlProfile items on this page. Required.
    :vartype value: list[~azure.mgmt.compute.models.GalleryInVMAccessControlProfile]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[GalleryInVMAccessControlProfile]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: list["_models.GalleryInVMAccessControlProfile"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The GalleryInVMAccessControlProfile items on this page. Required.
        :paramtype value: list[~azure.mgmt.compute.models.GalleryInVMAccessControlProfile]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class GalleryResourceProfilePropertiesBase(_serialization.Model):
    """The properties of a gallery ResourceProfile.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: The provisioning state, which only appears in the response. Known
     values are: "Creating", "Updating", "Failed", "Succeeded", "Deleting", and "Migrating".
    :vartype provisioning_state: str or ~azure.mgmt.compute.models.GalleryProvisioningState
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provisioning_state: Optional[Union[str, "_models.GalleryProvisioningState"]] = None


class GalleryInVMAccessControlProfileProperties(GalleryResourceProfilePropertiesBase):  # pylint: disable=name-too-long
    """Describes the properties of a gallery inVMAccessControlProfile.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar provisioning_state: The provisioning state, which only appears in the response. Known
     values are: "Creating", "Updating", "Failed", "Succeeded", "Deleting", and "Migrating".
    :vartype provisioning_state: str or ~azure.mgmt.compute.models.GalleryProvisioningState
    :ivar description: The description of this gallery inVMAccessControlProfile resources. This
     property is updatable.
    :vartype description: str
    :ivar os_type: This property allows you to specify the OS type of the VMs/VMSS for which this
     profile can be used against. Possible values are: 'Windows' or 'Linux'. Required. Known values
     are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
    :ivar applicable_host_endpoint: This property allows you to specify the Endpoint type for which
     this profile is defining the access control for. Possible values are: 'WireServer' or 'IMDS'.
     Required. Known values are: "WireServer" and "IMDS".
    :vartype applicable_host_endpoint: str or ~azure.mgmt.compute.models.EndpointTypes
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "os_type": {"required": True},
        "applicable_host_endpoint": {"required": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "os_type": {"key": "osType", "type": "str"},
        "applicable_host_endpoint": {"key": "applicableHostEndpoint", "type": "str"},
    }

    def __init__(
        self,
        *,
        os_type: Union[str, "_models.OperatingSystemTypes"],
        applicable_host_endpoint: Union[str, "_models.EndpointTypes"],
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: The description of this gallery inVMAccessControlProfile resources. This
         property is updatable.
        :paramtype description: str
        :keyword os_type: This property allows you to specify the OS type of the VMs/VMSS for which
         this profile can be used against. Possible values are: 'Windows' or 'Linux'. Required. Known
         values are: "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
        :keyword applicable_host_endpoint: This property allows you to specify the Endpoint type for
         which this profile is defining the access control for. Possible values are: 'WireServer' or
         'IMDS'. Required. Known values are: "WireServer" and "IMDS".
        :paramtype applicable_host_endpoint: str or ~azure.mgmt.compute.models.EndpointTypes
        """
        super().__init__(**kwargs)
        self.description = description
        self.os_type = os_type
        self.applicable_host_endpoint = applicable_host_endpoint


class GalleryInVMAccessControlProfileUpdate(UpdateResourceDefinition):
    """Specifies information about the gallery inVMAccessControlProfile that you want to update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: Describes the properties of a gallery inVMAccessControlProfile.
    :vartype properties: ~azure.mgmt.compute.models.GalleryInVMAccessControlProfileProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "properties": {"key": "properties", "type": "GalleryInVMAccessControlProfileProperties"},
    }

    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.GalleryInVMAccessControlProfileProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword properties: Describes the properties of a gallery inVMAccessControlProfile.
        :paramtype properties: ~azure.mgmt.compute.models.GalleryInVMAccessControlProfileProperties
        """
        super().__init__(tags=tags, **kwargs)
        self.properties = properties


class GalleryInVMAccessControlProfileVersion(TrackedResource):
    """Specifies information about the gallery inVMAccessControlProfile version that you want to
    create or update.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.compute.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar target_locations: The target regions where the Resource Profile version is going to be
     replicated to. This property is updatable.
    :vartype target_locations: list[~azure.mgmt.compute.models.TargetRegion]
    :ivar exclude_from_latest: If set to true, Virtual Machines deployed from the latest version of
     the Resource Profile won't use this Profile version.
    :vartype exclude_from_latest: bool
    :ivar published_date: The timestamp for when the Resource Profile Version is published.
    :vartype published_date: ~datetime.datetime
    :ivar provisioning_state: The provisioning state, which only appears in the response. Known
     values are: "Creating", "Updating", "Failed", "Succeeded", "Deleting", and "Migrating".
    :vartype provisioning_state: str or ~azure.mgmt.compute.models.GalleryProvisioningState
    :ivar replication_status: This is the replication status of the gallery image version.
    :vartype replication_status: ~azure.mgmt.compute.models.ReplicationStatus
    :ivar mode: This property allows you to specify whether the access control rules are in Audit
     mode, in Enforce mode or Disabled. Possible values are: 'Audit', 'Enforce' or 'Disabled'. Known
     values are: "Audit", "Enforce", and "Disabled".
    :vartype mode: str or ~azure.mgmt.compute.models.AccessControlRulesMode
    :ivar default_access: This property allows you to specify if the requests will be allowed to
     access the host endpoints. Possible values are: 'Allow', 'Deny'. Known values are: "Allow" and
     "Deny".
    :vartype default_access: str or ~azure.mgmt.compute.models.EndpointAccess
    :ivar rules: This is the Access Control Rules specification for an inVMAccessControlProfile
     version.
    :vartype rules: ~azure.mgmt.compute.models.AccessControlRules
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "published_date": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "replication_status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "target_locations": {"key": "properties.targetLocations", "type": "[TargetRegion]"},
        "exclude_from_latest": {"key": "properties.excludeFromLatest", "type": "bool"},
        "published_date": {"key": "properties.publishedDate", "type": "iso-8601"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "replication_status": {"key": "properties.replicationStatus", "type": "ReplicationStatus"},
        "mode": {"key": "properties.mode", "type": "str"},
        "default_access": {"key": "properties.defaultAccess", "type": "str"},
        "rules": {"key": "properties.rules", "type": "AccessControlRules"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        target_locations: Optional[list["_models.TargetRegion"]] = None,
        exclude_from_latest: Optional[bool] = None,
        mode: Optional[Union[str, "_models.AccessControlRulesMode"]] = None,
        default_access: Optional[Union[str, "_models.EndpointAccess"]] = None,
        rules: Optional["_models.AccessControlRules"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword target_locations: The target regions where the Resource Profile version is going to be
         replicated to. This property is updatable.
        :paramtype target_locations: list[~azure.mgmt.compute.models.TargetRegion]
        :keyword exclude_from_latest: If set to true, Virtual Machines deployed from the latest version
         of the Resource Profile won't use this Profile version.
        :paramtype exclude_from_latest: bool
        :keyword mode: This property allows you to specify whether the access control rules are in
         Audit mode, in Enforce mode or Disabled. Possible values are: 'Audit', 'Enforce' or 'Disabled'.
         Known values are: "Audit", "Enforce", and "Disabled".
        :paramtype mode: str or ~azure.mgmt.compute.models.AccessControlRulesMode
        :keyword default_access: This property allows you to specify if the requests will be allowed to
         access the host endpoints. Possible values are: 'Allow', 'Deny'. Known values are: "Allow" and
         "Deny".
        :paramtype default_access: str or ~azure.mgmt.compute.models.EndpointAccess
        :keyword rules: This is the Access Control Rules specification for an inVMAccessControlProfile
         version.
        :paramtype rules: ~azure.mgmt.compute.models.AccessControlRules
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.target_locations = target_locations
        self.exclude_from_latest = exclude_from_latest
        self.published_date: Optional[datetime.datetime] = None
        self.provisioning_state: Optional[Union[str, "_models.GalleryProvisioningState"]] = None
        self.replication_status: Optional["_models.ReplicationStatus"] = None
        self.mode = mode
        self.default_access = default_access
        self.rules = rules


class GalleryInVMAccessControlProfileVersionList(_serialization.Model):  # pylint: disable=name-too-long
    """The List Gallery InVMAccessControlProfile Versions operation response.

    All required parameters must be populated in order to send to server.

    :ivar value: The GalleryInVMAccessControlProfileVersion items on this page. Required.
    :vartype value: list[~azure.mgmt.compute.models.GalleryInVMAccessControlProfileVersion]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[GalleryInVMAccessControlProfileVersion]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: list["_models.GalleryInVMAccessControlProfileVersion"],
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The GalleryInVMAccessControlProfileVersion items on this page. Required.
        :paramtype value: list[~azure.mgmt.compute.models.GalleryInVMAccessControlProfileVersion]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class GalleryResourceProfileVersionPropertiesBase(_serialization.Model):  # pylint: disable=name-too-long
    """The properties of a gallery ResourceProfile version.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar target_locations: The target regions where the Resource Profile version is going to be
     replicated to. This property is updatable.
    :vartype target_locations: list[~azure.mgmt.compute.models.TargetRegion]
    :ivar exclude_from_latest: If set to true, Virtual Machines deployed from the latest version of
     the Resource Profile won't use this Profile version.
    :vartype exclude_from_latest: bool
    :ivar published_date: The timestamp for when the Resource Profile Version is published.
    :vartype published_date: ~datetime.datetime
    :ivar provisioning_state: The provisioning state, which only appears in the response. Known
     values are: "Creating", "Updating", "Failed", "Succeeded", "Deleting", and "Migrating".
    :vartype provisioning_state: str or ~azure.mgmt.compute.models.GalleryProvisioningState
    :ivar replication_status: This is the replication status of the gallery image version.
    :vartype replication_status: ~azure.mgmt.compute.models.ReplicationStatus
    """

    _validation = {
        "published_date": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "replication_status": {"readonly": True},
    }

    _attribute_map = {
        "target_locations": {"key": "targetLocations", "type": "[TargetRegion]"},
        "exclude_from_latest": {"key": "excludeFromLatest", "type": "bool"},
        "published_date": {"key": "publishedDate", "type": "iso-8601"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "replication_status": {"key": "replicationStatus", "type": "ReplicationStatus"},
    }

    def __init__(
        self,
        *,
        target_locations: Optional[list["_models.TargetRegion"]] = None,
        exclude_from_latest: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword target_locations: The target regions where the Resource Profile version is going to be
         replicated to. This property is updatable.
        :paramtype target_locations: list[~azure.mgmt.compute.models.TargetRegion]
        :keyword exclude_from_latest: If set to true, Virtual Machines deployed from the latest version
         of the Resource Profile won't use this Profile version.
        :paramtype exclude_from_latest: bool
        """
        super().__init__(**kwargs)
        self.target_locations = target_locations
        self.exclude_from_latest = exclude_from_latest
        self.published_date: Optional[datetime.datetime] = None
        self.provisioning_state: Optional[Union[str, "_models.GalleryProvisioningState"]] = None
        self.replication_status: Optional["_models.ReplicationStatus"] = None


class GalleryInVMAccessControlProfileVersionProperties(
    GalleryResourceProfileVersionPropertiesBase
):  # pylint: disable=name-too-long
    """Describes the properties of an inVMAccessControlProfile version.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar target_locations: The target regions where the Resource Profile version is going to be
     replicated to. This property is updatable.
    :vartype target_locations: list[~azure.mgmt.compute.models.TargetRegion]
    :ivar exclude_from_latest: If set to true, Virtual Machines deployed from the latest version of
     the Resource Profile won't use this Profile version.
    :vartype exclude_from_latest: bool
    :ivar published_date: The timestamp for when the Resource Profile Version is published.
    :vartype published_date: ~datetime.datetime
    :ivar provisioning_state: The provisioning state, which only appears in the response. Known
     values are: "Creating", "Updating", "Failed", "Succeeded", "Deleting", and "Migrating".
    :vartype provisioning_state: str or ~azure.mgmt.compute.models.GalleryProvisioningState
    :ivar replication_status: This is the replication status of the gallery image version.
    :vartype replication_status: ~azure.mgmt.compute.models.ReplicationStatus
    :ivar mode: This property allows you to specify whether the access control rules are in Audit
     mode, in Enforce mode or Disabled. Possible values are: 'Audit', 'Enforce' or 'Disabled'.
     Required. Known values are: "Audit", "Enforce", and "Disabled".
    :vartype mode: str or ~azure.mgmt.compute.models.AccessControlRulesMode
    :ivar default_access: This property allows you to specify if the requests will be allowed to
     access the host endpoints. Possible values are: 'Allow', 'Deny'. Required. Known values are:
     "Allow" and "Deny".
    :vartype default_access: str or ~azure.mgmt.compute.models.EndpointAccess
    :ivar rules: This is the Access Control Rules specification for an inVMAccessControlProfile
     version.
    :vartype rules: ~azure.mgmt.compute.models.AccessControlRules
    """

    _validation = {
        "published_date": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "replication_status": {"readonly": True},
        "mode": {"required": True},
        "default_access": {"required": True},
    }

    _attribute_map = {
        "target_locations": {"key": "targetLocations", "type": "[TargetRegion]"},
        "exclude_from_latest": {"key": "excludeFromLatest", "type": "bool"},
        "published_date": {"key": "publishedDate", "type": "iso-8601"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "replication_status": {"key": "replicationStatus", "type": "ReplicationStatus"},
        "mode": {"key": "mode", "type": "str"},
        "default_access": {"key": "defaultAccess", "type": "str"},
        "rules": {"key": "rules", "type": "AccessControlRules"},
    }

    def __init__(
        self,
        *,
        mode: Union[str, "_models.AccessControlRulesMode"],
        default_access: Union[str, "_models.EndpointAccess"],
        target_locations: Optional[list["_models.TargetRegion"]] = None,
        exclude_from_latest: Optional[bool] = None,
        rules: Optional["_models.AccessControlRules"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword target_locations: The target regions where the Resource Profile version is going to be
         replicated to. This property is updatable.
        :paramtype target_locations: list[~azure.mgmt.compute.models.TargetRegion]
        :keyword exclude_from_latest: If set to true, Virtual Machines deployed from the latest version
         of the Resource Profile won't use this Profile version.
        :paramtype exclude_from_latest: bool
        :keyword mode: This property allows you to specify whether the access control rules are in
         Audit mode, in Enforce mode or Disabled. Possible values are: 'Audit', 'Enforce' or 'Disabled'.
         Required. Known values are: "Audit", "Enforce", and "Disabled".
        :paramtype mode: str or ~azure.mgmt.compute.models.AccessControlRulesMode
        :keyword default_access: This property allows you to specify if the requests will be allowed to
         access the host endpoints. Possible values are: 'Allow', 'Deny'. Required. Known values are:
         "Allow" and "Deny".
        :paramtype default_access: str or ~azure.mgmt.compute.models.EndpointAccess
        :keyword rules: This is the Access Control Rules specification for an inVMAccessControlProfile
         version.
        :paramtype rules: ~azure.mgmt.compute.models.AccessControlRules
        """
        super().__init__(target_locations=target_locations, exclude_from_latest=exclude_from_latest, **kwargs)
        self.mode = mode
        self.default_access = default_access
        self.rules = rules


class GalleryInVMAccessControlProfileVersionUpdate(UpdateResourceDefinition):  # pylint: disable=name-too-long
    """Specifies information about the gallery inVMAccessControlProfile version that you want to
    update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar target_locations: The target regions where the Resource Profile version is going to be
     replicated to. This property is updatable.
    :vartype target_locations: list[~azure.mgmt.compute.models.TargetRegion]
    :ivar exclude_from_latest: If set to true, Virtual Machines deployed from the latest version of
     the Resource Profile won't use this Profile version.
    :vartype exclude_from_latest: bool
    :ivar published_date: The timestamp for when the Resource Profile Version is published.
    :vartype published_date: ~datetime.datetime
    :ivar provisioning_state: The provisioning state, which only appears in the response. Known
     values are: "Creating", "Updating", "Failed", "Succeeded", "Deleting", and "Migrating".
    :vartype provisioning_state: str or ~azure.mgmt.compute.models.GalleryProvisioningState
    :ivar replication_status: This is the replication status of the gallery image version.
    :vartype replication_status: ~azure.mgmt.compute.models.ReplicationStatus
    :ivar mode: This property allows you to specify whether the access control rules are in Audit
     mode, in Enforce mode or Disabled. Possible values are: 'Audit', 'Enforce' or 'Disabled'. Known
     values are: "Audit", "Enforce", and "Disabled".
    :vartype mode: str or ~azure.mgmt.compute.models.AccessControlRulesMode
    :ivar default_access: This property allows you to specify if the requests will be allowed to
     access the host endpoints. Possible values are: 'Allow', 'Deny'. Known values are: "Allow" and
     "Deny".
    :vartype default_access: str or ~azure.mgmt.compute.models.EndpointAccess
    :ivar rules: This is the Access Control Rules specification for an inVMAccessControlProfile
     version.
    :vartype rules: ~azure.mgmt.compute.models.AccessControlRules
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "published_date": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "replication_status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "target_locations": {"key": "properties.targetLocations", "type": "[TargetRegion]"},
        "exclude_from_latest": {"key": "properties.excludeFromLatest", "type": "bool"},
        "published_date": {"key": "properties.publishedDate", "type": "iso-8601"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "replication_status": {"key": "properties.replicationStatus", "type": "ReplicationStatus"},
        "mode": {"key": "properties.mode", "type": "str"},
        "default_access": {"key": "properties.defaultAccess", "type": "str"},
        "rules": {"key": "properties.rules", "type": "AccessControlRules"},
    }

    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
        target_locations: Optional[list["_models.TargetRegion"]] = None,
        exclude_from_latest: Optional[bool] = None,
        mode: Optional[Union[str, "_models.AccessControlRulesMode"]] = None,
        default_access: Optional[Union[str, "_models.EndpointAccess"]] = None,
        rules: Optional["_models.AccessControlRules"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword target_locations: The target regions where the Resource Profile version is going to be
         replicated to. This property is updatable.
        :paramtype target_locations: list[~azure.mgmt.compute.models.TargetRegion]
        :keyword exclude_from_latest: If set to true, Virtual Machines deployed from the latest version
         of the Resource Profile won't use this Profile version.
        :paramtype exclude_from_latest: bool
        :keyword mode: This property allows you to specify whether the access control rules are in
         Audit mode, in Enforce mode or Disabled. Possible values are: 'Audit', 'Enforce' or 'Disabled'.
         Known values are: "Audit", "Enforce", and "Disabled".
        :paramtype mode: str or ~azure.mgmt.compute.models.AccessControlRulesMode
        :keyword default_access: This property allows you to specify if the requests will be allowed to
         access the host endpoints. Possible values are: 'Allow', 'Deny'. Known values are: "Allow" and
         "Deny".
        :paramtype default_access: str or ~azure.mgmt.compute.models.EndpointAccess
        :keyword rules: This is the Access Control Rules specification for an inVMAccessControlProfile
         version.
        :paramtype rules: ~azure.mgmt.compute.models.AccessControlRules
        """
        super().__init__(tags=tags, **kwargs)
        self.target_locations = target_locations
        self.exclude_from_latest = exclude_from_latest
        self.published_date: Optional[datetime.datetime] = None
        self.provisioning_state: Optional[Union[str, "_models.GalleryProvisioningState"]] = None
        self.replication_status: Optional["_models.ReplicationStatus"] = None
        self.mode = mode
        self.default_access = default_access
        self.rules = rules


class GalleryList(_serialization.Model):
    """The List Galleries operation response.

    All required parameters must be populated in order to send to server.

    :ivar value: A list of galleries. Required.
    :vartype value: list[~azure.mgmt.compute.models.Gallery]
    :ivar next_link: The uri to fetch the next page of galleries. Call ListNext() with this to
     fetch the next page of galleries.
    :vartype next_link: str
    :ivar security_profile: The security profile of a gallery image version.
    :vartype security_profile: ~azure.mgmt.compute.models.ImageVersionSecurityProfile
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Gallery]"},
        "next_link": {"key": "nextLink", "type": "str"},
        "security_profile": {"key": "securityProfile", "type": "ImageVersionSecurityProfile"},
    }

    def __init__(
        self,
        *,
        value: list["_models.Gallery"],
        next_link: Optional[str] = None,
        security_profile: Optional["_models.ImageVersionSecurityProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of galleries. Required.
        :paramtype value: list[~azure.mgmt.compute.models.Gallery]
        :keyword next_link: The uri to fetch the next page of galleries. Call ListNext() with this to
         fetch the next page of galleries.
        :paramtype next_link: str
        :keyword security_profile: The security profile of a gallery image version.
        :paramtype security_profile: ~azure.mgmt.compute.models.ImageVersionSecurityProfile
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link
        self.security_profile = security_profile


class GalleryOSDiskImage(GalleryDiskImage):
    """This is the OS disk image.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar size_in_gb: This property indicates the size of the VHD to be created.
    :vartype size_in_gb: int
    :ivar host_caching: The host caching of the disk. Valid values are 'None', 'ReadOnly', and
     'ReadWrite'. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype host_caching: str or ~azure.mgmt.compute.models.HostCaching
    :ivar source: The source for the disk image.
    :vartype source: ~azure.mgmt.compute.models.GalleryDiskImageSource
    """


class GallerySoftDeletedResource(TrackedResource):
    """The details information of soft-deleted resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.compute.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar resource_arm_id: arm id of the soft-deleted resource.
    :vartype resource_arm_id: str
    :ivar soft_deleted_artifact_type: artifact type of the soft-deleted resource. "Images"
    :vartype soft_deleted_artifact_type: str or ~azure.mgmt.compute.models.SoftDeletedArtifactTypes
    :ivar soft_deleted_time: The timestamp for when the resource is soft-deleted. In dateTime
     offset format.
    :vartype soft_deleted_time: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "resource_arm_id": {"key": "properties.resourceArmId", "type": "str"},
        "soft_deleted_artifact_type": {"key": "properties.softDeletedArtifactType", "type": "str"},
        "soft_deleted_time": {"key": "properties.softDeletedTime", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        resource_arm_id: Optional[str] = None,
        soft_deleted_artifact_type: Optional[Union[str, "_models.SoftDeletedArtifactTypes"]] = None,
        soft_deleted_time: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword resource_arm_id: arm id of the soft-deleted resource.
        :paramtype resource_arm_id: str
        :keyword soft_deleted_artifact_type: artifact type of the soft-deleted resource. "Images"
        :paramtype soft_deleted_artifact_type: str or
         ~azure.mgmt.compute.models.SoftDeletedArtifactTypes
        :keyword soft_deleted_time: The timestamp for when the resource is soft-deleted. In dateTime
         offset format.
        :paramtype soft_deleted_time: str
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.resource_arm_id = resource_arm_id
        self.soft_deleted_artifact_type = soft_deleted_artifact_type
        self.soft_deleted_time = soft_deleted_time


class GallerySoftDeletedResourceList(_serialization.Model):
    """The List Soft-deleted Resources operation response.

    All required parameters must be populated in order to send to server.

    :ivar value: The GallerySoftDeletedResource items on this page. Required.
    :vartype value: list[~azure.mgmt.compute.models.GallerySoftDeletedResource]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[GallerySoftDeletedResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: list["_models.GallerySoftDeletedResource"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The GallerySoftDeletedResource items on this page. Required.
        :paramtype value: list[~azure.mgmt.compute.models.GallerySoftDeletedResource]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class GalleryTargetExtendedLocation(_serialization.Model):
    """GalleryTargetExtendedLocation.

    :ivar name: The name of the region.
    :vartype name: str
    :ivar extended_location: The name of the extended location.
    :vartype extended_location: ~azure.mgmt.compute.models.GalleryExtendedLocation
    :ivar extended_location_replica_count: The number of replicas of the Image Version to be
     created per extended location. This property is updatable.
    :vartype extended_location_replica_count: int
    :ivar storage_account_type: Specifies the storage account type to be used to store the image.
     This property is not updatable. Known values are: "Standard_LRS", "Standard_ZRS",
     "StandardSSD_LRS", and "Premium_LRS".
    :vartype storage_account_type: str or ~azure.mgmt.compute.models.EdgeZoneStorageAccountType
    :ivar encryption: Optional. Allows users to provide customer managed keys for encrypting the OS
     and data disks in the gallery artifact.
    :vartype encryption: ~azure.mgmt.compute.models.EncryptionImages
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "extended_location": {"key": "extendedLocation", "type": "GalleryExtendedLocation"},
        "extended_location_replica_count": {"key": "extendedLocationReplicaCount", "type": "int"},
        "storage_account_type": {"key": "storageAccountType", "type": "str"},
        "encryption": {"key": "encryption", "type": "EncryptionImages"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        extended_location: Optional["_models.GalleryExtendedLocation"] = None,
        extended_location_replica_count: Optional[int] = None,
        storage_account_type: Optional[Union[str, "_models.EdgeZoneStorageAccountType"]] = None,
        encryption: Optional["_models.EncryptionImages"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the region.
        :paramtype name: str
        :keyword extended_location: The name of the extended location.
        :paramtype extended_location: ~azure.mgmt.compute.models.GalleryExtendedLocation
        :keyword extended_location_replica_count: The number of replicas of the Image Version to be
         created per extended location. This property is updatable.
        :paramtype extended_location_replica_count: int
        :keyword storage_account_type: Specifies the storage account type to be used to store the
         image. This property is not updatable. Known values are: "Standard_LRS", "Standard_ZRS",
         "StandardSSD_LRS", and "Premium_LRS".
        :paramtype storage_account_type: str or ~azure.mgmt.compute.models.EdgeZoneStorageAccountType
        :keyword encryption: Optional. Allows users to provide customer managed keys for encrypting the
         OS and data disks in the gallery artifact.
        :paramtype encryption: ~azure.mgmt.compute.models.EncryptionImages
        """
        super().__init__(**kwargs)
        self.name = name
        self.extended_location = extended_location
        self.extended_location_replica_count = extended_location_replica_count
        self.storage_account_type = storage_account_type
        self.encryption = encryption


class GalleryUpdate(UpdateResourceDefinition):
    """Specifies information about the Shared Image Gallery that you want to update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar identity: The identity of the gallery, if configured.
    :vartype identity: ~azure.mgmt.compute.models.GalleryIdentity
    :ivar description: The description of this Shared Image Gallery resource. This property is
     updatable.
    :vartype description: str
    :ivar identifier: Describes the gallery unique name.
    :vartype identifier: ~azure.mgmt.compute.models.GalleryIdentifier
    :ivar provisioning_state: The provisioning state, which only appears in the response. Known
     values are: "Creating", "Updating", "Failed", "Succeeded", "Deleting", and "Migrating".
    :vartype provisioning_state: str or ~azure.mgmt.compute.models.GalleryProvisioningState
    :ivar sharing_profile: Profile for gallery sharing to subscription or tenant.
    :vartype sharing_profile: ~azure.mgmt.compute.models.SharingProfile
    :ivar soft_delete_policy: Contains information about the soft deletion policy of the gallery.
    :vartype soft_delete_policy: ~azure.mgmt.compute.models.SoftDeletePolicy
    :ivar sharing_status: Sharing status of current gallery.
    :vartype sharing_status: ~azure.mgmt.compute.models.SharingStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "sharing_status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "GalleryIdentity"},
        "description": {"key": "properties.description", "type": "str"},
        "identifier": {"key": "properties.identifier", "type": "GalleryIdentifier"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "sharing_profile": {"key": "properties.sharingProfile", "type": "SharingProfile"},
        "soft_delete_policy": {"key": "properties.softDeletePolicy", "type": "SoftDeletePolicy"},
        "sharing_status": {"key": "properties.sharingStatus", "type": "SharingStatus"},
    }

    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
        identity: Optional["_models.GalleryIdentity"] = None,
        description: Optional[str] = None,
        identifier: Optional["_models.GalleryIdentifier"] = None,
        sharing_profile: Optional["_models.SharingProfile"] = None,
        soft_delete_policy: Optional["_models.SoftDeletePolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword identity: The identity of the gallery, if configured.
        :paramtype identity: ~azure.mgmt.compute.models.GalleryIdentity
        :keyword description: The description of this Shared Image Gallery resource. This property is
         updatable.
        :paramtype description: str
        :keyword identifier: Describes the gallery unique name.
        :paramtype identifier: ~azure.mgmt.compute.models.GalleryIdentifier
        :keyword sharing_profile: Profile for gallery sharing to subscription or tenant.
        :paramtype sharing_profile: ~azure.mgmt.compute.models.SharingProfile
        :keyword soft_delete_policy: Contains information about the soft deletion policy of the
         gallery.
        :paramtype soft_delete_policy: ~azure.mgmt.compute.models.SoftDeletePolicy
        """
        super().__init__(tags=tags, **kwargs)
        self.identity = identity
        self.description = description
        self.identifier = identifier
        self.provisioning_state: Optional[Union[str, "_models.GalleryProvisioningState"]] = None
        self.sharing_profile = sharing_profile
        self.soft_delete_policy = soft_delete_policy
        self.sharing_status: Optional["_models.SharingStatus"] = None


class GrantAccessData(_serialization.Model):
    """Data used for requesting a SAS.

    All required parameters must be populated in order to send to server.

    :ivar access: The Access Level, accepted values include None, Read, Write. Required. Known
     values are: "None", "Read", and "Write".
    :vartype access: str or ~azure.mgmt.compute.models.AccessLevel
    :ivar duration_in_seconds: Time duration in seconds until the SAS access expires. Required.
    :vartype duration_in_seconds: int
    :ivar get_secure_vm_guest_state_sas: Set this flag to true to get additional SAS for VM guest
     state.
    :vartype get_secure_vm_guest_state_sas: bool
    :ivar file_format: Used to specify the file format when making request for SAS on a VHDX file
     format snapshot. Known values are: "VHD" and "VHDX".
    :vartype file_format: str or ~azure.mgmt.compute.models.FileFormat
    """

    _validation = {
        "access": {"required": True},
        "duration_in_seconds": {"required": True},
    }

    _attribute_map = {
        "access": {"key": "access", "type": "str"},
        "duration_in_seconds": {"key": "durationInSeconds", "type": "int"},
        "get_secure_vm_guest_state_sas": {"key": "getSecureVMGuestStateSAS", "type": "bool"},
        "file_format": {"key": "fileFormat", "type": "str"},
    }

    def __init__(
        self,
        *,
        access: Union[str, "_models.AccessLevel"],
        duration_in_seconds: int,
        get_secure_vm_guest_state_sas: Optional[bool] = None,
        file_format: Optional[Union[str, "_models.FileFormat"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword access: The Access Level, accepted values include None, Read, Write. Required. Known
         values are: "None", "Read", and "Write".
        :paramtype access: str or ~azure.mgmt.compute.models.AccessLevel
        :keyword duration_in_seconds: Time duration in seconds until the SAS access expires. Required.
        :paramtype duration_in_seconds: int
        :keyword get_secure_vm_guest_state_sas: Set this flag to true to get additional SAS for VM
         guest state.
        :paramtype get_secure_vm_guest_state_sas: bool
        :keyword file_format: Used to specify the file format when making request for SAS on a VHDX
         file format snapshot. Known values are: "VHD" and "VHDX".
        :paramtype file_format: str or ~azure.mgmt.compute.models.FileFormat
        """
        super().__init__(**kwargs)
        self.access = access
        self.duration_in_seconds = duration_in_seconds
        self.get_secure_vm_guest_state_sas = get_secure_vm_guest_state_sas
        self.file_format = file_format


class HardwareProfile(_serialization.Model):
    """Specifies the hardware settings for the virtual machine.

    :ivar vm_size: Specifies the size of the virtual machine. The enum data type is currently
     deprecated and will be removed by December 23rd 2023. The recommended way to get the list of
     available sizes is using these APIs: `List all available virtual machine sizes in an
     availability set
     <https://docs.microsoft.com/rest/api/compute/availabilitysets/listavailablesizes>`_\\ , `List
     all available virtual machine sizes in a region
     <https://docs.microsoft.com/rest/api/compute/resourceskus/list>`_\\ , `List all available
     virtual machine sizes for resizing
     <https://docs.microsoft.com/rest/api/compute/virtualmachines/listavailablesizes>`_. For more
     information about virtual machine sizes, see `Sizes for virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/sizes>`_. The available VM sizes depend on
     region and availability set. Known values are: "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3",
     "Basic_A4", "Standard_A0", "Standard_A1", "Standard_A2", "Standard_A3", "Standard_A4",
     "Standard_A5", "Standard_A6", "Standard_A7", "Standard_A8", "Standard_A9", "Standard_A10",
     "Standard_A11", "Standard_A1_v2", "Standard_A2_v2", "Standard_A4_v2", "Standard_A8_v2",
     "Standard_A2m_v2", "Standard_A4m_v2", "Standard_A8m_v2", "Standard_B1s", "Standard_B1ms",
     "Standard_B2s", "Standard_B2ms", "Standard_B4ms", "Standard_B8ms", "Standard_D1",
     "Standard_D2", "Standard_D3", "Standard_D4", "Standard_D11", "Standard_D12", "Standard_D13",
     "Standard_D14", "Standard_D1_v2", "Standard_D2_v2", "Standard_D3_v2", "Standard_D4_v2",
     "Standard_D5_v2", "Standard_D2_v3", "Standard_D4_v3", "Standard_D8_v3", "Standard_D16_v3",
     "Standard_D32_v3", "Standard_D64_v3", "Standard_D2s_v3", "Standard_D4s_v3", "Standard_D8s_v3",
     "Standard_D16s_v3", "Standard_D32s_v3", "Standard_D64s_v3", "Standard_D11_v2",
     "Standard_D12_v2", "Standard_D13_v2", "Standard_D14_v2", "Standard_D15_v2", "Standard_DS1",
     "Standard_DS2", "Standard_DS3", "Standard_DS4", "Standard_DS11", "Standard_DS12",
     "Standard_DS13", "Standard_DS14", "Standard_DS1_v2", "Standard_DS2_v2", "Standard_DS3_v2",
     "Standard_DS4_v2", "Standard_DS5_v2", "Standard_DS11_v2", "Standard_DS12_v2",
     "Standard_DS13_v2", "Standard_DS14_v2", "Standard_DS15_v2", "Standard_DS13-4_v2",
     "Standard_DS13-2_v2", "Standard_DS14-8_v2", "Standard_DS14-4_v2", "Standard_E2_v3",
     "Standard_E4_v3", "Standard_E8_v3", "Standard_E16_v3", "Standard_E32_v3", "Standard_E64_v3",
     "Standard_E2s_v3", "Standard_E4s_v3", "Standard_E8s_v3", "Standard_E16s_v3",
     "Standard_E32s_v3", "Standard_E64s_v3", "Standard_E32-16_v3", "Standard_E32-8s_v3",
     "Standard_E64-32s_v3", "Standard_E64-16s_v3", "Standard_F1", "Standard_F2", "Standard_F4",
     "Standard_F8", "Standard_F16", "Standard_F1s", "Standard_F2s", "Standard_F4s", "Standard_F8s",
     "Standard_F16s", "Standard_F2s_v2", "Standard_F4s_v2", "Standard_F8s_v2", "Standard_F16s_v2",
     "Standard_F32s_v2", "Standard_F64s_v2", "Standard_F72s_v2", "Standard_G1", "Standard_G2",
     "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2", "Standard_GS3",
     "Standard_GS4", "Standard_GS5", "Standard_GS4-8", "Standard_GS4-4", "Standard_GS5-16",
     "Standard_GS5-8", "Standard_H8", "Standard_H16", "Standard_H8m", "Standard_H16m",
     "Standard_H16r", "Standard_H16mr", "Standard_L4s", "Standard_L8s", "Standard_L16s",
     "Standard_L32s", "Standard_M64s", "Standard_M64ms", "Standard_M128s", "Standard_M128ms",
     "Standard_M64-32ms", "Standard_M64-16ms", "Standard_M128-64ms", "Standard_M128-32ms",
     "Standard_NC6", "Standard_NC12", "Standard_NC24", "Standard_NC24r", "Standard_NC6s_v2",
     "Standard_NC12s_v2", "Standard_NC24s_v2", "Standard_NC24rs_v2", "Standard_NC6s_v3",
     "Standard_NC12s_v3", "Standard_NC24s_v3", "Standard_NC24rs_v3", "Standard_ND6s",
     "Standard_ND12s", "Standard_ND24s", "Standard_ND24rs", "Standard_NV6", "Standard_NV12", and
     "Standard_NV24".
    :vartype vm_size: str or ~azure.mgmt.compute.models.VirtualMachineSizeTypes
    :ivar vm_size_properties: Specifies the properties for customizing the size of the virtual
     machine. Minimum api-version: 2021-07-01. This feature is still in preview mode and is not
     supported for VirtualMachineScaleSet. Please follow the instructions in `VM Customization
     <https://aka.ms/vmcustomization>`_ for more details.
    :vartype vm_size_properties: ~azure.mgmt.compute.models.VMSizeProperties
    """

    _attribute_map = {
        "vm_size": {"key": "vmSize", "type": "str"},
        "vm_size_properties": {"key": "vmSizeProperties", "type": "VMSizeProperties"},
    }

    def __init__(
        self,
        *,
        vm_size: Optional[Union[str, "_models.VirtualMachineSizeTypes"]] = None,
        vm_size_properties: Optional["_models.VMSizeProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword vm_size: Specifies the size of the virtual machine. The enum data type is currently
         deprecated and will be removed by December 23rd 2023. The recommended way to get the list of
         available sizes is using these APIs: `List all available virtual machine sizes in an
         availability set
         <https://docs.microsoft.com/rest/api/compute/availabilitysets/listavailablesizes>`_\\ , `List
         all available virtual machine sizes in a region
         <https://docs.microsoft.com/rest/api/compute/resourceskus/list>`_\\ , `List all available
         virtual machine sizes for resizing
         <https://docs.microsoft.com/rest/api/compute/virtualmachines/listavailablesizes>`_. For more
         information about virtual machine sizes, see `Sizes for virtual machines
         <https://docs.microsoft.com/azure/virtual-machines/sizes>`_. The available VM sizes depend on
         region and availability set. Known values are: "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3",
         "Basic_A4", "Standard_A0", "Standard_A1", "Standard_A2", "Standard_A3", "Standard_A4",
         "Standard_A5", "Standard_A6", "Standard_A7", "Standard_A8", "Standard_A9", "Standard_A10",
         "Standard_A11", "Standard_A1_v2", "Standard_A2_v2", "Standard_A4_v2", "Standard_A8_v2",
         "Standard_A2m_v2", "Standard_A4m_v2", "Standard_A8m_v2", "Standard_B1s", "Standard_B1ms",
         "Standard_B2s", "Standard_B2ms", "Standard_B4ms", "Standard_B8ms", "Standard_D1",
         "Standard_D2", "Standard_D3", "Standard_D4", "Standard_D11", "Standard_D12", "Standard_D13",
         "Standard_D14", "Standard_D1_v2", "Standard_D2_v2", "Standard_D3_v2", "Standard_D4_v2",
         "Standard_D5_v2", "Standard_D2_v3", "Standard_D4_v3", "Standard_D8_v3", "Standard_D16_v3",
         "Standard_D32_v3", "Standard_D64_v3", "Standard_D2s_v3", "Standard_D4s_v3", "Standard_D8s_v3",
         "Standard_D16s_v3", "Standard_D32s_v3", "Standard_D64s_v3", "Standard_D11_v2",
         "Standard_D12_v2", "Standard_D13_v2", "Standard_D14_v2", "Standard_D15_v2", "Standard_DS1",
         "Standard_DS2", "Standard_DS3", "Standard_DS4", "Standard_DS11", "Standard_DS12",
         "Standard_DS13", "Standard_DS14", "Standard_DS1_v2", "Standard_DS2_v2", "Standard_DS3_v2",
         "Standard_DS4_v2", "Standard_DS5_v2", "Standard_DS11_v2", "Standard_DS12_v2",
         "Standard_DS13_v2", "Standard_DS14_v2", "Standard_DS15_v2", "Standard_DS13-4_v2",
         "Standard_DS13-2_v2", "Standard_DS14-8_v2", "Standard_DS14-4_v2", "Standard_E2_v3",
         "Standard_E4_v3", "Standard_E8_v3", "Standard_E16_v3", "Standard_E32_v3", "Standard_E64_v3",
         "Standard_E2s_v3", "Standard_E4s_v3", "Standard_E8s_v3", "Standard_E16s_v3",
         "Standard_E32s_v3", "Standard_E64s_v3", "Standard_E32-16_v3", "Standard_E32-8s_v3",
         "Standard_E64-32s_v3", "Standard_E64-16s_v3", "Standard_F1", "Standard_F2", "Standard_F4",
         "Standard_F8", "Standard_F16", "Standard_F1s", "Standard_F2s", "Standard_F4s", "Standard_F8s",
         "Standard_F16s", "Standard_F2s_v2", "Standard_F4s_v2", "Standard_F8s_v2", "Standard_F16s_v2",
         "Standard_F32s_v2", "Standard_F64s_v2", "Standard_F72s_v2", "Standard_G1", "Standard_G2",
         "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2", "Standard_GS3",
         "Standard_GS4", "Standard_GS5", "Standard_GS4-8", "Standard_GS4-4", "Standard_GS5-16",
         "Standard_GS5-8", "Standard_H8", "Standard_H16", "Standard_H8m", "Standard_H16m",
         "Standard_H16r", "Standard_H16mr", "Standard_L4s", "Standard_L8s", "Standard_L16s",
         "Standard_L32s", "Standard_M64s", "Standard_M64ms", "Standard_M128s", "Standard_M128ms",
         "Standard_M64-32ms", "Standard_M64-16ms", "Standard_M128-64ms", "Standard_M128-32ms",
         "Standard_NC6", "Standard_NC12", "Standard_NC24", "Standard_NC24r", "Standard_NC6s_v2",
         "Standard_NC12s_v2", "Standard_NC24s_v2", "Standard_NC24rs_v2", "Standard_NC6s_v3",
         "Standard_NC12s_v3", "Standard_NC24s_v3", "Standard_NC24rs_v3", "Standard_ND6s",
         "Standard_ND12s", "Standard_ND24s", "Standard_ND24rs", "Standard_NV6", "Standard_NV12", and
         "Standard_NV24".
        :paramtype vm_size: str or ~azure.mgmt.compute.models.VirtualMachineSizeTypes
        :keyword vm_size_properties: Specifies the properties for customizing the size of the virtual
         machine. Minimum api-version: 2021-07-01. This feature is still in preview mode and is not
         supported for VirtualMachineScaleSet. Please follow the instructions in `VM Customization
         <https://aka.ms/vmcustomization>`_ for more details.
        :paramtype vm_size_properties: ~azure.mgmt.compute.models.VMSizeProperties
        """
        super().__init__(**kwargs)
        self.vm_size = vm_size
        self.vm_size_properties = vm_size_properties


class HostEndpointSettings(_serialization.Model):
    """Specifies particular host endpoint settings.

    :ivar mode: Specifies the execution mode. In Audit mode, the system acts as if it is enforcing
     the access control policy, including emitting access denial entries in the logs but it does not
     actually deny any requests to host endpoints. In Enforce mode, the system will enforce the
     access control and it is the recommended mode of operation. Known values are: "Audit",
     "Enforce", and "Disabled".
    :vartype mode: str or ~azure.mgmt.compute.models.Modes
    :ivar in_vm_access_control_profile_reference_id: Specifies the InVMAccessControlProfileVersion
     resource id in the format of
     /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/inVMAccessControlProfiles/{profile}/versions/{version}.
    :vartype in_vm_access_control_profile_reference_id: str
    """

    _attribute_map = {
        "mode": {"key": "mode", "type": "str"},
        "in_vm_access_control_profile_reference_id": {"key": "inVMAccessControlProfileReferenceId", "type": "str"},
    }

    def __init__(
        self,
        *,
        mode: Optional[Union[str, "_models.Modes"]] = None,
        in_vm_access_control_profile_reference_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword mode: Specifies the execution mode. In Audit mode, the system acts as if it is
         enforcing the access control policy, including emitting access denial entries in the logs but
         it does not actually deny any requests to host endpoints. In Enforce mode, the system will
         enforce the access control and it is the recommended mode of operation. Known values are:
         "Audit", "Enforce", and "Disabled".
        :paramtype mode: str or ~azure.mgmt.compute.models.Modes
        :keyword in_vm_access_control_profile_reference_id: Specifies the
         InVMAccessControlProfileVersion resource id in the format of
         /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/inVMAccessControlProfiles/{profile}/versions/{version}.
        :paramtype in_vm_access_control_profile_reference_id: str
        """
        super().__init__(**kwargs)
        self.mode = mode
        self.in_vm_access_control_profile_reference_id = in_vm_access_control_profile_reference_id


class Image(TrackedResource):
    """The source user image virtual hard disk. The virtual hard disk will be copied before being
    attached to the virtual machine. If SourceImage is provided, the destination virtual hard drive
    must not exist.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.compute.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar extended_location: The extended location of the Image.
    :vartype extended_location: ~azure.mgmt.compute.models.ExtendedLocation
    :ivar source_virtual_machine: The source virtual machine from which Image is created.
    :vartype source_virtual_machine: ~azure.mgmt.compute.models.SubResource
    :ivar storage_profile: Specifies the storage settings for the virtual machine disks.
    :vartype storage_profile: ~azure.mgmt.compute.models.ImageStorageProfile
    :ivar provisioning_state: The provisioning state.
    :vartype provisioning_state: str
    :ivar hyper_v_generation: Specifies the HyperVGenerationType of the VirtualMachine created from
     the image. From API Version 2019-03-01 if the image source is a blob, then we need the user to
     specify the value, if the source is managed resource like disk or snapshot, we may require the
     user to specify the property if we cannot deduce it from the source managed resource. Known
     values are: "V1" and "V2".
    :vartype hyper_v_generation: str or ~azure.mgmt.compute.models.HyperVGenerationTypes
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "source_virtual_machine": {"key": "properties.sourceVirtualMachine", "type": "SubResource"},
        "storage_profile": {"key": "properties.storageProfile", "type": "ImageStorageProfile"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "hyper_v_generation": {"key": "properties.hyperVGeneration", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        source_virtual_machine: Optional["_models.SubResource"] = None,
        storage_profile: Optional["_models.ImageStorageProfile"] = None,
        hyper_v_generation: Optional[Union[str, "_models.HyperVGenerationTypes"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword extended_location: The extended location of the Image.
        :paramtype extended_location: ~azure.mgmt.compute.models.ExtendedLocation
        :keyword source_virtual_machine: The source virtual machine from which Image is created.
        :paramtype source_virtual_machine: ~azure.mgmt.compute.models.SubResource
        :keyword storage_profile: Specifies the storage settings for the virtual machine disks.
        :paramtype storage_profile: ~azure.mgmt.compute.models.ImageStorageProfile
        :keyword hyper_v_generation: Specifies the HyperVGenerationType of the VirtualMachine created
         from the image. From API Version 2019-03-01 if the image source is a blob, then we need the
         user to specify the value, if the source is managed resource like disk or snapshot, we may
         require the user to specify the property if we cannot deduce it from the source managed
         resource. Known values are: "V1" and "V2".
        :paramtype hyper_v_generation: str or ~azure.mgmt.compute.models.HyperVGenerationTypes
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.extended_location = extended_location
        self.source_virtual_machine = source_virtual_machine
        self.storage_profile = storage_profile
        self.provisioning_state: Optional[str] = None
        self.hyper_v_generation = hyper_v_generation


class ImageDisk(_serialization.Model):
    """Describes a image disk.

    :ivar snapshot: The snapshot.
    :vartype snapshot: ~azure.mgmt.compute.models.SubResource
    :ivar managed_disk: The managedDisk.
    :vartype managed_disk: ~azure.mgmt.compute.models.SubResource
    :ivar blob_uri: The Virtual Hard Disk.
    :vartype blob_uri: str
    :ivar caching: Specifies the caching requirements. Possible values are: **None,** **ReadOnly,**
     **ReadWrite.** The default values are: **None for Standard storage. ReadOnly for Premium
     storage.**. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype caching: str or ~azure.mgmt.compute.models.CachingTypes
    :ivar disk_size_gb: Specifies the size of empty data disks in gigabytes. This element can be
     used to overwrite the name of the disk in a virtual machine image. This value cannot be larger
     than 1023 GB.
    :vartype disk_size_gb: int
    :ivar storage_account_type: Specifies the storage account type for the managed disk. NOTE:
     UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk. Known values
     are: "Standard_LRS", "Premium_LRS", "StandardSSD_LRS", "UltraSSD_LRS", "Premium_ZRS",
     "StandardSSD_ZRS", and "PremiumV2_LRS".
    :vartype storage_account_type: str or ~azure.mgmt.compute.models.StorageAccountTypes
    :ivar disk_encryption_set: Specifies the customer managed disk encryption set resource id for
     the managed image disk.
    :vartype disk_encryption_set: ~azure.mgmt.compute.models.DiskEncryptionSetParameters
    """

    _attribute_map = {
        "snapshot": {"key": "snapshot", "type": "SubResource"},
        "managed_disk": {"key": "managedDisk", "type": "SubResource"},
        "blob_uri": {"key": "blobUri", "type": "str"},
        "caching": {"key": "caching", "type": "str"},
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
        "storage_account_type": {"key": "storageAccountType", "type": "str"},
        "disk_encryption_set": {"key": "diskEncryptionSet", "type": "DiskEncryptionSetParameters"},
    }

    def __init__(
        self,
        *,
        snapshot: Optional["_models.SubResource"] = None,
        managed_disk: Optional["_models.SubResource"] = None,
        blob_uri: Optional[str] = None,
        caching: Optional[Union[str, "_models.CachingTypes"]] = None,
        disk_size_gb: Optional[int] = None,
        storage_account_type: Optional[Union[str, "_models.StorageAccountTypes"]] = None,
        disk_encryption_set: Optional["_models.DiskEncryptionSetParameters"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword snapshot: The snapshot.
        :paramtype snapshot: ~azure.mgmt.compute.models.SubResource
        :keyword managed_disk: The managedDisk.
        :paramtype managed_disk: ~azure.mgmt.compute.models.SubResource
        :keyword blob_uri: The Virtual Hard Disk.
        :paramtype blob_uri: str
        :keyword caching: Specifies the caching requirements. Possible values are: **None,**
         **ReadOnly,** **ReadWrite.** The default values are: **None for Standard storage. ReadOnly for
         Premium storage.**. Known values are: "None", "ReadOnly", and "ReadWrite".
        :paramtype caching: str or ~azure.mgmt.compute.models.CachingTypes
        :keyword disk_size_gb: Specifies the size of empty data disks in gigabytes. This element can be
         used to overwrite the name of the disk in a virtual machine image. This value cannot be larger
         than 1023 GB.
        :paramtype disk_size_gb: int
        :keyword storage_account_type: Specifies the storage account type for the managed disk. NOTE:
         UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk. Known values
         are: "Standard_LRS", "Premium_LRS", "StandardSSD_LRS", "UltraSSD_LRS", "Premium_ZRS",
         "StandardSSD_ZRS", and "PremiumV2_LRS".
        :paramtype storage_account_type: str or ~azure.mgmt.compute.models.StorageAccountTypes
        :keyword disk_encryption_set: Specifies the customer managed disk encryption set resource id
         for the managed image disk.
        :paramtype disk_encryption_set: ~azure.mgmt.compute.models.DiskEncryptionSetParameters
        """
        super().__init__(**kwargs)
        self.snapshot = snapshot
        self.managed_disk = managed_disk
        self.blob_uri = blob_uri
        self.caching = caching
        self.disk_size_gb = disk_size_gb
        self.storage_account_type = storage_account_type
        self.disk_encryption_set = disk_encryption_set


class ImageDataDisk(ImageDisk):
    """Describes a data disk.

    All required parameters must be populated in order to send to server.

    :ivar snapshot: The snapshot.
    :vartype snapshot: ~azure.mgmt.compute.models.SubResource
    :ivar managed_disk: The managedDisk.
    :vartype managed_disk: ~azure.mgmt.compute.models.SubResource
    :ivar blob_uri: The Virtual Hard Disk.
    :vartype blob_uri: str
    :ivar caching: Specifies the caching requirements. Possible values are: **None,** **ReadOnly,**
     **ReadWrite.** The default values are: **None for Standard storage. ReadOnly for Premium
     storage.**. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype caching: str or ~azure.mgmt.compute.models.CachingTypes
    :ivar disk_size_gb: Specifies the size of empty data disks in gigabytes. This element can be
     used to overwrite the name of the disk in a virtual machine image. This value cannot be larger
     than 1023 GB.
    :vartype disk_size_gb: int
    :ivar storage_account_type: Specifies the storage account type for the managed disk. NOTE:
     UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk. Known values
     are: "Standard_LRS", "Premium_LRS", "StandardSSD_LRS", "UltraSSD_LRS", "Premium_ZRS",
     "StandardSSD_ZRS", and "PremiumV2_LRS".
    :vartype storage_account_type: str or ~azure.mgmt.compute.models.StorageAccountTypes
    :ivar disk_encryption_set: Specifies the customer managed disk encryption set resource id for
     the managed image disk.
    :vartype disk_encryption_set: ~azure.mgmt.compute.models.DiskEncryptionSetParameters
    :ivar lun: Specifies the logical unit number of the data disk. This value is used to identify
     data disks within the VM and therefore must be unique for each data disk attached to a VM.
     Required.
    :vartype lun: int
    """

    _validation = {
        "lun": {"required": True},
    }

    _attribute_map = {
        "snapshot": {"key": "snapshot", "type": "SubResource"},
        "managed_disk": {"key": "managedDisk", "type": "SubResource"},
        "blob_uri": {"key": "blobUri", "type": "str"},
        "caching": {"key": "caching", "type": "str"},
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
        "storage_account_type": {"key": "storageAccountType", "type": "str"},
        "disk_encryption_set": {"key": "diskEncryptionSet", "type": "DiskEncryptionSetParameters"},
        "lun": {"key": "lun", "type": "int"},
    }

    def __init__(
        self,
        *,
        lun: int,
        snapshot: Optional["_models.SubResource"] = None,
        managed_disk: Optional["_models.SubResource"] = None,
        blob_uri: Optional[str] = None,
        caching: Optional[Union[str, "_models.CachingTypes"]] = None,
        disk_size_gb: Optional[int] = None,
        storage_account_type: Optional[Union[str, "_models.StorageAccountTypes"]] = None,
        disk_encryption_set: Optional["_models.DiskEncryptionSetParameters"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword snapshot: The snapshot.
        :paramtype snapshot: ~azure.mgmt.compute.models.SubResource
        :keyword managed_disk: The managedDisk.
        :paramtype managed_disk: ~azure.mgmt.compute.models.SubResource
        :keyword blob_uri: The Virtual Hard Disk.
        :paramtype blob_uri: str
        :keyword caching: Specifies the caching requirements. Possible values are: **None,**
         **ReadOnly,** **ReadWrite.** The default values are: **None for Standard storage. ReadOnly for
         Premium storage.**. Known values are: "None", "ReadOnly", and "ReadWrite".
        :paramtype caching: str or ~azure.mgmt.compute.models.CachingTypes
        :keyword disk_size_gb: Specifies the size of empty data disks in gigabytes. This element can be
         used to overwrite the name of the disk in a virtual machine image. This value cannot be larger
         than 1023 GB.
        :paramtype disk_size_gb: int
        :keyword storage_account_type: Specifies the storage account type for the managed disk. NOTE:
         UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk. Known values
         are: "Standard_LRS", "Premium_LRS", "StandardSSD_LRS", "UltraSSD_LRS", "Premium_ZRS",
         "StandardSSD_ZRS", and "PremiumV2_LRS".
        :paramtype storage_account_type: str or ~azure.mgmt.compute.models.StorageAccountTypes
        :keyword disk_encryption_set: Specifies the customer managed disk encryption set resource id
         for the managed image disk.
        :paramtype disk_encryption_set: ~azure.mgmt.compute.models.DiskEncryptionSetParameters
        :keyword lun: Specifies the logical unit number of the data disk. This value is used to
         identify data disks within the VM and therefore must be unique for each data disk attached to a
         VM. Required.
        :paramtype lun: int
        """
        super().__init__(
            snapshot=snapshot,
            managed_disk=managed_disk,
            blob_uri=blob_uri,
            caching=caching,
            disk_size_gb=disk_size_gb,
            storage_account_type=storage_account_type,
            disk_encryption_set=disk_encryption_set,
            **kwargs
        )
        self.lun = lun


class ImageDeprecationStatus(_serialization.Model):
    """Describes image deprecation status properties on the image.

    :ivar image_state: Describes the state of the image. Known values are: "Active",
     "ScheduledForDeprecation", and "Deprecated".
    :vartype image_state: str or ~azure.mgmt.compute.models.ImageState
    :ivar scheduled_deprecation_time: The time, in future, at which this image will be marked as
     deprecated. This scheduled time is chosen by the Publisher.
    :vartype scheduled_deprecation_time: ~datetime.datetime
    :ivar alternative_option: Describes the alternative option specified by the Publisher for this
     image when this image is deprecated.
    :vartype alternative_option: ~azure.mgmt.compute.models.AlternativeOption
    """

    _attribute_map = {
        "image_state": {"key": "imageState", "type": "str"},
        "scheduled_deprecation_time": {"key": "scheduledDeprecationTime", "type": "iso-8601"},
        "alternative_option": {"key": "alternativeOption", "type": "AlternativeOption"},
    }

    def __init__(
        self,
        *,
        image_state: Optional[Union[str, "_models.ImageState"]] = None,
        scheduled_deprecation_time: Optional[datetime.datetime] = None,
        alternative_option: Optional["_models.AlternativeOption"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword image_state: Describes the state of the image. Known values are: "Active",
         "ScheduledForDeprecation", and "Deprecated".
        :paramtype image_state: str or ~azure.mgmt.compute.models.ImageState
        :keyword scheduled_deprecation_time: The time, in future, at which this image will be marked as
         deprecated. This scheduled time is chosen by the Publisher.
        :paramtype scheduled_deprecation_time: ~datetime.datetime
        :keyword alternative_option: Describes the alternative option specified by the Publisher for
         this image when this image is deprecated.
        :paramtype alternative_option: ~azure.mgmt.compute.models.AlternativeOption
        """
        super().__init__(**kwargs)
        self.image_state = image_state
        self.scheduled_deprecation_time = scheduled_deprecation_time
        self.alternative_option = alternative_option


class ImageDiskReference(_serialization.Model):
    """The source image used for creating the disk.

    :ivar id: A relative uri containing either a Platform Image Repository, user image, or Azure
     Compute Gallery image reference.
    :vartype id: str
    :ivar shared_gallery_image_id: A relative uri containing a direct shared Azure Compute Gallery
     image reference.
    :vartype shared_gallery_image_id: str
    :ivar community_gallery_image_id: A relative uri containing a community Azure Compute Gallery
     image reference.
    :vartype community_gallery_image_id: str
    :ivar lun: If the disk is created from an image's data disk, this is an index that indicates
     which of the data disks in the image to use. For OS disks, this field is null.
    :vartype lun: int
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "shared_gallery_image_id": {"key": "sharedGalleryImageId", "type": "str"},
        "community_gallery_image_id": {"key": "communityGalleryImageId", "type": "str"},
        "lun": {"key": "lun", "type": "int"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        shared_gallery_image_id: Optional[str] = None,
        community_gallery_image_id: Optional[str] = None,
        lun: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: A relative uri containing either a Platform Image Repository, user image, or Azure
         Compute Gallery image reference.
        :paramtype id: str
        :keyword shared_gallery_image_id: A relative uri containing a direct shared Azure Compute
         Gallery image reference.
        :paramtype shared_gallery_image_id: str
        :keyword community_gallery_image_id: A relative uri containing a community Azure Compute
         Gallery image reference.
        :paramtype community_gallery_image_id: str
        :keyword lun: If the disk is created from an image's data disk, this is an index that indicates
         which of the data disks in the image to use. For OS disks, this field is null.
        :paramtype lun: int
        """
        super().__init__(**kwargs)
        self.id = id
        self.shared_gallery_image_id = shared_gallery_image_id
        self.community_gallery_image_id = community_gallery_image_id
        self.lun = lun


class ImageListResult(_serialization.Model):
    """The List Image operation response.

    All required parameters must be populated in order to send to server.

    :ivar value: The list of Images. Required.
    :vartype value: list[~azure.mgmt.compute.models.Image]
    :ivar next_link: The uri to fetch the next page of Images. Call ListNext() with this to fetch
     the next page of Images.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Image]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: list["_models.Image"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of Images. Required.
        :paramtype value: list[~azure.mgmt.compute.models.Image]
        :keyword next_link: The uri to fetch the next page of Images. Call ListNext() with this to
         fetch the next page of Images.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ImageOSDisk(ImageDisk):
    """Describes an Operating System disk.

    All required parameters must be populated in order to send to server.

    :ivar snapshot: The snapshot.
    :vartype snapshot: ~azure.mgmt.compute.models.SubResource
    :ivar managed_disk: The managedDisk.
    :vartype managed_disk: ~azure.mgmt.compute.models.SubResource
    :ivar blob_uri: The Virtual Hard Disk.
    :vartype blob_uri: str
    :ivar caching: Specifies the caching requirements. Possible values are: **None,** **ReadOnly,**
     **ReadWrite.** The default values are: **None for Standard storage. ReadOnly for Premium
     storage.**. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype caching: str or ~azure.mgmt.compute.models.CachingTypes
    :ivar disk_size_gb: Specifies the size of empty data disks in gigabytes. This element can be
     used to overwrite the name of the disk in a virtual machine image. This value cannot be larger
     than 1023 GB.
    :vartype disk_size_gb: int
    :ivar storage_account_type: Specifies the storage account type for the managed disk. NOTE:
     UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk. Known values
     are: "Standard_LRS", "Premium_LRS", "StandardSSD_LRS", "UltraSSD_LRS", "Premium_ZRS",
     "StandardSSD_ZRS", and "PremiumV2_LRS".
    :vartype storage_account_type: str or ~azure.mgmt.compute.models.StorageAccountTypes
    :ivar disk_encryption_set: Specifies the customer managed disk encryption set resource id for
     the managed image disk.
    :vartype disk_encryption_set: ~azure.mgmt.compute.models.DiskEncryptionSetParameters
    :ivar os_type: This property allows you to specify the type of the OS that is included in the
     disk if creating a VM from a custom image. Possible values are: **Windows,** **Linux.**.
     Required. Known values are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
    :ivar os_state: The OS State. For managed images, use Generalized. Required. Known values are:
     "Generalized" and "Specialized".
    :vartype os_state: str or ~azure.mgmt.compute.models.OperatingSystemStateTypes
    """

    _validation = {
        "os_type": {"required": True},
        "os_state": {"required": True},
    }

    _attribute_map = {
        "snapshot": {"key": "snapshot", "type": "SubResource"},
        "managed_disk": {"key": "managedDisk", "type": "SubResource"},
        "blob_uri": {"key": "blobUri", "type": "str"},
        "caching": {"key": "caching", "type": "str"},
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
        "storage_account_type": {"key": "storageAccountType", "type": "str"},
        "disk_encryption_set": {"key": "diskEncryptionSet", "type": "DiskEncryptionSetParameters"},
        "os_type": {"key": "osType", "type": "str"},
        "os_state": {"key": "osState", "type": "str"},
    }

    def __init__(
        self,
        *,
        os_type: Union[str, "_models.OperatingSystemTypes"],
        os_state: Union[str, "_models.OperatingSystemStateTypes"],
        snapshot: Optional["_models.SubResource"] = None,
        managed_disk: Optional["_models.SubResource"] = None,
        blob_uri: Optional[str] = None,
        caching: Optional[Union[str, "_models.CachingTypes"]] = None,
        disk_size_gb: Optional[int] = None,
        storage_account_type: Optional[Union[str, "_models.StorageAccountTypes"]] = None,
        disk_encryption_set: Optional["_models.DiskEncryptionSetParameters"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword snapshot: The snapshot.
        :paramtype snapshot: ~azure.mgmt.compute.models.SubResource
        :keyword managed_disk: The managedDisk.
        :paramtype managed_disk: ~azure.mgmt.compute.models.SubResource
        :keyword blob_uri: The Virtual Hard Disk.
        :paramtype blob_uri: str
        :keyword caching: Specifies the caching requirements. Possible values are: **None,**
         **ReadOnly,** **ReadWrite.** The default values are: **None for Standard storage. ReadOnly for
         Premium storage.**. Known values are: "None", "ReadOnly", and "ReadWrite".
        :paramtype caching: str or ~azure.mgmt.compute.models.CachingTypes
        :keyword disk_size_gb: Specifies the size of empty data disks in gigabytes. This element can be
         used to overwrite the name of the disk in a virtual machine image. This value cannot be larger
         than 1023 GB.
        :paramtype disk_size_gb: int
        :keyword storage_account_type: Specifies the storage account type for the managed disk. NOTE:
         UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk. Known values
         are: "Standard_LRS", "Premium_LRS", "StandardSSD_LRS", "UltraSSD_LRS", "Premium_ZRS",
         "StandardSSD_ZRS", and "PremiumV2_LRS".
        :paramtype storage_account_type: str or ~azure.mgmt.compute.models.StorageAccountTypes
        :keyword disk_encryption_set: Specifies the customer managed disk encryption set resource id
         for the managed image disk.
        :paramtype disk_encryption_set: ~azure.mgmt.compute.models.DiskEncryptionSetParameters
        :keyword os_type: This property allows you to specify the type of the OS that is included in
         the disk if creating a VM from a custom image. Possible values are: **Windows,** **Linux.**.
         Required. Known values are: "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
        :keyword os_state: The OS State. For managed images, use Generalized. Required. Known values
         are: "Generalized" and "Specialized".
        :paramtype os_state: str or ~azure.mgmt.compute.models.OperatingSystemStateTypes
        """
        super().__init__(
            snapshot=snapshot,
            managed_disk=managed_disk,
            blob_uri=blob_uri,
            caching=caching,
            disk_size_gb=disk_size_gb,
            storage_account_type=storage_account_type,
            disk_encryption_set=disk_encryption_set,
            **kwargs
        )
        self.os_type = os_type
        self.os_state = os_state


class ImagePurchasePlan(_serialization.Model):
    """Describes the gallery image definition purchase plan. This is used by marketplace images.

    :ivar name: The plan ID.
    :vartype name: str
    :ivar publisher: The publisher ID.
    :vartype publisher: str
    :ivar product: The product ID.
    :vartype product: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "publisher": {"key": "publisher", "type": "str"},
        "product": {"key": "product", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        publisher: Optional[str] = None,
        product: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The plan ID.
        :paramtype name: str
        :keyword publisher: The publisher ID.
        :paramtype publisher: str
        :keyword product: The product ID.
        :paramtype product: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.publisher = publisher
        self.product = product


class ImageReference(SubResource):
    """Specifies information about the image to use. You can specify information about platform
    images, marketplace images, or virtual machine images. This element is required when you want
    to use a platform image, marketplace image, or virtual machine image, but is not used in other
    creation operations. NOTE: Image reference publisher and offer can only be set when you create
    the scale set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar publisher: The image publisher.
    :vartype publisher: str
    :ivar offer: Specifies the offer of the platform image or marketplace image used to create the
     virtual machine.
    :vartype offer: str
    :ivar sku: The image SKU.
    :vartype sku: str
    :ivar version: Specifies the version of the platform image or marketplace image used to create
     the virtual machine. The allowed formats are Major.Minor.Build or 'latest'. Major, Minor, and
     Build are decimal numbers. Specify 'latest' to use the latest version of an image available at
     deploy time. Even if you use 'latest', the VM image will not automatically update after deploy
     time even if a new version becomes available. Please do not use field 'version' for gallery
     image deployment, gallery image should always use 'id' field for deployment, to use 'latest'
     version of gallery image, just set
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageName}'
     in the 'id' field without version input.
    :vartype version: str
    :ivar exact_version: Specifies in decimal numbers, the version of platform image or marketplace
     image used to create the virtual machine. This readonly field differs from 'version', only if
     the value specified in 'version' field is 'latest'.
    :vartype exact_version: str
    :ivar shared_gallery_image_id: Specified the shared gallery image unique id for vm deployment.
     This can be fetched from shared gallery image GET call.
    :vartype shared_gallery_image_id: str
    :ivar community_gallery_image_id: Specified the community gallery image unique id for vm
     deployment. This can be fetched from community gallery image GET call.
    :vartype community_gallery_image_id: str
    """

    _validation = {
        "exact_version": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "publisher": {"key": "publisher", "type": "str"},
        "offer": {"key": "offer", "type": "str"},
        "sku": {"key": "sku", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "exact_version": {"key": "exactVersion", "type": "str"},
        "shared_gallery_image_id": {"key": "sharedGalleryImageId", "type": "str"},
        "community_gallery_image_id": {"key": "communityGalleryImageId", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        publisher: Optional[str] = None,
        offer: Optional[str] = None,
        sku: Optional[str] = None,
        version: Optional[str] = None,
        shared_gallery_image_id: Optional[str] = None,
        community_gallery_image_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Id.
        :paramtype id: str
        :keyword publisher: The image publisher.
        :paramtype publisher: str
        :keyword offer: Specifies the offer of the platform image or marketplace image used to create
         the virtual machine.
        :paramtype offer: str
        :keyword sku: The image SKU.
        :paramtype sku: str
        :keyword version: Specifies the version of the platform image or marketplace image used to
         create the virtual machine. The allowed formats are Major.Minor.Build or 'latest'. Major,
         Minor, and Build are decimal numbers. Specify 'latest' to use the latest version of an image
         available at deploy time. Even if you use 'latest', the VM image will not automatically update
         after deploy time even if a new version becomes available. Please do not use field 'version'
         for gallery image deployment, gallery image should always use 'id' field for deployment, to use
         'latest' version of gallery image, just set
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageName}'
         in the 'id' field without version input.
        :paramtype version: str
        :keyword shared_gallery_image_id: Specified the shared gallery image unique id for vm
         deployment. This can be fetched from shared gallery image GET call.
        :paramtype shared_gallery_image_id: str
        :keyword community_gallery_image_id: Specified the community gallery image unique id for vm
         deployment. This can be fetched from community gallery image GET call.
        :paramtype community_gallery_image_id: str
        """
        super().__init__(id=id, **kwargs)
        self.publisher = publisher
        self.offer = offer
        self.sku = sku
        self.version = version
        self.exact_version: Optional[str] = None
        self.shared_gallery_image_id = shared_gallery_image_id
        self.community_gallery_image_id = community_gallery_image_id


class ImageStorageProfile(_serialization.Model):
    """Describes a storage profile.

    :ivar os_disk: Specifies information about the operating system disk used by the virtual
     machine. :code:`<br>`\\ :code:`<br>` For more information about disks, see `About disks and
     VHDs for Azure virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_.
    :vartype os_disk: ~azure.mgmt.compute.models.ImageOSDisk
    :ivar data_disks: Specifies the parameters that are used to add a data disk to a virtual
     machine. :code:`<br>`\\ :code:`<br>` For more information about disks, see `About disks and
     VHDs for Azure virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_.
    :vartype data_disks: list[~azure.mgmt.compute.models.ImageDataDisk]
    :ivar zone_resilient: Specifies whether an image is zone resilient or not. Default is false.
     Zone resilient images can be created only in regions that provide Zone Redundant Storage (ZRS).
    :vartype zone_resilient: bool
    """

    _attribute_map = {
        "os_disk": {"key": "osDisk", "type": "ImageOSDisk"},
        "data_disks": {"key": "dataDisks", "type": "[ImageDataDisk]"},
        "zone_resilient": {"key": "zoneResilient", "type": "bool"},
    }

    def __init__(
        self,
        *,
        os_disk: Optional["_models.ImageOSDisk"] = None,
        data_disks: Optional[list["_models.ImageDataDisk"]] = None,
        zone_resilient: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword os_disk: Specifies information about the operating system disk used by the virtual
         machine. :code:`<br>`\\ :code:`<br>` For more information about disks, see `About disks and
         VHDs for Azure virtual machines
         <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_.
        :paramtype os_disk: ~azure.mgmt.compute.models.ImageOSDisk
        :keyword data_disks: Specifies the parameters that are used to add a data disk to a virtual
         machine. :code:`<br>`\\ :code:`<br>` For more information about disks, see `About disks and
         VHDs for Azure virtual machines
         <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_.
        :paramtype data_disks: list[~azure.mgmt.compute.models.ImageDataDisk]
        :keyword zone_resilient: Specifies whether an image is zone resilient or not. Default is false.
         Zone resilient images can be created only in regions that provide Zone Redundant Storage (ZRS).
        :paramtype zone_resilient: bool
        """
        super().__init__(**kwargs)
        self.os_disk = os_disk
        self.data_disks = data_disks
        self.zone_resilient = zone_resilient


class ImageUpdate(UpdateResource):
    """The source user image virtual hard disk. Only tags may be updated.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar source_virtual_machine: The source virtual machine from which Image is created.
    :vartype source_virtual_machine: ~azure.mgmt.compute.models.SubResource
    :ivar storage_profile: Specifies the storage settings for the virtual machine disks.
    :vartype storage_profile: ~azure.mgmt.compute.models.ImageStorageProfile
    :ivar provisioning_state: The provisioning state.
    :vartype provisioning_state: str
    :ivar hyper_v_generation: Specifies the HyperVGenerationType of the VirtualMachine created from
     the image. From API Version 2019-03-01 if the image source is a blob, then we need the user to
     specify the value, if the source is managed resource like disk or snapshot, we may require the
     user to specify the property if we cannot deduce it from the source managed resource. Known
     values are: "V1" and "V2".
    :vartype hyper_v_generation: str or ~azure.mgmt.compute.models.HyperVGenerationTypes
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "source_virtual_machine": {"key": "properties.sourceVirtualMachine", "type": "SubResource"},
        "storage_profile": {"key": "properties.storageProfile", "type": "ImageStorageProfile"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "hyper_v_generation": {"key": "properties.hyperVGeneration", "type": "str"},
    }

    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
        source_virtual_machine: Optional["_models.SubResource"] = None,
        storage_profile: Optional["_models.ImageStorageProfile"] = None,
        hyper_v_generation: Optional[Union[str, "_models.HyperVGenerationTypes"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword source_virtual_machine: The source virtual machine from which Image is created.
        :paramtype source_virtual_machine: ~azure.mgmt.compute.models.SubResource
        :keyword storage_profile: Specifies the storage settings for the virtual machine disks.
        :paramtype storage_profile: ~azure.mgmt.compute.models.ImageStorageProfile
        :keyword hyper_v_generation: Specifies the HyperVGenerationType of the VirtualMachine created
         from the image. From API Version 2019-03-01 if the image source is a blob, then we need the
         user to specify the value, if the source is managed resource like disk or snapshot, we may
         require the user to specify the property if we cannot deduce it from the source managed
         resource. Known values are: "V1" and "V2".
        :paramtype hyper_v_generation: str or ~azure.mgmt.compute.models.HyperVGenerationTypes
        """
        super().__init__(tags=tags, **kwargs)
        self.source_virtual_machine = source_virtual_machine
        self.storage_profile = storage_profile
        self.provisioning_state: Optional[str] = None
        self.hyper_v_generation = hyper_v_generation


class ImageVersionSecurityProfile(_serialization.Model):
    """The security profile of a gallery image version.

    :ivar uefi_settings: Contains UEFI settings for the image version.
    :vartype uefi_settings: ~azure.mgmt.compute.models.GalleryImageVersionUefiSettings
    """

    _attribute_map = {
        "uefi_settings": {"key": "uefiSettings", "type": "GalleryImageVersionUefiSettings"},
    }

    def __init__(
        self, *, uefi_settings: Optional["_models.GalleryImageVersionUefiSettings"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword uefi_settings: Contains UEFI settings for the image version.
        :paramtype uefi_settings: ~azure.mgmt.compute.models.GalleryImageVersionUefiSettings
        """
        super().__init__(**kwargs)
        self.uefi_settings = uefi_settings


class InnerError(_serialization.Model):
    """Inner error details.

    :ivar exceptiontype: The exception type.
    :vartype exceptiontype: str
    :ivar errordetail: The internal error message or exception dump.
    :vartype errordetail: str
    """

    _attribute_map = {
        "exceptiontype": {"key": "exceptiontype", "type": "str"},
        "errordetail": {"key": "errordetail", "type": "str"},
    }

    def __init__(
        self, *, exceptiontype: Optional[str] = None, errordetail: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword exceptiontype: The exception type.
        :paramtype exceptiontype: str
        :keyword errordetail: The internal error message or exception dump.
        :paramtype errordetail: str
        """
        super().__init__(**kwargs)
        self.exceptiontype = exceptiontype
        self.errordetail = errordetail


class InstanceSku(_serialization.Model):
    """The role instance SKU.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The sku name.
    :vartype name: str
    :ivar tier: The tier of the cloud service role instance.
    :vartype tier: str
    """

    _validation = {
        "name": {"readonly": True},
        "tier": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.tier: Optional[str] = None


class InstanceViewStatus(_serialization.Model):
    """Instance view status.

    :ivar code: The status code.
    :vartype code: str
    :ivar level: The level code. Known values are: "Info", "Warning", and "Error".
    :vartype level: str or ~azure.mgmt.compute.models.StatusLevelTypes
    :ivar display_status: The short localizable label for the status.
    :vartype display_status: str
    :ivar message: The detailed status message, including for alerts and error messages.
    :vartype message: str
    :ivar time: The time of the status.
    :vartype time: ~datetime.datetime
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "level": {"key": "level", "type": "str"},
        "display_status": {"key": "displayStatus", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "time": {"key": "time", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        level: Optional[Union[str, "_models.StatusLevelTypes"]] = None,
        display_status: Optional[str] = None,
        message: Optional[str] = None,
        time: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: The status code.
        :paramtype code: str
        :keyword level: The level code. Known values are: "Info", "Warning", and "Error".
        :paramtype level: str or ~azure.mgmt.compute.models.StatusLevelTypes
        :keyword display_status: The short localizable label for the status.
        :paramtype display_status: str
        :keyword message: The detailed status message, including for alerts and error messages.
        :paramtype message: str
        :keyword time: The time of the status.
        :paramtype time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.code = code
        self.level = level
        self.display_status = display_status
        self.message = message
        self.time = time


class InstanceViewStatusesSummary(_serialization.Model):
    """Instance view statuses.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar statuses_summary: The summary.
    :vartype statuses_summary: list[~azure.mgmt.compute.models.StatusCodeCount]
    """

    _validation = {
        "statuses_summary": {"readonly": True},
    }

    _attribute_map = {
        "statuses_summary": {"key": "statusesSummary", "type": "[StatusCodeCount]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.statuses_summary: Optional[list["_models.StatusCodeCount"]] = None


class KeyForDiskEncryptionSet(_serialization.Model):
    """Key Vault Key Url to be used for server side encryption of Managed Disks and Snapshots.

    All required parameters must be populated in order to send to server.

    :ivar source_vault: Resource id of the KeyVault containing the key or secret. This property is
     optional and cannot be used if the KeyVault subscription is not the same as the Disk Encryption
     Set subscription.
    :vartype source_vault: ~azure.mgmt.compute.models.SourceVault
    :ivar key_url: Fully versioned Key Url pointing to a key in KeyVault. Version segment of the
     Url is required regardless of rotationToLatestKeyVersionEnabled value. Required.
    :vartype key_url: str
    """

    _validation = {
        "key_url": {"required": True},
    }

    _attribute_map = {
        "source_vault": {"key": "sourceVault", "type": "SourceVault"},
        "key_url": {"key": "keyUrl", "type": "str"},
    }

    def __init__(self, *, key_url: str, source_vault: Optional["_models.SourceVault"] = None, **kwargs: Any) -> None:
        """
        :keyword source_vault: Resource id of the KeyVault containing the key or secret. This property
         is optional and cannot be used if the KeyVault subscription is not the same as the Disk
         Encryption Set subscription.
        :paramtype source_vault: ~azure.mgmt.compute.models.SourceVault
        :keyword key_url: Fully versioned Key Url pointing to a key in KeyVault. Version segment of the
         Url is required regardless of rotationToLatestKeyVersionEnabled value. Required.
        :paramtype key_url: str
        """
        super().__init__(**kwargs)
        self.source_vault = source_vault
        self.key_url = key_url


class KeyVaultAndKeyReference(_serialization.Model):
    """Key Vault Key Url and vault id of KeK, KeK is optional and when provided is used to unwrap the
    encryptionKey.

    All required parameters must be populated in order to send to server.

    :ivar source_vault: Resource id of the KeyVault containing the key or secret. Required.
    :vartype source_vault: ~azure.mgmt.compute.models.SourceVault
    :ivar key_url: Url pointing to a key or secret in KeyVault. Required.
    :vartype key_url: str
    """

    _validation = {
        "source_vault": {"required": True},
        "key_url": {"required": True},
    }

    _attribute_map = {
        "source_vault": {"key": "sourceVault", "type": "SourceVault"},
        "key_url": {"key": "keyUrl", "type": "str"},
    }

    def __init__(self, *, source_vault: "_models.SourceVault", key_url: str, **kwargs: Any) -> None:
        """
        :keyword source_vault: Resource id of the KeyVault containing the key or secret. Required.
        :paramtype source_vault: ~azure.mgmt.compute.models.SourceVault
        :keyword key_url: Url pointing to a key or secret in KeyVault. Required.
        :paramtype key_url: str
        """
        super().__init__(**kwargs)
        self.source_vault = source_vault
        self.key_url = key_url


class KeyVaultAndSecretReference(_serialization.Model):
    """Key Vault Secret Url and vault id of the encryption key.

    All required parameters must be populated in order to send to server.

    :ivar source_vault: Resource id of the KeyVault containing the key or secret. Required.
    :vartype source_vault: ~azure.mgmt.compute.models.SourceVault
    :ivar secret_url: Url pointing to a key or secret in KeyVault. Required.
    :vartype secret_url: str
    """

    _validation = {
        "source_vault": {"required": True},
        "secret_url": {"required": True},
    }

    _attribute_map = {
        "source_vault": {"key": "sourceVault", "type": "SourceVault"},
        "secret_url": {"key": "secretUrl", "type": "str"},
    }

    def __init__(self, *, source_vault: "_models.SourceVault", secret_url: str, **kwargs: Any) -> None:
        """
        :keyword source_vault: Resource id of the KeyVault containing the key or secret. Required.
        :paramtype source_vault: ~azure.mgmt.compute.models.SourceVault
        :keyword secret_url: Url pointing to a key or secret in KeyVault. Required.
        :paramtype secret_url: str
        """
        super().__init__(**kwargs)
        self.source_vault = source_vault
        self.secret_url = secret_url


class KeyVaultKeyReference(_serialization.Model):
    """Describes a reference to Key Vault Key.

    All required parameters must be populated in order to send to server.

    :ivar key_url: The URL referencing a key encryption key in Key Vault. Required.
    :vartype key_url: str
    :ivar source_vault: The relative URL of the Key Vault containing the key. Required.
    :vartype source_vault: ~azure.mgmt.compute.models.SubResource
    """

    _validation = {
        "key_url": {"required": True},
        "source_vault": {"required": True},
    }

    _attribute_map = {
        "key_url": {"key": "keyUrl", "type": "str"},
        "source_vault": {"key": "sourceVault", "type": "SubResource"},
    }

    def __init__(self, *, key_url: str, source_vault: "_models.SubResource", **kwargs: Any) -> None:
        """
        :keyword key_url: The URL referencing a key encryption key in Key Vault. Required.
        :paramtype key_url: str
        :keyword source_vault: The relative URL of the Key Vault containing the key. Required.
        :paramtype source_vault: ~azure.mgmt.compute.models.SubResource
        """
        super().__init__(**kwargs)
        self.key_url = key_url
        self.source_vault = source_vault


class KeyVaultSecretReference(_serialization.Model):
    """Describes a reference to Key Vault Secret.

    All required parameters must be populated in order to send to server.

    :ivar secret_url: The URL referencing a secret in a Key Vault. Required.
    :vartype secret_url: str
    :ivar source_vault: The relative URL of the Key Vault containing the secret. Required.
    :vartype source_vault: ~azure.mgmt.compute.models.SubResource
    """

    _validation = {
        "secret_url": {"required": True},
        "source_vault": {"required": True},
    }

    _attribute_map = {
        "secret_url": {"key": "secretUrl", "type": "str"},
        "source_vault": {"key": "sourceVault", "type": "SubResource"},
    }

    def __init__(self, *, secret_url: str, source_vault: "_models.SubResource", **kwargs: Any) -> None:
        """
        :keyword secret_url: The URL referencing a secret in a Key Vault. Required.
        :paramtype secret_url: str
        :keyword source_vault: The relative URL of the Key Vault containing the secret. Required.
        :paramtype source_vault: ~azure.mgmt.compute.models.SubResource
        """
        super().__init__(**kwargs)
        self.secret_url = secret_url
        self.source_vault = source_vault


class LastPatchInstallationSummary(_serialization.Model):
    """Describes the properties of the last installed patch summary.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The overall success or failure status of the operation. It remains "InProgress"
     until the operation completes. At that point it will become "Unknown", "Failed", "Succeeded",
     or "CompletedWithWarnings.". Known values are: "Unknown", "InProgress", "Failed", "Succeeded",
     and "CompletedWithWarnings".
    :vartype status: str or ~azure.mgmt.compute.models.PatchOperationStatus
    :ivar installation_activity_id: The activity ID of the operation that produced this result. It
     is used to correlate across CRP and extension logs.
    :vartype installation_activity_id: str
    :ivar maintenance_window_exceeded: Describes whether the operation ran out of time before it
     completed all its intended actions.
    :vartype maintenance_window_exceeded: bool
    :ivar not_selected_patch_count: The number of all available patches but not going to be
     installed because it didn't match a classification or inclusion list entry.
    :vartype not_selected_patch_count: int
    :ivar excluded_patch_count: The number of all available patches but excluded explicitly by a
     customer-specified exclusion list match.
    :vartype excluded_patch_count: int
    :ivar pending_patch_count: The number of all available patches expected to be installed over
     the course of the patch installation operation.
    :vartype pending_patch_count: int
    :ivar installed_patch_count: The count of patches that successfully installed.
    :vartype installed_patch_count: int
    :ivar failed_patch_count: The count of patches that failed installation.
    :vartype failed_patch_count: int
    :ivar start_time: The UTC timestamp when the operation began.
    :vartype start_time: ~datetime.datetime
    :ivar last_modified_time: The UTC timestamp when the operation began.
    :vartype last_modified_time: ~datetime.datetime
    :ivar error: The errors that were encountered during execution of the operation. The details
     array contains the list of them.
    :vartype error: ~azure.mgmt.compute.models.ApiError
    """

    _validation = {
        "status": {"readonly": True},
        "installation_activity_id": {"readonly": True},
        "maintenance_window_exceeded": {"readonly": True},
        "not_selected_patch_count": {"readonly": True},
        "excluded_patch_count": {"readonly": True},
        "pending_patch_count": {"readonly": True},
        "installed_patch_count": {"readonly": True},
        "failed_patch_count": {"readonly": True},
        "start_time": {"readonly": True},
        "last_modified_time": {"readonly": True},
        "error": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "installation_activity_id": {"key": "installationActivityId", "type": "str"},
        "maintenance_window_exceeded": {"key": "maintenanceWindowExceeded", "type": "bool"},
        "not_selected_patch_count": {"key": "notSelectedPatchCount", "type": "int"},
        "excluded_patch_count": {"key": "excludedPatchCount", "type": "int"},
        "pending_patch_count": {"key": "pendingPatchCount", "type": "int"},
        "installed_patch_count": {"key": "installedPatchCount", "type": "int"},
        "failed_patch_count": {"key": "failedPatchCount", "type": "int"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "last_modified_time": {"key": "lastModifiedTime", "type": "iso-8601"},
        "error": {"key": "error", "type": "ApiError"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.status: Optional[Union[str, "_models.PatchOperationStatus"]] = None
        self.installation_activity_id: Optional[str] = None
        self.maintenance_window_exceeded: Optional[bool] = None
        self.not_selected_patch_count: Optional[int] = None
        self.excluded_patch_count: Optional[int] = None
        self.pending_patch_count: Optional[int] = None
        self.installed_patch_count: Optional[int] = None
        self.failed_patch_count: Optional[int] = None
        self.start_time: Optional[datetime.datetime] = None
        self.last_modified_time: Optional[datetime.datetime] = None
        self.error: Optional["_models.ApiError"] = None


class LinuxConfiguration(_serialization.Model):
    """Specifies the Linux operating system settings on the virtual machine. For a list of supported
    Linux distributions, see `Linux on Azure-Endorsed Distributions
    <https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros>`_.

    :ivar disable_password_authentication: Specifies whether password authentication should be
     disabled.
    :vartype disable_password_authentication: bool
    :ivar ssh: Specifies the ssh key configuration for a Linux OS.
    :vartype ssh: ~azure.mgmt.compute.models.SshConfiguration
    :ivar provision_vm_agent: Indicates whether virtual machine agent should be provisioned on the
     virtual machine. When this property is not specified in the request body, default behavior is
     to set it to true. This will ensure that VM Agent is installed on the VM so that extensions can
     be added to the VM later.
    :vartype provision_vm_agent: bool
    :ivar patch_settings: [Preview Feature] Specifies settings related to VM Guest Patching on
     Linux.
    :vartype patch_settings: ~azure.mgmt.compute.models.LinuxPatchSettings
    :ivar enable_vm_agent_platform_updates: Indicates whether VMAgent Platform Updates is enabled
     for the Linux virtual machine. Default value is false.
    :vartype enable_vm_agent_platform_updates: bool
    """

    _attribute_map = {
        "disable_password_authentication": {"key": "disablePasswordAuthentication", "type": "bool"},
        "ssh": {"key": "ssh", "type": "SshConfiguration"},
        "provision_vm_agent": {"key": "provisionVMAgent", "type": "bool"},
        "patch_settings": {"key": "patchSettings", "type": "LinuxPatchSettings"},
        "enable_vm_agent_platform_updates": {"key": "enableVMAgentPlatformUpdates", "type": "bool"},
    }

    def __init__(
        self,
        *,
        disable_password_authentication: Optional[bool] = None,
        ssh: Optional["_models.SshConfiguration"] = None,
        provision_vm_agent: Optional[bool] = None,
        patch_settings: Optional["_models.LinuxPatchSettings"] = None,
        enable_vm_agent_platform_updates: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword disable_password_authentication: Specifies whether password authentication should be
         disabled.
        :paramtype disable_password_authentication: bool
        :keyword ssh: Specifies the ssh key configuration for a Linux OS.
        :paramtype ssh: ~azure.mgmt.compute.models.SshConfiguration
        :keyword provision_vm_agent: Indicates whether virtual machine agent should be provisioned on
         the virtual machine. When this property is not specified in the request body, default behavior
         is to set it to true. This will ensure that VM Agent is installed on the VM so that extensions
         can be added to the VM later.
        :paramtype provision_vm_agent: bool
        :keyword patch_settings: [Preview Feature] Specifies settings related to VM Guest Patching on
         Linux.
        :paramtype patch_settings: ~azure.mgmt.compute.models.LinuxPatchSettings
        :keyword enable_vm_agent_platform_updates: Indicates whether VMAgent Platform Updates is
         enabled for the Linux virtual machine. Default value is false.
        :paramtype enable_vm_agent_platform_updates: bool
        """
        super().__init__(**kwargs)
        self.disable_password_authentication = disable_password_authentication
        self.ssh = ssh
        self.provision_vm_agent = provision_vm_agent
        self.patch_settings = patch_settings
        self.enable_vm_agent_platform_updates = enable_vm_agent_platform_updates


class LinuxParameters(_serialization.Model):
    """Input for InstallPatches on a Linux VM, as directly received by the API.

    :ivar classifications_to_include: The update classifications to select when installing patches
     for Linux.
    :vartype classifications_to_include: list[str or
     ~azure.mgmt.compute.models.VMGuestPatchClassificationLinux]
    :ivar package_name_masks_to_include: packages to include in the patch operation. Format:
     packageName_packageVersion.
    :vartype package_name_masks_to_include: list[str]
    :ivar package_name_masks_to_exclude: packages to exclude in the patch operation. Format:
     packageName_packageVersion.
    :vartype package_name_masks_to_exclude: list[str]
    :ivar maintenance_run_id: This is used as a maintenance run identifier for Auto VM Guest
     Patching in Linux.
    :vartype maintenance_run_id: str
    """

    _attribute_map = {
        "classifications_to_include": {"key": "classificationsToInclude", "type": "[str]"},
        "package_name_masks_to_include": {"key": "packageNameMasksToInclude", "type": "[str]"},
        "package_name_masks_to_exclude": {"key": "packageNameMasksToExclude", "type": "[str]"},
        "maintenance_run_id": {"key": "maintenanceRunId", "type": "str"},
    }

    def __init__(
        self,
        *,
        classifications_to_include: Optional[list[Union[str, "_models.VMGuestPatchClassificationLinux"]]] = None,
        package_name_masks_to_include: Optional[list[str]] = None,
        package_name_masks_to_exclude: Optional[list[str]] = None,
        maintenance_run_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword classifications_to_include: The update classifications to select when installing
         patches for Linux.
        :paramtype classifications_to_include: list[str or
         ~azure.mgmt.compute.models.VMGuestPatchClassificationLinux]
        :keyword package_name_masks_to_include: packages to include in the patch operation. Format:
         packageName_packageVersion.
        :paramtype package_name_masks_to_include: list[str]
        :keyword package_name_masks_to_exclude: packages to exclude in the patch operation. Format:
         packageName_packageVersion.
        :paramtype package_name_masks_to_exclude: list[str]
        :keyword maintenance_run_id: This is used as a maintenance run identifier for Auto VM Guest
         Patching in Linux.
        :paramtype maintenance_run_id: str
        """
        super().__init__(**kwargs)
        self.classifications_to_include = classifications_to_include
        self.package_name_masks_to_include = package_name_masks_to_include
        self.package_name_masks_to_exclude = package_name_masks_to_exclude
        self.maintenance_run_id = maintenance_run_id


class LinuxPatchSettings(_serialization.Model):
    """Specifies settings related to VM Guest Patching on Linux.

    :ivar patch_mode: Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual
     machines associated to virtual machine scale set with OrchestrationMode as Flexible.\\
     :code:`<br />`\\ :code:`<br />` Possible values are:\\ :code:`<br />`\\ :code:`<br />`
     **ImageDefault** - The virtual machine's default patching configuration is used. :code:`<br
     />`\\ :code:`<br />` **AutomaticByPlatform** - The virtual machine will be automatically
     updated by the platform. The property provisionVMAgent must be true. Known values are:
     "ImageDefault" and "AutomaticByPlatform".
    :vartype patch_mode: str or ~azure.mgmt.compute.models.LinuxVMGuestPatchMode
    :ivar assessment_mode: Specifies the mode of VM Guest Patch Assessment for the IaaS virtual
     machine.\\ :code:`<br />`\\ :code:`<br />` Possible values are:\\ :code:`<br />`\\ :code:`<br
     />` **ImageDefault** - You control the timing of patch assessments on a virtual machine.
     :code:`<br />`\\ :code:`<br />` **AutomaticByPlatform** - The platform will trigger periodic
     patch assessments. The property provisionVMAgent must be true. Known values are: "ImageDefault"
     and "AutomaticByPlatform".
    :vartype assessment_mode: str or ~azure.mgmt.compute.models.LinuxPatchAssessmentMode
    :ivar automatic_by_platform_settings: Specifies additional settings for patch mode
     AutomaticByPlatform in VM Guest Patching on Linux.
    :vartype automatic_by_platform_settings:
     ~azure.mgmt.compute.models.LinuxVMGuestPatchAutomaticByPlatformSettings
    """

    _attribute_map = {
        "patch_mode": {"key": "patchMode", "type": "str"},
        "assessment_mode": {"key": "assessmentMode", "type": "str"},
        "automatic_by_platform_settings": {
            "key": "automaticByPlatformSettings",
            "type": "LinuxVMGuestPatchAutomaticByPlatformSettings",
        },
    }

    def __init__(
        self,
        *,
        patch_mode: Optional[Union[str, "_models.LinuxVMGuestPatchMode"]] = None,
        assessment_mode: Optional[Union[str, "_models.LinuxPatchAssessmentMode"]] = None,
        automatic_by_platform_settings: Optional["_models.LinuxVMGuestPatchAutomaticByPlatformSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword patch_mode: Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual
         machines associated to virtual machine scale set with OrchestrationMode as Flexible.\\
         :code:`<br />`\\ :code:`<br />` Possible values are:\\ :code:`<br />`\\ :code:`<br />`
         **ImageDefault** - The virtual machine's default patching configuration is used. :code:`<br
         />`\\ :code:`<br />` **AutomaticByPlatform** - The virtual machine will be automatically
         updated by the platform. The property provisionVMAgent must be true. Known values are:
         "ImageDefault" and "AutomaticByPlatform".
        :paramtype patch_mode: str or ~azure.mgmt.compute.models.LinuxVMGuestPatchMode
        :keyword assessment_mode: Specifies the mode of VM Guest Patch Assessment for the IaaS virtual
         machine.\\ :code:`<br />`\\ :code:`<br />` Possible values are:\\ :code:`<br />`\\ :code:`<br
         />` **ImageDefault** - You control the timing of patch assessments on a virtual machine.
         :code:`<br />`\\ :code:`<br />` **AutomaticByPlatform** - The platform will trigger periodic
         patch assessments. The property provisionVMAgent must be true. Known values are: "ImageDefault"
         and "AutomaticByPlatform".
        :paramtype assessment_mode: str or ~azure.mgmt.compute.models.LinuxPatchAssessmentMode
        :keyword automatic_by_platform_settings: Specifies additional settings for patch mode
         AutomaticByPlatform in VM Guest Patching on Linux.
        :paramtype automatic_by_platform_settings:
         ~azure.mgmt.compute.models.LinuxVMGuestPatchAutomaticByPlatformSettings
        """
        super().__init__(**kwargs)
        self.patch_mode = patch_mode
        self.assessment_mode = assessment_mode
        self.automatic_by_platform_settings = automatic_by_platform_settings


class LinuxVMGuestPatchAutomaticByPlatformSettings(_serialization.Model):  # pylint: disable=name-too-long
    """Specifies additional settings to be applied when patch mode AutomaticByPlatform is selected in
    Linux patch settings.

    :ivar reboot_setting: Specifies the reboot setting for all AutomaticByPlatform patch
     installation operations. Known values are: "Unknown", "IfRequired", "Never", and "Always".
    :vartype reboot_setting: str or
     ~azure.mgmt.compute.models.LinuxVMGuestPatchAutomaticByPlatformRebootSetting
    :ivar bypass_platform_safety_checks_on_user_schedule: Enables customer to schedule patching
     without accidental upgrades.
    :vartype bypass_platform_safety_checks_on_user_schedule: bool
    """

    _attribute_map = {
        "reboot_setting": {"key": "rebootSetting", "type": "str"},
        "bypass_platform_safety_checks_on_user_schedule": {
            "key": "bypassPlatformSafetyChecksOnUserSchedule",
            "type": "bool",
        },
    }

    def __init__(
        self,
        *,
        reboot_setting: Optional[Union[str, "_models.LinuxVMGuestPatchAutomaticByPlatformRebootSetting"]] = None,
        bypass_platform_safety_checks_on_user_schedule: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword reboot_setting: Specifies the reboot setting for all AutomaticByPlatform patch
         installation operations. Known values are: "Unknown", "IfRequired", "Never", and "Always".
        :paramtype reboot_setting: str or
         ~azure.mgmt.compute.models.LinuxVMGuestPatchAutomaticByPlatformRebootSetting
        :keyword bypass_platform_safety_checks_on_user_schedule: Enables customer to schedule patching
         without accidental upgrades.
        :paramtype bypass_platform_safety_checks_on_user_schedule: bool
        """
        super().__init__(**kwargs)
        self.reboot_setting = reboot_setting
        self.bypass_platform_safety_checks_on_user_schedule = bypass_platform_safety_checks_on_user_schedule


class ListUsagesResult(_serialization.Model):
    """The List Usages operation response.

    All required parameters must be populated in order to send to server.

    :ivar value: The list of compute resource usages. Required.
    :vartype value: list[~azure.mgmt.compute.models.Usage]
    :ivar next_link: The URI to fetch the next page of compute resource usage information. Call
     ListNext() with this to fetch the next page of compute resource usage information.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Usage]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: list["_models.Usage"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of compute resource usages. Required.
        :paramtype value: list[~azure.mgmt.compute.models.Usage]
        :keyword next_link: The URI to fetch the next page of compute resource usage information. Call
         ListNext() with this to fetch the next page of compute resource usage information.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class LoadBalancerConfiguration(_serialization.Model):
    """Describes the load balancer configuration.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: The name of the Load balancer. Required.
    :vartype name: str
    :ivar properties: Properties of the load balancer configuration. Required.
    :vartype properties: ~azure.mgmt.compute.models.LoadBalancerConfigurationProperties
    """

    _validation = {
        "name": {"required": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "properties": {"key": "properties", "type": "LoadBalancerConfigurationProperties"},
    }

    def __init__(
        self,
        *,
        name: str,
        properties: "_models.LoadBalancerConfigurationProperties",
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Id.
        :paramtype id: str
        :keyword name: The name of the Load balancer. Required.
        :paramtype name: str
        :keyword properties: Properties of the load balancer configuration. Required.
        :paramtype properties: ~azure.mgmt.compute.models.LoadBalancerConfigurationProperties
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.properties = properties


class LoadBalancerConfigurationProperties(_serialization.Model):
    """Describes the properties of the load balancer configuration.

    All required parameters must be populated in order to send to server.

    :ivar frontend_ip_configurations: Specifies the frontend IP to be used for the load balancer.
     Only IPv4 frontend IP address is supported. Each load balancer configuration must have exactly
     one frontend IP configuration. Required.
    :vartype frontend_ip_configurations:
     list[~azure.mgmt.compute.models.LoadBalancerFrontendIpConfiguration]
    """

    _validation = {
        "frontend_ip_configurations": {"required": True},
    }

    _attribute_map = {
        "frontend_ip_configurations": {
            "key": "frontendIpConfigurations",
            "type": "[LoadBalancerFrontendIpConfiguration]",
        },
    }

    def __init__(
        self, *, frontend_ip_configurations: list["_models.LoadBalancerFrontendIpConfiguration"], **kwargs: Any
    ) -> None:
        """
        :keyword frontend_ip_configurations: Specifies the frontend IP to be used for the load
         balancer. Only IPv4 frontend IP address is supported. Each load balancer configuration must
         have exactly one frontend IP configuration. Required.
        :paramtype frontend_ip_configurations:
         list[~azure.mgmt.compute.models.LoadBalancerFrontendIpConfiguration]
        """
        super().__init__(**kwargs)
        self.frontend_ip_configurations = frontend_ip_configurations


class LoadBalancerFrontendIpConfiguration(_serialization.Model):
    """Specifies the frontend IP to be used for the load balancer. Only IPv4 frontend IP address is
    supported. Each load balancer configuration must have exactly one frontend IP configuration.

    All required parameters must be populated in order to send to server.

    :ivar name: The name of the resource that is unique within the set of frontend IP
     configurations used by the load balancer. This name can be used to access the resource.
     Required.
    :vartype name: str
    :ivar properties: Properties of load balancer frontend ip configuration. Required.
    :vartype properties: ~azure.mgmt.compute.models.LoadBalancerFrontendIpConfigurationProperties
    """

    _validation = {
        "name": {"required": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "properties": {"key": "properties", "type": "LoadBalancerFrontendIpConfigurationProperties"},
    }

    def __init__(
        self, *, name: str, properties: "_models.LoadBalancerFrontendIpConfigurationProperties", **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the resource that is unique within the set of frontend IP
         configurations used by the load balancer. This name can be used to access the resource.
         Required.
        :paramtype name: str
        :keyword properties: Properties of load balancer frontend ip configuration. Required.
        :paramtype properties: ~azure.mgmt.compute.models.LoadBalancerFrontendIpConfigurationProperties
        """
        super().__init__(**kwargs)
        self.name = name
        self.properties = properties


class LoadBalancerFrontendIpConfigurationProperties(_serialization.Model):  # pylint: disable=name-too-long
    """Describes a cloud service IP Configuration.

    :ivar public_ip_address: The reference to the public ip address resource.
    :vartype public_ip_address: ~azure.mgmt.compute.models.SubResource
    :ivar subnet: The reference to the virtual network subnet resource.
    :vartype subnet: ~azure.mgmt.compute.models.SubResource
    :ivar private_ip_address: The virtual network private IP address of the IP configuration.
    :vartype private_ip_address: str
    """

    _attribute_map = {
        "public_ip_address": {"key": "publicIPAddress", "type": "SubResource"},
        "subnet": {"key": "subnet", "type": "SubResource"},
        "private_ip_address": {"key": "privateIPAddress", "type": "str"},
    }

    def __init__(
        self,
        *,
        public_ip_address: Optional["_models.SubResource"] = None,
        subnet: Optional["_models.SubResource"] = None,
        private_ip_address: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword public_ip_address: The reference to the public ip address resource.
        :paramtype public_ip_address: ~azure.mgmt.compute.models.SubResource
        :keyword subnet: The reference to the virtual network subnet resource.
        :paramtype subnet: ~azure.mgmt.compute.models.SubResource
        :keyword private_ip_address: The virtual network private IP address of the IP configuration.
        :paramtype private_ip_address: str
        """
        super().__init__(**kwargs)
        self.public_ip_address = public_ip_address
        self.subnet = subnet
        self.private_ip_address = private_ip_address


class LogAnalyticsInputBase(_serialization.Model):
    """Api input base class for LogAnalytics Api.

    All required parameters must be populated in order to send to server.

    :ivar blob_container_sas_uri: SAS Uri of the logging blob container to which LogAnalytics Api
     writes output logs to. Required.
    :vartype blob_container_sas_uri: str
    :ivar from_time: From time of the query. Required.
    :vartype from_time: ~datetime.datetime
    :ivar to_time: To time of the query. Required.
    :vartype to_time: ~datetime.datetime
    :ivar group_by_throttle_policy: Group query result by Throttle Policy applied.
    :vartype group_by_throttle_policy: bool
    :ivar group_by_operation_name: Group query result by Operation Name.
    :vartype group_by_operation_name: bool
    :ivar group_by_resource_name: Group query result by Resource Name.
    :vartype group_by_resource_name: bool
    :ivar group_by_client_application_id: Group query result by Client Application ID.
    :vartype group_by_client_application_id: bool
    :ivar group_by_user_agent: Group query result by User Agent.
    :vartype group_by_user_agent: bool
    """

    _validation = {
        "blob_container_sas_uri": {"required": True},
        "from_time": {"required": True},
        "to_time": {"required": True},
    }

    _attribute_map = {
        "blob_container_sas_uri": {"key": "blobContainerSasUri", "type": "str"},
        "from_time": {"key": "fromTime", "type": "iso-8601"},
        "to_time": {"key": "toTime", "type": "iso-8601"},
        "group_by_throttle_policy": {"key": "groupByThrottlePolicy", "type": "bool"},
        "group_by_operation_name": {"key": "groupByOperationName", "type": "bool"},
        "group_by_resource_name": {"key": "groupByResourceName", "type": "bool"},
        "group_by_client_application_id": {"key": "groupByClientApplicationId", "type": "bool"},
        "group_by_user_agent": {"key": "groupByUserAgent", "type": "bool"},
    }

    def __init__(
        self,
        *,
        blob_container_sas_uri: str,
        from_time: datetime.datetime,
        to_time: datetime.datetime,
        group_by_throttle_policy: Optional[bool] = None,
        group_by_operation_name: Optional[bool] = None,
        group_by_resource_name: Optional[bool] = None,
        group_by_client_application_id: Optional[bool] = None,
        group_by_user_agent: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword blob_container_sas_uri: SAS Uri of the logging blob container to which LogAnalytics
         Api writes output logs to. Required.
        :paramtype blob_container_sas_uri: str
        :keyword from_time: From time of the query. Required.
        :paramtype from_time: ~datetime.datetime
        :keyword to_time: To time of the query. Required.
        :paramtype to_time: ~datetime.datetime
        :keyword group_by_throttle_policy: Group query result by Throttle Policy applied.
        :paramtype group_by_throttle_policy: bool
        :keyword group_by_operation_name: Group query result by Operation Name.
        :paramtype group_by_operation_name: bool
        :keyword group_by_resource_name: Group query result by Resource Name.
        :paramtype group_by_resource_name: bool
        :keyword group_by_client_application_id: Group query result by Client Application ID.
        :paramtype group_by_client_application_id: bool
        :keyword group_by_user_agent: Group query result by User Agent.
        :paramtype group_by_user_agent: bool
        """
        super().__init__(**kwargs)
        self.blob_container_sas_uri = blob_container_sas_uri
        self.from_time = from_time
        self.to_time = to_time
        self.group_by_throttle_policy = group_by_throttle_policy
        self.group_by_operation_name = group_by_operation_name
        self.group_by_resource_name = group_by_resource_name
        self.group_by_client_application_id = group_by_client_application_id
        self.group_by_user_agent = group_by_user_agent


class LogAnalyticsOperationResult(_serialization.Model):
    """LogAnalytics operation status response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar properties: LogAnalyticsOutput.
    :vartype properties: ~azure.mgmt.compute.models.LogAnalyticsOutput
    """

    _validation = {
        "properties": {"readonly": True},
    }

    _attribute_map = {
        "properties": {"key": "properties", "type": "LogAnalyticsOutput"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.properties: Optional["_models.LogAnalyticsOutput"] = None


class LogAnalyticsOutput(_serialization.Model):
    """LogAnalytics output properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar output: Output file Uri path to blob container.
    :vartype output: str
    """

    _validation = {
        "output": {"readonly": True},
    }

    _attribute_map = {
        "output": {"key": "output", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.output: Optional[str] = None


class MaintenanceRedeployStatus(_serialization.Model):
    """Maintenance Operation Status.

    :ivar is_customer_initiated_maintenance_allowed: True, if customer is allowed to perform
     Maintenance.
    :vartype is_customer_initiated_maintenance_allowed: bool
    :ivar pre_maintenance_window_start_time: Start Time for the Pre Maintenance Window.
    :vartype pre_maintenance_window_start_time: ~datetime.datetime
    :ivar pre_maintenance_window_end_time: End Time for the Pre Maintenance Window.
    :vartype pre_maintenance_window_end_time: ~datetime.datetime
    :ivar maintenance_window_start_time: Start Time for the Maintenance Window.
    :vartype maintenance_window_start_time: ~datetime.datetime
    :ivar maintenance_window_end_time: End Time for the Maintenance Window.
    :vartype maintenance_window_end_time: ~datetime.datetime
    :ivar last_operation_result_code: The Last Maintenance Operation Result Code. Known values are:
     "None", "RetryLater", "MaintenanceAborted", and "MaintenanceCompleted".
    :vartype last_operation_result_code: str or
     ~azure.mgmt.compute.models.MaintenanceOperationResultCodeTypes
    :ivar last_operation_message: Message returned for the last Maintenance Operation.
    :vartype last_operation_message: str
    """

    _attribute_map = {
        "is_customer_initiated_maintenance_allowed": {"key": "isCustomerInitiatedMaintenanceAllowed", "type": "bool"},
        "pre_maintenance_window_start_time": {"key": "preMaintenanceWindowStartTime", "type": "iso-8601"},
        "pre_maintenance_window_end_time": {"key": "preMaintenanceWindowEndTime", "type": "iso-8601"},
        "maintenance_window_start_time": {"key": "maintenanceWindowStartTime", "type": "iso-8601"},
        "maintenance_window_end_time": {"key": "maintenanceWindowEndTime", "type": "iso-8601"},
        "last_operation_result_code": {"key": "lastOperationResultCode", "type": "str"},
        "last_operation_message": {"key": "lastOperationMessage", "type": "str"},
    }

    def __init__(
        self,
        *,
        is_customer_initiated_maintenance_allowed: Optional[bool] = None,
        pre_maintenance_window_start_time: Optional[datetime.datetime] = None,
        pre_maintenance_window_end_time: Optional[datetime.datetime] = None,
        maintenance_window_start_time: Optional[datetime.datetime] = None,
        maintenance_window_end_time: Optional[datetime.datetime] = None,
        last_operation_result_code: Optional[Union[str, "_models.MaintenanceOperationResultCodeTypes"]] = None,
        last_operation_message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_customer_initiated_maintenance_allowed: True, if customer is allowed to perform
         Maintenance.
        :paramtype is_customer_initiated_maintenance_allowed: bool
        :keyword pre_maintenance_window_start_time: Start Time for the Pre Maintenance Window.
        :paramtype pre_maintenance_window_start_time: ~datetime.datetime
        :keyword pre_maintenance_window_end_time: End Time for the Pre Maintenance Window.
        :paramtype pre_maintenance_window_end_time: ~datetime.datetime
        :keyword maintenance_window_start_time: Start Time for the Maintenance Window.
        :paramtype maintenance_window_start_time: ~datetime.datetime
        :keyword maintenance_window_end_time: End Time for the Maintenance Window.
        :paramtype maintenance_window_end_time: ~datetime.datetime
        :keyword last_operation_result_code: The Last Maintenance Operation Result Code. Known values
         are: "None", "RetryLater", "MaintenanceAborted", and "MaintenanceCompleted".
        :paramtype last_operation_result_code: str or
         ~azure.mgmt.compute.models.MaintenanceOperationResultCodeTypes
        :keyword last_operation_message: Message returned for the last Maintenance Operation.
        :paramtype last_operation_message: str
        """
        super().__init__(**kwargs)
        self.is_customer_initiated_maintenance_allowed = is_customer_initiated_maintenance_allowed
        self.pre_maintenance_window_start_time = pre_maintenance_window_start_time
        self.pre_maintenance_window_end_time = pre_maintenance_window_end_time
        self.maintenance_window_start_time = maintenance_window_start_time
        self.maintenance_window_end_time = maintenance_window_end_time
        self.last_operation_result_code = last_operation_result_code
        self.last_operation_message = last_operation_message


class ManagedDiskParameters(SubResource):
    """The parameters of a managed disk.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar storage_account_type: Specifies the storage account type for the managed disk. NOTE:
     UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk. Known values
     are: "Standard_LRS", "Premium_LRS", "StandardSSD_LRS", "UltraSSD_LRS", "Premium_ZRS",
     "StandardSSD_ZRS", and "PremiumV2_LRS".
    :vartype storage_account_type: str or ~azure.mgmt.compute.models.StorageAccountTypes
    :ivar disk_encryption_set: Specifies the customer managed disk encryption set resource id for
     the managed disk.
    :vartype disk_encryption_set: ~azure.mgmt.compute.models.DiskEncryptionSetParameters
    :ivar security_profile: Specifies the security profile for the managed disk.
    :vartype security_profile: ~azure.mgmt.compute.models.VMDiskSecurityProfile
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "storage_account_type": {"key": "storageAccountType", "type": "str"},
        "disk_encryption_set": {"key": "diskEncryptionSet", "type": "DiskEncryptionSetParameters"},
        "security_profile": {"key": "securityProfile", "type": "VMDiskSecurityProfile"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        storage_account_type: Optional[Union[str, "_models.StorageAccountTypes"]] = None,
        disk_encryption_set: Optional["_models.DiskEncryptionSetParameters"] = None,
        security_profile: Optional["_models.VMDiskSecurityProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Id.
        :paramtype id: str
        :keyword storage_account_type: Specifies the storage account type for the managed disk. NOTE:
         UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk. Known values
         are: "Standard_LRS", "Premium_LRS", "StandardSSD_LRS", "UltraSSD_LRS", "Premium_ZRS",
         "StandardSSD_ZRS", and "PremiumV2_LRS".
        :paramtype storage_account_type: str or ~azure.mgmt.compute.models.StorageAccountTypes
        :keyword disk_encryption_set: Specifies the customer managed disk encryption set resource id
         for the managed disk.
        :paramtype disk_encryption_set: ~azure.mgmt.compute.models.DiskEncryptionSetParameters
        :keyword security_profile: Specifies the security profile for the managed disk.
        :paramtype security_profile: ~azure.mgmt.compute.models.VMDiskSecurityProfile
        """
        super().__init__(id=id, **kwargs)
        self.storage_account_type = storage_account_type
        self.disk_encryption_set = disk_encryption_set
        self.security_profile = security_profile


class MaxInstancePercentPerZonePolicy(_serialization.Model):
    """The configuration parameters used to limit the number of virtual machines per availability zone
    in the virtual machine scale set.

    :ivar enabled: Specifies whether maxInstancePercentPerZonePolicy should be enabled on the
     virtual machine scale set.
    :vartype enabled: bool
    :ivar value: Limit on the number of instances in each zone as a percentage of the total
     capacity of the virtual machine scale set.
    :vartype value: int
    """

    _validation = {
        "value": {"maximum": 100},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "value": {"key": "value", "type": "int"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, value: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Specifies whether maxInstancePercentPerZonePolicy should be enabled on the
         virtual machine scale set.
        :paramtype enabled: bool
        :keyword value: Limit on the number of instances in each zone as a percentage of the total
         capacity of the virtual machine scale set.
        :paramtype value: int
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.value = value


class MigrateToVirtualMachineScaleSetInput(_serialization.Model):
    """Describes the Virtual Machine Scale Set to migrate from Availability Set.

    All required parameters must be populated in order to send to server.

    :ivar virtual_machine_scale_set_flexible: Specifies information about the Virtual Machine Scale
     Set that the Availability Set should be migrated to. Minimum api‐version: 2024‐11‐01. Required.
    :vartype virtual_machine_scale_set_flexible: ~azure.mgmt.compute.models.SubResource
    """

    _validation = {
        "virtual_machine_scale_set_flexible": {"required": True},
    }

    _attribute_map = {
        "virtual_machine_scale_set_flexible": {"key": "virtualMachineScaleSetFlexible", "type": "SubResource"},
    }

    def __init__(self, *, virtual_machine_scale_set_flexible: "_models.SubResource", **kwargs: Any) -> None:
        """
        :keyword virtual_machine_scale_set_flexible: Specifies information about the Virtual Machine
         Scale Set that the Availability Set should be migrated to. Minimum api‐version: 2024‐11‐01.
         Required.
        :paramtype virtual_machine_scale_set_flexible: ~azure.mgmt.compute.models.SubResource
        """
        super().__init__(**kwargs)
        self.virtual_machine_scale_set_flexible = virtual_machine_scale_set_flexible


class MigrateVMToVirtualMachineScaleSetInput(_serialization.Model):
    """The input of virtual machine migration from Availability Set to Flexible Virtual Machine Scale
    Set.

    :ivar target_zone: The target zone of VM migration to Flexible Virtual Machine Scale Set.
    :vartype target_zone: str
    :ivar target_fault_domain: The target compute fault domain of VM migration to Flexible Virtual
     Machine Scale Set.
    :vartype target_fault_domain: int
    :ivar target_vm_size: The target Virtual Machine size of VM migration to Flexible Virtual
     Machine Scale Set.
    :vartype target_vm_size: str
    """

    _attribute_map = {
        "target_zone": {"key": "targetZone", "type": "str"},
        "target_fault_domain": {"key": "targetFaultDomain", "type": "int"},
        "target_vm_size": {"key": "targetVMSize", "type": "str"},
    }

    def __init__(
        self,
        *,
        target_zone: Optional[str] = None,
        target_fault_domain: Optional[int] = None,
        target_vm_size: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword target_zone: The target zone of VM migration to Flexible Virtual Machine Scale Set.
        :paramtype target_zone: str
        :keyword target_fault_domain: The target compute fault domain of VM migration to Flexible
         Virtual Machine Scale Set.
        :paramtype target_fault_domain: int
        :keyword target_vm_size: The target Virtual Machine size of VM migration to Flexible Virtual
         Machine Scale Set.
        :paramtype target_vm_size: str
        """
        super().__init__(**kwargs)
        self.target_zone = target_zone
        self.target_fault_domain = target_fault_domain
        self.target_vm_size = target_vm_size


class NetworkInterfaceReference(SubResource):
    """Describes a network interface reference.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar primary: Specifies the primary network interface in case the virtual machine has more
     than 1 network interface.
    :vartype primary: bool
    :ivar delete_option: Specify what happens to the network interface when the VM is deleted.
     Known values are: "Delete" and "Detach".
    :vartype delete_option: str or ~azure.mgmt.compute.models.DeleteOptions
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "primary": {"key": "properties.primary", "type": "bool"},
        "delete_option": {"key": "properties.deleteOption", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        primary: Optional[bool] = None,
        delete_option: Optional[Union[str, "_models.DeleteOptions"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Id.
        :paramtype id: str
        :keyword primary: Specifies the primary network interface in case the virtual machine has more
         than 1 network interface.
        :paramtype primary: bool
        :keyword delete_option: Specify what happens to the network interface when the VM is deleted.
         Known values are: "Delete" and "Detach".
        :paramtype delete_option: str or ~azure.mgmt.compute.models.DeleteOptions
        """
        super().__init__(id=id, **kwargs)
        self.primary = primary
        self.delete_option = delete_option


class NetworkProfile(_serialization.Model):
    """Specifies the network interfaces or the networking configuration of the virtual machine.

    :ivar network_interfaces: Specifies the list of resource Ids for the network interfaces
     associated with the virtual machine.
    :vartype network_interfaces: list[~azure.mgmt.compute.models.NetworkInterfaceReference]
    :ivar network_api_version: specifies the Microsoft.Network API version used when creating
     networking resources in the Network Interface Configurations. Known values are: "2020-11-01"
     and "2022-11-01".
    :vartype network_api_version: str or ~azure.mgmt.compute.models.NetworkApiVersion
    :ivar network_interface_configurations: Specifies the networking configurations that will be
     used to create the virtual machine networking resources.
    :vartype network_interface_configurations:
     list[~azure.mgmt.compute.models.VirtualMachineNetworkInterfaceConfiguration]
    """

    _attribute_map = {
        "network_interfaces": {"key": "networkInterfaces", "type": "[NetworkInterfaceReference]"},
        "network_api_version": {"key": "networkApiVersion", "type": "str"},
        "network_interface_configurations": {
            "key": "networkInterfaceConfigurations",
            "type": "[VirtualMachineNetworkInterfaceConfiguration]",
        },
    }

    def __init__(
        self,
        *,
        network_interfaces: Optional[list["_models.NetworkInterfaceReference"]] = None,
        network_api_version: Optional[Union[str, "_models.NetworkApiVersion"]] = None,
        network_interface_configurations: Optional[list["_models.VirtualMachineNetworkInterfaceConfiguration"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword network_interfaces: Specifies the list of resource Ids for the network interfaces
         associated with the virtual machine.
        :paramtype network_interfaces: list[~azure.mgmt.compute.models.NetworkInterfaceReference]
        :keyword network_api_version: specifies the Microsoft.Network API version used when creating
         networking resources in the Network Interface Configurations. Known values are: "2020-11-01"
         and "2022-11-01".
        :paramtype network_api_version: str or ~azure.mgmt.compute.models.NetworkApiVersion
        :keyword network_interface_configurations: Specifies the networking configurations that will be
         used to create the virtual machine networking resources.
        :paramtype network_interface_configurations:
         list[~azure.mgmt.compute.models.VirtualMachineNetworkInterfaceConfiguration]
        """
        super().__init__(**kwargs)
        self.network_interfaces = network_interfaces
        self.network_api_version = network_api_version
        self.network_interface_configurations = network_interface_configurations


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.compute.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.compute.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.compute.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.compute.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.is_data_action: Optional[bool] = None
        self.display = display
        self.origin: Optional[Union[str, "_models.Origin"]] = None
        self.action_type: Optional[Union[str, "_models.ActionType"]] = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider: Optional[str] = None
        self.resource: Optional[str] = None
        self.operation: Optional[str] = None
        self.description: Optional[str] = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link
    to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.compute.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[list["_models.Operation"]] = None
        self.next_link: Optional[str] = None


class OrchestrationServiceStateInput(_serialization.Model):
    """The input for OrchestrationServiceState.

    All required parameters must be populated in order to send to server.

    :ivar service_name: The name of the service. Required. Known values are: "AutomaticRepairs" and
     "AutomaticZoneRebalancing".
    :vartype service_name: str or ~azure.mgmt.compute.models.OrchestrationServiceNames
    :ivar action: The action to be performed. Required. Known values are: "Resume" and "Suspend".
    :vartype action: str or ~azure.mgmt.compute.models.OrchestrationServiceStateAction
    """

    _validation = {
        "service_name": {"required": True},
        "action": {"required": True},
    }

    _attribute_map = {
        "service_name": {"key": "serviceName", "type": "str"},
        "action": {"key": "action", "type": "str"},
    }

    def __init__(
        self,
        *,
        service_name: Union[str, "_models.OrchestrationServiceNames"],
        action: Union[str, "_models.OrchestrationServiceStateAction"],
        **kwargs: Any
    ) -> None:
        """
        :keyword service_name: The name of the service. Required. Known values are: "AutomaticRepairs"
         and "AutomaticZoneRebalancing".
        :paramtype service_name: str or ~azure.mgmt.compute.models.OrchestrationServiceNames
        :keyword action: The action to be performed. Required. Known values are: "Resume" and
         "Suspend".
        :paramtype action: str or ~azure.mgmt.compute.models.OrchestrationServiceStateAction
        """
        super().__init__(**kwargs)
        self.service_name = service_name
        self.action = action


class OrchestrationServiceSummary(_serialization.Model):
    """Summary for an orchestration service of a virtual machine scale set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar service_name: The name of the service. Known values are: "AutomaticRepairs" and
     "AutomaticZoneRebalancing".
    :vartype service_name: str or ~azure.mgmt.compute.models.OrchestrationServiceNames
    :ivar service_state: The current state of the service. Known values are: "NotRunning",
     "Running", and "Suspended".
    :vartype service_state: str or ~azure.mgmt.compute.models.OrchestrationServiceState
    :ivar latest_operation_status: The latest operation status of the service. Minimum API version
     for this property is 2025-04-01. Known values are: "InProgress" and "Completed".
    :vartype latest_operation_status: str or
     ~azure.mgmt.compute.models.OrchestrationServiceOperationStatus
    :ivar last_status_change_time: The last UTC time when the operation status changed. Minimum API
     version for this property is 2025-04-01.
    :vartype last_status_change_time: ~datetime.datetime
    """

    _validation = {
        "service_name": {"readonly": True},
        "service_state": {"readonly": True},
        "latest_operation_status": {"readonly": True},
        "last_status_change_time": {"readonly": True},
    }

    _attribute_map = {
        "service_name": {"key": "serviceName", "type": "str"},
        "service_state": {"key": "serviceState", "type": "str"},
        "latest_operation_status": {"key": "latestOperationStatus", "type": "str"},
        "last_status_change_time": {"key": "lastStatusChangeTime", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.service_name: Optional[Union[str, "_models.OrchestrationServiceNames"]] = None
        self.service_state: Optional[Union[str, "_models.OrchestrationServiceState"]] = None
        self.latest_operation_status: Optional[Union[str, "_models.OrchestrationServiceOperationStatus"]] = None
        self.last_status_change_time: Optional[datetime.datetime] = None


class OSDisk(_serialization.Model):
    """Specifies information about the operating system disk used by the virtual machine. For more
    information about disks, see `About disks and VHDs for Azure virtual machines
    <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_.

    All required parameters must be populated in order to send to server.

    :ivar os_type: This property allows you to specify the type of the OS that is included in the
     disk if creating a VM from user-image or a specialized VHD. Possible values are: **Windows,**
     **Linux.**. Known values are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
    :ivar encryption_settings: Specifies the encryption settings for the OS Disk. Minimum
     api-version: 2015-06-15.
    :vartype encryption_settings: ~azure.mgmt.compute.models.DiskEncryptionSettings
    :ivar name: The disk name.
    :vartype name: str
    :ivar vhd: The virtual hard disk.
    :vartype vhd: ~azure.mgmt.compute.models.VirtualHardDisk
    :ivar image: The source user image virtual hard disk. The virtual hard disk will be copied
     before being attached to the virtual machine. If SourceImage is provided, the destination
     virtual hard drive must not exist.
    :vartype image: ~azure.mgmt.compute.models.VirtualHardDisk
    :ivar caching: Specifies the caching requirements. Possible values are: **None,** **ReadOnly,**
     **ReadWrite.** The defaulting behavior is: **None for Standard storage. ReadOnly for Premium
     storage.**. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype caching: str or ~azure.mgmt.compute.models.CachingTypes
    :ivar write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
     disabled on the disk.
    :vartype write_accelerator_enabled: bool
    :ivar diff_disk_settings: Specifies the ephemeral Disk Settings for the operating system disk
     used by the virtual machine.
    :vartype diff_disk_settings: ~azure.mgmt.compute.models.DiffDiskSettings
    :ivar create_option: Specifies how the virtual machine disk should be created. Possible values
     are **Attach:** This value is used when you are using a specialized disk to create the virtual
     machine. **FromImage:** This value is used when you are using an image to create the virtual
     machine. If you are using a platform image, you should also use the imageReference element
     described above. If you are using a marketplace image, you should also use the plan element
     previously described. Required. Known values are: "FromImage", "Empty", "Attach", "Copy", and
     "Restore".
    :vartype create_option: str or ~azure.mgmt.compute.models.DiskCreateOptionTypes
    :ivar disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can be
     used to overwrite the size of the disk in a virtual machine image. The property 'diskSizeGB' is
     the number of bytes x 1024^3 for the disk and the value cannot be larger than 1023.
    :vartype disk_size_gb: int
    :ivar managed_disk: The managed disk parameters.
    :vartype managed_disk: ~azure.mgmt.compute.models.ManagedDiskParameters
    :ivar delete_option: Specifies whether OS Disk should be deleted or detached upon VM deletion.
     Possible values are: **Delete.** If this value is used, the OS disk is deleted when VM is
     deleted. **Detach.** If this value is used, the os disk is retained after VM is deleted. The
     default value is set to **Detach**. For an ephemeral OS Disk, the default value is set to
     **Delete**. The user cannot change the delete option for an ephemeral OS Disk. Known values
     are: "Delete" and "Detach".
    :vartype delete_option: str or ~azure.mgmt.compute.models.DiskDeleteOptionTypes
    """

    _validation = {
        "create_option": {"required": True},
    }

    _attribute_map = {
        "os_type": {"key": "osType", "type": "str"},
        "encryption_settings": {"key": "encryptionSettings", "type": "DiskEncryptionSettings"},
        "name": {"key": "name", "type": "str"},
        "vhd": {"key": "vhd", "type": "VirtualHardDisk"},
        "image": {"key": "image", "type": "VirtualHardDisk"},
        "caching": {"key": "caching", "type": "str"},
        "write_accelerator_enabled": {"key": "writeAcceleratorEnabled", "type": "bool"},
        "diff_disk_settings": {"key": "diffDiskSettings", "type": "DiffDiskSettings"},
        "create_option": {"key": "createOption", "type": "str"},
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
        "managed_disk": {"key": "managedDisk", "type": "ManagedDiskParameters"},
        "delete_option": {"key": "deleteOption", "type": "str"},
    }

    def __init__(
        self,
        *,
        create_option: Union[str, "_models.DiskCreateOptionTypes"],
        os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None,
        encryption_settings: Optional["_models.DiskEncryptionSettings"] = None,
        name: Optional[str] = None,
        vhd: Optional["_models.VirtualHardDisk"] = None,
        image: Optional["_models.VirtualHardDisk"] = None,
        caching: Optional[Union[str, "_models.CachingTypes"]] = None,
        write_accelerator_enabled: Optional[bool] = None,
        diff_disk_settings: Optional["_models.DiffDiskSettings"] = None,
        disk_size_gb: Optional[int] = None,
        managed_disk: Optional["_models.ManagedDiskParameters"] = None,
        delete_option: Optional[Union[str, "_models.DiskDeleteOptionTypes"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword os_type: This property allows you to specify the type of the OS that is included in
         the disk if creating a VM from user-image or a specialized VHD. Possible values are:
         **Windows,** **Linux.**. Known values are: "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
        :keyword encryption_settings: Specifies the encryption settings for the OS Disk. Minimum
         api-version: 2015-06-15.
        :paramtype encryption_settings: ~azure.mgmt.compute.models.DiskEncryptionSettings
        :keyword name: The disk name.
        :paramtype name: str
        :keyword vhd: The virtual hard disk.
        :paramtype vhd: ~azure.mgmt.compute.models.VirtualHardDisk
        :keyword image: The source user image virtual hard disk. The virtual hard disk will be copied
         before being attached to the virtual machine. If SourceImage is provided, the destination
         virtual hard drive must not exist.
        :paramtype image: ~azure.mgmt.compute.models.VirtualHardDisk
        :keyword caching: Specifies the caching requirements. Possible values are: **None,**
         **ReadOnly,** **ReadWrite.** The defaulting behavior is: **None for Standard storage. ReadOnly
         for Premium storage.**. Known values are: "None", "ReadOnly", and "ReadWrite".
        :paramtype caching: str or ~azure.mgmt.compute.models.CachingTypes
        :keyword write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
         disabled on the disk.
        :paramtype write_accelerator_enabled: bool
        :keyword diff_disk_settings: Specifies the ephemeral Disk Settings for the operating system
         disk used by the virtual machine.
        :paramtype diff_disk_settings: ~azure.mgmt.compute.models.DiffDiskSettings
        :keyword create_option: Specifies how the virtual machine disk should be created. Possible
         values are **Attach:** This value is used when you are using a specialized disk to create the
         virtual machine. **FromImage:** This value is used when you are using an image to create the
         virtual machine. If you are using a platform image, you should also use the imageReference
         element described above. If you are using a marketplace image, you should also use the plan
         element previously described. Required. Known values are: "FromImage", "Empty", "Attach",
         "Copy", and "Restore".
        :paramtype create_option: str or ~azure.mgmt.compute.models.DiskCreateOptionTypes
        :keyword disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can
         be used to overwrite the size of the disk in a virtual machine image. The property 'diskSizeGB'
         is the number of bytes x 1024^3 for the disk and the value cannot be larger than 1023.
        :paramtype disk_size_gb: int
        :keyword managed_disk: The managed disk parameters.
        :paramtype managed_disk: ~azure.mgmt.compute.models.ManagedDiskParameters
        :keyword delete_option: Specifies whether OS Disk should be deleted or detached upon VM
         deletion. Possible values are: **Delete.** If this value is used, the OS disk is deleted when
         VM is deleted. **Detach.** If this value is used, the os disk is retained after VM is deleted.
         The default value is set to **Detach**. For an ephemeral OS Disk, the default value is set to
         **Delete**. The user cannot change the delete option for an ephemeral OS Disk. Known values
         are: "Delete" and "Detach".
        :paramtype delete_option: str or ~azure.mgmt.compute.models.DiskDeleteOptionTypes
        """
        super().__init__(**kwargs)
        self.os_type = os_type
        self.encryption_settings = encryption_settings
        self.name = name
        self.vhd = vhd
        self.image = image
        self.caching = caching
        self.write_accelerator_enabled = write_accelerator_enabled
        self.diff_disk_settings = diff_disk_settings
        self.create_option = create_option
        self.disk_size_gb = disk_size_gb
        self.managed_disk = managed_disk
        self.delete_option = delete_option


class OSDiskImage(_serialization.Model):
    """Contains the os disk image information.

    All required parameters must be populated in order to send to server.

    :ivar operating_system: The operating system of the osDiskImage. Required. Known values are:
     "Windows" and "Linux".
    :vartype operating_system: str or ~azure.mgmt.compute.models.OperatingSystemTypes
    """

    _validation = {
        "operating_system": {"required": True},
    }

    _attribute_map = {
        "operating_system": {"key": "operatingSystem", "type": "str"},
    }

    def __init__(self, *, operating_system: Union[str, "_models.OperatingSystemTypes"], **kwargs: Any) -> None:
        """
        :keyword operating_system: The operating system of the osDiskImage. Required. Known values are:
         "Windows" and "Linux".
        :paramtype operating_system: str or ~azure.mgmt.compute.models.OperatingSystemTypes
        """
        super().__init__(**kwargs)
        self.operating_system = operating_system


class OSDiskImageEncryption(DiskImageEncryption):
    """Contains encryption settings for an OS disk image.

    :ivar disk_encryption_set_id: A relative URI containing the resource ID of the disk encryption
     set.
    :vartype disk_encryption_set_id: str
    :ivar security_profile: This property specifies the security profile of an OS disk image.
    :vartype security_profile: ~azure.mgmt.compute.models.OSDiskImageSecurityProfile
    """

    _attribute_map = {
        "disk_encryption_set_id": {"key": "diskEncryptionSetId", "type": "str"},
        "security_profile": {"key": "securityProfile", "type": "OSDiskImageSecurityProfile"},
    }

    def __init__(
        self,
        *,
        disk_encryption_set_id: Optional[str] = None,
        security_profile: Optional["_models.OSDiskImageSecurityProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword disk_encryption_set_id: A relative URI containing the resource ID of the disk
         encryption set.
        :paramtype disk_encryption_set_id: str
        :keyword security_profile: This property specifies the security profile of an OS disk image.
        :paramtype security_profile: ~azure.mgmt.compute.models.OSDiskImageSecurityProfile
        """
        super().__init__(disk_encryption_set_id=disk_encryption_set_id, **kwargs)
        self.security_profile = security_profile


class OSDiskImageSecurityProfile(_serialization.Model):
    """Contains security profile for an OS disk image.

    :ivar confidential_vm_encryption_type: confidential VM encryption types. Known values are:
     "EncryptedVMGuestStateOnlyWithPmk", "EncryptedWithPmk", "EncryptedWithCmk", and
     "NonPersistedTPM".
    :vartype confidential_vm_encryption_type: str or
     ~azure.mgmt.compute.models.ConfidentialVMEncryptionType
    :ivar secure_vm_disk_encryption_set_id: secure VM disk encryption set id.
    :vartype secure_vm_disk_encryption_set_id: str
    """

    _attribute_map = {
        "confidential_vm_encryption_type": {"key": "confidentialVMEncryptionType", "type": "str"},
        "secure_vm_disk_encryption_set_id": {"key": "secureVMDiskEncryptionSetId", "type": "str"},
    }

    def __init__(
        self,
        *,
        confidential_vm_encryption_type: Optional[Union[str, "_models.ConfidentialVMEncryptionType"]] = None,
        secure_vm_disk_encryption_set_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword confidential_vm_encryption_type: confidential VM encryption types. Known values are:
         "EncryptedVMGuestStateOnlyWithPmk", "EncryptedWithPmk", "EncryptedWithCmk", and
         "NonPersistedTPM".
        :paramtype confidential_vm_encryption_type: str or
         ~azure.mgmt.compute.models.ConfidentialVMEncryptionType
        :keyword secure_vm_disk_encryption_set_id: secure VM disk encryption set id.
        :paramtype secure_vm_disk_encryption_set_id: str
        """
        super().__init__(**kwargs)
        self.confidential_vm_encryption_type = confidential_vm_encryption_type
        self.secure_vm_disk_encryption_set_id = secure_vm_disk_encryption_set_id


class OSFamily(_serialization.Model):
    """Describes a cloud service OS family.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar properties: OS family properties.
    :vartype properties: ~azure.mgmt.compute.models.OSFamilyProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "OSFamilyProperties"},
    }

    def __init__(self, *, properties: Optional["_models.OSFamilyProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: OS family properties.
        :paramtype properties: ~azure.mgmt.compute.models.OSFamilyProperties
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.location: Optional[str] = None
        self.properties = properties


class OSFamilyListResult(_serialization.Model):
    """The list operation result.

    All required parameters must be populated in order to send to server.

    :ivar value: The list of resources. Required.
    :vartype value: list[~azure.mgmt.compute.models.OSFamily]
    :ivar next_link: The URI to fetch the next page of resources. Use this to get the next page of
     resources. Do this till nextLink is null to fetch all the resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[OSFamily]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: list["_models.OSFamily"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of resources. Required.
        :paramtype value: list[~azure.mgmt.compute.models.OSFamily]
        :keyword next_link: The URI to fetch the next page of resources. Use this to get the next page
         of resources. Do this till nextLink is null to fetch all the resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class OSFamilyProperties(_serialization.Model):
    """OS family properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The OS family name.
    :vartype name: str
    :ivar label: The OS family label.
    :vartype label: str
    :ivar versions: List of OS versions belonging to this family.
    :vartype versions: list[~azure.mgmt.compute.models.OSVersionPropertiesBase]
    """

    _validation = {
        "name": {"readonly": True},
        "label": {"readonly": True},
        "versions": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "versions": {"key": "versions", "type": "[OSVersionPropertiesBase]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.label: Optional[str] = None
        self.versions: Optional[list["_models.OSVersionPropertiesBase"]] = None


class OSImageNotificationProfile(_serialization.Model):
    """OSImageNotificationProfile.

    :ivar not_before_timeout: Length of time a Virtual Machine being reimaged or having its OS
     upgraded will have to potentially approve the OS Image Scheduled Event before the event is auto
     approved (timed out). The configuration is specified in ISO 8601 format, and the value must be
     15 minutes (PT15M).
    :vartype not_before_timeout: str
    :ivar enable: Specifies whether the OS Image Scheduled event is enabled or disabled.
    :vartype enable: bool
    """

    _attribute_map = {
        "not_before_timeout": {"key": "notBeforeTimeout", "type": "str"},
        "enable": {"key": "enable", "type": "bool"},
    }

    def __init__(
        self, *, not_before_timeout: Optional[str] = None, enable: Optional[bool] = None, **kwargs: Any
    ) -> None:
        """
        :keyword not_before_timeout: Length of time a Virtual Machine being reimaged or having its OS
         upgraded will have to potentially approve the OS Image Scheduled Event before the event is auto
         approved (timed out). The configuration is specified in ISO 8601 format, and the value must be
         15 minutes (PT15M).
        :paramtype not_before_timeout: str
        :keyword enable: Specifies whether the OS Image Scheduled event is enabled or disabled.
        :paramtype enable: bool
        """
        super().__init__(**kwargs)
        self.not_before_timeout = not_before_timeout
        self.enable = enable


class OSProfile(_serialization.Model):
    """Specifies the operating system settings for the virtual machine. Some of the settings cannot be
    changed once VM is provisioned.

    :ivar computer_name: Specifies the host OS name of the virtual machine. This name cannot be
     updated after the VM is created. **Max-length (Windows):** 15 characters. **Max-length
     (Linux):** 64 characters. For naming conventions and restrictions see `Azure infrastructure
     services implementation guidelines
     <https://docs.microsoft.com/azure/azure-resource-manager/management/resource-name-rules>`_.
    :vartype computer_name: str
    :ivar admin_username: Specifies the name of the administrator account. :code:`<br>`\\
     :code:`<br>` This property cannot be updated after the VM is created. :code:`<br>`\\
     :code:`<br>` **Windows-only restriction:** Cannot end in "." :code:`<br>`\\ :code:`<br>`
     **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1",
     "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console",
     "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0",
     "sys", "test2", "test3", "user4", "user5". :code:`<br>`\\ :code:`<br>` **Minimum-length
     (Linux):** 1  character :code:`<br>`\\ :code:`<br>` **Max-length (Linux):** 64 characters
     :code:`<br>`\\ :code:`<br>` **Max-length (Windows):** 20 characters.
    :vartype admin_username: str
    :ivar admin_password: Specifies the password of the administrator account. :code:`<br>`\\
     :code:`<br>` **Minimum-length (Windows):** 8 characters :code:`<br>`\\ :code:`<br>`
     **Minimum-length (Linux):** 6 characters :code:`<br>`\\ :code:`<br>` **Max-length (Windows):**
     123 characters :code:`<br>`\\ :code:`<br>` **Max-length (Linux):** 72 characters :code:`<br>`\\
     :code:`<br>` **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled
     :code:`<br>` Has lower characters :code:`<br>`Has upper characters :code:`<br>` Has a digit
     :code:`<br>` Has a special character (Regex match [\\W_]) :code:`<br>`\\ :code:`<br>`
     **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word",
     "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" :code:`<br>`\\ :code:`<br>`
     For resetting the password, see `How to reset the Remote Desktop service or its login password
     in a Windows VM <https://docs.microsoft.com/troubleshoot/azure/virtual-machines/reset-rdp>`_
     :code:`<br>`\\ :code:`<br>` For resetting root password, see `Manage users, SSH, and check or
     repair disks on Azure Linux VMs using the VMAccess Extension
     <https://docs.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection>`_.
    :vartype admin_password: str
    :ivar custom_data: Specifies a base-64 encoded string of custom data. The base-64 encoded
     string is decoded to a binary array that is saved as a file on the Virtual Machine. The maximum
     length of the binary array is 65535 bytes. **Note: Do not pass any secrets or passwords in
     customData property.** This property cannot be updated after the VM is created. The property
     'customData' is passed to the VM to be saved as a file, for more information see `Custom Data
     on Azure VMs <https://azure.microsoft.com/blog/custom-data-and-cloud-init-on-windows-azure/>`_.
     For using cloud-init for your Linux VM, see `Using cloud-init to customize a Linux VM during
     creation <https://docs.microsoft.com/azure/virtual-machines/linux/using-cloud-init>`_.
    :vartype custom_data: str
    :ivar windows_configuration: Specifies Windows operating system settings on the virtual
     machine.
    :vartype windows_configuration: ~azure.mgmt.compute.models.WindowsConfiguration
    :ivar linux_configuration: Specifies the Linux operating system settings on the virtual
     machine. For a list of supported Linux distributions, see `Linux on Azure-Endorsed
     Distributions <https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros>`_.
    :vartype linux_configuration: ~azure.mgmt.compute.models.LinuxConfiguration
    :ivar secrets: Specifies set of certificates that should be installed onto the virtual machine.
     To install certificates on a virtual machine it is recommended to use the `Azure Key Vault
     virtual machine extension for Linux
     <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux>`_ or the `Azure
     Key Vault virtual machine extension for Windows
     <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows>`_.
    :vartype secrets: list[~azure.mgmt.compute.models.VaultSecretGroup]
    :ivar allow_extension_operations: Specifies whether extension operations should be allowed on
     the virtual machine. This may only be set to False when no extensions are present on the
     virtual machine.
    :vartype allow_extension_operations: bool
    :ivar require_guest_provision_signal: Optional property which must either be set to True or
     omitted.
    :vartype require_guest_provision_signal: bool
    """

    _attribute_map = {
        "computer_name": {"key": "computerName", "type": "str"},
        "admin_username": {"key": "adminUsername", "type": "str"},
        "admin_password": {"key": "adminPassword", "type": "str"},
        "custom_data": {"key": "customData", "type": "str"},
        "windows_configuration": {"key": "windowsConfiguration", "type": "WindowsConfiguration"},
        "linux_configuration": {"key": "linuxConfiguration", "type": "LinuxConfiguration"},
        "secrets": {"key": "secrets", "type": "[VaultSecretGroup]"},
        "allow_extension_operations": {"key": "allowExtensionOperations", "type": "bool"},
        "require_guest_provision_signal": {"key": "requireGuestProvisionSignal", "type": "bool"},
    }

    def __init__(
        self,
        *,
        computer_name: Optional[str] = None,
        admin_username: Optional[str] = None,
        admin_password: Optional[str] = None,
        custom_data: Optional[str] = None,
        windows_configuration: Optional["_models.WindowsConfiguration"] = None,
        linux_configuration: Optional["_models.LinuxConfiguration"] = None,
        secrets: Optional[list["_models.VaultSecretGroup"]] = None,
        allow_extension_operations: Optional[bool] = None,
        require_guest_provision_signal: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword computer_name: Specifies the host OS name of the virtual machine. This name cannot be
         updated after the VM is created. **Max-length (Windows):** 15 characters. **Max-length
         (Linux):** 64 characters. For naming conventions and restrictions see `Azure infrastructure
         services implementation guidelines
         <https://docs.microsoft.com/azure/azure-resource-manager/management/resource-name-rules>`_.
        :paramtype computer_name: str
        :keyword admin_username: Specifies the name of the administrator account. :code:`<br>`\\
         :code:`<br>` This property cannot be updated after the VM is created. :code:`<br>`\\
         :code:`<br>` **Windows-only restriction:** Cannot end in "." :code:`<br>`\\ :code:`<br>`
         **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1",
         "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console",
         "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0",
         "sys", "test2", "test3", "user4", "user5". :code:`<br>`\\ :code:`<br>` **Minimum-length
         (Linux):** 1  character :code:`<br>`\\ :code:`<br>` **Max-length (Linux):** 64 characters
         :code:`<br>`\\ :code:`<br>` **Max-length (Windows):** 20 characters.
        :paramtype admin_username: str
        :keyword admin_password: Specifies the password of the administrator account. :code:`<br>`\\
         :code:`<br>` **Minimum-length (Windows):** 8 characters :code:`<br>`\\ :code:`<br>`
         **Minimum-length (Linux):** 6 characters :code:`<br>`\\ :code:`<br>` **Max-length (Windows):**
         123 characters :code:`<br>`\\ :code:`<br>` **Max-length (Linux):** 72 characters :code:`<br>`\\
         :code:`<br>` **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled
         :code:`<br>` Has lower characters :code:`<br>`Has upper characters :code:`<br>` Has a digit
         :code:`<br>` Has a special character (Regex match [\\W_]) :code:`<br>`\\ :code:`<br>`
         **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word",
         "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" :code:`<br>`\\ :code:`<br>`
         For resetting the password, see `How to reset the Remote Desktop service or its login password
         in a Windows VM <https://docs.microsoft.com/troubleshoot/azure/virtual-machines/reset-rdp>`_
         :code:`<br>`\\ :code:`<br>` For resetting root password, see `Manage users, SSH, and check or
         repair disks on Azure Linux VMs using the VMAccess Extension
         <https://docs.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection>`_.
        :paramtype admin_password: str
        :keyword custom_data: Specifies a base-64 encoded string of custom data. The base-64 encoded
         string is decoded to a binary array that is saved as a file on the Virtual Machine. The maximum
         length of the binary array is 65535 bytes. **Note: Do not pass any secrets or passwords in
         customData property.** This property cannot be updated after the VM is created. The property
         'customData' is passed to the VM to be saved as a file, for more information see `Custom Data
         on Azure VMs <https://azure.microsoft.com/blog/custom-data-and-cloud-init-on-windows-azure/>`_.
         For using cloud-init for your Linux VM, see `Using cloud-init to customize a Linux VM during
         creation <https://docs.microsoft.com/azure/virtual-machines/linux/using-cloud-init>`_.
        :paramtype custom_data: str
        :keyword windows_configuration: Specifies Windows operating system settings on the virtual
         machine.
        :paramtype windows_configuration: ~azure.mgmt.compute.models.WindowsConfiguration
        :keyword linux_configuration: Specifies the Linux operating system settings on the virtual
         machine. For a list of supported Linux distributions, see `Linux on Azure-Endorsed
         Distributions <https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros>`_.
        :paramtype linux_configuration: ~azure.mgmt.compute.models.LinuxConfiguration
        :keyword secrets: Specifies set of certificates that should be installed onto the virtual
         machine. To install certificates on a virtual machine it is recommended to use the `Azure Key
         Vault virtual machine extension for Linux
         <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux>`_ or the `Azure
         Key Vault virtual machine extension for Windows
         <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows>`_.
        :paramtype secrets: list[~azure.mgmt.compute.models.VaultSecretGroup]
        :keyword allow_extension_operations: Specifies whether extension operations should be allowed
         on the virtual machine. This may only be set to False when no extensions are present on the
         virtual machine.
        :paramtype allow_extension_operations: bool
        :keyword require_guest_provision_signal: Optional property which must either be set to True or
         omitted.
        :paramtype require_guest_provision_signal: bool
        """
        super().__init__(**kwargs)
        self.computer_name = computer_name
        self.admin_username = admin_username
        self.admin_password = admin_password
        self.custom_data = custom_data
        self.windows_configuration = windows_configuration
        self.linux_configuration = linux_configuration
        self.secrets = secrets
        self.allow_extension_operations = allow_extension_operations
        self.require_guest_provision_signal = require_guest_provision_signal


class OSProfileProvisioningData(_serialization.Model):
    """Additional parameters for Reimaging Non-Ephemeral Virtual Machine.

    :ivar admin_password: Specifies the password of the administrator account. :code:`<br>`\\
     :code:`<br>` **Minimum-length (Windows):** 8 characters :code:`<br>`\\ :code:`<br>`
     **Minimum-length (Linux):** 6 characters :code:`<br>`\\ :code:`<br>` **Max-length (Windows):**
     123 characters :code:`<br>`\\ :code:`<br>` **Max-length (Linux):** 72 characters :code:`<br>`\\
     :code:`<br>` **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled
     :code:`<br>` Has lower characters :code:`<br>`Has upper characters :code:`<br>` Has a digit
     :code:`<br>` Has a special character (Regex match [\\W_]) :code:`<br>`\\ :code:`<br>`
     **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word",
     "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" :code:`<br>`\\ :code:`<br>`
     For resetting the password, see `How to reset the Remote Desktop service or its login password
     in a Windows VM <https://docs.microsoft.com/troubleshoot/azure/virtual-machines/reset-rdp>`_
     :code:`<br>`\\ :code:`<br>` For resetting root password, see `Manage users, SSH, and check or
     repair disks on Azure Linux VMs using the VMAccess Extension
     <https://docs.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection>`_.
    :vartype admin_password: str
    :ivar custom_data: Specifies a base-64 encoded string of custom data. The base-64 encoded
     string is decoded to a binary array that is saved as a file on the Virtual Machine. The maximum
     length of the binary array is 65535 bytes. **Note: Do not pass any secrets or passwords in
     customData property.** This property cannot be updated after the VM is created. The property
     customData is passed to the VM to be saved as a file, for more information see `Custom Data on
     Azure VMs <https://azure.microsoft.com/blog/custom-data-and-cloud-init-on-windows-azure/>`_. If
     using cloud-init for your Linux VM, see `Using cloud-init to customize a Linux VM during
     creation <https://docs.microsoft.com/azure/virtual-machines/linux/using-cloud-init>`_.
    :vartype custom_data: str
    """

    _attribute_map = {
        "admin_password": {"key": "adminPassword", "type": "str"},
        "custom_data": {"key": "customData", "type": "str"},
    }

    def __init__(
        self, *, admin_password: Optional[str] = None, custom_data: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword admin_password: Specifies the password of the administrator account. :code:`<br>`\\
         :code:`<br>` **Minimum-length (Windows):** 8 characters :code:`<br>`\\ :code:`<br>`
         **Minimum-length (Linux):** 6 characters :code:`<br>`\\ :code:`<br>` **Max-length (Windows):**
         123 characters :code:`<br>`\\ :code:`<br>` **Max-length (Linux):** 72 characters :code:`<br>`\\
         :code:`<br>` **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled
         :code:`<br>` Has lower characters :code:`<br>`Has upper characters :code:`<br>` Has a digit
         :code:`<br>` Has a special character (Regex match [\\W_]) :code:`<br>`\\ :code:`<br>`
         **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word",
         "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" :code:`<br>`\\ :code:`<br>`
         For resetting the password, see `How to reset the Remote Desktop service or its login password
         in a Windows VM <https://docs.microsoft.com/troubleshoot/azure/virtual-machines/reset-rdp>`_
         :code:`<br>`\\ :code:`<br>` For resetting root password, see `Manage users, SSH, and check or
         repair disks on Azure Linux VMs using the VMAccess Extension
         <https://docs.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection>`_.
        :paramtype admin_password: str
        :keyword custom_data: Specifies a base-64 encoded string of custom data. The base-64 encoded
         string is decoded to a binary array that is saved as a file on the Virtual Machine. The maximum
         length of the binary array is 65535 bytes. **Note: Do not pass any secrets or passwords in
         customData property.** This property cannot be updated after the VM is created. The property
         customData is passed to the VM to be saved as a file, for more information see `Custom Data on
         Azure VMs <https://azure.microsoft.com/blog/custom-data-and-cloud-init-on-windows-azure/>`_. If
         using cloud-init for your Linux VM, see `Using cloud-init to customize a Linux VM during
         creation <https://docs.microsoft.com/azure/virtual-machines/linux/using-cloud-init>`_.
        :paramtype custom_data: str
        """
        super().__init__(**kwargs)
        self.admin_password = admin_password
        self.custom_data = custom_data


class OSVersion(_serialization.Model):
    """Describes a cloud service OS version.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar properties: OS version properties.
    :vartype properties: ~azure.mgmt.compute.models.OSVersionProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "OSVersionProperties"},
    }

    def __init__(self, *, properties: Optional["_models.OSVersionProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: OS version properties.
        :paramtype properties: ~azure.mgmt.compute.models.OSVersionProperties
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.location: Optional[str] = None
        self.properties = properties


class OSVersionListResult(_serialization.Model):
    """The list operation result.

    All required parameters must be populated in order to send to server.

    :ivar value: The list of resources. Required.
    :vartype value: list[~azure.mgmt.compute.models.OSVersion]
    :ivar next_link: The URI to fetch the next page of resources. Use this to get the next page of
     resources. Do this till nextLink is null to fetch all the resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[OSVersion]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: list["_models.OSVersion"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of resources. Required.
        :paramtype value: list[~azure.mgmt.compute.models.OSVersion]
        :keyword next_link: The URI to fetch the next page of resources. Use this to get the next page
         of resources. Do this till nextLink is null to fetch all the resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class OSVersionProperties(_serialization.Model):
    """OS version properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar family: The family of this OS version.
    :vartype family: str
    :ivar family_label: The family label of this OS version.
    :vartype family_label: str
    :ivar version: The OS version.
    :vartype version: str
    :ivar label: The OS version label.
    :vartype label: str
    :ivar is_default: Specifies whether this is the default OS version for its family.
    :vartype is_default: bool
    :ivar is_active: Specifies whether this OS version is active.
    :vartype is_active: bool
    """

    _validation = {
        "family": {"readonly": True},
        "family_label": {"readonly": True},
        "version": {"readonly": True},
        "label": {"readonly": True},
        "is_default": {"readonly": True},
        "is_active": {"readonly": True},
    }

    _attribute_map = {
        "family": {"key": "family", "type": "str"},
        "family_label": {"key": "familyLabel", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "is_default": {"key": "isDefault", "type": "bool"},
        "is_active": {"key": "isActive", "type": "bool"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.family: Optional[str] = None
        self.family_label: Optional[str] = None
        self.version: Optional[str] = None
        self.label: Optional[str] = None
        self.is_default: Optional[bool] = None
        self.is_active: Optional[bool] = None


class OSVersionPropertiesBase(_serialization.Model):
    """Configuration view of an OS version.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar version: The OS version.
    :vartype version: str
    :ivar label: The OS version label.
    :vartype label: str
    :ivar is_default: Specifies whether this is the default OS version for its family.
    :vartype is_default: bool
    :ivar is_active: Specifies whether this OS version is active.
    :vartype is_active: bool
    """

    _validation = {
        "version": {"readonly": True},
        "label": {"readonly": True},
        "is_default": {"readonly": True},
        "is_active": {"readonly": True},
    }

    _attribute_map = {
        "version": {"key": "version", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "is_default": {"key": "isDefault", "type": "bool"},
        "is_active": {"key": "isActive", "type": "bool"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.version: Optional[str] = None
        self.label: Optional[str] = None
        self.is_default: Optional[bool] = None
        self.is_active: Optional[bool] = None


class PatchInstallationDetail(_serialization.Model):
    """Information about a specific patch that was encountered during an installation action.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar patch_id: A unique identifier for the patch.
    :vartype patch_id: str
    :ivar name: The friendly name of the patch.
    :vartype name: str
    :ivar version: The version string of the package. It may conform to Semantic Versioning. Only
     applies to Linux.
    :vartype version: str
    :ivar kb_id: The KBID of the patch. Only applies to Windows patches.
    :vartype kb_id: str
    :ivar classifications: The classification(s) of the patch as provided by the patch publisher.
    :vartype classifications: list[str]
    :ivar installation_state: The state of the patch after the installation operation completed.
     Known values are: "Unknown", "Installed", "Failed", "Excluded", "NotSelected", and "Pending".
    :vartype installation_state: str or ~azure.mgmt.compute.models.PatchInstallationState
    """

    _validation = {
        "patch_id": {"readonly": True},
        "name": {"readonly": True},
        "version": {"readonly": True},
        "kb_id": {"readonly": True},
        "classifications": {"readonly": True},
        "installation_state": {"readonly": True},
    }

    _attribute_map = {
        "patch_id": {"key": "patchId", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "kb_id": {"key": "kbId", "type": "str"},
        "classifications": {"key": "classifications", "type": "[str]"},
        "installation_state": {"key": "installationState", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.patch_id: Optional[str] = None
        self.name: Optional[str] = None
        self.version: Optional[str] = None
        self.kb_id: Optional[str] = None
        self.classifications: Optional[list[str]] = None
        self.installation_state: Optional[Union[str, "_models.PatchInstallationState"]] = None


class PatchSettings(_serialization.Model):
    """Specifies settings related to VM Guest Patching on Windows.

    :ivar patch_mode: Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual
     machines associated to virtual machine scale set with OrchestrationMode as Flexible.\\
     :code:`<br />`\\ :code:`<br />` Possible values are:\\ :code:`<br />`\\ :code:`<br />`
     **Manual** - You  control the application of patches to a virtual machine. You do this by
     applying patches manually inside the VM. In this mode, automatic updates are disabled; the
     property WindowsConfiguration.enableAutomaticUpdates must be false\\ :code:`<br />`\\
     :code:`<br />` **AutomaticByOS** - The virtual machine will automatically be updated by the OS.
     The property WindowsConfiguration.enableAutomaticUpdates must be true. :code:`<br />`\\
     :code:`<br />` **AutomaticByPlatform** - the virtual machine will automatically updated by the
     platform. The properties provisionVMAgent and WindowsConfiguration.enableAutomaticUpdates must
     be true. Known values are: "Manual", "AutomaticByOS", and "AutomaticByPlatform".
    :vartype patch_mode: str or ~azure.mgmt.compute.models.WindowsVMGuestPatchMode
    :ivar enable_hotpatching: Enables customers to patch their Azure VMs without requiring a
     reboot. For enableHotpatching, the 'provisionVMAgent' must be set to true and 'patchMode' must
     be set to 'AutomaticByPlatform'.
    :vartype enable_hotpatching: bool
    :ivar assessment_mode: Specifies the mode of VM Guest patch assessment for the IaaS virtual
     machine.\\ :code:`<br />`\\ :code:`<br />` Possible values are:\\ :code:`<br />`\\ :code:`<br
     />` **ImageDefault** - You control the timing of patch assessments on a virtual machine.\\
     :code:`<br />`\\ :code:`<br />` **AutomaticByPlatform** - The platform will trigger periodic
     patch assessments. The property provisionVMAgent must be true. Known values are: "ImageDefault"
     and "AutomaticByPlatform".
    :vartype assessment_mode: str or ~azure.mgmt.compute.models.WindowsPatchAssessmentMode
    :ivar automatic_by_platform_settings: Specifies additional settings for patch mode
     AutomaticByPlatform in VM Guest Patching on Windows.
    :vartype automatic_by_platform_settings:
     ~azure.mgmt.compute.models.WindowsVMGuestPatchAutomaticByPlatformSettings
    """

    _attribute_map = {
        "patch_mode": {"key": "patchMode", "type": "str"},
        "enable_hotpatching": {"key": "enableHotpatching", "type": "bool"},
        "assessment_mode": {"key": "assessmentMode", "type": "str"},
        "automatic_by_platform_settings": {
            "key": "automaticByPlatformSettings",
            "type": "WindowsVMGuestPatchAutomaticByPlatformSettings",
        },
    }

    def __init__(
        self,
        *,
        patch_mode: Optional[Union[str, "_models.WindowsVMGuestPatchMode"]] = None,
        enable_hotpatching: Optional[bool] = None,
        assessment_mode: Optional[Union[str, "_models.WindowsPatchAssessmentMode"]] = None,
        automatic_by_platform_settings: Optional["_models.WindowsVMGuestPatchAutomaticByPlatformSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword patch_mode: Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual
         machines associated to virtual machine scale set with OrchestrationMode as Flexible.\\
         :code:`<br />`\\ :code:`<br />` Possible values are:\\ :code:`<br />`\\ :code:`<br />`
         **Manual** - You  control the application of patches to a virtual machine. You do this by
         applying patches manually inside the VM. In this mode, automatic updates are disabled; the
         property WindowsConfiguration.enableAutomaticUpdates must be false\\ :code:`<br />`\\
         :code:`<br />` **AutomaticByOS** - The virtual machine will automatically be updated by the OS.
         The property WindowsConfiguration.enableAutomaticUpdates must be true. :code:`<br />`\\
         :code:`<br />` **AutomaticByPlatform** - the virtual machine will automatically updated by the
         platform. The properties provisionVMAgent and WindowsConfiguration.enableAutomaticUpdates must
         be true. Known values are: "Manual", "AutomaticByOS", and "AutomaticByPlatform".
        :paramtype patch_mode: str or ~azure.mgmt.compute.models.WindowsVMGuestPatchMode
        :keyword enable_hotpatching: Enables customers to patch their Azure VMs without requiring a
         reboot. For enableHotpatching, the 'provisionVMAgent' must be set to true and 'patchMode' must
         be set to 'AutomaticByPlatform'.
        :paramtype enable_hotpatching: bool
        :keyword assessment_mode: Specifies the mode of VM Guest patch assessment for the IaaS virtual
         machine.\\ :code:`<br />`\\ :code:`<br />` Possible values are:\\ :code:`<br />`\\ :code:`<br
         />` **ImageDefault** - You control the timing of patch assessments on a virtual machine.\\
         :code:`<br />`\\ :code:`<br />` **AutomaticByPlatform** - The platform will trigger periodic
         patch assessments. The property provisionVMAgent must be true. Known values are: "ImageDefault"
         and "AutomaticByPlatform".
        :paramtype assessment_mode: str or ~azure.mgmt.compute.models.WindowsPatchAssessmentMode
        :keyword automatic_by_platform_settings: Specifies additional settings for patch mode
         AutomaticByPlatform in VM Guest Patching on Windows.
        :paramtype automatic_by_platform_settings:
         ~azure.mgmt.compute.models.WindowsVMGuestPatchAutomaticByPlatformSettings
        """
        super().__init__(**kwargs)
        self.patch_mode = patch_mode
        self.enable_hotpatching = enable_hotpatching
        self.assessment_mode = assessment_mode
        self.automatic_by_platform_settings = automatic_by_platform_settings


class PirResource(_serialization.Model):
    """The Resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Resource name.
    :vartype name: str
    :ivar location: Resource location.
    :vartype location: str
    """

    _validation = {
        "name": {"readonly": True},
        "location": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.location: Optional[str] = None


class PirSharedGalleryResource(PirResource):
    """Base information about the shared gallery resource in pir.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Resource name.
    :vartype name: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar unique_id: The unique id of this shared gallery.
    :vartype unique_id: str
    """

    _validation = {
        "name": {"readonly": True},
        "location": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "unique_id": {"key": "identifier.uniqueId", "type": "str"},
    }

    def __init__(self, *, unique_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword unique_id: The unique id of this shared gallery.
        :paramtype unique_id: str
        """
        super().__init__(**kwargs)
        self.unique_id = unique_id


class Placement(_serialization.Model):
    """Describes the user-defined constraints for resource hardware placement.

    :ivar zone_placement_policy: Specifies the policy for resource's placement in availability
     zone. Possible values are: **Any** (used for Virtual Machines), **Auto** (used for Virtual
     Machine Scale Sets) - An availability zone will be automatically picked by system as part of
     resource creation. Known values are: "Any" and "Auto".
    :vartype zone_placement_policy: str or ~azure.mgmt.compute.models.ZonePlacementPolicyType
    :ivar include_zones: This property supplements the 'zonePlacementPolicy' property. If
     'zonePlacementPolicy' is set to 'Any'/'Auto', availability zone selected by the system must be
     present in the list of availability zones passed with 'includeZones'. If 'includeZones' is not
     provided, all availability zones in region will be considered for selection.
    :vartype include_zones: list[str]
    :ivar exclude_zones: This property supplements the 'zonePlacementPolicy' property. If
     'zonePlacementPolicy' is set to 'Any'/'Auto', availability zone selected by the system must not
     be present in the list of availability zones passed with 'excludeZones'. If 'excludeZones' is
     not provided, all availability zones in region will be considered for selection.
    :vartype exclude_zones: list[str]
    """

    _attribute_map = {
        "zone_placement_policy": {"key": "zonePlacementPolicy", "type": "str"},
        "include_zones": {"key": "includeZones", "type": "[str]"},
        "exclude_zones": {"key": "excludeZones", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        zone_placement_policy: Optional[Union[str, "_models.ZonePlacementPolicyType"]] = None,
        include_zones: Optional[list[str]] = None,
        exclude_zones: Optional[list[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword zone_placement_policy: Specifies the policy for resource's placement in availability
         zone. Possible values are: **Any** (used for Virtual Machines), **Auto** (used for Virtual
         Machine Scale Sets) - An availability zone will be automatically picked by system as part of
         resource creation. Known values are: "Any" and "Auto".
        :paramtype zone_placement_policy: str or ~azure.mgmt.compute.models.ZonePlacementPolicyType
        :keyword include_zones: This property supplements the 'zonePlacementPolicy' property. If
         'zonePlacementPolicy' is set to 'Any'/'Auto', availability zone selected by the system must be
         present in the list of availability zones passed with 'includeZones'. If 'includeZones' is not
         provided, all availability zones in region will be considered for selection.
        :paramtype include_zones: list[str]
        :keyword exclude_zones: This property supplements the 'zonePlacementPolicy' property. If
         'zonePlacementPolicy' is set to 'Any'/'Auto', availability zone selected by the system must not
         be present in the list of availability zones passed with 'excludeZones'. If 'excludeZones' is
         not provided, all availability zones in region will be considered for selection.
        :paramtype exclude_zones: list[str]
        """
        super().__init__(**kwargs)
        self.zone_placement_policy = zone_placement_policy
        self.include_zones = include_zones
        self.exclude_zones = exclude_zones


class Plan(_serialization.Model):
    """Specifies information about the marketplace image used to create the virtual machine. This
    element is only used for marketplace images. Before you can use a marketplace image from an
    API, you must enable the image for programmatic use.  In the Azure portal, find the marketplace
    image that you want to use and then click **Want to deploy programmatically, Get Started ->**.
    Enter any required information and then click **Save**.

    :ivar name: The plan ID.
    :vartype name: str
    :ivar publisher: The publisher ID.
    :vartype publisher: str
    :ivar product: Specifies the product of the image from the marketplace. This is the same value
     as Offer under the imageReference element.
    :vartype product: str
    :ivar promotion_code: The promotion code.
    :vartype promotion_code: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "publisher": {"key": "publisher", "type": "str"},
        "product": {"key": "product", "type": "str"},
        "promotion_code": {"key": "promotionCode", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        publisher: Optional[str] = None,
        product: Optional[str] = None,
        promotion_code: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The plan ID.
        :paramtype name: str
        :keyword publisher: The publisher ID.
        :paramtype publisher: str
        :keyword product: Specifies the product of the image from the marketplace. This is the same
         value as Offer under the imageReference element.
        :paramtype product: str
        :keyword promotion_code: The promotion code.
        :paramtype promotion_code: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.publisher = publisher
        self.product = product
        self.promotion_code = promotion_code


class PlatformAttribute(_serialization.Model):
    """This is the platform attribute of the image version.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: This property specifies the name of the platformAttribute. It is read-only.
    :vartype name: str
    :ivar value: This property specifies the value of the corresponding name property. It is
     read-only.
    :vartype value: str
    """

    _validation = {
        "name": {"readonly": True},
        "value": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.value: Optional[str] = None


class PolicyViolation(_serialization.Model):
    """A policy violation reported against a gallery artifact.

    :ivar category: Describes the nature of the policy violation. Known values are: "Other",
     "ImageFlaggedUnsafe", "CopyrightValidation", and "IpTheft".
    :vartype category: str or ~azure.mgmt.compute.models.PolicyViolationCategory
    :ivar details: Describes specific details about why this policy violation was reported.
    :vartype details: str
    """

    _attribute_map = {
        "category": {"key": "category", "type": "str"},
        "details": {"key": "details", "type": "str"},
    }

    def __init__(
        self,
        *,
        category: Optional[Union[str, "_models.PolicyViolationCategory"]] = None,
        details: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword category: Describes the nature of the policy violation. Known values are: "Other",
         "ImageFlaggedUnsafe", "CopyrightValidation", and "IpTheft".
        :paramtype category: str or ~azure.mgmt.compute.models.PolicyViolationCategory
        :keyword details: Describes specific details about why this policy violation was reported.
        :paramtype details: str
        """
        super().__init__(**kwargs)
        self.category = category
        self.details = details


class PriorityMixPolicy(_serialization.Model):
    """Specifies the target splits for Spot and Regular priority VMs within a scale set with flexible
    orchestration mode. With this property the customer is able to specify the base number of
    regular priority VMs created as the VMSS flex instance scales out and the split between Spot
    and Regular priority VMs after this base target has been reached.

    :ivar base_regular_priority_count: The base number of regular priority VMs that will be created
     in this scale set as it scales out.
    :vartype base_regular_priority_count: int
    :ivar regular_priority_percentage_above_base: The percentage of VM instances, after the base
     regular priority count has been reached, that are expected to use regular priority.
    :vartype regular_priority_percentage_above_base: int
    """

    _validation = {
        "regular_priority_percentage_above_base": {"maximum": 100},
    }

    _attribute_map = {
        "base_regular_priority_count": {"key": "baseRegularPriorityCount", "type": "int"},
        "regular_priority_percentage_above_base": {"key": "regularPriorityPercentageAboveBase", "type": "int"},
    }

    def __init__(
        self,
        *,
        base_regular_priority_count: Optional[int] = None,
        regular_priority_percentage_above_base: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword base_regular_priority_count: The base number of regular priority VMs that will be
         created in this scale set as it scales out.
        :paramtype base_regular_priority_count: int
        :keyword regular_priority_percentage_above_base: The percentage of VM instances, after the base
         regular priority count has been reached, that are expected to use regular priority.
        :paramtype regular_priority_percentage_above_base: int
        """
        super().__init__(**kwargs)
        self.base_regular_priority_count = base_regular_priority_count
        self.regular_priority_percentage_above_base = regular_priority_percentage_above_base


class PrivateEndpoint(_serialization.Model):
    """The Private Endpoint resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ARM identifier for Private Endpoint.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None


class PrivateEndpointConnection(ProxyResource):
    """The Private Endpoint Connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.compute.models.SystemData
    :ivar private_endpoint: The resource of private end point.
    :vartype private_endpoint: ~azure.mgmt.compute.models.PrivateEndpoint
    :ivar private_link_service_connection_state: A collection of information about the state of the
     connection between DiskAccess and Virtual Network.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.compute.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: The provisioning state of the private endpoint connection resource.
     Known values are: "Succeeded", "Creating", "Deleting", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.compute.models.PrivateEndpointConnectionProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "private_endpoint": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "private_endpoint": {"key": "properties.privateEndpoint", "type": "PrivateEndpoint"},
        "private_link_service_connection_state": {
            "key": "properties.privateLinkServiceConnectionState",
            "type": "PrivateLinkServiceConnectionState",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        private_link_service_connection_state: Optional["_models.PrivateLinkServiceConnectionState"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword private_link_service_connection_state: A collection of information about the state of
         the connection between DiskAccess and Virtual Network.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.compute.models.PrivateLinkServiceConnectionState
        """
        super().__init__(**kwargs)
        self.private_endpoint: Optional["_models.PrivateEndpoint"] = None
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state: Optional[Union[str, "_models.PrivateEndpointConnectionProvisioningState"]] = None


class PrivateEndpointConnectionListResult(_serialization.Model):
    """A list of private link resources.

    All required parameters must be populated in order to send to server.

    :ivar value: The PrivateEndpointConnection items on this page. Required.
    :vartype value: list[~azure.mgmt.compute.models.PrivateEndpointConnection]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateEndpointConnection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: list["_models.PrivateEndpointConnection"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The PrivateEndpointConnection items on this page. Required.
        :paramtype value: list[~azure.mgmt.compute.models.PrivateEndpointConnection]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PrivateLinkResource(_serialization.Model):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: private link resource Id.
    :vartype id: str
    :ivar name: private link resource name.
    :vartype name: str
    :ivar type: private link resource type.
    :vartype type: str
    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :ivar required_zone_names: The private link resource DNS zone name.
    :vartype required_zone_names: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "group_id": {"readonly": True},
        "required_members": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "group_id": {"key": "properties.groupId", "type": "str"},
        "required_members": {"key": "properties.requiredMembers", "type": "[str]"},
        "required_zone_names": {"key": "properties.requiredZoneNames", "type": "[str]"},
    }

    def __init__(self, *, required_zone_names: Optional[list[str]] = None, **kwargs: Any) -> None:
        """
        :keyword required_zone_names: The private link resource DNS zone name.
        :paramtype required_zone_names: list[str]
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.group_id: Optional[str] = None
        self.required_members: Optional[list[str]] = None
        self.required_zone_names = required_zone_names


class PrivateLinkResourceListResult(_serialization.Model):
    """A list of private link resources.

    :ivar value: Array of private link resources.
    :vartype value: list[~azure.mgmt.compute.models.PrivateLinkResource]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateLinkResource]"},
    }

    def __init__(self, *, value: Optional[list["_models.PrivateLinkResource"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Array of private link resources.
        :paramtype value: list[~azure.mgmt.compute.models.PrivateLinkResource]
        """
        super().__init__(**kwargs)
        self.value = value


class PrivateLinkServiceConnectionState(_serialization.Model):
    """A collection of information about the state of the connection between service consumer and
    provider.

    :ivar status: Indicates whether the connection has been Approved/Rejected/Removed by the owner
     of the service. Known values are: "Pending", "Approved", and "Rejected".
    :vartype status: str or ~azure.mgmt.compute.models.PrivateEndpointServiceConnectionStatus
    :ivar description: The reason for approval/rejection of the connection.
    :vartype description: str
    :ivar actions_required: A message indicating if changes on the service provider require any
     updates on the consumer.
    :vartype actions_required: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "actions_required": {"key": "actionsRequired", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.PrivateEndpointServiceConnectionStatus"]] = None,
        description: Optional[str] = None,
        actions_required: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Indicates whether the connection has been Approved/Rejected/Removed by the
         owner of the service. Known values are: "Pending", "Approved", and "Rejected".
        :paramtype status: str or ~azure.mgmt.compute.models.PrivateEndpointServiceConnectionStatus
        :keyword description: The reason for approval/rejection of the connection.
        :paramtype description: str
        :keyword actions_required: A message indicating if changes on the service provider require any
         updates on the consumer.
        :paramtype actions_required: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required


class PropertyUpdatesInProgress(_serialization.Model):
    """Properties of the disk for which update is pending.

    :ivar target_tier: The target performance tier of the disk if a tier change operation is in
     progress.
    :vartype target_tier: str
    """

    _attribute_map = {
        "target_tier": {"key": "targetTier", "type": "str"},
    }

    def __init__(self, *, target_tier: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword target_tier: The target performance tier of the disk if a tier change operation is in
         progress.
        :paramtype target_tier: str
        """
        super().__init__(**kwargs)
        self.target_tier = target_tier


class ProximityPlacementGroup(TrackedResource):
    """Specifies information about the proximity placement group.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.compute.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar zones: The availability zones.
    :vartype zones: list[str]
    :ivar proximity_placement_group_type: Specifies the type of the proximity placement group.
     Possible values are: **Standard** : Co-locate resources within an Azure region or Availability
     Zone. **Ultra** : For future use. Known values are: "Standard" and "Ultra".
    :vartype proximity_placement_group_type: str or
     ~azure.mgmt.compute.models.ProximityPlacementGroupType
    :ivar virtual_machines: A list of references to all virtual machines in the proximity placement
     group.
    :vartype virtual_machines: list[~azure.mgmt.compute.models.SubResourceWithColocationStatus]
    :ivar virtual_machine_scale_sets: A list of references to all virtual machine scale sets in the
     proximity placement group.
    :vartype virtual_machine_scale_sets:
     list[~azure.mgmt.compute.models.SubResourceWithColocationStatus]
    :ivar availability_sets: A list of references to all availability sets in the proximity
     placement group.
    :vartype availability_sets: list[~azure.mgmt.compute.models.SubResourceWithColocationStatus]
    :ivar colocation_status: Describes colocation status of the Proximity Placement Group.
    :vartype colocation_status: ~azure.mgmt.compute.models.InstanceViewStatus
    :ivar intent: Specifies the user intent of the proximity placement group.
    :vartype intent: ~azure.mgmt.compute.models.ProximityPlacementGroupPropertiesIntent
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "virtual_machines": {"readonly": True},
        "virtual_machine_scale_sets": {"readonly": True},
        "availability_sets": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "zones": {"key": "zones", "type": "[str]"},
        "proximity_placement_group_type": {"key": "properties.proximityPlacementGroupType", "type": "str"},
        "virtual_machines": {"key": "properties.virtualMachines", "type": "[SubResourceWithColocationStatus]"},
        "virtual_machine_scale_sets": {
            "key": "properties.virtualMachineScaleSets",
            "type": "[SubResourceWithColocationStatus]",
        },
        "availability_sets": {"key": "properties.availabilitySets", "type": "[SubResourceWithColocationStatus]"},
        "colocation_status": {"key": "properties.colocationStatus", "type": "InstanceViewStatus"},
        "intent": {"key": "properties.intent", "type": "ProximityPlacementGroupPropertiesIntent"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        zones: Optional[list[str]] = None,
        proximity_placement_group_type: Optional[Union[str, "_models.ProximityPlacementGroupType"]] = None,
        colocation_status: Optional["_models.InstanceViewStatus"] = None,
        intent: Optional["_models.ProximityPlacementGroupPropertiesIntent"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword zones: The availability zones.
        :paramtype zones: list[str]
        :keyword proximity_placement_group_type: Specifies the type of the proximity placement group.
         Possible values are: **Standard** : Co-locate resources within an Azure region or Availability
         Zone. **Ultra** : For future use. Known values are: "Standard" and "Ultra".
        :paramtype proximity_placement_group_type: str or
         ~azure.mgmt.compute.models.ProximityPlacementGroupType
        :keyword colocation_status: Describes colocation status of the Proximity Placement Group.
        :paramtype colocation_status: ~azure.mgmt.compute.models.InstanceViewStatus
        :keyword intent: Specifies the user intent of the proximity placement group.
        :paramtype intent: ~azure.mgmt.compute.models.ProximityPlacementGroupPropertiesIntent
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.zones = zones
        self.proximity_placement_group_type = proximity_placement_group_type
        self.virtual_machines: Optional[list["_models.SubResourceWithColocationStatus"]] = None
        self.virtual_machine_scale_sets: Optional[list["_models.SubResourceWithColocationStatus"]] = None
        self.availability_sets: Optional[list["_models.SubResourceWithColocationStatus"]] = None
        self.colocation_status = colocation_status
        self.intent = intent


class ProximityPlacementGroupListResult(_serialization.Model):
    """The List Proximity Placement Group operation response.

    All required parameters must be populated in order to send to server.

    :ivar value: The list of proximity placement groups. Required.
    :vartype value: list[~azure.mgmt.compute.models.ProximityPlacementGroup]
    :ivar next_link: The URI to fetch the next page of proximity placement groups.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ProximityPlacementGroup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: list["_models.ProximityPlacementGroup"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of proximity placement groups. Required.
        :paramtype value: list[~azure.mgmt.compute.models.ProximityPlacementGroup]
        :keyword next_link: The URI to fetch the next page of proximity placement groups.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ProximityPlacementGroupPropertiesIntent(_serialization.Model):
    """Specifies the user intent of the proximity placement group.

    :ivar vm_sizes: Specifies possible sizes of virtual machines that can be created in the
     proximity placement group.
    :vartype vm_sizes: list[str]
    """

    _attribute_map = {
        "vm_sizes": {"key": "vmSizes", "type": "[str]"},
    }

    def __init__(self, *, vm_sizes: Optional[list[str]] = None, **kwargs: Any) -> None:
        """
        :keyword vm_sizes: Specifies possible sizes of virtual machines that can be created in the
         proximity placement group.
        :paramtype vm_sizes: list[str]
        """
        super().__init__(**kwargs)
        self.vm_sizes = vm_sizes


class ProximityPlacementGroupUpdate(UpdateResource):
    """Specifies information about the proximity placement group.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """


class ProxyAgentSettings(_serialization.Model):
    """Specifies ProxyAgent settings for the virtual machine or virtual machine scale set. Minimum
    api-version: 2023-09-01.

    :ivar enabled: Specifies whether ProxyAgent feature should be enabled on the virtual machine or
     virtual machine scale set.
    :vartype enabled: bool
    :ivar mode: Specifies the mode that ProxyAgent will execute on. Warning: this property has been
     deprecated, please specify 'mode' under particular hostendpoint setting. Known values are:
     "Audit" and "Enforce".
    :vartype mode: str or ~azure.mgmt.compute.models.Mode
    :ivar key_incarnation_id: Increase the value of this property allows users to reset the key
     used for securing communication channel between guest and host.
    :vartype key_incarnation_id: int
    :ivar wire_server: Specifies the Wire Server endpoint settings while creating the virtual
     machine or virtual machine scale set. Minimum api-version: 2024-03-01.
    :vartype wire_server: ~azure.mgmt.compute.models.HostEndpointSettings
    :ivar imds: Specifies the IMDS endpoint settings while creating the virtual machine or virtual
     machine scale set. Minimum api-version: 2024-03-01.
    :vartype imds: ~azure.mgmt.compute.models.HostEndpointSettings
    :ivar add_proxy_agent_extension: Specify whether to implicitly install the ProxyAgent
     Extension. This option is currently applicable only for Linux Os.
    :vartype add_proxy_agent_extension: bool
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "mode": {"key": "mode", "type": "str"},
        "key_incarnation_id": {"key": "keyIncarnationId", "type": "int"},
        "wire_server": {"key": "wireServer", "type": "HostEndpointSettings"},
        "imds": {"key": "imds", "type": "HostEndpointSettings"},
        "add_proxy_agent_extension": {"key": "addProxyAgentExtension", "type": "bool"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        mode: Optional[Union[str, "_models.Mode"]] = None,
        key_incarnation_id: Optional[int] = None,
        wire_server: Optional["_models.HostEndpointSettings"] = None,
        imds: Optional["_models.HostEndpointSettings"] = None,
        add_proxy_agent_extension: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Specifies whether ProxyAgent feature should be enabled on the virtual machine
         or virtual machine scale set.
        :paramtype enabled: bool
        :keyword mode: Specifies the mode that ProxyAgent will execute on. Warning: this property has
         been deprecated, please specify 'mode' under particular hostendpoint setting. Known values are:
         "Audit" and "Enforce".
        :paramtype mode: str or ~azure.mgmt.compute.models.Mode
        :keyword key_incarnation_id: Increase the value of this property allows users to reset the key
         used for securing communication channel between guest and host.
        :paramtype key_incarnation_id: int
        :keyword wire_server: Specifies the Wire Server endpoint settings while creating the virtual
         machine or virtual machine scale set. Minimum api-version: 2024-03-01.
        :paramtype wire_server: ~azure.mgmt.compute.models.HostEndpointSettings
        :keyword imds: Specifies the IMDS endpoint settings while creating the virtual machine or
         virtual machine scale set. Minimum api-version: 2024-03-01.
        :paramtype imds: ~azure.mgmt.compute.models.HostEndpointSettings
        :keyword add_proxy_agent_extension: Specify whether to implicitly install the ProxyAgent
         Extension. This option is currently applicable only for Linux Os.
        :paramtype add_proxy_agent_extension: bool
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.mode = mode
        self.key_incarnation_id = key_incarnation_id
        self.wire_server = wire_server
        self.imds = imds
        self.add_proxy_agent_extension = add_proxy_agent_extension


class PublicIPAddressSku(_serialization.Model):
    """Describes the public IP Sku. It can only be set with OrchestrationMode as Flexible.

    :ivar name: Specify public IP sku name. Known values are: "Basic" and "Standard".
    :vartype name: str or ~azure.mgmt.compute.models.PublicIPAddressSkuName
    :ivar tier: Specify public IP sku tier. Known values are: "Regional", "Global", and "Global".
    :vartype tier: str or ~azure.mgmt.compute.models.PublicIPAddressSkuTier
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "_models.PublicIPAddressSkuName"]] = None,
        tier: Optional[Union[str, "_models.PublicIPAddressSkuTier"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Specify public IP sku name. Known values are: "Basic" and "Standard".
        :paramtype name: str or ~azure.mgmt.compute.models.PublicIPAddressSkuName
        :keyword tier: Specify public IP sku tier. Known values are: "Regional", "Global", and
         "Global".
        :paramtype tier: str or ~azure.mgmt.compute.models.PublicIPAddressSkuTier
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier


class PurchasePlan(_serialization.Model):
    """Used for establishing the purchase context of any 3rd Party artifact through MarketPlace.

    All required parameters must be populated in order to send to server.

    :ivar publisher: The publisher ID. Required.
    :vartype publisher: str
    :ivar name: The plan ID. Required.
    :vartype name: str
    :ivar product: Specifies the product of the image from the marketplace. This is the same value
     as Offer under the imageReference element. Required.
    :vartype product: str
    """

    _validation = {
        "publisher": {"required": True},
        "name": {"required": True},
        "product": {"required": True},
    }

    _attribute_map = {
        "publisher": {"key": "publisher", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "product": {"key": "product", "type": "str"},
    }

    def __init__(self, *, publisher: str, name: str, product: str, **kwargs: Any) -> None:
        """
        :keyword publisher: The publisher ID. Required.
        :paramtype publisher: str
        :keyword name: The plan ID. Required.
        :paramtype name: str
        :keyword product: Specifies the product of the image from the marketplace. This is the same
         value as Offer under the imageReference element. Required.
        :paramtype product: str
        """
        super().__init__(**kwargs)
        self.publisher = publisher
        self.name = name
        self.product = product


class RecommendedMachineConfiguration(_serialization.Model):
    """The properties describe the recommended machine configuration for this Image Definition. These
    properties are updatable.

    :ivar v_cp_us: Describes the resource range.
    :vartype v_cp_us: ~azure.mgmt.compute.models.ResourceRange
    :ivar memory: Describes the resource range.
    :vartype memory: ~azure.mgmt.compute.models.ResourceRange
    """

    _attribute_map = {
        "v_cp_us": {"key": "vCPUs", "type": "ResourceRange"},
        "memory": {"key": "memory", "type": "ResourceRange"},
    }

    def __init__(
        self,
        *,
        v_cp_us: Optional["_models.ResourceRange"] = None,
        memory: Optional["_models.ResourceRange"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword v_cp_us: Describes the resource range.
        :paramtype v_cp_us: ~azure.mgmt.compute.models.ResourceRange
        :keyword memory: Describes the resource range.
        :paramtype memory: ~azure.mgmt.compute.models.ResourceRange
        """
        super().__init__(**kwargs)
        self.v_cp_us = v_cp_us
        self.memory = memory


class RecoveryWalkResponse(_serialization.Model):
    """Response after calling a manual recovery walk.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar walk_performed: Whether the recovery walk was performed.
    :vartype walk_performed: bool
    :ivar next_platform_update_domain: The next update domain that needs to be walked. Null means
     walk spanning all update domains has been completed.
    :vartype next_platform_update_domain: int
    """

    _validation = {
        "walk_performed": {"readonly": True},
        "next_platform_update_domain": {"readonly": True},
    }

    _attribute_map = {
        "walk_performed": {"key": "walkPerformed", "type": "bool"},
        "next_platform_update_domain": {"key": "nextPlatformUpdateDomain", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.walk_performed: Optional[bool] = None
        self.next_platform_update_domain: Optional[int] = None


class RegionalReplicationStatus(_serialization.Model):
    """This is the regional replication status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar region: The region to which the gallery image version is being replicated to.
    :vartype region: str
    :ivar state: This is the regional replication state. Known values are: "Unknown",
     "Replicating", "Completed", and "Failed".
    :vartype state: str or ~azure.mgmt.compute.models.ReplicationState
    :ivar details: The details of the replication status.
    :vartype details: str
    :ivar progress: It indicates progress of the replication job.
    :vartype progress: int
    """

    _validation = {
        "region": {"readonly": True},
        "state": {"readonly": True},
        "details": {"readonly": True},
        "progress": {"readonly": True},
    }

    _attribute_map = {
        "region": {"key": "region", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "details": {"key": "details", "type": "str"},
        "progress": {"key": "progress", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.region: Optional[str] = None
        self.state: Optional[Union[str, "_models.ReplicationState"]] = None
        self.details: Optional[str] = None
        self.progress: Optional[int] = None


class RegionalSharingStatus(_serialization.Model):
    """Gallery regional sharing status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar region: Region name.
    :vartype region: str
    :ivar state: Gallery sharing state in current region. Known values are: "Succeeded",
     "InProgress", "Failed", and "Unknown".
    :vartype state: str or ~azure.mgmt.compute.models.SharingState
    :ivar details: Details of gallery regional sharing failure.
    :vartype details: str
    """

    _validation = {
        "state": {"readonly": True},
    }

    _attribute_map = {
        "region": {"key": "region", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "details": {"key": "details", "type": "str"},
    }

    def __init__(self, *, region: Optional[str] = None, details: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword region: Region name.
        :paramtype region: str
        :keyword details: Details of gallery regional sharing failure.
        :paramtype details: str
        """
        super().__init__(**kwargs)
        self.region = region
        self.state: Optional[Union[str, "_models.SharingState"]] = None
        self.details = details


class ReplicationStatus(_serialization.Model):
    """This is the replication status of the gallery image version.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar aggregated_state: This is the aggregated replication status based on all the regional
     replication status flags. Known values are: "Unknown", "InProgress", "Completed", and "Failed".
    :vartype aggregated_state: str or ~azure.mgmt.compute.models.AggregatedReplicationState
    :ivar summary: This is a summary of replication status for each region.
    :vartype summary: list[~azure.mgmt.compute.models.RegionalReplicationStatus]
    """

    _validation = {
        "aggregated_state": {"readonly": True},
        "summary": {"readonly": True},
    }

    _attribute_map = {
        "aggregated_state": {"key": "aggregatedState", "type": "str"},
        "summary": {"key": "summary", "type": "[RegionalReplicationStatus]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.aggregated_state: Optional[Union[str, "_models.AggregatedReplicationState"]] = None
        self.summary: Optional[list["_models.RegionalReplicationStatus"]] = None


class RequestRateByIntervalInput(LogAnalyticsInputBase):
    """Api request input for LogAnalytics getRequestRateByInterval Api.

    All required parameters must be populated in order to send to server.

    :ivar blob_container_sas_uri: SAS Uri of the logging blob container to which LogAnalytics Api
     writes output logs to. Required.
    :vartype blob_container_sas_uri: str
    :ivar from_time: From time of the query. Required.
    :vartype from_time: ~datetime.datetime
    :ivar to_time: To time of the query. Required.
    :vartype to_time: ~datetime.datetime
    :ivar group_by_throttle_policy: Group query result by Throttle Policy applied.
    :vartype group_by_throttle_policy: bool
    :ivar group_by_operation_name: Group query result by Operation Name.
    :vartype group_by_operation_name: bool
    :ivar group_by_resource_name: Group query result by Resource Name.
    :vartype group_by_resource_name: bool
    :ivar group_by_client_application_id: Group query result by Client Application ID.
    :vartype group_by_client_application_id: bool
    :ivar group_by_user_agent: Group query result by User Agent.
    :vartype group_by_user_agent: bool
    :ivar interval_length: Interval value in minutes used to create LogAnalytics call rate logs.
     Required. Known values are: "ThreeMins", "FiveMins", "ThirtyMins", and "SixtyMins".
    :vartype interval_length: str or ~azure.mgmt.compute.models.IntervalInMins
    """

    _validation = {
        "blob_container_sas_uri": {"required": True},
        "from_time": {"required": True},
        "to_time": {"required": True},
        "interval_length": {"required": True},
    }

    _attribute_map = {
        "blob_container_sas_uri": {"key": "blobContainerSasUri", "type": "str"},
        "from_time": {"key": "fromTime", "type": "iso-8601"},
        "to_time": {"key": "toTime", "type": "iso-8601"},
        "group_by_throttle_policy": {"key": "groupByThrottlePolicy", "type": "bool"},
        "group_by_operation_name": {"key": "groupByOperationName", "type": "bool"},
        "group_by_resource_name": {"key": "groupByResourceName", "type": "bool"},
        "group_by_client_application_id": {"key": "groupByClientApplicationId", "type": "bool"},
        "group_by_user_agent": {"key": "groupByUserAgent", "type": "bool"},
        "interval_length": {"key": "intervalLength", "type": "str"},
    }

    def __init__(
        self,
        *,
        blob_container_sas_uri: str,
        from_time: datetime.datetime,
        to_time: datetime.datetime,
        interval_length: Union[str, "_models.IntervalInMins"],
        group_by_throttle_policy: Optional[bool] = None,
        group_by_operation_name: Optional[bool] = None,
        group_by_resource_name: Optional[bool] = None,
        group_by_client_application_id: Optional[bool] = None,
        group_by_user_agent: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword blob_container_sas_uri: SAS Uri of the logging blob container to which LogAnalytics
         Api writes output logs to. Required.
        :paramtype blob_container_sas_uri: str
        :keyword from_time: From time of the query. Required.
        :paramtype from_time: ~datetime.datetime
        :keyword to_time: To time of the query. Required.
        :paramtype to_time: ~datetime.datetime
        :keyword group_by_throttle_policy: Group query result by Throttle Policy applied.
        :paramtype group_by_throttle_policy: bool
        :keyword group_by_operation_name: Group query result by Operation Name.
        :paramtype group_by_operation_name: bool
        :keyword group_by_resource_name: Group query result by Resource Name.
        :paramtype group_by_resource_name: bool
        :keyword group_by_client_application_id: Group query result by Client Application ID.
        :paramtype group_by_client_application_id: bool
        :keyword group_by_user_agent: Group query result by User Agent.
        :paramtype group_by_user_agent: bool
        :keyword interval_length: Interval value in minutes used to create LogAnalytics call rate logs.
         Required. Known values are: "ThreeMins", "FiveMins", "ThirtyMins", and "SixtyMins".
        :paramtype interval_length: str or ~azure.mgmt.compute.models.IntervalInMins
        """
        super().__init__(
            blob_container_sas_uri=blob_container_sas_uri,
            from_time=from_time,
            to_time=to_time,
            group_by_throttle_policy=group_by_throttle_policy,
            group_by_operation_name=group_by_operation_name,
            group_by_resource_name=group_by_resource_name,
            group_by_client_application_id=group_by_client_application_id,
            group_by_user_agent=group_by_user_agent,
            **kwargs
        )
        self.interval_length = interval_length


class ResiliencyPolicy(_serialization.Model):
    """Describes an resiliency policy - AutomaticZoneRebalancingPolicy, ResilientVMCreationPolicy
    and/or ResilientVMDeletionPolicy.

    :ivar resilient_vm_creation_policy: The configuration parameters used while performing
     resilient VM creation.
    :vartype resilient_vm_creation_policy: ~azure.mgmt.compute.models.ResilientVMCreationPolicy
    :ivar resilient_vm_deletion_policy: The configuration parameters used while performing
     resilient VM deletion.
    :vartype resilient_vm_deletion_policy: ~azure.mgmt.compute.models.ResilientVMDeletionPolicy
    :ivar automatic_zone_rebalancing_policy: The configuration parameters used while performing
     automatic AZ balancing.
    :vartype automatic_zone_rebalancing_policy:
     ~azure.mgmt.compute.models.AutomaticZoneRebalancingPolicy
    :ivar zone_allocation_policy: The configuration parameters used while performing zone
     allocation.
    :vartype zone_allocation_policy: ~azure.mgmt.compute.models.ZoneAllocationPolicy
    """

    _attribute_map = {
        "resilient_vm_creation_policy": {"key": "resilientVMCreationPolicy", "type": "ResilientVMCreationPolicy"},
        "resilient_vm_deletion_policy": {"key": "resilientVMDeletionPolicy", "type": "ResilientVMDeletionPolicy"},
        "automatic_zone_rebalancing_policy": {
            "key": "automaticZoneRebalancingPolicy",
            "type": "AutomaticZoneRebalancingPolicy",
        },
        "zone_allocation_policy": {"key": "zoneAllocationPolicy", "type": "ZoneAllocationPolicy"},
    }

    def __init__(
        self,
        *,
        resilient_vm_creation_policy: Optional["_models.ResilientVMCreationPolicy"] = None,
        resilient_vm_deletion_policy: Optional["_models.ResilientVMDeletionPolicy"] = None,
        automatic_zone_rebalancing_policy: Optional["_models.AutomaticZoneRebalancingPolicy"] = None,
        zone_allocation_policy: Optional["_models.ZoneAllocationPolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resilient_vm_creation_policy: The configuration parameters used while performing
         resilient VM creation.
        :paramtype resilient_vm_creation_policy: ~azure.mgmt.compute.models.ResilientVMCreationPolicy
        :keyword resilient_vm_deletion_policy: The configuration parameters used while performing
         resilient VM deletion.
        :paramtype resilient_vm_deletion_policy: ~azure.mgmt.compute.models.ResilientVMDeletionPolicy
        :keyword automatic_zone_rebalancing_policy: The configuration parameters used while performing
         automatic AZ balancing.
        :paramtype automatic_zone_rebalancing_policy:
         ~azure.mgmt.compute.models.AutomaticZoneRebalancingPolicy
        :keyword zone_allocation_policy: The configuration parameters used while performing zone
         allocation.
        :paramtype zone_allocation_policy: ~azure.mgmt.compute.models.ZoneAllocationPolicy
        """
        super().__init__(**kwargs)
        self.resilient_vm_creation_policy = resilient_vm_creation_policy
        self.resilient_vm_deletion_policy = resilient_vm_deletion_policy
        self.automatic_zone_rebalancing_policy = automatic_zone_rebalancing_policy
        self.zone_allocation_policy = zone_allocation_policy


class ResilientVMCreationPolicy(_serialization.Model):
    """The configuration parameters used while performing resilient VM creation.

    :ivar enabled: Specifies whether resilient VM creation should be enabled on the virtual machine
     scale set. The default value is false.
    :vartype enabled: bool
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Specifies whether resilient VM creation should be enabled on the virtual
         machine scale set. The default value is false.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.enabled = enabled


class ResilientVMDeletionPolicy(_serialization.Model):
    """The configuration parameters used while performing resilient VM deletion.

    :ivar enabled: Specifies whether resilient VM deletion should be enabled on the virtual machine
     scale set. The default value is false.
    :vartype enabled: bool
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Specifies whether resilient VM deletion should be enabled on the virtual
         machine scale set. The default value is false.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.enabled = enabled


class ResourceInstanceViewStatus(_serialization.Model):
    """Instance view status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The status code.
    :vartype code: str
    :ivar display_status: The short localizable label for the status.
    :vartype display_status: str
    :ivar message: The detailed status message, including for alerts and error messages.
    :vartype message: str
    :ivar time: The time of the status.
    :vartype time: ~datetime.datetime
    :ivar level: The level code. Known values are: "Info", "Warning", and "Error".
    :vartype level: str or ~azure.mgmt.compute.models.StatusLevelTypes
    """

    _validation = {
        "code": {"readonly": True},
        "display_status": {"readonly": True},
        "message": {"readonly": True},
        "time": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "display_status": {"key": "displayStatus", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "time": {"key": "time", "type": "iso-8601"},
        "level": {"key": "level", "type": "str"},
    }

    def __init__(self, *, level: Optional[Union[str, "_models.StatusLevelTypes"]] = None, **kwargs: Any) -> None:
        """
        :keyword level: The level code. Known values are: "Info", "Warning", and "Error".
        :paramtype level: str or ~azure.mgmt.compute.models.StatusLevelTypes
        """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.display_status: Optional[str] = None
        self.message: Optional[str] = None
        self.time: Optional[datetime.datetime] = None
        self.level = level


class ResourceRange(_serialization.Model):
    """Describes the resource range.

    :ivar min: The minimum number of the resource.
    :vartype min: int
    :ivar max: The maximum number of the resource.
    :vartype max: int
    """

    _attribute_map = {
        "min": {"key": "min", "type": "int"},
        "max": {"key": "max", "type": "int"},
    }

    def __init__(
        self,
        *,
        min: Optional[int] = None,  # pylint: disable=redefined-builtin
        max: Optional[int] = None,  # pylint: disable=redefined-builtin
        **kwargs: Any
    ) -> None:
        """
        :keyword min: The minimum number of the resource.
        :paramtype min: int
        :keyword max: The maximum number of the resource.
        :paramtype max: int
        """
        super().__init__(**kwargs)
        self.min = min
        self.max = max


class ResourceSharingProfile(_serialization.Model):
    """ResourceSharingProfile.

    :ivar subscription_ids: Specifies an array of subscription resource IDs that capacity
     reservation group is shared with. Block Capacity Reservations does not support sharing across
     subscriptions. **Note:** Minimum api-version: 2023-09-01. Please refer to
     https://aka.ms/computereservationsharing for more details.
    :vartype subscription_ids: list[~azure.mgmt.compute.models.SubResource]
    """

    _attribute_map = {
        "subscription_ids": {"key": "subscriptionIds", "type": "[SubResource]"},
    }

    def __init__(self, *, subscription_ids: Optional[list["_models.SubResource"]] = None, **kwargs: Any) -> None:
        """
        :keyword subscription_ids: Specifies an array of subscription resource IDs that capacity
         reservation group is shared with. Block Capacity Reservations does not support sharing across
         subscriptions. **Note:** Minimum api-version: 2023-09-01. Please refer to
         https://aka.ms/computereservationsharing for more details.
        :paramtype subscription_ids: list[~azure.mgmt.compute.models.SubResource]
        """
        super().__init__(**kwargs)
        self.subscription_ids = subscription_ids


class ResourceSku(_serialization.Model):
    """Describes an available Compute SKU.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_type: The type of resource the SKU applies to.
    :vartype resource_type: str
    :ivar name: The name of SKU.
    :vartype name: str
    :ivar tier: Specifies the tier of virtual machines in a scale set.\\ :code:`<br />`\\
     :code:`<br />` Possible Values:\\ :code:`<br />`\\ :code:`<br />` **Standard**\\ :code:`<br
     />`\\ :code:`<br />` **Basic**.
    :vartype tier: str
    :ivar size: The Size of the SKU.
    :vartype size: str
    :ivar family: The Family of this particular SKU.
    :vartype family: str
    :ivar kind: The Kind of resources that are supported in this SKU.
    :vartype kind: str
    :ivar capacity: Specifies the number of virtual machines in the scale set.
    :vartype capacity: ~azure.mgmt.compute.models.ResourceSkuCapacity
    :ivar locations: The set of locations that the SKU is available.
    :vartype locations: list[str]
    :ivar location_info: A list of locations and availability zones in those locations where the
     SKU is available.
    :vartype location_info: list[~azure.mgmt.compute.models.ResourceSkuLocationInfo]
    :ivar api_versions: The api versions that support this SKU.
    :vartype api_versions: list[str]
    :ivar costs: Metadata for retrieving price info.
    :vartype costs: list[~azure.mgmt.compute.models.ResourceSkuCosts]
    :ivar capabilities: A name value pair to describe the capability.
    :vartype capabilities: list[~azure.mgmt.compute.models.ResourceSkuCapabilities]
    :ivar restrictions: The restrictions because of which SKU cannot be used. This is empty if
     there are no restrictions.
    :vartype restrictions: list[~azure.mgmt.compute.models.ResourceSkuRestrictions]
    """

    _validation = {
        "resource_type": {"readonly": True},
        "name": {"readonly": True},
        "tier": {"readonly": True},
        "size": {"readonly": True},
        "family": {"readonly": True},
        "kind": {"readonly": True},
        "capacity": {"readonly": True},
        "locations": {"readonly": True},
        "location_info": {"readonly": True},
        "api_versions": {"readonly": True},
        "costs": {"readonly": True},
        "capabilities": {"readonly": True},
        "restrictions": {"readonly": True},
    }

    _attribute_map = {
        "resource_type": {"key": "resourceType", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "size": {"key": "size", "type": "str"},
        "family": {"key": "family", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "capacity": {"key": "capacity", "type": "ResourceSkuCapacity"},
        "locations": {"key": "locations", "type": "[str]"},
        "location_info": {"key": "locationInfo", "type": "[ResourceSkuLocationInfo]"},
        "api_versions": {"key": "apiVersions", "type": "[str]"},
        "costs": {"key": "costs", "type": "[ResourceSkuCosts]"},
        "capabilities": {"key": "capabilities", "type": "[ResourceSkuCapabilities]"},
        "restrictions": {"key": "restrictions", "type": "[ResourceSkuRestrictions]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.resource_type: Optional[str] = None
        self.name: Optional[str] = None
        self.tier: Optional[str] = None
        self.size: Optional[str] = None
        self.family: Optional[str] = None
        self.kind: Optional[str] = None
        self.capacity: Optional["_models.ResourceSkuCapacity"] = None
        self.locations: Optional[list[str]] = None
        self.location_info: Optional[list["_models.ResourceSkuLocationInfo"]] = None
        self.api_versions: Optional[list[str]] = None
        self.costs: Optional[list["_models.ResourceSkuCosts"]] = None
        self.capabilities: Optional[list["_models.ResourceSkuCapabilities"]] = None
        self.restrictions: Optional[list["_models.ResourceSkuRestrictions"]] = None


class ResourceSkuCapabilities(_serialization.Model):
    """Describes The SKU capabilities object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: An invariant to describe the feature.
    :vartype name: str
    :ivar value: An invariant if the feature is measured by quantity.
    :vartype value: str
    """

    _validation = {
        "name": {"readonly": True},
        "value": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.value: Optional[str] = None


class ResourceSkuCapacity(_serialization.Model):
    """Describes scaling information of a SKU.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar minimum: The minimum capacity.
    :vartype minimum: int
    :ivar maximum: The maximum capacity that can be set.
    :vartype maximum: int
    :ivar default: The default capacity.
    :vartype default: int
    :ivar scale_type: The scale type applicable to the sku. Known values are: "Automatic",
     "Manual", and "None".
    :vartype scale_type: str or ~azure.mgmt.compute.models.ResourceSkuCapacityScaleType
    """

    _validation = {
        "minimum": {"readonly": True},
        "maximum": {"readonly": True},
        "default": {"readonly": True},
        "scale_type": {"readonly": True},
    }

    _attribute_map = {
        "minimum": {"key": "minimum", "type": "int"},
        "maximum": {"key": "maximum", "type": "int"},
        "default": {"key": "default", "type": "int"},
        "scale_type": {"key": "scaleType", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.minimum: Optional[int] = None
        self.maximum: Optional[int] = None
        self.default: Optional[int] = None
        self.scale_type: Optional[Union[str, "_models.ResourceSkuCapacityScaleType"]] = None


class ResourceSkuCosts(_serialization.Model):
    """Describes metadata for retrieving price info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar meter_id: Used for querying price from commerce.
    :vartype meter_id: str
    :ivar quantity: The multiplier is needed to extend the base metered cost.
    :vartype quantity: int
    :ivar extended_unit: An invariant to show the extended unit.
    :vartype extended_unit: str
    """

    _validation = {
        "meter_id": {"readonly": True},
        "quantity": {"readonly": True},
        "extended_unit": {"readonly": True},
    }

    _attribute_map = {
        "meter_id": {"key": "meterID", "type": "str"},
        "quantity": {"key": "quantity", "type": "int"},
        "extended_unit": {"key": "extendedUnit", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.meter_id: Optional[str] = None
        self.quantity: Optional[int] = None
        self.extended_unit: Optional[str] = None


class ResourceSkuLocationInfo(_serialization.Model):
    """Describes an available Compute SKU Location Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: Location of the SKU.
    :vartype location: str
    :ivar zones: List of availability zones where the SKU is supported.
    :vartype zones: list[str]
    :ivar zone_details: Details of capabilities available to a SKU in specific zones.
    :vartype zone_details: list[~azure.mgmt.compute.models.ResourceSkuZoneDetails]
    :ivar extended_locations: The names of extended locations.
    :vartype extended_locations: list[str]
    :ivar type: The type of the extended location. "EdgeZone"
    :vartype type: str or ~azure.mgmt.compute.models.ExtendedLocationType
    """

    _validation = {
        "location": {"readonly": True},
        "zones": {"readonly": True},
        "zone_details": {"readonly": True},
        "extended_locations": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "zones": {"key": "zones", "type": "[str]"},
        "zone_details": {"key": "zoneDetails", "type": "[ResourceSkuZoneDetails]"},
        "extended_locations": {"key": "extendedLocations", "type": "[str]"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.location: Optional[str] = None
        self.zones: Optional[list[str]] = None
        self.zone_details: Optional[list["_models.ResourceSkuZoneDetails"]] = None
        self.extended_locations: Optional[list[str]] = None
        self.type: Optional[Union[str, "_models.ExtendedLocationType"]] = None


class ResourceSkuRestrictionInfo(_serialization.Model):
    """Describes an available Compute SKU Restriction Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar locations: Locations where the SKU is restricted.
    :vartype locations: list[str]
    :ivar zones: List of availability zones where the SKU is restricted.
    :vartype zones: list[str]
    """

    _validation = {
        "locations": {"readonly": True},
        "zones": {"readonly": True},
    }

    _attribute_map = {
        "locations": {"key": "locations", "type": "[str]"},
        "zones": {"key": "zones", "type": "[str]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.locations: Optional[list[str]] = None
        self.zones: Optional[list[str]] = None


class ResourceSkuRestrictions(_serialization.Model):
    """Describes scaling information of a SKU.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of restrictions. Known values are: "Location" and "Zone".
    :vartype type: str or ~azure.mgmt.compute.models.ResourceSkuRestrictionsType
    :ivar values: The value of restrictions. If the restriction type is set to location. This would
     be different locations where the SKU is restricted.
    :vartype values: list[str]
    :ivar restriction_info: The information about the restriction where the SKU cannot be used.
    :vartype restriction_info: ~azure.mgmt.compute.models.ResourceSkuRestrictionInfo
    :ivar reason_code: The reason for restriction. Known values are: "QuotaId" and
     "NotAvailableForSubscription".
    :vartype reason_code: str or ~azure.mgmt.compute.models.ResourceSkuRestrictionsReasonCode
    """

    _validation = {
        "type": {"readonly": True},
        "values": {"readonly": True},
        "restriction_info": {"readonly": True},
        "reason_code": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "values": {"key": "values", "type": "[str]"},
        "restriction_info": {"key": "restrictionInfo", "type": "ResourceSkuRestrictionInfo"},
        "reason_code": {"key": "reasonCode", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[Union[str, "_models.ResourceSkuRestrictionsType"]] = None
        self.values: Optional[list[str]] = None
        self.restriction_info: Optional["_models.ResourceSkuRestrictionInfo"] = None
        self.reason_code: Optional[Union[str, "_models.ResourceSkuRestrictionsReasonCode"]] = None


class ResourceSkusResult(_serialization.Model):
    """The List Resource Skus operation response.

    All required parameters must be populated in order to send to server.

    :ivar value: The ResourceSku items on this page. Required.
    :vartype value: list[~azure.mgmt.compute.models.ResourceSku]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ResourceSku]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: list["_models.ResourceSku"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The ResourceSku items on this page. Required.
        :paramtype value: list[~azure.mgmt.compute.models.ResourceSku]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ResourceSkuZoneDetails(_serialization.Model):
    """Describes The zonal capabilities of a SKU.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The set of zones that the SKU is available in with the specified capabilities.
    :vartype name: list[str]
    :ivar capabilities: A list of capabilities that are available for the SKU in the specified list
     of zones.
    :vartype capabilities: list[~azure.mgmt.compute.models.ResourceSkuCapabilities]
    """

    _validation = {
        "name": {"readonly": True},
        "capabilities": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "[str]"},
        "capabilities": {"key": "capabilities", "type": "[ResourceSkuCapabilities]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name: Optional[list[str]] = None
        self.capabilities: Optional[list["_models.ResourceSkuCapabilities"]] = None


class ResourceUriList(_serialization.Model):
    """The List resources which are encrypted with the disk encryption set.

    All required parameters must be populated in order to send to server.

    :ivar value: A list of IDs or Owner IDs of resources which are encrypted with the disk
     encryption set. Required.
    :vartype value: list[str]
    :ivar next_link: The uri to fetch the next page of encrypted resources. Call ListNext() with
     this to fetch the next page of encrypted resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[str]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: list[str], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of IDs or Owner IDs of resources which are encrypted with the disk
         encryption set. Required.
        :paramtype value: list[str]
        :keyword next_link: The uri to fetch the next page of encrypted resources. Call ListNext() with
         this to fetch the next page of encrypted resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ResourceWithOptionalLocation(_serialization.Model):
    """The Resource model definition with location property as optional.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: Resource location.
    :vartype location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, location: Optional[str] = None, tags: Optional[dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.location = location
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.tags = tags


class RestorePoint(ProxyResource):
    """Restore Point details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.compute.models.SystemData
    :ivar exclude_disks: List of disk resource ids that the customer wishes to exclude from the
     restore point. If no disks are specified, all disks will be included.
    :vartype exclude_disks: list[~azure.mgmt.compute.models.ApiEntityReference]
    :ivar source_metadata: Gets the details of the VM captured at the time of the restore point
     creation.
    :vartype source_metadata: ~azure.mgmt.compute.models.RestorePointSourceMetadata
    :ivar provisioning_state: Gets the provisioning state of the restore point.
    :vartype provisioning_state: str
    :ivar consistency_mode: ConsistencyMode of the RestorePoint. Can be specified in the input
     while creating a restore point. For now, only CrashConsistent is accepted as a valid input.
     Please refer to https://aka.ms/RestorePoints for more details. Known values are:
     "CrashConsistent", "FileSystemConsistent", and "ApplicationConsistent".
    :vartype consistency_mode: str or ~azure.mgmt.compute.models.ConsistencyModeTypes
    :ivar time_created: Gets the creation time of the restore point.
    :vartype time_created: ~datetime.datetime
    :ivar source_restore_point: Resource Id of the source restore point from which a copy needs to
     be created.
    :vartype source_restore_point: ~azure.mgmt.compute.models.ApiEntityReference
    :ivar instance_view: The restore point instance view.
    :vartype instance_view: ~azure.mgmt.compute.models.RestorePointInstanceView
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "instance_view": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "exclude_disks": {"key": "properties.excludeDisks", "type": "[ApiEntityReference]"},
        "source_metadata": {"key": "properties.sourceMetadata", "type": "RestorePointSourceMetadata"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "consistency_mode": {"key": "properties.consistencyMode", "type": "str"},
        "time_created": {"key": "properties.timeCreated", "type": "iso-8601"},
        "source_restore_point": {"key": "properties.sourceRestorePoint", "type": "ApiEntityReference"},
        "instance_view": {"key": "properties.instanceView", "type": "RestorePointInstanceView"},
    }

    def __init__(
        self,
        *,
        exclude_disks: Optional[list["_models.ApiEntityReference"]] = None,
        source_metadata: Optional["_models.RestorePointSourceMetadata"] = None,
        consistency_mode: Optional[Union[str, "_models.ConsistencyModeTypes"]] = None,
        time_created: Optional[datetime.datetime] = None,
        source_restore_point: Optional["_models.ApiEntityReference"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword exclude_disks: List of disk resource ids that the customer wishes to exclude from the
         restore point. If no disks are specified, all disks will be included.
        :paramtype exclude_disks: list[~azure.mgmt.compute.models.ApiEntityReference]
        :keyword source_metadata: Gets the details of the VM captured at the time of the restore point
         creation.
        :paramtype source_metadata: ~azure.mgmt.compute.models.RestorePointSourceMetadata
        :keyword consistency_mode: ConsistencyMode of the RestorePoint. Can be specified in the input
         while creating a restore point. For now, only CrashConsistent is accepted as a valid input.
         Please refer to https://aka.ms/RestorePoints for more details. Known values are:
         "CrashConsistent", "FileSystemConsistent", and "ApplicationConsistent".
        :paramtype consistency_mode: str or ~azure.mgmt.compute.models.ConsistencyModeTypes
        :keyword time_created: Gets the creation time of the restore point.
        :paramtype time_created: ~datetime.datetime
        :keyword source_restore_point: Resource Id of the source restore point from which a copy needs
         to be created.
        :paramtype source_restore_point: ~azure.mgmt.compute.models.ApiEntityReference
        """
        super().__init__(**kwargs)
        self.exclude_disks = exclude_disks
        self.source_metadata = source_metadata
        self.provisioning_state: Optional[str] = None
        self.consistency_mode = consistency_mode
        self.time_created = time_created
        self.source_restore_point = source_restore_point
        self.instance_view: Optional["_models.RestorePointInstanceView"] = None


class RestorePointCollection(TrackedResource):
    """Create or update Restore Point collection parameters.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.compute.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar source: The properties of the source resource that this restore point collection is
     created from.
    :vartype source: ~azure.mgmt.compute.models.RestorePointCollectionSourceProperties
    :ivar provisioning_state: The provisioning state of the restore point collection.
    :vartype provisioning_state: str
    :ivar restore_point_collection_id: The unique id of the restore point collection.
    :vartype restore_point_collection_id: str
    :ivar restore_points: A list containing all restore points created under this restore point
     collection.
    :vartype restore_points: list[~azure.mgmt.compute.models.RestorePoint]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "restore_point_collection_id": {"readonly": True},
        "restore_points": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "source": {"key": "properties.source", "type": "RestorePointCollectionSourceProperties"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "restore_point_collection_id": {"key": "properties.restorePointCollectionId", "type": "str"},
        "restore_points": {"key": "properties.restorePoints", "type": "[RestorePoint]"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        source: Optional["_models.RestorePointCollectionSourceProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword source: The properties of the source resource that this restore point collection is
         created from.
        :paramtype source: ~azure.mgmt.compute.models.RestorePointCollectionSourceProperties
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.source = source
        self.provisioning_state: Optional[str] = None
        self.restore_point_collection_id: Optional[str] = None
        self.restore_points: Optional[list["_models.RestorePoint"]] = None


class RestorePointCollectionListResult(_serialization.Model):
    """The List restore point collection operation response.

    All required parameters must be populated in order to send to server.

    :ivar value: Gets the list of restore point collections. Required.
    :vartype value: list[~azure.mgmt.compute.models.RestorePointCollection]
    :ivar next_link: The uri to fetch the next page of RestorePointCollections. Call ListNext()
     with this to fetch the next page of RestorePointCollections.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[RestorePointCollection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: list["_models.RestorePointCollection"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Gets the list of restore point collections. Required.
        :paramtype value: list[~azure.mgmt.compute.models.RestorePointCollection]
        :keyword next_link: The uri to fetch the next page of RestorePointCollections. Call ListNext()
         with this to fetch the next page of RestorePointCollections.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RestorePointCollectionSourceProperties(_serialization.Model):
    """The properties of the source resource that this restore point collection is created from.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: Location of the source resource used to create this restore point collection.
    :vartype location: str
    :ivar id: Resource Id of the source resource used to create this restore point collection.
    :vartype id: str
    """

    _validation = {
        "location": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource Id of the source resource used to create this restore point collection.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.location: Optional[str] = None
        self.id = id


class RestorePointCollectionUpdate(UpdateResource):
    """Update Restore Point collection parameters.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar source: The properties of the source resource that this restore point collection is
     created from.
    :vartype source: ~azure.mgmt.compute.models.RestorePointCollectionSourceProperties
    :ivar provisioning_state: The provisioning state of the restore point collection.
    :vartype provisioning_state: str
    :ivar restore_point_collection_id: The unique id of the restore point collection.
    :vartype restore_point_collection_id: str
    :ivar restore_points: A list containing all restore points created under this restore point
     collection.
    :vartype restore_points: list[~azure.mgmt.compute.models.RestorePoint]
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "restore_point_collection_id": {"readonly": True},
        "restore_points": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "source": {"key": "properties.source", "type": "RestorePointCollectionSourceProperties"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "restore_point_collection_id": {"key": "properties.restorePointCollectionId", "type": "str"},
        "restore_points": {"key": "properties.restorePoints", "type": "[RestorePoint]"},
    }

    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
        source: Optional["_models.RestorePointCollectionSourceProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword source: The properties of the source resource that this restore point collection is
         created from.
        :paramtype source: ~azure.mgmt.compute.models.RestorePointCollectionSourceProperties
        """
        super().__init__(tags=tags, **kwargs)
        self.source = source
        self.provisioning_state: Optional[str] = None
        self.restore_point_collection_id: Optional[str] = None
        self.restore_points: Optional[list["_models.RestorePoint"]] = None


class RestorePointEncryption(_serialization.Model):
    """Encryption at rest settings for disk restore point. It is an optional property that can be
    specified in the input while creating a restore point.

    :ivar disk_encryption_set: Describes the parameter of customer managed disk encryption set
     resource id that can be specified for disk. **Note:** The disk encryption set resource id can
     only be specified for managed disk. Please refer https://aka.ms/mdssewithcmkoverview for more
     details.
    :vartype disk_encryption_set: ~azure.mgmt.compute.models.DiskEncryptionSetParameters
    :ivar type: The type of key used to encrypt the data of the disk restore point. Known values
     are: "EncryptionAtRestWithPlatformKey", "EncryptionAtRestWithCustomerKey", and
     "EncryptionAtRestWithPlatformAndCustomerKeys".
    :vartype type: str or ~azure.mgmt.compute.models.RestorePointEncryptionType
    """

    _attribute_map = {
        "disk_encryption_set": {"key": "diskEncryptionSet", "type": "DiskEncryptionSetParameters"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        disk_encryption_set: Optional["_models.DiskEncryptionSetParameters"] = None,
        type: Optional[Union[str, "_models.RestorePointEncryptionType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword disk_encryption_set: Describes the parameter of customer managed disk encryption set
         resource id that can be specified for disk. **Note:** The disk encryption set resource id can
         only be specified for managed disk. Please refer https://aka.ms/mdssewithcmkoverview for more
         details.
        :paramtype disk_encryption_set: ~azure.mgmt.compute.models.DiskEncryptionSetParameters
        :keyword type: The type of key used to encrypt the data of the disk restore point. Known values
         are: "EncryptionAtRestWithPlatformKey", "EncryptionAtRestWithCustomerKey", and
         "EncryptionAtRestWithPlatformAndCustomerKeys".
        :paramtype type: str or ~azure.mgmt.compute.models.RestorePointEncryptionType
        """
        super().__init__(**kwargs)
        self.disk_encryption_set = disk_encryption_set
        self.type = type


class RestorePointInstanceView(_serialization.Model):
    """The instance view of a restore point.

    :ivar disk_restore_points: The disk restore points information.
    :vartype disk_restore_points: list[~azure.mgmt.compute.models.DiskRestorePointInstanceView]
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.models.InstanceViewStatus]
    """

    _attribute_map = {
        "disk_restore_points": {"key": "diskRestorePoints", "type": "[DiskRestorePointInstanceView]"},
        "statuses": {"key": "statuses", "type": "[InstanceViewStatus]"},
    }

    def __init__(
        self,
        *,
        disk_restore_points: Optional[list["_models.DiskRestorePointInstanceView"]] = None,
        statuses: Optional[list["_models.InstanceViewStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword disk_restore_points: The disk restore points information.
        :paramtype disk_restore_points: list[~azure.mgmt.compute.models.DiskRestorePointInstanceView]
        :keyword statuses: The resource status information.
        :paramtype statuses: list[~azure.mgmt.compute.models.InstanceViewStatus]
        """
        super().__init__(**kwargs)
        self.disk_restore_points = disk_restore_points
        self.statuses = statuses


class RestorePointSourceMetadata(_serialization.Model):
    """Describes the properties of the Virtual Machine for which the restore point was created. The
    properties provided are a subset and the snapshot of the overall Virtual Machine properties
    captured at the time of the restore point creation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar hardware_profile: Gets the hardware profile.
    :vartype hardware_profile: ~azure.mgmt.compute.models.HardwareProfile
    :ivar storage_profile: Gets the storage profile.
    :vartype storage_profile: ~azure.mgmt.compute.models.RestorePointSourceVMStorageProfile
    :ivar os_profile: Gets the OS profile.
    :vartype os_profile: ~azure.mgmt.compute.models.OSProfile
    :ivar diagnostics_profile: Gets the diagnostics profile.
    :vartype diagnostics_profile: ~azure.mgmt.compute.models.DiagnosticsProfile
    :ivar license_type: Gets the license type, which is for bring your own license scenario.
    :vartype license_type: str
    :ivar vm_id: Gets the virtual machine unique id.
    :vartype vm_id: str
    :ivar security_profile: Gets the security profile.
    :vartype security_profile: ~azure.mgmt.compute.models.SecurityProfile
    :ivar location: Location of the VM from which the restore point was created.
    :vartype location: str
    :ivar user_data: UserData associated with the source VM for which restore point is captured,
     which is a base-64 encoded value.
    :vartype user_data: str
    :ivar hyper_v_generation: HyperVGeneration of the source VM for which restore point is
     captured. Known values are: "V1" and "V2".
    :vartype hyper_v_generation: str or ~azure.mgmt.compute.models.HyperVGenerationTypes
    """

    _validation = {
        "hardware_profile": {"readonly": True},
        "os_profile": {"readonly": True},
        "diagnostics_profile": {"readonly": True},
        "license_type": {"readonly": True},
        "vm_id": {"readonly": True},
        "security_profile": {"readonly": True},
        "location": {"readonly": True},
        "user_data": {"readonly": True},
        "hyper_v_generation": {"readonly": True},
    }

    _attribute_map = {
        "hardware_profile": {"key": "hardwareProfile", "type": "HardwareProfile"},
        "storage_profile": {"key": "storageProfile", "type": "RestorePointSourceVMStorageProfile"},
        "os_profile": {"key": "osProfile", "type": "OSProfile"},
        "diagnostics_profile": {"key": "diagnosticsProfile", "type": "DiagnosticsProfile"},
        "license_type": {"key": "licenseType", "type": "str"},
        "vm_id": {"key": "vmId", "type": "str"},
        "security_profile": {"key": "securityProfile", "type": "SecurityProfile"},
        "location": {"key": "location", "type": "str"},
        "user_data": {"key": "userData", "type": "str"},
        "hyper_v_generation": {"key": "hyperVGeneration", "type": "str"},
    }

    def __init__(
        self, *, storage_profile: Optional["_models.RestorePointSourceVMStorageProfile"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword storage_profile: Gets the storage profile.
        :paramtype storage_profile: ~azure.mgmt.compute.models.RestorePointSourceVMStorageProfile
        """
        super().__init__(**kwargs)
        self.hardware_profile: Optional["_models.HardwareProfile"] = None
        self.storage_profile = storage_profile
        self.os_profile: Optional["_models.OSProfile"] = None
        self.diagnostics_profile: Optional["_models.DiagnosticsProfile"] = None
        self.license_type: Optional[str] = None
        self.vm_id: Optional[str] = None
        self.security_profile: Optional["_models.SecurityProfile"] = None
        self.location: Optional[str] = None
        self.user_data: Optional[str] = None
        self.hyper_v_generation: Optional[Union[str, "_models.HyperVGenerationTypes"]] = None


class RestorePointSourceVMDataDisk(_serialization.Model):
    """Describes a data disk.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar lun: Gets the logical unit number.
    :vartype lun: int
    :ivar name: Gets the disk name.
    :vartype name: str
    :ivar caching: Gets the caching type. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype caching: str or ~azure.mgmt.compute.models.CachingTypes
    :ivar disk_size_gb: Gets the initial disk size in GB for blank data disks, and the new desired
     size for existing OS and Data disks.
    :vartype disk_size_gb: int
    :ivar managed_disk: Contains the managed disk details.
    :vartype managed_disk: ~azure.mgmt.compute.models.ManagedDiskParameters
    :ivar disk_restore_point: Contains Disk Restore Point properties.
    :vartype disk_restore_point: ~azure.mgmt.compute.models.DiskRestorePointAttributes
    :ivar write_accelerator_enabled: Shows true if the disk is write-accelerator enabled.
    :vartype write_accelerator_enabled: bool
    """

    _validation = {
        "lun": {"readonly": True},
        "name": {"readonly": True},
        "caching": {"readonly": True},
        "disk_size_gb": {"readonly": True},
        "write_accelerator_enabled": {"readonly": True},
    }

    _attribute_map = {
        "lun": {"key": "lun", "type": "int"},
        "name": {"key": "name", "type": "str"},
        "caching": {"key": "caching", "type": "str"},
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
        "managed_disk": {"key": "managedDisk", "type": "ManagedDiskParameters"},
        "disk_restore_point": {"key": "diskRestorePoint", "type": "DiskRestorePointAttributes"},
        "write_accelerator_enabled": {"key": "writeAcceleratorEnabled", "type": "bool"},
    }

    def __init__(
        self,
        *,
        managed_disk: Optional["_models.ManagedDiskParameters"] = None,
        disk_restore_point: Optional["_models.DiskRestorePointAttributes"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword managed_disk: Contains the managed disk details.
        :paramtype managed_disk: ~azure.mgmt.compute.models.ManagedDiskParameters
        :keyword disk_restore_point: Contains Disk Restore Point properties.
        :paramtype disk_restore_point: ~azure.mgmt.compute.models.DiskRestorePointAttributes
        """
        super().__init__(**kwargs)
        self.lun: Optional[int] = None
        self.name: Optional[str] = None
        self.caching: Optional[Union[str, "_models.CachingTypes"]] = None
        self.disk_size_gb: Optional[int] = None
        self.managed_disk = managed_disk
        self.disk_restore_point = disk_restore_point
        self.write_accelerator_enabled: Optional[bool] = None


class RestorePointSourceVMOSDisk(_serialization.Model):
    """Describes an Operating System disk.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar os_type: Gets the Operating System type. Known values are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.models.OperatingSystemType
    :ivar encryption_settings: Gets the disk encryption settings.
    :vartype encryption_settings: ~azure.mgmt.compute.models.DiskEncryptionSettings
    :ivar name: Gets the disk name.
    :vartype name: str
    :ivar caching: Gets the caching type. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype caching: str or ~azure.mgmt.compute.models.CachingTypes
    :ivar disk_size_gb: Gets the disk size in GB.
    :vartype disk_size_gb: int
    :ivar managed_disk: Gets the managed disk details.
    :vartype managed_disk: ~azure.mgmt.compute.models.ManagedDiskParameters
    :ivar disk_restore_point: Contains Disk Restore Point properties.
    :vartype disk_restore_point: ~azure.mgmt.compute.models.DiskRestorePointAttributes
    :ivar write_accelerator_enabled: Shows true if the disk is write-accelerator enabled.
    :vartype write_accelerator_enabled: bool
    """

    _validation = {
        "os_type": {"readonly": True},
        "encryption_settings": {"readonly": True},
        "name": {"readonly": True},
        "caching": {"readonly": True},
        "disk_size_gb": {"readonly": True},
        "write_accelerator_enabled": {"readonly": True},
    }

    _attribute_map = {
        "os_type": {"key": "osType", "type": "str"},
        "encryption_settings": {"key": "encryptionSettings", "type": "DiskEncryptionSettings"},
        "name": {"key": "name", "type": "str"},
        "caching": {"key": "caching", "type": "str"},
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
        "managed_disk": {"key": "managedDisk", "type": "ManagedDiskParameters"},
        "disk_restore_point": {"key": "diskRestorePoint", "type": "DiskRestorePointAttributes"},
        "write_accelerator_enabled": {"key": "writeAcceleratorEnabled", "type": "bool"},
    }

    def __init__(
        self,
        *,
        managed_disk: Optional["_models.ManagedDiskParameters"] = None,
        disk_restore_point: Optional["_models.DiskRestorePointAttributes"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword managed_disk: Gets the managed disk details.
        :paramtype managed_disk: ~azure.mgmt.compute.models.ManagedDiskParameters
        :keyword disk_restore_point: Contains Disk Restore Point properties.
        :paramtype disk_restore_point: ~azure.mgmt.compute.models.DiskRestorePointAttributes
        """
        super().__init__(**kwargs)
        self.os_type: Optional[Union[str, "_models.OperatingSystemType"]] = None
        self.encryption_settings: Optional["_models.DiskEncryptionSettings"] = None
        self.name: Optional[str] = None
        self.caching: Optional[Union[str, "_models.CachingTypes"]] = None
        self.disk_size_gb: Optional[int] = None
        self.managed_disk = managed_disk
        self.disk_restore_point = disk_restore_point
        self.write_accelerator_enabled: Optional[bool] = None


class RestorePointSourceVMStorageProfile(_serialization.Model):
    """Describes the storage profile.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar os_disk: Gets the OS disk of the VM captured at the time of the restore point creation.
    :vartype os_disk: ~azure.mgmt.compute.models.RestorePointSourceVMOSDisk
    :ivar data_disks: Gets the data disks of the VM captured at the time of the restore point
     creation.
    :vartype data_disks: list[~azure.mgmt.compute.models.RestorePointSourceVMDataDisk]
    :ivar disk_controller_type: Gets the disk controller type of the VM captured at the time of the
     restore point creation. Known values are: "SCSI" and "NVMe".
    :vartype disk_controller_type: str or ~azure.mgmt.compute.models.DiskControllerTypes
    """

    _validation = {
        "disk_controller_type": {"readonly": True},
    }

    _attribute_map = {
        "os_disk": {"key": "osDisk", "type": "RestorePointSourceVMOSDisk"},
        "data_disks": {"key": "dataDisks", "type": "[RestorePointSourceVMDataDisk]"},
        "disk_controller_type": {"key": "diskControllerType", "type": "str"},
    }

    def __init__(
        self,
        *,
        os_disk: Optional["_models.RestorePointSourceVMOSDisk"] = None,
        data_disks: Optional[list["_models.RestorePointSourceVMDataDisk"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword os_disk: Gets the OS disk of the VM captured at the time of the restore point
         creation.
        :paramtype os_disk: ~azure.mgmt.compute.models.RestorePointSourceVMOSDisk
        :keyword data_disks: Gets the data disks of the VM captured at the time of the restore point
         creation.
        :paramtype data_disks: list[~azure.mgmt.compute.models.RestorePointSourceVMDataDisk]
        """
        super().__init__(**kwargs)
        self.os_disk = os_disk
        self.data_disks = data_disks
        self.disk_controller_type: Optional[Union[str, "_models.DiskControllerTypes"]] = None


class RetrieveBootDiagnosticsDataResult(_serialization.Model):
    """The SAS URIs of the console screenshot and serial log blobs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar console_screenshot_blob_uri: The console screenshot blob URI.
    :vartype console_screenshot_blob_uri: str
    :ivar serial_console_log_blob_uri: The serial console log blob URI.
    :vartype serial_console_log_blob_uri: str
    """

    _validation = {
        "console_screenshot_blob_uri": {"readonly": True},
        "serial_console_log_blob_uri": {"readonly": True},
    }

    _attribute_map = {
        "console_screenshot_blob_uri": {"key": "consoleScreenshotBlobUri", "type": "str"},
        "serial_console_log_blob_uri": {"key": "serialConsoleLogBlobUri", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.console_screenshot_blob_uri: Optional[str] = None
        self.serial_console_log_blob_uri: Optional[str] = None


class RoleInstance(_serialization.Model):
    """Describes the cloud service role instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :ivar location: Resource Location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: The role instance SKU.
    :vartype sku: ~azure.mgmt.compute.models.InstanceSku
    :ivar properties: Role instance properties.
    :vartype properties: ~azure.mgmt.compute.models.RoleInstanceProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
        "tags": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "InstanceSku"},
        "properties": {"key": "properties", "type": "RoleInstanceProperties"},
    }

    def __init__(
        self,
        *,
        sku: Optional["_models.InstanceSku"] = None,
        properties: Optional["_models.RoleInstanceProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword sku: The role instance SKU.
        :paramtype sku: ~azure.mgmt.compute.models.InstanceSku
        :keyword properties: Role instance properties.
        :paramtype properties: ~azure.mgmt.compute.models.RoleInstanceProperties
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.location: Optional[str] = None
        self.tags: Optional[dict[str, str]] = None
        self.sku = sku
        self.properties = properties


class RoleInstanceListResult(_serialization.Model):
    """The list operation result.

    All required parameters must be populated in order to send to server.

    :ivar value: The list of resources. Required.
    :vartype value: list[~azure.mgmt.compute.models.RoleInstance]
    :ivar next_link: The URI to fetch the next page of resources. Use this to get the next page of
     resources. Do this till nextLink is null to fetch all the resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[RoleInstance]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: list["_models.RoleInstance"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of resources. Required.
        :paramtype value: list[~azure.mgmt.compute.models.RoleInstance]
        :keyword next_link: The URI to fetch the next page of resources. Use this to get the next page
         of resources. Do this till nextLink is null to fetch all the resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RoleInstanceNetworkProfile(_serialization.Model):
    """Describes the network profile for the role instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar network_interfaces: Specifies the list of resource Ids for the network interfaces
     associated with the role instance.
    :vartype network_interfaces: list[~azure.mgmt.compute.models.SubResource]
    """

    _validation = {
        "network_interfaces": {"readonly": True},
    }

    _attribute_map = {
        "network_interfaces": {"key": "networkInterfaces", "type": "[SubResource]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.network_interfaces: Optional[list["_models.SubResource"]] = None


class RoleInstanceProperties(_serialization.Model):
    """Role instance properties.

    :ivar network_profile: Describes the network profile for the role instance.
    :vartype network_profile: ~azure.mgmt.compute.models.RoleInstanceNetworkProfile
    :ivar instance_view: The instance view of the role instance.
    :vartype instance_view: ~azure.mgmt.compute.models.RoleInstanceView
    """

    _attribute_map = {
        "network_profile": {"key": "networkProfile", "type": "RoleInstanceNetworkProfile"},
        "instance_view": {"key": "instanceView", "type": "RoleInstanceView"},
    }

    def __init__(
        self,
        *,
        network_profile: Optional["_models.RoleInstanceNetworkProfile"] = None,
        instance_view: Optional["_models.RoleInstanceView"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword network_profile: Describes the network profile for the role instance.
        :paramtype network_profile: ~azure.mgmt.compute.models.RoleInstanceNetworkProfile
        :keyword instance_view: The instance view of the role instance.
        :paramtype instance_view: ~azure.mgmt.compute.models.RoleInstanceView
        """
        super().__init__(**kwargs)
        self.network_profile = network_profile
        self.instance_view = instance_view


class RoleInstances(_serialization.Model):
    """Specifies a list of role instances from the cloud service.

    All required parameters must be populated in order to send to server.

    :ivar role_instances: List of cloud service role instance names. Value of '*' will signify all
     role instances of the cloud service. Required.
    :vartype role_instances: list[str]
    """

    _validation = {
        "role_instances": {"required": True},
    }

    _attribute_map = {
        "role_instances": {"key": "roleInstances", "type": "[str]"},
    }

    def __init__(self, *, role_instances: list[str], **kwargs: Any) -> None:
        """
        :keyword role_instances: List of cloud service role instance names. Value of '*' will signify
         all role instances of the cloud service. Required.
        :paramtype role_instances: list[str]
        """
        super().__init__(**kwargs)
        self.role_instances = role_instances


class RoleInstanceView(_serialization.Model):
    """The instance view of the role instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar platform_update_domain: The Update Domain.
    :vartype platform_update_domain: int
    :ivar platform_fault_domain: The Fault Domain.
    :vartype platform_fault_domain: int
    :ivar private_id: Specifies a unique identifier generated internally for the cloud service
     associated with this role instance. :code:`<br />`\\ :code:`<br />` NOTE: If you are using
     Azure Diagnostics extension, this property can be used as 'DeploymentId' for querying details.
    :vartype private_id: str
    :ivar statuses:
    :vartype statuses: list[~azure.mgmt.compute.models.ResourceInstanceViewStatus]
    """

    _validation = {
        "platform_update_domain": {"readonly": True},
        "platform_fault_domain": {"readonly": True},
        "private_id": {"readonly": True},
        "statuses": {"readonly": True},
    }

    _attribute_map = {
        "platform_update_domain": {"key": "platformUpdateDomain", "type": "int"},
        "platform_fault_domain": {"key": "platformFaultDomain", "type": "int"},
        "private_id": {"key": "privateId", "type": "str"},
        "statuses": {"key": "statuses", "type": "[ResourceInstanceViewStatus]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.platform_update_domain: Optional[int] = None
        self.platform_fault_domain: Optional[int] = None
        self.private_id: Optional[str] = None
        self.statuses: Optional[list["_models.ResourceInstanceViewStatus"]] = None


class RollbackStatusInfo(_serialization.Model):
    """Information about rollback on failed VM instances after a OS Upgrade operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar successfully_rolledback_instance_count: The number of instances which have been
     successfully rolled back.
    :vartype successfully_rolledback_instance_count: int
    :ivar failed_rolledback_instance_count: The number of instances which failed to rollback.
    :vartype failed_rolledback_instance_count: int
    :ivar rollback_error: Error details if OS rollback failed.
    :vartype rollback_error: ~azure.mgmt.compute.models.ApiError
    """

    _validation = {
        "successfully_rolledback_instance_count": {"readonly": True},
        "failed_rolledback_instance_count": {"readonly": True},
        "rollback_error": {"readonly": True},
    }

    _attribute_map = {
        "successfully_rolledback_instance_count": {"key": "successfullyRolledbackInstanceCount", "type": "int"},
        "failed_rolledback_instance_count": {"key": "failedRolledbackInstanceCount", "type": "int"},
        "rollback_error": {"key": "rollbackError", "type": "ApiError"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.successfully_rolledback_instance_count: Optional[int] = None
        self.failed_rolledback_instance_count: Optional[int] = None
        self.rollback_error: Optional["_models.ApiError"] = None


class RollingUpgradePolicy(_serialization.Model):
    """The configuration parameters used while performing a rolling upgrade.

    :ivar max_batch_instance_percent: The maximum percent of total virtual machine instances that
     will be upgraded simultaneously by the rolling upgrade in one batch. As this is a maximum,
     unhealthy instances in previous or future batches can cause the percentage of instances in a
     batch to decrease to ensure higher reliability. The default value for this parameter is 20%.
    :vartype max_batch_instance_percent: int
    :ivar max_unhealthy_instance_percent: The maximum percentage of the total virtual machine
     instances in the scale set that can be simultaneously unhealthy, either as a result of being
     upgraded, or by being found in an unhealthy state by the virtual machine health checks before
     the rolling upgrade aborts. This constraint will be checked prior to starting any batch. The
     default value for this parameter is 20%.
    :vartype max_unhealthy_instance_percent: int
    :ivar max_unhealthy_upgraded_instance_percent: The maximum percentage of upgraded virtual
     machine instances that can be found to be in an unhealthy state. This check will happen after
     each batch is upgraded. If this percentage is ever exceeded, the rolling update aborts. The
     default value for this parameter is 20%.
    :vartype max_unhealthy_upgraded_instance_percent: int
    :ivar pause_time_between_batches: The wait time between completing the update for all virtual
     machines in one batch and starting the next batch. The time duration should be specified in ISO
     8601 format. The default value is 0 seconds (PT0S).
    :vartype pause_time_between_batches: str
    :ivar enable_cross_zone_upgrade: Allow VMSS to ignore AZ boundaries when constructing upgrade
     batches. Take into consideration the Update Domain and maxBatchInstancePercent to determine the
     batch size.
    :vartype enable_cross_zone_upgrade: bool
    :ivar prioritize_unhealthy_instances: Upgrade all unhealthy instances in a scale set before any
     healthy instances.
    :vartype prioritize_unhealthy_instances: bool
    :ivar rollback_failed_instances_on_policy_breach: Rollback failed instances to previous model
     if the Rolling Upgrade policy is violated.
    :vartype rollback_failed_instances_on_policy_breach: bool
    :ivar max_surge: Create new virtual machines to upgrade the scale set, rather than updating the
     existing virtual machines. Existing virtual machines will be deleted once the new virtual
     machines are created for each batch.
    :vartype max_surge: bool
    """

    _validation = {
        "max_batch_instance_percent": {"maximum": 100, "minimum": 5},
        "max_unhealthy_instance_percent": {"maximum": 100, "minimum": 5},
        "max_unhealthy_upgraded_instance_percent": {"maximum": 100},
    }

    _attribute_map = {
        "max_batch_instance_percent": {"key": "maxBatchInstancePercent", "type": "int"},
        "max_unhealthy_instance_percent": {"key": "maxUnhealthyInstancePercent", "type": "int"},
        "max_unhealthy_upgraded_instance_percent": {"key": "maxUnhealthyUpgradedInstancePercent", "type": "int"},
        "pause_time_between_batches": {"key": "pauseTimeBetweenBatches", "type": "str"},
        "enable_cross_zone_upgrade": {"key": "enableCrossZoneUpgrade", "type": "bool"},
        "prioritize_unhealthy_instances": {"key": "prioritizeUnhealthyInstances", "type": "bool"},
        "rollback_failed_instances_on_policy_breach": {"key": "rollbackFailedInstancesOnPolicyBreach", "type": "bool"},
        "max_surge": {"key": "maxSurge", "type": "bool"},
    }

    def __init__(
        self,
        *,
        max_batch_instance_percent: Optional[int] = None,
        max_unhealthy_instance_percent: Optional[int] = None,
        max_unhealthy_upgraded_instance_percent: Optional[int] = None,
        pause_time_between_batches: Optional[str] = None,
        enable_cross_zone_upgrade: Optional[bool] = None,
        prioritize_unhealthy_instances: Optional[bool] = None,
        rollback_failed_instances_on_policy_breach: Optional[bool] = None,
        max_surge: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword max_batch_instance_percent: The maximum percent of total virtual machine instances
         that will be upgraded simultaneously by the rolling upgrade in one batch. As this is a maximum,
         unhealthy instances in previous or future batches can cause the percentage of instances in a
         batch to decrease to ensure higher reliability. The default value for this parameter is 20%.
        :paramtype max_batch_instance_percent: int
        :keyword max_unhealthy_instance_percent: The maximum percentage of the total virtual machine
         instances in the scale set that can be simultaneously unhealthy, either as a result of being
         upgraded, or by being found in an unhealthy state by the virtual machine health checks before
         the rolling upgrade aborts. This constraint will be checked prior to starting any batch. The
         default value for this parameter is 20%.
        :paramtype max_unhealthy_instance_percent: int
        :keyword max_unhealthy_upgraded_instance_percent: The maximum percentage of upgraded virtual
         machine instances that can be found to be in an unhealthy state. This check will happen after
         each batch is upgraded. If this percentage is ever exceeded, the rolling update aborts. The
         default value for this parameter is 20%.
        :paramtype max_unhealthy_upgraded_instance_percent: int
        :keyword pause_time_between_batches: The wait time between completing the update for all
         virtual machines in one batch and starting the next batch. The time duration should be
         specified in ISO 8601 format. The default value is 0 seconds (PT0S).
        :paramtype pause_time_between_batches: str
        :keyword enable_cross_zone_upgrade: Allow VMSS to ignore AZ boundaries when constructing
         upgrade batches. Take into consideration the Update Domain and maxBatchInstancePercent to
         determine the batch size.
        :paramtype enable_cross_zone_upgrade: bool
        :keyword prioritize_unhealthy_instances: Upgrade all unhealthy instances in a scale set before
         any healthy instances.
        :paramtype prioritize_unhealthy_instances: bool
        :keyword rollback_failed_instances_on_policy_breach: Rollback failed instances to previous
         model if the Rolling Upgrade policy is violated.
        :paramtype rollback_failed_instances_on_policy_breach: bool
        :keyword max_surge: Create new virtual machines to upgrade the scale set, rather than updating
         the existing virtual machines. Existing virtual machines will be deleted once the new virtual
         machines are created for each batch.
        :paramtype max_surge: bool
        """
        super().__init__(**kwargs)
        self.max_batch_instance_percent = max_batch_instance_percent
        self.max_unhealthy_instance_percent = max_unhealthy_instance_percent
        self.max_unhealthy_upgraded_instance_percent = max_unhealthy_upgraded_instance_percent
        self.pause_time_between_batches = pause_time_between_batches
        self.enable_cross_zone_upgrade = enable_cross_zone_upgrade
        self.prioritize_unhealthy_instances = prioritize_unhealthy_instances
        self.rollback_failed_instances_on_policy_breach = rollback_failed_instances_on_policy_breach
        self.max_surge = max_surge


class RollingUpgradeProgressInfo(_serialization.Model):
    """Information about the number of virtual machine instances in each upgrade state.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar successful_instance_count: The number of instances that have been successfully upgraded.
    :vartype successful_instance_count: int
    :ivar failed_instance_count: The number of instances that have failed to be upgraded
     successfully.
    :vartype failed_instance_count: int
    :ivar in_progress_instance_count: The number of instances that are currently being upgraded.
    :vartype in_progress_instance_count: int
    :ivar pending_instance_count: The number of instances that have not yet begun to be upgraded.
    :vartype pending_instance_count: int
    """

    _validation = {
        "successful_instance_count": {"readonly": True},
        "failed_instance_count": {"readonly": True},
        "in_progress_instance_count": {"readonly": True},
        "pending_instance_count": {"readonly": True},
    }

    _attribute_map = {
        "successful_instance_count": {"key": "successfulInstanceCount", "type": "int"},
        "failed_instance_count": {"key": "failedInstanceCount", "type": "int"},
        "in_progress_instance_count": {"key": "inProgressInstanceCount", "type": "int"},
        "pending_instance_count": {"key": "pendingInstanceCount", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.successful_instance_count: Optional[int] = None
        self.failed_instance_count: Optional[int] = None
        self.in_progress_instance_count: Optional[int] = None
        self.pending_instance_count: Optional[int] = None


class RollingUpgradeRunningStatus(_serialization.Model):
    """Information about the current running state of the overall upgrade.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Code indicating the current status of the upgrade. Known values are:
     "RollingForward", "Cancelled", "Completed", and "Faulted".
    :vartype code: str or ~azure.mgmt.compute.models.RollingUpgradeStatusCode
    :ivar start_time: Start time of the upgrade.
    :vartype start_time: ~datetime.datetime
    :ivar last_action: The last action performed on the rolling upgrade. Known values are: "Start"
     and "Cancel".
    :vartype last_action: str or ~azure.mgmt.compute.models.RollingUpgradeActionType
    :ivar last_action_time: Last action time of the upgrade.
    :vartype last_action_time: ~datetime.datetime
    """

    _validation = {
        "code": {"readonly": True},
        "start_time": {"readonly": True},
        "last_action": {"readonly": True},
        "last_action_time": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "last_action": {"key": "lastAction", "type": "str"},
        "last_action_time": {"key": "lastActionTime", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[Union[str, "_models.RollingUpgradeStatusCode"]] = None
        self.start_time: Optional[datetime.datetime] = None
        self.last_action: Optional[Union[str, "_models.RollingUpgradeActionType"]] = None
        self.last_action_time: Optional[datetime.datetime] = None


class RollingUpgradeStatusInfo(TrackedResource):
    """The status of the latest virtual machine scale set rolling upgrade.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.compute.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar policy: The rolling upgrade policies applied for this upgrade.
    :vartype policy: ~azure.mgmt.compute.models.RollingUpgradePolicy
    :ivar running_status: Information about the current running state of the overall upgrade.
    :vartype running_status: ~azure.mgmt.compute.models.RollingUpgradeRunningStatus
    :ivar progress: Information about the number of virtual machine instances in each upgrade
     state.
    :vartype progress: ~azure.mgmt.compute.models.RollingUpgradeProgressInfo
    :ivar error: Error details for this upgrade, if there are any.
    :vartype error: ~azure.mgmt.compute.models.ApiError
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "policy": {"readonly": True},
        "running_status": {"readonly": True},
        "progress": {"readonly": True},
        "error": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "policy": {"key": "properties.policy", "type": "RollingUpgradePolicy"},
        "running_status": {"key": "properties.runningStatus", "type": "RollingUpgradeRunningStatus"},
        "progress": {"key": "properties.progress", "type": "RollingUpgradeProgressInfo"},
        "error": {"key": "properties.error", "type": "ApiError"},
    }

    def __init__(self, *, location: str, tags: Optional[dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.policy: Optional["_models.RollingUpgradePolicy"] = None
        self.running_status: Optional["_models.RollingUpgradeRunningStatus"] = None
        self.progress: Optional["_models.RollingUpgradeProgressInfo"] = None
        self.error: Optional["_models.ApiError"] = None


class RunCommandDocumentBase(_serialization.Model):
    """Describes the properties of a Run Command metadata.

    All required parameters must be populated in order to send to server.

    :ivar schema: The VM run command schema. Required.
    :vartype schema: str
    :ivar id: The VM run command id. Required.
    :vartype id: str
    :ivar os_type: The Operating System type. Required. Known values are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
    :ivar label: The VM run command label. Required.
    :vartype label: str
    :ivar description: The VM run command description. Required.
    :vartype description: str
    """

    _validation = {
        "schema": {"required": True},
        "id": {"required": True},
        "os_type": {"required": True},
        "label": {"required": True},
        "description": {"required": True},
    }

    _attribute_map = {
        "schema": {"key": "$schema", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "os_type": {"key": "osType", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        schema: str,
        id: str,  # pylint: disable=redefined-builtin
        os_type: Union[str, "_models.OperatingSystemTypes"],
        label: str,
        description: str,
        **kwargs: Any
    ) -> None:
        """
        :keyword schema: The VM run command schema. Required.
        :paramtype schema: str
        :keyword id: The VM run command id. Required.
        :paramtype id: str
        :keyword os_type: The Operating System type. Required. Known values are: "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
        :keyword label: The VM run command label. Required.
        :paramtype label: str
        :keyword description: The VM run command description. Required.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.schema = schema
        self.id = id
        self.os_type = os_type
        self.label = label
        self.description = description


class RunCommandDocument(RunCommandDocumentBase):
    """Describes the properties of a Run Command.

    All required parameters must be populated in order to send to server.

    :ivar schema: The VM run command schema. Required.
    :vartype schema: str
    :ivar id: The VM run command id. Required.
    :vartype id: str
    :ivar os_type: The Operating System type. Required. Known values are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
    :ivar label: The VM run command label. Required.
    :vartype label: str
    :ivar description: The VM run command description. Required.
    :vartype description: str
    :ivar script: The script to be executed. Required.
    :vartype script: list[str]
    :ivar parameters: The parameters used by the script.
    :vartype parameters: list[~azure.mgmt.compute.models.RunCommandParameterDefinition]
    """

    _validation = {
        "schema": {"required": True},
        "id": {"required": True},
        "os_type": {"required": True},
        "label": {"required": True},
        "description": {"required": True},
        "script": {"required": True},
    }

    _attribute_map = {
        "schema": {"key": "$schema", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "os_type": {"key": "osType", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "script": {"key": "script", "type": "[str]"},
        "parameters": {"key": "parameters", "type": "[RunCommandParameterDefinition]"},
    }

    def __init__(
        self,
        *,
        schema: str,
        id: str,  # pylint: disable=redefined-builtin
        os_type: Union[str, "_models.OperatingSystemTypes"],
        label: str,
        description: str,
        script: list[str],
        parameters: Optional[list["_models.RunCommandParameterDefinition"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword schema: The VM run command schema. Required.
        :paramtype schema: str
        :keyword id: The VM run command id. Required.
        :paramtype id: str
        :keyword os_type: The Operating System type. Required. Known values are: "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
        :keyword label: The VM run command label. Required.
        :paramtype label: str
        :keyword description: The VM run command description. Required.
        :paramtype description: str
        :keyword script: The script to be executed. Required.
        :paramtype script: list[str]
        :keyword parameters: The parameters used by the script.
        :paramtype parameters: list[~azure.mgmt.compute.models.RunCommandParameterDefinition]
        """
        super().__init__(schema=schema, id=id, os_type=os_type, label=label, description=description, **kwargs)
        self.script = script
        self.parameters = parameters


class RunCommandInput(_serialization.Model):
    """Capture Virtual Machine parameters.

    All required parameters must be populated in order to send to server.

    :ivar command_id: Specifies a commandId of predefined built-in script. Command IDs available
     for Linux are listed at https://aka.ms/RunCommandManagedLinux#available-commands, Windows at
     https://aka.ms/RunCommandManagedWindows#available-commands. Required.
    :vartype command_id: str
    :ivar script: Optional. The script to be executed.  When this value is given, the given script
     will override the default script of the command.
    :vartype script: list[str]
    :ivar parameters: The run command parameters.
    :vartype parameters: list[~azure.mgmt.compute.models.RunCommandInputParameter]
    """

    _validation = {
        "command_id": {"required": True},
    }

    _attribute_map = {
        "command_id": {"key": "commandId", "type": "str"},
        "script": {"key": "script", "type": "[str]"},
        "parameters": {"key": "parameters", "type": "[RunCommandInputParameter]"},
    }

    def __init__(
        self,
        *,
        command_id: str,
        script: Optional[list[str]] = None,
        parameters: Optional[list["_models.RunCommandInputParameter"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword command_id: Specifies a commandId of predefined built-in script. Command IDs available
         for Linux are listed at https://aka.ms/RunCommandManagedLinux#available-commands, Windows at
         https://aka.ms/RunCommandManagedWindows#available-commands. Required.
        :paramtype command_id: str
        :keyword script: Optional. The script to be executed.  When this value is given, the given
         script will override the default script of the command.
        :paramtype script: list[str]
        :keyword parameters: The run command parameters.
        :paramtype parameters: list[~azure.mgmt.compute.models.RunCommandInputParameter]
        """
        super().__init__(**kwargs)
        self.command_id = command_id
        self.script = script
        self.parameters = parameters


class RunCommandInputParameter(_serialization.Model):
    """Describes the properties of a run command parameter.

    All required parameters must be populated in order to send to server.

    :ivar name: The run command parameter name. Required.
    :vartype name: str
    :ivar value: The run command parameter value. Required.
    :vartype value: str
    """

    _validation = {
        "name": {"required": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, name: str, value: str, **kwargs: Any) -> None:
        """
        :keyword name: The run command parameter name. Required.
        :paramtype name: str
        :keyword value: The run command parameter value. Required.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value


class RunCommandListResult(_serialization.Model):
    """The List Virtual Machine operation response.

    All required parameters must be populated in order to send to server.

    :ivar value: The list of virtual machine run commands. Required.
    :vartype value: list[~azure.mgmt.compute.models.RunCommandDocumentBase]
    :ivar next_link: The uri to fetch the next page of run commands. Call ListNext() with this to
     fetch the next page of run commands.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[RunCommandDocumentBase]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: list["_models.RunCommandDocumentBase"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of virtual machine run commands. Required.
        :paramtype value: list[~azure.mgmt.compute.models.RunCommandDocumentBase]
        :keyword next_link: The uri to fetch the next page of run commands. Call ListNext() with this
         to fetch the next page of run commands.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RunCommandManagedIdentity(_serialization.Model):
    """Contains clientId or objectId (use only one, not both) of a user-assigned managed identity that
    has access to storage blob used in Run Command. Use an empty RunCommandManagedIdentity object
    in case of system-assigned identity. Make sure the Azure storage blob exists in case of
    scriptUri, and managed identity has been given access to blob's container with 'Storage Blob
    Data Reader' role assignment with scriptUri blob and 'Storage Blob Data Contributor' for Append
    blobs(outputBlobUri, errorBlobUri). In case of user assigned identity, make sure you add it
    under VM's identity. For more info on managed identity and Run Command, refer
    https://aka.ms/ManagedIdentity and https://aka.ms/RunCommandManaged.

    :ivar client_id: Client Id (GUID value) of the user-assigned managed identity. ObjectId should
     not be used if this is provided.
    :vartype client_id: str
    :ivar object_id: Object Id (GUID value) of the user-assigned managed identity. ClientId should
     not be used if this is provided.
    :vartype object_id: str
    """

    _attribute_map = {
        "client_id": {"key": "clientId", "type": "str"},
        "object_id": {"key": "objectId", "type": "str"},
    }

    def __init__(self, *, client_id: Optional[str] = None, object_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword client_id: Client Id (GUID value) of the user-assigned managed identity. ObjectId
         should not be used if this is provided.
        :paramtype client_id: str
        :keyword object_id: Object Id (GUID value) of the user-assigned managed identity. ClientId
         should not be used if this is provided.
        :paramtype object_id: str
        """
        super().__init__(**kwargs)
        self.client_id = client_id
        self.object_id = object_id


class RunCommandParameterDefinition(_serialization.Model):
    """Describes the properties of a run command parameter.

    All required parameters must be populated in order to send to server.

    :ivar name: The run command parameter name. Required.
    :vartype name: str
    :ivar type: The run command parameter type. Required.
    :vartype type: str
    :ivar default_value: The run command parameter default value.
    :vartype default_value: str
    :ivar required: The run command parameter required.
    :vartype required: bool
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "default_value": {"key": "defaultValue", "type": "str"},
        "required": {"key": "required", "type": "bool"},
    }

    def __init__(
        self,
        *,
        name: str,
        type: str,
        default_value: Optional[str] = None,
        required: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The run command parameter name. Required.
        :paramtype name: str
        :keyword type: The run command parameter type. Required.
        :paramtype type: str
        :keyword default_value: The run command parameter default value.
        :paramtype default_value: str
        :keyword required: The run command parameter required.
        :paramtype required: bool
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type
        self.default_value = default_value
        self.required = required


class RunCommandResult(_serialization.Model):
    """RunCommandResult.

    :ivar value: Run command operation response.
    :vartype value: list[~azure.mgmt.compute.models.InstanceViewStatus]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[InstanceViewStatus]"},
    }

    def __init__(self, *, value: Optional[list["_models.InstanceViewStatus"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Run command operation response.
        :paramtype value: list[~azure.mgmt.compute.models.InstanceViewStatus]
        """
        super().__init__(**kwargs)
        self.value = value


class ScaleInPolicy(_serialization.Model):
    """Describes a scale-in policy for a virtual machine scale set.

    :ivar rules: The rules to be followed when scaling-in a virtual machine scale set.
     :code:`<br>`\\ :code:`<br>` Possible values are: :code:`<br>`\\ :code:`<br>` **Default** When a
     virtual machine scale set is scaled in, the scale set will first be balanced across zones if it
     is a zonal scale set. Then, it will be balanced across Fault Domains as far as possible. Within
     each Fault Domain, the virtual machines chosen for removal will be the newest ones that are not
     protected from scale-in. :code:`<br>`\\ :code:`<br>` **OldestVM** When a virtual machine scale
     set is being scaled-in, the oldest virtual machines that are not protected from scale-in will
     be chosen for removal. For zonal virtual machine scale sets, the scale set will first be
     balanced across zones. Within each zone, the oldest virtual machines that are not protected
     will be chosen for removal. :code:`<br>`\\ :code:`<br>` **NewestVM** When a virtual machine
     scale set is being scaled-in, the newest virtual machines that are not protected from scale-in
     will be chosen for removal. For zonal virtual machine scale sets, the scale set will first be
     balanced across zones. Within each zone, the newest virtual machines that are not protected
     will be chosen for removal. :code:`<br>`\\ :code:`<br>`.
    :vartype rules: list[str or ~azure.mgmt.compute.models.VirtualMachineScaleSetScaleInRules]
    :ivar force_deletion: This property allows you to specify if virtual machines chosen for
     removal have to be force deleted when a virtual machine scale set is being scaled-in.(Feature
     in Preview).
    :vartype force_deletion: bool
    :ivar prioritize_unhealthy_v_ms: This property allows you to prioritize the deletion of
     unhealthy and inactive VMs when a virtual machine scale set is being scaled-in.(Feature in
     Preview).
    :vartype prioritize_unhealthy_v_ms: bool
    """

    _attribute_map = {
        "rules": {"key": "rules", "type": "[str]"},
        "force_deletion": {"key": "forceDeletion", "type": "bool"},
        "prioritize_unhealthy_v_ms": {"key": "prioritizeUnhealthyVMs", "type": "bool"},
    }

    def __init__(
        self,
        *,
        rules: Optional[list[Union[str, "_models.VirtualMachineScaleSetScaleInRules"]]] = None,
        force_deletion: Optional[bool] = None,
        prioritize_unhealthy_v_ms: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword rules: The rules to be followed when scaling-in a virtual machine scale set.
         :code:`<br>`\\ :code:`<br>` Possible values are: :code:`<br>`\\ :code:`<br>` **Default** When a
         virtual machine scale set is scaled in, the scale set will first be balanced across zones if it
         is a zonal scale set. Then, it will be balanced across Fault Domains as far as possible. Within
         each Fault Domain, the virtual machines chosen for removal will be the newest ones that are not
         protected from scale-in. :code:`<br>`\\ :code:`<br>` **OldestVM** When a virtual machine scale
         set is being scaled-in, the oldest virtual machines that are not protected from scale-in will
         be chosen for removal. For zonal virtual machine scale sets, the scale set will first be
         balanced across zones. Within each zone, the oldest virtual machines that are not protected
         will be chosen for removal. :code:`<br>`\\ :code:`<br>` **NewestVM** When a virtual machine
         scale set is being scaled-in, the newest virtual machines that are not protected from scale-in
         will be chosen for removal. For zonal virtual machine scale sets, the scale set will first be
         balanced across zones. Within each zone, the newest virtual machines that are not protected
         will be chosen for removal. :code:`<br>`\\ :code:`<br>`.
        :paramtype rules: list[str or ~azure.mgmt.compute.models.VirtualMachineScaleSetScaleInRules]
        :keyword force_deletion: This property allows you to specify if virtual machines chosen for
         removal have to be force deleted when a virtual machine scale set is being scaled-in.(Feature
         in Preview).
        :paramtype force_deletion: bool
        :keyword prioritize_unhealthy_v_ms: This property allows you to prioritize the deletion of
         unhealthy and inactive VMs when a virtual machine scale set is being scaled-in.(Feature in
         Preview).
        :paramtype prioritize_unhealthy_v_ms: bool
        """
        super().__init__(**kwargs)
        self.rules = rules
        self.force_deletion = force_deletion
        self.prioritize_unhealthy_v_ms = prioritize_unhealthy_v_ms


class ScheduledEventsAdditionalPublishingTargets(_serialization.Model):  # pylint: disable=name-too-long
    """ScheduledEventsAdditionalPublishingTargets.

    :ivar event_grid_and_resource_graph: The configuration parameters used while creating
     eventGridAndResourceGraph Scheduled Event setting.
    :vartype event_grid_and_resource_graph: ~azure.mgmt.compute.models.EventGridAndResourceGraph
    """

    _attribute_map = {
        "event_grid_and_resource_graph": {"key": "eventGridAndResourceGraph", "type": "EventGridAndResourceGraph"},
    }

    def __init__(
        self, *, event_grid_and_resource_graph: Optional["_models.EventGridAndResourceGraph"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword event_grid_and_resource_graph: The configuration parameters used while creating
         eventGridAndResourceGraph Scheduled Event setting.
        :paramtype event_grid_and_resource_graph: ~azure.mgmt.compute.models.EventGridAndResourceGraph
        """
        super().__init__(**kwargs)
        self.event_grid_and_resource_graph = event_grid_and_resource_graph


class ScheduledEventsPolicy(_serialization.Model):
    """Specifies Redeploy, Reboot and ScheduledEventsAdditionalPublishingTargets Scheduled Event
    related configurations.

    :ivar user_initiated_redeploy: The configuration parameters used while creating
     userInitiatedRedeploy scheduled event setting creation.
    :vartype user_initiated_redeploy: ~azure.mgmt.compute.models.UserInitiatedRedeploy
    :ivar user_initiated_reboot: The configuration parameters used while creating
     userInitiatedReboot scheduled event setting creation.
    :vartype user_initiated_reboot: ~azure.mgmt.compute.models.UserInitiatedReboot
    :ivar scheduled_events_additional_publishing_targets: The configuration parameters used while
     publishing scheduledEventsAdditionalPublishingTargets.
    :vartype scheduled_events_additional_publishing_targets:
     ~azure.mgmt.compute.models.ScheduledEventsAdditionalPublishingTargets
    :ivar all_instances_down: The configuration parameters used while creating AllInstancesDown
     scheduled event setting creation.
    :vartype all_instances_down: ~azure.mgmt.compute.models.AllInstancesDown
    """

    _attribute_map = {
        "user_initiated_redeploy": {"key": "userInitiatedRedeploy", "type": "UserInitiatedRedeploy"},
        "user_initiated_reboot": {"key": "userInitiatedReboot", "type": "UserInitiatedReboot"},
        "scheduled_events_additional_publishing_targets": {
            "key": "scheduledEventsAdditionalPublishingTargets",
            "type": "ScheduledEventsAdditionalPublishingTargets",
        },
        "all_instances_down": {"key": "allInstancesDown", "type": "AllInstancesDown"},
    }

    def __init__(
        self,
        *,
        user_initiated_redeploy: Optional["_models.UserInitiatedRedeploy"] = None,
        user_initiated_reboot: Optional["_models.UserInitiatedReboot"] = None,
        scheduled_events_additional_publishing_targets: Optional[
            "_models.ScheduledEventsAdditionalPublishingTargets"
        ] = None,
        all_instances_down: Optional["_models.AllInstancesDown"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword user_initiated_redeploy: The configuration parameters used while creating
         userInitiatedRedeploy scheduled event setting creation.
        :paramtype user_initiated_redeploy: ~azure.mgmt.compute.models.UserInitiatedRedeploy
        :keyword user_initiated_reboot: The configuration parameters used while creating
         userInitiatedReboot scheduled event setting creation.
        :paramtype user_initiated_reboot: ~azure.mgmt.compute.models.UserInitiatedReboot
        :keyword scheduled_events_additional_publishing_targets: The configuration parameters used
         while publishing scheduledEventsAdditionalPublishingTargets.
        :paramtype scheduled_events_additional_publishing_targets:
         ~azure.mgmt.compute.models.ScheduledEventsAdditionalPublishingTargets
        :keyword all_instances_down: The configuration parameters used while creating AllInstancesDown
         scheduled event setting creation.
        :paramtype all_instances_down: ~azure.mgmt.compute.models.AllInstancesDown
        """
        super().__init__(**kwargs)
        self.user_initiated_redeploy = user_initiated_redeploy
        self.user_initiated_reboot = user_initiated_reboot
        self.scheduled_events_additional_publishing_targets = scheduled_events_additional_publishing_targets
        self.all_instances_down = all_instances_down


class ScheduledEventsProfile(_serialization.Model):
    """ScheduledEventsProfile.

    :ivar terminate_notification_profile: Specifies Terminate Scheduled Event related
     configurations.
    :vartype terminate_notification_profile:
     ~azure.mgmt.compute.models.TerminateNotificationProfile
    :ivar os_image_notification_profile: Specifies OS Image Scheduled Event related configurations.
    :vartype os_image_notification_profile: ~azure.mgmt.compute.models.OSImageNotificationProfile
    """

    _attribute_map = {
        "terminate_notification_profile": {
            "key": "terminateNotificationProfile",
            "type": "TerminateNotificationProfile",
        },
        "os_image_notification_profile": {"key": "osImageNotificationProfile", "type": "OSImageNotificationProfile"},
    }

    def __init__(
        self,
        *,
        terminate_notification_profile: Optional["_models.TerminateNotificationProfile"] = None,
        os_image_notification_profile: Optional["_models.OSImageNotificationProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword terminate_notification_profile: Specifies Terminate Scheduled Event related
         configurations.
        :paramtype terminate_notification_profile:
         ~azure.mgmt.compute.models.TerminateNotificationProfile
        :keyword os_image_notification_profile: Specifies OS Image Scheduled Event related
         configurations.
        :paramtype os_image_notification_profile: ~azure.mgmt.compute.models.OSImageNotificationProfile
        """
        super().__init__(**kwargs)
        self.terminate_notification_profile = terminate_notification_profile
        self.os_image_notification_profile = os_image_notification_profile


class ScheduleProfile(_serialization.Model):
    """Defines the schedule for Block-type capacity reservations. Specifies the schedule during which
    capacity reservation is active and VM or VMSS resource can be allocated using reservation. This
    property is required and only supported when the capacity reservation group type is 'Block'.
    The scheduleProfile, start, and end fields are immutable after creation. Minimum API version:
    2025-04-01. Please refer to https://aka.ms/blockcapacityreservation for more details.

    :ivar start: The required start date for block capacity reservations. Must be today or within
     56 days in the future. For same-day scheduling, requests must be submitted before 11:30 AM UTC.
     Example: 2025-06-27.
    :vartype start: str
    :ivar end: The required end date for block capacity reservations. Must be after the start date,
     with a duration of either 1–14 whole days or 3–26 whole weeks. Example: 2025-06-28.
    :vartype end: str
    """

    _attribute_map = {
        "start": {"key": "start", "type": "str"},
        "end": {"key": "end", "type": "str"},
    }

    def __init__(self, *, start: Optional[str] = None, end: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword start: The required start date for block capacity reservations. Must be today or
         within 56 days in the future. For same-day scheduling, requests must be submitted before 11:30
         AM UTC. Example: 2025-06-27.
        :paramtype start: str
        :keyword end: The required end date for block capacity reservations. Must be after the start
         date, with a duration of either 1–14 whole days or 3–26 whole weeks. Example: 2025-06-28.
        :paramtype end: str
        """
        super().__init__(**kwargs)
        self.start = start
        self.end = end


class SecurityPostureReference(_serialization.Model):
    """Specifies the security posture to be used in the scale set. Minimum api-version: 2023-03-01.

    All required parameters must be populated in order to send to server.

    :ivar id: The security posture reference id in the form of
     /CommunityGalleries/{communityGalleryName}/securityPostures/{securityPostureName}/versions/{major.minor.patch}|latest.
     Required.
    :vartype id: str
    :ivar exclude_extensions: The list of virtual machine extension names to exclude when applying
     the security posture.
    :vartype exclude_extensions: list[str]
    :ivar is_overridable: Whether the security posture can be overridden by the user.
    :vartype is_overridable: bool
    """

    _validation = {
        "id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "exclude_extensions": {"key": "excludeExtensions", "type": "[str]"},
        "is_overridable": {"key": "isOverridable", "type": "bool"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        exclude_extensions: Optional[list[str]] = None,
        is_overridable: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The security posture reference id in the form of
         /CommunityGalleries/{communityGalleryName}/securityPostures/{securityPostureName}/versions/{major.minor.patch}|latest.
         Required.
        :paramtype id: str
        :keyword exclude_extensions: The list of virtual machine extension names to exclude when
         applying the security posture.
        :paramtype exclude_extensions: list[str]
        :keyword is_overridable: Whether the security posture can be overridden by the user.
        :paramtype is_overridable: bool
        """
        super().__init__(**kwargs)
        self.id = id
        self.exclude_extensions = exclude_extensions
        self.is_overridable = is_overridable


class SecurityPostureReferenceUpdate(_serialization.Model):
    """Specifies the security posture to be used in the scale set. Minimum api-version: 2023-03-01.

    :ivar id: The security posture reference id in the form of
     /CommunityGalleries/{communityGalleryName}/securityPostures/{securityPostureName}/versions/{major.minor.patch}|latest.
    :vartype id: str
    :ivar exclude_extensions: The list of virtual machine extension names to exclude when applying
     the security posture.
    :vartype exclude_extensions: list[str]
    :ivar is_overridable: Whether the security posture can be overridden by the user.
    :vartype is_overridable: bool
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "exclude_extensions": {"key": "excludeExtensions", "type": "[str]"},
        "is_overridable": {"key": "isOverridable", "type": "bool"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        exclude_extensions: Optional[list[str]] = None,
        is_overridable: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The security posture reference id in the form of
         /CommunityGalleries/{communityGalleryName}/securityPostures/{securityPostureName}/versions/{major.minor.patch}|latest.
        :paramtype id: str
        :keyword exclude_extensions: The list of virtual machine extension names to exclude when
         applying the security posture.
        :paramtype exclude_extensions: list[str]
        :keyword is_overridable: Whether the security posture can be overridden by the user.
        :paramtype is_overridable: bool
        """
        super().__init__(**kwargs)
        self.id = id
        self.exclude_extensions = exclude_extensions
        self.is_overridable = is_overridable


class SecurityProfile(_serialization.Model):
    """Specifies the Security profile settings for the virtual machine or virtual machine scale set.

    :ivar uefi_settings: Specifies the security settings like secure boot and vTPM used while
     creating the virtual machine. Minimum api-version: 2020-12-01.
    :vartype uefi_settings: ~azure.mgmt.compute.models.UefiSettings
    :ivar encryption_at_host: This property can be used by user in the request to enable or disable
     the Host Encryption for the virtual machine or virtual machine scale set. This will enable the
     encryption for all the disks including Resource/Temp disk at host itself. The default behavior
     is: The Encryption at host will be disabled unless this property is set to true for the
     resource.
    :vartype encryption_at_host: bool
    :ivar security_type: Specifies the SecurityType of the virtual machine. It has to be set to any
     specified value to enable UefiSettings. The default behavior is: UefiSettings will not be
     enabled unless this property is set. Known values are: "TrustedLaunch" and "ConfidentialVM".
    :vartype security_type: str or ~azure.mgmt.compute.models.SecurityTypes
    :ivar encryption_identity: Specifies the Managed Identity used by ADE to get access token for
     keyvault operations.
    :vartype encryption_identity: ~azure.mgmt.compute.models.EncryptionIdentity
    :ivar proxy_agent_settings: Specifies ProxyAgent settings while creating the virtual machine.
     Minimum api-version: 2023-09-01.
    :vartype proxy_agent_settings: ~azure.mgmt.compute.models.ProxyAgentSettings
    """

    _attribute_map = {
        "uefi_settings": {"key": "uefiSettings", "type": "UefiSettings"},
        "encryption_at_host": {"key": "encryptionAtHost", "type": "bool"},
        "security_type": {"key": "securityType", "type": "str"},
        "encryption_identity": {"key": "encryptionIdentity", "type": "EncryptionIdentity"},
        "proxy_agent_settings": {"key": "proxyAgentSettings", "type": "ProxyAgentSettings"},
    }

    def __init__(
        self,
        *,
        uefi_settings: Optional["_models.UefiSettings"] = None,
        encryption_at_host: Optional[bool] = None,
        security_type: Optional[Union[str, "_models.SecurityTypes"]] = None,
        encryption_identity: Optional["_models.EncryptionIdentity"] = None,
        proxy_agent_settings: Optional["_models.ProxyAgentSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword uefi_settings: Specifies the security settings like secure boot and vTPM used while
         creating the virtual machine. Minimum api-version: 2020-12-01.
        :paramtype uefi_settings: ~azure.mgmt.compute.models.UefiSettings
        :keyword encryption_at_host: This property can be used by user in the request to enable or
         disable the Host Encryption for the virtual machine or virtual machine scale set. This will
         enable the encryption for all the disks including Resource/Temp disk at host itself. The
         default behavior is: The Encryption at host will be disabled unless this property is set to
         true for the resource.
        :paramtype encryption_at_host: bool
        :keyword security_type: Specifies the SecurityType of the virtual machine. It has to be set to
         any specified value to enable UefiSettings. The default behavior is: UefiSettings will not be
         enabled unless this property is set. Known values are: "TrustedLaunch" and "ConfidentialVM".
        :paramtype security_type: str or ~azure.mgmt.compute.models.SecurityTypes
        :keyword encryption_identity: Specifies the Managed Identity used by ADE to get access token
         for keyvault operations.
        :paramtype encryption_identity: ~azure.mgmt.compute.models.EncryptionIdentity
        :keyword proxy_agent_settings: Specifies ProxyAgent settings while creating the virtual
         machine. Minimum api-version: 2023-09-01.
        :paramtype proxy_agent_settings: ~azure.mgmt.compute.models.ProxyAgentSettings
        """
        super().__init__(**kwargs)
        self.uefi_settings = uefi_settings
        self.encryption_at_host = encryption_at_host
        self.security_type = security_type
        self.encryption_identity = encryption_identity
        self.proxy_agent_settings = proxy_agent_settings


class ServiceArtifactReference(_serialization.Model):
    """Specifies the service artifact reference id used to set same image version for all virtual
    machines in the scale set when using 'latest' image version. Minimum api-version: 2022-11-01.

    :ivar id: The service artifact reference id in the form of
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/serviceArtifacts/{serviceArtifactName}/vmArtifactsProfiles/{vmArtifactsProfilesName}.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: The service artifact reference id in the form of
         /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/serviceArtifacts/{serviceArtifactName}/vmArtifactsProfiles/{vmArtifactsProfilesName}.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class SharedGallery(PirSharedGalleryResource):
    """Specifies information about the Shared Gallery that you want to create or update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Resource name.
    :vartype name: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar unique_id: The unique id of this shared gallery.
    :vartype unique_id: str
    :ivar artifact_tags: The artifact tags of a shared gallery resource.
    :vartype artifact_tags: dict[str, str]
    """

    _validation = {
        "name": {"readonly": True},
        "location": {"readonly": True},
        "artifact_tags": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "unique_id": {"key": "identifier.uniqueId", "type": "str"},
        "artifact_tags": {"key": "properties.artifactTags", "type": "{str}"},
    }

    def __init__(self, *, unique_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword unique_id: The unique id of this shared gallery.
        :paramtype unique_id: str
        """
        super().__init__(unique_id=unique_id, **kwargs)
        self.artifact_tags: Optional[dict[str, str]] = None


class SharedGalleryDiskImage(_serialization.Model):
    """This is the disk image base class.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar disk_size_gb: This property indicates the size of the VHD to be created.
    :vartype disk_size_gb: int
    :ivar host_caching: The host caching of the disk. Valid values are 'None', 'ReadOnly', and
     'ReadWrite'. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype host_caching: str or ~azure.mgmt.compute.models.SharedGalleryHostCaching
    """

    _validation = {
        "disk_size_gb": {"readonly": True},
    }

    _attribute_map = {
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
        "host_caching": {"key": "hostCaching", "type": "str"},
    }

    def __init__(
        self, *, host_caching: Optional[Union[str, "_models.SharedGalleryHostCaching"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword host_caching: The host caching of the disk. Valid values are 'None', 'ReadOnly', and
         'ReadWrite'. Known values are: "None", "ReadOnly", and "ReadWrite".
        :paramtype host_caching: str or ~azure.mgmt.compute.models.SharedGalleryHostCaching
        """
        super().__init__(**kwargs)
        self.disk_size_gb: Optional[int] = None
        self.host_caching = host_caching


class SharedGalleryDataDiskImage(SharedGalleryDiskImage):
    """This is the data disk image.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar disk_size_gb: This property indicates the size of the VHD to be created.
    :vartype disk_size_gb: int
    :ivar host_caching: The host caching of the disk. Valid values are 'None', 'ReadOnly', and
     'ReadWrite'. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype host_caching: str or ~azure.mgmt.compute.models.SharedGalleryHostCaching
    :ivar lun: This property specifies the logical unit number of the data disk. This value is used
     to identify data disks within the Virtual Machine and therefore must be unique for each data
     disk attached to the Virtual Machine. Required.
    :vartype lun: int
    """

    _validation = {
        "disk_size_gb": {"readonly": True},
        "lun": {"required": True},
    }

    _attribute_map = {
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
        "host_caching": {"key": "hostCaching", "type": "str"},
        "lun": {"key": "lun", "type": "int"},
    }

    def __init__(
        self, *, lun: int, host_caching: Optional[Union[str, "_models.SharedGalleryHostCaching"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword host_caching: The host caching of the disk. Valid values are 'None', 'ReadOnly', and
         'ReadWrite'. Known values are: "None", "ReadOnly", and "ReadWrite".
        :paramtype host_caching: str or ~azure.mgmt.compute.models.SharedGalleryHostCaching
        :keyword lun: This property specifies the logical unit number of the data disk. This value is
         used to identify data disks within the Virtual Machine and therefore must be unique for each
         data disk attached to the Virtual Machine. Required.
        :paramtype lun: int
        """
        super().__init__(host_caching=host_caching, **kwargs)
        self.lun = lun


class SharedGalleryImage(PirSharedGalleryResource):
    """Specifies information about the gallery image definition that you want to create or update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Resource name.
    :vartype name: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar unique_id: The unique id of this shared gallery.
    :vartype unique_id: str
    :ivar os_type: This property allows you to specify the type of the OS that is included in the
     disk when creating a VM from a managed image. Possible values are: **Windows,** **Linux.**.
     Known values are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
    :ivar os_state: This property allows the user to specify whether the virtual machines created
     under this image are 'Generalized' or 'Specialized'. Known values are: "Generalized" and
     "Specialized".
    :vartype os_state: str or ~azure.mgmt.compute.models.OperatingSystemStateTypes
    :ivar end_of_life_date: The end of life date of the gallery image definition. This property can
     be used for decommissioning purposes. This property is updatable.
    :vartype end_of_life_date: ~datetime.datetime
    :ivar identifier: This is the gallery image definition identifier.
    :vartype identifier: ~azure.mgmt.compute.models.GalleryImageIdentifier
    :ivar recommended: The properties describe the recommended machine configuration for this Image
     Definition. These properties are updatable.
    :vartype recommended: ~azure.mgmt.compute.models.RecommendedMachineConfiguration
    :ivar disallowed: Describes the disallowed disk types.
    :vartype disallowed: ~azure.mgmt.compute.models.Disallowed
    :ivar hyper_v_generation: The hypervisor generation of the Virtual Machine. Applicable to OS
     disks only. Known values are: "V1" and "V2".
    :vartype hyper_v_generation: str or ~azure.mgmt.compute.models.HyperVGeneration
    :ivar features: A list of gallery image features.
    :vartype features: list[~azure.mgmt.compute.models.GalleryImageFeature]
    :ivar purchase_plan: Describes the gallery image definition purchase plan. This is used by
     marketplace images.
    :vartype purchase_plan: ~azure.mgmt.compute.models.ImagePurchasePlan
    :ivar architecture: The architecture of the image. Applicable to OS disks only. Known values
     are: "x64" and "Arm64".
    :vartype architecture: str or ~azure.mgmt.compute.models.Architecture
    :ivar privacy_statement_uri: Privacy statement uri for the current community gallery image.
    :vartype privacy_statement_uri: str
    :ivar eula: End-user license agreement for the current community gallery image.
    :vartype eula: str
    :ivar artifact_tags: The artifact tags of a shared gallery resource.
    :vartype artifact_tags: dict[str, str]
    """

    _validation = {
        "name": {"readonly": True},
        "location": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "unique_id": {"key": "identifier.uniqueId", "type": "str"},
        "os_type": {"key": "properties.osType", "type": "str"},
        "os_state": {"key": "properties.osState", "type": "str"},
        "end_of_life_date": {"key": "properties.endOfLifeDate", "type": "iso-8601"},
        "identifier": {"key": "properties.identifier", "type": "GalleryImageIdentifier"},
        "recommended": {"key": "properties.recommended", "type": "RecommendedMachineConfiguration"},
        "disallowed": {"key": "properties.disallowed", "type": "Disallowed"},
        "hyper_v_generation": {"key": "properties.hyperVGeneration", "type": "str"},
        "features": {"key": "properties.features", "type": "[GalleryImageFeature]"},
        "purchase_plan": {"key": "properties.purchasePlan", "type": "ImagePurchasePlan"},
        "architecture": {"key": "properties.architecture", "type": "str"},
        "privacy_statement_uri": {"key": "properties.privacyStatementUri", "type": "str"},
        "eula": {"key": "properties.eula", "type": "str"},
        "artifact_tags": {"key": "properties.artifactTags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        unique_id: Optional[str] = None,
        os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None,
        os_state: Optional[Union[str, "_models.OperatingSystemStateTypes"]] = None,
        end_of_life_date: Optional[datetime.datetime] = None,
        identifier: Optional["_models.GalleryImageIdentifier"] = None,
        recommended: Optional["_models.RecommendedMachineConfiguration"] = None,
        disallowed: Optional["_models.Disallowed"] = None,
        hyper_v_generation: Optional[Union[str, "_models.HyperVGeneration"]] = None,
        features: Optional[list["_models.GalleryImageFeature"]] = None,
        purchase_plan: Optional["_models.ImagePurchasePlan"] = None,
        architecture: Optional[Union[str, "_models.Architecture"]] = None,
        privacy_statement_uri: Optional[str] = None,
        eula: Optional[str] = None,
        artifact_tags: Optional[dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword unique_id: The unique id of this shared gallery.
        :paramtype unique_id: str
        :keyword os_type: This property allows you to specify the type of the OS that is included in
         the disk when creating a VM from a managed image. Possible values are: **Windows,** **Linux.**.
         Known values are: "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
        :keyword os_state: This property allows the user to specify whether the virtual machines
         created under this image are 'Generalized' or 'Specialized'. Known values are: "Generalized"
         and "Specialized".
        :paramtype os_state: str or ~azure.mgmt.compute.models.OperatingSystemStateTypes
        :keyword end_of_life_date: The end of life date of the gallery image definition. This property
         can be used for decommissioning purposes. This property is updatable.
        :paramtype end_of_life_date: ~datetime.datetime
        :keyword identifier: This is the gallery image definition identifier.
        :paramtype identifier: ~azure.mgmt.compute.models.GalleryImageIdentifier
        :keyword recommended: The properties describe the recommended machine configuration for this
         Image Definition. These properties are updatable.
        :paramtype recommended: ~azure.mgmt.compute.models.RecommendedMachineConfiguration
        :keyword disallowed: Describes the disallowed disk types.
        :paramtype disallowed: ~azure.mgmt.compute.models.Disallowed
        :keyword hyper_v_generation: The hypervisor generation of the Virtual Machine. Applicable to OS
         disks only. Known values are: "V1" and "V2".
        :paramtype hyper_v_generation: str or ~azure.mgmt.compute.models.HyperVGeneration
        :keyword features: A list of gallery image features.
        :paramtype features: list[~azure.mgmt.compute.models.GalleryImageFeature]
        :keyword purchase_plan: Describes the gallery image definition purchase plan. This is used by
         marketplace images.
        :paramtype purchase_plan: ~azure.mgmt.compute.models.ImagePurchasePlan
        :keyword architecture: The architecture of the image. Applicable to OS disks only. Known values
         are: "x64" and "Arm64".
        :paramtype architecture: str or ~azure.mgmt.compute.models.Architecture
        :keyword privacy_statement_uri: Privacy statement uri for the current community gallery image.
        :paramtype privacy_statement_uri: str
        :keyword eula: End-user license agreement for the current community gallery image.
        :paramtype eula: str
        :keyword artifact_tags: The artifact tags of a shared gallery resource.
        :paramtype artifact_tags: dict[str, str]
        """
        super().__init__(unique_id=unique_id, **kwargs)
        self.os_type = os_type
        self.os_state = os_state
        self.end_of_life_date = end_of_life_date
        self.identifier = identifier
        self.recommended = recommended
        self.disallowed = disallowed
        self.hyper_v_generation = hyper_v_generation
        self.features = features
        self.purchase_plan = purchase_plan
        self.architecture = architecture
        self.privacy_statement_uri = privacy_statement_uri
        self.eula = eula
        self.artifact_tags = artifact_tags


class SharedGalleryImageList(_serialization.Model):
    """The List Shared Gallery Images operation response.

    All required parameters must be populated in order to send to server.

    :ivar value: A list of shared gallery images. Required.
    :vartype value: list[~azure.mgmt.compute.models.SharedGalleryImage]
    :ivar next_link: The uri to fetch the next page of shared gallery images. Call ListNext() with
     this to fetch the next page of shared gallery images.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SharedGalleryImage]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: list["_models.SharedGalleryImage"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of shared gallery images. Required.
        :paramtype value: list[~azure.mgmt.compute.models.SharedGalleryImage]
        :keyword next_link: The uri to fetch the next page of shared gallery images. Call ListNext()
         with this to fetch the next page of shared gallery images.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SharedGalleryImageVersion(PirSharedGalleryResource):
    """Specifies information about the gallery image version that you want to create or update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Resource name.
    :vartype name: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar unique_id: The unique id of this shared gallery.
    :vartype unique_id: str
    :ivar published_date: The published date of the gallery image version Definition. This property
     can be used for decommissioning purposes. This property is updatable.
    :vartype published_date: ~datetime.datetime
    :ivar end_of_life_date: The end of life date of the gallery image version Definition. This
     property can be used for decommissioning purposes. This property is updatable.
    :vartype end_of_life_date: ~datetime.datetime
    :ivar exclude_from_latest: If set to true, Virtual Machines deployed from the latest version of
     the Image Definition won't use this Image Version.
    :vartype exclude_from_latest: bool
    :ivar storage_profile: Describes the storage profile of the image version.
    :vartype storage_profile: ~azure.mgmt.compute.models.SharedGalleryImageVersionStorageProfile
    :ivar artifact_tags: The artifact tags of a shared gallery resource.
    :vartype artifact_tags: dict[str, str]
    """

    _validation = {
        "name": {"readonly": True},
        "location": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "unique_id": {"key": "identifier.uniqueId", "type": "str"},
        "published_date": {"key": "properties.publishedDate", "type": "iso-8601"},
        "end_of_life_date": {"key": "properties.endOfLifeDate", "type": "iso-8601"},
        "exclude_from_latest": {"key": "properties.excludeFromLatest", "type": "bool"},
        "storage_profile": {"key": "properties.storageProfile", "type": "SharedGalleryImageVersionStorageProfile"},
        "artifact_tags": {"key": "properties.artifactTags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        unique_id: Optional[str] = None,
        published_date: Optional[datetime.datetime] = None,
        end_of_life_date: Optional[datetime.datetime] = None,
        exclude_from_latest: Optional[bool] = None,
        storage_profile: Optional["_models.SharedGalleryImageVersionStorageProfile"] = None,
        artifact_tags: Optional[dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword unique_id: The unique id of this shared gallery.
        :paramtype unique_id: str
        :keyword published_date: The published date of the gallery image version Definition. This
         property can be used for decommissioning purposes. This property is updatable.
        :paramtype published_date: ~datetime.datetime
        :keyword end_of_life_date: The end of life date of the gallery image version Definition. This
         property can be used for decommissioning purposes. This property is updatable.
        :paramtype end_of_life_date: ~datetime.datetime
        :keyword exclude_from_latest: If set to true, Virtual Machines deployed from the latest version
         of the Image Definition won't use this Image Version.
        :paramtype exclude_from_latest: bool
        :keyword storage_profile: Describes the storage profile of the image version.
        :paramtype storage_profile: ~azure.mgmt.compute.models.SharedGalleryImageVersionStorageProfile
        :keyword artifact_tags: The artifact tags of a shared gallery resource.
        :paramtype artifact_tags: dict[str, str]
        """
        super().__init__(unique_id=unique_id, **kwargs)
        self.published_date = published_date
        self.end_of_life_date = end_of_life_date
        self.exclude_from_latest = exclude_from_latest
        self.storage_profile = storage_profile
        self.artifact_tags = artifact_tags


class SharedGalleryImageVersionList(_serialization.Model):
    """The List Shared Gallery Image versions operation response.

    All required parameters must be populated in order to send to server.

    :ivar value: The SharedGalleryImageVersion items on this page. Required.
    :vartype value: list[~azure.mgmt.compute.models.SharedGalleryImageVersion]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SharedGalleryImageVersion]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: list["_models.SharedGalleryImageVersion"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The SharedGalleryImageVersion items on this page. Required.
        :paramtype value: list[~azure.mgmt.compute.models.SharedGalleryImageVersion]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SharedGalleryImageVersionStorageProfile(_serialization.Model):
    """This is the storage profile of a Gallery Image Version.

    :ivar os_disk_image: This is the OS disk image.
    :vartype os_disk_image: ~azure.mgmt.compute.models.SharedGalleryOSDiskImage
    :ivar data_disk_images: A list of data disk images.
    :vartype data_disk_images: list[~azure.mgmt.compute.models.SharedGalleryDataDiskImage]
    """

    _attribute_map = {
        "os_disk_image": {"key": "osDiskImage", "type": "SharedGalleryOSDiskImage"},
        "data_disk_images": {"key": "dataDiskImages", "type": "[SharedGalleryDataDiskImage]"},
    }

    def __init__(
        self,
        *,
        os_disk_image: Optional["_models.SharedGalleryOSDiskImage"] = None,
        data_disk_images: Optional[list["_models.SharedGalleryDataDiskImage"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword os_disk_image: This is the OS disk image.
        :paramtype os_disk_image: ~azure.mgmt.compute.models.SharedGalleryOSDiskImage
        :keyword data_disk_images: A list of data disk images.
        :paramtype data_disk_images: list[~azure.mgmt.compute.models.SharedGalleryDataDiskImage]
        """
        super().__init__(**kwargs)
        self.os_disk_image = os_disk_image
        self.data_disk_images = data_disk_images


class SharedGalleryList(_serialization.Model):
    """The List Shared Galleries operation response.

    All required parameters must be populated in order to send to server.

    :ivar value: A list of shared galleries. Required.
    :vartype value: list[~azure.mgmt.compute.models.SharedGallery]
    :ivar next_link: The uri to fetch the next page of shared galleries. Call ListNext() with this
     to fetch the next page of shared galleries.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SharedGallery]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: list["_models.SharedGallery"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of shared galleries. Required.
        :paramtype value: list[~azure.mgmt.compute.models.SharedGallery]
        :keyword next_link: The uri to fetch the next page of shared galleries. Call ListNext() with
         this to fetch the next page of shared galleries.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SharedGalleryOSDiskImage(SharedGalleryDiskImage):
    """This is the OS disk image.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar disk_size_gb: This property indicates the size of the VHD to be created.
    :vartype disk_size_gb: int
    :ivar host_caching: The host caching of the disk. Valid values are 'None', 'ReadOnly', and
     'ReadWrite'. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype host_caching: str or ~azure.mgmt.compute.models.SharedGalleryHostCaching
    """


class ShareInfoElement(_serialization.Model):
    """ShareInfoElement.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar vm_uri: A relative URI containing the ID of the VM that has the disk attached.
    :vartype vm_uri: str
    """

    _validation = {
        "vm_uri": {"readonly": True},
    }

    _attribute_map = {
        "vm_uri": {"key": "vmUri", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.vm_uri: Optional[str] = None


class SharingProfile(_serialization.Model):
    """Profile for gallery sharing to subscription or tenant.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar permissions: This property allows you to specify the permission of sharing gallery.
     Possible values are: **Private,** **Groups,** **Community.**. Known values are: "Private",
     "Groups", and "Community".
    :vartype permissions: str or ~azure.mgmt.compute.models.GallerySharingPermissionTypes
    :ivar groups: A list of sharing profile groups.
    :vartype groups: list[~azure.mgmt.compute.models.SharingProfileGroup]
    :ivar community_gallery_info: Information of community gallery if current gallery is shared to
     community.
    :vartype community_gallery_info: ~azure.mgmt.compute.models.CommunityGalleryInfo
    """

    _validation = {
        "groups": {"readonly": True},
    }

    _attribute_map = {
        "permissions": {"key": "permissions", "type": "str"},
        "groups": {"key": "groups", "type": "[SharingProfileGroup]"},
        "community_gallery_info": {"key": "communityGalleryInfo", "type": "CommunityGalleryInfo"},
    }

    def __init__(
        self,
        *,
        permissions: Optional[Union[str, "_models.GallerySharingPermissionTypes"]] = None,
        community_gallery_info: Optional["_models.CommunityGalleryInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword permissions: This property allows you to specify the permission of sharing gallery.
         Possible values are: **Private,** **Groups,** **Community.**. Known values are: "Private",
         "Groups", and "Community".
        :paramtype permissions: str or ~azure.mgmt.compute.models.GallerySharingPermissionTypes
        :keyword community_gallery_info: Information of community gallery if current gallery is shared
         to community.
        :paramtype community_gallery_info: ~azure.mgmt.compute.models.CommunityGalleryInfo
        """
        super().__init__(**kwargs)
        self.permissions = permissions
        self.groups: Optional[list["_models.SharingProfileGroup"]] = None
        self.community_gallery_info = community_gallery_info


class SharingProfileGroup(_serialization.Model):
    """Group of the gallery sharing profile.

    :ivar type: This property allows you to specify the type of sharing group. Possible values are:
     **Subscriptions,** **AADTenants.**. Known values are: "Subscriptions" and "AADTenants".
    :vartype type: str or ~azure.mgmt.compute.models.SharingProfileGroupTypes
    :ivar ids: A list of subscription/tenant ids the gallery is aimed to be shared to.
    :vartype ids: list[str]
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "ids": {"key": "ids", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.SharingProfileGroupTypes"]] = None,
        ids: Optional[list[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: This property allows you to specify the type of sharing group. Possible values
         are: **Subscriptions,** **AADTenants.**. Known values are: "Subscriptions" and "AADTenants".
        :paramtype type: str or ~azure.mgmt.compute.models.SharingProfileGroupTypes
        :keyword ids: A list of subscription/tenant ids the gallery is aimed to be shared to.
        :paramtype ids: list[str]
        """
        super().__init__(**kwargs)
        self.type = type
        self.ids = ids


class SharingStatus(_serialization.Model):
    """Sharing status of current gallery.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar aggregated_state: Aggregated sharing state of current gallery. Known values are:
     "Succeeded", "InProgress", "Failed", and "Unknown".
    :vartype aggregated_state: str or ~azure.mgmt.compute.models.SharingState
    :ivar summary: Summary of all regional sharing status.
    :vartype summary: list[~azure.mgmt.compute.models.RegionalSharingStatus]
    """

    _validation = {
        "aggregated_state": {"readonly": True},
    }

    _attribute_map = {
        "aggregated_state": {"key": "aggregatedState", "type": "str"},
        "summary": {"key": "summary", "type": "[RegionalSharingStatus]"},
    }

    def __init__(self, *, summary: Optional[list["_models.RegionalSharingStatus"]] = None, **kwargs: Any) -> None:
        """
        :keyword summary: Summary of all regional sharing status.
        :paramtype summary: list[~azure.mgmt.compute.models.RegionalSharingStatus]
        """
        super().__init__(**kwargs)
        self.aggregated_state: Optional[Union[str, "_models.SharingState"]] = None
        self.summary = summary


class SharingUpdate(_serialization.Model):
    """Specifies information about the gallery sharing profile update.

    All required parameters must be populated in order to send to server.

    :ivar operation_type: This property allows you to specify the operation type of gallery sharing
     update. Possible values are: **Add,** **Remove,** **Reset.**. Required. Known values are:
     "Add", "Remove", "Reset", and "EnableCommunity".
    :vartype operation_type: str or ~azure.mgmt.compute.models.SharingUpdateOperationTypes
    :ivar groups: A list of sharing profile groups.
    :vartype groups: list[~azure.mgmt.compute.models.SharingProfileGroup]
    """

    _validation = {
        "operation_type": {"required": True},
    }

    _attribute_map = {
        "operation_type": {"key": "operationType", "type": "str"},
        "groups": {"key": "groups", "type": "[SharingProfileGroup]"},
    }

    def __init__(
        self,
        *,
        operation_type: Union[str, "_models.SharingUpdateOperationTypes"],
        groups: Optional[list["_models.SharingProfileGroup"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword operation_type: This property allows you to specify the operation type of gallery
         sharing update. Possible values are: **Add,** **Remove,** **Reset.**. Required. Known values
         are: "Add", "Remove", "Reset", and "EnableCommunity".
        :paramtype operation_type: str or ~azure.mgmt.compute.models.SharingUpdateOperationTypes
        :keyword groups: A list of sharing profile groups.
        :paramtype groups: list[~azure.mgmt.compute.models.SharingProfileGroup]
        """
        super().__init__(**kwargs)
        self.operation_type = operation_type
        self.groups = groups


class Sku(_serialization.Model):
    """Describes a virtual machine scale set sku. NOTE: If the new VM SKU is not supported on the
    hardware the scale set is currently on, you need to deallocate the VMs in the scale set before
    you modify the SKU name.

    :ivar name: The sku name.
    :vartype name: str
    :ivar tier: Specifies the tier of virtual machines in a scale set.\\ :code:`<br />`\\
     :code:`<br />` Possible Values:\\ :code:`<br />`\\ :code:`<br />` **Standard**\\ :code:`<br
     />`\\ :code:`<br />` **Basic**.
    :vartype tier: str
    :ivar capacity: Specifies the number of virtual machines in the scale set.
    :vartype capacity: int
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
    }

    def __init__(
        self, *, name: Optional[str] = None, tier: Optional[str] = None, capacity: Optional[int] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: The sku name.
        :paramtype name: str
        :keyword tier: Specifies the tier of virtual machines in a scale set.\\ :code:`<br />`\\
         :code:`<br />` Possible Values:\\ :code:`<br />`\\ :code:`<br />` **Standard**\\ :code:`<br
         />`\\ :code:`<br />` **Basic**.
        :paramtype tier: str
        :keyword capacity: Specifies the number of virtual machines in the scale set.
        :paramtype capacity: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.capacity = capacity


class SkuProfile(_serialization.Model):
    """Specifies the sku profile for the virtual machine scale set. With this property the customer is
    able to specify a list of VM sizes and an allocation strategy.

    :ivar vm_sizes: Specifies the VM sizes for the virtual machine scale set.
    :vartype vm_sizes: list[~azure.mgmt.compute.models.SkuProfileVMSize]
    :ivar allocation_strategy: Specifies the allocation strategy for the virtual machine scale set
     based on which the VMs will be allocated. Known values are: "LowestPrice", "CapacityOptimized",
     and "Prioritized".
    :vartype allocation_strategy: str or ~azure.mgmt.compute.models.AllocationStrategy
    """

    _attribute_map = {
        "vm_sizes": {"key": "vmSizes", "type": "[SkuProfileVMSize]"},
        "allocation_strategy": {"key": "allocationStrategy", "type": "str"},
    }

    def __init__(
        self,
        *,
        vm_sizes: Optional[list["_models.SkuProfileVMSize"]] = None,
        allocation_strategy: Optional[Union[str, "_models.AllocationStrategy"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword vm_sizes: Specifies the VM sizes for the virtual machine scale set.
        :paramtype vm_sizes: list[~azure.mgmt.compute.models.SkuProfileVMSize]
        :keyword allocation_strategy: Specifies the allocation strategy for the virtual machine scale
         set based on which the VMs will be allocated. Known values are: "LowestPrice",
         "CapacityOptimized", and "Prioritized".
        :paramtype allocation_strategy: str or ~azure.mgmt.compute.models.AllocationStrategy
        """
        super().__init__(**kwargs)
        self.vm_sizes = vm_sizes
        self.allocation_strategy = allocation_strategy


class SkuProfileVMSize(_serialization.Model):
    """Specifies the VM Size.

    :ivar name: Specifies the name of the VM Size.
    :vartype name: str
    :ivar rank: Specifies the rank (a.k.a priority) associated with the VM Size.
    :vartype rank: int
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "rank": {"key": "rank", "type": "int"},
    }

    def __init__(self, *, name: Optional[str] = None, rank: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword name: Specifies the name of the VM Size.
        :paramtype name: str
        :keyword rank: Specifies the rank (a.k.a priority) associated with the VM Size.
        :paramtype rank: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.rank = rank


class Snapshot(TrackedResource):
    """Snapshot resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.compute.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar managed_by: Unused. Always Null.
    :vartype managed_by: str
    :ivar sku: The snapshots sku name. Can be Standard_LRS, Premium_LRS, or Standard_ZRS. This is
     an optional parameter for incremental snapshot and the default behavior is the SKU will be set
     to the same sku as the previous snapshot.
    :vartype sku: ~azure.mgmt.compute.models.SnapshotSku
    :ivar extended_location: The extended location where the snapshot will be created. Extended
     location cannot be changed.
    :vartype extended_location: ~azure.mgmt.compute.models.ExtendedLocation
    :ivar time_created: The time when the snapshot was created.
    :vartype time_created: ~datetime.datetime
    :ivar os_type: The Operating System type. Known values are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
    :ivar hyper_v_generation: The hypervisor generation of the Virtual Machine. Applicable to OS
     disks only. Known values are: "V1" and "V2".
    :vartype hyper_v_generation: str or ~azure.mgmt.compute.models.HyperVGeneration
    :ivar purchase_plan: Purchase plan information for the image from which the source disk for the
     snapshot was originally created.
    :vartype purchase_plan: ~azure.mgmt.compute.models.DiskPurchasePlan
    :ivar supported_capabilities: List of supported capabilities for the image from which the
     source disk from the snapshot was originally created.
    :vartype supported_capabilities: ~azure.mgmt.compute.models.SupportedCapabilities
    :ivar creation_data: Disk source information. CreationData information cannot be changed after
     the disk has been created.
    :vartype creation_data: ~azure.mgmt.compute.models.CreationData
    :ivar disk_size_gb: If creationData.createOption is Empty, this field is mandatory and it
     indicates the size of the disk to create. If this field is present for updates or creation with
     other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a
     running VM, and can only increase the disk's size.
    :vartype disk_size_gb: int
    :ivar disk_size_bytes: The size of the disk in bytes. This field is read only.
    :vartype disk_size_bytes: int
    :ivar disk_state: The state of the snapshot. Known values are: "Unattached", "Attached",
     "Reserved", "Frozen", "ActiveSAS", "ActiveSASFrozen", "ReadyToUpload", and "ActiveUpload".
    :vartype disk_state: str or ~azure.mgmt.compute.models.DiskState
    :ivar unique_id: Unique Guid identifying the resource.
    :vartype unique_id: str
    :ivar encryption_settings_collection: Encryption settings collection used be Azure Disk
     Encryption, can contain multiple encryption settings per disk or snapshot.
    :vartype encryption_settings_collection:
     ~azure.mgmt.compute.models.EncryptionSettingsCollection
    :ivar provisioning_state: The disk provisioning state.
    :vartype provisioning_state: str
    :ivar incremental: Whether a snapshot is incremental. Incremental snapshots on the same disk
     occupy less space than full snapshots and can be diffed.
    :vartype incremental: bool
    :ivar incremental_snapshot_family_id: Incremental snapshots for a disk share an incremental
     snapshot family id. The Get Page Range Diff API can only be called on incremental snapshots
     with the same family id.
    :vartype incremental_snapshot_family_id: str
    :ivar encryption: Encryption property can be used to encrypt data at rest with customer managed
     keys or platform managed keys.
    :vartype encryption: ~azure.mgmt.compute.models.Encryption
    :ivar network_access_policy: Policy for accessing the disk via network. Known values are:
     "AllowAll", "AllowPrivate", and "DenyAll".
    :vartype network_access_policy: str or ~azure.mgmt.compute.models.NetworkAccessPolicy
    :ivar disk_access_id: ARM id of the DiskAccess resource for using private endpoints on disks.
    :vartype disk_access_id: str
    :ivar security_profile: Contains the security related information for the resource.
    :vartype security_profile: ~azure.mgmt.compute.models.DiskSecurityProfile
    :ivar supports_hibernation: Indicates the OS on a snapshot supports hibernation.
    :vartype supports_hibernation: bool
    :ivar public_network_access: Policy for controlling export on the disk. Known values are:
     "Enabled" and "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.compute.models.PublicNetworkAccess
    :ivar completion_percent: Percentage complete for the background copy when a resource is
     created via the CopyStart operation.
    :vartype completion_percent: float
    :ivar copy_completion_error: Indicates the error details if the background copy of a resource
     created via the CopyStart operation fails.
    :vartype copy_completion_error: ~azure.mgmt.compute.models.CopyCompletionError
    :ivar data_access_auth_mode: Additional authentication requirements when exporting or uploading
     to a disk or snapshot. Known values are: "AzureActiveDirectory" and "None".
    :vartype data_access_auth_mode: str or ~azure.mgmt.compute.models.DataAccessAuthMode
    :ivar snapshot_access_state: The state of snapshot which determines the access availability of
     the snapshot. Known values are: "Unknown", "Pending", "Available", "InstantAccess", and
     "AvailableWithInstantAccess".
    :vartype snapshot_access_state: str or ~azure.mgmt.compute.models.SnapshotAccessState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "managed_by": {"readonly": True},
        "time_created": {"readonly": True},
        "disk_size_bytes": {"readonly": True},
        "disk_state": {"readonly": True},
        "unique_id": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "incremental_snapshot_family_id": {"readonly": True},
        "snapshot_access_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "managed_by": {"key": "managedBy", "type": "str"},
        "sku": {"key": "sku", "type": "SnapshotSku"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "time_created": {"key": "properties.timeCreated", "type": "iso-8601"},
        "os_type": {"key": "properties.osType", "type": "str"},
        "hyper_v_generation": {"key": "properties.hyperVGeneration", "type": "str"},
        "purchase_plan": {"key": "properties.purchasePlan", "type": "DiskPurchasePlan"},
        "supported_capabilities": {"key": "properties.supportedCapabilities", "type": "SupportedCapabilities"},
        "creation_data": {"key": "properties.creationData", "type": "CreationData"},
        "disk_size_gb": {"key": "properties.diskSizeGB", "type": "int"},
        "disk_size_bytes": {"key": "properties.diskSizeBytes", "type": "int"},
        "disk_state": {"key": "properties.diskState", "type": "str"},
        "unique_id": {"key": "properties.uniqueId", "type": "str"},
        "encryption_settings_collection": {
            "key": "properties.encryptionSettingsCollection",
            "type": "EncryptionSettingsCollection",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "incremental": {"key": "properties.incremental", "type": "bool"},
        "incremental_snapshot_family_id": {"key": "properties.incrementalSnapshotFamilyId", "type": "str"},
        "encryption": {"key": "properties.encryption", "type": "Encryption"},
        "network_access_policy": {"key": "properties.networkAccessPolicy", "type": "str"},
        "disk_access_id": {"key": "properties.diskAccessId", "type": "str"},
        "security_profile": {"key": "properties.securityProfile", "type": "DiskSecurityProfile"},
        "supports_hibernation": {"key": "properties.supportsHibernation", "type": "bool"},
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "completion_percent": {"key": "properties.completionPercent", "type": "float"},
        "copy_completion_error": {"key": "properties.copyCompletionError", "type": "CopyCompletionError"},
        "data_access_auth_mode": {"key": "properties.dataAccessAuthMode", "type": "str"},
        "snapshot_access_state": {"key": "properties.snapshotAccessState", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        sku: Optional["_models.SnapshotSku"] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None,
        hyper_v_generation: Optional[Union[str, "_models.HyperVGeneration"]] = None,
        purchase_plan: Optional["_models.DiskPurchasePlan"] = None,
        supported_capabilities: Optional["_models.SupportedCapabilities"] = None,
        creation_data: Optional["_models.CreationData"] = None,
        disk_size_gb: Optional[int] = None,
        encryption_settings_collection: Optional["_models.EncryptionSettingsCollection"] = None,
        incremental: Optional[bool] = None,
        encryption: Optional["_models.Encryption"] = None,
        network_access_policy: Optional[Union[str, "_models.NetworkAccessPolicy"]] = None,
        disk_access_id: Optional[str] = None,
        security_profile: Optional["_models.DiskSecurityProfile"] = None,
        supports_hibernation: Optional[bool] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        completion_percent: Optional[float] = None,
        copy_completion_error: Optional["_models.CopyCompletionError"] = None,
        data_access_auth_mode: Optional[Union[str, "_models.DataAccessAuthMode"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword sku: The snapshots sku name. Can be Standard_LRS, Premium_LRS, or Standard_ZRS. This
         is an optional parameter for incremental snapshot and the default behavior is the SKU will be
         set to the same sku as the previous snapshot.
        :paramtype sku: ~azure.mgmt.compute.models.SnapshotSku
        :keyword extended_location: The extended location where the snapshot will be created. Extended
         location cannot be changed.
        :paramtype extended_location: ~azure.mgmt.compute.models.ExtendedLocation
        :keyword os_type: The Operating System type. Known values are: "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
        :keyword hyper_v_generation: The hypervisor generation of the Virtual Machine. Applicable to OS
         disks only. Known values are: "V1" and "V2".
        :paramtype hyper_v_generation: str or ~azure.mgmt.compute.models.HyperVGeneration
        :keyword purchase_plan: Purchase plan information for the image from which the source disk for
         the snapshot was originally created.
        :paramtype purchase_plan: ~azure.mgmt.compute.models.DiskPurchasePlan
        :keyword supported_capabilities: List of supported capabilities for the image from which the
         source disk from the snapshot was originally created.
        :paramtype supported_capabilities: ~azure.mgmt.compute.models.SupportedCapabilities
        :keyword creation_data: Disk source information. CreationData information cannot be changed
         after the disk has been created.
        :paramtype creation_data: ~azure.mgmt.compute.models.CreationData
        :keyword disk_size_gb: If creationData.createOption is Empty, this field is mandatory and it
         indicates the size of the disk to create. If this field is present for updates or creation with
         other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a
         running VM, and can only increase the disk's size.
        :paramtype disk_size_gb: int
        :keyword encryption_settings_collection: Encryption settings collection used be Azure Disk
         Encryption, can contain multiple encryption settings per disk or snapshot.
        :paramtype encryption_settings_collection:
         ~azure.mgmt.compute.models.EncryptionSettingsCollection
        :keyword incremental: Whether a snapshot is incremental. Incremental snapshots on the same disk
         occupy less space than full snapshots and can be diffed.
        :paramtype incremental: bool
        :keyword encryption: Encryption property can be used to encrypt data at rest with customer
         managed keys or platform managed keys.
        :paramtype encryption: ~azure.mgmt.compute.models.Encryption
        :keyword network_access_policy: Policy for accessing the disk via network. Known values are:
         "AllowAll", "AllowPrivate", and "DenyAll".
        :paramtype network_access_policy: str or ~azure.mgmt.compute.models.NetworkAccessPolicy
        :keyword disk_access_id: ARM id of the DiskAccess resource for using private endpoints on
         disks.
        :paramtype disk_access_id: str
        :keyword security_profile: Contains the security related information for the resource.
        :paramtype security_profile: ~azure.mgmt.compute.models.DiskSecurityProfile
        :keyword supports_hibernation: Indicates the OS on a snapshot supports hibernation.
        :paramtype supports_hibernation: bool
        :keyword public_network_access: Policy for controlling export on the disk. Known values are:
         "Enabled" and "Disabled".
        :paramtype public_network_access: str or ~azure.mgmt.compute.models.PublicNetworkAccess
        :keyword completion_percent: Percentage complete for the background copy when a resource is
         created via the CopyStart operation.
        :paramtype completion_percent: float
        :keyword copy_completion_error: Indicates the error details if the background copy of a
         resource created via the CopyStart operation fails.
        :paramtype copy_completion_error: ~azure.mgmt.compute.models.CopyCompletionError
        :keyword data_access_auth_mode: Additional authentication requirements when exporting or
         uploading to a disk or snapshot. Known values are: "AzureActiveDirectory" and "None".
        :paramtype data_access_auth_mode: str or ~azure.mgmt.compute.models.DataAccessAuthMode
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.managed_by: Optional[str] = None
        self.sku = sku
        self.extended_location = extended_location
        self.time_created: Optional[datetime.datetime] = None
        self.os_type = os_type
        self.hyper_v_generation = hyper_v_generation
        self.purchase_plan = purchase_plan
        self.supported_capabilities = supported_capabilities
        self.creation_data = creation_data
        self.disk_size_gb = disk_size_gb
        self.disk_size_bytes: Optional[int] = None
        self.disk_state: Optional[Union[str, "_models.DiskState"]] = None
        self.unique_id: Optional[str] = None
        self.encryption_settings_collection = encryption_settings_collection
        self.provisioning_state: Optional[str] = None
        self.incremental = incremental
        self.incremental_snapshot_family_id: Optional[str] = None
        self.encryption = encryption
        self.network_access_policy = network_access_policy
        self.disk_access_id = disk_access_id
        self.security_profile = security_profile
        self.supports_hibernation = supports_hibernation
        self.public_network_access = public_network_access
        self.completion_percent = completion_percent
        self.copy_completion_error = copy_completion_error
        self.data_access_auth_mode = data_access_auth_mode
        self.snapshot_access_state: Optional[Union[str, "_models.SnapshotAccessState"]] = None


class SnapshotList(_serialization.Model):
    """The List Snapshots operation response.

    All required parameters must be populated in order to send to server.

    :ivar value: A list of snapshots. Required.
    :vartype value: list[~azure.mgmt.compute.models.Snapshot]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Snapshot]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: list["_models.Snapshot"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of snapshots. Required.
        :paramtype value: list[~azure.mgmt.compute.models.Snapshot]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SnapshotSku(_serialization.Model):
    """The snapshots sku name. Can be Standard_LRS, Premium_LRS, or Standard_ZRS. This is an optional
    parameter for incremental snapshot and the default behavior is the SKU will be set to the same
    sku as the previous snapshot.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The sku name. Known values are: "Standard_LRS", "Premium_LRS", and "Standard_ZRS".
    :vartype name: str or ~azure.mgmt.compute.models.SnapshotStorageAccountTypes
    :ivar tier: The sku tier.
    :vartype tier: str
    """

    _validation = {
        "tier": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
    }

    def __init__(
        self, *, name: Optional[Union[str, "_models.SnapshotStorageAccountTypes"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: The sku name. Known values are: "Standard_LRS", "Premium_LRS", and
         "Standard_ZRS".
        :paramtype name: str or ~azure.mgmt.compute.models.SnapshotStorageAccountTypes
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier: Optional[str] = None


class SnapshotUpdate(_serialization.Model):
    """Snapshot update resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: The snapshots sku name. Can be Standard_LRS, Premium_LRS, or Standard_ZRS. This is
     an optional parameter for incremental snapshot and the default behavior is the SKU will be set
     to the same sku as the previous snapshot.
    :vartype sku: ~azure.mgmt.compute.models.SnapshotSku
    :ivar os_type: the Operating System type. Known values are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
    :ivar disk_size_gb: If creationData.createOption is Empty, this field is mandatory and it
     indicates the size of the disk to create. If this field is present for updates or creation with
     other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a
     running VM, and can only increase the disk's size.
    :vartype disk_size_gb: int
    :ivar encryption_settings_collection: Encryption settings collection used be Azure Disk
     Encryption, can contain multiple encryption settings per disk or snapshot.
    :vartype encryption_settings_collection:
     ~azure.mgmt.compute.models.EncryptionSettingsCollection
    :ivar encryption: Encryption property can be used to encrypt data at rest with customer managed
     keys or platform managed keys.
    :vartype encryption: ~azure.mgmt.compute.models.Encryption
    :ivar network_access_policy: Policy for accessing the disk via network. Known values are:
     "AllowAll", "AllowPrivate", and "DenyAll".
    :vartype network_access_policy: str or ~azure.mgmt.compute.models.NetworkAccessPolicy
    :ivar disk_access_id: ARM id of the DiskAccess resource for using private endpoints on disks.
    :vartype disk_access_id: str
    :ivar supports_hibernation: Indicates the OS on a snapshot supports hibernation.
    :vartype supports_hibernation: bool
    :ivar public_network_access: Policy for controlling export on the disk. Known values are:
     "Enabled" and "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.compute.models.PublicNetworkAccess
    :ivar data_access_auth_mode: Additional authentication requirements when exporting or uploading
     to a disk or snapshot. Known values are: "AzureActiveDirectory" and "None".
    :vartype data_access_auth_mode: str or ~azure.mgmt.compute.models.DataAccessAuthMode
    :ivar supported_capabilities: List of supported capabilities for the image from which the OS
     disk was created.
    :vartype supported_capabilities: ~azure.mgmt.compute.models.SupportedCapabilities
    :ivar snapshot_access_state: The state of snapshot which determines the access availability of
     the snapshot. Known values are: "Unknown", "Pending", "Available", "InstantAccess", and
     "AvailableWithInstantAccess".
    :vartype snapshot_access_state: str or ~azure.mgmt.compute.models.SnapshotAccessState
    """

    _validation = {
        "snapshot_access_state": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "SnapshotSku"},
        "os_type": {"key": "properties.osType", "type": "str"},
        "disk_size_gb": {"key": "properties.diskSizeGB", "type": "int"},
        "encryption_settings_collection": {
            "key": "properties.encryptionSettingsCollection",
            "type": "EncryptionSettingsCollection",
        },
        "encryption": {"key": "properties.encryption", "type": "Encryption"},
        "network_access_policy": {"key": "properties.networkAccessPolicy", "type": "str"},
        "disk_access_id": {"key": "properties.diskAccessId", "type": "str"},
        "supports_hibernation": {"key": "properties.supportsHibernation", "type": "bool"},
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "data_access_auth_mode": {"key": "properties.dataAccessAuthMode", "type": "str"},
        "supported_capabilities": {"key": "properties.supportedCapabilities", "type": "SupportedCapabilities"},
        "snapshot_access_state": {"key": "properties.snapshotAccessState", "type": "str"},
    }

    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
        sku: Optional["_models.SnapshotSku"] = None,
        os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None,
        disk_size_gb: Optional[int] = None,
        encryption_settings_collection: Optional["_models.EncryptionSettingsCollection"] = None,
        encryption: Optional["_models.Encryption"] = None,
        network_access_policy: Optional[Union[str, "_models.NetworkAccessPolicy"]] = None,
        disk_access_id: Optional[str] = None,
        supports_hibernation: Optional[bool] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        data_access_auth_mode: Optional[Union[str, "_models.DataAccessAuthMode"]] = None,
        supported_capabilities: Optional["_models.SupportedCapabilities"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: The snapshots sku name. Can be Standard_LRS, Premium_LRS, or Standard_ZRS. This
         is an optional parameter for incremental snapshot and the default behavior is the SKU will be
         set to the same sku as the previous snapshot.
        :paramtype sku: ~azure.mgmt.compute.models.SnapshotSku
        :keyword os_type: the Operating System type. Known values are: "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
        :keyword disk_size_gb: If creationData.createOption is Empty, this field is mandatory and it
         indicates the size of the disk to create. If this field is present for updates or creation with
         other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a
         running VM, and can only increase the disk's size.
        :paramtype disk_size_gb: int
        :keyword encryption_settings_collection: Encryption settings collection used be Azure Disk
         Encryption, can contain multiple encryption settings per disk or snapshot.
        :paramtype encryption_settings_collection:
         ~azure.mgmt.compute.models.EncryptionSettingsCollection
        :keyword encryption: Encryption property can be used to encrypt data at rest with customer
         managed keys or platform managed keys.
        :paramtype encryption: ~azure.mgmt.compute.models.Encryption
        :keyword network_access_policy: Policy for accessing the disk via network. Known values are:
         "AllowAll", "AllowPrivate", and "DenyAll".
        :paramtype network_access_policy: str or ~azure.mgmt.compute.models.NetworkAccessPolicy
        :keyword disk_access_id: ARM id of the DiskAccess resource for using private endpoints on
         disks.
        :paramtype disk_access_id: str
        :keyword supports_hibernation: Indicates the OS on a snapshot supports hibernation.
        :paramtype supports_hibernation: bool
        :keyword public_network_access: Policy for controlling export on the disk. Known values are:
         "Enabled" and "Disabled".
        :paramtype public_network_access: str or ~azure.mgmt.compute.models.PublicNetworkAccess
        :keyword data_access_auth_mode: Additional authentication requirements when exporting or
         uploading to a disk or snapshot. Known values are: "AzureActiveDirectory" and "None".
        :paramtype data_access_auth_mode: str or ~azure.mgmt.compute.models.DataAccessAuthMode
        :keyword supported_capabilities: List of supported capabilities for the image from which the OS
         disk was created.
        :paramtype supported_capabilities: ~azure.mgmt.compute.models.SupportedCapabilities
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.sku = sku
        self.os_type = os_type
        self.disk_size_gb = disk_size_gb
        self.encryption_settings_collection = encryption_settings_collection
        self.encryption = encryption
        self.network_access_policy = network_access_policy
        self.disk_access_id = disk_access_id
        self.supports_hibernation = supports_hibernation
        self.public_network_access = public_network_access
        self.data_access_auth_mode = data_access_auth_mode
        self.supported_capabilities = supported_capabilities
        self.snapshot_access_state: Optional[Union[str, "_models.SnapshotAccessState"]] = None


class SoftDeletePolicy(_serialization.Model):
    """Contains information about the soft deletion policy of the gallery.

    :ivar is_soft_delete_enabled: Enables soft-deletion for resources in this gallery, allowing
     them to be recovered within retention time.
    :vartype is_soft_delete_enabled: bool
    """

    _attribute_map = {
        "is_soft_delete_enabled": {"key": "isSoftDeleteEnabled", "type": "bool"},
    }

    def __init__(self, *, is_soft_delete_enabled: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword is_soft_delete_enabled: Enables soft-deletion for resources in this gallery, allowing
         them to be recovered within retention time.
        :paramtype is_soft_delete_enabled: bool
        """
        super().__init__(**kwargs)
        self.is_soft_delete_enabled = is_soft_delete_enabled


class SourceVault(_serialization.Model):
    """The vault id is an Azure Resource Manager Resource id in the form
    /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}.

    :ivar id: Resource Id.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource Id.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class SpotRestorePolicy(_serialization.Model):
    """Specifies the Spot-Try-Restore properties for the virtual machine scale set. With this property
    customer can enable or disable automatic restore of the evicted Spot VMSS VM instances
    opportunistically based on capacity availability and pricing constraint.

    :ivar enabled: Enables the Spot-Try-Restore feature where evicted VMSS SPOT instances will be
     tried to be restored opportunistically based on capacity availability and pricing constraints.
    :vartype enabled: bool
    :ivar restore_timeout: Timeout value expressed as an ISO 8601 time duration after which the
     platform will not try to restore the VMSS SPOT instances.
    :vartype restore_timeout: str
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "restore_timeout": {"key": "restoreTimeout", "type": "str"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, restore_timeout: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Enables the Spot-Try-Restore feature where evicted VMSS SPOT instances will
         be tried to be restored opportunistically based on capacity availability and pricing
         constraints.
        :paramtype enabled: bool
        :keyword restore_timeout: Timeout value expressed as an ISO 8601 time duration after which the
         platform will not try to restore the VMSS SPOT instances.
        :paramtype restore_timeout: str
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.restore_timeout = restore_timeout


class SshConfiguration(_serialization.Model):
    """SSH configuration for Linux based VMs running on Azure.

    :ivar public_keys: The list of SSH public keys used to authenticate with linux based VMs.
    :vartype public_keys: list[~azure.mgmt.compute.models.SshPublicKey]
    """

    _attribute_map = {
        "public_keys": {"key": "publicKeys", "type": "[SshPublicKey]"},
    }

    def __init__(self, *, public_keys: Optional[list["_models.SshPublicKey"]] = None, **kwargs: Any) -> None:
        """
        :keyword public_keys: The list of SSH public keys used to authenticate with linux based VMs.
        :paramtype public_keys: list[~azure.mgmt.compute.models.SshPublicKey]
        """
        super().__init__(**kwargs)
        self.public_keys = public_keys


class SshGenerateKeyPairInputParameters(_serialization.Model):
    """Parameters for GenerateSshKeyPair.

    :ivar encryption_type: The encryption type of the SSH keys to be generated. See
     SshEncryptionTypes for possible set of values. If not provided, will default to RSA. Known
     values are: "RSA" and "Ed25519".
    :vartype encryption_type: str or ~azure.mgmt.compute.models.SshEncryptionTypes
    """

    _attribute_map = {
        "encryption_type": {"key": "encryptionType", "type": "str"},
    }

    def __init__(
        self, *, encryption_type: Optional[Union[str, "_models.SshEncryptionTypes"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword encryption_type: The encryption type of the SSH keys to be generated. See
         SshEncryptionTypes for possible set of values. If not provided, will default to RSA. Known
         values are: "RSA" and "Ed25519".
        :paramtype encryption_type: str or ~azure.mgmt.compute.models.SshEncryptionTypes
        """
        super().__init__(**kwargs)
        self.encryption_type = encryption_type


class SshPublicKey(_serialization.Model):
    """Contains information about SSH certificate public key and the path on the Linux VM where the
    public key is placed.

    :ivar path: Specifies the full path on the created VM where ssh public key is stored. If the
     file already exists, the specified key is appended to the file. Example:
     /home/user/.ssh/authorized_keys.
    :vartype path: str
    :ivar key_data: SSH public key certificate used to authenticate with the VM through ssh. The
     key needs to be at least 2048-bit and in ssh-rsa format. For creating ssh keys, see [Create SSH
     keys on Linux and Mac for Linux VMs in
     Azure]https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed).
    :vartype key_data: str
    """

    _attribute_map = {
        "path": {"key": "path", "type": "str"},
        "key_data": {"key": "keyData", "type": "str"},
    }

    def __init__(self, *, path: Optional[str] = None, key_data: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword path: Specifies the full path on the created VM where ssh public key is stored. If the
         file already exists, the specified key is appended to the file. Example:
         /home/user/.ssh/authorized_keys.
        :paramtype path: str
        :keyword key_data: SSH public key certificate used to authenticate with the VM through ssh. The
         key needs to be at least 2048-bit and in ssh-rsa format. For creating ssh keys, see [Create SSH
         keys on Linux and Mac for Linux VMs in
         Azure]https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed).
        :paramtype key_data: str
        """
        super().__init__(**kwargs)
        self.path = path
        self.key_data = key_data


class SshPublicKeyGenerateKeyPairResult(_serialization.Model):
    """Response from generation of an SSH key pair.

    All required parameters must be populated in order to send to server.

    :ivar private_key: Private key portion of the key pair used to authenticate to a virtual
     machine through ssh. The private key is returned in RFC3447 format and should be treated as a
     secret. Required.
    :vartype private_key: str
    :ivar public_key: Public key portion of the key pair used to authenticate to a virtual machine
     through ssh. The public key is in ssh-rsa format. Required.
    :vartype public_key: str
    :ivar id: The ARM resource id in the form of
     /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Compute/sshPublicKeys/{SshPublicKeyName}.
     Required.
    :vartype id: str
    """

    _validation = {
        "private_key": {"required": True},
        "public_key": {"required": True},
        "id": {"required": True},
    }

    _attribute_map = {
        "private_key": {"key": "privateKey", "type": "str"},
        "public_key": {"key": "publicKey", "type": "str"},
        "id": {"key": "id", "type": "str"},
    }

    def __init__(
        self, *, private_key: str, public_key: str, id: str, **kwargs: Any  # pylint: disable=redefined-builtin
    ) -> None:
        """
        :keyword private_key: Private key portion of the key pair used to authenticate to a virtual
         machine through ssh. The private key is returned in RFC3447 format and should be treated as a
         secret. Required.
        :paramtype private_key: str
        :keyword public_key: Public key portion of the key pair used to authenticate to a virtual
         machine through ssh. The public key is in ssh-rsa format. Required.
        :paramtype public_key: str
        :keyword id: The ARM resource id in the form of
         /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Compute/sshPublicKeys/{SshPublicKeyName}.
         Required.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.private_key = private_key
        self.public_key = public_key
        self.id = id


class SshPublicKeyResource(TrackedResource):
    """Specifies information about the SSH public key.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.compute.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar public_key: SSH public key used to authenticate to a virtual machine through ssh. If this
     property is not initially provided when the resource is created, the publicKey property will be
     populated when generateKeyPair is called. If the public key is provided upon resource creation,
     the provided public key needs to be at least 2048-bit and in ssh-rsa format.
    :vartype public_key: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "public_key": {"key": "properties.publicKey", "type": "str"},
    }

    def __init__(
        self, *, location: str, tags: Optional[dict[str, str]] = None, public_key: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword public_key: SSH public key used to authenticate to a virtual machine through ssh. If
         this property is not initially provided when the resource is created, the publicKey property
         will be populated when generateKeyPair is called. If the public key is provided upon resource
         creation, the provided public key needs to be at least 2048-bit and in ssh-rsa format.
        :paramtype public_key: str
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.public_key = public_key


class SshPublicKeysGroupListResult(_serialization.Model):
    """The list SSH public keys operation response.

    All required parameters must be populated in order to send to server.

    :ivar value: The list of SSH public keys. Required.
    :vartype value: list[~azure.mgmt.compute.models.SshPublicKeyResource]
    :ivar next_link: The URI to fetch the next page of SSH public keys. Call ListNext() with this
     URI to fetch the next page of SSH public keys.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SshPublicKeyResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: list["_models.SshPublicKeyResource"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of SSH public keys. Required.
        :paramtype value: list[~azure.mgmt.compute.models.SshPublicKeyResource]
        :keyword next_link: The URI to fetch the next page of SSH public keys. Call ListNext() with
         this URI to fetch the next page of SSH public keys.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SshPublicKeyUpdateResource(UpdateResource):
    """Specifies information about the SSH public key.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar public_key: SSH public key used to authenticate to a virtual machine through ssh. If this
     property is not initially provided when the resource is created, the publicKey property will be
     populated when generateKeyPair is called. If the public key is provided upon resource creation,
     the provided public key needs to be at least 2048-bit and in ssh-rsa format.
    :vartype public_key: str
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "public_key": {"key": "properties.publicKey", "type": "str"},
    }

    def __init__(
        self, *, tags: Optional[dict[str, str]] = None, public_key: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword public_key: SSH public key used to authenticate to a virtual machine through ssh. If
         this property is not initially provided when the resource is created, the publicKey property
         will be populated when generateKeyPair is called. If the public key is provided upon resource
         creation, the provided public key needs to be at least 2048-bit and in ssh-rsa format.
        :paramtype public_key: str
        """
        super().__init__(tags=tags, **kwargs)
        self.public_key = public_key


class StatusCodeCount(_serialization.Model):
    """The status code and count of the cloud service instance view statuses.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The instance view status code.
    :vartype code: str
    :ivar count: Number of instances having this status code.
    :vartype count: int
    """

    _validation = {
        "code": {"readonly": True},
        "count": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "count": {"key": "count", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.count: Optional[int] = None


class StorageProfile(_serialization.Model):
    """Specifies the storage settings for the virtual machine disks.

    :ivar image_reference: Specifies information about the image to use. You can specify
     information about platform images, marketplace images, or virtual machine images. This element
     is required when you want to use a platform image, marketplace image, or virtual machine image,
     but is not used in other creation operations.
    :vartype image_reference: ~azure.mgmt.compute.models.ImageReference
    :ivar os_disk: Specifies information about the operating system disk used by the virtual
     machine. For more information about disks, see `About disks and VHDs for Azure virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_.
    :vartype os_disk: ~azure.mgmt.compute.models.OSDisk
    :ivar data_disks: Specifies the parameters that are used to add a data disk to a virtual
     machine. For more information about disks, see `About disks and VHDs for Azure virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_.
    :vartype data_disks: list[~azure.mgmt.compute.models.DataDisk]
    :ivar disk_controller_type: Specifies the disk controller type configured for the VM. **Note:**
     This property will be set to the default disk controller type if not specified provided virtual
     machine is being created with 'hyperVGeneration' set to V2 based on the capabilities of the
     operating system disk and VM size from the the specified minimum api version. You need to
     deallocate the VM before updating its disk controller type unless you are updating the VM size
     in the VM configuration which implicitly deallocates and reallocates the VM. Minimum
     api-version: 2022-08-01. Known values are: "SCSI" and "NVMe".
    :vartype disk_controller_type: str or ~azure.mgmt.compute.models.DiskControllerTypes
    :ivar align_regional_disks_to_vm_zone: Specifies whether the regional disks should be
     aligned/moved to the VM zone. This is applicable only for VMs with placement property set.
     Please note that this change is irreversible. Minimum api-version: 2024-11-01.
    :vartype align_regional_disks_to_vm_zone: bool
    """

    _attribute_map = {
        "image_reference": {"key": "imageReference", "type": "ImageReference"},
        "os_disk": {"key": "osDisk", "type": "OSDisk"},
        "data_disks": {"key": "dataDisks", "type": "[DataDisk]"},
        "disk_controller_type": {"key": "diskControllerType", "type": "str"},
        "align_regional_disks_to_vm_zone": {"key": "alignRegionalDisksToVMZone", "type": "bool"},
    }

    def __init__(
        self,
        *,
        image_reference: Optional["_models.ImageReference"] = None,
        os_disk: Optional["_models.OSDisk"] = None,
        data_disks: Optional[list["_models.DataDisk"]] = None,
        disk_controller_type: Optional[Union[str, "_models.DiskControllerTypes"]] = None,
        align_regional_disks_to_vm_zone: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword image_reference: Specifies information about the image to use. You can specify
         information about platform images, marketplace images, or virtual machine images. This element
         is required when you want to use a platform image, marketplace image, or virtual machine image,
         but is not used in other creation operations.
        :paramtype image_reference: ~azure.mgmt.compute.models.ImageReference
        :keyword os_disk: Specifies information about the operating system disk used by the virtual
         machine. For more information about disks, see `About disks and VHDs for Azure virtual machines
         <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_.
        :paramtype os_disk: ~azure.mgmt.compute.models.OSDisk
        :keyword data_disks: Specifies the parameters that are used to add a data disk to a virtual
         machine. For more information about disks, see `About disks and VHDs for Azure virtual machines
         <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_.
        :paramtype data_disks: list[~azure.mgmt.compute.models.DataDisk]
        :keyword disk_controller_type: Specifies the disk controller type configured for the VM.
         **Note:** This property will be set to the default disk controller type if not specified
         provided virtual machine is being created with 'hyperVGeneration' set to V2 based on the
         capabilities of the operating system disk and VM size from the the specified minimum api
         version. You need to deallocate the VM before updating its disk controller type unless you are
         updating the VM size in the VM configuration which implicitly deallocates and reallocates the
         VM. Minimum api-version: 2022-08-01. Known values are: "SCSI" and "NVMe".
        :paramtype disk_controller_type: str or ~azure.mgmt.compute.models.DiskControllerTypes
        :keyword align_regional_disks_to_vm_zone: Specifies whether the regional disks should be
         aligned/moved to the VM zone. This is applicable only for VMs with placement property set.
         Please note that this change is irreversible. Minimum api-version: 2024-11-01.
        :paramtype align_regional_disks_to_vm_zone: bool
        """
        super().__init__(**kwargs)
        self.image_reference = image_reference
        self.os_disk = os_disk
        self.data_disks = data_disks
        self.disk_controller_type = disk_controller_type
        self.align_regional_disks_to_vm_zone = align_regional_disks_to_vm_zone


class SubResourceWithColocationStatus(SubResource):
    """SubResourceWithColocationStatus.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar colocation_status: Describes colocation status of a resource in the Proximity Placement
     Group.
    :vartype colocation_status: ~azure.mgmt.compute.models.InstanceViewStatus
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "colocation_status": {"key": "colocationStatus", "type": "InstanceViewStatus"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        colocation_status: Optional["_models.InstanceViewStatus"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Id.
        :paramtype id: str
        :keyword colocation_status: Describes colocation status of a resource in the Proximity
         Placement Group.
        :paramtype colocation_status: ~azure.mgmt.compute.models.InstanceViewStatus
        """
        super().__init__(id=id, **kwargs)
        self.colocation_status = colocation_status


class SupportedCapabilities(_serialization.Model):
    """List of supported capabilities persisted on the disk resource for VM use.

    :ivar disk_controller_types: The disk controllers that an OS disk supports. If set it can be
     SCSI or SCSI, NVME or NVME, SCSI.
    :vartype disk_controller_types: str
    :ivar accelerated_network: True if the image from which the OS disk is created supports
     accelerated networking.
    :vartype accelerated_network: bool
    :ivar architecture: CPU architecture supported by an OS disk. Known values are: "x64" and
     "Arm64".
    :vartype architecture: str or ~azure.mgmt.compute.models.Architecture
    :ivar supported_security_option: Refers to the security capability of the disk supported to
     create a Trusted launch or Confidential VM. Known values are: "TrustedLaunchSupported" and
     "TrustedLaunchAndConfidentialVMSupported".
    :vartype supported_security_option: str or ~azure.mgmt.compute.models.SupportedSecurityOption
    """

    _attribute_map = {
        "disk_controller_types": {"key": "diskControllerTypes", "type": "str"},
        "accelerated_network": {"key": "acceleratedNetwork", "type": "bool"},
        "architecture": {"key": "architecture", "type": "str"},
        "supported_security_option": {"key": "supportedSecurityOption", "type": "str"},
    }

    def __init__(
        self,
        *,
        disk_controller_types: Optional[str] = None,
        accelerated_network: Optional[bool] = None,
        architecture: Optional[Union[str, "_models.Architecture"]] = None,
        supported_security_option: Optional[Union[str, "_models.SupportedSecurityOption"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword disk_controller_types: The disk controllers that an OS disk supports. If set it can be
         SCSI or SCSI, NVME or NVME, SCSI.
        :paramtype disk_controller_types: str
        :keyword accelerated_network: True if the image from which the OS disk is created supports
         accelerated networking.
        :paramtype accelerated_network: bool
        :keyword architecture: CPU architecture supported by an OS disk. Known values are: "x64" and
         "Arm64".
        :paramtype architecture: str or ~azure.mgmt.compute.models.Architecture
        :keyword supported_security_option: Refers to the security capability of the disk supported to
         create a Trusted launch or Confidential VM. Known values are: "TrustedLaunchSupported" and
         "TrustedLaunchAndConfidentialVMSupported".
        :paramtype supported_security_option: str or ~azure.mgmt.compute.models.SupportedSecurityOption
        """
        super().__init__(**kwargs)
        self.disk_controller_types = disk_controller_types
        self.accelerated_network = accelerated_network
        self.architecture = architecture
        self.supported_security_option = supported_security_option


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.compute.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.compute.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.compute.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.compute.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TargetRegion(_serialization.Model):
    """Describes the target region information.

    All required parameters must be populated in order to send to server.

    :ivar name: The name of the region. Required.
    :vartype name: str
    :ivar regional_replica_count: The number of replicas of the Image Version to be created per
     region. This property is updatable.
    :vartype regional_replica_count: int
    :ivar storage_account_type: Specifies the storage account type to be used to store the image.
     This property is not updatable. Known values are: "Standard_LRS", "Standard_ZRS",
     "Premium_LRS", and "PremiumV2_LRS".
    :vartype storage_account_type: str or ~azure.mgmt.compute.models.StorageAccountType
    :ivar encryption: Optional. Allows users to provide customer managed keys for encrypting the OS
     and data disks in the gallery artifact.
    :vartype encryption: ~azure.mgmt.compute.models.EncryptionImages
    :ivar exclude_from_latest: Contains the flag setting to hide an image when users specify
     version='latest'.
    :vartype exclude_from_latest: bool
    :ivar additional_replica_sets: List of storage sku with replica count to create direct drive
     replicas.
    :vartype additional_replica_sets: list[~azure.mgmt.compute.models.AdditionalReplicaSet]
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "regional_replica_count": {"key": "regionalReplicaCount", "type": "int"},
        "storage_account_type": {"key": "storageAccountType", "type": "str"},
        "encryption": {"key": "encryption", "type": "EncryptionImages"},
        "exclude_from_latest": {"key": "excludeFromLatest", "type": "bool"},
        "additional_replica_sets": {"key": "additionalReplicaSets", "type": "[AdditionalReplicaSet]"},
    }

    def __init__(
        self,
        *,
        name: str,
        regional_replica_count: Optional[int] = None,
        storage_account_type: Optional[Union[str, "_models.StorageAccountType"]] = None,
        encryption: Optional["_models.EncryptionImages"] = None,
        exclude_from_latest: Optional[bool] = None,
        additional_replica_sets: Optional[list["_models.AdditionalReplicaSet"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the region. Required.
        :paramtype name: str
        :keyword regional_replica_count: The number of replicas of the Image Version to be created per
         region. This property is updatable.
        :paramtype regional_replica_count: int
        :keyword storage_account_type: Specifies the storage account type to be used to store the
         image. This property is not updatable. Known values are: "Standard_LRS", "Standard_ZRS",
         "Premium_LRS", and "PremiumV2_LRS".
        :paramtype storage_account_type: str or ~azure.mgmt.compute.models.StorageAccountType
        :keyword encryption: Optional. Allows users to provide customer managed keys for encrypting the
         OS and data disks in the gallery artifact.
        :paramtype encryption: ~azure.mgmt.compute.models.EncryptionImages
        :keyword exclude_from_latest: Contains the flag setting to hide an image when users specify
         version='latest'.
        :paramtype exclude_from_latest: bool
        :keyword additional_replica_sets: List of storage sku with replica count to create direct drive
         replicas.
        :paramtype additional_replica_sets: list[~azure.mgmt.compute.models.AdditionalReplicaSet]
        """
        super().__init__(**kwargs)
        self.name = name
        self.regional_replica_count = regional_replica_count
        self.storage_account_type = storage_account_type
        self.encryption = encryption
        self.exclude_from_latest = exclude_from_latest
        self.additional_replica_sets = additional_replica_sets


class TerminateNotificationProfile(_serialization.Model):
    """TerminateNotificationProfile.

    :ivar not_before_timeout: Configurable length of time a Virtual Machine being deleted will have
     to potentially approve the Terminate Scheduled Event before the event is auto approved (timed
     out). The configuration must be specified in ISO 8601 format, the default value is 5 minutes
     (PT5M).
    :vartype not_before_timeout: str
    :ivar enable: Specifies whether the Terminate Scheduled event is enabled or disabled.
    :vartype enable: bool
    """

    _attribute_map = {
        "not_before_timeout": {"key": "notBeforeTimeout", "type": "str"},
        "enable": {"key": "enable", "type": "bool"},
    }

    def __init__(
        self, *, not_before_timeout: Optional[str] = None, enable: Optional[bool] = None, **kwargs: Any
    ) -> None:
        """
        :keyword not_before_timeout: Configurable length of time a Virtual Machine being deleted will
         have to potentially approve the Terminate Scheduled Event before the event is auto approved
         (timed out). The configuration must be specified in ISO 8601 format, the default value is 5
         minutes (PT5M).
        :paramtype not_before_timeout: str
        :keyword enable: Specifies whether the Terminate Scheduled event is enabled or disabled.
        :paramtype enable: bool
        """
        super().__init__(**kwargs)
        self.not_before_timeout = not_before_timeout
        self.enable = enable


class ThrottledRequestsInput(LogAnalyticsInputBase):
    """Api request input for LogAnalytics getThrottledRequests Api.

    All required parameters must be populated in order to send to server.

    :ivar blob_container_sas_uri: SAS Uri of the logging blob container to which LogAnalytics Api
     writes output logs to. Required.
    :vartype blob_container_sas_uri: str
    :ivar from_time: From time of the query. Required.
    :vartype from_time: ~datetime.datetime
    :ivar to_time: To time of the query. Required.
    :vartype to_time: ~datetime.datetime
    :ivar group_by_throttle_policy: Group query result by Throttle Policy applied.
    :vartype group_by_throttle_policy: bool
    :ivar group_by_operation_name: Group query result by Operation Name.
    :vartype group_by_operation_name: bool
    :ivar group_by_resource_name: Group query result by Resource Name.
    :vartype group_by_resource_name: bool
    :ivar group_by_client_application_id: Group query result by Client Application ID.
    :vartype group_by_client_application_id: bool
    :ivar group_by_user_agent: Group query result by User Agent.
    :vartype group_by_user_agent: bool
    """


class UefiKey(_serialization.Model):
    """A UEFI key signature.

    :ivar type: The type of key signature. Known values are: "sha256" and "x509".
    :vartype type: str or ~azure.mgmt.compute.models.UefiKeyType
    :ivar value: The value of the key signature.
    :vartype value: list[str]
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "value": {"key": "value", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.UefiKeyType"]] = None,
        value: Optional[list[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The type of key signature. Known values are: "sha256" and "x509".
        :paramtype type: str or ~azure.mgmt.compute.models.UefiKeyType
        :keyword value: The value of the key signature.
        :paramtype value: list[str]
        """
        super().__init__(**kwargs)
        self.type = type
        self.value = value


class UefiKeySignatures(_serialization.Model):
    """Additional UEFI key signatures that will be added to the image in addition to the signature
    templates.

    :ivar pk: The Platform Key of this image version.
    :vartype pk: ~azure.mgmt.compute.models.UefiKey
    :ivar kek: The Key Encryption Keys of this image version.
    :vartype kek: list[~azure.mgmt.compute.models.UefiKey]
    :ivar db: The database of UEFI keys for this image version.
    :vartype db: list[~azure.mgmt.compute.models.UefiKey]
    :ivar dbx: The database of revoked UEFI keys for this image version.
    :vartype dbx: list[~azure.mgmt.compute.models.UefiKey]
    """

    _attribute_map = {
        "pk": {"key": "pk", "type": "UefiKey"},
        "kek": {"key": "kek", "type": "[UefiKey]"},
        "db": {"key": "db", "type": "[UefiKey]"},
        "dbx": {"key": "dbx", "type": "[UefiKey]"},
    }

    def __init__(
        self,
        *,
        pk: Optional["_models.UefiKey"] = None,
        kek: Optional[list["_models.UefiKey"]] = None,
        db: Optional[list["_models.UefiKey"]] = None,
        dbx: Optional[list["_models.UefiKey"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword pk: The Platform Key of this image version.
        :paramtype pk: ~azure.mgmt.compute.models.UefiKey
        :keyword kek: The Key Encryption Keys of this image version.
        :paramtype kek: list[~azure.mgmt.compute.models.UefiKey]
        :keyword db: The database of UEFI keys for this image version.
        :paramtype db: list[~azure.mgmt.compute.models.UefiKey]
        :keyword dbx: The database of revoked UEFI keys for this image version.
        :paramtype dbx: list[~azure.mgmt.compute.models.UefiKey]
        """
        super().__init__(**kwargs)
        self.pk = pk
        self.kek = kek
        self.db = db
        self.dbx = dbx


class UefiSettings(_serialization.Model):
    """Specifies the security settings like secure boot and vTPM used while creating the virtual
    machine. Minimum api-version: 2020-12-01.

    :ivar secure_boot_enabled: Specifies whether secure boot should be enabled on the virtual
     machine. Minimum api-version: 2020-12-01.
    :vartype secure_boot_enabled: bool
    :ivar v_tpm_enabled: Specifies whether vTPM should be enabled on the virtual machine. Minimum
     api-version: 2020-12-01.
    :vartype v_tpm_enabled: bool
    """

    _attribute_map = {
        "secure_boot_enabled": {"key": "secureBootEnabled", "type": "bool"},
        "v_tpm_enabled": {"key": "vTpmEnabled", "type": "bool"},
    }

    def __init__(
        self, *, secure_boot_enabled: Optional[bool] = None, v_tpm_enabled: Optional[bool] = None, **kwargs: Any
    ) -> None:
        """
        :keyword secure_boot_enabled: Specifies whether secure boot should be enabled on the virtual
         machine. Minimum api-version: 2020-12-01.
        :paramtype secure_boot_enabled: bool
        :keyword v_tpm_enabled: Specifies whether vTPM should be enabled on the virtual machine.
         Minimum api-version: 2020-12-01.
        :paramtype v_tpm_enabled: bool
        """
        super().__init__(**kwargs)
        self.secure_boot_enabled = secure_boot_enabled
        self.v_tpm_enabled = v_tpm_enabled


class UpdateDomain(_serialization.Model):
    """Defines an update domain for the cloud service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None


class UpdateDomainListResult(_serialization.Model):
    """The list operation result.

    All required parameters must be populated in order to send to server.

    :ivar value: The list of resources. Required.
    :vartype value: list[~azure.mgmt.compute.models.UpdateDomain]
    :ivar next_link: The URI to fetch the next page of resources. Use this to get the next page of
     resources. Do this till nextLink is null to fetch all the resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[UpdateDomain]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: list["_models.UpdateDomain"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of resources. Required.
        :paramtype value: list[~azure.mgmt.compute.models.UpdateDomain]
        :keyword next_link: The URI to fetch the next page of resources. Use this to get the next page
         of resources. Do this till nextLink is null to fetch all the resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class UpgradeOperationHistoricalStatusInfo(_serialization.Model):
    """Virtual Machine Scale Set OS Upgrade History operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar properties: Information about the properties of the upgrade operation.
    :vartype properties: ~azure.mgmt.compute.models.UpgradeOperationHistoricalStatusInfoProperties
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    """

    _validation = {
        "properties": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
    }

    _attribute_map = {
        "properties": {"key": "properties", "type": "UpgradeOperationHistoricalStatusInfoProperties"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.properties: Optional["_models.UpgradeOperationHistoricalStatusInfoProperties"] = None
        self.type: Optional[str] = None
        self.location: Optional[str] = None


class UpgradeOperationHistoricalStatusInfoProperties(_serialization.Model):  # pylint: disable=name-too-long
    """Describes each OS upgrade on the Virtual Machine Scale Set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar running_status: Information about the overall status of the upgrade operation.
    :vartype running_status: ~azure.mgmt.compute.models.UpgradeOperationHistoryStatus
    :ivar progress: Counts of the VMs in each state.
    :vartype progress: ~azure.mgmt.compute.models.RollingUpgradeProgressInfo
    :ivar error: Error Details for this upgrade if there are any.
    :vartype error: ~azure.mgmt.compute.models.ApiError
    :ivar started_by: Invoker of the Upgrade Operation. Known values are: "Unknown", "User", and
     "Platform".
    :vartype started_by: str or ~azure.mgmt.compute.models.UpgradeOperationInvoker
    :ivar target_image_reference: Image Reference details.
    :vartype target_image_reference: ~azure.mgmt.compute.models.ImageReference
    :ivar rollback_info: Information about OS rollback if performed.
    :vartype rollback_info: ~azure.mgmt.compute.models.RollbackStatusInfo
    """

    _validation = {
        "running_status": {"readonly": True},
        "progress": {"readonly": True},
        "error": {"readonly": True},
        "started_by": {"readonly": True},
        "target_image_reference": {"readonly": True},
        "rollback_info": {"readonly": True},
    }

    _attribute_map = {
        "running_status": {"key": "runningStatus", "type": "UpgradeOperationHistoryStatus"},
        "progress": {"key": "progress", "type": "RollingUpgradeProgressInfo"},
        "error": {"key": "error", "type": "ApiError"},
        "started_by": {"key": "startedBy", "type": "str"},
        "target_image_reference": {"key": "targetImageReference", "type": "ImageReference"},
        "rollback_info": {"key": "rollbackInfo", "type": "RollbackStatusInfo"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.running_status: Optional["_models.UpgradeOperationHistoryStatus"] = None
        self.progress: Optional["_models.RollingUpgradeProgressInfo"] = None
        self.error: Optional["_models.ApiError"] = None
        self.started_by: Optional[Union[str, "_models.UpgradeOperationInvoker"]] = None
        self.target_image_reference: Optional["_models.ImageReference"] = None
        self.rollback_info: Optional["_models.RollbackStatusInfo"] = None


class UpgradeOperationHistoryStatus(_serialization.Model):
    """Information about the current running state of the overall upgrade.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Code indicating the current status of the upgrade. Known values are:
     "RollingForward", "Cancelled", "Completed", and "Faulted".
    :vartype code: str or ~azure.mgmt.compute.models.UpgradeState
    :ivar start_time: Start time of the upgrade.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the upgrade.
    :vartype end_time: ~datetime.datetime
    """

    _validation = {
        "code": {"readonly": True},
        "start_time": {"readonly": True},
        "end_time": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[Union[str, "_models.UpgradeState"]] = None
        self.start_time: Optional[datetime.datetime] = None
        self.end_time: Optional[datetime.datetime] = None


class UpgradePolicy(_serialization.Model):
    """Describes an upgrade policy - automatic, manual, or rolling.

    :ivar mode: Specifies the mode of an upgrade to virtual machines in the scale set.\\ :code:`<br
     />`\\ :code:`<br />` Possible values are:\\ :code:`<br />`\\ :code:`<br />` **Manual** - You
     control the application of updates to virtual machines in the scale set. You do this by using
     the manualUpgrade action.\\ :code:`<br />`\\ :code:`<br />` **Automatic** - All virtual
     machines in the scale set are  automatically updated at the same time. Known values are:
     "Automatic", "Manual", and "Rolling".
    :vartype mode: str or ~azure.mgmt.compute.models.UpgradeMode
    :ivar rolling_upgrade_policy: The configuration parameters used while performing a rolling
     upgrade.
    :vartype rolling_upgrade_policy: ~azure.mgmt.compute.models.RollingUpgradePolicy
    :ivar automatic_os_upgrade_policy: Configuration parameters used for performing automatic OS
     Upgrade.
    :vartype automatic_os_upgrade_policy: ~azure.mgmt.compute.models.AutomaticOSUpgradePolicy
    """

    _attribute_map = {
        "mode": {"key": "mode", "type": "str"},
        "rolling_upgrade_policy": {"key": "rollingUpgradePolicy", "type": "RollingUpgradePolicy"},
        "automatic_os_upgrade_policy": {"key": "automaticOSUpgradePolicy", "type": "AutomaticOSUpgradePolicy"},
    }

    def __init__(
        self,
        *,
        mode: Optional[Union[str, "_models.UpgradeMode"]] = None,
        rolling_upgrade_policy: Optional["_models.RollingUpgradePolicy"] = None,
        automatic_os_upgrade_policy: Optional["_models.AutomaticOSUpgradePolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword mode: Specifies the mode of an upgrade to virtual machines in the scale set.\\
         :code:`<br />`\\ :code:`<br />` Possible values are:\\ :code:`<br />`\\ :code:`<br />`
         **Manual** - You  control the application of updates to virtual machines in the scale set. You
         do this by using the manualUpgrade action.\\ :code:`<br />`\\ :code:`<br />` **Automatic** -
         All virtual machines in the scale set are  automatically updated at the same time. Known values
         are: "Automatic", "Manual", and "Rolling".
        :paramtype mode: str or ~azure.mgmt.compute.models.UpgradeMode
        :keyword rolling_upgrade_policy: The configuration parameters used while performing a rolling
         upgrade.
        :paramtype rolling_upgrade_policy: ~azure.mgmt.compute.models.RollingUpgradePolicy
        :keyword automatic_os_upgrade_policy: Configuration parameters used for performing automatic OS
         Upgrade.
        :paramtype automatic_os_upgrade_policy: ~azure.mgmt.compute.models.AutomaticOSUpgradePolicy
        """
        super().__init__(**kwargs)
        self.mode = mode
        self.rolling_upgrade_policy = rolling_upgrade_policy
        self.automatic_os_upgrade_policy = automatic_os_upgrade_policy


class Usage(_serialization.Model):
    """Describes Compute Resource Usage.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar unit: An enum describing the unit of usage measurement. Required. Default value is
     "Count".
    :vartype unit: str
    :ivar current_value: The current usage of the resource. Required.
    :vartype current_value: int
    :ivar limit: The maximum permitted usage of the resource. Required.
    :vartype limit: int
    :ivar name: The name of the type of usage. Required.
    :vartype name: ~azure.mgmt.compute.models.UsageName
    """

    _validation = {
        "unit": {"required": True, "constant": True},
        "current_value": {"required": True},
        "limit": {"required": True},
        "name": {"required": True},
    }

    _attribute_map = {
        "unit": {"key": "unit", "type": "str"},
        "current_value": {"key": "currentValue", "type": "int"},
        "limit": {"key": "limit", "type": "int"},
        "name": {"key": "name", "type": "UsageName"},
    }

    unit = "Count"

    def __init__(self, *, current_value: int, limit: int, name: "_models.UsageName", **kwargs: Any) -> None:
        """
        :keyword current_value: The current usage of the resource. Required.
        :paramtype current_value: int
        :keyword limit: The maximum permitted usage of the resource. Required.
        :paramtype limit: int
        :keyword name: The name of the type of usage. Required.
        :paramtype name: ~azure.mgmt.compute.models.UsageName
        """
        super().__init__(**kwargs)
        self.current_value = current_value
        self.limit = limit
        self.name = name


class UsageName(_serialization.Model):
    """The Usage Names.

    :ivar value: The name of the resource.
    :vartype value: str
    :ivar localized_value: The localized name of the resource.
    :vartype localized_value: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "localized_value": {"key": "localizedValue", "type": "str"},
    }

    def __init__(self, *, value: Optional[str] = None, localized_value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The name of the resource.
        :paramtype value: str
        :keyword localized_value: The localized name of the resource.
        :paramtype localized_value: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class UserArtifactManage(_serialization.Model):
    """UserArtifactManage.

    All required parameters must be populated in order to send to server.

    :ivar install: Required. The path and arguments to install the gallery application. This is
     limited to 4096 characters. Required.
    :vartype install: str
    :ivar remove: Required. The path and arguments to remove the gallery application. This is
     limited to 4096 characters. Required.
    :vartype remove: str
    :ivar update: Optional. The path and arguments to update the gallery application. If not
     present, then update operation will invoke remove command on the previous version and install
     command on the current version of the gallery application. This is limited to 4096 characters.
    :vartype update: str
    """

    _validation = {
        "install": {"required": True},
        "remove": {"required": True},
    }

    _attribute_map = {
        "install": {"key": "install", "type": "str"},
        "remove": {"key": "remove", "type": "str"},
        "update": {"key": "update", "type": "str"},
    }

    def __init__(self, *, install: str, remove: str, update: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword install: Required. The path and arguments to install the gallery application. This is
         limited to 4096 characters. Required.
        :paramtype install: str
        :keyword remove: Required. The path and arguments to remove the gallery application. This is
         limited to 4096 characters. Required.
        :paramtype remove: str
        :keyword update: Optional. The path and arguments to update the gallery application. If not
         present, then update operation will invoke remove command on the previous version and install
         command on the current version of the gallery application. This is limited to 4096 characters.
        :paramtype update: str
        """
        super().__init__(**kwargs)
        self.install = install
        self.remove = remove
        self.update = update


class UserArtifactSettings(_serialization.Model):
    """Additional settings for the VM app that contains the target package and config file name when
    it is deployed to target VM or VM scale set.

    :ivar package_file_name: Optional. The name to assign the downloaded package file on the VM.
     This is limited to 4096 characters. If not specified, the package file will be named the same
     as the Gallery Application name.
    :vartype package_file_name: str
    :ivar config_file_name: Optional. The name to assign the downloaded config file on the VM. This
     is limited to 4096 characters. If not specified, the config file will be named the Gallery
     Application name appended with "_config".
    :vartype config_file_name: str
    :ivar script_behavior_after_reboot: Optional. The action to be taken with regards to
     install/update/remove of the gallery application in the event of a reboot. Known values are:
     "None" and "Rerun".
    :vartype script_behavior_after_reboot: str or
     ~azure.mgmt.compute.models.GalleryApplicationScriptRebootBehavior
    """

    _attribute_map = {
        "package_file_name": {"key": "packageFileName", "type": "str"},
        "config_file_name": {"key": "configFileName", "type": "str"},
        "script_behavior_after_reboot": {"key": "scriptBehaviorAfterReboot", "type": "str"},
    }

    def __init__(
        self,
        *,
        package_file_name: Optional[str] = None,
        config_file_name: Optional[str] = None,
        script_behavior_after_reboot: Optional[Union[str, "_models.GalleryApplicationScriptRebootBehavior"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword package_file_name: Optional. The name to assign the downloaded package file on the VM.
         This is limited to 4096 characters. If not specified, the package file will be named the same
         as the Gallery Application name.
        :paramtype package_file_name: str
        :keyword config_file_name: Optional. The name to assign the downloaded config file on the VM.
         This is limited to 4096 characters. If not specified, the config file will be named the Gallery
         Application name appended with "_config".
        :paramtype config_file_name: str
        :keyword script_behavior_after_reboot: Optional. The action to be taken with regards to
         install/update/remove of the gallery application in the event of a reboot. Known values are:
         "None" and "Rerun".
        :paramtype script_behavior_after_reboot: str or
         ~azure.mgmt.compute.models.GalleryApplicationScriptRebootBehavior
        """
        super().__init__(**kwargs)
        self.package_file_name = package_file_name
        self.config_file_name = config_file_name
        self.script_behavior_after_reboot = script_behavior_after_reboot


class UserArtifactSource(_serialization.Model):
    """The source image from which the Image Version is going to be created.

    All required parameters must be populated in order to send to server.

    :ivar media_link: Required. The mediaLink of the artifact, must be a readable storage page
     blob. Required.
    :vartype media_link: str
    :ivar default_configuration_link: Optional. The defaultConfigurationLink of the artifact, must
     be a readable storage page blob.
    :vartype default_configuration_link: str
    """

    _validation = {
        "media_link": {"required": True},
    }

    _attribute_map = {
        "media_link": {"key": "mediaLink", "type": "str"},
        "default_configuration_link": {"key": "defaultConfigurationLink", "type": "str"},
    }

    def __init__(self, *, media_link: str, default_configuration_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword media_link: Required. The mediaLink of the artifact, must be a readable storage page
         blob. Required.
        :paramtype media_link: str
        :keyword default_configuration_link: Optional. The defaultConfigurationLink of the artifact,
         must be a readable storage page blob.
        :paramtype default_configuration_link: str
        """
        super().__init__(**kwargs)
        self.media_link = media_link
        self.default_configuration_link = default_configuration_link


class UserAssignedIdentitiesValue(_serialization.Model):
    """UserAssignedIdentitiesValue.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id: Optional[str] = None
        self.client_id: Optional[str] = None


class UserInitiatedReboot(_serialization.Model):
    """Specifies Reboot related Scheduled Event related configurations.

    :ivar automatically_approve: Specifies Reboot Scheduled Event related configurations.
    :vartype automatically_approve: bool
    """

    _attribute_map = {
        "automatically_approve": {"key": "automaticallyApprove", "type": "bool"},
    }

    def __init__(self, *, automatically_approve: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword automatically_approve: Specifies Reboot Scheduled Event related configurations.
        :paramtype automatically_approve: bool
        """
        super().__init__(**kwargs)
        self.automatically_approve = automatically_approve


class UserInitiatedRedeploy(_serialization.Model):
    """Specifies Redeploy related Scheduled Event related configurations.

    :ivar automatically_approve: Specifies Redeploy Scheduled Event related configurations.
    :vartype automatically_approve: bool
    """

    _attribute_map = {
        "automatically_approve": {"key": "automaticallyApprove", "type": "bool"},
    }

    def __init__(self, *, automatically_approve: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword automatically_approve: Specifies Redeploy Scheduled Event related configurations.
        :paramtype automatically_approve: bool
        """
        super().__init__(**kwargs)
        self.automatically_approve = automatically_approve


class ValidationsProfile(_serialization.Model):
    """This is the validations profile of a Gallery Image Version.

    :ivar validation_etag: The published time of the image version.
    :vartype validation_etag: str
    :ivar executed_validations:
    :vartype executed_validations: list[~azure.mgmt.compute.models.ExecutedValidation]
    :ivar platform_attributes: This specifies the pub, offer, sku and version of the image version
     metadata.
    :vartype platform_attributes: list[~azure.mgmt.compute.models.PlatformAttribute]
    """

    _attribute_map = {
        "validation_etag": {"key": "validationEtag", "type": "str"},
        "executed_validations": {"key": "executedValidations", "type": "[ExecutedValidation]"},
        "platform_attributes": {"key": "platformAttributes", "type": "[PlatformAttribute]"},
    }

    def __init__(
        self,
        *,
        validation_etag: Optional[str] = None,
        executed_validations: Optional[list["_models.ExecutedValidation"]] = None,
        platform_attributes: Optional[list["_models.PlatformAttribute"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword validation_etag: The published time of the image version.
        :paramtype validation_etag: str
        :keyword executed_validations:
        :paramtype executed_validations: list[~azure.mgmt.compute.models.ExecutedValidation]
        :keyword platform_attributes: This specifies the pub, offer, sku and version of the image
         version metadata.
        :paramtype platform_attributes: list[~azure.mgmt.compute.models.PlatformAttribute]
        """
        super().__init__(**kwargs)
        self.validation_etag = validation_etag
        self.executed_validations = executed_validations
        self.platform_attributes = platform_attributes


class VaultCertificate(_serialization.Model):
    """Describes a single certificate reference in a Key Vault, and where the certificate should
    reside on the VM.

    :ivar certificate_url: This is the URL of a certificate that has been uploaded to Key Vault as
     a secret. For adding a secret to the Key Vault, see `Add a key or secret to the key vault
     <https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add>`_. In this case, your
     certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded
     in UTF-8: :code:`<br>`\\ :code:`<br>` {\\ :code:`<br>`  "data":"\\
     :code:`<Base64-encoded-certificate>`",\\ :code:`<br>`  "dataType":"pfx",\\ :code:`<br>`
     "password":"\\ :code:`<pfx-file-password>`"\\ :code:`<br>`} :code:`<br>` To install
     certificates on a virtual machine it is recommended to use the `Azure Key Vault virtual machine
     extension for Linux
     <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux>`_ or the `Azure
     Key Vault virtual machine extension for Windows
     <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows>`_.
    :vartype certificate_url: str
    :ivar certificate_store: For Windows VMs, specifies the certificate store on the Virtual
     Machine to which the certificate should be added. The specified certificate store is implicitly
     in the LocalMachine account. For Linux VMs, the certificate file is placed under the
     /var/lib/waagent directory, with the file name &lt;UppercaseThumbprint&gt;.crt for the X509
     certificate file and &lt;UppercaseThumbprint&gt;.prv for private key. Both of these files are
     .pem formatted.
    :vartype certificate_store: str
    """

    _attribute_map = {
        "certificate_url": {"key": "certificateUrl", "type": "str"},
        "certificate_store": {"key": "certificateStore", "type": "str"},
    }

    def __init__(
        self, *, certificate_url: Optional[str] = None, certificate_store: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword certificate_url: This is the URL of a certificate that has been uploaded to Key Vault
         as a secret. For adding a secret to the Key Vault, see `Add a key or secret to the key vault
         <https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add>`_. In this case, your
         certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded
         in UTF-8: :code:`<br>`\\ :code:`<br>` {\\ :code:`<br>`  "data":"\\
         :code:`<Base64-encoded-certificate>`",\\ :code:`<br>`  "dataType":"pfx",\\ :code:`<br>`
         "password":"\\ :code:`<pfx-file-password>`"\\ :code:`<br>`} :code:`<br>` To install
         certificates on a virtual machine it is recommended to use the `Azure Key Vault virtual machine
         extension for Linux
         <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux>`_ or the `Azure
         Key Vault virtual machine extension for Windows
         <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows>`_.
        :paramtype certificate_url: str
        :keyword certificate_store: For Windows VMs, specifies the certificate store on the Virtual
         Machine to which the certificate should be added. The specified certificate store is implicitly
         in the LocalMachine account. For Linux VMs, the certificate file is placed under the
         /var/lib/waagent directory, with the file name &lt;UppercaseThumbprint&gt;.crt for the X509
         certificate file and &lt;UppercaseThumbprint&gt;.prv for private key. Both of these files are
         .pem formatted.
        :paramtype certificate_store: str
        """
        super().__init__(**kwargs)
        self.certificate_url = certificate_url
        self.certificate_store = certificate_store


class VaultSecretGroup(_serialization.Model):
    """Describes a set of certificates which are all in the same Key Vault.

    :ivar source_vault: The relative URL of the Key Vault containing all of the certificates in
     VaultCertificates.
    :vartype source_vault: ~azure.mgmt.compute.models.SubResource
    :ivar vault_certificates: The list of key vault references in SourceVault which contain
     certificates.
    :vartype vault_certificates: list[~azure.mgmt.compute.models.VaultCertificate]
    """

    _attribute_map = {
        "source_vault": {"key": "sourceVault", "type": "SubResource"},
        "vault_certificates": {"key": "vaultCertificates", "type": "[VaultCertificate]"},
    }

    def __init__(
        self,
        *,
        source_vault: Optional["_models.SubResource"] = None,
        vault_certificates: Optional[list["_models.VaultCertificate"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source_vault: The relative URL of the Key Vault containing all of the certificates in
         VaultCertificates.
        :paramtype source_vault: ~azure.mgmt.compute.models.SubResource
        :keyword vault_certificates: The list of key vault references in SourceVault which contain
         certificates.
        :paramtype vault_certificates: list[~azure.mgmt.compute.models.VaultCertificate]
        """
        super().__init__(**kwargs)
        self.source_vault = source_vault
        self.vault_certificates = vault_certificates


class VirtualHardDisk(_serialization.Model):
    """Describes the uri of a disk.

    :ivar uri: Specifies the virtual hard disk's uri.
    :vartype uri: str
    """

    _attribute_map = {
        "uri": {"key": "uri", "type": "str"},
    }

    def __init__(self, *, uri: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword uri: Specifies the virtual hard disk's uri.
        :paramtype uri: str
        """
        super().__init__(**kwargs)
        self.uri = uri


class VirtualMachine(TrackedResource):
    """Describes a Virtual Machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.compute.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar plan: Specifies information about the marketplace image used to create the virtual
     machine. This element is only used for marketplace images. Before you can use a marketplace
     image from an API, you must enable the image for programmatic use.  In the Azure portal, find
     the marketplace image that you want to use and then click **Want to deploy programmatically,
     Get Started ->**. Enter any required information and then click **Save**.
    :vartype plan: ~azure.mgmt.compute.models.Plan
    :ivar resources: The virtual machine child extension resources.
    :vartype resources: list[~azure.mgmt.compute.models.VirtualMachineExtension]
    :ivar identity: The identity of the virtual machine, if configured.
    :vartype identity: ~azure.mgmt.compute.models.VirtualMachineIdentity
    :ivar zones: The availability zones.
    :vartype zones: list[str]
    :ivar extended_location: The extended location of the Virtual Machine.
    :vartype extended_location: ~azure.mgmt.compute.models.ExtendedLocation
    :ivar managed_by: ManagedBy is set to Virtual Machine Scale Set(VMSS) flex ARM resourceID, if
     the VM is part of the VMSS. This property is used by platform for internal resource group
     delete optimization.
    :vartype managed_by: str
    :ivar etag: Etag is property returned in Create/Update/Get response of the VM, so that customer
     can supply it in the header to ensure optimistic updates.
    :vartype etag: str
    :ivar placement: Placement section specifies the user-defined constraints for virtual machine
     hardware placement. This property cannot be changed once VM is provisioned. Minimum
     api-version: 2024-11-01.
    :vartype placement: ~azure.mgmt.compute.models.Placement
    :ivar hardware_profile: Specifies the hardware settings for the virtual machine.
    :vartype hardware_profile: ~azure.mgmt.compute.models.HardwareProfile
    :ivar scheduled_events_policy: Specifies Redeploy, Reboot and
     ScheduledEventsAdditionalPublishingTargets Scheduled Event related configurations for the
     virtual machine.
    :vartype scheduled_events_policy: ~azure.mgmt.compute.models.ScheduledEventsPolicy
    :ivar storage_profile: Specifies the storage settings for the virtual machine disks.
    :vartype storage_profile: ~azure.mgmt.compute.models.StorageProfile
    :ivar additional_capabilities: Specifies additional capabilities enabled or disabled on the
     virtual machine.
    :vartype additional_capabilities: ~azure.mgmt.compute.models.AdditionalCapabilities
    :ivar os_profile: Specifies the operating system settings used while creating the virtual
     machine. Some of the settings cannot be changed once VM is provisioned.
    :vartype os_profile: ~azure.mgmt.compute.models.OSProfile
    :ivar network_profile: Specifies the network interfaces of the virtual machine.
    :vartype network_profile: ~azure.mgmt.compute.models.NetworkProfile
    :ivar security_profile: Specifies the Security related profile settings for the virtual
     machine.
    :vartype security_profile: ~azure.mgmt.compute.models.SecurityProfile
    :ivar diagnostics_profile: Specifies the boot diagnostic settings state. Minimum api-version:
     2015-06-15.
    :vartype diagnostics_profile: ~azure.mgmt.compute.models.DiagnosticsProfile
    :ivar availability_set: Specifies information about the availability set that the virtual
     machine should be assigned to. Virtual machines specified in the same availability set are
     allocated to different nodes to maximize availability. For more information about availability
     sets, see `Availability sets overview
     <https://docs.microsoft.com/azure/virtual-machines/availability-set-overview>`_. For more
     information on Azure planned maintenance, see `Maintenance and updates for Virtual Machines in
     Azure <https://docs.microsoft.com/azure/virtual-machines/maintenance-and-updates>`_. Currently,
     a VM can only be added to availability set at creation time. The availability set to which the
     VM is being added should be under the same resource group as the availability set resource. An
     existing VM cannot be added to an availability set. This property cannot exist along with a
     non-null properties.virtualMachineScaleSet reference.
    :vartype availability_set: ~azure.mgmt.compute.models.SubResource
    :ivar virtual_machine_scale_set: Specifies information about the virtual machine scale set that
     the virtual machine should be assigned to. Virtual machines specified in the same virtual
     machine scale set are allocated to different nodes to maximize availability. Currently, a VM
     can only be added to virtual machine scale set at creation time. An existing VM cannot be added
     to a virtual machine scale set. This property cannot exist along with a non-null
     properties.availabilitySet reference. Minimum api‐version: 2019‐03‐01.
    :vartype virtual_machine_scale_set: ~azure.mgmt.compute.models.SubResource
    :ivar proximity_placement_group: Specifies information about the proximity placement group that
     the virtual machine should be assigned to. Minimum api-version: 2018-04-01.
    :vartype proximity_placement_group: ~azure.mgmt.compute.models.SubResource
    :ivar priority: Specifies the priority for the virtual machine. Minimum api-version:
     2019-03-01. Known values are: "Regular", "Low", and "Spot".
    :vartype priority: str or ~azure.mgmt.compute.models.VirtualMachinePriorityTypes
    :ivar eviction_policy: Specifies the eviction policy for the Azure Spot virtual machine and
     Azure Spot scale set. For Azure Spot virtual machines, both 'Deallocate' and 'Delete' are
     supported and the minimum api-version is 2019-03-01. For Azure Spot scale sets, both
     'Deallocate' and 'Delete' are supported and the minimum api-version is 2017-10-30-preview.
     Known values are: "Deallocate" and "Delete".
    :vartype eviction_policy: str or ~azure.mgmt.compute.models.VirtualMachineEvictionPolicyTypes
    :ivar billing_profile: Specifies the billing related details of a Azure Spot virtual machine.
     Minimum api-version: 2019-03-01.
    :vartype billing_profile: ~azure.mgmt.compute.models.BillingProfile
    :ivar host: Specifies information about the dedicated host that the virtual machine resides in.
     Minimum api-version: 2018-10-01.
    :vartype host: ~azure.mgmt.compute.models.SubResource
    :ivar host_group: Specifies information about the dedicated host group that the virtual machine
     resides in. **Note:** User cannot specify both host and hostGroup properties. Minimum
     api-version: 2020-06-01.
    :vartype host_group: ~azure.mgmt.compute.models.SubResource
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar instance_view: The virtual machine instance view.
    :vartype instance_view: ~azure.mgmt.compute.models.VirtualMachineInstanceView
    :ivar license_type: Specifies that the image or disk that is being used was licensed
     on-premises. :code:`<br>`\\ :code:`<br>` Possible values for Windows Server operating system
     are: :code:`<br>`\\ :code:`<br>` Windows_Client :code:`<br>`\\ :code:`<br>` Windows_Server
     :code:`<br>`\\ :code:`<br>` Possible values for Linux Server operating system are:
     :code:`<br>`\\ :code:`<br>` RHEL_BYOS (for RHEL) :code:`<br>`\\ :code:`<br>` SLES_BYOS (for
     SUSE) :code:`<br>`\\ :code:`<br>` For more information, see `Azure Hybrid Use Benefit for
     Windows Server
     <https://docs.microsoft.com/azure/virtual-machines/windows/hybrid-use-benefit-licensing>`_
     :code:`<br>`\\ :code:`<br>` `Azure Hybrid Use Benefit for Linux Server
     <https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux>`_
     :code:`<br>`\\ :code:`<br>` Minimum api-version: 2015-06-15.
    :vartype license_type: str
    :ivar vm_id: Specifies the VM unique ID which is a 128-bits identifier that is encoded and
     stored in all Azure IaaS VMs SMBIOS and can be read using platform BIOS commands.
    :vartype vm_id: str
    :ivar extensions_time_budget: Specifies the time alloted for all extensions to start. The time
     duration should be between 15 minutes and 120 minutes (inclusive) and should be specified in
     ISO 8601 format. The default value is 90 minutes (PT1H30M). Minimum api-version: 2020-06-01.
    :vartype extensions_time_budget: str
    :ivar platform_fault_domain: Specifies the scale set logical fault domain into which the
     Virtual Machine will be created. By default, the Virtual Machine will by automatically assigned
     to a fault domain that best maintains balance across available fault domains. This is
     applicable only if the 'virtualMachineScaleSet' property of this Virtual Machine is set. The
     Virtual Machine Scale Set that is referenced, must have 'platformFaultDomainCount' greater than
     1. This property cannot be updated once the Virtual Machine is created. Fault domain assignment
     can be viewed in the Virtual Machine Instance View. Minimum api‐version: 2020‐12‐01.
    :vartype platform_fault_domain: int
    :ivar scheduled_events_profile: Specifies Scheduled Event related configurations.
    :vartype scheduled_events_profile: ~azure.mgmt.compute.models.ScheduledEventsProfile
    :ivar user_data: UserData for the VM, which must be base-64 encoded. Customer should not pass
     any secrets in here. Minimum api-version: 2021-03-01.
    :vartype user_data: str
    :ivar capacity_reservation: Specifies information about the capacity reservation that is used
     to allocate virtual machine. Minimum api-version: 2021-04-01.
    :vartype capacity_reservation: ~azure.mgmt.compute.models.CapacityReservationProfile
    :ivar application_profile: Specifies the gallery applications that should be made available to
     the VM/VMSS.
    :vartype application_profile: ~azure.mgmt.compute.models.ApplicationProfile
    :ivar time_created: Specifies the time at which the Virtual Machine resource was created.
     Minimum api-version: 2021-11-01.
    :vartype time_created: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "resources": {"readonly": True},
        "managed_by": {"readonly": True},
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "instance_view": {"readonly": True},
        "vm_id": {"readonly": True},
        "time_created": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "plan": {"key": "plan", "type": "Plan"},
        "resources": {"key": "resources", "type": "[VirtualMachineExtension]"},
        "identity": {"key": "identity", "type": "VirtualMachineIdentity"},
        "zones": {"key": "zones", "type": "[str]"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "managed_by": {"key": "managedBy", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "placement": {"key": "placement", "type": "Placement"},
        "hardware_profile": {"key": "properties.hardwareProfile", "type": "HardwareProfile"},
        "scheduled_events_policy": {"key": "properties.scheduledEventsPolicy", "type": "ScheduledEventsPolicy"},
        "storage_profile": {"key": "properties.storageProfile", "type": "StorageProfile"},
        "additional_capabilities": {"key": "properties.additionalCapabilities", "type": "AdditionalCapabilities"},
        "os_profile": {"key": "properties.osProfile", "type": "OSProfile"},
        "network_profile": {"key": "properties.networkProfile", "type": "NetworkProfile"},
        "security_profile": {"key": "properties.securityProfile", "type": "SecurityProfile"},
        "diagnostics_profile": {"key": "properties.diagnosticsProfile", "type": "DiagnosticsProfile"},
        "availability_set": {"key": "properties.availabilitySet", "type": "SubResource"},
        "virtual_machine_scale_set": {"key": "properties.virtualMachineScaleSet", "type": "SubResource"},
        "proximity_placement_group": {"key": "properties.proximityPlacementGroup", "type": "SubResource"},
        "priority": {"key": "properties.priority", "type": "str"},
        "eviction_policy": {"key": "properties.evictionPolicy", "type": "str"},
        "billing_profile": {"key": "properties.billingProfile", "type": "BillingProfile"},
        "host": {"key": "properties.host", "type": "SubResource"},
        "host_group": {"key": "properties.hostGroup", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "instance_view": {"key": "properties.instanceView", "type": "VirtualMachineInstanceView"},
        "license_type": {"key": "properties.licenseType", "type": "str"},
        "vm_id": {"key": "properties.vmId", "type": "str"},
        "extensions_time_budget": {"key": "properties.extensionsTimeBudget", "type": "str"},
        "platform_fault_domain": {"key": "properties.platformFaultDomain", "type": "int"},
        "scheduled_events_profile": {"key": "properties.scheduledEventsProfile", "type": "ScheduledEventsProfile"},
        "user_data": {"key": "properties.userData", "type": "str"},
        "capacity_reservation": {"key": "properties.capacityReservation", "type": "CapacityReservationProfile"},
        "application_profile": {"key": "properties.applicationProfile", "type": "ApplicationProfile"},
        "time_created": {"key": "properties.timeCreated", "type": "iso-8601"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        plan: Optional["_models.Plan"] = None,
        identity: Optional["_models.VirtualMachineIdentity"] = None,
        zones: Optional[list[str]] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        placement: Optional["_models.Placement"] = None,
        hardware_profile: Optional["_models.HardwareProfile"] = None,
        scheduled_events_policy: Optional["_models.ScheduledEventsPolicy"] = None,
        storage_profile: Optional["_models.StorageProfile"] = None,
        additional_capabilities: Optional["_models.AdditionalCapabilities"] = None,
        os_profile: Optional["_models.OSProfile"] = None,
        network_profile: Optional["_models.NetworkProfile"] = None,
        security_profile: Optional["_models.SecurityProfile"] = None,
        diagnostics_profile: Optional["_models.DiagnosticsProfile"] = None,
        availability_set: Optional["_models.SubResource"] = None,
        virtual_machine_scale_set: Optional["_models.SubResource"] = None,
        proximity_placement_group: Optional["_models.SubResource"] = None,
        priority: Optional[Union[str, "_models.VirtualMachinePriorityTypes"]] = None,
        eviction_policy: Optional[Union[str, "_models.VirtualMachineEvictionPolicyTypes"]] = None,
        billing_profile: Optional["_models.BillingProfile"] = None,
        host: Optional["_models.SubResource"] = None,
        host_group: Optional["_models.SubResource"] = None,
        license_type: Optional[str] = None,
        extensions_time_budget: Optional[str] = None,
        platform_fault_domain: Optional[int] = None,
        scheduled_events_profile: Optional["_models.ScheduledEventsProfile"] = None,
        user_data: Optional[str] = None,
        capacity_reservation: Optional["_models.CapacityReservationProfile"] = None,
        application_profile: Optional["_models.ApplicationProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword plan: Specifies information about the marketplace image used to create the virtual
         machine. This element is only used for marketplace images. Before you can use a marketplace
         image from an API, you must enable the image for programmatic use.  In the Azure portal, find
         the marketplace image that you want to use and then click **Want to deploy programmatically,
         Get Started ->**. Enter any required information and then click **Save**.
        :paramtype plan: ~azure.mgmt.compute.models.Plan
        :keyword identity: The identity of the virtual machine, if configured.
        :paramtype identity: ~azure.mgmt.compute.models.VirtualMachineIdentity
        :keyword zones: The availability zones.
        :paramtype zones: list[str]
        :keyword extended_location: The extended location of the Virtual Machine.
        :paramtype extended_location: ~azure.mgmt.compute.models.ExtendedLocation
        :keyword placement: Placement section specifies the user-defined constraints for virtual
         machine hardware placement. This property cannot be changed once VM is provisioned. Minimum
         api-version: 2024-11-01.
        :paramtype placement: ~azure.mgmt.compute.models.Placement
        :keyword hardware_profile: Specifies the hardware settings for the virtual machine.
        :paramtype hardware_profile: ~azure.mgmt.compute.models.HardwareProfile
        :keyword scheduled_events_policy: Specifies Redeploy, Reboot and
         ScheduledEventsAdditionalPublishingTargets Scheduled Event related configurations for the
         virtual machine.
        :paramtype scheduled_events_policy: ~azure.mgmt.compute.models.ScheduledEventsPolicy
        :keyword storage_profile: Specifies the storage settings for the virtual machine disks.
        :paramtype storage_profile: ~azure.mgmt.compute.models.StorageProfile
        :keyword additional_capabilities: Specifies additional capabilities enabled or disabled on the
         virtual machine.
        :paramtype additional_capabilities: ~azure.mgmt.compute.models.AdditionalCapabilities
        :keyword os_profile: Specifies the operating system settings used while creating the virtual
         machine. Some of the settings cannot be changed once VM is provisioned.
        :paramtype os_profile: ~azure.mgmt.compute.models.OSProfile
        :keyword network_profile: Specifies the network interfaces of the virtual machine.
        :paramtype network_profile: ~azure.mgmt.compute.models.NetworkProfile
        :keyword security_profile: Specifies the Security related profile settings for the virtual
         machine.
        :paramtype security_profile: ~azure.mgmt.compute.models.SecurityProfile
        :keyword diagnostics_profile: Specifies the boot diagnostic settings state. Minimum
         api-version: 2015-06-15.
        :paramtype diagnostics_profile: ~azure.mgmt.compute.models.DiagnosticsProfile
        :keyword availability_set: Specifies information about the availability set that the virtual
         machine should be assigned to. Virtual machines specified in the same availability set are
         allocated to different nodes to maximize availability. For more information about availability
         sets, see `Availability sets overview
         <https://docs.microsoft.com/azure/virtual-machines/availability-set-overview>`_. For more
         information on Azure planned maintenance, see `Maintenance and updates for Virtual Machines in
         Azure <https://docs.microsoft.com/azure/virtual-machines/maintenance-and-updates>`_. Currently,
         a VM can only be added to availability set at creation time. The availability set to which the
         VM is being added should be under the same resource group as the availability set resource. An
         existing VM cannot be added to an availability set. This property cannot exist along with a
         non-null properties.virtualMachineScaleSet reference.
        :paramtype availability_set: ~azure.mgmt.compute.models.SubResource
        :keyword virtual_machine_scale_set: Specifies information about the virtual machine scale set
         that the virtual machine should be assigned to. Virtual machines specified in the same virtual
         machine scale set are allocated to different nodes to maximize availability. Currently, a VM
         can only be added to virtual machine scale set at creation time. An existing VM cannot be added
         to a virtual machine scale set. This property cannot exist along with a non-null
         properties.availabilitySet reference. Minimum api‐version: 2019‐03‐01.
        :paramtype virtual_machine_scale_set: ~azure.mgmt.compute.models.SubResource
        :keyword proximity_placement_group: Specifies information about the proximity placement group
         that the virtual machine should be assigned to. Minimum api-version: 2018-04-01.
        :paramtype proximity_placement_group: ~azure.mgmt.compute.models.SubResource
        :keyword priority: Specifies the priority for the virtual machine. Minimum api-version:
         2019-03-01. Known values are: "Regular", "Low", and "Spot".
        :paramtype priority: str or ~azure.mgmt.compute.models.VirtualMachinePriorityTypes
        :keyword eviction_policy: Specifies the eviction policy for the Azure Spot virtual machine and
         Azure Spot scale set. For Azure Spot virtual machines, both 'Deallocate' and 'Delete' are
         supported and the minimum api-version is 2019-03-01. For Azure Spot scale sets, both
         'Deallocate' and 'Delete' are supported and the minimum api-version is 2017-10-30-preview.
         Known values are: "Deallocate" and "Delete".
        :paramtype eviction_policy: str or ~azure.mgmt.compute.models.VirtualMachineEvictionPolicyTypes
        :keyword billing_profile: Specifies the billing related details of a Azure Spot virtual
         machine. Minimum api-version: 2019-03-01.
        :paramtype billing_profile: ~azure.mgmt.compute.models.BillingProfile
        :keyword host: Specifies information about the dedicated host that the virtual machine resides
         in. Minimum api-version: 2018-10-01.
        :paramtype host: ~azure.mgmt.compute.models.SubResource
        :keyword host_group: Specifies information about the dedicated host group that the virtual
         machine resides in. **Note:** User cannot specify both host and hostGroup properties. Minimum
         api-version: 2020-06-01.
        :paramtype host_group: ~azure.mgmt.compute.models.SubResource
        :keyword license_type: Specifies that the image or disk that is being used was licensed
         on-premises. :code:`<br>`\\ :code:`<br>` Possible values for Windows Server operating system
         are: :code:`<br>`\\ :code:`<br>` Windows_Client :code:`<br>`\\ :code:`<br>` Windows_Server
         :code:`<br>`\\ :code:`<br>` Possible values for Linux Server operating system are:
         :code:`<br>`\\ :code:`<br>` RHEL_BYOS (for RHEL) :code:`<br>`\\ :code:`<br>` SLES_BYOS (for
         SUSE) :code:`<br>`\\ :code:`<br>` For more information, see `Azure Hybrid Use Benefit for
         Windows Server
         <https://docs.microsoft.com/azure/virtual-machines/windows/hybrid-use-benefit-licensing>`_
         :code:`<br>`\\ :code:`<br>` `Azure Hybrid Use Benefit for Linux Server
         <https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux>`_
         :code:`<br>`\\ :code:`<br>` Minimum api-version: 2015-06-15.
        :paramtype license_type: str
        :keyword extensions_time_budget: Specifies the time alloted for all extensions to start. The
         time duration should be between 15 minutes and 120 minutes (inclusive) and should be specified
         in ISO 8601 format. The default value is 90 minutes (PT1H30M). Minimum api-version: 2020-06-01.
        :paramtype extensions_time_budget: str
        :keyword platform_fault_domain: Specifies the scale set logical fault domain into which the
         Virtual Machine will be created. By default, the Virtual Machine will by automatically assigned
         to a fault domain that best maintains balance across available fault domains. This is
         applicable only if the 'virtualMachineScaleSet' property of this Virtual Machine is set. The
         Virtual Machine Scale Set that is referenced, must have 'platformFaultDomainCount' greater than
         1. This property cannot be updated once the Virtual Machine is created. Fault domain assignment
         can be viewed in the Virtual Machine Instance View. Minimum api‐version: 2020‐12‐01.
        :paramtype platform_fault_domain: int
        :keyword scheduled_events_profile: Specifies Scheduled Event related configurations.
        :paramtype scheduled_events_profile: ~azure.mgmt.compute.models.ScheduledEventsProfile
        :keyword user_data: UserData for the VM, which must be base-64 encoded. Customer should not
         pass any secrets in here. Minimum api-version: 2021-03-01.
        :paramtype user_data: str
        :keyword capacity_reservation: Specifies information about the capacity reservation that is
         used to allocate virtual machine. Minimum api-version: 2021-04-01.
        :paramtype capacity_reservation: ~azure.mgmt.compute.models.CapacityReservationProfile
        :keyword application_profile: Specifies the gallery applications that should be made available
         to the VM/VMSS.
        :paramtype application_profile: ~azure.mgmt.compute.models.ApplicationProfile
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.plan = plan
        self.resources: Optional[list["_models.VirtualMachineExtension"]] = None
        self.identity = identity
        self.zones = zones
        self.extended_location = extended_location
        self.managed_by: Optional[str] = None
        self.etag: Optional[str] = None
        self.placement = placement
        self.hardware_profile = hardware_profile
        self.scheduled_events_policy = scheduled_events_policy
        self.storage_profile = storage_profile
        self.additional_capabilities = additional_capabilities
        self.os_profile = 