% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/continuous-gsea.R
\name{scale_color_gsea}
\alias{scale_color_gsea}
\alias{scale_colour_gsea}
\alias{scale_fill_gsea}
\title{The GSEA GenePattern color scales}
\usage{
scale_color_gsea(palette = c("default"), alpha = 1, reverse = FALSE, ...)

scale_colour_gsea(palette = c("default"), alpha = 1, reverse = FALSE, ...)

scale_fill_gsea(palette = c("default"), alpha = 1, reverse = FALSE, ...)
}
\arguments{
\item{palette}{Palette type.
Currently there is one available option: \code{"default"}
(continuous palette with 12 base colors).}

\item{alpha}{Transparency level, a real number in (0, 1].
See \code{alpha} in \code{\link[grDevices:rgb]{grDevices::rgb()}} for details.}

\item{reverse}{Logical. Should the order of the colors be reversed?}

\item{...}{Additional parameters for \code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale()}}.}
}
\description{
See \code{\link[=pal_gsea]{pal_gsea()}} for details.
}
\examples{
library("ggplot2")

data("mtcars")
cor <- cor(mtcars)
cor_melt <- data.frame(
  Var1 = rep(seq_len(nrow(cor)), times = ncol(cor)),
  Var2 = rep(seq_len(ncol(cor)), each = nrow(cor)),
  value = as.vector(cor)
)

ggplot(
  cor_melt,
  aes(x = Var1, y = Var2, fill = value)
) +
  geom_tile(colour = "black", size = 0.3) +
  theme_bw() +
  scale_fill_gsea()
}
\author{
Nan Xiao | \email{me@nanx.me} | \url{https://nanx.me}
}
