% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survest.orm.r
\name{survest.orm}
\alias{survest.orm}
\title{Title survest.orm}
\usage{
\method{survest}{orm}(
  fit,
  newdata = NULL,
  linear.predictors = NULL,
  x = NULL,
  times = NULL,
  fun,
  loglog = FALSE,
  conf.int = 0.95,
  what = c("survival", "parallel"),
  ...
)
}
\arguments{
\item{fit}{result of \code{orm}}

\item{newdata}{data frame defining covariate settings}

\item{linear.predictors}{linear predictor vector using the reference intercept}

\item{x}{design matrix}

\item{times}{times for which estimates are desired; defaults to estimating probabilities of T > t for all uncensored times}

\item{fun}{optional transformation of survival probabilities}

\item{loglog}{set to \code{TRUE} to use the log-log transformatino}

\item{conf.int}{a number between 0-1 with the default of 0.95; set to 0 to not compute CLs}

\item{what}{specify \code{what='parallel'} to compute the survival probability at the observed linear predictor and time values, both varying; all possible combinations of these are then not created}

\item{...}{ignored}
}
\value{
a data frame with variables \verb{time, surv}.  If \code{conf.int > 0} the data also contains \verb{lower, upper}.  The variable \code{Xrow} indicates the row of the design matrix or the linear predictor element used in getting the current data frame row estimate.
}
\description{
Title survest.orm
}
\examples{
# See survest.psm
}
\author{
Frank Harrell
}
