// -*- C++ -*-
#include "Rivet/Analysis.hh"
#include "Rivet/Projections/FinalState.hh"


namespace Rivet {


  /// @brief e+ e- > K+K-, KS0 KL0 and pi+pi-pi0
  class SND_2001_I533574 : public Analysis {
  public:

    /// Constructor
    RIVET_DEFAULT_ANALYSIS_CTOR(SND_2001_I533574);


    /// @name Analysis methods
    /// @{

    /// Book histograms and initialise projections before the run
    void init() {

      // Initialise and register projections
      declare(FinalState(), "FS");
      for (size_t ix=0; ix<2; ++ix) {
        for (size_t iy=0; iy<4; ++iy) {
          book(_sigma[ix][iy], 1+ix, 1, 1+iy);
        }
        for (const string& en : _sigma[ix][3].binning().edges<0>()) {
          double eval = stod(en)*MeV;
          if (isCompatibleWithSqrtS(eval)) {
            _sqs[ix] = en; break;
          }
        }
      }
      raiseBeamErrorIf(_sqs[0].empty() && _sqs[1].empty());
    }


    /// Perform the per-event analysis
    void analyze(const Event& event) {
      const FinalState& fs = apply<FinalState>(event, "FS");

      map<long,int> nCount;
      int ntotal(0);
      for (const Particle& p : fs.particles()) {
        nCount[p.pid()] += 1;
        ++ntotal;
      }
      if (ntotal==2) {
        if (nCount[321]==1 && nCount[-321]==1) {
          _sigma[0][0]->fill(_sqs[0]);
          _sigma[1][0]->fill(_sqs[1]);
        }
        else if (nCount[130]==1 && nCount[310]==1) {
          _sigma[0][1]->fill(_sqs[0]);
          _sigma[0][2]->fill(_sqs[0]);
          _sigma[1][1]->fill(_sqs[1]);
          _sigma[1][2]->fill(_sqs[1]);
        }
      }
      else if (ntotal==3 && nCount[211] == 1 && nCount[-211] == 1 && nCount[111] == 1) {
        _sigma[0][3]->fill(_sqs[0]);
        _sigma[1][3]->fill(_sqs[1]);
      }

    }


    /// Normalise histograms etc., after the run
    void finalize() {
      const double fact = crossSection()/sumOfWeights()/nanobarn;
      scale(_sigma[0], fact);
      scale(_sigma[1], fact);
    }

    /// @}


    /// @name Histograms
    /// @{
    BinnedHistoPtr<string> _sigma[2][4];
    string _sqs[2];
    /// @}


  };


  RIVET_DECLARE_PLUGIN(SND_2001_I533574);
}
