// -*- C++ -*-
#include "Rivet/Analysis.hh"
#include "Rivet/Projections/ChargedFinalState.hh"

namespace Rivet {


  /// @brief Add a short analysis description here
  class JADE_1979_I142874 : public Analysis {
  public:

    /// Constructor
    RIVET_DEFAULT_ANALYSIS_CTOR(JADE_1979_I142874);


    /// @name Analysis methods
    /// @{

    /// Book histograms and initialise projections before the run
    void init() {

      // Initialise and register projections
      declare(ChargedFinalState(), "FS");
      book(_mult, 2, 1, 1);
      for (const string& en : _mult.binning().edges<0>()) {
        const double eval = stod(en)*GeV;
        if (isCompatibleWithSqrtS(eval)) {
          _sqs = en; break;
        }
      }
      raiseBeamErrorIf(_sqs.empty());
    }


    /// Perform the per-event analysis
    void analyze(const Event& event) {
      const ChargedFinalState& fs = apply<ChargedFinalState>(event, "FS");
      _mult->fill(_sqs, fs.particles().size());
    }

    /// @}


    /// @name Histograms
    /// @{
    BinnedProfilePtr<string> _mult;
    string _sqs = "";
    /// @}


  };


  RIVET_DECLARE_PLUGIN(JADE_1979_I142874);
}
