/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.functions.DocumentFn;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.lib.CollectionURIResolver;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.value.AnyURIValue;

public class Collection
extends SystemFunctionCall
implements Callable {
    public static String EMPTY_COLLECTION = "http://saxon.sf.net/collection/empty";
    private String expressionBaseURI = null;

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        if (this.expressionBaseURI == null) {
            super.checkArguments(visitor);
            this.expressionBaseURI = visitor.getStaticContext().getBaseURI();
        }
    }

    public int computeSpecialProperties() {
        return super.computeSpecialProperties() & 0xFFBFFFFF | 0x80000;
    }

    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        return this.addDocToPathMap(pathMap, pathMapNodeSet);
    }

    public Expression copy() {
        Collection c2 = (Collection)super.copy();
        c2.expressionBaseURI = this.expressionBaseURI;
        return c2;
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        SequenceIterator iter;
        Item arg;
        String href = this.getNumberOfArguments() == 0 ? context.getController().getDefaultCollection() : ((arg = this.argument[0].evaluateItem(context)) == null ? context.getController().getDefaultCollection() : arg.getStringValue());
        if (EMPTY_COLLECTION.equals(href)) {
            return EmptyIterator.emptyIterator();
        }
        CollectionURIResolver resolver = context.getConfiguration().getCollectionURIResolver();
        try {
            iter = resolver.resolve(href, this.expressionBaseURI, context);
        }
        catch (XPathException e) {
            e.setLocator(this);
            if (e.getErrorCodeQName() == null) {
                e.setErrorCode("FODC0002");
            }
            throw e;
        }
        return Collection.getResolverResults(iter, this.expressionBaseURI, context, this);
    }

    public static SequenceIterator getResolverResults(SequenceIterator iter, final String baseURI, final XPathContext context, final SourceLocator locator) {
        if (iter == null) {
            return EmptyIterator.emptyIterator();
        }
        ItemMappingFunction<Item, NodeInfo> imf = new ItemMappingFunction<Item, NodeInfo>(){

            @Override
            public NodeInfo mapItem(Item item) throws XPathException {
                if (item instanceof NodeInfo) {
                    return (NodeInfo)item;
                }
                if (item instanceof AnyURIValue) {
                    return DocumentFn.makeDoc(item.getStringValue(), baseURI, context, locator, false);
                }
                if (item instanceof Source) {
                    return context.getConfiguration().buildDocument((Source)((Object)item));
                }
                throw new XPathException("Value returned by CollectionURIResolver must be a Source or an anyURI");
            }
        };
        return new ItemMappingIterator<Item, NodeInfo>(iter, imf);
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        SequenceIterator iter;
        Item arg;
        String href = this.getNumberOfArguments() == 0 ? context.getConfiguration().getDefaultCollection() : ((arg = arguments[0].head()) == null ? context.getConfiguration().getDefaultCollection() : arg.getStringValue());
        CollectionURIResolver resolver = context.getConfiguration().getCollectionURIResolver();
        try {
            iter = resolver.resolve(href, this.expressionBaseURI, context);
        }
        catch (XPathException e) {
            e.setLocator(this);
            throw e;
        }
        return SequenceTool.toLazySequence(Collection.getResolverResults(iter, this.expressionBaseURI, context, this));
    }
}

