//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_class!(
    /// An object that can render an image from encapsulated PostScript (EPS) code.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nsepsimagerep?language=objc)
    #[unsafe(super(NSImageRep, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(feature = "NSImageRep")]
    #[deprecated = "`NSEPSImageRep` instances cannot be created on macOS 14.0 and later"]
    pub struct NSEPSImageRep;
);

#[cfg(feature = "NSImageRep")]
extern_conformance!(
    unsafe impl NSCoding for NSEPSImageRep {}
);

#[cfg(feature = "NSImageRep")]
extern_conformance!(
    unsafe impl NSCopying for NSEPSImageRep {}
);

#[cfg(feature = "NSImageRep")]
unsafe impl CopyingHelper for NSEPSImageRep {
    type Result = Self;
}

#[cfg(feature = "NSImageRep")]
extern_conformance!(
    unsafe impl NSObjectProtocol for NSEPSImageRep {}
);

#[cfg(feature = "NSImageRep")]
impl NSEPSImageRep {
    extern_methods!(
        /// Creates and returns a representation of an image initialized with the specified EPS data. Convenience of `-initWithData:`.
        /// - Note: This method always returns `nil` on macOS 14.0 and later.
        #[unsafe(method(imageRepWithData:))]
        #[unsafe(method_family = none)]
        pub fn imageRepWithData(eps_data: &NSData) -> Option<Retained<Self>>;

        /// Returns a representation of an image initialized with the specified EPS data.
        /// - Note: This method always returns `nil` on macOS 14.0 and later.
        #[unsafe(method(initWithData:))]
        #[unsafe(method_family = init)]
        pub fn initWithData(this: Allocated<Self>, eps_data: &NSData) -> Option<Retained<Self>>;

        /// The rectangle that bounds the image representation.
        #[unsafe(method(boundingBox))]
        #[unsafe(method_family = none)]
        pub fn boundingBox(&self) -> NSRect;

        /// The EPS representation of the image representation.
        #[unsafe(method(EPSRepresentation))]
        #[unsafe(method_family = none)]
        pub fn EPSRepresentation(&self) -> Retained<NSData>;

        /// The `-[NSEPSImageRep draw]` method sends this message to itself just before rendering the EPS code. The default implementation of this method does nothing. It can be overridden in a subclass to prepare the graphics state as needed.
        #[deprecated]
        #[unsafe(method(prepareGState))]
        #[unsafe(method_family = none)]
        pub fn prepareGState(&self);
    );
}

/// Methods declared on superclass `NSImageRep`.
#[cfg(feature = "NSImageRep")]
impl NSEPSImageRep {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(feature = "NSImageRep")]
impl NSEPSImageRep {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new() -> Retained<Self>;
    );
}

#[cfg(feature = "NSImageRep")]
impl DefaultRetained for NSEPSImageRep {
    #[inline]
    fn default_retained() -> Retained<Self> {
        Self::new()
    }
}
