/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// CreateAuthMethodOIDC createAuthMethodOIDC is a command that creates a new auth method that will be available to authenticate using OIDC. [Deprecated: Use auth-method-create-oidc command]
type CreateAuthMethodOIDC struct {
	// Access expiration date in Unix timestamp (select 0 for access without expiry date)
	AccessExpires *int64 `json:"access-expires,omitempty"`
	// Allowed redirect URIs after the authentication
	AllowedRedirectUri *[]string `json:"allowed-redirect-uri,omitempty"`
	// Audience claim to be used as part of the authentication flow. In case set, it must match the one configured on the Identity Provider's Application
	Audience *string `json:"audience,omitempty"`
	// Subclaims to include in audit logs, e.g \"--audit-logs-claims email --audit-logs-claims username\"
	AuditLogsClaims *[]string `json:"audit-logs-claims,omitempty"`
	// A CIDR whitelist with the IPs that the access is restricted to
	BoundIps *[]string `json:"bound-ips,omitempty"`
	// Client ID
	ClientId *string `json:"client-id,omitempty"`
	// Client Secret
	ClientSecret *string `json:"client-secret,omitempty"`
	// Protection from accidental deletion of this object [true/false]
	DeleteProtection *string `json:"delete_protection,omitempty"`
	// Auth Method description
	Description *string `json:"description,omitempty"`
	// if true: enforce role-association must include sub claims
	ForceSubClaims *bool `json:"force-sub-claims,omitempty"`
	// A CIDR whitelist with the GW IPs that the access is restricted to
	GwBoundIps *[]string `json:"gw-bound-ips,omitempty"`
	// Issuer URL
	Issuer *string `json:"issuer,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Jwt TTL
	JwtTtl *int64 `json:"jwt-ttl,omitempty"`
	// Auth Method name
	Name string `json:"name"`
	// Choose the relevant product type for the auth method [sm, sra, pm, dp, ca]
	ProductType *[]string `json:"product-type,omitempty"`
	// RequiredScopes is a list of required scopes that the oidc method will request from the oidc provider and the user must approve
	RequiredScopes *[]string `json:"required-scopes,omitempty"`
	// RequiredScopesPrefix is a a prefix to add to all required-scopes when requesting them from the oidc server (for example, azures' Application ID URI)
	RequiredScopesPrefix *string `json:"required-scopes-prefix,omitempty"`
	// A list of additional sub claims delimiters (relevant only for SAML, OIDC, OAuth2/JWT)
	SubclaimsDelimiters *[]string `json:"subclaims-delimiters,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
	// A unique identifier (ID) value should be configured for OIDC, OAuth2, LDAP and SAML authentication method types and is usually a value such as the email, username, or upn for example. Whenever a user logs in with a token, these authentication types issue a \"sub claim\" that contains details uniquely identifying that user. This sub claim includes a key containing the ID value that you configured, and is used to distinguish between different users from within the same organization.
	UniqueIdentifier string `json:"unique-identifier"`
}

// NewCreateAuthMethodOIDC instantiates a new CreateAuthMethodOIDC object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewCreateAuthMethodOIDC(name string, uniqueIdentifier string, ) *CreateAuthMethodOIDC {
	this := CreateAuthMethodOIDC{}
	var accessExpires int64 = 0
	this.AccessExpires = &accessExpires
	var json bool = false
	this.Json = &json
	var jwtTtl int64 = 0
	this.JwtTtl = &jwtTtl
	this.Name = name
	this.UniqueIdentifier = uniqueIdentifier
	return &this
}

// NewCreateAuthMethodOIDCWithDefaults instantiates a new CreateAuthMethodOIDC object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewCreateAuthMethodOIDCWithDefaults() *CreateAuthMethodOIDC {
	this := CreateAuthMethodOIDC{}
	var accessExpires int64 = 0
	this.AccessExpires = &accessExpires
	var json bool = false
	this.Json = &json
	var jwtTtl int64 = 0
	this.JwtTtl = &jwtTtl
	return &this
}

// GetAccessExpires returns the AccessExpires field value if set, zero value otherwise.
func (o *CreateAuthMethodOIDC) GetAccessExpires() int64 {
	if o == nil || o.AccessExpires == nil {
		var ret int64
		return ret
	}
	return *o.AccessExpires
}

// GetAccessExpiresOk returns a tuple with the AccessExpires field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodOIDC) GetAccessExpiresOk() (*int64, bool) {
	if o == nil || o.AccessExpires == nil {
		return nil, false
	}
	return o.AccessExpires, true
}

// HasAccessExpires returns a boolean if a field has been set.
func (o *CreateAuthMethodOIDC) HasAccessExpires() bool {
	if o != nil && o.AccessExpires != nil {
		return true
	}

	return false
}

// SetAccessExpires gets a reference to the given int64 and assigns it to the AccessExpires field.
func (o *CreateAuthMethodOIDC) SetAccessExpires(v int64) {
	o.AccessExpires = &v
}

// GetAllowedRedirectUri returns the AllowedRedirectUri field value if set, zero value otherwise.
func (o *CreateAuthMethodOIDC) GetAllowedRedirectUri() []string {
	if o == nil || o.AllowedRedirectUri == nil {
		var ret []string
		return ret
	}
	return *o.AllowedRedirectUri
}

// GetAllowedRedirectUriOk returns a tuple with the AllowedRedirectUri field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodOIDC) GetAllowedRedirectUriOk() (*[]string, bool) {
	if o == nil || o.AllowedRedirectUri == nil {
		return nil, false
	}
	return o.AllowedRedirectUri, true
}

// HasAllowedRedirectUri returns a boolean if a field has been set.
func (o *CreateAuthMethodOIDC) HasAllowedRedirectUri() bool {
	if o != nil && o.AllowedRedirectUri != nil {
		return true
	}

	return false
}

// SetAllowedRedirectUri gets a reference to the given []string and assigns it to the AllowedRedirectUri field.
func (o *CreateAuthMethodOIDC) SetAllowedRedirectUri(v []string) {
	o.AllowedRedirectUri = &v
}

// GetAudience returns the Audience field value if set, zero value otherwise.
func (o *CreateAuthMethodOIDC) GetAudience() string {
	if o == nil || o.Audience == nil {
		var ret string
		return ret
	}
	return *o.Audience
}

// GetAudienceOk returns a tuple with the Audience field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodOIDC) GetAudienceOk() (*string, bool) {
	if o == nil || o.Audience == nil {
		return nil, false
	}
	return o.Audience, true
}

// HasAudience returns a boolean if a field has been set.
func (o *CreateAuthMethodOIDC) HasAudience() bool {
	if o != nil && o.Audience != nil {
		return true
	}

	return false
}

// SetAudience gets a reference to the given string and assigns it to the Audience field.
func (o *CreateAuthMethodOIDC) SetAudience(v string) {
	o.Audience = &v
}

// GetAuditLogsClaims returns the AuditLogsClaims field value if set, zero value otherwise.
func (o *CreateAuthMethodOIDC) GetAuditLogsClaims() []string {
	if o == nil || o.AuditLogsClaims == nil {
		var ret []string
		return ret
	}
	return *o.AuditLogsClaims
}

// GetAuditLogsClaimsOk returns a tuple with the AuditLogsClaims field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodOIDC) GetAuditLogsClaimsOk() (*[]string, bool) {
	if o == nil || o.AuditLogsClaims == nil {
		return nil, false
	}
	return o.AuditLogsClaims, true
}

// HasAuditLogsClaims returns a boolean if a field has been set.
func (o *CreateAuthMethodOIDC) HasAuditLogsClaims() bool {
	if o != nil && o.AuditLogsClaims != nil {
		return true
	}

	return false
}

// SetAuditLogsClaims gets a reference to the given []string and assigns it to the AuditLogsClaims field.
func (o *CreateAuthMethodOIDC) SetAuditLogsClaims(v []string) {
	o.AuditLogsClaims = &v
}

// GetBoundIps returns the BoundIps field value if set, zero value otherwise.
func (o *CreateAuthMethodOIDC) GetBoundIps() []string {
	if o == nil || o.BoundIps == nil {
		var ret []string
		return ret
	}
	return *o.BoundIps
}

// GetBoundIpsOk returns a tuple with the BoundIps field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodOIDC) GetBoundIpsOk() (*[]string, bool) {
	if o == nil || o.BoundIps == nil {
		return nil, false
	}
	return o.BoundIps, true
}

// HasBoundIps returns a boolean if a field has been set.
func (o *CreateAuthMethodOIDC) HasBoundIps() bool {
	if o != nil && o.BoundIps != nil {
		return true
	}

	return false
}

// SetBoundIps gets a reference to the given []string and assigns it to the BoundIps field.
func (o *CreateAuthMethodOIDC) SetBoundIps(v []string) {
	o.BoundIps = &v
}

// GetClientId returns the ClientId field value if set, zero value otherwise.
func (o *CreateAuthMethodOIDC) GetClientId() string {
	if o == nil || o.ClientId == nil {
		var ret string
		return ret
	}
	return *o.ClientId
}

// GetClientIdOk returns a tuple with the ClientId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodOIDC) GetClientIdOk() (*string, bool) {
	if o == nil || o.ClientId == nil {
		return nil, false
	}
	return o.ClientId, true
}

// HasClientId returns a boolean if a field has been set.
func (o *CreateAuthMethodOIDC) HasClientId() bool {
	if o != nil && o.ClientId != nil {
		return true
	}

	return false
}

// SetClientId gets a reference to the given string and assigns it to the ClientId field.
func (o *CreateAuthMethodOIDC) SetClientId(v string) {
	o.ClientId = &v
}

// GetClientSecret returns the ClientSecret field value if set, zero value otherwise.
func (o *CreateAuthMethodOIDC) GetClientSecret() string {
	if o == nil || o.ClientSecret == nil {
		var ret string
		return ret
	}
	return *o.ClientSecret
}

// GetClientSecretOk returns a tuple with the ClientSecret field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodOIDC) GetClientSecretOk() (*string, bool) {
	if o == nil || o.ClientSecret == nil {
		return nil, false
	}
	return o.ClientSecret, true
}

// HasClientSecret returns a boolean if a field has been set.
func (o *CreateAuthMethodOIDC) HasClientSecret() bool {
	if o != nil && o.ClientSecret != nil {
		return true
	}

	return false
}

// SetClientSecret gets a reference to the given string and assigns it to the ClientSecret field.
func (o *CreateAuthMethodOIDC) SetClientSecret(v string) {
	o.ClientSecret = &v
}

// GetDeleteProtection returns the DeleteProtection field value if set, zero value otherwise.
func (o *CreateAuthMethodOIDC) GetDeleteProtection() string {
	if o == nil || o.DeleteProtection == nil {
		var ret string
		return ret
	}
	return *o.DeleteProtection
}

// GetDeleteProtectionOk returns a tuple with the DeleteProtection field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodOIDC) GetDeleteProtectionOk() (*string, bool) {
	if o == nil || o.DeleteProtection == nil {
		return nil, false
	}
	return o.DeleteProtection, true
}

// HasDeleteProtection returns a boolean if a field has been set.
func (o *CreateAuthMethodOIDC) HasDeleteProtection() bool {
	if o != nil && o.DeleteProtection != nil {
		return true
	}

	return false
}

// SetDeleteProtection gets a reference to the given string and assigns it to the DeleteProtection field.
func (o *CreateAuthMethodOIDC) SetDeleteProtection(v string) {
	o.DeleteProtection = &v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *CreateAuthMethodOIDC) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodOIDC) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *CreateAuthMethodOIDC) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *CreateAuthMethodOIDC) SetDescription(v string) {
	o.Description = &v
}

// GetForceSubClaims returns the ForceSubClaims field value if set, zero value otherwise.
func (o *CreateAuthMethodOIDC) GetForceSubClaims() bool {
	if o == nil || o.ForceSubClaims == nil {
		var ret bool
		return ret
	}
	return *o.ForceSubClaims
}

// GetForceSubClaimsOk returns a tuple with the ForceSubClaims field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodOIDC) GetForceSubClaimsOk() (*bool, bool) {
	if o == nil || o.ForceSubClaims == nil {
		return nil, false
	}
	return o.ForceSubClaims, true
}

// HasForceSubClaims returns a boolean if a field has been set.
func (o *CreateAuthMethodOIDC) HasForceSubClaims() bool {
	if o != nil && o.ForceSubClaims != nil {
		return true
	}

	return false
}

// SetForceSubClaims gets a reference to the given bool and assigns it to the ForceSubClaims field.
func (o *CreateAuthMethodOIDC) SetForceSubClaims(v bool) {
	o.ForceSubClaims = &v
}

// GetGwBoundIps returns the GwBoundIps field value if set, zero value otherwise.
func (o *CreateAuthMethodOIDC) GetGwBoundIps() []string {
	if o == nil || o.GwBoundIps == nil {
		var ret []string
		return ret
	}
	return *o.GwBoundIps
}

// GetGwBoundIpsOk returns a tuple with the GwBoundIps field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodOIDC) GetGwBoundIpsOk() (*[]string, bool) {
	if o == nil || o.GwBoundIps == nil {
		return nil, false
	}
	return o.GwBoundIps, true
}

// HasGwBoundIps returns a boolean if a field has been set.
func (o *CreateAuthMethodOIDC) HasGwBoundIps() bool {
	if o != nil && o.GwBoundIps != nil {
		return true
	}

	return false
}

// SetGwBoundIps gets a reference to the given []string and assigns it to the GwBoundIps field.
func (o *CreateAuthMethodOIDC) SetGwBoundIps(v []string) {
	o.GwBoundIps = &v
}

// GetIssuer returns the Issuer field value if set, zero value otherwise.
func (o *CreateAuthMethodOIDC) GetIssuer() string {
	if o == nil || o.Issuer == nil {
		var ret string
		return ret
	}
	return *o.Issuer
}

// GetIssuerOk returns a tuple with the Issuer field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodOIDC) GetIssuerOk() (*string, bool) {
	if o == nil || o.Issuer == nil {
		return nil, false
	}
	return o.Issuer, true
}

// HasIssuer returns a boolean if a field has been set.
func (o *CreateAuthMethodOIDC) HasIssuer() bool {
	if o != nil && o.Issuer != nil {
		return true
	}

	return false
}

// SetIssuer gets a reference to the given string and assigns it to the Issuer field.
func (o *CreateAuthMethodOIDC) SetIssuer(v string) {
	o.Issuer = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *CreateAuthMethodOIDC) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodOIDC) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *CreateAuthMethodOIDC) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *CreateAuthMethodOIDC) SetJson(v bool) {
	o.Json = &v
}

// GetJwtTtl returns the JwtTtl field value if set, zero value otherwise.
func (o *CreateAuthMethodOIDC) GetJwtTtl() int64 {
	if o == nil || o.JwtTtl == nil {
		var ret int64
		return ret
	}
	return *o.JwtTtl
}

// GetJwtTtlOk returns a tuple with the JwtTtl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodOIDC) GetJwtTtlOk() (*int64, bool) {
	if o == nil || o.JwtTtl == nil {
		return nil, false
	}
	return o.JwtTtl, true
}

// HasJwtTtl returns a boolean if a field has been set.
func (o *CreateAuthMethodOIDC) HasJwtTtl() bool {
	if o != nil && o.JwtTtl != nil {
		return true
	}

	return false
}

// SetJwtTtl gets a reference to the given int64 and assigns it to the JwtTtl field.
func (o *CreateAuthMethodOIDC) SetJwtTtl(v int64) {
	o.JwtTtl = &v
}

// GetName returns the Name field value
func (o *CreateAuthMethodOIDC) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodOIDC) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *CreateAuthMethodOIDC) SetName(v string) {
	o.Name = v
}

// GetProductType returns the ProductType field value if set, zero value otherwise.
func (o *CreateAuthMethodOIDC) GetProductType() []string {
	if o == nil || o.ProductType == nil {
		var ret []string
		return ret
	}
	return *o.ProductType
}

// GetProductTypeOk returns a tuple with the ProductType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodOIDC) GetProductTypeOk() (*[]string, bool) {
	if o == nil || o.ProductType == nil {
		return nil, false
	}
	return o.ProductType, true
}

// HasProductType returns a boolean if a field has been set.
func (o *CreateAuthMethodOIDC) HasProductType() bool {
	if o != nil && o.ProductType != nil {
		return true
	}

	return false
}

// SetProductType gets a reference to the given []string and assigns it to the ProductType field.
func (o *CreateAuthMethodOIDC) SetProductType(v []string) {
	o.ProductType = &v
}

// GetRequiredScopes returns the RequiredScopes field value if set, zero value otherwise.
func (o *CreateAuthMethodOIDC) GetRequiredScopes() []string {
	if o == nil || o.RequiredScopes == nil {
		var ret []string
		return ret
	}
	return *o.RequiredScopes
}

// GetRequiredScopesOk returns a tuple with the RequiredScopes field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodOIDC) GetRequiredScopesOk() (*[]string, bool) {
	if o == nil || o.RequiredScopes == nil {
		return nil, false
	}
	return o.RequiredScopes, true
}

// HasRequiredScopes returns a boolean if a field has been set.
func (o *CreateAuthMethodOIDC) HasRequiredScopes() bool {
	if o != nil && o.RequiredScopes != nil {
		return true
	}

	return false
}

// SetRequiredScopes gets a reference to the given []string and assigns it to the RequiredScopes field.
func (o *CreateAuthMethodOIDC) SetRequiredScopes(v []string) {
	o.RequiredScopes = &v
}

// GetRequiredScopesPrefix returns the RequiredScopesPrefix field value if set, zero value otherwise.
func (o *CreateAuthMethodOIDC) GetRequiredScopesPrefix() string {
	if o == nil || o.RequiredScopesPrefix == nil {
		var ret string
		return ret
	}
	return *o.RequiredScopesPrefix
}

// GetRequiredScopesPrefixOk returns a tuple with the RequiredScopesPrefix field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodOIDC) GetRequiredScopesPrefixOk() (*string, bool) {
	if o == nil || o.RequiredScopesPrefix == nil {
		return nil, false
	}
	return o.RequiredScopesPrefix, true
}

// HasRequiredScopesPrefix returns a boolean if a field has been set.
func (o *CreateAuthMethodOIDC) HasRequiredScopesPrefix() bool {
	if o != nil && o.RequiredScopesPrefix != nil {
		return true
	}

	return false
}

// SetRequiredScopesPrefix gets a reference to the given string and assigns it to the RequiredScopesPrefix field.
func (o *CreateAuthMethodOIDC) SetRequiredScopesPrefix(v string) {
	o.RequiredScopesPrefix = &v
}

// GetSubclaimsDelimiters returns the SubclaimsDelimiters field value if set, zero value otherwise.
func (o *CreateAuthMethodOIDC) GetSubclaimsDelimiters() []string {
	if o == nil || o.SubclaimsDelimiters == nil {
		var ret []string
		return ret
	}
	return *o.SubclaimsDelimiters
}

// GetSubclaimsDelimitersOk returns a tuple with the SubclaimsDelimiters field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodOIDC) GetSubclaimsDelimitersOk() (*[]string, bool) {
	if o == nil || o.SubclaimsDelimiters == nil {
		return nil, false
	}
	return o.SubclaimsDelimiters, true
}

// HasSubclaimsDelimiters returns a boolean if a field has been set.
func (o *CreateAuthMethodOIDC) HasSubclaimsDelimiters() bool {
	if o != nil && o.SubclaimsDelimiters != nil {
		return true
	}

	return false
}

// SetSubclaimsDelimiters gets a reference to the given []string and assigns it to the SubclaimsDelimiters field.
func (o *CreateAuthMethodOIDC) SetSubclaimsDelimiters(v []string) {
	o.SubclaimsDelimiters = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *CreateAuthMethodOIDC) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodOIDC) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *CreateAuthMethodOIDC) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *CreateAuthMethodOIDC) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *CreateAuthMethodOIDC) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodOIDC) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *CreateAuthMethodOIDC) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *CreateAuthMethodOIDC) SetUidToken(v string) {
	o.UidToken = &v
}

// GetUniqueIdentifier returns the UniqueIdentifier field value
func (o *CreateAuthMethodOIDC) GetUniqueIdentifier() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.UniqueIdentifier
}

// GetUniqueIdentifierOk returns a tuple with the UniqueIdentifier field value
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodOIDC) GetUniqueIdentifierOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.UniqueIdentifier, true
}

// SetUniqueIdentifier sets field value
func (o *CreateAuthMethodOIDC) SetUniqueIdentifier(v string) {
	o.UniqueIdentifier = v
}

func (o CreateAuthMethodOIDC) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.AccessExpires != nil {
		toSerialize["access-expires"] = o.AccessExpires
	}
	if o.AllowedRedirectUri != nil {
		toSerialize["allowed-redirect-uri"] = o.AllowedRedirectUri
	}
	if o.Audience != nil {
		toSerialize["audience"] = o.Audience
	}
	if o.AuditLogsClaims != nil {
		toSerialize["audit-logs-claims"] = o.AuditLogsClaims
	}
	if o.BoundIps != nil {
		toSerialize["bound-ips"] = o.BoundIps
	}
	if o.ClientId != nil {
		toSerialize["client-id"] = o.ClientId
	}
	if o.ClientSecret != nil {
		toSerialize["client-secret"] = o.ClientSecret
	}
	if o.DeleteProtection != nil {
		toSerialize["delete_protection"] = o.DeleteProtection
	}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if o.ForceSubClaims != nil {
		toSerialize["force-sub-claims"] = o.ForceSubClaims
	}
	if o.GwBoundIps != nil {
		toSerialize["gw-bound-ips"] = o.GwBoundIps
	}
	if o.Issuer != nil {
		toSerialize["issuer"] = o.Issuer
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.JwtTtl != nil {
		toSerialize["jwt-ttl"] = o.JwtTtl
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.ProductType != nil {
		toSerialize["product-type"] = o.ProductType
	}
	if o.RequiredScopes != nil {
		toSerialize["required-scopes"] = o.RequiredScopes
	}
	if o.RequiredScopesPrefix != nil {
		toSerialize["required-scopes-prefix"] = o.RequiredScopesPrefix
	}
	if o.SubclaimsDelimiters != nil {
		toSerialize["subclaims-delimiters"] = o.SubclaimsDelimiters
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	if true {
		toSerialize["unique-identifier"] = o.UniqueIdentifier
	}
	return json.Marshal(toSerialize)
}

type NullableCreateAuthMethodOIDC struct {
	value *CreateAuthMethodOIDC
	isSet bool
}

func (v NullableCreateAuthMethodOIDC) Get() *CreateAuthMethodOIDC {
	return v.value
}

func (v *NullableCreateAuthMethodOIDC) Set(val *CreateAuthMethodOIDC) {
	v.value = val
	v.isSet = true
}

func (v NullableCreateAuthMethodOIDC) IsSet() bool {
	return v.isSet
}

func (v *NullableCreateAuthMethodOIDC) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableCreateAuthMethodOIDC(val *CreateAuthMethodOIDC) *NullableCreateAuthMethodOIDC {
	return &NullableCreateAuthMethodOIDC{value: val, isSet: true}
}

func (v NullableCreateAuthMethodOIDC) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableCreateAuthMethodOIDC) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


