/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// CreateSSHCertIssuer struct for CreateSSHCertIssuer
type CreateSSHCertIssuer struct {
	ProviderType *string `json:"ProviderType,omitempty"`
	// Users allowed to fetch the certificate, e.g root,ubuntu
	AllowedUsers string `json:"allowed-users"`
	// Protection from accidental deletion of this object [true/false]
	DeleteProtection *string `json:"delete_protection,omitempty"`
	// Description of the object
	Description *string `json:"description,omitempty"`
	// Signed certificates with extensions, e.g permit-port-forwarding=\\\"\\\"
	Extensions *map[string]string `json:"extensions,omitempty"`
	// Host provider type [explicit/target], Default Host provider is explicit, Relevant only for Secure Remote Access of ssh cert issuer, ldap rotated secret and ldap dynamic secret
	HostProvider *string `json:"host-provider,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Deprecated - use description
	Metadata *string `json:"metadata,omitempty"`
	// SSH certificate issuer name
	Name string `json:"name"`
	// Signed certificates with principal, e.g example_role1,example_role2
	Principals *string `json:"principals,omitempty"`
	// Bastion's SSH control API endpoint. E.g. https://my.bastion:9900
	SecureAccessBastionApi *string `json:"secure-access-bastion-api,omitempty"`
	// Bastion's SSH server. E.g. my.bastion:22
	SecureAccessBastionSsh *string `json:"secure-access-bastion-ssh,omitempty"`
	// Enable/Disable secure remote access [true/false]
	SecureAccessEnable *string `json:"secure-access-enable,omitempty"`
	// Enable this flag to enforce connections only to the hosts listed in --secure-access-host
	SecureAccessEnforceHostsRestriction *bool `json:"secure-access-enforce-hosts-restriction,omitempty"`
	// Target servers for connections (In case of Linked Target association, host(s) will inherit Linked Target hosts - Relevant only for Dynamic Secrets/producers)
	SecureAccessHost *[]string `json:"secure-access-host,omitempty"`
	// SSH username to connect to target server, must be in 'Allowed Users' list
	SecureAccessSshCredsUser *string `json:"secure-access-ssh-creds-user,omitempty"`
	// Use internal SSH Bastion
	SecureAccessUseInternalBastion *bool `json:"secure-access-use-internal-bastion,omitempty"`
	// A key to sign the certificate with
	SignerKeyName string `json:"signer-key-name"`
	// List of the tags attached to this key
	Tag *[]string `json:"tag,omitempty"`
	// A list of linked targets to be associated, Relevant only for Secure Remote Access for ssh cert issuer, ldap rotated secret and ldap dynamic secret, To specify multiple targets use argument multiple times
	Target *[]string `json:"target,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The requested Time To Live for the certificate, in seconds
	Ttl int64 `json:"ttl"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewCreateSSHCertIssuer instantiates a new CreateSSHCertIssuer object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewCreateSSHCertIssuer(allowedUsers string, name string, signerKeyName string, ttl int64, ) *CreateSSHCertIssuer {
	this := CreateSSHCertIssuer{}
	this.AllowedUsers = allowedUsers
	var json bool = false
	this.Json = &json
	this.Name = name
	this.SignerKeyName = signerKeyName
	this.Ttl = ttl
	return &this
}

// NewCreateSSHCertIssuerWithDefaults instantiates a new CreateSSHCertIssuer object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewCreateSSHCertIssuerWithDefaults() *CreateSSHCertIssuer {
	this := CreateSSHCertIssuer{}
	var json bool = false
	this.Json = &json
	return &this
}

// GetProviderType returns the ProviderType field value if set, zero value otherwise.
func (o *CreateSSHCertIssuer) GetProviderType() string {
	if o == nil || o.ProviderType == nil {
		var ret string
		return ret
	}
	return *o.ProviderType
}

// GetProviderTypeOk returns a tuple with the ProviderType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateSSHCertIssuer) GetProviderTypeOk() (*string, bool) {
	if o == nil || o.ProviderType == nil {
		return nil, false
	}
	return o.ProviderType, true
}

// HasProviderType returns a boolean if a field has been set.
func (o *CreateSSHCertIssuer) HasProviderType() bool {
	if o != nil && o.ProviderType != nil {
		return true
	}

	return false
}

// SetProviderType gets a reference to the given string and assigns it to the ProviderType field.
func (o *CreateSSHCertIssuer) SetProviderType(v string) {
	o.ProviderType = &v
}

// GetAllowedUsers returns the AllowedUsers field value
func (o *CreateSSHCertIssuer) GetAllowedUsers() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.AllowedUsers
}

// GetAllowedUsersOk returns a tuple with the AllowedUsers field value
// and a boolean to check if the value has been set.
func (o *CreateSSHCertIssuer) GetAllowedUsersOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.AllowedUsers, true
}

// SetAllowedUsers sets field value
func (o *CreateSSHCertIssuer) SetAllowedUsers(v string) {
	o.AllowedUsers = v
}

// GetDeleteProtection returns the DeleteProtection field value if set, zero value otherwise.
func (o *CreateSSHCertIssuer) GetDeleteProtection() string {
	if o == nil || o.DeleteProtection == nil {
		var ret string
		return ret
	}
	return *o.DeleteProtection
}

// GetDeleteProtectionOk returns a tuple with the DeleteProtection field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateSSHCertIssuer) GetDeleteProtectionOk() (*string, bool) {
	if o == nil || o.DeleteProtection == nil {
		return nil, false
	}
	return o.DeleteProtection, true
}

// HasDeleteProtection returns a boolean if a field has been set.
func (o *CreateSSHCertIssuer) HasDeleteProtection() bool {
	if o != nil && o.DeleteProtection != nil {
		return true
	}

	return false
}

// SetDeleteProtection gets a reference to the given string and assigns it to the DeleteProtection field.
func (o *CreateSSHCertIssuer) SetDeleteProtection(v string) {
	o.DeleteProtection = &v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *CreateSSHCertIssuer) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateSSHCertIssuer) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *CreateSSHCertIssuer) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *CreateSSHCertIssuer) SetDescription(v string) {
	o.Description = &v
}

// GetExtensions returns the Extensions field value if set, zero value otherwise.
func (o *CreateSSHCertIssuer) GetExtensions() map[string]string {
	if o == nil || o.Extensions == nil {
		var ret map[string]string
		return ret
	}
	return *o.Extensions
}

// GetExtensionsOk returns a tuple with the Extensions field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateSSHCertIssuer) GetExtensionsOk() (*map[string]string, bool) {
	if o == nil || o.Extensions == nil {
		return nil, false
	}
	return o.Extensions, true
}

// HasExtensions returns a boolean if a field has been set.
func (o *CreateSSHCertIssuer) HasExtensions() bool {
	if o != nil && o.Extensions != nil {
		return true
	}

	return false
}

// SetExtensions gets a reference to the given map[string]string and assigns it to the Extensions field.
func (o *CreateSSHCertIssuer) SetExtensions(v map[string]string) {
	o.Extensions = &v
}

// GetHostProvider returns the HostProvider field value if set, zero value otherwise.
func (o *CreateSSHCertIssuer) GetHostProvider() string {
	if o == nil || o.HostProvider == nil {
		var ret string
		return ret
	}
	return *o.HostProvider
}

// GetHostProviderOk returns a tuple with the HostProvider field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateSSHCertIssuer) GetHostProviderOk() (*string, bool) {
	if o == nil || o.HostProvider == nil {
		return nil, false
	}
	return o.HostProvider, true
}

// HasHostProvider returns a boolean if a field has been set.
func (o *CreateSSHCertIssuer) HasHostProvider() bool {
	if o != nil && o.HostProvider != nil {
		return true
	}

	return false
}

// SetHostProvider gets a reference to the given string and assigns it to the HostProvider field.
func (o *CreateSSHCertIssuer) SetHostProvider(v string) {
	o.HostProvider = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *CreateSSHCertIssuer) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateSSHCertIssuer) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *CreateSSHCertIssuer) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *CreateSSHCertIssuer) SetJson(v bool) {
	o.Json = &v
}

// GetMetadata returns the Metadata field value if set, zero value otherwise.
func (o *CreateSSHCertIssuer) GetMetadata() string {
	if o == nil || o.Metadata == nil {
		var ret string
		return ret
	}
	return *o.Metadata
}

// GetMetadataOk returns a tuple with the Metadata field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateSSHCertIssuer) GetMetadataOk() (*string, bool) {
	if o == nil || o.Metadata == nil {
		return nil, false
	}
	return o.Metadata, true
}

// HasMetadata returns a boolean if a field has been set.
func (o *CreateSSHCertIssuer) HasMetadata() bool {
	if o != nil && o.Metadata != nil {
		return true
	}

	return false
}

// SetMetadata gets a reference to the given string and assigns it to the Metadata field.
func (o *CreateSSHCertIssuer) SetMetadata(v string) {
	o.Metadata = &v
}

// GetName returns the Name field value
func (o *CreateSSHCertIssuer) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *CreateSSHCertIssuer) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *CreateSSHCertIssuer) SetName(v string) {
	o.Name = v
}

// GetPrincipals returns the Principals field value if set, zero value otherwise.
func (o *CreateSSHCertIssuer) GetPrincipals() string {
	if o == nil || o.Principals == nil {
		var ret string
		return ret
	}
	return *o.Principals
}

// GetPrincipalsOk returns a tuple with the Principals field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateSSHCertIssuer) GetPrincipalsOk() (*string, bool) {
	if o == nil || o.Principals == nil {
		return nil, false
	}
	return o.Principals, true
}

// HasPrincipals returns a boolean if a field has been set.
func (o *CreateSSHCertIssuer) HasPrincipals() bool {
	if o != nil && o.Principals != nil {
		return true
	}

	return false
}

// SetPrincipals gets a reference to the given string and assigns it to the Principals field.
func (o *CreateSSHCertIssuer) SetPrincipals(v string) {
	o.Principals = &v
}

// GetSecureAccessBastionApi returns the SecureAccessBastionApi field value if set, zero value otherwise.
func (o *CreateSSHCertIssuer) GetSecureAccessBastionApi() string {
	if o == nil || o.SecureAccessBastionApi == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessBastionApi
}

// GetSecureAccessBastionApiOk returns a tuple with the SecureAccessBastionApi field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateSSHCertIssuer) GetSecureAccessBastionApiOk() (*string, bool) {
	if o == nil || o.SecureAccessBastionApi == nil {
		return nil, false
	}
	return o.SecureAccessBastionApi, true
}

// HasSecureAccessBastionApi returns a boolean if a field has been set.
func (o *CreateSSHCertIssuer) HasSecureAccessBastionApi() bool {
	if o != nil && o.SecureAccessBastionApi != nil {
		return true
	}

	return false
}

// SetSecureAccessBastionApi gets a reference to the given string and assigns it to the SecureAccessBastionApi field.
func (o *CreateSSHCertIssuer) SetSecureAccessBastionApi(v string) {
	o.SecureAccessBastionApi = &v
}

// GetSecureAccessBastionSsh returns the SecureAccessBastionSsh field value if set, zero value otherwise.
func (o *CreateSSHCertIssuer) GetSecureAccessBastionSsh() string {
	if o == nil || o.SecureAccessBastionSsh == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessBastionSsh
}

// GetSecureAccessBastionSshOk returns a tuple with the SecureAccessBastionSsh field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateSSHCertIssuer) GetSecureAccessBastionSshOk() (*string, bool) {
	if o == nil || o.SecureAccessBastionSsh == nil {
		return nil, false
	}
	return o.SecureAccessBastionSsh, true
}

// HasSecureAccessBastionSsh returns a boolean if a field has been set.
func (o *CreateSSHCertIssuer) HasSecureAccessBastionSsh() bool {
	if o != nil && o.SecureAccessBastionSsh != nil {
		return true
	}

	return false
}

// SetSecureAccessBastionSsh gets a reference to the given string and assigns it to the SecureAccessBastionSsh field.
func (o *CreateSSHCertIssuer) SetSecureAccessBastionSsh(v string) {
	o.SecureAccessBastionSsh = &v
}

// GetSecureAccessEnable returns the SecureAccessEnable field value if set, zero value otherwise.
func (o *CreateSSHCertIssuer) GetSecureAccessEnable() string {
	if o == nil || o.SecureAccessEnable == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessEnable
}

// GetSecureAccessEnableOk returns a tuple with the SecureAccessEnable field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateSSHCertIssuer) GetSecureAccessEnableOk() (*string, bool) {
	if o == nil || o.SecureAccessEnable == nil {
		return nil, false
	}
	return o.SecureAccessEnable, true
}

// HasSecureAccessEnable returns a boolean if a field has been set.
func (o *CreateSSHCertIssuer) HasSecureAccessEnable() bool {
	if o != nil && o.SecureAccessEnable != nil {
		return true
	}

	return false
}

// SetSecureAccessEnable gets a reference to the given string and assigns it to the SecureAccessEnable field.
func (o *CreateSSHCertIssuer) SetSecureAccessEnable(v string) {
	o.SecureAccessEnable = &v
}

// GetSecureAccessEnforceHostsRestriction returns the SecureAccessEnforceHostsRestriction field value if set, zero value otherwise.
func (o *CreateSSHCertIssuer) GetSecureAccessEnforceHostsRestriction() bool {
	if o == nil || o.SecureAccessEnforceHostsRestriction == nil {
		var ret bool
		return ret
	}
	return *o.SecureAccessEnforceHostsRestriction
}

// GetSecureAccessEnforceHostsRestrictionOk returns a tuple with the SecureAccessEnforceHostsRestriction field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateSSHCertIssuer) GetSecureAccessEnforceHostsRestrictionOk() (*bool, bool) {
	if o == nil || o.SecureAccessEnforceHostsRestriction == nil {
		return nil, false
	}
	return o.SecureAccessEnforceHostsRestriction, true
}

// HasSecureAccessEnforceHostsRestriction returns a boolean if a field has been set.
func (o *CreateSSHCertIssuer) HasSecureAccessEnforceHostsRestriction() bool {
	if o != nil && o.SecureAccessEnforceHostsRestriction != nil {
		return true
	}

	return false
}

// SetSecureAccessEnforceHostsRestriction gets a reference to the given bool and assigns it to the SecureAccessEnforceHostsRestriction field.
func (o *CreateSSHCertIssuer) SetSecureAccessEnforceHostsRestriction(v bool) {
	o.SecureAccessEnforceHostsRestriction = &v
}

// GetSecureAccessHost returns the SecureAccessHost field value if set, zero value otherwise.
func (o *CreateSSHCertIssuer) GetSecureAccessHost() []string {
	if o == nil || o.SecureAccessHost == nil {
		var ret []string
		return ret
	}
	return *o.SecureAccessHost
}

// GetSecureAccessHostOk returns a tuple with the SecureAccessHost field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateSSHCertIssuer) GetSecureAccessHostOk() (*[]string, bool) {
	if o == nil || o.SecureAccessHost == nil {
		return nil, false
	}
	return o.SecureAccessHost, true
}

// HasSecureAccessHost returns a boolean if a field has been set.
func (o *CreateSSHCertIssuer) HasSecureAccessHost() bool {
	if o != nil && o.SecureAccessHost != nil {
		return true
	}

	return false
}

// SetSecureAccessHost gets a reference to the given []string and assigns it to the SecureAccessHost field.
func (o *CreateSSHCertIssuer) SetSecureAccessHost(v []string) {
	o.SecureAccessHost = &v
}

// GetSecureAccessSshCredsUser returns the SecureAccessSshCredsUser field value if set, zero value otherwise.
func (o *CreateSSHCertIssuer) GetSecureAccessSshCredsUser() string {
	if o == nil || o.SecureAccessSshCredsUser == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessSshCredsUser
}

// GetSecureAccessSshCredsUserOk returns a tuple with the SecureAccessSshCredsUser field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateSSHCertIssuer) GetSecureAccessSshCredsUserOk() (*string, bool) {
	if o == nil || o.SecureAccessSshCredsUser == nil {
		return nil, false
	}
	return o.SecureAccessSshCredsUser, true
}

// HasSecureAccessSshCredsUser returns a boolean if a field has been set.
func (o *CreateSSHCertIssuer) HasSecureAccessSshCredsUser() bool {
	if o != nil && o.SecureAccessSshCredsUser != nil {
		return true
	}

	return false
}

// SetSecureAccessSshCredsUser gets a reference to the given string and assigns it to the SecureAccessSshCredsUser field.
func (o *CreateSSHCertIssuer) SetSecureAccessSshCredsUser(v string) {
	o.SecureAccessSshCredsUser = &v
}

// GetSecureAccessUseInternalBastion returns the SecureAccessUseInternalBastion field value if set, zero value otherwise.
func (o *CreateSSHCertIssuer) GetSecureAccessUseInternalBastion() bool {
	if o == nil || o.SecureAccessUseInternalBastion == nil {
		var ret bool
		return ret
	}
	return *o.SecureAccessUseInternalBastion
}

// GetSecureAccessUseInternalBastionOk returns a tuple with the SecureAccessUseInternalBastion field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateSSHCertIssuer) GetSecureAccessUseInternalBastionOk() (*bool, bool) {
	if o == nil || o.SecureAccessUseInternalBastion == nil {
		return nil, false
	}
	return o.SecureAccessUseInternalBastion, true
}

// HasSecureAccessUseInternalBastion returns a boolean if a field has been set.
func (o *CreateSSHCertIssuer) HasSecureAccessUseInternalBastion() bool {
	if o != nil && o.SecureAccessUseInternalBastion != nil {
		return true
	}

	return false
}

// SetSecureAccessUseInternalBastion gets a reference to the given bool and assigns it to the SecureAccessUseInternalBastion field.
func (o *CreateSSHCertIssuer) SetSecureAccessUseInternalBastion(v bool) {
	o.SecureAccessUseInternalBastion = &v
}

// GetSignerKeyName returns the SignerKeyName field value
func (o *CreateSSHCertIssuer) GetSignerKeyName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.SignerKeyName
}

// GetSignerKeyNameOk returns a tuple with the SignerKeyName field value
// and a boolean to check if the value has been set.
func (o *CreateSSHCertIssuer) GetSignerKeyNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.SignerKeyName, true
}

// SetSignerKeyName sets field value
func (o *CreateSSHCertIssuer) SetSignerKeyName(v string) {
	o.SignerKeyName = v
}

// GetTag returns the Tag field value if set, zero value otherwise.
func (o *CreateSSHCertIssuer) GetTag() []string {
	if o == nil || o.Tag == nil {
		var ret []string
		return ret
	}
	return *o.Tag
}

// GetTagOk returns a tuple with the Tag field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateSSHCertIssuer) GetTagOk() (*[]string, bool) {
	if o == nil || o.Tag == nil {
		return nil, false
	}
	return o.Tag, true
}

// HasTag returns a boolean if a field has been set.
func (o *CreateSSHCertIssuer) HasTag() bool {
	if o != nil && o.Tag != nil {
		return true
	}

	return false
}

// SetTag gets a reference to the given []string and assigns it to the Tag field.
func (o *CreateSSHCertIssuer) SetTag(v []string) {
	o.Tag = &v
}

// GetTarget returns the Target field value if set, zero value otherwise.
func (o *CreateSSHCertIssuer) GetTarget() []string {
	if o == nil || o.Target == nil {
		var ret []string
		return ret
	}
	return *o.Target
}

// GetTargetOk returns a tuple with the Target field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateSSHCertIssuer) GetTargetOk() (*[]string, bool) {
	if o == nil || o.Target == nil {
		return nil, false
	}
	return o.Target, true
}

// HasTarget returns a boolean if a field has been set.
func (o *CreateSSHCertIssuer) HasTarget() bool {
	if o != nil && o.Target != nil {
		return true
	}

	return false
}

// SetTarget gets a reference to the given []string and assigns it to the Target field.
func (o *CreateSSHCertIssuer) SetTarget(v []string) {
	o.Target = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *CreateSSHCertIssuer) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateSSHCertIssuer) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *CreateSSHCertIssuer) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *CreateSSHCertIssuer) SetToken(v string) {
	o.Token = &v
}

// GetTtl returns the Ttl field value
func (o *CreateSSHCertIssuer) GetTtl() int64 {
	if o == nil  {
		var ret int64
		return ret
	}

	return o.Ttl
}

// GetTtlOk returns a tuple with the Ttl field value
// and a boolean to check if the value has been set.
func (o *CreateSSHCertIssuer) GetTtlOk() (*int64, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Ttl, true
}

// SetTtl sets field value
func (o *CreateSSHCertIssuer) SetTtl(v int64) {
	o.Ttl = v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *CreateSSHCertIssuer) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateSSHCertIssuer) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *CreateSSHCertIssuer) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *CreateSSHCertIssuer) SetUidToken(v string) {
	o.UidToken = &v
}

func (o CreateSSHCertIssuer) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.ProviderType != nil {
		toSerialize["ProviderType"] = o.ProviderType
	}
	if true {
		toSerialize["allowed-users"] = o.AllowedUsers
	}
	if o.DeleteProtection != nil {
		toSerialize["delete_protection"] = o.DeleteProtection
	}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if o.Extensions != nil {
		toSerialize["extensions"] = o.Extensions
	}
	if o.HostProvider != nil {
		toSerialize["host-provider"] = o.HostProvider
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.Metadata != nil {
		toSerialize["metadata"] = o.Metadata
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.Principals != nil {
		toSerialize["principals"] = o.Principals
	}
	if o.SecureAccessBastionApi != nil {
		toSerialize["secure-access-bastion-api"] = o.SecureAccessBastionApi
	}
	if o.SecureAccessBastionSsh != nil {
		toSerialize["secure-access-bastion-ssh"] = o.SecureAccessBastionSsh
	}
	if o.SecureAccessEnable != nil {
		toSerialize["secure-access-enable"] = o.SecureAccessEnable
	}
	if o.SecureAccessEnforceHostsRestriction != nil {
		toSerialize["secure-access-enforce-hosts-restriction"] = o.SecureAccessEnforceHostsRestriction
	}
	if o.SecureAccessHost != nil {
		toSerialize["secure-access-host"] = o.SecureAccessHost
	}
	if o.SecureAccessSshCredsUser != nil {
		toSerialize["secure-access-ssh-creds-user"] = o.SecureAccessSshCredsUser
	}
	if o.SecureAccessUseInternalBastion != nil {
		toSerialize["secure-access-use-internal-bastion"] = o.SecureAccessUseInternalBastion
	}
	if true {
		toSerialize["signer-key-name"] = o.SignerKeyName
	}
	if o.Tag != nil {
		toSerialize["tag"] = o.Tag
	}
	if o.Target != nil {
		toSerialize["target"] = o.Target
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if true {
		toSerialize["ttl"] = o.Ttl
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableCreateSSHCertIssuer struct {
	value *CreateSSHCertIssuer
	isSet bool
}

func (v NullableCreateSSHCertIssuer) Get() *CreateSSHCertIssuer {
	return v.value
}

func (v *NullableCreateSSHCertIssuer) Set(val *CreateSSHCertIssuer) {
	v.value = val
	v.isSet = true
}

func (v NullableCreateSSHCertIssuer) IsSet() bool {
	return v.isSet
}

func (v *NullableCreateSSHCertIssuer) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableCreateSSHCertIssuer(val *CreateSSHCertIssuer) *NullableCreateSSHCertIssuer {
	return &NullableCreateSSHCertIssuer{value: val, isSet: true}
}

func (v NullableCreateSSHCertIssuer) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableCreateSSHCertIssuer) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


