/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// DecryptFile struct for DecryptFile
type DecryptFile struct {
	CyphertextHeader *string `json:"cyphertext-header,omitempty"`
	// The display id of the key to use in the decryption process
	DisplayId *string `json:"display-id,omitempty"`
	// Path to the file to be decrypted. If not provided, the content will be taken from stdin
	In string `json:"in"`
	// The item id of the key to use in the decryption process
	ItemId *int64 `json:"item-id,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// The name of the key to use in the decryption process
	KeyName string `json:"key-name"`
	// Path to the output file. If not provided, the output will be sent to stdout
	Out *string `json:"out,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
	// key version (relevant only for classic key)
	Version *int32 `json:"version,omitempty"`
}

// NewDecryptFile instantiates a new DecryptFile object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewDecryptFile(in string, keyName string, ) *DecryptFile {
	this := DecryptFile{}
	this.In = in
	var json bool = false
	this.Json = &json
	this.KeyName = keyName
	return &this
}

// NewDecryptFileWithDefaults instantiates a new DecryptFile object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewDecryptFileWithDefaults() *DecryptFile {
	this := DecryptFile{}
	var json bool = false
	this.Json = &json
	return &this
}

// GetCyphertextHeader returns the CyphertextHeader field value if set, zero value otherwise.
func (o *DecryptFile) GetCyphertextHeader() string {
	if o == nil || o.CyphertextHeader == nil {
		var ret string
		return ret
	}
	return *o.CyphertextHeader
}

// GetCyphertextHeaderOk returns a tuple with the CyphertextHeader field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DecryptFile) GetCyphertextHeaderOk() (*string, bool) {
	if o == nil || o.CyphertextHeader == nil {
		return nil, false
	}
	return o.CyphertextHeader, true
}

// HasCyphertextHeader returns a boolean if a field has been set.
func (o *DecryptFile) HasCyphertextHeader() bool {
	if o != nil && o.CyphertextHeader != nil {
		return true
	}

	return false
}

// SetCyphertextHeader gets a reference to the given string and assigns it to the CyphertextHeader field.
func (o *DecryptFile) SetCyphertextHeader(v string) {
	o.CyphertextHeader = &v
}

// GetDisplayId returns the DisplayId field value if set, zero value otherwise.
func (o *DecryptFile) GetDisplayId() string {
	if o == nil || o.DisplayId == nil {
		var ret string
		return ret
	}
	return *o.DisplayId
}

// GetDisplayIdOk returns a tuple with the DisplayId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DecryptFile) GetDisplayIdOk() (*string, bool) {
	if o == nil || o.DisplayId == nil {
		return nil, false
	}
	return o.DisplayId, true
}

// HasDisplayId returns a boolean if a field has been set.
func (o *DecryptFile) HasDisplayId() bool {
	if o != nil && o.DisplayId != nil {
		return true
	}

	return false
}

// SetDisplayId gets a reference to the given string and assigns it to the DisplayId field.
func (o *DecryptFile) SetDisplayId(v string) {
	o.DisplayId = &v
}

// GetIn returns the In field value
func (o *DecryptFile) GetIn() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.In
}

// GetInOk returns a tuple with the In field value
// and a boolean to check if the value has been set.
func (o *DecryptFile) GetInOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.In, true
}

// SetIn sets field value
func (o *DecryptFile) SetIn(v string) {
	o.In = v
}

// GetItemId returns the ItemId field value if set, zero value otherwise.
func (o *DecryptFile) GetItemId() int64 {
	if o == nil || o.ItemId == nil {
		var ret int64
		return ret
	}
	return *o.ItemId
}

// GetItemIdOk returns a tuple with the ItemId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DecryptFile) GetItemIdOk() (*int64, bool) {
	if o == nil || o.ItemId == nil {
		return nil, false
	}
	return o.ItemId, true
}

// HasItemId returns a boolean if a field has been set.
func (o *DecryptFile) HasItemId() bool {
	if o != nil && o.ItemId != nil {
		return true
	}

	return false
}

// SetItemId gets a reference to the given int64 and assigns it to the ItemId field.
func (o *DecryptFile) SetItemId(v int64) {
	o.ItemId = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *DecryptFile) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DecryptFile) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *DecryptFile) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *DecryptFile) SetJson(v bool) {
	o.Json = &v
}

// GetKeyName returns the KeyName field value
func (o *DecryptFile) GetKeyName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.KeyName
}

// GetKeyNameOk returns a tuple with the KeyName field value
// and a boolean to check if the value has been set.
func (o *DecryptFile) GetKeyNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.KeyName, true
}

// SetKeyName sets field value
func (o *DecryptFile) SetKeyName(v string) {
	o.KeyName = v
}

// GetOut returns the Out field value if set, zero value otherwise.
func (o *DecryptFile) GetOut() string {
	if o == nil || o.Out == nil {
		var ret string
		return ret
	}
	return *o.Out
}

// GetOutOk returns a tuple with the Out field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DecryptFile) GetOutOk() (*string, bool) {
	if o == nil || o.Out == nil {
		return nil, false
	}
	return o.Out, true
}

// HasOut returns a boolean if a field has been set.
func (o *DecryptFile) HasOut() bool {
	if o != nil && o.Out != nil {
		return true
	}

	return false
}

// SetOut gets a reference to the given string and assigns it to the Out field.
func (o *DecryptFile) SetOut(v string) {
	o.Out = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *DecryptFile) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DecryptFile) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *DecryptFile) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *DecryptFile) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *DecryptFile) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DecryptFile) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *DecryptFile) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *DecryptFile) SetUidToken(v string) {
	o.UidToken = &v
}

// GetVersion returns the Version field value if set, zero value otherwise.
func (o *DecryptFile) GetVersion() int32 {
	if o == nil || o.Version == nil {
		var ret int32
		return ret
	}
	return *o.Version
}

// GetVersionOk returns a tuple with the Version field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DecryptFile) GetVersionOk() (*int32, bool) {
	if o == nil || o.Version == nil {
		return nil, false
	}
	return o.Version, true
}

// HasVersion returns a boolean if a field has been set.
func (o *DecryptFile) HasVersion() bool {
	if o != nil && o.Version != nil {
		return true
	}

	return false
}

// SetVersion gets a reference to the given int32 and assigns it to the Version field.
func (o *DecryptFile) SetVersion(v int32) {
	o.Version = &v
}

func (o DecryptFile) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.CyphertextHeader != nil {
		toSerialize["cyphertext-header"] = o.CyphertextHeader
	}
	if o.DisplayId != nil {
		toSerialize["display-id"] = o.DisplayId
	}
	if true {
		toSerialize["in"] = o.In
	}
	if o.ItemId != nil {
		toSerialize["item-id"] = o.ItemId
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if true {
		toSerialize["key-name"] = o.KeyName
	}
	if o.Out != nil {
		toSerialize["out"] = o.Out
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	if o.Version != nil {
		toSerialize["version"] = o.Version
	}
	return json.Marshal(toSerialize)
}

type NullableDecryptFile struct {
	value *DecryptFile
	isSet bool
}

func (v NullableDecryptFile) Get() *DecryptFile {
	return v.value
}

func (v *NullableDecryptFile) Set(val *DecryptFile) {
	v.value = val
	v.isSet = true
}

func (v NullableDecryptFile) IsSet() bool {
	return v.isSet
}

func (v *NullableDecryptFile) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableDecryptFile(val *DecryptFile) *NullableDecryptFile {
	return &NullableDecryptFile{value: val, isSet: true}
}

func (v NullableDecryptFile) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableDecryptFile) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


