/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// DeriveKey struct for DeriveKey
type DeriveKey struct {
	// for personal password manager
	Accessibility *string `json:"accessibility,omitempty"`
	// Kdf algorithm
	Alg string `json:"alg"`
	// HashFunction the hash function to use (relevant for pbkdf2)
	HashFunction *string `json:"hash-function,omitempty"`
	// IterationCount the number of iterations
	Iter int64 `json:"iter"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// KeyLength the byte length of the generated key
	KeyLen int64 `json:"key-len"`
	// MemorySizeInKb the memory paramter in kb (relevant for argon2id)
	Mem *int64 `json:"mem,omitempty"`
	// Static Secret full name
	Name string `json:"name"`
	// Parallelism the number of threads to use (relevant for argon2id)
	Parallelism *int64 `json:"parallelism,omitempty"`
	// Salt Base64 encoded salt value. If not provided, the salt will be generated as part of the operation. The salt should be securely-generated random bytes, minimum 64 bits, 128 bits is recommended
	Salt *string `json:"salt,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewDeriveKey instantiates a new DeriveKey object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewDeriveKey(alg string, iter int64, keyLen int64, name string, ) *DeriveKey {
	this := DeriveKey{}
	var accessibility string = "regular"
	this.Accessibility = &accessibility
	this.Alg = alg
	var hashFunction string = "sha256"
	this.HashFunction = &hashFunction
	this.Iter = iter
	var json bool = false
	this.Json = &json
	this.KeyLen = keyLen
	var mem int64 = 16384
	this.Mem = &mem
	this.Name = name
	var parallelism int64 = 1
	this.Parallelism = &parallelism
	return &this
}

// NewDeriveKeyWithDefaults instantiates a new DeriveKey object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewDeriveKeyWithDefaults() *DeriveKey {
	this := DeriveKey{}
	var accessibility string = "regular"
	this.Accessibility = &accessibility
	var alg string = "pbkdf2"
	this.Alg = alg
	var hashFunction string = "sha256"
	this.HashFunction = &hashFunction
	var json bool = false
	this.Json = &json
	var mem int64 = 16384
	this.Mem = &mem
	var parallelism int64 = 1
	this.Parallelism = &parallelism
	return &this
}

// GetAccessibility returns the Accessibility field value if set, zero value otherwise.
func (o *DeriveKey) GetAccessibility() string {
	if o == nil || o.Accessibility == nil {
		var ret string
		return ret
	}
	return *o.Accessibility
}

// GetAccessibilityOk returns a tuple with the Accessibility field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DeriveKey) GetAccessibilityOk() (*string, bool) {
	if o == nil || o.Accessibility == nil {
		return nil, false
	}
	return o.Accessibility, true
}

// HasAccessibility returns a boolean if a field has been set.
func (o *DeriveKey) HasAccessibility() bool {
	if o != nil && o.Accessibility != nil {
		return true
	}

	return false
}

// SetAccessibility gets a reference to the given string and assigns it to the Accessibility field.
func (o *DeriveKey) SetAccessibility(v string) {
	o.Accessibility = &v
}

// GetAlg returns the Alg field value
func (o *DeriveKey) GetAlg() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Alg
}

// GetAlgOk returns a tuple with the Alg field value
// and a boolean to check if the value has been set.
func (o *DeriveKey) GetAlgOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Alg, true
}

// SetAlg sets field value
func (o *DeriveKey) SetAlg(v string) {
	o.Alg = v
}

// GetHashFunction returns the HashFunction field value if set, zero value otherwise.
func (o *DeriveKey) GetHashFunction() string {
	if o == nil || o.HashFunction == nil {
		var ret string
		return ret
	}
	return *o.HashFunction
}

// GetHashFunctionOk returns a tuple with the HashFunction field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DeriveKey) GetHashFunctionOk() (*string, bool) {
	if o == nil || o.HashFunction == nil {
		return nil, false
	}
	return o.HashFunction, true
}

// HasHashFunction returns a boolean if a field has been set.
func (o *DeriveKey) HasHashFunction() bool {
	if o != nil && o.HashFunction != nil {
		return true
	}

	return false
}

// SetHashFunction gets a reference to the given string and assigns it to the HashFunction field.
func (o *DeriveKey) SetHashFunction(v string) {
	o.HashFunction = &v
}

// GetIter returns the Iter field value
func (o *DeriveKey) GetIter() int64 {
	if o == nil  {
		var ret int64
		return ret
	}

	return o.Iter
}

// GetIterOk returns a tuple with the Iter field value
// and a boolean to check if the value has been set.
func (o *DeriveKey) GetIterOk() (*int64, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Iter, true
}

// SetIter sets field value
func (o *DeriveKey) SetIter(v int64) {
	o.Iter = v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *DeriveKey) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DeriveKey) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *DeriveKey) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *DeriveKey) SetJson(v bool) {
	o.Json = &v
}

// GetKeyLen returns the KeyLen field value
func (o *DeriveKey) GetKeyLen() int64 {
	if o == nil  {
		var ret int64
		return ret
	}

	return o.KeyLen
}

// GetKeyLenOk returns a tuple with the KeyLen field value
// and a boolean to check if the value has been set.
func (o *DeriveKey) GetKeyLenOk() (*int64, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.KeyLen, true
}

// SetKeyLen sets field value
func (o *DeriveKey) SetKeyLen(v int64) {
	o.KeyLen = v
}

// GetMem returns the Mem field value if set, zero value otherwise.
func (o *DeriveKey) GetMem() int64 {
	if o == nil || o.Mem == nil {
		var ret int64
		return ret
	}
	return *o.Mem
}

// GetMemOk returns a tuple with the Mem field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DeriveKey) GetMemOk() (*int64, bool) {
	if o == nil || o.Mem == nil {
		return nil, false
	}
	return o.Mem, true
}

// HasMem returns a boolean if a field has been set.
func (o *DeriveKey) HasMem() bool {
	if o != nil && o.Mem != nil {
		return true
	}

	return false
}

// SetMem gets a reference to the given int64 and assigns it to the Mem field.
func (o *DeriveKey) SetMem(v int64) {
	o.Mem = &v
}

// GetName returns the Name field value
func (o *DeriveKey) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *DeriveKey) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *DeriveKey) SetName(v string) {
	o.Name = v
}

// GetParallelism returns the Parallelism field value if set, zero value otherwise.
func (o *DeriveKey) GetParallelism() int64 {
	if o == nil || o.Parallelism == nil {
		var ret int64
		return ret
	}
	return *o.Parallelism
}

// GetParallelismOk returns a tuple with the Parallelism field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DeriveKey) GetParallelismOk() (*int64, bool) {
	if o == nil || o.Parallelism == nil {
		return nil, false
	}
	return o.Parallelism, true
}

// HasParallelism returns a boolean if a field has been set.
func (o *DeriveKey) HasParallelism() bool {
	if o != nil && o.Parallelism != nil {
		return true
	}

	return false
}

// SetParallelism gets a reference to the given int64 and assigns it to the Parallelism field.
func (o *DeriveKey) SetParallelism(v int64) {
	o.Parallelism = &v
}

// GetSalt returns the Salt field value if set, zero value otherwise.
func (o *DeriveKey) GetSalt() string {
	if o == nil || o.Salt == nil {
		var ret string
		return ret
	}
	return *o.Salt
}

// GetSaltOk returns a tuple with the Salt field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DeriveKey) GetSaltOk() (*string, bool) {
	if o == nil || o.Salt == nil {
		return nil, false
	}
	return o.Salt, true
}

// HasSalt returns a boolean if a field has been set.
func (o *DeriveKey) HasSalt() bool {
	if o != nil && o.Salt != nil {
		return true
	}

	return false
}

// SetSalt gets a reference to the given string and assigns it to the Salt field.
func (o *DeriveKey) SetSalt(v string) {
	o.Salt = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *DeriveKey) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DeriveKey) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *DeriveKey) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *DeriveKey) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *DeriveKey) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DeriveKey) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *DeriveKey) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *DeriveKey) SetUidToken(v string) {
	o.UidToken = &v
}

func (o DeriveKey) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Accessibility != nil {
		toSerialize["accessibility"] = o.Accessibility
	}
	if true {
		toSerialize["alg"] = o.Alg
	}
	if o.HashFunction != nil {
		toSerialize["hash-function"] = o.HashFunction
	}
	if true {
		toSerialize["iter"] = o.Iter
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if true {
		toSerialize["key-len"] = o.KeyLen
	}
	if o.Mem != nil {
		toSerialize["mem"] = o.Mem
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.Parallelism != nil {
		toSerialize["parallelism"] = o.Parallelism
	}
	if o.Salt != nil {
		toSerialize["salt"] = o.Salt
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableDeriveKey struct {
	value *DeriveKey
	isSet bool
}

func (v NullableDeriveKey) Get() *DeriveKey {
	return v.value
}

func (v *NullableDeriveKey) Set(val *DeriveKey) {
	v.value = val
	v.isSet = true
}

func (v NullableDeriveKey) IsSet() bool {
	return v.isSet
}

func (v *NullableDeriveKey) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableDeriveKey(val *DeriveKey) *NullableDeriveKey {
	return &NullableDeriveKey{value: val, isSet: true}
}

func (v NullableDeriveKey) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableDeriveKey) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


