/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// GatewayCreateK8SAuthConfig gatewayCreateK8SAuth is a command that creates k8s auth config
type GatewayCreateK8SAuthConfig struct {
	// The access ID of the Kubernetes auth method
	AccessId string `json:"access-id"`
	// Cluster access type. options: [native_k8s, rancher]
	ClusterApiType *string `json:"cluster-api-type,omitempty"`
	// Disable issuer validation [true/false]
	DisableIssuerValidation *string `json:"disable-issuer-validation,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// K8S auth type [token/certificate]. (relevant for \"native_k8s\" only)
	K8sAuthType *string `json:"k8s-auth-type,omitempty"`
	// The CA Certificate (base64 encoded) to use to call into the kubernetes API server
	K8sCaCert *string `json:"k8s-ca-cert,omitempty"`
	// Content of the k8 client certificate (PEM format) in a Base64 format (relevant for \"native_k8s\" only)
	K8sClientCertificate *string `json:"k8s-client-certificate,omitempty"`
	// Content of the k8 client private key (PEM format) in a Base64 format (relevant for \"native_k8s\" only)
	K8sClientKey *string `json:"k8s-client-key,omitempty"`
	// The URL of the kubernetes API server
	K8sHost string `json:"k8s-host"`
	// The Kubernetes JWT issuer name. K8SIssuer is the claim that specifies who issued the Kubernetes token
	K8sIssuer *string `json:"k8s-issuer,omitempty"`
	// K8S Auth config name
	Name string `json:"name"`
	// The api key used to access the TokenReview API to validate other JWTs (relevant for \"rancher\" only)
	RancherApiKey *string `json:"rancher-api-key,omitempty"`
	// The cluster id as define in rancher (relevant for \"rancher\" only)
	RancherClusterId *string `json:"rancher-cluster-id,omitempty"`
	// The private key (base64 encoded) associated with the public key defined in the Kubernetes auth
	SigningKey string `json:"signing-key"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// Time in seconds of expiration of the Akeyless Kube Auth Method token
	TokenExp *int64 `json:"token-exp,omitempty"`
	// A Kubernetes service account JWT used to access the TokenReview API to validate other JWTs (relevant for \"native_k8s\" only). If not set, the JWT submitted in the authentication process will be used to access the Kubernetes TokenReview API.
	TokenReviewerJwt *string `json:"token-reviewer-jwt,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
	// Use the GW's service account
	UseGwServiceAccount *bool `json:"use-gw-service-account,omitempty"`
}

// NewGatewayCreateK8SAuthConfig instantiates a new GatewayCreateK8SAuthConfig object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewGatewayCreateK8SAuthConfig(accessId string, k8sHost string, name string, signingKey string, ) *GatewayCreateK8SAuthConfig {
	this := GatewayCreateK8SAuthConfig{}
	this.AccessId = accessId
	var clusterApiType string = "native_k8s"
	this.ClusterApiType = &clusterApiType
	var json bool = false
	this.Json = &json
	var k8sAuthType string = "token"
	this.K8sAuthType = &k8sAuthType
	this.K8sHost = k8sHost
	var k8sIssuer string = "kubernetes/serviceaccount"
	this.K8sIssuer = &k8sIssuer
	this.Name = name
	this.SigningKey = signingKey
	var tokenExp int64 = 300
	this.TokenExp = &tokenExp
	return &this
}

// NewGatewayCreateK8SAuthConfigWithDefaults instantiates a new GatewayCreateK8SAuthConfig object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewGatewayCreateK8SAuthConfigWithDefaults() *GatewayCreateK8SAuthConfig {
	this := GatewayCreateK8SAuthConfig{}
	var clusterApiType string = "native_k8s"
	this.ClusterApiType = &clusterApiType
	var json bool = false
	this.Json = &json
	var k8sAuthType string = "token"
	this.K8sAuthType = &k8sAuthType
	var k8sIssuer string = "kubernetes/serviceaccount"
	this.K8sIssuer = &k8sIssuer
	var tokenExp int64 = 300
	this.TokenExp = &tokenExp
	return &this
}

// GetAccessId returns the AccessId field value
func (o *GatewayCreateK8SAuthConfig) GetAccessId() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.AccessId
}

// GetAccessIdOk returns a tuple with the AccessId field value
// and a boolean to check if the value has been set.
func (o *GatewayCreateK8SAuthConfig) GetAccessIdOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.AccessId, true
}

// SetAccessId sets field value
func (o *GatewayCreateK8SAuthConfig) SetAccessId(v string) {
	o.AccessId = v
}

// GetClusterApiType returns the ClusterApiType field value if set, zero value otherwise.
func (o *GatewayCreateK8SAuthConfig) GetClusterApiType() string {
	if o == nil || o.ClusterApiType == nil {
		var ret string
		return ret
	}
	return *o.ClusterApiType
}

// GetClusterApiTypeOk returns a tuple with the ClusterApiType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayCreateK8SAuthConfig) GetClusterApiTypeOk() (*string, bool) {
	if o == nil || o.ClusterApiType == nil {
		return nil, false
	}
	return o.ClusterApiType, true
}

// HasClusterApiType returns a boolean if a field has been set.
func (o *GatewayCreateK8SAuthConfig) HasClusterApiType() bool {
	if o != nil && o.ClusterApiType != nil {
		return true
	}

	return false
}

// SetClusterApiType gets a reference to the given string and assigns it to the ClusterApiType field.
func (o *GatewayCreateK8SAuthConfig) SetClusterApiType(v string) {
	o.ClusterApiType = &v
}

// GetDisableIssuerValidation returns the DisableIssuerValidation field value if set, zero value otherwise.
func (o *GatewayCreateK8SAuthConfig) GetDisableIssuerValidation() string {
	if o == nil || o.DisableIssuerValidation == nil {
		var ret string
		return ret
	}
	return *o.DisableIssuerValidation
}

// GetDisableIssuerValidationOk returns a tuple with the DisableIssuerValidation field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayCreateK8SAuthConfig) GetDisableIssuerValidationOk() (*string, bool) {
	if o == nil || o.DisableIssuerValidation == nil {
		return nil, false
	}
	return o.DisableIssuerValidation, true
}

// HasDisableIssuerValidation returns a boolean if a field has been set.
func (o *GatewayCreateK8SAuthConfig) HasDisableIssuerValidation() bool {
	if o != nil && o.DisableIssuerValidation != nil {
		return true
	}

	return false
}

// SetDisableIssuerValidation gets a reference to the given string and assigns it to the DisableIssuerValidation field.
func (o *GatewayCreateK8SAuthConfig) SetDisableIssuerValidation(v string) {
	o.DisableIssuerValidation = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *GatewayCreateK8SAuthConfig) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayCreateK8SAuthConfig) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *GatewayCreateK8SAuthConfig) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *GatewayCreateK8SAuthConfig) SetJson(v bool) {
	o.Json = &v
}

// GetK8sAuthType returns the K8sAuthType field value if set, zero value otherwise.
func (o *GatewayCreateK8SAuthConfig) GetK8sAuthType() string {
	if o == nil || o.K8sAuthType == nil {
		var ret string
		return ret
	}
	return *o.K8sAuthType
}

// GetK8sAuthTypeOk returns a tuple with the K8sAuthType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayCreateK8SAuthConfig) GetK8sAuthTypeOk() (*string, bool) {
	if o == nil || o.K8sAuthType == nil {
		return nil, false
	}
	return o.K8sAuthType, true
}

// HasK8sAuthType returns a boolean if a field has been set.
func (o *GatewayCreateK8SAuthConfig) HasK8sAuthType() bool {
	if o != nil && o.K8sAuthType != nil {
		return true
	}

	return false
}

// SetK8sAuthType gets a reference to the given string and assigns it to the K8sAuthType field.
func (o *GatewayCreateK8SAuthConfig) SetK8sAuthType(v string) {
	o.K8sAuthType = &v
}

// GetK8sCaCert returns the K8sCaCert field value if set, zero value otherwise.
func (o *GatewayCreateK8SAuthConfig) GetK8sCaCert() string {
	if o == nil || o.K8sCaCert == nil {
		var ret string
		return ret
	}
	return *o.K8sCaCert
}

// GetK8sCaCertOk returns a tuple with the K8sCaCert field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayCreateK8SAuthConfig) GetK8sCaCertOk() (*string, bool) {
	if o == nil || o.K8sCaCert == nil {
		return nil, false
	}
	return o.K8sCaCert, true
}

// HasK8sCaCert returns a boolean if a field has been set.
func (o *GatewayCreateK8SAuthConfig) HasK8sCaCert() bool {
	if o != nil && o.K8sCaCert != nil {
		return true
	}

	return false
}

// SetK8sCaCert gets a reference to the given string and assigns it to the K8sCaCert field.
func (o *GatewayCreateK8SAuthConfig) SetK8sCaCert(v string) {
	o.K8sCaCert = &v
}

// GetK8sClientCertificate returns the K8sClientCertificate field value if set, zero value otherwise.
func (o *GatewayCreateK8SAuthConfig) GetK8sClientCertificate() string {
	if o == nil || o.K8sClientCertificate == nil {
		var ret string
		return ret
	}
	return *o.K8sClientCertificate
}

// GetK8sClientCertificateOk returns a tuple with the K8sClientCertificate field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayCreateK8SAuthConfig) GetK8sClientCertificateOk() (*string, bool) {
	if o == nil || o.K8sClientCertificate == nil {
		return nil, false
	}
	return o.K8sClientCertificate, true
}

// HasK8sClientCertificate returns a boolean if a field has been set.
func (o *GatewayCreateK8SAuthConfig) HasK8sClientCertificate() bool {
	if o != nil && o.K8sClientCertificate != nil {
		return true
	}

	return false
}

// SetK8sClientCertificate gets a reference to the given string and assigns it to the K8sClientCertificate field.
func (o *GatewayCreateK8SAuthConfig) SetK8sClientCertificate(v string) {
	o.K8sClientCertificate = &v
}

// GetK8sClientKey returns the K8sClientKey field value if set, zero value otherwise.
func (o *GatewayCreateK8SAuthConfig) GetK8sClientKey() string {
	if o == nil || o.K8sClientKey == nil {
		var ret string
		return ret
	}
	return *o.K8sClientKey
}

// GetK8sClientKeyOk returns a tuple with the K8sClientKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayCreateK8SAuthConfig) GetK8sClientKeyOk() (*string, bool) {
	if o == nil || o.K8sClientKey == nil {
		return nil, false
	}
	return o.K8sClientKey, true
}

// HasK8sClientKey returns a boolean if a field has been set.
func (o *GatewayCreateK8SAuthConfig) HasK8sClientKey() bool {
	if o != nil && o.K8sClientKey != nil {
		return true
	}

	return false
}

// SetK8sClientKey gets a reference to the given string and assigns it to the K8sClientKey field.
func (o *GatewayCreateK8SAuthConfig) SetK8sClientKey(v string) {
	o.K8sClientKey = &v
}

// GetK8sHost returns the K8sHost field value
func (o *GatewayCreateK8SAuthConfig) GetK8sHost() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.K8sHost
}

// GetK8sHostOk returns a tuple with the K8sHost field value
// and a boolean to check if the value has been set.
func (o *GatewayCreateK8SAuthConfig) GetK8sHostOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.K8sHost, true
}

// SetK8sHost sets field value
func (o *GatewayCreateK8SAuthConfig) SetK8sHost(v string) {
	o.K8sHost = v
}

// GetK8sIssuer returns the K8sIssuer field value if set, zero value otherwise.
func (o *GatewayCreateK8SAuthConfig) GetK8sIssuer() string {
	if o == nil || o.K8sIssuer == nil {
		var ret string
		return ret
	}
	return *o.K8sIssuer
}

// GetK8sIssuerOk returns a tuple with the K8sIssuer field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayCreateK8SAuthConfig) GetK8sIssuerOk() (*string, bool) {
	if o == nil || o.K8sIssuer == nil {
		return nil, false
	}
	return o.K8sIssuer, true
}

// HasK8sIssuer returns a boolean if a field has been set.
func (o *GatewayCreateK8SAuthConfig) HasK8sIssuer() bool {
	if o != nil && o.K8sIssuer != nil {
		return true
	}

	return false
}

// SetK8sIssuer gets a reference to the given string and assigns it to the K8sIssuer field.
func (o *GatewayCreateK8SAuthConfig) SetK8sIssuer(v string) {
	o.K8sIssuer = &v
}

// GetName returns the Name field value
func (o *GatewayCreateK8SAuthConfig) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *GatewayCreateK8SAuthConfig) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *GatewayCreateK8SAuthConfig) SetName(v string) {
	o.Name = v
}

// GetRancherApiKey returns the RancherApiKey field value if set, zero value otherwise.
func (o *GatewayCreateK8SAuthConfig) GetRancherApiKey() string {
	if o == nil || o.RancherApiKey == nil {
		var ret string
		return ret
	}
	return *o.RancherApiKey
}

// GetRancherApiKeyOk returns a tuple with the RancherApiKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayCreateK8SAuthConfig) GetRancherApiKeyOk() (*string, bool) {
	if o == nil || o.RancherApiKey == nil {
		return nil, false
	}
	return o.RancherApiKey, true
}

// HasRancherApiKey returns a boolean if a field has been set.
func (o *GatewayCreateK8SAuthConfig) HasRancherApiKey() bool {
	if o != nil && o.RancherApiKey != nil {
		return true
	}

	return false
}

// SetRancherApiKey gets a reference to the given string and assigns it to the RancherApiKey field.
func (o *GatewayCreateK8SAuthConfig) SetRancherApiKey(v string) {
	o.RancherApiKey = &v
}

// GetRancherClusterId returns the RancherClusterId field value if set, zero value otherwise.
func (o *GatewayCreateK8SAuthConfig) GetRancherClusterId() string {
	if o == nil || o.RancherClusterId == nil {
		var ret string
		return ret
	}
	return *o.RancherClusterId
}

// GetRancherClusterIdOk returns a tuple with the RancherClusterId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayCreateK8SAuthConfig) GetRancherClusterIdOk() (*string, bool) {
	if o == nil || o.RancherClusterId == nil {
		return nil, false
	}
	return o.RancherClusterId, true
}

// HasRancherClusterId returns a boolean if a field has been set.
func (o *GatewayCreateK8SAuthConfig) HasRancherClusterId() bool {
	if o != nil && o.RancherClusterId != nil {
		return true
	}

	return false
}

// SetRancherClusterId gets a reference to the given string and assigns it to the RancherClusterId field.
func (o *GatewayCreateK8SAuthConfig) SetRancherClusterId(v string) {
	o.RancherClusterId = &v
}

// GetSigningKey returns the SigningKey field value
func (o *GatewayCreateK8SAuthConfig) GetSigningKey() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.SigningKey
}

// GetSigningKeyOk returns a tuple with the SigningKey field value
// and a boolean to check if the value has been set.
func (o *GatewayCreateK8SAuthConfig) GetSigningKeyOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.SigningKey, true
}

// SetSigningKey sets field value
func (o *GatewayCreateK8SAuthConfig) SetSigningKey(v string) {
	o.SigningKey = v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *GatewayCreateK8SAuthConfig) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayCreateK8SAuthConfig) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *GatewayCreateK8SAuthConfig) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *GatewayCreateK8SAuthConfig) SetToken(v string) {
	o.Token = &v
}

// GetTokenExp returns the TokenExp field value if set, zero value otherwise.
func (o *GatewayCreateK8SAuthConfig) GetTokenExp() int64 {
	if o == nil || o.TokenExp == nil {
		var ret int64
		return ret
	}
	return *o.TokenExp
}

// GetTokenExpOk returns a tuple with the TokenExp field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayCreateK8SAuthConfig) GetTokenExpOk() (*int64, bool) {
	if o == nil || o.TokenExp == nil {
		return nil, false
	}
	return o.TokenExp, true
}

// HasTokenExp returns a boolean if a field has been set.
func (o *GatewayCreateK8SAuthConfig) HasTokenExp() bool {
	if o != nil && o.TokenExp != nil {
		return true
	}

	return false
}

// SetTokenExp gets a reference to the given int64 and assigns it to the TokenExp field.
func (o *GatewayCreateK8SAuthConfig) SetTokenExp(v int64) {
	o.TokenExp = &v
}

// GetTokenReviewerJwt returns the TokenReviewerJwt field value if set, zero value otherwise.
func (o *GatewayCreateK8SAuthConfig) GetTokenReviewerJwt() string {
	if o == nil || o.TokenReviewerJwt == nil {
		var ret string
		return ret
	}
	return *o.TokenReviewerJwt
}

// GetTokenReviewerJwtOk returns a tuple with the TokenReviewerJwt field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayCreateK8SAuthConfig) GetTokenReviewerJwtOk() (*string, bool) {
	if o == nil || o.TokenReviewerJwt == nil {
		return nil, false
	}
	return o.TokenReviewerJwt, true
}

// HasTokenReviewerJwt returns a boolean if a field has been set.
func (o *GatewayCreateK8SAuthConfig) HasTokenReviewerJwt() bool {
	if o != nil && o.TokenReviewerJwt != nil {
		return true
	}

	return false
}

// SetTokenReviewerJwt gets a reference to the given string and assigns it to the TokenReviewerJwt field.
func (o *GatewayCreateK8SAuthConfig) SetTokenReviewerJwt(v string) {
	o.TokenReviewerJwt = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *GatewayCreateK8SAuthConfig) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayCreateK8SAuthConfig) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *GatewayCreateK8SAuthConfig) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *GatewayCreateK8SAuthConfig) SetUidToken(v string) {
	o.UidToken = &v
}

// GetUseGwServiceAccount returns the UseGwServiceAccount field value if set, zero value otherwise.
func (o *GatewayCreateK8SAuthConfig) GetUseGwServiceAccount() bool {
	if o == nil || o.UseGwServiceAccount == nil {
		var ret bool
		return ret
	}
	return *o.UseGwServiceAccount
}

// GetUseGwServiceAccountOk returns a tuple with the UseGwServiceAccount field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayCreateK8SAuthConfig) GetUseGwServiceAccountOk() (*bool, bool) {
	if o == nil || o.UseGwServiceAccount == nil {
		return nil, false
	}
	return o.UseGwServiceAccount, true
}

// HasUseGwServiceAccount returns a boolean if a field has been set.
func (o *GatewayCreateK8SAuthConfig) HasUseGwServiceAccount() bool {
	if o != nil && o.UseGwServiceAccount != nil {
		return true
	}

	return false
}

// SetUseGwServiceAccount gets a reference to the given bool and assigns it to the UseGwServiceAccount field.
func (o *GatewayCreateK8SAuthConfig) SetUseGwServiceAccount(v bool) {
	o.UseGwServiceAccount = &v
}

func (o GatewayCreateK8SAuthConfig) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if true {
		toSerialize["access-id"] = o.AccessId
	}
	if o.ClusterApiType != nil {
		toSerialize["cluster-api-type"] = o.ClusterApiType
	}
	if o.DisableIssuerValidation != nil {
		toSerialize["disable-issuer-validation"] = o.DisableIssuerValidation
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.K8sAuthType != nil {
		toSerialize["k8s-auth-type"] = o.K8sAuthType
	}
	if o.K8sCaCert != nil {
		toSerialize["k8s-ca-cert"] = o.K8sCaCert
	}
	if o.K8sClientCertificate != nil {
		toSerialize["k8s-client-certificate"] = o.K8sClientCertificate
	}
	if o.K8sClientKey != nil {
		toSerialize["k8s-client-key"] = o.K8sClientKey
	}
	if true {
		toSerialize["k8s-host"] = o.K8sHost
	}
	if o.K8sIssuer != nil {
		toSerialize["k8s-issuer"] = o.K8sIssuer
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.RancherApiKey != nil {
		toSerialize["rancher-api-key"] = o.RancherApiKey
	}
	if o.RancherClusterId != nil {
		toSerialize["rancher-cluster-id"] = o.RancherClusterId
	}
	if true {
		toSerialize["signing-key"] = o.SigningKey
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.TokenExp != nil {
		toSerialize["token-exp"] = o.TokenExp
	}
	if o.TokenReviewerJwt != nil {
		toSerialize["token-reviewer-jwt"] = o.TokenReviewerJwt
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	if o.UseGwServiceAccount != nil {
		toSerialize["use-gw-service-account"] = o.UseGwServiceAccount
	}
	return json.Marshal(toSerialize)
}

type NullableGatewayCreateK8SAuthConfig struct {
	value *GatewayCreateK8SAuthConfig
	isSet bool
}

func (v NullableGatewayCreateK8SAuthConfig) Get() *GatewayCreateK8SAuthConfig {
	return v.value
}

func (v *NullableGatewayCreateK8SAuthConfig) Set(val *GatewayCreateK8SAuthConfig) {
	v.value = val
	v.isSet = true
}

func (v NullableGatewayCreateK8SAuthConfig) IsSet() bool {
	return v.isSet
}

func (v *NullableGatewayCreateK8SAuthConfig) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableGatewayCreateK8SAuthConfig(val *GatewayCreateK8SAuthConfig) *NullableGatewayCreateK8SAuthConfig {
	return &NullableGatewayCreateK8SAuthConfig{value: val, isSet: true}
}

func (v NullableGatewayCreateK8SAuthConfig) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableGatewayCreateK8SAuthConfig) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


