/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// GatewayUpdateMigration gatewayUpdateMigration is a command that update migration
type GatewayUpdateMigration struct {
	// 1Password user email to connect to the API
	Var1passwordEmail *string `json:"1password-email,omitempty"`
	// 1Password user password to connect to the API
	Var1passwordPassword *string `json:"1password-password,omitempty"`
	// 1Password user secret key to connect to the API
	Var1passwordSecretKey *string `json:"1password-secret-key,omitempty"`
	// 1Password api container url
	Var1passwordUrl *string `json:"1password-url,omitempty"`
	// 1Password list of vault to get the items from
	Var1passwordVaults *[]string `json:"1password-vaults,omitempty"`
	ServiceAccountKeyDecoded *string `json:"ServiceAccountKeyDecoded,omitempty"`
	// Enable/Disable discovery of Windows services from each domain server as part of the SSH/Windows Rotated Secrets. Default is false. (Relevant only for Active Directory migration)
	AdDiscoverServices *string `json:"ad-discover-services,omitempty"`
	// Set migration discovery types (domain-users, computers, local-users). (Relevant only for Active Directory migration)
	AdDiscoveryTypes *[]string `json:"ad-discovery-types,omitempty"`
	// Filter by Operating System to run the migration, can be used with wildcards, e.g. SRV20* (Relevant only for Active Directory migration)
	AdOsFilter *string `json:"ad-os-filter,omitempty"`
	// Set the SSH Port for further connection to the domain servers. Default is port 22 (Relevant only for Active Directory migration)
	AdSshPort *string `json:"ad-ssh-port,omitempty"`
	// Relevant only for ad-discovery-types=computers. For linked, all computers will be migrated into a linked target(s). if set with regular, the migration will create a target for each computer.
	AdTargetFormat *string `json:"ad-target-format,omitempty"`
	// Set the target type of the domain servers [ssh/windows](Relevant only for Active Directory migration)
	AdTargetsType *string `json:"ad-targets-type,omitempty"`
	// Use WinRM over HTTP, by default runs over HTTPS
	AdWinrmOverHttp *string `json:"ad-winrm-over-http,omitempty"`
	// Set the WinRM Port for further connection to the domain servers. Default is 5986 (Relevant only for Active Directory migration)
	AdWinrmPort *string `json:"ad-winrm-port,omitempty"`
	// Enable/Disable automatic/recurrent rotation for migrated secrets. Default is false: only manual rotation is allowed for migrated secrets. If set to true, this command should be combined with --ad-rotation-interval and --ad-rotation-hour parameters (Relevant only for Active Directory migration)
	AdAutoRotate *string `json:"ad_auto_rotate,omitempty"`
	// Distinguished Name of Computer objects (servers) to search in Active Directory e.g.: CN=Computers,DC=example,DC=com (Relevant only for Active Directory migration)
	AdComputerBaseDn *string `json:"ad_computer_base_dn,omitempty"`
	// Enable/Disable discovery of local users from each domain server and migrate them as SSH/Windows Rotated Secrets. Default is false: only domain users will be migrated. Discovery of local users might require further installation of SSH on the servers, based on the supplied computer base DN. This will be implemented automatically as part of the migration process (Relevant only for Active Directory migration) Deprecated: use AdDiscoverTypes
	AdDiscoverLocalUsers *string `json:"ad_discover_local_users,omitempty"`
	// Active Directory Domain Name (Relevant only for Active Directory migration)
	AdDomainName *string `json:"ad_domain_name,omitempty"`
	// Path location template for migrating domain users as Rotated Secrets e.g.: .../DomainUsers/{{USERNAME}} (Relevant only for Active Directory migration)
	AdDomainUsersPathTemplate *string `json:"ad_domain_users_path_template,omitempty"`
	// Comma-separated list of Local Users which should not be migrated (Relevant only for Active Directory migration)
	AdLocalUsersIgnore *string `json:"ad_local_users_ignore,omitempty"`
	// Path location template for migrating domain users as Rotated Secrets e.g.: .../LocalUsers/{{COMPUTER_NAME}}/{{USERNAME}} (Relevant only for Active Directory migration)
	AdLocalUsersPathTemplate *string `json:"ad_local_users_path_template,omitempty"`
	// The hour of the scheduled rotation in UTC (Relevant only for Active Directory migration)
	AdRotationHour *int32 `json:"ad_rotation_hour,omitempty"`
	// The number of days to wait between every automatic rotation [1-365] (Relevant only for Active Directory migration)
	AdRotationInterval *int32 `json:"ad_rotation_interval,omitempty"`
	// Enable/Disable RDP Secure Remote Access for the migrated local users rotated secrets. Default is false: rotated secrets will not be created with SRA (Relevant only for Active Directory migration)
	AdSraEnableRdp *string `json:"ad_sra_enable_rdp,omitempty"`
	// Active Directory LDAP Target Name. Server type should be Active Directory (Relevant only for Active Directory migration)
	AdTargetName *string `json:"ad_target_name,omitempty"`
	// Path location template for migrating domain servers as SSH/Windows Targets e.g.: .../Servers/{{COMPUTER_NAME}} (Relevant only for Active Directory migration)
	AdTargetsPathTemplate *string `json:"ad_targets_path_template,omitempty"`
	// Distinguished Name of User objects to search in Active Directory, e.g.: CN=Users,DC=example,DC=com (Relevant only for Active Directory migration)
	AdUserBaseDn *string `json:"ad_user_base_dn,omitempty"`
	// Comma-separated list of domain groups from which privileged domain users will be migrated. If empty, migrate all users based on the --ad-user-base-dn (Relevant only for Active Directory migration)
	AdUserGroups *string `json:"ad_user_groups,omitempty"`
	// AWS Secret Access Key (relevant only for AWS migration)
	AwsKey *string `json:"aws-key,omitempty"`
	// AWS Access Key ID with sufficient permissions to get all secrets, e.g. 'arn:aws:secretsmanager:[Region]:[AccountId]:secret:[/path/to/secrets/_*]' (relevant only for AWS migration)
	AwsKeyId *string `json:"aws-key-id,omitempty"`
	// AWS region of the required Secrets Manager (relevant only for AWS migration)
	AwsRegion *string `json:"aws-region,omitempty"`
	// Azure Key Vault Access client ID, should be Azure AD App with a service principal (relevant only for Azure Key Vault migration)
	AzureClientId *string `json:"azure-client-id,omitempty"`
	// Azure Key Vault Name (relevant only for Azure Key Vault migration)
	AzureKvName *string `json:"azure-kv-name,omitempty"`
	// Azure Key Vault secret (relevant only for Azure Key Vault migration)
	AzureSecret *string `json:"azure-secret,omitempty"`
	// Azure Key Vault Access tenant ID (relevant only for Azure Key Vault migration)
	AzureTenantId *string `json:"azure-tenant-id,omitempty"`
	// Base64-encoded GCP Service Account private key text with sufficient permissions to Secrets Manager, Minimum required permission is Secret Manager Secret Accessor, e.g. 'roles/secretmanager.secretAccessor' (relevant only for GCP migration)
	GcpKey *string `json:"gcp-key,omitempty"`
	// Import secret key as json value or independent secrets (relevant only for HasiCorp Vault migration) [true/false]
	HashiJson *string `json:"hashi-json,omitempty"`
	// HashiCorp Vault Namespaces is a comma-separated list of namespaces which need to be imported into Akeyless Vault. For every provided namespace, all its child namespaces are imported as well, e.g. nmsp/subnmsp1/subnmsp2,nmsp/anothernmsp. By default, import all namespaces (relevant only for HasiCorp Vault migration)
	HashiNs *[]string `json:"hashi-ns,omitempty"`
	// HashiCorp Vault access token with sufficient permissions to preform list & read operations on secrets objects (relevant only for HasiCorp Vault migration)
	HashiToken *string `json:"hashi-token,omitempty"`
	// HashiCorp Vault API URL, e.g. https://vault-mgr01:8200 (relevant only for HasiCorp Vault migration)
	HashiUrl *string `json:"hashi-url,omitempty"`
	// Migration ID (Can be retrieved with gateway-list-migration command)
	Id *string `json:"id,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// For Certificate Authentication method K8s Cluster CA certificate (relevant only for K8s migration with Certificate Authentication method)
	K8sCaCertificate *[]int32 `json:"k8s-ca-certificate,omitempty"`
	// K8s Client certificate with sufficient permission to list and get secrets in the namespace(s) you selected (relevant only for K8s migration with Certificate Authentication method)
	K8sClientCertificate *[]int32 `json:"k8s-client-certificate,omitempty"`
	// K8s Client key (relevant only for K8s migration with Certificate Authentication method)
	K8sClientKey *[]int32 `json:"k8s-client-key,omitempty"`
	// K8s Namespace, Use this field to import secrets from a particular namespace only. By default, the secrets are imported from all namespaces (relevant only for K8s migration)
	K8sNamespace *string `json:"k8s-namespace,omitempty"`
	// K8s Client password (relevant only for K8s migration with Password Authentication method)
	K8sPassword *string `json:"k8s-password,omitempty"`
	// K8s Skip Control Plane Secrets, This option allows to avoid importing secrets from system namespaces (relevant only for K8s migration)
	K8sSkipSystem *bool `json:"k8s-skip-system,omitempty"`
	// For Token Authentication method K8s Bearer Token with sufficient permission to list and get secrets in the namespace(s) you selected (relevant only for K8s migration with Token Authentication method)
	K8sToken *string `json:"k8s-token,omitempty"`
	// K8s API Server URL, e.g. https://k8s-api.mycompany.com:6443 (relevant only for K8s migration)
	K8sUrl *string `json:"k8s-url,omitempty"`
	// For Password Authentication method K8s Client username with sufficient permission to list and get secrets in the namespace(s) you selected (relevant only for K8s migration with Password Authentication method)
	K8sUsername *string `json:"k8s-username,omitempty"`
	// Migration name
	Name *string `json:"name,omitempty"`
	// New migration name
	NewName *string `json:"new_name,omitempty"`
	// The name of the key that protects the classic key value (if empty, the account default key will be used)
	ProtectionKey *string `json:"protection-key,omitempty"`
	// Enable/Disable automatic/recurrent rotation for migrated secrets. Default is false: only manual rotation is allowed for migrated secrets. If set to true, this command should be combined with --si-rotation-interval and --si-rotation-hour parameters (Relevant only for Server Inventory migration)
	SiAutoRotate *string `json:"si-auto-rotate,omitempty"`
	// The hour of the scheduled rotation in UTC (Relevant only for Server Inventory migration)
	SiRotationHour *int32 `json:"si-rotation-hour,omitempty"`
	// The number of days to wait between every automatic rotation [1-365] (Relevant only for Server Inventory migration)
	SiRotationInterval *int32 `json:"si-rotation-interval,omitempty"`
	// Enable/Disable RDP Secure Remote Access for the migrated local users rotated secrets. Default is false: rotated secrets will not be created with SRA (Relevant only for Server Inventory migration)
	SiSraEnableRdp *string `json:"si-sra-enable-rdp,omitempty"`
	// SSH, Windows or Linked Target Name. (Relevant only for Server Inventory migration)
	SiTargetName string `json:"si-target-name"`
	// Comma-separated list of groups to migrate users from. If empty, all users from all groups will be migrated (Relevant only for Server Inventory migration)
	SiUserGroups *string `json:"si-user-groups,omitempty"`
	// Comma-separated list of Local Users which should not be migrated (Relevant only for Server Inventory migration)
	SiUsersIgnore *string `json:"si-users-ignore,omitempty"`
	// Path location template for migrating users as Rotated Secrets e.g.: .../Users/{{COMPUTER_NAME}}/{{USERNAME}} (Relevant only for Server Inventory migration)
	SiUsersPathTemplate string `json:"si-users-path-template"`
	// Target location in Akeyless for imported secrets
	TargetLocation string `json:"target-location"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewGatewayUpdateMigration instantiates a new GatewayUpdateMigration object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewGatewayUpdateMigration(siTargetName string, siUsersPathTemplate string, targetLocation string, ) *GatewayUpdateMigration {
	this := GatewayUpdateMigration{}
	var adDiscoverServices string = "false"
	this.AdDiscoverServices = &adDiscoverServices
	var adSshPort string = "22"
	this.AdSshPort = &adSshPort
	var adTargetFormat string = "linked"
	this.AdTargetFormat = &adTargetFormat
	var adTargetsType string = "windows"
	this.AdTargetsType = &adTargetsType
	var adWinrmOverHttp string = "false"
	this.AdWinrmOverHttp = &adWinrmOverHttp
	var adWinrmPort string = "5986"
	this.AdWinrmPort = &adWinrmPort
	var awsRegion string = "us-east-2"
	this.AwsRegion = &awsRegion
	var hashiJson string = "true"
	this.HashiJson = &hashiJson
	var json bool = false
	this.Json = &json
	var siSraEnableRdp string = "false"
	this.SiSraEnableRdp = &siSraEnableRdp
	this.SiTargetName = siTargetName
	this.SiUsersPathTemplate = siUsersPathTemplate
	this.TargetLocation = targetLocation
	return &this
}

// NewGatewayUpdateMigrationWithDefaults instantiates a new GatewayUpdateMigration object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewGatewayUpdateMigrationWithDefaults() *GatewayUpdateMigration {
	this := GatewayUpdateMigration{}
	var adDiscoverServices string = "false"
	this.AdDiscoverServices = &adDiscoverServices
	var adSshPort string = "22"
	this.AdSshPort = &adSshPort
	var adTargetFormat string = "linked"
	this.AdTargetFormat = &adTargetFormat
	var adTargetsType string = "windows"
	this.AdTargetsType = &adTargetsType
	var adWinrmOverHttp string = "false"
	this.AdWinrmOverHttp = &adWinrmOverHttp
	var adWinrmPort string = "5986"
	this.AdWinrmPort = &adWinrmPort
	var awsRegion string = "us-east-2"
	this.AwsRegion = &awsRegion
	var hashiJson string = "true"
	this.HashiJson = &hashiJson
	var json bool = false
	this.Json = &json
	var siSraEnableRdp string = "false"
	this.SiSraEnableRdp = &siSraEnableRdp
	return &this
}

// GetVar1passwordEmail returns the Var1passwordEmail field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetVar1passwordEmail() string {
	if o == nil || o.Var1passwordEmail == nil {
		var ret string
		return ret
	}
	return *o.Var1passwordEmail
}

// GetVar1passwordEmailOk returns a tuple with the Var1passwordEmail field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetVar1passwordEmailOk() (*string, bool) {
	if o == nil || o.Var1passwordEmail == nil {
		return nil, false
	}
	return o.Var1passwordEmail, true
}

// HasVar1passwordEmail returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasVar1passwordEmail() bool {
	if o != nil && o.Var1passwordEmail != nil {
		return true
	}

	return false
}

// SetVar1passwordEmail gets a reference to the given string and assigns it to the Var1passwordEmail field.
func (o *GatewayUpdateMigration) SetVar1passwordEmail(v string) {
	o.Var1passwordEmail = &v
}

// GetVar1passwordPassword returns the Var1passwordPassword field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetVar1passwordPassword() string {
	if o == nil || o.Var1passwordPassword == nil {
		var ret string
		return ret
	}
	return *o.Var1passwordPassword
}

// GetVar1passwordPasswordOk returns a tuple with the Var1passwordPassword field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetVar1passwordPasswordOk() (*string, bool) {
	if o == nil || o.Var1passwordPassword == nil {
		return nil, false
	}
	return o.Var1passwordPassword, true
}

// HasVar1passwordPassword returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasVar1passwordPassword() bool {
	if o != nil && o.Var1passwordPassword != nil {
		return true
	}

	return false
}

// SetVar1passwordPassword gets a reference to the given string and assigns it to the Var1passwordPassword field.
func (o *GatewayUpdateMigration) SetVar1passwordPassword(v string) {
	o.Var1passwordPassword = &v
}

// GetVar1passwordSecretKey returns the Var1passwordSecretKey field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetVar1passwordSecretKey() string {
	if o == nil || o.Var1passwordSecretKey == nil {
		var ret string
		return ret
	}
	return *o.Var1passwordSecretKey
}

// GetVar1passwordSecretKeyOk returns a tuple with the Var1passwordSecretKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetVar1passwordSecretKeyOk() (*string, bool) {
	if o == nil || o.Var1passwordSecretKey == nil {
		return nil, false
	}
	return o.Var1passwordSecretKey, true
}

// HasVar1passwordSecretKey returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasVar1passwordSecretKey() bool {
	if o != nil && o.Var1passwordSecretKey != nil {
		return true
	}

	return false
}

// SetVar1passwordSecretKey gets a reference to the given string and assigns it to the Var1passwordSecretKey field.
func (o *GatewayUpdateMigration) SetVar1passwordSecretKey(v string) {
	o.Var1passwordSecretKey = &v
}

// GetVar1passwordUrl returns the Var1passwordUrl field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetVar1passwordUrl() string {
	if o == nil || o.Var1passwordUrl == nil {
		var ret string
		return ret
	}
	return *o.Var1passwordUrl
}

// GetVar1passwordUrlOk returns a tuple with the Var1passwordUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetVar1passwordUrlOk() (*string, bool) {
	if o == nil || o.Var1passwordUrl == nil {
		return nil, false
	}
	return o.Var1passwordUrl, true
}

// HasVar1passwordUrl returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasVar1passwordUrl() bool {
	if o != nil && o.Var1passwordUrl != nil {
		return true
	}

	return false
}

// SetVar1passwordUrl gets a reference to the given string and assigns it to the Var1passwordUrl field.
func (o *GatewayUpdateMigration) SetVar1passwordUrl(v string) {
	o.Var1passwordUrl = &v
}

// GetVar1passwordVaults returns the Var1passwordVaults field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetVar1passwordVaults() []string {
	if o == nil || o.Var1passwordVaults == nil {
		var ret []string
		return ret
	}
	return *o.Var1passwordVaults
}

// GetVar1passwordVaultsOk returns a tuple with the Var1passwordVaults field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetVar1passwordVaultsOk() (*[]string, bool) {
	if o == nil || o.Var1passwordVaults == nil {
		return nil, false
	}
	return o.Var1passwordVaults, true
}

// HasVar1passwordVaults returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasVar1passwordVaults() bool {
	if o != nil && o.Var1passwordVaults != nil {
		return true
	}

	return false
}

// SetVar1passwordVaults gets a reference to the given []string and assigns it to the Var1passwordVaults field.
func (o *GatewayUpdateMigration) SetVar1passwordVaults(v []string) {
	o.Var1passwordVaults = &v
}

// GetServiceAccountKeyDecoded returns the ServiceAccountKeyDecoded field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetServiceAccountKeyDecoded() string {
	if o == nil || o.ServiceAccountKeyDecoded == nil {
		var ret string
		return ret
	}
	return *o.ServiceAccountKeyDecoded
}

// GetServiceAccountKeyDecodedOk returns a tuple with the ServiceAccountKeyDecoded field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetServiceAccountKeyDecodedOk() (*string, bool) {
	if o == nil || o.ServiceAccountKeyDecoded == nil {
		return nil, false
	}
	return o.ServiceAccountKeyDecoded, true
}

// HasServiceAccountKeyDecoded returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasServiceAccountKeyDecoded() bool {
	if o != nil && o.ServiceAccountKeyDecoded != nil {
		return true
	}

	return false
}

// SetServiceAccountKeyDecoded gets a reference to the given string and assigns it to the ServiceAccountKeyDecoded field.
func (o *GatewayUpdateMigration) SetServiceAccountKeyDecoded(v string) {
	o.ServiceAccountKeyDecoded = &v
}

// GetAdDiscoverServices returns the AdDiscoverServices field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetAdDiscoverServices() string {
	if o == nil || o.AdDiscoverServices == nil {
		var ret string
		return ret
	}
	return *o.AdDiscoverServices
}

// GetAdDiscoverServicesOk returns a tuple with the AdDiscoverServices field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetAdDiscoverServicesOk() (*string, bool) {
	if o == nil || o.AdDiscoverServices == nil {
		return nil, false
	}
	return o.AdDiscoverServices, true
}

// HasAdDiscoverServices returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasAdDiscoverServices() bool {
	if o != nil && o.AdDiscoverServices != nil {
		return true
	}

	return false
}

// SetAdDiscoverServices gets a reference to the given string and assigns it to the AdDiscoverServices field.
func (o *GatewayUpdateMigration) SetAdDiscoverServices(v string) {
	o.AdDiscoverServices = &v
}

// GetAdDiscoveryTypes returns the AdDiscoveryTypes field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetAdDiscoveryTypes() []string {
	if o == nil || o.AdDiscoveryTypes == nil {
		var ret []string
		return ret
	}
	return *o.AdDiscoveryTypes
}

// GetAdDiscoveryTypesOk returns a tuple with the AdDiscoveryTypes field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetAdDiscoveryTypesOk() (*[]string, bool) {
	if o == nil || o.AdDiscoveryTypes == nil {
		return nil, false
	}
	return o.AdDiscoveryTypes, true
}

// HasAdDiscoveryTypes returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasAdDiscoveryTypes() bool {
	if o != nil && o.AdDiscoveryTypes != nil {
		return true
	}

	return false
}

// SetAdDiscoveryTypes gets a reference to the given []string and assigns it to the AdDiscoveryTypes field.
func (o *GatewayUpdateMigration) SetAdDiscoveryTypes(v []string) {
	o.AdDiscoveryTypes = &v
}

// GetAdOsFilter returns the AdOsFilter field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetAdOsFilter() string {
	if o == nil || o.AdOsFilter == nil {
		var ret string
		return ret
	}
	return *o.AdOsFilter
}

// GetAdOsFilterOk returns a tuple with the AdOsFilter field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetAdOsFilterOk() (*string, bool) {
	if o == nil || o.AdOsFilter == nil {
		return nil, false
	}
	return o.AdOsFilter, true
}

// HasAdOsFilter returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasAdOsFilter() bool {
	if o != nil && o.AdOsFilter != nil {
		return true
	}

	return false
}

// SetAdOsFilter gets a reference to the given string and assigns it to the AdOsFilter field.
func (o *GatewayUpdateMigration) SetAdOsFilter(v string) {
	o.AdOsFilter = &v
}

// GetAdSshPort returns the AdSshPort field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetAdSshPort() string {
	if o == nil || o.AdSshPort == nil {
		var ret string
		return ret
	}
	return *o.AdSshPort
}

// GetAdSshPortOk returns a tuple with the AdSshPort field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetAdSshPortOk() (*string, bool) {
	if o == nil || o.AdSshPort == nil {
		return nil, false
	}
	return o.AdSshPort, true
}

// HasAdSshPort returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasAdSshPort() bool {
	if o != nil && o.AdSshPort != nil {
		return true
	}

	return false
}

// SetAdSshPort gets a reference to the given string and assigns it to the AdSshPort field.
func (o *GatewayUpdateMigration) SetAdSshPort(v string) {
	o.AdSshPort = &v
}

// GetAdTargetFormat returns the AdTargetFormat field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetAdTargetFormat() string {
	if o == nil || o.AdTargetFormat == nil {
		var ret string
		return ret
	}
	return *o.AdTargetFormat
}

// GetAdTargetFormatOk returns a tuple with the AdTargetFormat field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetAdTargetFormatOk() (*string, bool) {
	if o == nil || o.AdTargetFormat == nil {
		return nil, false
	}
	return o.AdTargetFormat, true
}

// HasAdTargetFormat returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasAdTargetFormat() bool {
	if o != nil && o.AdTargetFormat != nil {
		return true
	}

	return false
}

// SetAdTargetFormat gets a reference to the given string and assigns it to the AdTargetFormat field.
func (o *GatewayUpdateMigration) SetAdTargetFormat(v string) {
	o.AdTargetFormat = &v
}

// GetAdTargetsType returns the AdTargetsType field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetAdTargetsType() string {
	if o == nil || o.AdTargetsType == nil {
		var ret string
		return ret
	}
	return *o.AdTargetsType
}

// GetAdTargetsTypeOk returns a tuple with the AdTargetsType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetAdTargetsTypeOk() (*string, bool) {
	if o == nil || o.AdTargetsType == nil {
		return nil, false
	}
	return o.AdTargetsType, true
}

// HasAdTargetsType returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasAdTargetsType() bool {
	if o != nil && o.AdTargetsType != nil {
		return true
	}

	return false
}

// SetAdTargetsType gets a reference to the given string and assigns it to the AdTargetsType field.
func (o *GatewayUpdateMigration) SetAdTargetsType(v string) {
	o.AdTargetsType = &v
}

// GetAdWinrmOverHttp returns the AdWinrmOverHttp field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetAdWinrmOverHttp() string {
	if o == nil || o.AdWinrmOverHttp == nil {
		var ret string
		return ret
	}
	return *o.AdWinrmOverHttp
}

// GetAdWinrmOverHttpOk returns a tuple with the AdWinrmOverHttp field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetAdWinrmOverHttpOk() (*string, bool) {
	if o == nil || o.AdWinrmOverHttp == nil {
		return nil, false
	}
	return o.AdWinrmOverHttp, true
}

// HasAdWinrmOverHttp returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasAdWinrmOverHttp() bool {
	if o != nil && o.AdWinrmOverHttp != nil {
		return true
	}

	return false
}

// SetAdWinrmOverHttp gets a reference to the given string and assigns it to the AdWinrmOverHttp field.
func (o *GatewayUpdateMigration) SetAdWinrmOverHttp(v string) {
	o.AdWinrmOverHttp = &v
}

// GetAdWinrmPort returns the AdWinrmPort field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetAdWinrmPort() string {
	if o == nil || o.AdWinrmPort == nil {
		var ret string
		return ret
	}
	return *o.AdWinrmPort
}

// GetAdWinrmPortOk returns a tuple with the AdWinrmPort field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetAdWinrmPortOk() (*string, bool) {
	if o == nil || o.AdWinrmPort == nil {
		return nil, false
	}
	return o.AdWinrmPort, true
}

// HasAdWinrmPort returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasAdWinrmPort() bool {
	if o != nil && o.AdWinrmPort != nil {
		return true
	}

	return false
}

// SetAdWinrmPort gets a reference to the given string and assigns it to the AdWinrmPort field.
func (o *GatewayUpdateMigration) SetAdWinrmPort(v string) {
	o.AdWinrmPort = &v
}

// GetAdAutoRotate returns the AdAutoRotate field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetAdAutoRotate() string {
	if o == nil || o.AdAutoRotate == nil {
		var ret string
		return ret
	}
	return *o.AdAutoRotate
}

// GetAdAutoRotateOk returns a tuple with the AdAutoRotate field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetAdAutoRotateOk() (*string, bool) {
	if o == nil || o.AdAutoRotate == nil {
		return nil, false
	}
	return o.AdAutoRotate, true
}

// HasAdAutoRotate returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasAdAutoRotate() bool {
	if o != nil && o.AdAutoRotate != nil {
		return true
	}

	return false
}

// SetAdAutoRotate gets a reference to the given string and assigns it to the AdAutoRotate field.
func (o *GatewayUpdateMigration) SetAdAutoRotate(v string) {
	o.AdAutoRotate = &v
}

// GetAdComputerBaseDn returns the AdComputerBaseDn field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetAdComputerBaseDn() string {
	if o == nil || o.AdComputerBaseDn == nil {
		var ret string
		return ret
	}
	return *o.AdComputerBaseDn
}

// GetAdComputerBaseDnOk returns a tuple with the AdComputerBaseDn field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetAdComputerBaseDnOk() (*string, bool) {
	if o == nil || o.AdComputerBaseDn == nil {
		return nil, false
	}
	return o.AdComputerBaseDn, true
}

// HasAdComputerBaseDn returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasAdComputerBaseDn() bool {
	if o != nil && o.AdComputerBaseDn != nil {
		return true
	}

	return false
}

// SetAdComputerBaseDn gets a reference to the given string and assigns it to the AdComputerBaseDn field.
func (o *GatewayUpdateMigration) SetAdComputerBaseDn(v string) {
	o.AdComputerBaseDn = &v
}

// GetAdDiscoverLocalUsers returns the AdDiscoverLocalUsers field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetAdDiscoverLocalUsers() string {
	if o == nil || o.AdDiscoverLocalUsers == nil {
		var ret string
		return ret
	}
	return *o.AdDiscoverLocalUsers
}

// GetAdDiscoverLocalUsersOk returns a tuple with the AdDiscoverLocalUsers field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetAdDiscoverLocalUsersOk() (*string, bool) {
	if o == nil || o.AdDiscoverLocalUsers == nil {
		return nil, false
	}
	return o.AdDiscoverLocalUsers, true
}

// HasAdDiscoverLocalUsers returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasAdDiscoverLocalUsers() bool {
	if o != nil && o.AdDiscoverLocalUsers != nil {
		return true
	}

	return false
}

// SetAdDiscoverLocalUsers gets a reference to the given string and assigns it to the AdDiscoverLocalUsers field.
func (o *GatewayUpdateMigration) SetAdDiscoverLocalUsers(v string) {
	o.AdDiscoverLocalUsers = &v
}

// GetAdDomainName returns the AdDomainName field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetAdDomainName() string {
	if o == nil || o.AdDomainName == nil {
		var ret string
		return ret
	}
	return *o.AdDomainName
}

// GetAdDomainNameOk returns a tuple with the AdDomainName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetAdDomainNameOk() (*string, bool) {
	if o == nil || o.AdDomainName == nil {
		return nil, false
	}
	return o.AdDomainName, true
}

// HasAdDomainName returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasAdDomainName() bool {
	if o != nil && o.AdDomainName != nil {
		return true
	}

	return false
}

// SetAdDomainName gets a reference to the given string and assigns it to the AdDomainName field.
func (o *GatewayUpdateMigration) SetAdDomainName(v string) {
	o.AdDomainName = &v
}

// GetAdDomainUsersPathTemplate returns the AdDomainUsersPathTemplate field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetAdDomainUsersPathTemplate() string {
	if o == nil || o.AdDomainUsersPathTemplate == nil {
		var ret string
		return ret
	}
	return *o.AdDomainUsersPathTemplate
}

// GetAdDomainUsersPathTemplateOk returns a tuple with the AdDomainUsersPathTemplate field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetAdDomainUsersPathTemplateOk() (*string, bool) {
	if o == nil || o.AdDomainUsersPathTemplate == nil {
		return nil, false
	}
	return o.AdDomainUsersPathTemplate, true
}

// HasAdDomainUsersPathTemplate returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasAdDomainUsersPathTemplate() bool {
	if o != nil && o.AdDomainUsersPathTemplate != nil {
		return true
	}

	return false
}

// SetAdDomainUsersPathTemplate gets a reference to the given string and assigns it to the AdDomainUsersPathTemplate field.
func (o *GatewayUpdateMigration) SetAdDomainUsersPathTemplate(v string) {
	o.AdDomainUsersPathTemplate = &v
}

// GetAdLocalUsersIgnore returns the AdLocalUsersIgnore field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetAdLocalUsersIgnore() string {
	if o == nil || o.AdLocalUsersIgnore == nil {
		var ret string
		return ret
	}
	return *o.AdLocalUsersIgnore
}

// GetAdLocalUsersIgnoreOk returns a tuple with the AdLocalUsersIgnore field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetAdLocalUsersIgnoreOk() (*string, bool) {
	if o == nil || o.AdLocalUsersIgnore == nil {
		return nil, false
	}
	return o.AdLocalUsersIgnore, true
}

// HasAdLocalUsersIgnore returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasAdLocalUsersIgnore() bool {
	if o != nil && o.AdLocalUsersIgnore != nil {
		return true
	}

	return false
}

// SetAdLocalUsersIgnore gets a reference to the given string and assigns it to the AdLocalUsersIgnore field.
func (o *GatewayUpdateMigration) SetAdLocalUsersIgnore(v string) {
	o.AdLocalUsersIgnore = &v
}

// GetAdLocalUsersPathTemplate returns the AdLocalUsersPathTemplate field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetAdLocalUsersPathTemplate() string {
	if o == nil || o.AdLocalUsersPathTemplate == nil {
		var ret string
		return ret
	}
	return *o.AdLocalUsersPathTemplate
}

// GetAdLocalUsersPathTemplateOk returns a tuple with the AdLocalUsersPathTemplate field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetAdLocalUsersPathTemplateOk() (*string, bool) {
	if o == nil || o.AdLocalUsersPathTemplate == nil {
		return nil, false
	}
	return o.AdLocalUsersPathTemplate, true
}

// HasAdLocalUsersPathTemplate returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasAdLocalUsersPathTemplate() bool {
	if o != nil && o.AdLocalUsersPathTemplate != nil {
		return true
	}

	return false
}

// SetAdLocalUsersPathTemplate gets a reference to the given string and assigns it to the AdLocalUsersPathTemplate field.
func (o *GatewayUpdateMigration) SetAdLocalUsersPathTemplate(v string) {
	o.AdLocalUsersPathTemplate = &v
}

// GetAdRotationHour returns the AdRotationHour field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetAdRotationHour() int32 {
	if o == nil || o.AdRotationHour == nil {
		var ret int32
		return ret
	}
	return *o.AdRotationHour
}

// GetAdRotationHourOk returns a tuple with the AdRotationHour field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetAdRotationHourOk() (*int32, bool) {
	if o == nil || o.AdRotationHour == nil {
		return nil, false
	}
	return o.AdRotationHour, true
}

// HasAdRotationHour returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasAdRotationHour() bool {
	if o != nil && o.AdRotationHour != nil {
		return true
	}

	return false
}

// SetAdRotationHour gets a reference to the given int32 and assigns it to the AdRotationHour field.
func (o *GatewayUpdateMigration) SetAdRotationHour(v int32) {
	o.AdRotationHour = &v
}

// GetAdRotationInterval returns the AdRotationInterval field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetAdRotationInterval() int32 {
	if o == nil || o.AdRotationInterval == nil {
		var ret int32
		return ret
	}
	return *o.AdRotationInterval
}

// GetAdRotationIntervalOk returns a tuple with the AdRotationInterval field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetAdRotationIntervalOk() (*int32, bool) {
	if o == nil || o.AdRotationInterval == nil {
		return nil, false
	}
	return o.AdRotationInterval, true
}

// HasAdRotationInterval returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasAdRotationInterval() bool {
	if o != nil && o.AdRotationInterval != nil {
		return true
	}

	return false
}

// SetAdRotationInterval gets a reference to the given int32 and assigns it to the AdRotationInterval field.
func (o *GatewayUpdateMigration) SetAdRotationInterval(v int32) {
	o.AdRotationInterval = &v
}

// GetAdSraEnableRdp returns the AdSraEnableRdp field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetAdSraEnableRdp() string {
	if o == nil || o.AdSraEnableRdp == nil {
		var ret string
		return ret
	}
	return *o.AdSraEnableRdp
}

// GetAdSraEnableRdpOk returns a tuple with the AdSraEnableRdp field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetAdSraEnableRdpOk() (*string, bool) {
	if o == nil || o.AdSraEnableRdp == nil {
		return nil, false
	}
	return o.AdSraEnableRdp, true
}

// HasAdSraEnableRdp returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasAdSraEnableRdp() bool {
	if o != nil && o.AdSraEnableRdp != nil {
		return true
	}

	return false
}

// SetAdSraEnableRdp gets a reference to the given string and assigns it to the AdSraEnableRdp field.
func (o *GatewayUpdateMigration) SetAdSraEnableRdp(v string) {
	o.AdSraEnableRdp = &v
}

// GetAdTargetName returns the AdTargetName field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetAdTargetName() string {
	if o == nil || o.AdTargetName == nil {
		var ret string
		return ret
	}
	return *o.AdTargetName
}

// GetAdTargetNameOk returns a tuple with the AdTargetName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetAdTargetNameOk() (*string, bool) {
	if o == nil || o.AdTargetName == nil {
		return nil, false
	}
	return o.AdTargetName, true
}

// HasAdTargetName returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasAdTargetName() bool {
	if o != nil && o.AdTargetName != nil {
		return true
	}

	return false
}

// SetAdTargetName gets a reference to the given string and assigns it to the AdTargetName field.
func (o *GatewayUpdateMigration) SetAdTargetName(v string) {
	o.AdTargetName = &v
}

// GetAdTargetsPathTemplate returns the AdTargetsPathTemplate field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetAdTargetsPathTemplate() string {
	if o == nil || o.AdTargetsPathTemplate == nil {
		var ret string
		return ret
	}
	return *o.AdTargetsPathTemplate
}

// GetAdTargetsPathTemplateOk returns a tuple with the AdTargetsPathTemplate field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetAdTargetsPathTemplateOk() (*string, bool) {
	if o == nil || o.AdTargetsPathTemplate == nil {
		return nil, false
	}
	return o.AdTargetsPathTemplate, true
}

// HasAdTargetsPathTemplate returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasAdTargetsPathTemplate() bool {
	if o != nil && o.AdTargetsPathTemplate != nil {
		return true
	}

	return false
}

// SetAdTargetsPathTemplate gets a reference to the given string and assigns it to the AdTargetsPathTemplate field.
func (o *GatewayUpdateMigration) SetAdTargetsPathTemplate(v string) {
	o.AdTargetsPathTemplate = &v
}

// GetAdUserBaseDn returns the AdUserBaseDn field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetAdUserBaseDn() string {
	if o == nil || o.AdUserBaseDn == nil {
		var ret string
		return ret
	}
	return *o.AdUserBaseDn
}

// GetAdUserBaseDnOk returns a tuple with the AdUserBaseDn field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetAdUserBaseDnOk() (*string, bool) {
	if o == nil || o.AdUserBaseDn == nil {
		return nil, false
	}
	return o.AdUserBaseDn, true
}

// HasAdUserBaseDn returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasAdUserBaseDn() bool {
	if o != nil && o.AdUserBaseDn != nil {
		return true
	}

	return false
}

// SetAdUserBaseDn gets a reference to the given string and assigns it to the AdUserBaseDn field.
func (o *GatewayUpdateMigration) SetAdUserBaseDn(v string) {
	o.AdUserBaseDn = &v
}

// GetAdUserGroups returns the AdUserGroups field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetAdUserGroups() string {
	if o == nil || o.AdUserGroups == nil {
		var ret string
		return ret
	}
	return *o.AdUserGroups
}

// GetAdUserGroupsOk returns a tuple with the AdUserGroups field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetAdUserGroupsOk() (*string, bool) {
	if o == nil || o.AdUserGroups == nil {
		return nil, false
	}
	return o.AdUserGroups, true
}

// HasAdUserGroups returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasAdUserGroups() bool {
	if o != nil && o.AdUserGroups != nil {
		return true
	}

	return false
}

// SetAdUserGroups gets a reference to the given string and assigns it to the AdUserGroups field.
func (o *GatewayUpdateMigration) SetAdUserGroups(v string) {
	o.AdUserGroups = &v
}

// GetAwsKey returns the AwsKey field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetAwsKey() string {
	if o == nil || o.AwsKey == nil {
		var ret string
		return ret
	}
	return *o.AwsKey
}

// GetAwsKeyOk returns a tuple with the AwsKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetAwsKeyOk() (*string, bool) {
	if o == nil || o.AwsKey == nil {
		return nil, false
	}
	return o.AwsKey, true
}

// HasAwsKey returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasAwsKey() bool {
	if o != nil && o.AwsKey != nil {
		return true
	}

	return false
}

// SetAwsKey gets a reference to the given string and assigns it to the AwsKey field.
func (o *GatewayUpdateMigration) SetAwsKey(v string) {
	o.AwsKey = &v
}

// GetAwsKeyId returns the AwsKeyId field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetAwsKeyId() string {
	if o == nil || o.AwsKeyId == nil {
		var ret string
		return ret
	}
	return *o.AwsKeyId
}

// GetAwsKeyIdOk returns a tuple with the AwsKeyId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetAwsKeyIdOk() (*string, bool) {
	if o == nil || o.AwsKeyId == nil {
		return nil, false
	}
	return o.AwsKeyId, true
}

// HasAwsKeyId returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasAwsKeyId() bool {
	if o != nil && o.AwsKeyId != nil {
		return true
	}

	return false
}

// SetAwsKeyId gets a reference to the given string and assigns it to the AwsKeyId field.
func (o *GatewayUpdateMigration) SetAwsKeyId(v string) {
	o.AwsKeyId = &v
}

// GetAwsRegion returns the AwsRegion field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetAwsRegion() string {
	if o == nil || o.AwsRegion == nil {
		var ret string
		return ret
	}
	return *o.AwsRegion
}

// GetAwsRegionOk returns a tuple with the AwsRegion field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetAwsRegionOk() (*string, bool) {
	if o == nil || o.AwsRegion == nil {
		return nil, false
	}
	return o.AwsRegion, true
}

// HasAwsRegion returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasAwsRegion() bool {
	if o != nil && o.AwsRegion != nil {
		return true
	}

	return false
}

// SetAwsRegion gets a reference to the given string and assigns it to the AwsRegion field.
func (o *GatewayUpdateMigration) SetAwsRegion(v string) {
	o.AwsRegion = &v
}

// GetAzureClientId returns the AzureClientId field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetAzureClientId() string {
	if o == nil || o.AzureClientId == nil {
		var ret string
		return ret
	}
	return *o.AzureClientId
}

// GetAzureClientIdOk returns a tuple with the AzureClientId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetAzureClientIdOk() (*string, bool) {
	if o == nil || o.AzureClientId == nil {
		return nil, false
	}
	return o.AzureClientId, true
}

// HasAzureClientId returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasAzureClientId() bool {
	if o != nil && o.AzureClientId != nil {
		return true
	}

	return false
}

// SetAzureClientId gets a reference to the given string and assigns it to the AzureClientId field.
func (o *GatewayUpdateMigration) SetAzureClientId(v string) {
	o.AzureClientId = &v
}

// GetAzureKvName returns the AzureKvName field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetAzureKvName() string {
	if o == nil || o.AzureKvName == nil {
		var ret string
		return ret
	}
	return *o.AzureKvName
}

// GetAzureKvNameOk returns a tuple with the AzureKvName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetAzureKvNameOk() (*string, bool) {
	if o == nil || o.AzureKvName == nil {
		return nil, false
	}
	return o.AzureKvName, true
}

// HasAzureKvName returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasAzureKvName() bool {
	if o != nil && o.AzureKvName != nil {
		return true
	}

	return false
}

// SetAzureKvName gets a reference to the given string and assigns it to the AzureKvName field.
func (o *GatewayUpdateMigration) SetAzureKvName(v string) {
	o.AzureKvName = &v
}

// GetAzureSecret returns the AzureSecret field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetAzureSecret() string {
	if o == nil || o.AzureSecret == nil {
		var ret string
		return ret
	}
	return *o.AzureSecret
}

// GetAzureSecretOk returns a tuple with the AzureSecret field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetAzureSecretOk() (*string, bool) {
	if o == nil || o.AzureSecret == nil {
		return nil, false
	}
	return o.AzureSecret, true
}

// HasAzureSecret returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasAzureSecret() bool {
	if o != nil && o.AzureSecret != nil {
		return true
	}

	return false
}

// SetAzureSecret gets a reference to the given string and assigns it to the AzureSecret field.
func (o *GatewayUpdateMigration) SetAzureSecret(v string) {
	o.AzureSecret = &v
}

// GetAzureTenantId returns the AzureTenantId field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetAzureTenantId() string {
	if o == nil || o.AzureTenantId == nil {
		var ret string
		return ret
	}
	return *o.AzureTenantId
}

// GetAzureTenantIdOk returns a tuple with the AzureTenantId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetAzureTenantIdOk() (*string, bool) {
	if o == nil || o.AzureTenantId == nil {
		return nil, false
	}
	return o.AzureTenantId, true
}

// HasAzureTenantId returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasAzureTenantId() bool {
	if o != nil && o.AzureTenantId != nil {
		return true
	}

	return false
}

// SetAzureTenantId gets a reference to the given string and assigns it to the AzureTenantId field.
func (o *GatewayUpdateMigration) SetAzureTenantId(v string) {
	o.AzureTenantId = &v
}

// GetGcpKey returns the GcpKey field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetGcpKey() string {
	if o == nil || o.GcpKey == nil {
		var ret string
		return ret
	}
	return *o.GcpKey
}

// GetGcpKeyOk returns a tuple with the GcpKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetGcpKeyOk() (*string, bool) {
	if o == nil || o.GcpKey == nil {
		return nil, false
	}
	return o.GcpKey, true
}

// HasGcpKey returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasGcpKey() bool {
	if o != nil && o.GcpKey != nil {
		return true
	}

	return false
}

// SetGcpKey gets a reference to the given string and assigns it to the GcpKey field.
func (o *GatewayUpdateMigration) SetGcpKey(v string) {
	o.GcpKey = &v
}

// GetHashiJson returns the HashiJson field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetHashiJson() string {
	if o == nil || o.HashiJson == nil {
		var ret string
		return ret
	}
	return *o.HashiJson
}

// GetHashiJsonOk returns a tuple with the HashiJson field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetHashiJsonOk() (*string, bool) {
	if o == nil || o.HashiJson == nil {
		return nil, false
	}
	return o.HashiJson, true
}

// HasHashiJson returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasHashiJson() bool {
	if o != nil && o.HashiJson != nil {
		return true
	}

	return false
}

// SetHashiJson gets a reference to the given string and assigns it to the HashiJson field.
func (o *GatewayUpdateMigration) SetHashiJson(v string) {
	o.HashiJson = &v
}

// GetHashiNs returns the HashiNs field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetHashiNs() []string {
	if o == nil || o.HashiNs == nil {
		var ret []string
		return ret
	}
	return *o.HashiNs
}

// GetHashiNsOk returns a tuple with the HashiNs field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetHashiNsOk() (*[]string, bool) {
	if o == nil || o.HashiNs == nil {
		return nil, false
	}
	return o.HashiNs, true
}

// HasHashiNs returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasHashiNs() bool {
	if o != nil && o.HashiNs != nil {
		return true
	}

	return false
}

// SetHashiNs gets a reference to the given []string and assigns it to the HashiNs field.
func (o *GatewayUpdateMigration) SetHashiNs(v []string) {
	o.HashiNs = &v
}

// GetHashiToken returns the HashiToken field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetHashiToken() string {
	if o == nil || o.HashiToken == nil {
		var ret string
		return ret
	}
	return *o.HashiToken
}

// GetHashiTokenOk returns a tuple with the HashiToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetHashiTokenOk() (*string, bool) {
	if o == nil || o.HashiToken == nil {
		return nil, false
	}
	return o.HashiToken, true
}

// HasHashiToken returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasHashiToken() bool {
	if o != nil && o.HashiToken != nil {
		return true
	}

	return false
}

// SetHashiToken gets a reference to the given string and assigns it to the HashiToken field.
func (o *GatewayUpdateMigration) SetHashiToken(v string) {
	o.HashiToken = &v
}

// GetHashiUrl returns the HashiUrl field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetHashiUrl() string {
	if o == nil || o.HashiUrl == nil {
		var ret string
		return ret
	}
	return *o.HashiUrl
}

// GetHashiUrlOk returns a tuple with the HashiUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetHashiUrlOk() (*string, bool) {
	if o == nil || o.HashiUrl == nil {
		return nil, false
	}
	return o.HashiUrl, true
}

// HasHashiUrl returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasHashiUrl() bool {
	if o != nil && o.HashiUrl != nil {
		return true
	}

	return false
}

// SetHashiUrl gets a reference to the given string and assigns it to the HashiUrl field.
func (o *GatewayUpdateMigration) SetHashiUrl(v string) {
	o.HashiUrl = &v
}

// GetId returns the Id field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetId() string {
	if o == nil || o.Id == nil {
		var ret string
		return ret
	}
	return *o.Id
}

// GetIdOk returns a tuple with the Id field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetIdOk() (*string, bool) {
	if o == nil || o.Id == nil {
		return nil, false
	}
	return o.Id, true
}

// HasId returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasId() bool {
	if o != nil && o.Id != nil {
		return true
	}

	return false
}

// SetId gets a reference to the given string and assigns it to the Id field.
func (o *GatewayUpdateMigration) SetId(v string) {
	o.Id = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *GatewayUpdateMigration) SetJson(v bool) {
	o.Json = &v
}

// GetK8sCaCertificate returns the K8sCaCertificate field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetK8sCaCertificate() []int32 {
	if o == nil || o.K8sCaCertificate == nil {
		var ret []int32
		return ret
	}
	return *o.K8sCaCertificate
}

// GetK8sCaCertificateOk returns a tuple with the K8sCaCertificate field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetK8sCaCertificateOk() (*[]int32, bool) {
	if o == nil || o.K8sCaCertificate == nil {
		return nil, false
	}
	return o.K8sCaCertificate, true
}

// HasK8sCaCertificate returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasK8sCaCertificate() bool {
	if o != nil && o.K8sCaCertificate != nil {
		return true
	}

	return false
}

// SetK8sCaCertificate gets a reference to the given []int32 and assigns it to the K8sCaCertificate field.
func (o *GatewayUpdateMigration) SetK8sCaCertificate(v []int32) {
	o.K8sCaCertificate = &v
}

// GetK8sClientCertificate returns the K8sClientCertificate field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetK8sClientCertificate() []int32 {
	if o == nil || o.K8sClientCertificate == nil {
		var ret []int32
		return ret
	}
	return *o.K8sClientCertificate
}

// GetK8sClientCertificateOk returns a tuple with the K8sClientCertificate field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetK8sClientCertificateOk() (*[]int32, bool) {
	if o == nil || o.K8sClientCertificate == nil {
		return nil, false
	}
	return o.K8sClientCertificate, true
}

// HasK8sClientCertificate returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasK8sClientCertificate() bool {
	if o != nil && o.K8sClientCertificate != nil {
		return true
	}

	return false
}

// SetK8sClientCertificate gets a reference to the given []int32 and assigns it to the K8sClientCertificate field.
func (o *GatewayUpdateMigration) SetK8sClientCertificate(v []int32) {
	o.K8sClientCertificate = &v
}

// GetK8sClientKey returns the K8sClientKey field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetK8sClientKey() []int32 {
	if o == nil || o.K8sClientKey == nil {
		var ret []int32
		return ret
	}
	return *o.K8sClientKey
}

// GetK8sClientKeyOk returns a tuple with the K8sClientKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetK8sClientKeyOk() (*[]int32, bool) {
	if o == nil || o.K8sClientKey == nil {
		return nil, false
	}
	return o.K8sClientKey, true
}

// HasK8sClientKey returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasK8sClientKey() bool {
	if o != nil && o.K8sClientKey != nil {
		return true
	}

	return false
}

// SetK8sClientKey gets a reference to the given []int32 and assigns it to the K8sClientKey field.
func (o *GatewayUpdateMigration) SetK8sClientKey(v []int32) {
	o.K8sClientKey = &v
}

// GetK8sNamespace returns the K8sNamespace field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetK8sNamespace() string {
	if o == nil || o.K8sNamespace == nil {
		var ret string
		return ret
	}
	return *o.K8sNamespace
}

// GetK8sNamespaceOk returns a tuple with the K8sNamespace field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetK8sNamespaceOk() (*string, bool) {
	if o == nil || o.K8sNamespace == nil {
		return nil, false
	}
	return o.K8sNamespace, true
}

// HasK8sNamespace returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasK8sNamespace() bool {
	if o != nil && o.K8sNamespace != nil {
		return true
	}

	return false
}

// SetK8sNamespace gets a reference to the given string and assigns it to the K8sNamespace field.
func (o *GatewayUpdateMigration) SetK8sNamespace(v string) {
	o.K8sNamespace = &v
}

// GetK8sPassword returns the K8sPassword field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetK8sPassword() string {
	if o == nil || o.K8sPassword == nil {
		var ret string
		return ret
	}
	return *o.K8sPassword
}

// GetK8sPasswordOk returns a tuple with the K8sPassword field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetK8sPasswordOk() (*string, bool) {
	if o == nil || o.K8sPassword == nil {
		return nil, false
	}
	return o.K8sPassword, true
}

// HasK8sPassword returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasK8sPassword() bool {
	if o != nil && o.K8sPassword != nil {
		return true
	}

	return false
}

// SetK8sPassword gets a reference to the given string and assigns it to the K8sPassword field.
func (o *GatewayUpdateMigration) SetK8sPassword(v string) {
	o.K8sPassword = &v
}

// GetK8sSkipSystem returns the K8sSkipSystem field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetK8sSkipSystem() bool {
	if o == nil || o.K8sSkipSystem == nil {
		var ret bool
		return ret
	}
	return *o.K8sSkipSystem
}

// GetK8sSkipSystemOk returns a tuple with the K8sSkipSystem field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetK8sSkipSystemOk() (*bool, bool) {
	if o == nil || o.K8sSkipSystem == nil {
		return nil, false
	}
	return o.K8sSkipSystem, true
}

// HasK8sSkipSystem returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasK8sSkipSystem() bool {
	if o != nil && o.K8sSkipSystem != nil {
		return true
	}

	return false
}

// SetK8sSkipSystem gets a reference to the given bool and assigns it to the K8sSkipSystem field.
func (o *GatewayUpdateMigration) SetK8sSkipSystem(v bool) {
	o.K8sSkipSystem = &v
}

// GetK8sToken returns the K8sToken field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetK8sToken() string {
	if o == nil || o.K8sToken == nil {
		var ret string
		return ret
	}
	return *o.K8sToken
}

// GetK8sTokenOk returns a tuple with the K8sToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetK8sTokenOk() (*string, bool) {
	if o == nil || o.K8sToken == nil {
		return nil, false
	}
	return o.K8sToken, true
}

// HasK8sToken returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasK8sToken() bool {
	if o != nil && o.K8sToken != nil {
		return true
	}

	return false
}

// SetK8sToken gets a reference to the given string and assigns it to the K8sToken field.
func (o *GatewayUpdateMigration) SetK8sToken(v string) {
	o.K8sToken = &v
}

// GetK8sUrl returns the K8sUrl field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetK8sUrl() string {
	if o == nil || o.K8sUrl == nil {
		var ret string
		return ret
	}
	return *o.K8sUrl
}

// GetK8sUrlOk returns a tuple with the K8sUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetK8sUrlOk() (*string, bool) {
	if o == nil || o.K8sUrl == nil {
		return nil, false
	}
	return o.K8sUrl, true
}

// HasK8sUrl returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasK8sUrl() bool {
	if o != nil && o.K8sUrl != nil {
		return true
	}

	return false
}

// SetK8sUrl gets a reference to the given string and assigns it to the K8sUrl field.
func (o *GatewayUpdateMigration) SetK8sUrl(v string) {
	o.K8sUrl = &v
}

// GetK8sUsername returns the K8sUsername field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetK8sUsername() string {
	if o == nil || o.K8sUsername == nil {
		var ret string
		return ret
	}
	return *o.K8sUsername
}

// GetK8sUsernameOk returns a tuple with the K8sUsername field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetK8sUsernameOk() (*string, bool) {
	if o == nil || o.K8sUsername == nil {
		return nil, false
	}
	return o.K8sUsername, true
}

// HasK8sUsername returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasK8sUsername() bool {
	if o != nil && o.K8sUsername != nil {
		return true
	}

	return false
}

// SetK8sUsername gets a reference to the given string and assigns it to the K8sUsername field.
func (o *GatewayUpdateMigration) SetK8sUsername(v string) {
	o.K8sUsername = &v
}

// GetName returns the Name field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetName() string {
	if o == nil || o.Name == nil {
		var ret string
		return ret
	}
	return *o.Name
}

// GetNameOk returns a tuple with the Name field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetNameOk() (*string, bool) {
	if o == nil || o.Name == nil {
		return nil, false
	}
	return o.Name, true
}

// HasName returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasName() bool {
	if o != nil && o.Name != nil {
		return true
	}

	return false
}

// SetName gets a reference to the given string and assigns it to the Name field.
func (o *GatewayUpdateMigration) SetName(v string) {
	o.Name = &v
}

// GetNewName returns the NewName field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetNewName() string {
	if o == nil || o.NewName == nil {
		var ret string
		return ret
	}
	return *o.NewName
}

// GetNewNameOk returns a tuple with the NewName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetNewNameOk() (*string, bool) {
	if o == nil || o.NewName == nil {
		return nil, false
	}
	return o.NewName, true
}

// HasNewName returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasNewName() bool {
	if o != nil && o.NewName != nil {
		return true
	}

	return false
}

// SetNewName gets a reference to the given string and assigns it to the NewName field.
func (o *GatewayUpdateMigration) SetNewName(v string) {
	o.NewName = &v
}

// GetProtectionKey returns the ProtectionKey field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetProtectionKey() string {
	if o == nil || o.ProtectionKey == nil {
		var ret string
		return ret
	}
	return *o.ProtectionKey
}

// GetProtectionKeyOk returns a tuple with the ProtectionKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetProtectionKeyOk() (*string, bool) {
	if o == nil || o.ProtectionKey == nil {
		return nil, false
	}
	return o.ProtectionKey, true
}

// HasProtectionKey returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasProtectionKey() bool {
	if o != nil && o.ProtectionKey != nil {
		return true
	}

	return false
}

// SetProtectionKey gets a reference to the given string and assigns it to the ProtectionKey field.
func (o *GatewayUpdateMigration) SetProtectionKey(v string) {
	o.ProtectionKey = &v
}

// GetSiAutoRotate returns the SiAutoRotate field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetSiAutoRotate() string {
	if o == nil || o.SiAutoRotate == nil {
		var ret string
		return ret
	}
	return *o.SiAutoRotate
}

// GetSiAutoRotateOk returns a tuple with the SiAutoRotate field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetSiAutoRotateOk() (*string, bool) {
	if o == nil || o.SiAutoRotate == nil {
		return nil, false
	}
	return o.SiAutoRotate, true
}

// HasSiAutoRotate returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasSiAutoRotate() bool {
	if o != nil && o.SiAutoRotate != nil {
		return true
	}

	return false
}

// SetSiAutoRotate gets a reference to the given string and assigns it to the SiAutoRotate field.
func (o *GatewayUpdateMigration) SetSiAutoRotate(v string) {
	o.SiAutoRotate = &v
}

// GetSiRotationHour returns the SiRotationHour field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetSiRotationHour() int32 {
	if o == nil || o.SiRotationHour == nil {
		var ret int32
		return ret
	}
	return *o.SiRotationHour
}

// GetSiRotationHourOk returns a tuple with the SiRotationHour field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetSiRotationHourOk() (*int32, bool) {
	if o == nil || o.SiRotationHour == nil {
		return nil, false
	}
	return o.SiRotationHour, true
}

// HasSiRotationHour returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasSiRotationHour() bool {
	if o != nil && o.SiRotationHour != nil {
		return true
	}

	return false
}

// SetSiRotationHour gets a reference to the given int32 and assigns it to the SiRotationHour field.
func (o *GatewayUpdateMigration) SetSiRotationHour(v int32) {
	o.SiRotationHour = &v
}

// GetSiRotationInterval returns the SiRotationInterval field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetSiRotationInterval() int32 {
	if o == nil || o.SiRotationInterval == nil {
		var ret int32
		return ret
	}
	return *o.SiRotationInterval
}

// GetSiRotationIntervalOk returns a tuple with the SiRotationInterval field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetSiRotationIntervalOk() (*int32, bool) {
	if o == nil || o.SiRotationInterval == nil {
		return nil, false
	}
	return o.SiRotationInterval, true
}

// HasSiRotationInterval returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasSiRotationInterval() bool {
	if o != nil && o.SiRotationInterval != nil {
		return true
	}

	return false
}

// SetSiRotationInterval gets a reference to the given int32 and assigns it to the SiRotationInterval field.
func (o *GatewayUpdateMigration) SetSiRotationInterval(v int32) {
	o.SiRotationInterval = &v
}

// GetSiSraEnableRdp returns the SiSraEnableRdp field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetSiSraEnableRdp() string {
	if o == nil || o.SiSraEnableRdp == nil {
		var ret string
		return ret
	}
	return *o.SiSraEnableRdp
}

// GetSiSraEnableRdpOk returns a tuple with the SiSraEnableRdp field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetSiSraEnableRdpOk() (*string, bool) {
	if o == nil || o.SiSraEnableRdp == nil {
		return nil, false
	}
	return o.SiSraEnableRdp, true
}

// HasSiSraEnableRdp returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasSiSraEnableRdp() bool {
	if o != nil && o.SiSraEnableRdp != nil {
		return true
	}

	return false
}

// SetSiSraEnableRdp gets a reference to the given string and assigns it to the SiSraEnableRdp field.
func (o *GatewayUpdateMigration) SetSiSraEnableRdp(v string) {
	o.SiSraEnableRdp = &v
}

// GetSiTargetName returns the SiTargetName field value
func (o *GatewayUpdateMigration) GetSiTargetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.SiTargetName
}

// GetSiTargetNameOk returns a tuple with the SiTargetName field value
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetSiTargetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.SiTargetName, true
}

// SetSiTargetName sets field value
func (o *GatewayUpdateMigration) SetSiTargetName(v string) {
	o.SiTargetName = v
}

// GetSiUserGroups returns the SiUserGroups field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetSiUserGroups() string {
	if o == nil || o.SiUserGroups == nil {
		var ret string
		return ret
	}
	return *o.SiUserGroups
}

// GetSiUserGroupsOk returns a tuple with the SiUserGroups field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetSiUserGroupsOk() (*string, bool) {
	if o == nil || o.SiUserGroups == nil {
		return nil, false
	}
	return o.SiUserGroups, true
}

// HasSiUserGroups returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasSiUserGroups() bool {
	if o != nil && o.SiUserGroups != nil {
		return true
	}

	return false
}

// SetSiUserGroups gets a reference to the given string and assigns it to the SiUserGroups field.
func (o *GatewayUpdateMigration) SetSiUserGroups(v string) {
	o.SiUserGroups = &v
}

// GetSiUsersIgnore returns the SiUsersIgnore field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetSiUsersIgnore() string {
	if o == nil || o.SiUsersIgnore == nil {
		var ret string
		return ret
	}
	return *o.SiUsersIgnore
}

// GetSiUsersIgnoreOk returns a tuple with the SiUsersIgnore field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetSiUsersIgnoreOk() (*string, bool) {
	if o == nil || o.SiUsersIgnore == nil {
		return nil, false
	}
	return o.SiUsersIgnore, true
}

// HasSiUsersIgnore returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasSiUsersIgnore() bool {
	if o != nil && o.SiUsersIgnore != nil {
		return true
	}

	return false
}

// SetSiUsersIgnore gets a reference to the given string and assigns it to the SiUsersIgnore field.
func (o *GatewayUpdateMigration) SetSiUsersIgnore(v string) {
	o.SiUsersIgnore = &v
}

// GetSiUsersPathTemplate returns the SiUsersPathTemplate field value
func (o *GatewayUpdateMigration) GetSiUsersPathTemplate() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.SiUsersPathTemplate
}

// GetSiUsersPathTemplateOk returns a tuple with the SiUsersPathTemplate field value
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetSiUsersPathTemplateOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.SiUsersPathTemplate, true
}

// SetSiUsersPathTemplate sets field value
func (o *GatewayUpdateMigration) SetSiUsersPathTemplate(v string) {
	o.SiUsersPathTemplate = v
}

// GetTargetLocation returns the TargetLocation field value
func (o *GatewayUpdateMigration) GetTargetLocation() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.TargetLocation
}

// GetTargetLocationOk returns a tuple with the TargetLocation field value
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetTargetLocationOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.TargetLocation, true
}

// SetTargetLocation sets field value
func (o *GatewayUpdateMigration) SetTargetLocation(v string) {
	o.TargetLocation = v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *GatewayUpdateMigration) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *GatewayUpdateMigration) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateMigration) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *GatewayUpdateMigration) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *GatewayUpdateMigration) SetUidToken(v string) {
	o.UidToken = &v
}

func (o GatewayUpdateMigration) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Var1passwordEmail != nil {
		toSerialize["1password-email"] = o.Var1passwordEmail
	}
	if o.Var1passwordPassword != nil {
		toSerialize["1password-password"] = o.Var1passwordPassword
	}
	if o.Var1passwordSecretKey != nil {
		toSerialize["1password-secret-key"] = o.Var1passwordSecretKey
	}
	if o.Var1passwordUrl != nil {
		toSerialize["1password-url"] = o.Var1passwordUrl
	}
	if o.Var1passwordVaults != nil {
		toSerialize["1password-vaults"] = o.Var1passwordVaults
	}
	if o.ServiceAccountKeyDecoded != nil {
		toSerialize["ServiceAccountKeyDecoded"] = o.ServiceAccountKeyDecoded
	}
	if o.AdDiscoverServices != nil {
		toSerialize["ad-discover-services"] = o.AdDiscoverServices
	}
	if o.AdDiscoveryTypes != nil {
		toSerialize["ad-discovery-types"] = o.AdDiscoveryTypes
	}
	if o.AdOsFilter != nil {
		toSerialize["ad-os-filter"] = o.AdOsFilter
	}
	if o.AdSshPort != nil {
		toSerialize["ad-ssh-port"] = o.AdSshPort
	}
	if o.AdTargetFormat != nil {
		toSerialize["ad-target-format"] = o.AdTargetFormat
	}
	if o.AdTargetsType != nil {
		toSerialize["ad-targets-type"] = o.AdTargetsType
	}
	if o.AdWinrmOverHttp != nil {
		toSerialize["ad-winrm-over-http"] = o.AdWinrmOverHttp
	}
	if o.AdWinrmPort != nil {
		toSerialize["ad-winrm-port"] = o.AdWinrmPort
	}
	if o.AdAutoRotate != nil {
		toSerialize["ad_auto_rotate"] = o.AdAutoRotate
	}
	if o.AdComputerBaseDn != nil {
		toSerialize["ad_computer_base_dn"] = o.AdComputerBaseDn
	}
	if o.AdDiscoverLocalUsers != nil {
		toSerialize["ad_discover_local_users"] = o.AdDiscoverLocalUsers
	}
	if o.AdDomainName != nil {
		toSerialize["ad_domain_name"] = o.AdDomainName
	}
	if o.AdDomainUsersPathTemplate != nil {
		toSerialize["ad_domain_users_path_template"] = o.AdDomainUsersPathTemplate
	}
	if o.AdLocalUsersIgnore != nil {
		toSerialize["ad_local_users_ignore"] = o.AdLocalUsersIgnore
	}
	if o.AdLocalUsersPathTemplate != nil {
		toSerialize["ad_local_users_path_template"] = o.AdLocalUsersPathTemplate
	}
	if o.AdRotationHour != nil {
		toSerialize["ad_rotation_hour"] = o.AdRotationHour
	}
	if o.AdRotationInterval != nil {
		toSerialize["ad_rotation_interval"] = o.AdRotationInterval
	}
	if o.AdSraEnableRdp != nil {
		toSerialize["ad_sra_enable_rdp"] = o.AdSraEnableRdp
	}
	if o.AdTargetName != nil {
		toSerialize["ad_target_name"] = o.AdTargetName
	}
	if o.AdTargetsPathTemplate != nil {
		toSerialize["ad_targets_path_template"] = o.AdTargetsPathTemplate
	}
	if o.AdUserBaseDn != nil {
		toSerialize["ad_user_base_dn"] = o.AdUserBaseDn
	}
	if o.AdUserGroups != nil {
		toSerialize["ad_user_groups"] = o.AdUserGroups
	}
	if o.AwsKey != nil {
		toSerialize["aws-key"] = o.AwsKey
	}
	if o.AwsKeyId != nil {
		toSerialize["aws-key-id"] = o.AwsKeyId
	}
	if o.AwsRegion != nil {
		toSerialize["aws-region"] = o.AwsRegion
	}
	if o.AzureClientId != nil {
		toSerialize["azure-client-id"] = o.AzureClientId
	}
	if o.AzureKvName != nil {
		toSerialize["azure-kv-name"] = o.AzureKvName
	}
	if o.AzureSecret != nil {
		toSerialize["azure-secret"] = o.AzureSecret
	}
	if o.AzureTenantId != nil {
		toSerialize["azure-tenant-id"] = o.AzureTenantId
	}
	if o.GcpKey != nil {
		toSerialize["gcp-key"] = o.GcpKey
	}
	if o.HashiJson != nil {
		toSerialize["hashi-json"] = o.HashiJson
	}
	if o.HashiNs != nil {
		toSerialize["hashi-ns"] = o.HashiNs
	}
	if o.HashiToken != nil {
		toSerialize["hashi-token"] = o.HashiToken
	}
	if o.HashiUrl != nil {
		toSerialize["hashi-url"] = o.HashiUrl
	}
	if o.Id != nil {
		toSerialize["id"] = o.Id
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.K8sCaCertificate != nil {
		toSerialize["k8s-ca-certificate"] = o.K8sCaCertificate
	}
	if o.K8sClientCertificate != nil {
		toSerialize["k8s-client-certificate"] = o.K8sClientCertificate
	}
	if o.K8sClientKey != nil {
		toSerialize["k8s-client-key"] = o.K8sClientKey
	}
	if o.K8sNamespace != nil {
		toSerialize["k8s-namespace"] = o.K8sNamespace
	}
	if o.K8sPassword != nil {
		toSerialize["k8s-password"] = o.K8sPassword
	}
	if o.K8sSkipSystem != nil {
		toSerialize["k8s-skip-system"] = o.K8sSkipSystem
	}
	if o.K8sToken != nil {
		toSerialize["k8s-token"] = o.K8sToken
	}
	if o.K8sUrl != nil {
		toSerialize["k8s-url"] = o.K8sUrl
	}
	if o.K8sUsername != nil {
		toSerialize["k8s-username"] = o.K8sUsername
	}
	if o.Name != nil {
		toSerialize["name"] = o.Name
	}
	if o.NewName != nil {
		toSerialize["new_name"] = o.NewName
	}
	if o.ProtectionKey != nil {
		toSerialize["protection-key"] = o.ProtectionKey
	}
	if o.SiAutoRotate != nil {
		toSerialize["si-auto-rotate"] = o.SiAutoRotate
	}
	if o.SiRotationHour != nil {
		toSerialize["si-rotation-hour"] = o.SiRotationHour
	}
	if o.SiRotationInterval != nil {
		toSerialize["si-rotation-interval"] = o.SiRotationInterval
	}
	if o.SiSraEnableRdp != nil {
		toSerialize["si-sra-enable-rdp"] = o.SiSraEnableRdp
	}
	if true {
		toSerialize["si-target-name"] = o.SiTargetName
	}
	if o.SiUserGroups != nil {
		toSerialize["si-user-groups"] = o.SiUserGroups
	}
	if o.SiUsersIgnore != nil {
		toSerialize["si-users-ignore"] = o.SiUsersIgnore
	}
	if true {
		toSerialize["si-users-path-template"] = o.SiUsersPathTemplate
	}
	if true {
		toSerialize["target-location"] = o.TargetLocation
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableGatewayUpdateMigration struct {
	value *GatewayUpdateMigration
	isSet bool
}

func (v NullableGatewayUpdateMigration) Get() *GatewayUpdateMigration {
	return v.value
}

func (v *NullableGatewayUpdateMigration) Set(val *GatewayUpdateMigration) {
	v.value = val
	v.isSet = true
}

func (v NullableGatewayUpdateMigration) IsSet() bool {
	return v.isSet
}

func (v *NullableGatewayUpdateMigration) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableGatewayUpdateMigration(val *GatewayUpdateMigration) *NullableGatewayUpdateMigration {
	return &NullableGatewayUpdateMigration{value: val, isSet: true}
}

func (v NullableGatewayUpdateMigration) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableGatewayUpdateMigration) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


