/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// GenerateAcmeEab struct for GenerateAcmeEab
type GenerateAcmeEab struct {
	// The name of the PKI certificate issuer
	CertIssuerName string `json:"cert-issuer-name"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewGenerateAcmeEab instantiates a new GenerateAcmeEab object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewGenerateAcmeEab(certIssuerName string, ) *GenerateAcmeEab {
	this := GenerateAcmeEab{}
	this.CertIssuerName = certIssuerName
	var json bool = false
	this.Json = &json
	return &this
}

// NewGenerateAcmeEabWithDefaults instantiates a new GenerateAcmeEab object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewGenerateAcmeEabWithDefaults() *GenerateAcmeEab {
	this := GenerateAcmeEab{}
	var json bool = false
	this.Json = &json
	return &this
}

// GetCertIssuerName returns the CertIssuerName field value
func (o *GenerateAcmeEab) GetCertIssuerName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.CertIssuerName
}

// GetCertIssuerNameOk returns a tuple with the CertIssuerName field value
// and a boolean to check if the value has been set.
func (o *GenerateAcmeEab) GetCertIssuerNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.CertIssuerName, true
}

// SetCertIssuerName sets field value
func (o *GenerateAcmeEab) SetCertIssuerName(v string) {
	o.CertIssuerName = v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *GenerateAcmeEab) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GenerateAcmeEab) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *GenerateAcmeEab) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *GenerateAcmeEab) SetJson(v bool) {
	o.Json = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *GenerateAcmeEab) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GenerateAcmeEab) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *GenerateAcmeEab) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *GenerateAcmeEab) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *GenerateAcmeEab) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GenerateAcmeEab) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *GenerateAcmeEab) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *GenerateAcmeEab) SetUidToken(v string) {
	o.UidToken = &v
}

func (o GenerateAcmeEab) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if true {
		toSerialize["cert-issuer-name"] = o.CertIssuerName
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableGenerateAcmeEab struct {
	value *GenerateAcmeEab
	isSet bool
}

func (v NullableGenerateAcmeEab) Get() *GenerateAcmeEab {
	return v.value
}

func (v *NullableGenerateAcmeEab) Set(val *GenerateAcmeEab) {
	v.value = val
	v.isSet = true
}

func (v NullableGenerateAcmeEab) IsSet() bool {
	return v.isSet
}

func (v *NullableGenerateAcmeEab) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableGenerateAcmeEab(val *GenerateAcmeEab) *NullableGenerateAcmeEab {
	return &NullableGenerateAcmeEab{value: val, isSet: true}
}

func (v NullableGenerateAcmeEab) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableGenerateAcmeEab) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


