/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// GwUpdateRemoteAccessSessionLogsElasticsearch gwUpdateRemoteAccessSessionLogsElasticsearch is a command that updates session log forwarding config (elasticsearch target)
type GwUpdateRemoteAccessSessionLogsElasticsearch struct {
	// Elasticsearch api key relevant only for api_key auth-type
	ApiKey *string `json:"api-key,omitempty"`
	// Elasticsearch auth type [api_key/password]
	AuthType *string `json:"auth-type,omitempty"`
	// Elasticsearch cloud id relevant only for cloud server-type
	CloudId *string `json:"cloud-id,omitempty"`
	// Enable Log Forwarding [true/false]
	Enable *string `json:"enable,omitempty"`
	// Enable tls
	EnableTls *bool `json:"enable-tls,omitempty"`
	// Elasticsearch index
	Index *string `json:"index,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Elasticsearch nodes relevant only for nodes server-type
	Nodes *string `json:"nodes,omitempty"`
	// Logs format [text/json]
	OutputFormat *string `json:"output-format,omitempty"`
	// Elasticsearch password relevant only for password auth-type
	Password *string `json:"password,omitempty"`
	// Pull interval in seconds
	PullInterval *string `json:"pull-interval,omitempty"`
	// Elasticsearch server type [cloud/nodes]
	ServerType *string `json:"server-type,omitempty"`
	// Elasticsearch tls certificate
	TlsCertificate *string `json:"tls-certificate,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
	// Elasticsearch user name relevant only for password auth-type
	UserName *string `json:"user-name,omitempty"`
}

// NewGwUpdateRemoteAccessSessionLogsElasticsearch instantiates a new GwUpdateRemoteAccessSessionLogsElasticsearch object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewGwUpdateRemoteAccessSessionLogsElasticsearch() *GwUpdateRemoteAccessSessionLogsElasticsearch {
	this := GwUpdateRemoteAccessSessionLogsElasticsearch{}
	var enable string = "true"
	this.Enable = &enable
	var json bool = false
	this.Json = &json
	var outputFormat string = "text"
	this.OutputFormat = &outputFormat
	var pullInterval string = "10"
	this.PullInterval = &pullInterval
	var tlsCertificate string = "use-existing"
	this.TlsCertificate = &tlsCertificate
	return &this
}

// NewGwUpdateRemoteAccessSessionLogsElasticsearchWithDefaults instantiates a new GwUpdateRemoteAccessSessionLogsElasticsearch object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewGwUpdateRemoteAccessSessionLogsElasticsearchWithDefaults() *GwUpdateRemoteAccessSessionLogsElasticsearch {
	this := GwUpdateRemoteAccessSessionLogsElasticsearch{}
	var enable string = "true"
	this.Enable = &enable
	var json bool = false
	this.Json = &json
	var outputFormat string = "text"
	this.OutputFormat = &outputFormat
	var pullInterval string = "10"
	this.PullInterval = &pullInterval
	var tlsCertificate string = "use-existing"
	this.TlsCertificate = &tlsCertificate
	return &this
}

// GetApiKey returns the ApiKey field value if set, zero value otherwise.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) GetApiKey() string {
	if o == nil || o.ApiKey == nil {
		var ret string
		return ret
	}
	return *o.ApiKey
}

// GetApiKeyOk returns a tuple with the ApiKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) GetApiKeyOk() (*string, bool) {
	if o == nil || o.ApiKey == nil {
		return nil, false
	}
	return o.ApiKey, true
}

// HasApiKey returns a boolean if a field has been set.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) HasApiKey() bool {
	if o != nil && o.ApiKey != nil {
		return true
	}

	return false
}

// SetApiKey gets a reference to the given string and assigns it to the ApiKey field.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) SetApiKey(v string) {
	o.ApiKey = &v
}

// GetAuthType returns the AuthType field value if set, zero value otherwise.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) GetAuthType() string {
	if o == nil || o.AuthType == nil {
		var ret string
		return ret
	}
	return *o.AuthType
}

// GetAuthTypeOk returns a tuple with the AuthType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) GetAuthTypeOk() (*string, bool) {
	if o == nil || o.AuthType == nil {
		return nil, false
	}
	return o.AuthType, true
}

// HasAuthType returns a boolean if a field has been set.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) HasAuthType() bool {
	if o != nil && o.AuthType != nil {
		return true
	}

	return false
}

// SetAuthType gets a reference to the given string and assigns it to the AuthType field.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) SetAuthType(v string) {
	o.AuthType = &v
}

// GetCloudId returns the CloudId field value if set, zero value otherwise.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) GetCloudId() string {
	if o == nil || o.CloudId == nil {
		var ret string
		return ret
	}
	return *o.CloudId
}

// GetCloudIdOk returns a tuple with the CloudId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) GetCloudIdOk() (*string, bool) {
	if o == nil || o.CloudId == nil {
		return nil, false
	}
	return o.CloudId, true
}

// HasCloudId returns a boolean if a field has been set.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) HasCloudId() bool {
	if o != nil && o.CloudId != nil {
		return true
	}

	return false
}

// SetCloudId gets a reference to the given string and assigns it to the CloudId field.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) SetCloudId(v string) {
	o.CloudId = &v
}

// GetEnable returns the Enable field value if set, zero value otherwise.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) GetEnable() string {
	if o == nil || o.Enable == nil {
		var ret string
		return ret
	}
	return *o.Enable
}

// GetEnableOk returns a tuple with the Enable field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) GetEnableOk() (*string, bool) {
	if o == nil || o.Enable == nil {
		return nil, false
	}
	return o.Enable, true
}

// HasEnable returns a boolean if a field has been set.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) HasEnable() bool {
	if o != nil && o.Enable != nil {
		return true
	}

	return false
}

// SetEnable gets a reference to the given string and assigns it to the Enable field.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) SetEnable(v string) {
	o.Enable = &v
}

// GetEnableTls returns the EnableTls field value if set, zero value otherwise.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) GetEnableTls() bool {
	if o == nil || o.EnableTls == nil {
		var ret bool
		return ret
	}
	return *o.EnableTls
}

// GetEnableTlsOk returns a tuple with the EnableTls field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) GetEnableTlsOk() (*bool, bool) {
	if o == nil || o.EnableTls == nil {
		return nil, false
	}
	return o.EnableTls, true
}

// HasEnableTls returns a boolean if a field has been set.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) HasEnableTls() bool {
	if o != nil && o.EnableTls != nil {
		return true
	}

	return false
}

// SetEnableTls gets a reference to the given bool and assigns it to the EnableTls field.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) SetEnableTls(v bool) {
	o.EnableTls = &v
}

// GetIndex returns the Index field value if set, zero value otherwise.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) GetIndex() string {
	if o == nil || o.Index == nil {
		var ret string
		return ret
	}
	return *o.Index
}

// GetIndexOk returns a tuple with the Index field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) GetIndexOk() (*string, bool) {
	if o == nil || o.Index == nil {
		return nil, false
	}
	return o.Index, true
}

// HasIndex returns a boolean if a field has been set.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) HasIndex() bool {
	if o != nil && o.Index != nil {
		return true
	}

	return false
}

// SetIndex gets a reference to the given string and assigns it to the Index field.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) SetIndex(v string) {
	o.Index = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) SetJson(v bool) {
	o.Json = &v
}

// GetNodes returns the Nodes field value if set, zero value otherwise.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) GetNodes() string {
	if o == nil || o.Nodes == nil {
		var ret string
		return ret
	}
	return *o.Nodes
}

// GetNodesOk returns a tuple with the Nodes field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) GetNodesOk() (*string, bool) {
	if o == nil || o.Nodes == nil {
		return nil, false
	}
	return o.Nodes, true
}

// HasNodes returns a boolean if a field has been set.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) HasNodes() bool {
	if o != nil && o.Nodes != nil {
		return true
	}

	return false
}

// SetNodes gets a reference to the given string and assigns it to the Nodes field.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) SetNodes(v string) {
	o.Nodes = &v
}

// GetOutputFormat returns the OutputFormat field value if set, zero value otherwise.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) GetOutputFormat() string {
	if o == nil || o.OutputFormat == nil {
		var ret string
		return ret
	}
	return *o.OutputFormat
}

// GetOutputFormatOk returns a tuple with the OutputFormat field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) GetOutputFormatOk() (*string, bool) {
	if o == nil || o.OutputFormat == nil {
		return nil, false
	}
	return o.OutputFormat, true
}

// HasOutputFormat returns a boolean if a field has been set.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) HasOutputFormat() bool {
	if o != nil && o.OutputFormat != nil {
		return true
	}

	return false
}

// SetOutputFormat gets a reference to the given string and assigns it to the OutputFormat field.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) SetOutputFormat(v string) {
	o.OutputFormat = &v
}

// GetPassword returns the Password field value if set, zero value otherwise.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) GetPassword() string {
	if o == nil || o.Password == nil {
		var ret string
		return ret
	}
	return *o.Password
}

// GetPasswordOk returns a tuple with the Password field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) GetPasswordOk() (*string, bool) {
	if o == nil || o.Password == nil {
		return nil, false
	}
	return o.Password, true
}

// HasPassword returns a boolean if a field has been set.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) HasPassword() bool {
	if o != nil && o.Password != nil {
		return true
	}

	return false
}

// SetPassword gets a reference to the given string and assigns it to the Password field.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) SetPassword(v string) {
	o.Password = &v
}

// GetPullInterval returns the PullInterval field value if set, zero value otherwise.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) GetPullInterval() string {
	if o == nil || o.PullInterval == nil {
		var ret string
		return ret
	}
	return *o.PullInterval
}

// GetPullIntervalOk returns a tuple with the PullInterval field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) GetPullIntervalOk() (*string, bool) {
	if o == nil || o.PullInterval == nil {
		return nil, false
	}
	return o.PullInterval, true
}

// HasPullInterval returns a boolean if a field has been set.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) HasPullInterval() bool {
	if o != nil && o.PullInterval != nil {
		return true
	}

	return false
}

// SetPullInterval gets a reference to the given string and assigns it to the PullInterval field.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) SetPullInterval(v string) {
	o.PullInterval = &v
}

// GetServerType returns the ServerType field value if set, zero value otherwise.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) GetServerType() string {
	if o == nil || o.ServerType == nil {
		var ret string
		return ret
	}
	return *o.ServerType
}

// GetServerTypeOk returns a tuple with the ServerType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) GetServerTypeOk() (*string, bool) {
	if o == nil || o.ServerType == nil {
		return nil, false
	}
	return o.ServerType, true
}

// HasServerType returns a boolean if a field has been set.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) HasServerType() bool {
	if o != nil && o.ServerType != nil {
		return true
	}

	return false
}

// SetServerType gets a reference to the given string and assigns it to the ServerType field.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) SetServerType(v string) {
	o.ServerType = &v
}

// GetTlsCertificate returns the TlsCertificate field value if set, zero value otherwise.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) GetTlsCertificate() string {
	if o == nil || o.TlsCertificate == nil {
		var ret string
		return ret
	}
	return *o.TlsCertificate
}

// GetTlsCertificateOk returns a tuple with the TlsCertificate field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) GetTlsCertificateOk() (*string, bool) {
	if o == nil || o.TlsCertificate == nil {
		return nil, false
	}
	return o.TlsCertificate, true
}

// HasTlsCertificate returns a boolean if a field has been set.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) HasTlsCertificate() bool {
	if o != nil && o.TlsCertificate != nil {
		return true
	}

	return false
}

// SetTlsCertificate gets a reference to the given string and assigns it to the TlsCertificate field.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) SetTlsCertificate(v string) {
	o.TlsCertificate = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) SetUidToken(v string) {
	o.UidToken = &v
}

// GetUserName returns the UserName field value if set, zero value otherwise.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) GetUserName() string {
	if o == nil || o.UserName == nil {
		var ret string
		return ret
	}
	return *o.UserName
}

// GetUserNameOk returns a tuple with the UserName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) GetUserNameOk() (*string, bool) {
	if o == nil || o.UserName == nil {
		return nil, false
	}
	return o.UserName, true
}

// HasUserName returns a boolean if a field has been set.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) HasUserName() bool {
	if o != nil && o.UserName != nil {
		return true
	}

	return false
}

// SetUserName gets a reference to the given string and assigns it to the UserName field.
func (o *GwUpdateRemoteAccessSessionLogsElasticsearch) SetUserName(v string) {
	o.UserName = &v
}

func (o GwUpdateRemoteAccessSessionLogsElasticsearch) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.ApiKey != nil {
		toSerialize["api-key"] = o.ApiKey
	}
	if o.AuthType != nil {
		toSerialize["auth-type"] = o.AuthType
	}
	if o.CloudId != nil {
		toSerialize["cloud-id"] = o.CloudId
	}
	if o.Enable != nil {
		toSerialize["enable"] = o.Enable
	}
	if o.EnableTls != nil {
		toSerialize["enable-tls"] = o.EnableTls
	}
	if o.Index != nil {
		toSerialize["index"] = o.Index
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.Nodes != nil {
		toSerialize["nodes"] = o.Nodes
	}
	if o.OutputFormat != nil {
		toSerialize["output-format"] = o.OutputFormat
	}
	if o.Password != nil {
		toSerialize["password"] = o.Password
	}
	if o.PullInterval != nil {
		toSerialize["pull-interval"] = o.PullInterval
	}
	if o.ServerType != nil {
		toSerialize["server-type"] = o.ServerType
	}
	if o.TlsCertificate != nil {
		toSerialize["tls-certificate"] = o.TlsCertificate
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	if o.UserName != nil {
		toSerialize["user-name"] = o.UserName
	}
	return json.Marshal(toSerialize)
}

type NullableGwUpdateRemoteAccessSessionLogsElasticsearch struct {
	value *GwUpdateRemoteAccessSessionLogsElasticsearch
	isSet bool
}

func (v NullableGwUpdateRemoteAccessSessionLogsElasticsearch) Get() *GwUpdateRemoteAccessSessionLogsElasticsearch {
	return v.value
}

func (v *NullableGwUpdateRemoteAccessSessionLogsElasticsearch) Set(val *GwUpdateRemoteAccessSessionLogsElasticsearch) {
	v.value = val
	v.isSet = true
}

func (v NullableGwUpdateRemoteAccessSessionLogsElasticsearch) IsSet() bool {
	return v.isSet
}

func (v *NullableGwUpdateRemoteAccessSessionLogsElasticsearch) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableGwUpdateRemoteAccessSessionLogsElasticsearch(val *GwUpdateRemoteAccessSessionLogsElasticsearch) *NullableGwUpdateRemoteAccessSessionLogsElasticsearch {
	return &NullableGwUpdateRemoteAccessSessionLogsElasticsearch{value: val, isSet: true}
}

func (v NullableGwUpdateRemoteAccessSessionLogsElasticsearch) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableGwUpdateRemoteAccessSessionLogsElasticsearch) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


