/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// ListGroupsOutput struct for ListGroupsOutput
type ListGroupsOutput struct {
	Groups *[]Group `json:"groups,omitempty"`
	NextPage *string `json:"next_page,omitempty"`
}

// NewListGroupsOutput instantiates a new ListGroupsOutput object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewListGroupsOutput() *ListGroupsOutput {
	this := ListGroupsOutput{}
	return &this
}

// NewListGroupsOutputWithDefaults instantiates a new ListGroupsOutput object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewListGroupsOutputWithDefaults() *ListGroupsOutput {
	this := ListGroupsOutput{}
	return &this
}

// GetGroups returns the Groups field value if set, zero value otherwise.
func (o *ListGroupsOutput) GetGroups() []Group {
	if o == nil || o.Groups == nil {
		var ret []Group
		return ret
	}
	return *o.Groups
}

// GetGroupsOk returns a tuple with the Groups field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ListGroupsOutput) GetGroupsOk() (*[]Group, bool) {
	if o == nil || o.Groups == nil {
		return nil, false
	}
	return o.Groups, true
}

// HasGroups returns a boolean if a field has been set.
func (o *ListGroupsOutput) HasGroups() bool {
	if o != nil && o.Groups != nil {
		return true
	}

	return false
}

// SetGroups gets a reference to the given []Group and assigns it to the Groups field.
func (o *ListGroupsOutput) SetGroups(v []Group) {
	o.Groups = &v
}

// GetNextPage returns the NextPage field value if set, zero value otherwise.
func (o *ListGroupsOutput) GetNextPage() string {
	if o == nil || o.NextPage == nil {
		var ret string
		return ret
	}
	return *o.NextPage
}

// GetNextPageOk returns a tuple with the NextPage field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ListGroupsOutput) GetNextPageOk() (*string, bool) {
	if o == nil || o.NextPage == nil {
		return nil, false
	}
	return o.NextPage, true
}

// HasNextPage returns a boolean if a field has been set.
func (o *ListGroupsOutput) HasNextPage() bool {
	if o != nil && o.NextPage != nil {
		return true
	}

	return false
}

// SetNextPage gets a reference to the given string and assigns it to the NextPage field.
func (o *ListGroupsOutput) SetNextPage(v string) {
	o.NextPage = &v
}

func (o ListGroupsOutput) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Groups != nil {
		toSerialize["groups"] = o.Groups
	}
	if o.NextPage != nil {
		toSerialize["next_page"] = o.NextPage
	}
	return json.Marshal(toSerialize)
}

type NullableListGroupsOutput struct {
	value *ListGroupsOutput
	isSet bool
}

func (v NullableListGroupsOutput) Get() *ListGroupsOutput {
	return v.value
}

func (v *NullableListGroupsOutput) Set(val *ListGroupsOutput) {
	v.value = val
	v.isSet = true
}

func (v NullableListGroupsOutput) IsSet() bool {
	return v.isSet
}

func (v *NullableListGroupsOutput) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableListGroupsOutput(val *ListGroupsOutput) *NullableListGroupsOutput {
	return &NullableListGroupsOutput{value: val, isSet: true}
}

func (v NullableListGroupsOutput) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableListGroupsOutput) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


