/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// RoleAssociationDetails RoleAssociationDetails includes details of an association between a role and an auth method.
type RoleAssociationDetails struct {
	AssocId *string `json:"assoc_id,omitempty"`
	AuthMethodName *string `json:"auth_method_name,omitempty"`
	AuthMethodSubClaims *map[string][]string `json:"auth_method_sub_claims,omitempty"`
	IsSubclaimsWithOperator *bool `json:"is_subclaims_with_operator,omitempty"`
	RoleName *string `json:"role_name,omitempty"`
	SubClaimsCaseSensitive *bool `json:"sub_claims_case_sensitive,omitempty"`
}

// NewRoleAssociationDetails instantiates a new RoleAssociationDetails object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewRoleAssociationDetails() *RoleAssociationDetails {
	this := RoleAssociationDetails{}
	return &this
}

// NewRoleAssociationDetailsWithDefaults instantiates a new RoleAssociationDetails object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewRoleAssociationDetailsWithDefaults() *RoleAssociationDetails {
	this := RoleAssociationDetails{}
	return &this
}

// GetAssocId returns the AssocId field value if set, zero value otherwise.
func (o *RoleAssociationDetails) GetAssocId() string {
	if o == nil || o.AssocId == nil {
		var ret string
		return ret
	}
	return *o.AssocId
}

// GetAssocIdOk returns a tuple with the AssocId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RoleAssociationDetails) GetAssocIdOk() (*string, bool) {
	if o == nil || o.AssocId == nil {
		return nil, false
	}
	return o.AssocId, true
}

// HasAssocId returns a boolean if a field has been set.
func (o *RoleAssociationDetails) HasAssocId() bool {
	if o != nil && o.AssocId != nil {
		return true
	}

	return false
}

// SetAssocId gets a reference to the given string and assigns it to the AssocId field.
func (o *RoleAssociationDetails) SetAssocId(v string) {
	o.AssocId = &v
}

// GetAuthMethodName returns the AuthMethodName field value if set, zero value otherwise.
func (o *RoleAssociationDetails) GetAuthMethodName() string {
	if o == nil || o.AuthMethodName == nil {
		var ret string
		return ret
	}
	return *o.AuthMethodName
}

// GetAuthMethodNameOk returns a tuple with the AuthMethodName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RoleAssociationDetails) GetAuthMethodNameOk() (*string, bool) {
	if o == nil || o.AuthMethodName == nil {
		return nil, false
	}
	return o.AuthMethodName, true
}

// HasAuthMethodName returns a boolean if a field has been set.
func (o *RoleAssociationDetails) HasAuthMethodName() bool {
	if o != nil && o.AuthMethodName != nil {
		return true
	}

	return false
}

// SetAuthMethodName gets a reference to the given string and assigns it to the AuthMethodName field.
func (o *RoleAssociationDetails) SetAuthMethodName(v string) {
	o.AuthMethodName = &v
}

// GetAuthMethodSubClaims returns the AuthMethodSubClaims field value if set, zero value otherwise.
func (o *RoleAssociationDetails) GetAuthMethodSubClaims() map[string][]string {
	if o == nil || o.AuthMethodSubClaims == nil {
		var ret map[string][]string
		return ret
	}
	return *o.AuthMethodSubClaims
}

// GetAuthMethodSubClaimsOk returns a tuple with the AuthMethodSubClaims field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RoleAssociationDetails) GetAuthMethodSubClaimsOk() (*map[string][]string, bool) {
	if o == nil || o.AuthMethodSubClaims == nil {
		return nil, false
	}
	return o.AuthMethodSubClaims, true
}

// HasAuthMethodSubClaims returns a boolean if a field has been set.
func (o *RoleAssociationDetails) HasAuthMethodSubClaims() bool {
	if o != nil && o.AuthMethodSubClaims != nil {
		return true
	}

	return false
}

// SetAuthMethodSubClaims gets a reference to the given map[string][]string and assigns it to the AuthMethodSubClaims field.
func (o *RoleAssociationDetails) SetAuthMethodSubClaims(v map[string][]string) {
	o.AuthMethodSubClaims = &v
}

// GetIsSubclaimsWithOperator returns the IsSubclaimsWithOperator field value if set, zero value otherwise.
func (o *RoleAssociationDetails) GetIsSubclaimsWithOperator() bool {
	if o == nil || o.IsSubclaimsWithOperator == nil {
		var ret bool
		return ret
	}
	return *o.IsSubclaimsWithOperator
}

// GetIsSubclaimsWithOperatorOk returns a tuple with the IsSubclaimsWithOperator field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RoleAssociationDetails) GetIsSubclaimsWithOperatorOk() (*bool, bool) {
	if o == nil || o.IsSubclaimsWithOperator == nil {
		return nil, false
	}
	return o.IsSubclaimsWithOperator, true
}

// HasIsSubclaimsWithOperator returns a boolean if a field has been set.
func (o *RoleAssociationDetails) HasIsSubclaimsWithOperator() bool {
	if o != nil && o.IsSubclaimsWithOperator != nil {
		return true
	}

	return false
}

// SetIsSubclaimsWithOperator gets a reference to the given bool and assigns it to the IsSubclaimsWithOperator field.
func (o *RoleAssociationDetails) SetIsSubclaimsWithOperator(v bool) {
	o.IsSubclaimsWithOperator = &v
}

// GetRoleName returns the RoleName field value if set, zero value otherwise.
func (o *RoleAssociationDetails) GetRoleName() string {
	if o == nil || o.RoleName == nil {
		var ret string
		return ret
	}
	return *o.RoleName
}

// GetRoleNameOk returns a tuple with the RoleName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RoleAssociationDetails) GetRoleNameOk() (*string, bool) {
	if o == nil || o.RoleName == nil {
		return nil, false
	}
	return o.RoleName, true
}

// HasRoleName returns a boolean if a field has been set.
func (o *RoleAssociationDetails) HasRoleName() bool {
	if o != nil && o.RoleName != nil {
		return true
	}

	return false
}

// SetRoleName gets a reference to the given string and assigns it to the RoleName field.
func (o *RoleAssociationDetails) SetRoleName(v string) {
	o.RoleName = &v
}

// GetSubClaimsCaseSensitive returns the SubClaimsCaseSensitive field value if set, zero value otherwise.
func (o *RoleAssociationDetails) GetSubClaimsCaseSensitive() bool {
	if o == nil || o.SubClaimsCaseSensitive == nil {
		var ret bool
		return ret
	}
	return *o.SubClaimsCaseSensitive
}

// GetSubClaimsCaseSensitiveOk returns a tuple with the SubClaimsCaseSensitive field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RoleAssociationDetails) GetSubClaimsCaseSensitiveOk() (*bool, bool) {
	if o == nil || o.SubClaimsCaseSensitive == nil {
		return nil, false
	}
	return o.SubClaimsCaseSensitive, true
}

// HasSubClaimsCaseSensitive returns a boolean if a field has been set.
func (o *RoleAssociationDetails) HasSubClaimsCaseSensitive() bool {
	if o != nil && o.SubClaimsCaseSensitive != nil {
		return true
	}

	return false
}

// SetSubClaimsCaseSensitive gets a reference to the given bool and assigns it to the SubClaimsCaseSensitive field.
func (o *RoleAssociationDetails) SetSubClaimsCaseSensitive(v bool) {
	o.SubClaimsCaseSensitive = &v
}

func (o RoleAssociationDetails) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.AssocId != nil {
		toSerialize["assoc_id"] = o.AssocId
	}
	if o.AuthMethodName != nil {
		toSerialize["auth_method_name"] = o.AuthMethodName
	}
	if o.AuthMethodSubClaims != nil {
		toSerialize["auth_method_sub_claims"] = o.AuthMethodSubClaims
	}
	if o.IsSubclaimsWithOperator != nil {
		toSerialize["is_subclaims_with_operator"] = o.IsSubclaimsWithOperator
	}
	if o.RoleName != nil {
		toSerialize["role_name"] = o.RoleName
	}
	if o.SubClaimsCaseSensitive != nil {
		toSerialize["sub_claims_case_sensitive"] = o.SubClaimsCaseSensitive
	}
	return json.Marshal(toSerialize)
}

type NullableRoleAssociationDetails struct {
	value *RoleAssociationDetails
	isSet bool
}

func (v NullableRoleAssociationDetails) Get() *RoleAssociationDetails {
	return v.value
}

func (v *NullableRoleAssociationDetails) Set(val *RoleAssociationDetails) {
	v.value = val
	v.isSet = true
}

func (v NullableRoleAssociationDetails) IsSet() bool {
	return v.isSet
}

func (v *NullableRoleAssociationDetails) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableRoleAssociationDetails(val *RoleAssociationDetails) *NullableRoleAssociationDetails {
	return &NullableRoleAssociationDetails{value: val, isSet: true}
}

func (v NullableRoleAssociationDetails) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableRoleAssociationDetails) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


