/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// TargetCreateLdap targetCreateLdap is a command that creates a new ldap target
type TargetCreateLdap struct {
	// Bind DN
	BindDn string `json:"bind-dn"`
	// Bind DN Password
	BindDnPassword string `json:"bind-dn-password"`
	// Description of the object
	Description *string `json:"description,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// The name of a key that used to encrypt the target secret value (if empty, the account default protectionKey key will be used)
	Key *string `json:"key,omitempty"`
	// CA Certificate File Content
	LdapCaCert *string `json:"ldap-ca-cert,omitempty"`
	// LDAP Server URL
	LdapUrl string `json:"ldap-url"`
	// Set the maximum number of versions, limited by the account settings defaults.
	MaxVersions *string `json:"max-versions,omitempty"`
	// Target name
	Name string `json:"name"`
	// Set Ldap server type, Options:[OpenLDAP, ActiveDirectory]. Default is OpenLDAP
	ServerType *string `json:"server-type,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// Token expiration
	TokenExpiration *string `json:"token-expiration,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewTargetCreateLdap instantiates a new TargetCreateLdap object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewTargetCreateLdap(bindDn string, bindDnPassword string, ldapUrl string, name string, ) *TargetCreateLdap {
	this := TargetCreateLdap{}
	this.BindDn = bindDn
	this.BindDnPassword = bindDnPassword
	var json bool = false
	this.Json = &json
	this.LdapUrl = ldapUrl
	this.Name = name
	var serverType string = "OpenLDAP"
	this.ServerType = &serverType
	return &this
}

// NewTargetCreateLdapWithDefaults instantiates a new TargetCreateLdap object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewTargetCreateLdapWithDefaults() *TargetCreateLdap {
	this := TargetCreateLdap{}
	var json bool = false
	this.Json = &json
	var serverType string = "OpenLDAP"
	this.ServerType = &serverType
	return &this
}

// GetBindDn returns the BindDn field value
func (o *TargetCreateLdap) GetBindDn() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.BindDn
}

// GetBindDnOk returns a tuple with the BindDn field value
// and a boolean to check if the value has been set.
func (o *TargetCreateLdap) GetBindDnOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.BindDn, true
}

// SetBindDn sets field value
func (o *TargetCreateLdap) SetBindDn(v string) {
	o.BindDn = v
}

// GetBindDnPassword returns the BindDnPassword field value
func (o *TargetCreateLdap) GetBindDnPassword() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.BindDnPassword
}

// GetBindDnPasswordOk returns a tuple with the BindDnPassword field value
// and a boolean to check if the value has been set.
func (o *TargetCreateLdap) GetBindDnPasswordOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.BindDnPassword, true
}

// SetBindDnPassword sets field value
func (o *TargetCreateLdap) SetBindDnPassword(v string) {
	o.BindDnPassword = v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *TargetCreateLdap) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateLdap) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *TargetCreateLdap) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *TargetCreateLdap) SetDescription(v string) {
	o.Description = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *TargetCreateLdap) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateLdap) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *TargetCreateLdap) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *TargetCreateLdap) SetJson(v bool) {
	o.Json = &v
}

// GetKey returns the Key field value if set, zero value otherwise.
func (o *TargetCreateLdap) GetKey() string {
	if o == nil || o.Key == nil {
		var ret string
		return ret
	}
	return *o.Key
}

// GetKeyOk returns a tuple with the Key field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateLdap) GetKeyOk() (*string, bool) {
	if o == nil || o.Key == nil {
		return nil, false
	}
	return o.Key, true
}

// HasKey returns a boolean if a field has been set.
func (o *TargetCreateLdap) HasKey() bool {
	if o != nil && o.Key != nil {
		return true
	}

	return false
}

// SetKey gets a reference to the given string and assigns it to the Key field.
func (o *TargetCreateLdap) SetKey(v string) {
	o.Key = &v
}

// GetLdapCaCert returns the LdapCaCert field value if set, zero value otherwise.
func (o *TargetCreateLdap) GetLdapCaCert() string {
	if o == nil || o.LdapCaCert == nil {
		var ret string
		return ret
	}
	return *o.LdapCaCert
}

// GetLdapCaCertOk returns a tuple with the LdapCaCert field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateLdap) GetLdapCaCertOk() (*string, bool) {
	if o == nil || o.LdapCaCert == nil {
		return nil, false
	}
	return o.LdapCaCert, true
}

// HasLdapCaCert returns a boolean if a field has been set.
func (o *TargetCreateLdap) HasLdapCaCert() bool {
	if o != nil && o.LdapCaCert != nil {
		return true
	}

	return false
}

// SetLdapCaCert gets a reference to the given string and assigns it to the LdapCaCert field.
func (o *TargetCreateLdap) SetLdapCaCert(v string) {
	o.LdapCaCert = &v
}

// GetLdapUrl returns the LdapUrl field value
func (o *TargetCreateLdap) GetLdapUrl() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.LdapUrl
}

// GetLdapUrlOk returns a tuple with the LdapUrl field value
// and a boolean to check if the value has been set.
func (o *TargetCreateLdap) GetLdapUrlOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.LdapUrl, true
}

// SetLdapUrl sets field value
func (o *TargetCreateLdap) SetLdapUrl(v string) {
	o.LdapUrl = v
}

// GetMaxVersions returns the MaxVersions field value if set, zero value otherwise.
func (o *TargetCreateLdap) GetMaxVersions() string {
	if o == nil || o.MaxVersions == nil {
		var ret string
		return ret
	}
	return *o.MaxVersions
}

// GetMaxVersionsOk returns a tuple with the MaxVersions field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateLdap) GetMaxVersionsOk() (*string, bool) {
	if o == nil || o.MaxVersions == nil {
		return nil, false
	}
	return o.MaxVersions, true
}

// HasMaxVersions returns a boolean if a field has been set.
func (o *TargetCreateLdap) HasMaxVersions() bool {
	if o != nil && o.MaxVersions != nil {
		return true
	}

	return false
}

// SetMaxVersions gets a reference to the given string and assigns it to the MaxVersions field.
func (o *TargetCreateLdap) SetMaxVersions(v string) {
	o.MaxVersions = &v
}

// GetName returns the Name field value
func (o *TargetCreateLdap) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *TargetCreateLdap) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *TargetCreateLdap) SetName(v string) {
	o.Name = v
}

// GetServerType returns the ServerType field value if set, zero value otherwise.
func (o *TargetCreateLdap) GetServerType() string {
	if o == nil || o.ServerType == nil {
		var ret string
		return ret
	}
	return *o.ServerType
}

// GetServerTypeOk returns a tuple with the ServerType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateLdap) GetServerTypeOk() (*string, bool) {
	if o == nil || o.ServerType == nil {
		return nil, false
	}
	return o.ServerType, true
}

// HasServerType returns a boolean if a field has been set.
func (o *TargetCreateLdap) HasServerType() bool {
	if o != nil && o.ServerType != nil {
		return true
	}

	return false
}

// SetServerType gets a reference to the given string and assigns it to the ServerType field.
func (o *TargetCreateLdap) SetServerType(v string) {
	o.ServerType = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *TargetCreateLdap) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateLdap) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *TargetCreateLdap) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *TargetCreateLdap) SetToken(v string) {
	o.Token = &v
}

// GetTokenExpiration returns the TokenExpiration field value if set, zero value otherwise.
func (o *TargetCreateLdap) GetTokenExpiration() string {
	if o == nil || o.TokenExpiration == nil {
		var ret string
		return ret
	}
	return *o.TokenExpiration
}

// GetTokenExpirationOk returns a tuple with the TokenExpiration field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateLdap) GetTokenExpirationOk() (*string, bool) {
	if o == nil || o.TokenExpiration == nil {
		return nil, false
	}
	return o.TokenExpiration, true
}

// HasTokenExpiration returns a boolean if a field has been set.
func (o *TargetCreateLdap) HasTokenExpiration() bool {
	if o != nil && o.TokenExpiration != nil {
		return true
	}

	return false
}

// SetTokenExpiration gets a reference to the given string and assigns it to the TokenExpiration field.
func (o *TargetCreateLdap) SetTokenExpiration(v string) {
	o.TokenExpiration = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *TargetCreateLdap) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateLdap) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *TargetCreateLdap) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *TargetCreateLdap) SetUidToken(v string) {
	o.UidToken = &v
}

func (o TargetCreateLdap) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if true {
		toSerialize["bind-dn"] = o.BindDn
	}
	if true {
		toSerialize["bind-dn-password"] = o.BindDnPassword
	}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.Key != nil {
		toSerialize["key"] = o.Key
	}
	if o.LdapCaCert != nil {
		toSerialize["ldap-ca-cert"] = o.LdapCaCert
	}
	if true {
		toSerialize["ldap-url"] = o.LdapUrl
	}
	if o.MaxVersions != nil {
		toSerialize["max-versions"] = o.MaxVersions
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.ServerType != nil {
		toSerialize["server-type"] = o.ServerType
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.TokenExpiration != nil {
		toSerialize["token-expiration"] = o.TokenExpiration
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableTargetCreateLdap struct {
	value *TargetCreateLdap
	isSet bool
}

func (v NullableTargetCreateLdap) Get() *TargetCreateLdap {
	return v.value
}

func (v *NullableTargetCreateLdap) Set(val *TargetCreateLdap) {
	v.value = val
	v.isSet = true
}

func (v NullableTargetCreateLdap) IsSet() bool {
	return v.isSet
}

func (v *NullableTargetCreateLdap) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableTargetCreateLdap(val *TargetCreateLdap) *NullableTargetCreateLdap {
	return &NullableTargetCreateLdap{value: val, isSet: true}
}

func (v NullableTargetCreateLdap) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableTargetCreateLdap) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


