/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// TargetGetDetails struct for TargetGetDetails
type TargetGetDetails struct {
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Target name
	Name string `json:"name"`
	// Include all target versions in reply
	ShowVersions *bool `json:"show-versions,omitempty"`
	// Target version
	TargetVersion *int32 `json:"target-version,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewTargetGetDetails instantiates a new TargetGetDetails object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewTargetGetDetails(name string, ) *TargetGetDetails {
	this := TargetGetDetails{}
	var json bool = false
	this.Json = &json
	this.Name = name
	var showVersions bool = false
	this.ShowVersions = &showVersions
	return &this
}

// NewTargetGetDetailsWithDefaults instantiates a new TargetGetDetails object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewTargetGetDetailsWithDefaults() *TargetGetDetails {
	this := TargetGetDetails{}
	var json bool = false
	this.Json = &json
	var showVersions bool = false
	this.ShowVersions = &showVersions
	return &this
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *TargetGetDetails) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetGetDetails) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *TargetGetDetails) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *TargetGetDetails) SetJson(v bool) {
	o.Json = &v
}

// GetName returns the Name field value
func (o *TargetGetDetails) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *TargetGetDetails) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *TargetGetDetails) SetName(v string) {
	o.Name = v
}

// GetShowVersions returns the ShowVersions field value if set, zero value otherwise.
func (o *TargetGetDetails) GetShowVersions() bool {
	if o == nil || o.ShowVersions == nil {
		var ret bool
		return ret
	}
	return *o.ShowVersions
}

// GetShowVersionsOk returns a tuple with the ShowVersions field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetGetDetails) GetShowVersionsOk() (*bool, bool) {
	if o == nil || o.ShowVersions == nil {
		return nil, false
	}
	return o.ShowVersions, true
}

// HasShowVersions returns a boolean if a field has been set.
func (o *TargetGetDetails) HasShowVersions() bool {
	if o != nil && o.ShowVersions != nil {
		return true
	}

	return false
}

// SetShowVersions gets a reference to the given bool and assigns it to the ShowVersions field.
func (o *TargetGetDetails) SetShowVersions(v bool) {
	o.ShowVersions = &v
}

// GetTargetVersion returns the TargetVersion field value if set, zero value otherwise.
func (o *TargetGetDetails) GetTargetVersion() int32 {
	if o == nil || o.TargetVersion == nil {
		var ret int32
		return ret
	}
	return *o.TargetVersion
}

// GetTargetVersionOk returns a tuple with the TargetVersion field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetGetDetails) GetTargetVersionOk() (*int32, bool) {
	if o == nil || o.TargetVersion == nil {
		return nil, false
	}
	return o.TargetVersion, true
}

// HasTargetVersion returns a boolean if a field has been set.
func (o *TargetGetDetails) HasTargetVersion() bool {
	if o != nil && o.TargetVersion != nil {
		return true
	}

	return false
}

// SetTargetVersion gets a reference to the given int32 and assigns it to the TargetVersion field.
func (o *TargetGetDetails) SetTargetVersion(v int32) {
	o.TargetVersion = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *TargetGetDetails) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetGetDetails) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *TargetGetDetails) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *TargetGetDetails) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *TargetGetDetails) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetGetDetails) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *TargetGetDetails) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *TargetGetDetails) SetUidToken(v string) {
	o.UidToken = &v
}

func (o TargetGetDetails) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.ShowVersions != nil {
		toSerialize["show-versions"] = o.ShowVersions
	}
	if o.TargetVersion != nil {
		toSerialize["target-version"] = o.TargetVersion
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableTargetGetDetails struct {
	value *TargetGetDetails
	isSet bool
}

func (v NullableTargetGetDetails) Get() *TargetGetDetails {
	return v.value
}

func (v *NullableTargetGetDetails) Set(val *TargetGetDetails) {
	v.value = val
	v.isSet = true
}

func (v NullableTargetGetDetails) IsSet() bool {
	return v.isSet
}

func (v *NullableTargetGetDetails) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableTargetGetDetails(val *TargetGetDetails) *NullableTargetGetDetails {
	return &NullableTargetGetDetails{value: val, isSet: true}
}

func (v NullableTargetGetDetails) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableTargetGetDetails) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


