/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.crypto;

import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;

public class CryptographicMac
extends NativeHandleGuard.SimpleOwner {
    public CryptographicMac(String algo, byte[] key) {
        super(FilterExceptions.filterExceptions(() -> Native.CryptographicMac_New(algo, key)));
    }

    @Override
    protected void release(long nativeHandle) {
        Native.CryptographicMac_Destroy(nativeHandle);
    }

    public void update(byte[] input, int offset, int len) {
        this.guardedRun(nativeHandle -> Native.CryptographicMac_UpdateWithOffset(nativeHandle, input, offset, len));
    }

    public void update(byte[] input) {
        this.guardedRun(nativeHandle -> Native.CryptographicMac_Update(nativeHandle, input));
    }

    public byte[] finish() {
        return this.guardedMap(Native::CryptographicMac_Finalize);
    }
}

