/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.attachment;

import java.io.InputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.optionals.OptionalsKt;
import org.jetbrains.annotations.NotNull;
import org.whispersystems.signalservice.api.NetworkResult;
import org.whispersystems.signalservice.api.attachment.AttachmentUploadResult;
import org.whispersystems.signalservice.api.crypto.AttachmentCipherStreamUtil;
import org.whispersystems.signalservice.api.messages.SignalServiceAttachment;
import org.whispersystems.signalservice.api.messages.SignalServiceAttachmentRemoteId;
import org.whispersystems.signalservice.api.messages.SignalServiceAttachmentStream;
import org.whispersystems.signalservice.api.websocket.SignalWebSocket;
import org.whispersystems.signalservice.internal.WebSocketRequestExtKt;
import org.whispersystems.signalservice.internal.crypto.AttachmentDigest;
import org.whispersystems.signalservice.internal.crypto.PaddingInputStream;
import org.whispersystems.signalservice.internal.push.AttachmentUploadForm;
import org.whispersystems.signalservice.internal.push.PushAttachmentData;
import org.whispersystems.signalservice.internal.push.PushServiceSocket;
import org.whispersystems.signalservice.internal.push.http.AttachmentCipherOutputStreamFactory;
import org.whispersystems.signalservice.internal.push.http.CancelationSignal;
import org.whispersystems.signalservice.internal.push.http.OutputStreamFactory;
import org.whispersystems.signalservice.internal.push.http.ResumableUploadSpec;
import org.whispersystems.signalservice.internal.websocket.WebSocketRequestMessage;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ$\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\nJ\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\t2\u0006\u0010\u0013\u001a\u00020\u0014J,\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\t2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00180\t2\u0006\u0010\u0010\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/whispersystems/signalservice/api/attachment/AttachmentApi;", "", "authWebSocket", "Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$AuthenticatedWebSocket;", "pushServiceSocket", "Lorg/whispersystems/signalservice/internal/push/PushServiceSocket;", "<init>", "(Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$AuthenticatedWebSocket;Lorg/whispersystems/signalservice/internal/push/PushServiceSocket;)V", "getAttachmentV4UploadForm", "Lorg/whispersystems/signalservice/api/NetworkResult;", "Lorg/whispersystems/signalservice/internal/push/AttachmentUploadForm;", "getResumableUploadSpec", "Lorg/whispersystems/signalservice/internal/push/http/ResumableUploadSpec;", "key", "", "iv", "uploadForm", "uploadAttachmentV4", "Lorg/whispersystems/signalservice/api/attachment/AttachmentUploadResult;", "attachmentStream", "Lorg/whispersystems/signalservice/api/messages/SignalServiceAttachmentStream;", "uploadPreEncryptedFileToAttachmentV4", "", "resumableUploadUrl", "", "inputStream", "Ljava/io/InputStream;", "inputStreamLength", "", "getResumableUploadUrl", "signal-service-java"})
public final class AttachmentApi {
    @NotNull
    private final SignalWebSocket.AuthenticatedWebSocket authWebSocket;
    @NotNull
    private final PushServiceSocket pushServiceSocket;

    public AttachmentApi(@NotNull SignalWebSocket.AuthenticatedWebSocket authWebSocket, @NotNull PushServiceSocket pushServiceSocket) {
        Intrinsics.checkNotNullParameter((Object)authWebSocket, (String)"authWebSocket");
        Intrinsics.checkNotNullParameter((Object)pushServiceSocket, (String)"pushServiceSocket");
        this.authWebSocket = authWebSocket;
        this.pushServiceSocket = pushServiceSocket;
    }

    @NotNull
    public final NetworkResult<AttachmentUploadForm> getAttachmentV4UploadForm() {
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.get$default(WebSocketRequestMessage.Companion, "/v4/attachments/form/upload", null, 2, null);
        return NetworkResult.Companion.fromWebSocketRequest-Wn2Vu4Y$default(NetworkResult.Companion, this.authWebSocket, request2, Reflection.getOrCreateKotlinClass(AttachmentUploadForm.class), 0L, 8, null);
    }

    @NotNull
    public final NetworkResult<ResumableUploadSpec> getResumableUploadSpec(@NotNull byte[] key, @NotNull byte[] iv, @NotNull AttachmentUploadForm uploadForm) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
        Intrinsics.checkNotNullParameter((Object)uploadForm, (String)"uploadForm");
        return this.getResumableUploadUrl(uploadForm).map(arg_0 -> AttachmentApi.getResumableUploadSpec$lambda$0(key, iv, uploadForm, arg_0));
    }

    @NotNull
    public final NetworkResult<AttachmentUploadResult> uploadAttachmentV4(@NotNull SignalServiceAttachmentStream attachmentStream) {
        Intrinsics.checkNotNullParameter((Object)attachmentStream, (String)"attachmentStream");
        if (attachmentStream.getResumableUploadSpec().isEmpty()) {
            throw new IllegalStateException("Attachment must have a resumable upload spec!");
        }
        return NetworkResult.Companion.fromFetch(() -> AttachmentApi.uploadAttachmentV4$lambda$1(attachmentStream, this));
    }

    @NotNull
    public final NetworkResult<Unit> uploadPreEncryptedFileToAttachmentV4(@NotNull AttachmentUploadForm uploadForm, @NotNull String resumableUploadUrl, @NotNull InputStream inputStream, long inputStreamLength) {
        Intrinsics.checkNotNullParameter((Object)uploadForm, (String)"uploadForm");
        Intrinsics.checkNotNullParameter((Object)resumableUploadUrl, (String)"resumableUploadUrl");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        return NetworkResult.Companion.fromFetch(() -> AttachmentApi.uploadPreEncryptedFileToAttachmentV4$lambda$2(this, uploadForm, resumableUploadUrl, inputStream, inputStreamLength));
    }

    @NotNull
    public final NetworkResult<String> getResumableUploadUrl(@NotNull AttachmentUploadForm uploadForm) {
        Intrinsics.checkNotNullParameter((Object)uploadForm, (String)"uploadForm");
        return NetworkResult.Companion.fromFetch(() -> AttachmentApi.getResumableUploadUrl$lambda$3(this, uploadForm));
    }

    private static final ResumableUploadSpec getResumableUploadSpec$lambda$0(byte[] $key, byte[] $iv, AttachmentUploadForm $uploadForm, String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return new ResumableUploadSpec($key, $iv, $uploadForm.key, $uploadForm.cdn, url, System.currentTimeMillis() + PushServiceSocket.CDN2_RESUMABLE_LINK_LIFETIME_MILLIS, $uploadForm.headers);
    }

    private static final AttachmentUploadResult uploadAttachmentV4$lambda$1(SignalServiceAttachmentStream $attachmentStream, AttachmentApi this$0) {
        ResumableUploadSpec resumableUploadSpec = $attachmentStream.getResumableUploadSpec().get();
        Intrinsics.checkNotNullExpressionValue((Object)resumableUploadSpec, (String)"get(...)");
        ResumableUploadSpec resumableUploadSpec2 = resumableUploadSpec;
        long paddedLength = PaddingInputStream.getPaddedSize($attachmentStream.getLength());
        InputStream dataStream = new PaddingInputStream($attachmentStream.getInputStream(), $attachmentStream.getLength());
        long ciphertextLength = AttachmentCipherStreamUtil.getCiphertextLength(paddedLength);
        String string = $attachmentStream.getContentType();
        boolean bl = $attachmentStream.isFaststart();
        OutputStreamFactory outputStreamFactory = new AttachmentCipherOutputStreamFactory(resumableUploadSpec2.getAttachmentKey(), resumableUploadSpec2.getAttachmentIv());
        SignalServiceAttachment.ProgressListener progressListener = $attachmentStream.getListener();
        CancelationSignal cancelationSignal = $attachmentStream.getCancelationSignal();
        ResumableUploadSpec resumableUploadSpec3 = $attachmentStream.getResumableUploadSpec().get();
        Intrinsics.checkNotNullExpressionValue((Object)resumableUploadSpec3, (String)"get(...)");
        PushAttachmentData attachmentData = new PushAttachmentData(string, dataStream, ciphertextLength, bl, outputStreamFactory, progressListener, cancelationSignal, resumableUploadSpec3);
        AttachmentDigest digestInfo = this$0.pushServiceSocket.uploadAttachment(attachmentData);
        SignalServiceAttachmentRemoteId.V4 v4 = new SignalServiceAttachmentRemoteId.V4(attachmentData.getResumableUploadSpec().getCdnKey());
        int n = attachmentData.getResumableUploadSpec().getCdnNumber();
        byte[] byArray = resumableUploadSpec2.getAttachmentKey();
        byte[] byArray2 = digestInfo.getDigest();
        byte[] byArray3 = digestInfo.getIncrementalDigest();
        int n2 = digestInfo.getIncrementalMacChunkSize();
        long l = $attachmentStream.getUploadTimestamp();
        long l2 = $attachmentStream.getLength();
        String string2 = (String)OptionalsKt.getOrNull($attachmentStream.getBlurHash());
        return new AttachmentUploadResult(v4, n, byArray, byArray2, byArray3, n2, l2, l, string2);
    }

    private static final Unit uploadPreEncryptedFileToAttachmentV4$lambda$2(AttachmentApi this$0, AttachmentUploadForm $uploadForm, String $resumableUploadUrl, InputStream $inputStream, long $inputStreamLength) {
        this$0.pushServiceSocket.uploadBackupFile($uploadForm, $resumableUploadUrl, $inputStream, $inputStreamLength);
        return Unit.INSTANCE;
    }

    private static final String getResumableUploadUrl$lambda$3(AttachmentApi this$0, AttachmentUploadForm $uploadForm) {
        String string = this$0.pushServiceSocket.getResumableUploadUrl($uploadForm);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getResumableUploadUrl(...)");
        return string;
    }
}

