/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	context "context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
	wardlev1alpha1 "k8s.io/sample-apiserver/pkg/apis/wardle/v1alpha1"
	applyconfigurationwardlev1alpha1 "k8s.io/sample-apiserver/pkg/generated/applyconfiguration/wardle/v1alpha1"
	scheme "k8s.io/sample-apiserver/pkg/generated/clientset/versioned/scheme"
)

// FischersGetter has a method to return a FischerInterface.
// A group's client should implement this interface.
type FischersGetter interface {
	Fischers() FischerInterface
}

// FischerInterface has methods to work with Fischer resources.
type FischerInterface interface {
	Create(ctx context.Context, fischer *wardlev1alpha1.Fischer, opts v1.CreateOptions) (*wardlev1alpha1.Fischer, error)
	Update(ctx context.Context, fischer *wardlev1alpha1.Fischer, opts v1.UpdateOptions) (*wardlev1alpha1.Fischer, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*wardlev1alpha1.Fischer, error)
	List(ctx context.Context, opts v1.ListOptions) (*wardlev1alpha1.FischerList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *wardlev1alpha1.Fischer, err error)
	Apply(ctx context.Context, fischer *applyconfigurationwardlev1alpha1.FischerApplyConfiguration, opts v1.ApplyOptions) (result *wardlev1alpha1.Fischer, err error)
	FischerExpansion
}

// fischers implements FischerInterface
type fischers struct {
	*gentype.ClientWithListAndApply[*wardlev1alpha1.Fischer, *wardlev1alpha1.FischerList, *applyconfigurationwardlev1alpha1.FischerApplyConfiguration]
}

// newFischers returns a Fischers
func newFischers(c *WardleV1alpha1Client) *fischers {
	return &fischers{
		gentype.NewClientWithListAndApply[*wardlev1alpha1.Fischer, *wardlev1alpha1.FischerList, *applyconfigurationwardlev1alpha1.FischerApplyConfiguration](
			"fischers",
			c.RESTClient(),
			scheme.ParameterCodec,
			"",
			func() *wardlev1alpha1.Fischer { return &wardlev1alpha1.Fischer{} },
			func() *wardlev1alpha1.FischerList { return &wardlev1alpha1.FischerList{} },
		),
	}
}
