/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.lsp;

import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.mwe.PathTraverser;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.IFileSystemScanner;
import org.eclipse.xtext.util.UriExtensions;

@Singleton
public class ClasspathPropertiesBasedFileSystemScanner
implements IFileSystemScanner {
    private static final Logger LOGGER = Logger.getLogger(ClasspathPropertiesBasedFileSystemScanner.class);
    private static final Predicate<String> MODEL = Pattern.compile("^\\w+\\.(model|src).\\d+$").asPredicate();
    static final String XTEXT_CLASSPATH = "xtext.classpath";
    @Inject
    private UriExtensions uriExtensions;

    public void scan(URI root, IAcceptor<URI> acceptor) {
        Properties classpath = this.getProjectClasspath(root);
        ArrayList<String> modelPaths = new ArrayList<String>();
        if (classpath != null) {
            classpath.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                String key = (String)k;
                String value = (String)v;
                if (MODEL.test(key)) {
                    modelPaths.add(value);
                }
            }));
        } else {
            modelPaths.add(new File(root.toFileString()).getAbsolutePath());
        }
        IResourceServiceProvider.Registry registry = IResourceServiceProvider.Registry.INSTANCE;
        Multimap byPath = new PathTraverser().resolvePathes(modelPaths, uri -> registry.getResourceServiceProvider(uri) != null);
        LOGGER.debug((Object)"Initial files:");
        byPath.values().forEach(uri -> {
            URI lspCompliant = this.uriExtensions.withEmptyAuthority(uri);
            LOGGER.debug((Object)lspCompliant);
            acceptor.accept((Object)lspCompliant);
        });
    }

    protected Properties getProjectClasspath(URI root) {
        return Optional.ofNullable(root).map(URI::toFileString).map(File::new).map(base -> {
            File classPathInfo = this.configFile((File)base);
            if (classPathInfo.exists()) {
                Properties properties = new Properties();
                try {
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (FileReader reader = new FileReader(classPathInfo, StandardCharsets.UTF_8);){
                        properties.load(reader);
                        return properties;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            return null;
        }).orElse(null);
    }

    protected File configFile(File base) {
        return new File(new File(base, "target"), XTEXT_CLASSPATH);
    }
}

