/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.transport.impl.async;

import java.io.IOException;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jupnp.protocol.ProtocolFactory;
import org.jupnp.transport.impl.ServletUpnpStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AsyncServletUpnpStream
extends ServletUpnpStream
implements AsyncListener {
    private final Logger logger = LoggerFactory.getLogger(AsyncServletUpnpStream.class);
    protected final AsyncContext asyncContext;
    protected final HttpServletRequest request;

    protected AsyncServletUpnpStream(ProtocolFactory protocolFactory, AsyncContext asyncContext, HttpServletRequest request) {
        super(protocolFactory);
        this.asyncContext = asyncContext;
        this.request = request;
        asyncContext.addListener((AsyncListener)this);
    }

    @Override
    protected HttpServletRequest getRequest() {
        return this.request;
    }

    @Override
    protected HttpServletResponse getResponse() {
        ServletResponse response = this.asyncContext.getResponse();
        if (response == null) {
            throw new IllegalStateException("Couldn't get response from asynchronous context, already timed out");
        }
        return (HttpServletResponse)response;
    }

    @Override
    protected void complete() {
        try {
            this.asyncContext.complete();
        }
        catch (IllegalStateException e) {
            this.logger.info("Error calling servlet container's AsyncContext#complete() method", (Throwable)e);
        }
    }

    public void onStartAsync(AsyncEvent event) throws IOException {
    }

    public void onComplete(AsyncEvent event) throws IOException {
        this.logger.trace("Completed asynchronous processing of HTTP request: {}", (Object)event.getSuppliedRequest());
        this.responseSent(this.responseMessage);
    }

    public void onTimeout(AsyncEvent event) throws IOException {
        this.logger.trace("Asynchronous processing of HTTP request timed out: {}", (Object)event.getSuppliedRequest());
        this.responseException(new Exception("Asynchronous request timed out"));
    }

    public void onError(AsyncEvent event) throws IOException {
        this.logger.trace("Asynchronous processing of HTTP request error", event.getThrowable());
        this.responseException(event.getThrowable());
    }

    @Override
    public String toString() {
        return "" + this.hashCode();
    }
}

