/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.jarjar;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.pantsbuild.jarjar.MainProcessor;
import org.pantsbuild.jarjar.PatternElement;
import org.pantsbuild.jarjar.RulesFileParser;
import org.pantsbuild.jarjar.util.StandaloneJarProcessor;

public class JarJarMojo
extends AbstractMojo {
    private File fromJar;
    private File toJar;
    private File rulesFile;
    private String rules;
    private boolean verbose;

    @Override
    public void execute() throws MojoExecutionException {
        if (!((this.rulesFile == null || !this.rulesFile.exists()) ^ this.rules == null)) {
            throw new MojoExecutionException("Exactly one of rules or rulesFile is required");
        }
        try {
            List<PatternElement> list = this.rules != null ? RulesFileParser.parse(this.rules) : RulesFileParser.parse(this.rulesFile);
            MainProcessor mainProcessor = new MainProcessor(list, this.verbose, true);
            StandaloneJarProcessor.run(this.fromJar, this.toJar, mainProcessor);
            mainProcessor.strip(this.toJar);
        }
        catch (IOException iOException) {
            throw new MojoExecutionException(iOException.getMessage(), iOException);
        }
    }
}

