/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.ai.AIMessage;
import org.jkiss.dbeaver.model.ai.AIPromptGenerator;
import org.jkiss.dbeaver.model.ai.AISchemaGenerationOptions;
import org.jkiss.dbeaver.model.ai.AISettings;
import org.jkiss.dbeaver.model.ai.engine.AIDatabaseContext;
import org.jkiss.dbeaver.model.ai.engine.AIEngine;
import org.jkiss.dbeaver.model.ai.engine.AIEngineRequest;
import org.jkiss.dbeaver.model.ai.impl.AIDatabaseSnapshotService;
import org.jkiss.dbeaver.model.ai.impl.ChatTruncator;
import org.jkiss.dbeaver.model.ai.impl.TokenCounter;
import org.jkiss.dbeaver.model.ai.registry.AIEngineDescriptor;
import org.jkiss.dbeaver.model.ai.registry.AIFunctionDescriptor;
import org.jkiss.dbeaver.model.ai.registry.AIFunctionRegistry;
import org.jkiss.dbeaver.model.ai.registry.AISettingsManager;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class AIEngineRequestFactory {
    private static final Log log = Log.getLog(AIEngineRequestFactory.class);
    private static final String DB_SNAPSHOT_SECTION_HEADER = "Database snapshot:\n";
    private static final int SYSTEM_PROMPT_TOKEN_BUDGET_PERCENT = 80;
    private static final int REPLY_TOKEN_RESERVE = 2000;
    private static final int OVERHEAD_TOKEN_RESERVE = 100;
    private final AIDatabaseSnapshotService databaseSnapshotService;
    private final TokenCounter tokenCounter;

    public AIEngineRequestFactory(@NotNull AIDatabaseSnapshotService databaseSnapshotService, @NotNull TokenCounter tokenCounter) {
        this.databaseSnapshotService = databaseSnapshotService;
        this.tokenCounter = tokenCounter;
    }

    public AIEngineRequest build(@NotNull DBRProgressMonitor monitor, @NotNull AIEngine engine, @NotNull AIEngineDescriptor engineDescriptor, @NotNull AIPromptGenerator systemPromptGenerator, @Nullable AIDatabaseContext databaseContext, @NotNull List<AIMessage> messages) throws DBException {
        AISchemaGenerationOptions ddlOptions;
        AIDatabaseSnapshotService.TokenBoundedStringBuilder dbSnapshotBuilder;
        String systemPrompt = systemPromptGenerator.build();
        int maxContextWindowSize = AIEngineRequestFactory.getContextWindowSize(monitor, engine);
        int availableContextTokens = maxContextWindowSize - 2000 - 100;
        if (availableContextTokens < 0) {
            availableContextTokens = 0;
        }
        int systemPromptTokenBudget = availableContextTokens * 80 / 100;
        int snapshotHeaderTokenCount = this.tokenCounter.count(DB_SNAPSHOT_SECTION_HEADER);
        int systemPromptTokenCount = this.tokenCounter.count(systemPrompt);
        int dbSnapshotTokenBudget = systemPromptTokenBudget - systemPromptTokenCount - snapshotHeaderTokenCount;
        if (dbSnapshotTokenBudget < 0) {
            dbSnapshotTokenBudget = 0;
        }
        String dbSnapshot = "";
        boolean isContextTruncated = false;
        if (databaseContext != null && dbSnapshotTokenBudget > 0 && (dbSnapshotBuilder = this.databaseSnapshotService.createDbSnapshot(monitor, databaseContext, ddlOptions = this.buildOptions(dbSnapshotTokenBudget))) != null) {
            dbSnapshot = dbSnapshotBuilder.toString();
            isContextTruncated = dbSnapshotBuilder.isTruncated();
        }
        String fullSystemPrompt = dbSnapshot.isBlank() ? systemPrompt : systemPrompt + "\nDatabase snapshot:\n" + dbSnapshot;
        AIMessage systemMessage = AIMessage.systemMessage(fullSystemPrompt);
        ChatTruncator chatTruncator = ChatTruncator.builder().maxTokens(maxContextWindowSize).reserveForSystem(systemPromptTokenBudget).reserveForReply(2000).reserveForOverhead(100).tokenCounter(this.tokenCounter).build();
        ArrayList<AIMessage> allMessages = new ArrayList<AIMessage>(1 + messages.size());
        allMessages.add(systemMessage);
        allMessages.addAll(messages);
        List<AIMessage> truncated = chatTruncator.truncate(allMessages);
        AIEngineRequest request = new AIEngineRequest(truncated);
        request.setWasPromptTruncated(isContextTruncated);
        this.determineRequestTools(monitor, engineDescriptor, systemPromptGenerator, request);
        return request;
    }

    protected void determineRequestTools(@NotNull DBRProgressMonitor monitor, @NotNull AIEngineDescriptor engineDescriptor, @NotNull AIPromptGenerator systemPromptGenerator, @NotNull AIEngineRequest request) {
        if (!engineDescriptor.isSupportsFunctions()) {
            return;
        }
        ArrayList<AIFunctionDescriptor> functions = new ArrayList<AIFunctionDescriptor>();
        for (AIFunctionDescriptor fd : AIFunctionRegistry.getInstance().getAllFunctions()) {
            if (!fd.isGlobal() && !fd.isApplicable(engineDescriptor, systemPromptGenerator)) continue;
            functions.add(fd);
        }
        AISettings aiSettings = AISettingsManager.getInstance().getSettings();
        Set<String> enabledFunctions = aiSettings.getEnabledFunctions();
        Set<String> enabledFunctionCategories = aiSettings.getEnabledFunctionCategories();
        functions.removeIf(aiFunctionDescriptor -> !enabledFunctions.contains(aiFunctionDescriptor.getId()) && !enabledFunctionCategories.contains(aiFunctionDescriptor.getCategoryId()));
        request.setFunctions(functions);
    }

    private static int getContextWindowSize(@NotNull DBRProgressMonitor monitor, @NotNull AIEngine engine) {
        try {
            return engine.getContextWindowSize(monitor);
        }
        catch (DBException e) {
            log.debug((Object)("Cannot determine engine " + String.valueOf(engine) + " context window size. Set to default 16384"), (Throwable)e);
            return 16384;
        }
    }

    protected AISchemaGenerationOptions buildOptions(int dbSnapshotTokenBudget) {
        DBPPreferenceStore prefs = DBWorkbench.getPlatform().getPreferenceStore();
        return AISchemaGenerationOptions.builder().withMaxDbSnapshotTokens(dbSnapshotTokenBudget).withSendObjectComment(prefs.getBoolean("ai.completion.description")).withSendColumnTypes(prefs.getBoolean("ai.completion.sendType")).build();
    }
}

