/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.cli.command;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.cli.ApplicationInstanceController;
import org.jkiss.dbeaver.model.cli.CLIProcessResult;
import org.jkiss.dbeaver.model.cli.CLIRunMeta;
import org.jkiss.dbeaver.model.cli.CommandLineContext;
import org.jkiss.dbeaver.model.cli.model.CommandLineAuthenticator;
import org.jkiss.dbeaver.model.cli.model.option.EclipseOptions;
import org.jkiss.dbeaver.model.cli.model.option.HiddenOptions;
import picocli.CommandLine;

public abstract class AbstractTopLevelCommand
implements Runnable,
CommandLine.IExitCodeGenerator {
    private final Log log = Log.getLog(this.getClass());
    @CommandLine.Option(names={"-dump"}, description={"Print instance thread dump"})
    private boolean dump;
    @CommandLine.Mixin
    private EclipseOptions eclipseOptions;
    @CommandLine.Mixin
    private HiddenOptions hiddenOptions;
    @NotNull
    protected final CLIRunMeta meta;
    @Nullable
    protected final ApplicationInstanceController controller;
    @NotNull
    protected final CommandLineContext context;
    private int code = 0;

    protected AbstractTopLevelCommand(@Nullable ApplicationInstanceController controller, @NotNull CommandLineContext context, @NotNull CLIRunMeta meta) {
        this.controller = controller;
        this.context = context;
        this.meta = meta;
    }

    @Override
    public void run() {
        try {
            if (!this.meta.isUiActivated() && this.dump) {
                if (this.controller == null) {
                    this.log.debug((Object)"Can't process commands because no running instance is present");
                    this.context.setPostAction(CLIProcessResult.PostAction.START_INSTANCE);
                    return;
                }
                String threadDump = this.controller.getThreadDump();
                System.out.println(threadDump);
                this.context.addResult(threadDump);
                this.context.setPostAction(CLIProcessResult.PostAction.SHUTDOWN);
                return;
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error executing command", (Throwable)e);
            this.code = 1;
        }
    }

    public int getExitCode() {
        return this.code;
    }

    @NotNull
    public CommandLineContext getContext() {
        return this.context;
    }

    @Nullable
    public ApplicationInstanceController getController() {
        return this.controller;
    }

    @NotNull
    public CLIRunMeta getMeta() {
        return this.meta;
    }

    @Nullable
    public CommandLineAuthenticator getAuthenticator() {
        return null;
    }
}

