// Code generated by radius-dict-gen. DO NOT EDIT.

package rfc2865

import (
	"net"
	"strconv"

	"layeh.com/radius"
)

const (
	UserName_Type               radius.Type = 1
	UserPassword_Type           radius.Type = 2
	CHAPPassword_Type           radius.Type = 3
	NASIPAddress_Type           radius.Type = 4
	NASPort_Type                radius.Type = 5
	ServiceType_Type            radius.Type = 6
	FramedProtocol_Type         radius.Type = 7
	FramedIPAddress_Type        radius.Type = 8
	FramedIPNetmask_Type        radius.Type = 9
	FramedRouting_Type          radius.Type = 10
	FilterID_Type               radius.Type = 11
	FramedMTU_Type              radius.Type = 12
	FramedCompression_Type      radius.Type = 13
	LoginIPHost_Type            radius.Type = 14
	LoginService_Type           radius.Type = 15
	LoginTCPPort_Type           radius.Type = 16
	ReplyMessage_Type           radius.Type = 18
	CallbackNumber_Type         radius.Type = 19
	CallbackID_Type             radius.Type = 20
	FramedRoute_Type            radius.Type = 22
	FramedIPXNetwork_Type       radius.Type = 23
	State_Type                  radius.Type = 24
	Class_Type                  radius.Type = 25
	VendorSpecific_Type         radius.Type = 26
	SessionTimeout_Type         radius.Type = 27
	IdleTimeout_Type            radius.Type = 28
	TerminationAction_Type      radius.Type = 29
	CalledStationID_Type        radius.Type = 30
	CallingStationID_Type       radius.Type = 31
	NASIdentifier_Type          radius.Type = 32
	ProxyState_Type             radius.Type = 33
	LoginLATService_Type        radius.Type = 34
	LoginLATNode_Type           radius.Type = 35
	LoginLATGroup_Type          radius.Type = 36
	FramedAppleTalkLink_Type    radius.Type = 37
	FramedAppleTalkNetwork_Type radius.Type = 38
	FramedAppleTalkZone_Type    radius.Type = 39
	CHAPChallenge_Type          radius.Type = 60
	NASPortType_Type            radius.Type = 61
	PortLimit_Type              radius.Type = 62
	LoginLATPort_Type           radius.Type = 63
)

func UserName_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Add(UserName_Type, a)
	return
}

func UserName_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Add(UserName_Type, a)
	return
}

func UserName_Get(p *radius.Packet) (value []byte) {
	value, _ = UserName_Lookup(p)
	return
}

func UserName_GetString(p *radius.Packet) (value string) {
	value, _ = UserName_LookupString(p)
	return
}

func UserName_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, avp := range p.Attributes {
		if avp.Type != UserName_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func UserName_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, avp := range p.Attributes {
		if avp.Type != UserName_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func UserName_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := p.Lookup(UserName_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func UserName_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := p.Lookup(UserName_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func UserName_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Set(UserName_Type, a)
	return
}

func UserName_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Set(UserName_Type, a)
	return
}

func UserName_Del(p *radius.Packet) {
	p.Attributes.Del(UserName_Type)
}

func UserPassword_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewUserPassword(value, p.Secret, p.Authenticator[:])
	if err != nil {
		return
	}
	p.Add(UserPassword_Type, a)
	return
}

func UserPassword_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewUserPassword([]byte(value), p.Secret, p.Authenticator[:])
	if err != nil {
		return
	}
	p.Add(UserPassword_Type, a)
	return
}

func UserPassword_Get(p *radius.Packet) (value []byte) {
	value, _ = UserPassword_Lookup(p)
	return
}

func UserPassword_GetString(p *radius.Packet) (value string) {
	value, _ = UserPassword_LookupString(p)
	return
}

func UserPassword_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, avp := range p.Attributes {
		if avp.Type != UserPassword_Type {
			continue
		}
		attr := avp.Attribute
		i, err = radius.UserPassword(attr, p.Secret, p.Authenticator[:])
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func UserPassword_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, avp := range p.Attributes {
		if avp.Type != UserPassword_Type {
			continue
		}
		attr := avp.Attribute
		var up []byte
		up, err = radius.UserPassword(attr, p.Secret, p.Authenticator[:])
		if err == nil {
			i = string(up)
		}
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func UserPassword_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := p.Lookup(UserPassword_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value, err = radius.UserPassword(a, p.Secret, p.Authenticator[:])
	return
}

func UserPassword_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := p.Lookup(UserPassword_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var b []byte
	b, err = radius.UserPassword(a, p.Secret, p.Authenticator[:])
	if err == nil {
		value = string(b)
	}
	return
}

func UserPassword_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewUserPassword(value, p.Secret, p.Authenticator[:])
	if err != nil {
		return
	}
	p.Set(UserPassword_Type, a)
	return
}

func UserPassword_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewUserPassword([]byte(value), p.Secret, p.Authenticator[:])
	if err != nil {
		return
	}
	p.Set(UserPassword_Type, a)
	return
}

func UserPassword_Del(p *radius.Packet) {
	p.Attributes.Del(UserPassword_Type)
}

func CHAPPassword_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Add(CHAPPassword_Type, a)
	return
}

func CHAPPassword_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Add(CHAPPassword_Type, a)
	return
}

func CHAPPassword_Get(p *radius.Packet) (value []byte) {
	value, _ = CHAPPassword_Lookup(p)
	return
}

func CHAPPassword_GetString(p *radius.Packet) (value string) {
	value, _ = CHAPPassword_LookupString(p)
	return
}

func CHAPPassword_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, avp := range p.Attributes {
		if avp.Type != CHAPPassword_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func CHAPPassword_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, avp := range p.Attributes {
		if avp.Type != CHAPPassword_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func CHAPPassword_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := p.Lookup(CHAPPassword_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func CHAPPassword_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := p.Lookup(CHAPPassword_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func CHAPPassword_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Set(CHAPPassword_Type, a)
	return
}

func CHAPPassword_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Set(CHAPPassword_Type, a)
	return
}

func CHAPPassword_Del(p *radius.Packet) {
	p.Attributes.Del(CHAPPassword_Type)
}

func NASIPAddress_Add(p *radius.Packet, value net.IP) (err error) {
	var a radius.Attribute
	a, err = radius.NewIPAddr(value)
	if err != nil {
		return
	}
	p.Add(NASIPAddress_Type, a)
	return
}

func NASIPAddress_Get(p *radius.Packet) (value net.IP) {
	value, _ = NASIPAddress_Lookup(p)
	return
}

func NASIPAddress_Gets(p *radius.Packet) (values []net.IP, err error) {
	var i net.IP
	for _, avp := range p.Attributes {
		if avp.Type != NASIPAddress_Type {
			continue
		}
		attr := avp.Attribute
		i, err = radius.IPAddr(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func NASIPAddress_Lookup(p *radius.Packet) (value net.IP, err error) {
	a, ok := p.Lookup(NASIPAddress_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value, err = radius.IPAddr(a)
	return
}

func NASIPAddress_Set(p *radius.Packet, value net.IP) (err error) {
	var a radius.Attribute
	a, err = radius.NewIPAddr(value)
	if err != nil {
		return
	}
	p.Set(NASIPAddress_Type, a)
	return
}

func NASIPAddress_Del(p *radius.Packet) {
	p.Attributes.Del(NASIPAddress_Type)
}

type NASPort uint32

var NASPort_Strings = map[NASPort]string{}

func (a NASPort) String() string {
	if str, ok := NASPort_Strings[a]; ok {
		return str
	}
	return "NASPort(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func NASPort_Add(p *radius.Packet, value NASPort) (err error) {
	a := radius.NewInteger(uint32(value))
	p.Add(NASPort_Type, a)
	return
}

func NASPort_Get(p *radius.Packet) (value NASPort) {
	value, _ = NASPort_Lookup(p)
	return
}

func NASPort_Gets(p *radius.Packet) (values []NASPort, err error) {
	var i uint32
	for _, avp := range p.Attributes {
		if avp.Type != NASPort_Type {
			continue
		}
		attr := avp.Attribute
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, NASPort(i))
	}
	return
}

func NASPort_Lookup(p *radius.Packet) (value NASPort, err error) {
	a, ok := p.Lookup(NASPort_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = NASPort(i)
	return
}

func NASPort_Set(p *radius.Packet, value NASPort) (err error) {
	a := radius.NewInteger(uint32(value))
	p.Set(NASPort_Type, a)
	return
}

func NASPort_Del(p *radius.Packet) {
	p.Attributes.Del(NASPort_Type)
}

type ServiceType uint32

const (
	ServiceType_Value_LoginUser              ServiceType = 1
	ServiceType_Value_FramedUser             ServiceType = 2
	ServiceType_Value_CallbackLoginUser      ServiceType = 3
	ServiceType_Value_CallbackFramedUser     ServiceType = 4
	ServiceType_Value_OutboundUser           ServiceType = 5
	ServiceType_Value_AdministrativeUser     ServiceType = 6
	ServiceType_Value_NASPromptUser          ServiceType = 7
	ServiceType_Value_AuthenticateOnly       ServiceType = 8
	ServiceType_Value_CallbackNASPrompt      ServiceType = 9
	ServiceType_Value_CallCheck              ServiceType = 10
	ServiceType_Value_CallbackAdministrative ServiceType = 11
)

var ServiceType_Strings = map[ServiceType]string{
	ServiceType_Value_LoginUser:              "Login-User",
	ServiceType_Value_FramedUser:             "Framed-User",
	ServiceType_Value_CallbackLoginUser:      "Callback-Login-User",
	ServiceType_Value_CallbackFramedUser:     "Callback-Framed-User",
	ServiceType_Value_OutboundUser:           "Outbound-User",
	ServiceType_Value_AdministrativeUser:     "Administrative-User",
	ServiceType_Value_NASPromptUser:          "NAS-Prompt-User",
	ServiceType_Value_AuthenticateOnly:       "Authenticate-Only",
	ServiceType_Value_CallbackNASPrompt:      "Callback-NAS-Prompt",
	ServiceType_Value_CallCheck:              "Call-Check",
	ServiceType_Value_CallbackAdministrative: "Callback-Administrative",
}

func (a ServiceType) String() string {
	if str, ok := ServiceType_Strings[a]; ok {
		return str
	}
	return "ServiceType(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func ServiceType_Add(p *radius.Packet, value ServiceType) (err error) {
	a := radius.NewInteger(uint32(value))
	p.Add(ServiceType_Type, a)
	return
}

func ServiceType_Get(p *radius.Packet) (value ServiceType) {
	value, _ = ServiceType_Lookup(p)
	return
}

func ServiceType_Gets(p *radius.Packet) (values []ServiceType, err error) {
	var i uint32
	for _, avp := range p.Attributes {
		if avp.Type != ServiceType_Type {
			continue
		}
		attr := avp.Attribute
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, ServiceType(i))
	}
	return
}

func ServiceType_Lookup(p *radius.Packet) (value ServiceType, err error) {
	a, ok := p.Lookup(ServiceType_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = ServiceType(i)
	return
}

func ServiceType_Set(p *radius.Packet, value ServiceType) (err error) {
	a := radius.NewInteger(uint32(value))
	p.Set(ServiceType_Type, a)
	return
}

func ServiceType_Del(p *radius.Packet) {
	p.Attributes.Del(ServiceType_Type)
}

type FramedProtocol uint32

const (
	FramedProtocol_Value_PPP             FramedProtocol = 1
	FramedProtocol_Value_SLIP            FramedProtocol = 2
	FramedProtocol_Value_ARAP            FramedProtocol = 3
	FramedProtocol_Value_GandalfSLML     FramedProtocol = 4
	FramedProtocol_Value_XylogicsIPXSLIP FramedProtocol = 5
	FramedProtocol_Value_X75Synchronous  FramedProtocol = 6
)

var FramedProtocol_Strings = map[FramedProtocol]string{
	FramedProtocol_Value_PPP:             "PPP",
	FramedProtocol_Value_SLIP:            "SLIP",
	FramedProtocol_Value_ARAP:            "ARAP",
	FramedProtocol_Value_GandalfSLML:     "Gandalf-SLML",
	FramedProtocol_Value_XylogicsIPXSLIP: "Xylogics-IPX-SLIP",
	FramedProtocol_Value_X75Synchronous:  "X.75-Synchronous",
}

func (a FramedProtocol) String() string {
	if str, ok := FramedProtocol_Strings[a]; ok {
		return str
	}
	return "FramedProtocol(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func FramedProtocol_Add(p *radius.Packet, value FramedProtocol) (err error) {
	a := radius.NewInteger(uint32(value))
	p.Add(FramedProtocol_Type, a)
	return
}

func FramedProtocol_Get(p *radius.Packet) (value FramedProtocol) {
	value, _ = FramedProtocol_Lookup(p)
	return
}

func FramedProtocol_Gets(p *radius.Packet) (values []FramedProtocol, err error) {
	var i uint32
	for _, avp := range p.Attributes {
		if avp.Type != FramedProtocol_Type {
			continue
		}
		attr := avp.Attribute
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, FramedProtocol(i))
	}
	return
}

func FramedProtocol_Lookup(p *radius.Packet) (value FramedProtocol, err error) {
	a, ok := p.Lookup(FramedProtocol_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = FramedProtocol(i)
	return
}

func FramedProtocol_Set(p *radius.Packet, value FramedProtocol) (err error) {
	a := radius.NewInteger(uint32(value))
	p.Set(FramedProtocol_Type, a)
	return
}

func FramedProtocol_Del(p *radius.Packet) {
	p.Attributes.Del(FramedProtocol_Type)
}

func FramedIPAddress_Add(p *radius.Packet, value net.IP) (err error) {
	var a radius.Attribute
	a, err = radius.NewIPAddr(value)
	if err != nil {
		return
	}
	p.Add(FramedIPAddress_Type, a)
	return
}

func FramedIPAddress_Get(p *radius.Packet) (value net.IP) {
	value, _ = FramedIPAddress_Lookup(p)
	return
}

func FramedIPAddress_Gets(p *radius.Packet) (values []net.IP, err error) {
	var i net.IP
	for _, avp := range p.Attributes {
		if avp.Type != FramedIPAddress_Type {
			continue
		}
		attr := avp.Attribute
		i, err = radius.IPAddr(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func FramedIPAddress_Lookup(p *radius.Packet) (value net.IP, err error) {
	a, ok := p.Lookup(FramedIPAddress_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value, err = radius.IPAddr(a)
	return
}

func FramedIPAddress_Set(p *radius.Packet, value net.IP) (err error) {
	var a radius.Attribute
	a, err = radius.NewIPAddr(value)
	if err != nil {
		return
	}
	p.Set(FramedIPAddress_Type, a)
	return
}

func FramedIPAddress_Del(p *radius.Packet) {
	p.Attributes.Del(FramedIPAddress_Type)
}

func FramedIPNetmask_Add(p *radius.Packet, value net.IP) (err error) {
	var a radius.Attribute
	a, err = radius.NewIPAddr(value)
	if err != nil {
		return
	}
	p.Add(FramedIPNetmask_Type, a)
	return
}

func FramedIPNetmask_Get(p *radius.Packet) (value net.IP) {
	value, _ = FramedIPNetmask_Lookup(p)
	return
}

func FramedIPNetmask_Gets(p *radius.Packet) (values []net.IP, err error) {
	var i net.IP
	for _, avp := range p.Attributes {
		if avp.Type != FramedIPNetmask_Type {
			continue
		}
		attr := avp.Attribute
		i, err = radius.IPAddr(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func FramedIPNetmask_Lookup(p *radius.Packet) (value net.IP, err error) {
	a, ok := p.Lookup(FramedIPNetmask_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value, err = radius.IPAddr(a)
	return
}

func FramedIPNetmask_Set(p *radius.Packet, value net.IP) (err error) {
	var a radius.Attribute
	a, err = radius.NewIPAddr(value)
	if err != nil {
		return
	}
	p.Set(FramedIPNetmask_Type, a)
	return
}

func FramedIPNetmask_Del(p *radius.Packet) {
	p.Attributes.Del(FramedIPNetmask_Type)
}

type FramedRouting uint32

const (
	FramedRouting_Value_None            FramedRouting = 0
	FramedRouting_Value_Broadcast       FramedRouting = 1
	FramedRouting_Value_Listen          FramedRouting = 2
	FramedRouting_Value_BroadcastListen FramedRouting = 3
)

var FramedRouting_Strings = map[FramedRouting]string{
	FramedRouting_Value_None:            "None",
	FramedRouting_Value_Broadcast:       "Broadcast",
	FramedRouting_Value_Listen:          "Listen",
	FramedRouting_Value_BroadcastListen: "Broadcast-Listen",
}

func (a FramedRouting) String() string {
	if str, ok := FramedRouting_Strings[a]; ok {
		return str
	}
	return "FramedRouting(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func FramedRouting_Add(p *radius.Packet, value FramedRouting) (err error) {
	a := radius.NewInteger(uint32(value))
	p.Add(FramedRouting_Type, a)
	return
}

func FramedRouting_Get(p *radius.Packet) (value FramedRouting) {
	value, _ = FramedRouting_Lookup(p)
	return
}

func FramedRouting_Gets(p *radius.Packet) (values []FramedRouting, err error) {
	var i uint32
	for _, avp := range p.Attributes {
		if avp.Type != FramedRouting_Type {
			continue
		}
		attr := avp.Attribute
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, FramedRouting(i))
	}
	return
}

func FramedRouting_Lookup(p *radius.Packet) (value FramedRouting, err error) {
	a, ok := p.Lookup(FramedRouting_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = FramedRouting(i)
	return
}

func FramedRouting_Set(p *radius.Packet, value FramedRouting) (err error) {
	a := radius.NewInteger(uint32(value))
	p.Set(FramedRouting_Type, a)
	return
}

func FramedRouting_Del(p *radius.Packet) {
	p.Attributes.Del(FramedRouting_Type)
}

func FilterID_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Add(FilterID_Type, a)
	return
}

func FilterID_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Add(FilterID_Type, a)
	return
}

func FilterID_Get(p *radius.Packet) (value []byte) {
	value, _ = FilterID_Lookup(p)
	return
}

func FilterID_GetString(p *radius.Packet) (value string) {
	value, _ = FilterID_LookupString(p)
	return
}

func FilterID_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, avp := range p.Attributes {
		if avp.Type != FilterID_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func FilterID_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, avp := range p.Attributes {
		if avp.Type != FilterID_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func FilterID_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := p.Lookup(FilterID_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func FilterID_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := p.Lookup(FilterID_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func FilterID_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Set(FilterID_Type, a)
	return
}

func FilterID_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Set(FilterID_Type, a)
	return
}

func FilterID_Del(p *radius.Packet) {
	p.Attributes.Del(FilterID_Type)
}

type FramedMTU uint32

var FramedMTU_Strings = map[FramedMTU]string{}

func (a FramedMTU) String() string {
	if str, ok := FramedMTU_Strings[a]; ok {
		return str
	}
	return "FramedMTU(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func FramedMTU_Add(p *radius.Packet, value FramedMTU) (err error) {
	a := radius.NewInteger(uint32(value))
	p.Add(FramedMTU_Type, a)
	return
}

func FramedMTU_Get(p *radius.Packet) (value FramedMTU) {
	value, _ = FramedMTU_Lookup(p)
	return
}

func FramedMTU_Gets(p *radius.Packet) (values []FramedMTU, err error) {
	var i uint32
	for _, avp := range p.Attributes {
		if avp.Type != FramedMTU_Type {
			continue
		}
		attr := avp.Attribute
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, FramedMTU(i))
	}
	return
}

func FramedMTU_Lookup(p *radius.Packet) (value FramedMTU, err error) {
	a, ok := p.Lookup(FramedMTU_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = FramedMTU(i)
	return
}

func FramedMTU_Set(p *radius.Packet, value FramedMTU) (err error) {
	a := radius.NewInteger(uint32(value))
	p.Set(FramedMTU_Type, a)
	return
}

func FramedMTU_Del(p *radius.Packet) {
	p.Attributes.Del(FramedMTU_Type)
}

type FramedCompression uint32

const (
	FramedCompression_Value_None                 FramedCompression = 0
	FramedCompression_Value_VanJacobsonTCPIP     FramedCompression = 1
	FramedCompression_Value_IPXHeaderCompression FramedCompression = 2
	FramedCompression_Value_StacLZS              FramedCompression = 3
)

var FramedCompression_Strings = map[FramedCompression]string{
	FramedCompression_Value_None:                 "None",
	FramedCompression_Value_VanJacobsonTCPIP:     "Van-Jacobson-TCP-IP",
	FramedCompression_Value_IPXHeaderCompression: "IPX-Header-Compression",
	FramedCompression_Value_StacLZS:              "Stac-LZS",
}

func (a FramedCompression) String() string {
	if str, ok := FramedCompression_Strings[a]; ok {
		return str
	}
	return "FramedCompression(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func FramedCompression_Add(p *radius.Packet, value FramedCompression) (err error) {
	a := radius.NewInteger(uint32(value))
	p.Add(FramedCompression_Type, a)
	return
}

func FramedCompression_Get(p *radius.Packet) (value FramedCompression) {
	value, _ = FramedCompression_Lookup(p)
	return
}

func FramedCompression_Gets(p *radius.Packet) (values []FramedCompression, err error) {
	var i uint32
	for _, avp := range p.Attributes {
		if avp.Type != FramedCompression_Type {
			continue
		}
		attr := avp.Attribute
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, FramedCompression(i))
	}
	return
}

func FramedCompression_Lookup(p *radius.Packet) (value FramedCompression, err error) {
	a, ok := p.Lookup(FramedCompression_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = FramedCompression(i)
	return
}

func FramedCompression_Set(p *radius.Packet, value FramedCompression) (err error) {
	a := radius.NewInteger(uint32(value))
	p.Set(FramedCompression_Type, a)
	return
}

func FramedCompression_Del(p *radius.Packet) {
	p.Attributes.Del(FramedCompression_Type)
}

func LoginIPHost_Add(p *radius.Packet, value net.IP) (err error) {
	var a radius.Attribute
	a, err = radius.NewIPAddr(value)
	if err != nil {
		return
	}
	p.Add(LoginIPHost_Type, a)
	return
}

func LoginIPHost_Get(p *radius.Packet) (value net.IP) {
	value, _ = LoginIPHost_Lookup(p)
	return
}

func LoginIPHost_Gets(p *radius.Packet) (values []net.IP, err error) {
	var i net.IP
	for _, avp := range p.Attributes {
		if avp.Type != LoginIPHost_Type {
			continue
		}
		attr := avp.Attribute
		i, err = radius.IPAddr(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func LoginIPHost_Lookup(p *radius.Packet) (value net.IP, err error) {
	a, ok := p.Lookup(LoginIPHost_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value, err = radius.IPAddr(a)
	return
}

func LoginIPHost_Set(p *radius.Packet, value net.IP) (err error) {
	var a radius.Attribute
	a, err = radius.NewIPAddr(value)
	if err != nil {
		return
	}
	p.Set(LoginIPHost_Type, a)
	return
}

func LoginIPHost_Del(p *radius.Packet) {
	p.Attributes.Del(LoginIPHost_Type)
}

type LoginService uint32

const (
	LoginService_Value_Telnet        LoginService = 0
	LoginService_Value_Rlogin        LoginService = 1
	LoginService_Value_TCPClear      LoginService = 2
	LoginService_Value_PortMaster    LoginService = 3
	LoginService_Value_LAT           LoginService = 4
	LoginService_Value_X25PAD        LoginService = 5
	LoginService_Value_X25T3POS      LoginService = 6
	LoginService_Value_TCPClearQuiet LoginService = 8
)

var LoginService_Strings = map[LoginService]string{
	LoginService_Value_Telnet:        "Telnet",
	LoginService_Value_Rlogin:        "Rlogin",
	LoginService_Value_TCPClear:      "TCP-Clear",
	LoginService_Value_PortMaster:    "PortMaster",
	LoginService_Value_LAT:           "LAT",
	LoginService_Value_X25PAD:        "X25-PAD",
	LoginService_Value_X25T3POS:      "X25-T3POS",
	LoginService_Value_TCPClearQuiet: "TCP-Clear-Quiet",
}

func (a LoginService) String() string {
	if str, ok := LoginService_Strings[a]; ok {
		return str
	}
	return "LoginService(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func LoginService_Add(p *radius.Packet, value LoginService) (err error) {
	a := radius.NewInteger(uint32(value))
	p.Add(LoginService_Type, a)
	return
}

func LoginService_Get(p *radius.Packet) (value LoginService) {
	value, _ = LoginService_Lookup(p)
	return
}

func LoginService_Gets(p *radius.Packet) (values []LoginService, err error) {
	var i uint32
	for _, avp := range p.Attributes {
		if avp.Type != LoginService_Type {
			continue
		}
		attr := avp.Attribute
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, LoginService(i))
	}
	return
}

func LoginService_Lookup(p *radius.Packet) (value LoginService, err error) {
	a, ok := p.Lookup(LoginService_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = LoginService(i)
	return
}

func LoginService_Set(p *radius.Packet, value LoginService) (err error) {
	a := radius.NewInteger(uint32(value))
	p.Set(LoginService_Type, a)
	return
}

func LoginService_Del(p *radius.Packet) {
	p.Attributes.Del(LoginService_Type)
}

type LoginTCPPort uint32

const (
	LoginTCPPort_Value_Telnet LoginTCPPort = 23
	LoginTCPPort_Value_Rlogin LoginTCPPort = 513
	LoginTCPPort_Value_Rsh    LoginTCPPort = 514
)

var LoginTCPPort_Strings = map[LoginTCPPort]string{
	LoginTCPPort_Value_Telnet: "Telnet",
	LoginTCPPort_Value_Rlogin: "Rlogin",
	LoginTCPPort_Value_Rsh:    "Rsh",
}

func (a LoginTCPPort) String() string {
	if str, ok := LoginTCPPort_Strings[a]; ok {
		return str
	}
	return "LoginTCPPort(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func LoginTCPPort_Add(p *radius.Packet, value LoginTCPPort) (err error) {
	a := radius.NewInteger(uint32(value))
	p.Add(LoginTCPPort_Type, a)
	return
}

func LoginTCPPort_Get(p *radius.Packet) (value LoginTCPPort) {
	value, _ = LoginTCPPort_Lookup(p)
	return
}

func LoginTCPPort_Gets(p *radius.Packet) (values []LoginTCPPort, err error) {
	var i uint32
	for _, avp := range p.Attributes {
		if avp.Type != LoginTCPPort_Type {
			continue
		}
		attr := avp.Attribute
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, LoginTCPPort(i))
	}
	return
}

func LoginTCPPort_Lookup(p *radius.Packet) (value LoginTCPPort, err error) {
	a, ok := p.Lookup(LoginTCPPort_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = LoginTCPPort(i)
	return
}

func LoginTCPPort_Set(p *radius.Packet, value LoginTCPPort) (err error) {
	a := radius.NewInteger(uint32(value))
	p.Set(LoginTCPPort_Type, a)
	return
}

func LoginTCPPort_Del(p *radius.Packet) {
	p.Attributes.Del(LoginTCPPort_Type)
}

func ReplyMessage_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Add(ReplyMessage_Type, a)
	return
}

func ReplyMessage_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Add(ReplyMessage_Type, a)
	return
}

func ReplyMessage_Get(p *radius.Packet) (value []byte) {
	value, _ = ReplyMessage_Lookup(p)
	return
}

func ReplyMessage_GetString(p *radius.Packet) (value string) {
	value, _ = ReplyMessage_LookupString(p)
	return
}

func ReplyMessage_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, avp := range p.Attributes {
		if avp.Type != ReplyMessage_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ReplyMessage_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, avp := range p.Attributes {
		if avp.Type != ReplyMessage_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ReplyMessage_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := p.Lookup(ReplyMessage_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func ReplyMessage_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := p.Lookup(ReplyMessage_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func ReplyMessage_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Set(ReplyMessage_Type, a)
	return
}

func ReplyMessage_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Set(ReplyMessage_Type, a)
	return
}

func ReplyMessage_Del(p *radius.Packet) {
	p.Attributes.Del(ReplyMessage_Type)
}

func CallbackNumber_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Add(CallbackNumber_Type, a)
	return
}

func CallbackNumber_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Add(CallbackNumber_Type, a)
	return
}

func CallbackNumber_Get(p *radius.Packet) (value []byte) {
	value, _ = CallbackNumber_Lookup(p)
	return
}

func CallbackNumber_GetString(p *radius.Packet) (value string) {
	value, _ = CallbackNumber_LookupString(p)
	return
}

func CallbackNumber_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, avp := range p.Attributes {
		if avp.Type != CallbackNumber_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func CallbackNumber_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, avp := range p.Attributes {
		if avp.Type != CallbackNumber_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func CallbackNumber_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := p.Lookup(CallbackNumber_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func CallbackNumber_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := p.Lookup(CallbackNumber_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func CallbackNumber_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Set(CallbackNumber_Type, a)
	return
}

func CallbackNumber_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Set(CallbackNumber_Type, a)
	return
}

func CallbackNumber_Del(p *radius.Packet) {
	p.Attributes.Del(CallbackNumber_Type)
}

func CallbackID_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Add(CallbackID_Type, a)
	return
}

func CallbackID_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Add(CallbackID_Type, a)
	return
}

func CallbackID_Get(p *radius.Packet) (value []byte) {
	value, _ = CallbackID_Lookup(p)
	return
}

func CallbackID_GetString(p *radius.Packet) (value string) {
	value, _ = CallbackID_LookupString(p)
	return
}

func CallbackID_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, avp := range p.Attributes {
		if avp.Type != CallbackID_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func CallbackID_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, avp := range p.Attributes {
		if avp.Type != CallbackID_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func CallbackID_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := p.Lookup(CallbackID_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func CallbackID_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := p.Lookup(CallbackID_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func CallbackID_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Set(CallbackID_Type, a)
	return
}

func CallbackID_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Set(CallbackID_Type, a)
	return
}

func CallbackID_Del(p *radius.Packet) {
	p.Attributes.Del(CallbackID_Type)
}

func FramedRoute_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Add(FramedRoute_Type, a)
	return
}

func FramedRoute_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Add(FramedRoute_Type, a)
	return
}

func FramedRoute_Get(p *radius.Packet) (value []byte) {
	value, _ = FramedRoute_Lookup(p)
	return
}

func FramedRoute_GetString(p *radius.Packet) (value string) {
	value, _ = FramedRoute_LookupString(p)
	return
}

func FramedRoute_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, avp := range p.Attributes {
		if avp.Type != FramedRoute_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func FramedRoute_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, avp := range p.Attributes {
		if avp.Type != FramedRoute_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func FramedRoute_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := p.Lookup(FramedRoute_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func FramedRoute_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := p.Lookup(FramedRoute_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func FramedRoute_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Set(FramedRoute_Type, a)
	return
}

func FramedRoute_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Set(FramedRoute_Type, a)
	return
}

func FramedRoute_Del(p *radius.Packet) {
	p.Attributes.Del(FramedRoute_Type)
}

func FramedIPXNetwork_Add(p *radius.Packet, value net.IP) (err error) {
	var a radius.Attribute
	a, err = radius.NewIPAddr(value)
	if err != nil {
		return
	}
	p.Add(FramedIPXNetwork_Type, a)
	return
}

func FramedIPXNetwork_Get(p *radius.Packet) (value net.IP) {
	value, _ = FramedIPXNetwork_Lookup(p)
	return
}

func FramedIPXNetwork_Gets(p *radius.Packet) (values []net.IP, err error) {
	var i net.IP
	for _, avp := range p.Attributes {
		if avp.Type != FramedIPXNetwork_Type {
			continue
		}
		attr := avp.Attribute
		i, err = radius.IPAddr(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func FramedIPXNetwork_Lookup(p *radius.Packet) (value net.IP, err error) {
	a, ok := p.Lookup(FramedIPXNetwork_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value, err = radius.IPAddr(a)
	return
}

func FramedIPXNetwork_Set(p *radius.Packet, value net.IP) (err error) {
	var a radius.Attribute
	a, err = radius.NewIPAddr(value)
	if err != nil {
		return
	}
	p.Set(FramedIPXNetwork_Type, a)
	return
}

func FramedIPXNetwork_Del(p *radius.Packet) {
	p.Attributes.Del(FramedIPXNetwork_Type)
}

func State_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Add(State_Type, a)
	return
}

func State_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Add(State_Type, a)
	return
}

func State_Get(p *radius.Packet) (value []byte) {
	value, _ = State_Lookup(p)
	return
}

func State_GetString(p *radius.Packet) (value string) {
	value, _ = State_LookupString(p)
	return
}

func State_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, avp := range p.Attributes {
		if avp.Type != State_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func State_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, avp := range p.Attributes {
		if avp.Type != State_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func State_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := p.Lookup(State_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func State_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := p.Lookup(State_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func State_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Set(State_Type, a)
	return
}

func State_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Set(State_Type, a)
	return
}

func State_Del(p *radius.Packet) {
	p.Attributes.Del(State_Type)
}

func Class_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Add(Class_Type, a)
	return
}

func Class_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Add(Class_Type, a)
	return
}

func Class_Get(p *radius.Packet) (value []byte) {
	value, _ = Class_Lookup(p)
	return
}

func Class_GetString(p *radius.Packet) (value string) {
	value, _ = Class_LookupString(p)
	return
}

func Class_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, avp := range p.Attributes {
		if avp.Type != Class_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func Class_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, avp := range p.Attributes {
		if avp.Type != Class_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func Class_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := p.Lookup(Class_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func Class_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := p.Lookup(Class_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func Class_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Set(Class_Type, a)
	return
}

func Class_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Set(Class_Type, a)
	return
}

func Class_Del(p *radius.Packet) {
	p.Attributes.Del(Class_Type)
}

type SessionTimeout uint32

var SessionTimeout_Strings = map[SessionTimeout]string{}

func (a SessionTimeout) String() string {
	if str, ok := SessionTimeout_Strings[a]; ok {
		return str
	}
	return "SessionTimeout(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func SessionTimeout_Add(p *radius.Packet, value SessionTimeout) (err error) {
	a := radius.NewInteger(uint32(value))
	p.Add(SessionTimeout_Type, a)
	return
}

func SessionTimeout_Get(p *radius.Packet) (value SessionTimeout) {
	value, _ = SessionTimeout_Lookup(p)
	return
}

func SessionTimeout_Gets(p *radius.Packet) (values []SessionTimeout, err error) {
	var i uint32
	for _, avp := range p.Attributes {
		if avp.Type != SessionTimeout_Type {
			continue
		}
		attr := avp.Attribute
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, SessionTimeout(i))
	}
	return
}

func SessionTimeout_Lookup(p *radius.Packet) (value SessionTimeout, err error) {
	a, ok := p.Lookup(SessionTimeout_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = SessionTimeout(i)
	return
}

func SessionTimeout_Set(p *radius.Packet, value SessionTimeout) (err error) {
	a := radius.NewInteger(uint32(value))
	p.Set(SessionTimeout_Type, a)
	return
}

func SessionTimeout_Del(p *radius.Packet) {
	p.Attributes.Del(SessionTimeout_Type)
}

type IdleTimeout uint32

var IdleTimeout_Strings = map[IdleTimeout]string{}

func (a IdleTimeout) String() string {
	if str, ok := IdleTimeout_Strings[a]; ok {
		return str
	}
	return "IdleTimeout(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func IdleTimeout_Add(p *radius.Packet, value IdleTimeout) (err error) {
	a := radius.NewInteger(uint32(value))
	p.Add(IdleTimeout_Type, a)
	return
}

func IdleTimeout_Get(p *radius.Packet) (value IdleTimeout) {
	value, _ = IdleTimeout_Lookup(p)
	return
}

func IdleTimeout_Gets(p *radius.Packet) (values []IdleTimeout, err error) {
	var i uint32
	for _, avp := range p.Attributes {
		if avp.Type != IdleTimeout_Type {
			continue
		}
		attr := avp.Attribute
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, IdleTimeout(i))
	}
	return
}

func IdleTimeout_Lookup(p *radius.Packet) (value IdleTimeout, err error) {
	a, ok := p.Lookup(IdleTimeout_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = IdleTimeout(i)
	return
}

func IdleTimeout_Set(p *radius.Packet, value IdleTimeout) (err error) {
	a := radius.NewInteger(uint32(value))
	p.Set(IdleTimeout_Type, a)
	return
}

func IdleTimeout_Del(p *radius.Packet) {
	p.Attributes.Del(IdleTimeout_Type)
}

type TerminationAction uint32

const (
	TerminationAction_Value_Default       TerminationAction = 0
	TerminationAction_Value_RADIUSRequest TerminationAction = 1
)

var TerminationAction_Strings = map[TerminationAction]string{
	TerminationAction_Value_Default:       "Default",
	TerminationAction_Value_RADIUSRequest: "RADIUS-Request",
}

func (a TerminationAction) String() string {
	if str, ok := TerminationAction_Strings[a]; ok {
		return str
	}
	return "TerminationAction(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func TerminationAction_Add(p *radius.Packet, value TerminationAction) (err error) {
	a := radius.NewInteger(uint32(value))
	p.Add(TerminationAction_Type, a)
	return
}

func TerminationAction_Get(p *radius.Packet) (value TerminationAction) {
	value, _ = TerminationAction_Lookup(p)
	return
}

func TerminationAction_Gets(p *radius.Packet) (values []TerminationAction, err error) {
	var i uint32
	for _, avp := range p.Attributes {
		if avp.Type != TerminationAction_Type {
			continue
		}
		attr := avp.Attribute
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, TerminationAction(i))
	}
	return
}

func TerminationAction_Lookup(p *radius.Packet) (value TerminationAction, err error) {
	a, ok := p.Lookup(TerminationAction_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = TerminationAction(i)
	return
}

func TerminationAction_Set(p *radius.Packet, value TerminationAction) (err error) {
	a := radius.NewInteger(uint32(value))
	p.Set(TerminationAction_Type, a)
	return
}

func TerminationAction_Del(p *radius.Packet) {
	p.Attributes.Del(TerminationAction_Type)
}

func CalledStationID_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Add(CalledStationID_Type, a)
	return
}

func CalledStationID_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Add(CalledStationID_Type, a)
	return
}

func CalledStationID_Get(p *radius.Packet) (value []byte) {
	value, _ = CalledStationID_Lookup(p)
	return
}

func CalledStationID_GetString(p *radius.Packet) (value string) {
	value, _ = CalledStationID_LookupString(p)
	return
}

func CalledStationID_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, avp := range p.Attributes {
		if avp.Type != CalledStationID_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func CalledStationID_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, avp := range p.Attributes {
		if avp.Type != CalledStationID_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func CalledStationID_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := p.Lookup(CalledStationID_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func CalledStationID_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := p.Lookup(CalledStationID_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func CalledStationID_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Set(CalledStationID_Type, a)
	return
}

func CalledStationID_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Set(CalledStationID_Type, a)
	return
}

func CalledStationID_Del(p *radius.Packet) {
	p.Attributes.Del(CalledStationID_Type)
}

func CallingStationID_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Add(CallingStationID_Type, a)
	return
}

func CallingStationID_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Add(CallingStationID_Type, a)
	return
}

func CallingStationID_Get(p *radius.Packet) (value []byte) {
	value, _ = CallingStationID_Lookup(p)
	return
}

func CallingStationID_GetString(p *radius.Packet) (value string) {
	value, _ = CallingStationID_LookupString(p)
	return
}

func CallingStationID_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, avp := range p.Attributes {
		if avp.Type != CallingStationID_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func CallingStationID_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, avp := range p.Attributes {
		if avp.Type != CallingStationID_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func CallingStationID_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := p.Lookup(CallingStationID_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func CallingStationID_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := p.Lookup(CallingStationID_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func CallingStationID_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Set(CallingStationID_Type, a)
	return
}

func CallingStationID_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Set(CallingStationID_Type, a)
	return
}

func CallingStationID_Del(p *radius.Packet) {
	p.Attributes.Del(CallingStationID_Type)
}

func NASIdentifier_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Add(NASIdentifier_Type, a)
	return
}

func NASIdentifier_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Add(NASIdentifier_Type, a)
	return
}

func NASIdentifier_Get(p *radius.Packet) (value []byte) {
	value, _ = NASIdentifier_Lookup(p)
	return
}

func NASIdentifier_GetString(p *radius.Packet) (value string) {
	value, _ = NASIdentifier_LookupString(p)
	return
}

func NASIdentifier_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, avp := range p.Attributes {
		if avp.Type != NASIdentifier_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func NASIdentifier_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, avp := range p.Attributes {
		if avp.Type != NASIdentifier_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func NASIdentifier_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := p.Lookup(NASIdentifier_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func NASIdentifier_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := p.Lookup(NASIdentifier_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func NASIdentifier_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Set(NASIdentifier_Type, a)
	return
}

func NASIdentifier_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Set(NASIdentifier_Type, a)
	return
}

func NASIdentifier_Del(p *radius.Packet) {
	p.Attributes.Del(NASIdentifier_Type)
}

func ProxyState_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Add(ProxyState_Type, a)
	return
}

func ProxyState_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Add(ProxyState_Type, a)
	return
}

func ProxyState_Get(p *radius.Packet) (value []byte) {
	value, _ = ProxyState_Lookup(p)
	return
}

func ProxyState_GetString(p *radius.Packet) (value string) {
	value, _ = ProxyState_LookupString(p)
	return
}

func ProxyState_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, avp := range p.Attributes {
		if avp.Type != ProxyState_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ProxyState_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, avp := range p.Attributes {
		if avp.Type != ProxyState_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ProxyState_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := p.Lookup(ProxyState_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func ProxyState_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := p.Lookup(ProxyState_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func ProxyState_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Set(ProxyState_Type, a)
	return
}

func ProxyState_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Set(ProxyState_Type, a)
	return
}

func ProxyState_Del(p *radius.Packet) {
	p.Attributes.Del(ProxyState_Type)
}

func LoginLATService_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Add(LoginLATService_Type, a)
	return
}

func LoginLATService_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Add(LoginLATService_Type, a)
	return
}

func LoginLATService_Get(p *radius.Packet) (value []byte) {
	value, _ = LoginLATService_Lookup(p)
	return
}

func LoginLATService_GetString(p *radius.Packet) (value string) {
	value, _ = LoginLATService_LookupString(p)
	return
}

func LoginLATService_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, avp := range p.Attributes {
		if avp.Type != LoginLATService_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func LoginLATService_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, avp := range p.Attributes {
		if avp.Type != LoginLATService_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func LoginLATService_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := p.Lookup(LoginLATService_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func LoginLATService_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := p.Lookup(LoginLATService_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func LoginLATService_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Set(LoginLATService_Type, a)
	return
}

func LoginLATService_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Set(LoginLATService_Type, a)
	return
}

func LoginLATService_Del(p *radius.Packet) {
	p.Attributes.Del(LoginLATService_Type)
}

func LoginLATNode_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Add(LoginLATNode_Type, a)
	return
}

func LoginLATNode_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Add(LoginLATNode_Type, a)
	return
}

func LoginLATNode_Get(p *radius.Packet) (value []byte) {
	value, _ = LoginLATNode_Lookup(p)
	return
}

func LoginLATNode_GetString(p *radius.Packet) (value string) {
	value, _ = LoginLATNode_LookupString(p)
	return
}

func LoginLATNode_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, avp := range p.Attributes {
		if avp.Type != LoginLATNode_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func LoginLATNode_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, avp := range p.Attributes {
		if avp.Type != LoginLATNode_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func LoginLATNode_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := p.Lookup(LoginLATNode_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func LoginLATNode_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := p.Lookup(LoginLATNode_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func LoginLATNode_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Set(LoginLATNode_Type, a)
	return
}

func LoginLATNode_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Set(LoginLATNode_Type, a)
	return
}

func LoginLATNode_Del(p *radius.Packet) {
	p.Attributes.Del(LoginLATNode_Type)
}

func LoginLATGroup_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Add(LoginLATGroup_Type, a)
	return
}

func LoginLATGroup_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Add(LoginLATGroup_Type, a)
	return
}

func LoginLATGroup_Get(p *radius.Packet) (value []byte) {
	value, _ = LoginLATGroup_Lookup(p)
	return
}

func LoginLATGroup_GetString(p *radius.Packet) (value string) {
	value, _ = LoginLATGroup_LookupString(p)
	return
}

func LoginLATGroup_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, avp := range p.Attributes {
		if avp.Type != LoginLATGroup_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func LoginLATGroup_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, avp := range p.Attributes {
		if avp.Type != LoginLATGroup_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func LoginLATGroup_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := p.Lookup(LoginLATGroup_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func LoginLATGroup_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := p.Lookup(LoginLATGroup_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func LoginLATGroup_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Set(LoginLATGroup_Type, a)
	return
}

func LoginLATGroup_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Set(LoginLATGroup_Type, a)
	return
}

func LoginLATGroup_Del(p *radius.Packet) {
	p.Attributes.Del(LoginLATGroup_Type)
}

type FramedAppleTalkLink uint32

var FramedAppleTalkLink_Strings = map[FramedAppleTalkLink]string{}

func (a FramedAppleTalkLink) String() string {
	if str, ok := FramedAppleTalkLink_Strings[a]; ok {
		return str
	}
	return "FramedAppleTalkLink(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func FramedAppleTalkLink_Add(p *radius.Packet, value FramedAppleTalkLink) (err error) {
	a := radius.NewInteger(uint32(value))
	p.Add(FramedAppleTalkLink_Type, a)
	return
}

func FramedAppleTalkLink_Get(p *radius.Packet) (value FramedAppleTalkLink) {
	value, _ = FramedAppleTalkLink_Lookup(p)
	return
}

func FramedAppleTalkLink_Gets(p *radius.Packet) (values []FramedAppleTalkLink, err error) {
	var i uint32
	for _, avp := range p.Attributes {
		if avp.Type != FramedAppleTalkLink_Type {
			continue
		}
		attr := avp.Attribute
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, FramedAppleTalkLink(i))
	}
	return
}

func FramedAppleTalkLink_Lookup(p *radius.Packet) (value FramedAppleTalkLink, err error) {
	a, ok := p.Lookup(FramedAppleTalkLink_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = FramedAppleTalkLink(i)
	return
}

func FramedAppleTalkLink_Set(p *radius.Packet, value FramedAppleTalkLink) (err error) {
	a := radius.NewInteger(uint32(value))
	p.Set(FramedAppleTalkLink_Type, a)
	return
}

func FramedAppleTalkLink_Del(p *radius.Packet) {
	p.Attributes.Del(FramedAppleTalkLink_Type)
}

type FramedAppleTalkNetwork uint32

var FramedAppleTalkNetwork_Strings = map[FramedAppleTalkNetwork]string{}

func (a FramedAppleTalkNetwork) String() string {
	if str, ok := FramedAppleTalkNetwork_Strings[a]; ok {
		return str
	}
	return "FramedAppleTalkNetwork(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func FramedAppleTalkNetwork_Add(p *radius.Packet, value FramedAppleTalkNetwork) (err error) {
	a := radius.NewInteger(uint32(value))
	p.Add(FramedAppleTalkNetwork_Type, a)
	return
}

func FramedAppleTalkNetwork_Get(p *radius.Packet) (value FramedAppleTalkNetwork) {
	value, _ = FramedAppleTalkNetwork_Lookup(p)
	return
}

func FramedAppleTalkNetwork_Gets(p *radius.Packet) (values []FramedAppleTalkNetwork, err error) {
	var i uint32
	for _, avp := range p.Attributes {
		if avp.Type != FramedAppleTalkNetwork_Type {
			continue
		}
		attr := avp.Attribute
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, FramedAppleTalkNetwork(i))
	}
	return
}

func FramedAppleTalkNetwork_Lookup(p *radius.Packet) (value FramedAppleTalkNetwork, err error) {
	a, ok := p.Lookup(FramedAppleTalkNetwork_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = FramedAppleTalkNetwork(i)
	return
}

func FramedAppleTalkNetwork_Set(p *radius.Packet, value FramedAppleTalkNetwork) (err error) {
	a := radius.NewInteger(uint32(value))
	p.Set(FramedAppleTalkNetwork_Type, a)
	return
}

func FramedAppleTalkNetwork_Del(p *radius.Packet) {
	p.Attributes.Del(FramedAppleTalkNetwork_Type)
}

func FramedAppleTalkZone_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Add(FramedAppleTalkZone_Type, a)
	return
}

func FramedAppleTalkZone_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Add(FramedAppleTalkZone_Type, a)
	return
}

func FramedAppleTalkZone_Get(p *radius.Packet) (value []byte) {
	value, _ = FramedAppleTalkZone_Lookup(p)
	return
}

func FramedAppleTalkZone_GetString(p *radius.Packet) (value string) {
	value, _ = FramedAppleTalkZone_LookupString(p)
	return
}

func FramedAppleTalkZone_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, avp := range p.Attributes {
		if avp.Type != FramedAppleTalkZone_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func FramedAppleTalkZone_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, avp := range p.Attributes {
		if avp.Type != FramedAppleTalkZone_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func FramedAppleTalkZone_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := p.Lookup(FramedAppleTalkZone_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func FramedAppleTalkZone_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := p.Lookup(FramedAppleTalkZone_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func FramedAppleTalkZone_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Set(FramedAppleTalkZone_Type, a)
	return
}

func FramedAppleTalkZone_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Set(FramedAppleTalkZone_Type, a)
	return
}

func FramedAppleTalkZone_Del(p *radius.Packet) {
	p.Attributes.Del(FramedAppleTalkZone_Type)
}

func CHAPChallenge_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Add(CHAPChallenge_Type, a)
	return
}

func CHAPChallenge_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Add(CHAPChallenge_Type, a)
	return
}

func CHAPChallenge_Get(p *radius.Packet) (value []byte) {
	value, _ = CHAPChallenge_Lookup(p)
	return
}

func CHAPChallenge_GetString(p *radius.Packet) (value string) {
	value, _ = CHAPChallenge_LookupString(p)
	return
}

func CHAPChallenge_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, avp := range p.Attributes {
		if avp.Type != CHAPChallenge_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func CHAPChallenge_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, avp := range p.Attributes {
		if avp.Type != CHAPChallenge_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func CHAPChallenge_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := p.Lookup(CHAPChallenge_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func CHAPChallenge_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := p.Lookup(CHAPChallenge_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func CHAPChallenge_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Set(CHAPChallenge_Type, a)
	return
}

func CHAPChallenge_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Set(CHAPChallenge_Type, a)
	return
}

func CHAPChallenge_Del(p *radius.Packet) {
	p.Attributes.Del(CHAPChallenge_Type)
}

type NASPortType uint32

const (
	NASPortType_Value_Async            NASPortType = 0
	NASPortType_Value_Sync             NASPortType = 1
	NASPortType_Value_ISDN             NASPortType = 2
	NASPortType_Value_ISDNV120         NASPortType = 3
	NASPortType_Value_ISDNV110         NASPortType = 4
	NASPortType_Value_Virtual          NASPortType = 5
	NASPortType_Value_PIAFS            NASPortType = 6
	NASPortType_Value_HDLCClearChannel NASPortType = 7
	NASPortType_Value_X25              NASPortType = 8
	NASPortType_Value_X75              NASPortType = 9
	NASPortType_Value_G3Fax            NASPortType = 10
	NASPortType_Value_SDSL             NASPortType = 11
	NASPortType_Value_ADSLCAP          NASPortType = 12
	NASPortType_Value_ADSLDMT          NASPortType = 13
	NASPortType_Value_IDSL             NASPortType = 14
	NASPortType_Value_Ethernet         NASPortType = 15
	NASPortType_Value_XDSL             NASPortType = 16
	NASPortType_Value_Cable            NASPortType = 17
	NASPortType_Value_WirelessOther    NASPortType = 18
	NASPortType_Value_Wireless80211    NASPortType = 19
)

var NASPortType_Strings = map[NASPortType]string{
	NASPortType_Value_Async:            "Async",
	NASPortType_Value_Sync:             "Sync",
	NASPortType_Value_ISDN:             "ISDN",
	NASPortType_Value_ISDNV120:         "ISDN-V120",
	NASPortType_Value_ISDNV110:         "ISDN-V110",
	NASPortType_Value_Virtual:          "Virtual",
	NASPortType_Value_PIAFS:            "PIAFS",
	NASPortType_Value_HDLCClearChannel: "HDLC-Clear-Channel",
	NASPortType_Value_X25:              "X.25",
	NASPortType_Value_X75:              "X.75",
	NASPortType_Value_G3Fax:            "G.3-Fax",
	NASPortType_Value_SDSL:             "SDSL",
	NASPortType_Value_ADSLCAP:          "ADSL-CAP",
	NASPortType_Value_ADSLDMT:          "ADSL-DMT",
	NASPortType_Value_IDSL:             "IDSL",
	NASPortType_Value_Ethernet:         "Ethernet",
	NASPortType_Value_XDSL:             "xDSL",
	NASPortType_Value_Cable:            "Cable",
	NASPortType_Value_WirelessOther:    "Wireless-Other",
	NASPortType_Value_Wireless80211:    "Wireless-802.11",
}

func (a NASPortType) String() string {
	if str, ok := NASPortType_Strings[a]; ok {
		return str
	}
	return "NASPortType(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func NASPortType_Add(p *radius.Packet, value NASPortType) (err error) {
	a := radius.NewInteger(uint32(value))
	p.Add(NASPortType_Type, a)
	return
}

func NASPortType_Get(p *radius.Packet) (value NASPortType) {
	value, _ = NASPortType_Lookup(p)
	return
}

func NASPortType_Gets(p *radius.Packet) (values []NASPortType, err error) {
	var i uint32
	for _, avp := range p.Attributes {
		if avp.Type != NASPortType_Type {
			continue
		}
		attr := avp.Attribute
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, NASPortType(i))
	}
	return
}

func NASPortType_Lookup(p *radius.Packet) (value NASPortType, err error) {
	a, ok := p.Lookup(NASPortType_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = NASPortType(i)
	return
}

func NASPortType_Set(p *radius.Packet, value NASPortType) (err error) {
	a := radius.NewInteger(uint32(value))
	p.Set(NASPortType_Type, a)
	return
}

func NASPortType_Del(p *radius.Packet) {
	p.Attributes.Del(NASPortType_Type)
}

type PortLimit uint32

var PortLimit_Strings = map[PortLimit]string{}

func (a PortLimit) String() string {
	if str, ok := PortLimit_Strings[a]; ok {
		return str
	}
	return "PortLimit(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func PortLimit_Add(p *radius.Packet, value PortLimit) (err error) {
	a := radius.NewInteger(uint32(value))
	p.Add(PortLimit_Type, a)
	return
}

func PortLimit_Get(p *radius.Packet) (value PortLimit) {
	value, _ = PortLimit_Lookup(p)
	return
}

func PortLimit_Gets(p *radius.Packet) (values []PortLimit, err error) {
	var i uint32
	for _, avp := range p.Attributes {
		if avp.Type != PortLimit_Type {
			continue
		}
		attr := avp.Attribute
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, PortLimit(i))
	}
	return
}

func PortLimit_Lookup(p *radius.Packet) (value PortLimit, err error) {
	a, ok := p.Lookup(PortLimit_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = PortLimit(i)
	return
}

func PortLimit_Set(p *radius.Packet, value PortLimit) (err error) {
	a := radius.NewInteger(uint32(value))
	p.Set(PortLimit_Type, a)
	return
}

func PortLimit_Del(p *radius.Packet) {
	p.Attributes.Del(PortLimit_Type)
}

func LoginLATPort_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Add(LoginLATPort_Type, a)
	return
}

func LoginLATPort_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Add(LoginLATPort_Type, a)
	return
}

func LoginLATPort_Get(p *radius.Packet) (value []byte) {
	value, _ = LoginLATPort_Lookup(p)
	return
}

func LoginLATPort_GetString(p *radius.Packet) (value string) {
	value, _ = LoginLATPort_LookupString(p)
	return
}

func LoginLATPort_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, avp := range p.Attributes {
		if avp.Type != LoginLATPort_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func LoginLATPort_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, avp := range p.Attributes {
		if avp.Type != LoginLATPort_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func LoginLATPort_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := p.Lookup(LoginLATPort_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func LoginLATPort_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := p.Lookup(LoginLATPort_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func LoginLATPort_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Set(LoginLATPort_Type, a)
	return
}

func LoginLATPort_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Set(LoginLATPort_Type, a)
	return
}

func LoginLATPort_Del(p *radius.Packet) {
	p.Attributes.Del(LoginLATPort_Type)
}
