/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.compressor;

import com.izforge.izpack.compiler.CompilerException;
import com.izforge.izpack.compressor.BZip2PackCompressor;
import com.izforge.izpack.compressor.DefaultPackCompressor;
import com.izforge.izpack.compressor.PackCompressor;
import com.izforge.izpack.compressor.RawPackCompressor;
import java.util.HashMap;

public class PackCompressorFactory {
    private static HashMap<String, PackCompressor> typeMap = new HashMap();
    private static CompilerException ShitHappens = null;

    private PackCompressorFactory() {
    }

    public static void cachedRegister(PackCompressor packCompressor) {
        if (!PackCompressorFactory.good()) {
            return;
        }
        try {
            PackCompressorFactory.register(packCompressor);
        }
        catch (CompilerException compilerException) {
            ShitHappens = compilerException;
        }
    }

    public static void register(PackCompressor packCompressor) throws CompilerException {
        String[] stringArray;
        for (String string : stringArray = packCompressor.getCompressionFormatSymbols()) {
            String string2 = string.toLowerCase();
            if (typeMap.containsKey(string2)) {
                throw new CompilerException("PackCompressor for symbol " + string2 + " allready registered");
            }
            typeMap.put(string2, packCompressor);
        }
    }

    public static boolean isTypeSupported(String string) throws CompilerException {
        if (!PackCompressorFactory.good()) {
            throw ShitHappens;
        }
        string = string.toLowerCase();
        return typeMap.containsKey(string);
    }

    public static PackCompressor get(String string) throws CompilerException {
        if (!PackCompressorFactory.good()) {
            throw ShitHappens;
        }
        if (!typeMap.containsKey(string = string.toLowerCase())) {
            throw new CompilerException("No PackCompressor registered for the given symbol " + string + ".");
        }
        return typeMap.get(string);
    }

    public static CompilerException getRegisterException() {
        return ShitHappens;
    }

    public static void setRegisterException(CompilerException compilerException) {
        ShitHappens = compilerException;
    }

    public static boolean good() {
        return ShitHappens == null;
    }

    static {
        PackCompressorFactory.cachedRegister(new RawPackCompressor());
        PackCompressorFactory.cachedRegister(new DefaultPackCompressor());
        PackCompressorFactory.cachedRegister(new BZip2PackCompressor());
    }
}

