/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.CustomData;
import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Panel;
import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.adaptator.impl.XMLParser;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.installer.DataValidatorFactory;
import com.izforge.izpack.installer.InstallerBase;
import com.izforge.izpack.installer.InstallerException;
import com.izforge.izpack.installer.PanelAction;
import com.izforge.izpack.installer.PanelActionFactory;
import com.izforge.izpack.installer.PanelAutomation;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.util.AbstractUIHandler;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutomatedInstaller
extends InstallerBase {
    private TreeMap<String, Integer> panelInstanceCount;
    private AutomatedInstallData idata = new AutomatedInstallData();
    private boolean result = false;

    public AutomatedInstaller(String string) throws Exception {
        File file = new File(string);
        this.loadInstallData(this.idata);
        this.idata.xmlData = this.getXMLData(file);
        this.idata.localeISO3 = this.idata.xmlData.getAttribute("langpack", "eng");
        InputStream inputStream = this.getClass().getResourceAsStream("/langpacks/" + this.idata.localeISO3 + ".xml");
        this.idata.langpack = new LocaleDatabase(inputStream);
        this.idata.setVariable("ISO3_LANG", this.idata.localeISO3);
        ResourceManager.create(this.idata);
        this.addCustomLangpack(this.idata);
        this.panelInstanceCount = new TreeMap();
        this.loadConditions(this.idata);
        this.loadInstallerRequirements();
        this.loadDynamicVariables();
    }

    private boolean writeUninstallData() {
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            UninstallData uninstallData = UninstallData.getInstance();
            List list = uninstallData.getUninstalableFilesList();
            ZipOutputStream zipOutputStream = this.idata.uninstallOutJar;
            if (zipOutputStream == null) {
                return true;
            }
            System.out.println("[ Writing the uninstaller data ... ]");
            zipOutputStream.putNextEntry(new ZipEntry("install.log"));
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(zipOutputStream));
            bufferedWriter.write(this.idata.getInstallPath());
            bufferedWriter.newLine();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                bufferedWriter.write((String)iterator.next());
                if (!iterator.hasNext()) continue;
                bufferedWriter.newLine();
            }
            bufferedWriter.flush();
            zipOutputStream.closeEntry();
            zipOutputStream.putNextEntry(new ZipEntry("jarlocation.log"));
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(zipOutputStream));
            bufferedWriter.write(uninstallData.getUninstallerJarFilename());
            bufferedWriter.newLine();
            bufferedWriter.write(uninstallData.getUninstallerPath());
            bufferedWriter.flush();
            zipOutputStream.closeEntry();
            zipOutputStream.putNextEntry(new ZipEntry("executables"));
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(zipOutputStream);
            iterator = uninstallData.getExecutablesList().iterator();
            objectOutputStream.writeInt(uninstallData.getExecutablesList().size());
            while (iterator.hasNext()) {
                object5 = (ExecutableFile)iterator.next();
                objectOutputStream.writeObject(object5);
            }
            objectOutputStream.flush();
            zipOutputStream.closeEntry();
            object5 = uninstallData.getAdditionalData();
            if (object5 != null && !object5.isEmpty()) {
                object4 = object5.keySet().iterator();
                object3 = new HashSet();
                while (object4 != null && object4.hasNext()) {
                    int n;
                    Object object6;
                    long l;
                    Object object7;
                    Object object8;
                    object2 = (String)object4.next();
                    Object v = object5.get(object2);
                    if ("__uninstallLibs__".equals(object2)) {
                        object = ((List)v).iterator();
                        while (object != null && object.hasNext()) {
                            object8 = (String)((List)object.next()).get(0);
                            object7 = new byte[5120];
                            l = 0L;
                            zipOutputStream.putNextEntry(new ZipEntry("native/" + (String)object8));
                            object6 = this.getClass().getResourceAsStream("/native/" + (String)object8);
                            while ((n = ((InputStream)object6).read((byte[])object7)) != -1) {
                                zipOutputStream.write((byte[])object7, 0, n);
                                l += (long)n;
                            }
                            zipOutputStream.closeEntry();
                        }
                        continue;
                    }
                    if ("uninstallerListeners".equals(object2) || "uninstallerJars".equals(object2)) {
                        object = new ArrayList();
                        object8 = ((List)v).iterator();
                        while (object8.hasNext()) {
                            object7 = new byte[5120];
                            l = 0L;
                            object6 = (CustomData)object8.next();
                            if (((CustomData)object6).listenerName != null) {
                                ((ArrayList)object).add(((CustomData)object6).listenerName);
                            }
                            for (String string : ((CustomData)object6).contents) {
                                if (((HashSet)object3).contains(string)) continue;
                                ((HashSet)object3).add(string);
                                try {
                                    zipOutputStream.putNextEntry(new ZipEntry(string));
                                }
                                catch (ZipException zipException) {
                                    Debug.trace("ZipException in writing custom data: " + zipException.getMessage());
                                    continue;
                                }
                                InputStream inputStream = this.getClass().getResourceAsStream("/" + string);
                                if (inputStream != null) {
                                    while ((n = inputStream.read((byte[])object7)) != -1) {
                                        zipOutputStream.write((byte[])object7, 0, n);
                                        l += (long)n;
                                    }
                                } else {
                                    Debug.trace("custom data not found: " + string);
                                }
                                zipOutputStream.closeEntry();
                            }
                        }
                        zipOutputStream.putNextEntry(new ZipEntry((String)object2));
                        object7 = new ObjectOutputStream(zipOutputStream);
                        ((ObjectOutputStream)object7).writeObject(object);
                        ((ObjectOutputStream)object7).flush();
                        zipOutputStream.closeEntry();
                        continue;
                    }
                    zipOutputStream.putNextEntry(new ZipEntry((String)object2));
                    if (v instanceof ByteArrayOutputStream) {
                        ((ByteArrayOutputStream)v).writeTo(zipOutputStream);
                    } else {
                        object = new ObjectOutputStream(zipOutputStream);
                        ((ObjectOutputStream)object).writeObject(v);
                        ((ObjectOutputStream)object).flush();
                    }
                    zipOutputStream.closeEntry();
                }
            }
            object4 = uninstallData.getUninstallScripts();
            object3 = ((ArrayList)object4).iterator();
            int n = 0;
            while (object3.hasNext()) {
                zipOutputStream.putNextEntry(new ZipEntry("rootscript" + Integer.toString(n)));
                object2 = new ObjectOutputStream(zipOutputStream);
                object = (String)object3.next();
                ((ObjectOutputStream)object2).writeUTF((String)object);
                ((ObjectOutputStream)object2).flush();
                zipOutputStream.closeEntry();
            }
            zipOutputStream.flush();
            zipOutputStream.close();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInstall() throws Exception {
        block10: {
            if (!this.checkInstallerRequirements(this.idata)) {
                Debug.log("not all installerconditions are fulfilled.");
                System.exit(-1);
                return;
            }
            System.out.println("[ Starting automated installation ]");
            Debug.log("[ Starting automated installation ]");
            try {
                this.result = true;
                VariableSubstitutor variableSubstitutor = new VariableSubstitutor(this.idata.getVariables());
                for (Panel panel : this.idata.panelsOrder) {
                    if (panel.hasCondition() && !this.idata.getRules().isConditionTrue(panel.getCondition(), this.idata.variables)) {
                        Debug.log("Condition for panel " + panel.getPanelid() + "is not fulfilled, skipping panel!");
                        if (this.panelInstanceCount.containsKey(panel.className)) {
                            this.panelInstanceCount.put(panel.className, this.panelInstanceCount.get(panel.className) + 1);
                            continue;
                        }
                        this.panelInstanceCount.put(panel.className, 1);
                        continue;
                    }
                    if (!OsConstraint.oneMatchesCurrentSystem(panel.osConstraints)) continue;
                    PanelAutomation panelAutomation = this.getPanelAutomationHelper(panel);
                    if (panelAutomation == null) {
                        this.executePreValidateActions(panel, null);
                        this.validatePanel(panel);
                        this.executePostValidateActions(panel, null);
                        continue;
                    }
                    IXMLElement iXMLElement = this.updateInstanceCount(panel);
                    this.installPanel(panel, panelAutomation, iXMLElement);
                    this.refreshDynamicVariables(variableSubstitutor, this.idata);
                }
                this.writeUninstallData();
                if (this.result) {
                    System.out.println("[ Automated installation done ]");
                    break block10;
                }
                System.out.println("[ Automated installation FAILED! ]");
            }
            catch (Exception exception) {
                try {
                    this.result = false;
                    System.err.println(exception.toString());
                    exception.printStackTrace();
                    System.out.println("[ Automated installation FAILED! ]");
                }
                catch (Throwable throwable) {
                    Housekeeper.getInstance().shutDown(this.result ? 0 : 1);
                    throw throwable;
                }
                Housekeeper.getInstance().shutDown(this.result ? 0 : 1);
            }
        }
        Housekeeper.getInstance().shutDown(this.result ? 0 : 1);
    }

    private void installPanel(Panel panel, PanelAutomation panelAutomation, IXMLElement iXMLElement) throws InstallerException {
        this.executePreActivateActions(panel, null);
        Debug.log("automationHelperInstance.runAutomated :" + panelAutomation.getClass().getName() + " entered.");
        panelAutomation.runAutomated(this.idata, iXMLElement);
        Debug.log("automationHelperInstance.runAutomated :" + panelAutomation.getClass().getName() + " successfully done.");
        this.executePreValidateActions(panel, null);
        this.validatePanel(panel);
        this.executePostValidateActions(panel, null);
    }

    private IXMLElement updateInstanceCount(Panel panel) {
        String string = panel.className;
        Vector<IXMLElement> vector = this.idata.xmlData.getChildrenNamed(string);
        int n = 0;
        if (this.panelInstanceCount.containsKey(string)) {
            n = this.panelInstanceCount.get(string);
        }
        IXMLElement iXMLElement = vector.elementAt(n);
        this.panelInstanceCount.put(string, n + 1);
        return iXMLElement;
    }

    private PanelAutomation getPanelAutomationHelper(Panel panel) {
        Class<?> clazz = null;
        PanelAutomation panelAutomation = null;
        String string = "com.izforge.izpack.panels.";
        if (panel.className.compareTo(".") > -1) {
            string = "";
        }
        String string2 = string + panel.className + "AutomationHelper";
        try {
            Debug.log("AutomationHelper:" + string2);
            clazz = Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Debug.log("ClassNotFoundException-skip :" + string2);
        }
        this.executePreConstructActions(panel, null);
        if (clazz != null) {
            try {
                Debug.log("Instantiate :" + string2);
                panelAutomation = (PanelAutomation)clazz.newInstance();
            }
            catch (IllegalAccessException illegalAccessException) {
                Debug.log("ERROR: no default constructor for " + string2 + ", skipping...");
            }
            catch (InstantiationException instantiationException) {
                Debug.log("ERROR: no default constructor for " + string2 + ", skipping...");
            }
        }
        return panelAutomation;
    }

    private void validatePanel(Panel panel) throws InstallerException {
        DataValidator dataValidator;
        DataValidator.Status status;
        String string = panel.getValidator();
        if (string != null && (status = (dataValidator = DataValidatorFactory.createDataValidator(string)).validateData(this.idata)) != DataValidator.Status.OK) {
            if (status == DataValidator.Status.WARNING && dataValidator.getDefaultAnswer()) {
                System.out.println("Configuration said, it's ok to go on, if validation is not successfull");
                return;
            }
            this.result = false;
            throw new InstallerException("Validating data for panel " + panel.getPanelid() + " was not successfull");
        }
    }

    public IXMLElement getXMLData(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        XMLParser xMLParser = new XMLParser();
        IXMLElement iXMLElement = xMLParser.parse(fileInputStream, file.getAbsolutePath());
        fileInputStream.close();
        return iXMLElement;
    }

    public boolean getResult() {
        return this.result;
    }

    private List<PanelAction> createPanelActionsFromStringList(Panel panel, List<String> list) {
        ArrayList<PanelAction> arrayList = null;
        if (list != null) {
            arrayList = new ArrayList<PanelAction>();
            for (String string : list) {
                PanelAction panelAction = PanelActionFactory.createPanelAction(string);
                panelAction.initialize(panel.getPanelActionConfiguration(string));
                arrayList.add(panelAction);
            }
        }
        return arrayList;
    }

    private void executePreConstructActions(Panel panel, AbstractUIHandler abstractUIHandler) {
        List<PanelAction> list = this.createPanelActionsFromStringList(panel, panel.getPreConstructionActions());
        if (list != null) {
            for (PanelAction panelAction : list) {
                panelAction.executeAction(this.idata, abstractUIHandler);
            }
        }
    }

    private void executePreActivateActions(Panel panel, AbstractUIHandler abstractUIHandler) {
        List<PanelAction> list = this.createPanelActionsFromStringList(panel, panel.getPreActivationActions());
        if (list != null) {
            for (PanelAction panelAction : list) {
                panelAction.executeAction(this.idata, abstractUIHandler);
            }
        }
    }

    private void executePreValidateActions(Panel panel, AbstractUIHandler abstractUIHandler) {
        List<PanelAction> list = this.createPanelActionsFromStringList(panel, panel.getPreValidationActions());
        if (list != null) {
            for (PanelAction panelAction : list) {
                panelAction.executeAction(this.idata, abstractUIHandler);
            }
        }
    }

    private void executePostValidateActions(Panel panel, AbstractUIHandler abstractUIHandler) {
        List<PanelAction> list = this.createPanelActionsFromStringList(panel, panel.getPostValidationActions());
        if (list != null) {
            for (PanelAction panelAction : list) {
                panelAction.executeAction(this.idata, abstractUIHandler);
            }
        }
    }
}

