//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
use objc2_core_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/ctrubyannotation?language=objc)
#[doc(alias = "CTRubyAnnotationRef")]
#[repr(C)]
pub struct CTRubyAnnotation {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CTRubyAnnotation {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__CTRubyAnnotation"> for CTRubyAnnotation {}
);

unsafe impl ConcreteType for CTRubyAnnotation {
    /// Returns the CFType of the ruby annotation object
    #[doc(alias = "CTRubyAnnotationGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CTRubyAnnotationGetTypeID() -> CFTypeID;
        }
        unsafe { CTRubyAnnotationGetTypeID() }
    }
}

/// These constants specify how to align the ruby annotation and the base text relative to each other when they don't have the same length.
///
///
/// CoreText will determine the alignment.
///
///
/// The ruby text is aligned with the start edge of the base text.
///
///
/// The ruby text is centered within the width of the base text. If the ruby text is wider than the base text the base text is centered in the width of the ruby text.
///
///
/// The ruby text is aligned with the end edge of the base text.
///
///
/// If the width of the ruby text is less than the width of the base text, the ruby text is evenly distributed over the width of the base text, with the first letter of the ruby text aligning with the first letter of the base text and the last letter of the ruby text aligning with the last letter of the base text. If the width of the base text is less than the width of the ruby text, the base text is evenly distributed over the width of the ruby text.
///
///
/// If the width of the ruby text is less than the width of the base text, the ruby text is evenly distributed over the width of the base text, with a certain amount of space, usually half the inter-character width of the ruby text, before the first and after the last character. If the width of the base text is less than the width of the ruby text, the base text is similarly aligned to the width of the ruby text.
///
///
/// If the ruby text is not adjacent to a line edge it is aligned as with kCTRubyAlignmentAuto. If it is adjacent to a line edge the end of ruby text adjacent to the line edge is aligned to the line edge. This is only relevant if the width of the ruby text is greater than the width of the base text; otherwise alignment is as with kCTRubyAlignmentAuto.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/ctrubyalignment?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CTRubyAlignment(pub u8);
impl CTRubyAlignment {
    #[doc(alias = "kCTRubyAlignmentInvalid")]
    pub const Invalid: Self = Self(255);
    #[doc(alias = "kCTRubyAlignmentAuto")]
    pub const Auto: Self = Self(0);
    #[doc(alias = "kCTRubyAlignmentStart")]
    pub const Start: Self = Self(1);
    #[doc(alias = "kCTRubyAlignmentCenter")]
    pub const Center: Self = Self(2);
    #[doc(alias = "kCTRubyAlignmentEnd")]
    pub const End: Self = Self(3);
    #[doc(alias = "kCTRubyAlignmentDistributeLetter")]
    pub const DistributeLetter: Self = Self(4);
    #[doc(alias = "kCTRubyAlignmentDistributeSpace")]
    pub const DistributeSpace: Self = Self(5);
    #[doc(alias = "kCTRubyAlignmentLineEdge")]
    pub const LineEdge: Self = Self(6);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CTRubyAlignment {
    const ENCODING: Encoding = u8::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CTRubyAlignment {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// These constants specify whether, and on which side, ruby text is allowed to overhang adjacent text if it is wider than the base text.
///
///
/// The ruby text can overhang adjacent text on both sides.
///
///
/// The ruby text can overhang the text that proceeds it.
///
///
/// The ruby text can overhang the text that follows it.
///
///
/// The ruby text cannot overhang the proceeding or following text.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/ctrubyoverhang?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CTRubyOverhang(pub u8);
impl CTRubyOverhang {
    #[doc(alias = "kCTRubyOverhangInvalid")]
    pub const Invalid: Self = Self(255);
    #[doc(alias = "kCTRubyOverhangAuto")]
    pub const Auto: Self = Self(0);
    #[doc(alias = "kCTRubyOverhangStart")]
    pub const Start: Self = Self(1);
    #[doc(alias = "kCTRubyOverhangEnd")]
    pub const End: Self = Self(2);
    #[doc(alias = "kCTRubyOverhangNone")]
    pub const None: Self = Self(3);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CTRubyOverhang {
    const ENCODING: Encoding = u8::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CTRubyOverhang {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// These constants specify the position of the ruby text with respect to the base text.
///
///
/// The ruby text is positioned before the base text; i.e. above horizontal text and to the right of vertical text.
///
///
/// The ruby text is positioned after the base text; i.e. below horizontal text and to the left of vertical text.
///
///
/// The ruby text is positioned to the right of the base text whether it is horizontal or vertical. This is the way that Bopomofo annotations are attached to Chinese text in Taiwan.
///
///
/// The ruby text follows the base text with no special styling.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/ctrubyposition?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CTRubyPosition(pub u8);
impl CTRubyPosition {
    #[doc(alias = "kCTRubyPositionBefore")]
    pub const Before: Self = Self(0);
    #[doc(alias = "kCTRubyPositionAfter")]
    pub const After: Self = Self(1);
    #[doc(alias = "kCTRubyPositionInterCharacter")]
    pub const InterCharacter: Self = Self(2);
    #[doc(alias = "kCTRubyPositionInline")]
    pub const Inline: Self = Self(3);
    #[doc(alias = "kCTRubyPositionCount")]
    pub const Count: Self = Self(4);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CTRubyPosition {
    const ENCODING: Encoding = u8::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CTRubyPosition {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern "C" {
    /// Specifies the size of the annotation text as a percent of the size of the base text.
    ///
    ///
    /// Value must be a CFNumberRef.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctrubyannotationsizefactorattributename?language=objc)
    pub static kCTRubyAnnotationSizeFactorAttributeName: &'static CFString;
}

extern "C" {
    /// Treat the size specified in kCTRubyAnnotationSizeFactorAttributeName as the maximum
    /// scale factor, when the base text size is smaller than annotation text size, we will
    /// try to scale the annotation font size down so that it will fit the base text without
    /// overhang or adding extra padding between base text.
    ///
    ///
    /// Value must be a CFBooleanRef. Default is false.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctrubyannotationscaletofitattributename?language=objc)
    pub static kCTRubyAnnotationScaleToFitAttributeName: &'static CFString;
}

impl CTRubyAnnotation {
    /// Creates an immutable ruby annotation object.
    ///
    ///
    /// Using this function to create a ruby annotation object with more precise
    /// control of the annotation text.
    ///
    ///
    /// Parameter `alignment`: Specifies how the ruby text and the base text should be aligned relative to each other.
    ///
    ///
    /// Parameter `overhang`: Specifies how the ruby text can overhang adjacent characters.
    ///
    ///
    /// Parameter `position`: The position of the annotation text.
    ///
    ///
    /// Parameter `string`: A string without any formatting, its format will be derived from the attrs specified below.
    ///
    ///
    /// Parameter `attributes`: A attribute dictionary to combine with the string specified above. If you don't specify
    /// kCTFontAttributeName, the font used by the Ruby annotation will be deduced from the base
    /// text, with a size factor specified by a CFNumberRef value keyed by
    /// kCTRubyAnnotationSizeFactorAttributeName.
    ///
    ///
    /// Returns: This function will return a reference to a CTRubyAnnotation object.
    ///
    /// # Safety
    ///
    /// `attributes` generics must be of the correct type.
    #[doc(alias = "CTRubyAnnotationCreateWithAttributes")]
    #[inline]
    pub unsafe fn with_attributes(
        alignment: CTRubyAlignment,
        overhang: CTRubyOverhang,
        position: CTRubyPosition,
        string: &CFString,
        attributes: &CFDictionary,
    ) -> CFRetained<CTRubyAnnotation> {
        extern "C-unwind" {
            fn CTRubyAnnotationCreateWithAttributes(
                alignment: CTRubyAlignment,
                overhang: CTRubyOverhang,
                position: CTRubyPosition,
                string: &CFString,
                attributes: &CFDictionary,
            ) -> Option<NonNull<CTRubyAnnotation>>;
        }
        let ret = unsafe {
            CTRubyAnnotationCreateWithAttributes(alignment, overhang, position, string, attributes)
        };
        let ret =
            ret.expect("function was marked as returning non-null, but actually returned NULL");
        unsafe { CFRetained::from_raw(ret) }
    }

    /// Creates an immutable copy of a ruby annotation object.
    ///
    ///
    /// Parameter `rubyAnnotation`: The ruby annotation that you wish to copy.
    ///
    ///
    /// Returns: If the "rubyAnnotation" reference is valid, then this
    /// function will return valid reference to an immutable
    /// CTRubyAnnotation object that is a copy of the one passed into
    /// "rubyAnnotation".
    #[doc(alias = "CTRubyAnnotationCreateCopy")]
    #[inline]
    pub unsafe fn copy(&self) -> CFRetained<CTRubyAnnotation> {
        extern "C-unwind" {
            fn CTRubyAnnotationCreateCopy(
                ruby_annotation: &CTRubyAnnotation,
            ) -> Option<NonNull<CTRubyAnnotation>>;
        }
        let ret = unsafe { CTRubyAnnotationCreateCopy(self) };
        let ret =
            ret.expect("function was marked as returning non-null, but actually returned NULL");
        unsafe { CFRetained::from_raw(ret) }
    }

    /// Get the alignment value of a ruby annotation object.
    ///
    ///
    /// Parameter `rubyAnnotation`: The ruby annotation object.
    ///
    ///
    /// Returns: If the "rubyAnnotation" reference is valid, then this
    /// function will return its alignment. Otherwise it will return kCTRubyAlignmentInvalid.
    #[doc(alias = "CTRubyAnnotationGetAlignment")]
    #[inline]
    pub unsafe fn alignment(&self) -> CTRubyAlignment {
        extern "C-unwind" {
            fn CTRubyAnnotationGetAlignment(ruby_annotation: &CTRubyAnnotation) -> CTRubyAlignment;
        }
        unsafe { CTRubyAnnotationGetAlignment(self) }
    }

    /// Get the overhang value of a ruby annotation object.
    ///
    ///
    /// Parameter `rubyAnnotation`: The ruby annotation object.
    ///
    ///
    /// Returns: If the "rubyAnnotation" reference is valid, then this
    /// function will return its overhang value. Otherwise it will return kCTRubyOverhangInvalid.
    #[doc(alias = "CTRubyAnnotationGetOverhang")]
    #[inline]
    pub unsafe fn overhang(&self) -> CTRubyOverhang {
        extern "C-unwind" {
            fn CTRubyAnnotationGetOverhang(ruby_annotation: &CTRubyAnnotation) -> CTRubyOverhang;
        }
        unsafe { CTRubyAnnotationGetOverhang(self) }
    }

    /// Get the size factor of a ruby annotation object.
    ///
    ///
    /// Parameter `rubyAnnotation`: The ruby annotation object.
    ///
    ///
    /// Returns: If the "rubyAnnotation" reference is valid, then this
    /// function will return its sizeFactor. Otherwise it will return 0.
    #[doc(alias = "CTRubyAnnotationGetSizeFactor")]
    #[inline]
    pub unsafe fn size_factor(&self) -> CGFloat {
        extern "C-unwind" {
            fn CTRubyAnnotationGetSizeFactor(ruby_annotation: &CTRubyAnnotation) -> CGFloat;
        }
        unsafe { CTRubyAnnotationGetSizeFactor(self) }
    }

    /// Get the ruby text for a particular position in a ruby annotation.
    ///
    ///
    /// Parameter `rubyAnnotation`: The ruby annotation object.
    ///
    ///
    /// Parameter `position`: The position for which you want to get the ruby text.
    ///
    ///
    /// Returns: If the "rubyAnnotation" reference and the position are valid, then this
    /// function will return a CFStringRef for the text. Otherwise it will return NULL.
    #[doc(alias = "CTRubyAnnotationGetTextForPosition")]
    #[inline]
    pub unsafe fn text_for_position(
        &self,
        position: CTRubyPosition,
    ) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn CTRubyAnnotationGetTextForPosition(
                ruby_annotation: &CTRubyAnnotation,
                position: CTRubyPosition,
            ) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { CTRubyAnnotationGetTextForPosition(self, position) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }
}

#[deprecated = "renamed to `CTRubyAnnotation::with_attributes`"]
#[inline]
pub unsafe extern "C-unwind" fn CTRubyAnnotationCreateWithAttributes(
    alignment: CTRubyAlignment,
    overhang: CTRubyOverhang,
    position: CTRubyPosition,
    string: &CFString,
    attributes: &CFDictionary,
) -> CFRetained<CTRubyAnnotation> {
    extern "C-unwind" {
        fn CTRubyAnnotationCreateWithAttributes(
            alignment: CTRubyAlignment,
            overhang: CTRubyOverhang,
            position: CTRubyPosition,
            string: &CFString,
            attributes: &CFDictionary,
        ) -> Option<NonNull<CTRubyAnnotation>>;
    }
    let ret = unsafe {
        CTRubyAnnotationCreateWithAttributes(alignment, overhang, position, string, attributes)
    };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

#[deprecated = "renamed to `CTRubyAnnotation::copy`"]
#[inline]
pub unsafe extern "C-unwind" fn CTRubyAnnotationCreateCopy(
    ruby_annotation: &CTRubyAnnotation,
) -> CFRetained<CTRubyAnnotation> {
    extern "C-unwind" {
        fn CTRubyAnnotationCreateCopy(
            ruby_annotation: &CTRubyAnnotation,
        ) -> Option<NonNull<CTRubyAnnotation>>;
    }
    let ret = unsafe { CTRubyAnnotationCreateCopy(ruby_annotation) };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

extern "C-unwind" {
    #[deprecated = "renamed to `CTRubyAnnotation::alignment`"]
    pub fn CTRubyAnnotationGetAlignment(ruby_annotation: &CTRubyAnnotation) -> CTRubyAlignment;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CTRubyAnnotation::overhang`"]
    pub fn CTRubyAnnotationGetOverhang(ruby_annotation: &CTRubyAnnotation) -> CTRubyOverhang;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CTRubyAnnotation::size_factor`"]
    pub fn CTRubyAnnotationGetSizeFactor(ruby_annotation: &CTRubyAnnotation) -> CGFloat;
}

#[deprecated = "renamed to `CTRubyAnnotation::text_for_position`"]
#[inline]
pub unsafe extern "C-unwind" fn CTRubyAnnotationGetTextForPosition(
    ruby_annotation: &CTRubyAnnotation,
    position: CTRubyPosition,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CTRubyAnnotationGetTextForPosition(
            ruby_annotation: &CTRubyAnnotation,
            position: CTRubyPosition,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CTRubyAnnotationGetTextForPosition(ruby_annotation, position) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}
