// This file is part of Desktop App Toolkit,
// a set of libraries for developing nice desktop applications.
//
// For license and copyright information please follow this link:
// https://github.com/desktop-app/legal/blob/master/LEGAL
//
#include "base/bytes.h"

#include "base/random.h"

namespace bytes {

void set_random(span destination) {
	if (!destination.empty()) {
		base::RandomFill(destination.data(), destination.size());
	}
}

} // namespace bytes
