/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.actions.ToggleAction;
import org.openstreetmap.josm.data.osm.visitor.paint.MapRendererFactory;
import org.openstreetmap.josm.data.osm.visitor.paint.StyledMapRenderer;
import org.openstreetmap.josm.data.osm.visitor.paint.StyledTiledMapRenderer;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.AbstractMapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class TiledRenderToggleAction
extends ToggleAction
implements ExpertToggleAction.ExpertModeChangeListener {
    public TiledRenderToggleAction() {
        super(I18n.tr("Tiled Rendering", new Object[0]), null, I18n.tr("Enable/disable rendering the map in tiles", new Object[0]), Shortcut.registerShortcut("menu:view:tiled", I18n.tr("View: {0}", I18n.tr("Tiled View", new Object[0])), 65535, 5000), false);
        this.setToolbarId("tiledRendering");
        MainApplication.getToolbar().register(this);
        this.setSelected(false);
        if (MapRendererFactory.getInstance().isMapRendererActive(StyledTiledMapRenderer.class)) {
            MapRendererFactory.getInstance().activate(StyledMapRenderer.class);
        }
        ExpertToggleAction.addExpertModeChangeListener(this, true);
    }

    @Override
    protected boolean listenToSelectionChange() {
        return false;
    }

    @Override
    public void expertChanged(boolean isExpert) {
        this.updateEnabledState();
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.getLayerManager().getActiveData() != null && ExpertToggleAction.isExpert());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.toggleSelectedState(e);
        if (this.isSelected()) {
            MapRendererFactory.getInstance().activate(StyledTiledMapRenderer.class);
        } else {
            MapRendererFactory.getInstance().activate(StyledMapRenderer.class);
        }
        this.notifySelectedState();
        this.getLayerManager().getLayersOfType(OsmDataLayer.class).forEach(AbstractMapViewPaintable::invalidate);
    }
}

