/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1beta2 "k8s.io/api/apps/v1beta2"
	appsv1beta2 "k8s.io/client-go/applyconfigurations/apps/v1beta2"
	gentype "k8s.io/client-go/gentype"
	typedappsv1beta2 "k8s.io/client-go/kubernetes/typed/apps/v1beta2"
)

// fakeDaemonSets implements DaemonSetInterface
type fakeDaemonSets struct {
	*gentype.FakeClientWithListAndApply[*v1beta2.DaemonSet, *v1beta2.DaemonSetList, *appsv1beta2.DaemonSetApplyConfiguration]
	Fake *FakeAppsV1beta2
}

func newFakeDaemonSets(fake *FakeAppsV1beta2, namespace string) typedappsv1beta2.DaemonSetInterface {
	return &fakeDaemonSets{
		gentype.NewFakeClientWithListAndApply[*v1beta2.DaemonSet, *v1beta2.DaemonSetList, *appsv1beta2.DaemonSetApplyConfiguration](
			fake.Fake,
			namespace,
			v1beta2.SchemeGroupVersion.WithResource("daemonsets"),
			v1beta2.SchemeGroupVersion.WithKind("DaemonSet"),
			func() *v1beta2.DaemonSet { return &v1beta2.DaemonSet{} },
			func() *v1beta2.DaemonSetList { return &v1beta2.DaemonSetList{} },
			func(dst, src *v1beta2.DaemonSetList) { dst.ListMeta = src.ListMeta },
			func(list *v1beta2.DaemonSetList) []*v1beta2.DaemonSet { return gentype.ToPointerSlice(list.Items) },
			func(list *v1beta2.DaemonSetList, items []*v1beta2.DaemonSet) {
				list.Items = gentype.FromPointerSlice(items)
			},
		),
		fake,
	}
}
