/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.message_markup.element;

import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.message_markup.element.MarkupElement;

public class ListElement
extends MarkupElement.NonEmptyChildElement {
    public static final String ELEMENT = "list";
    public static final QName QNAME = new QName("urn:xmpp:markup:0", "list");
    private final List<ListEntryElement> entries;

    public ListElement(int start, int end, List<ListEntryElement> entries) {
        super(start, end);
        this.entries = Collections.unmodifiableList(entries);
    }

    public List<ListEntryElement> getEntries() {
        return this.entries;
    }

    @Override
    public String getElementName() {
        return QNAME.getLocalPart();
    }

    @Override
    public void appendInnerXml(XmlStringBuilder xml) {
        xml.append(this.getEntries());
    }

    public static class ListEntryElement
    implements ExtensionElement {
        public static final String ELEMENT = "li";
        public static final QName QNAME = new QName("urn:xmpp:markup:0", "li");
        private final int start;

        public ListEntryElement(int start) {
            this.start = start;
        }

        public int getStart() {
            return this.start;
        }

        @Override
        public String getElementName() {
            return QNAME.getLocalPart();
        }

        @Override
        public String getNamespace() {
            return QNAME.getNamespaceURI();
        }

        @Override
        public XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
            XmlStringBuilder xml = new XmlStringBuilder(this, enclosingNamespace);
            xml.attribute("start", this.getStart());
            xml.closeEmptyElement();
            return xml;
        }
    }
}

