/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo.exceptions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jivesoftware.smackx.omemo.internal.OmemoDevice;
import org.jxmpp.jid.BareJid;

public class CannotEstablishOmemoSessionException
extends Exception {
    private static final long serialVersionUID = 3165844730283295249L;
    private final Map<BareJid, Map<OmemoDevice, Throwable>> failures = new HashMap<BareJid, Map<OmemoDevice, Throwable>>();
    private final Map<BareJid, List<OmemoDevice>> successes = new HashMap<BareJid, List<OmemoDevice>>();

    public CannotEstablishOmemoSessionException(OmemoDevice failed, Throwable reason) {
        this.getFailsOfContact(failed.getJid()).put(failed, reason);
    }

    public void addFailures(CannotEstablishOmemoSessionException otherFailures) {
        for (Map.Entry<BareJid, Map<OmemoDevice, Throwable>> entry : otherFailures.getFailures().entrySet()) {
            this.getFailsOfContact(entry.getKey()).putAll(entry.getValue());
        }
    }

    public void addSuccess(OmemoDevice success) {
        this.getSuccessesOfContact(success.getJid()).add(success);
    }

    public Map<BareJid, Map<OmemoDevice, Throwable>> getFailures() {
        return this.failures;
    }

    public Map<BareJid, List<OmemoDevice>> getSuccesses() {
        return this.successes;
    }

    private Map<OmemoDevice, Throwable> getFailsOfContact(BareJid contact) {
        Map<OmemoDevice, Throwable> h = this.failures.get(contact);
        if (h == null) {
            h = new HashMap<OmemoDevice, Throwable>();
            this.failures.put(contact, h);
        }
        return h;
    }

    private List<OmemoDevice> getSuccessesOfContact(BareJid contact) {
        List<OmemoDevice> suc = this.successes.get(contact);
        if (suc == null) {
            suc = new ArrayList<OmemoDevice>();
            this.successes.put(contact, suc);
        }
        return suc;
    }

    public boolean requiresThrowing() {
        for (Map.Entry<BareJid, Map<OmemoDevice, Throwable>> entry : this.failures.entrySet()) {
            List<OmemoDevice> suc = this.successes.get(entry.getKey());
            if (suc != null && !suc.isEmpty()) continue;
            return true;
        }
        return false;
    }
}

