/*++

Copyright (C) 2019 Calculator developers

All rights reserved.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.6.0.

Abstract: This is an autogenerated C++-Header file in order to allow an easy
 use of Calculator library

Interface version: 1.0.0

*/

#ifndef __CALCULATOR_DYNAMICHEADER_CPPTYPES
#define __CALCULATOR_DYNAMICHEADER_CPPTYPES

#include "calculator_types.hpp"



/*************************************************************************************************************************
 Class definition for Base
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class definition for Variable
**************************************************************************************************************************/

/**
* Returns the current value of this Variable
*
* @param[in] pVariable - Variable instance.
* @param[out] pValue - The current value of this Variable
* @return error code or 0 (success)
*/
typedef CalculatorResult (*PCalculatorVariable_GetValuePtr) (Calculator_Variable pVariable, Calculator_double * pValue);

/**
* Set the numerical value of this Variable
*
* @param[in] pVariable - Variable instance.
* @param[in] dValue - The new value of this Variable
* @return error code or 0 (success)
*/
typedef CalculatorResult (*PCalculatorVariable_SetValuePtr) (Calculator_Variable pVariable, Calculator_double dValue);

/*************************************************************************************************************************
 Class definition for Calculator
**************************************************************************************************************************/

/**
* Adds a Variable to the list of Variables this calculator works on
*
* @param[in] pCalculator - Calculator instance.
* @param[in] pVariable - The new variable in this calculator
* @return error code or 0 (success)
*/
typedef CalculatorResult (*PCalculatorCalculator_EnlistVariablePtr) (Calculator_Calculator pCalculator, Calculator_Variable pVariable);

/**
* Returns an instance of a enlisted variable
*
* @param[in] pCalculator - Calculator instance.
* @param[in] nIndex - The index of the variable to query
* @param[out] pVariable - The Index-th variable in this calculator
* @return error code or 0 (success)
*/
typedef CalculatorResult (*PCalculatorCalculator_GetEnlistedVariablePtr) (Calculator_Calculator pCalculator, Calculator_uint32 nIndex, Calculator_Variable * pVariable);

/**
* Clears all variables in enlisted in this calculator
*
* @param[in] pCalculator - Calculator instance.
* @return error code or 0 (success)
*/
typedef CalculatorResult (*PCalculatorCalculator_ClearVariablesPtr) (Calculator_Calculator pCalculator);

/**
* Multiplies all enlisted variables
*
* @param[in] pCalculator - Calculator instance.
* @param[out] pInstance - Variable that holds the product of all enlisted Variables
* @return error code or 0 (success)
*/
typedef CalculatorResult (*PCalculatorCalculator_MultiplyPtr) (Calculator_Calculator pCalculator, Calculator_Variable * pInstance);

/**
* Sums all enlisted variables
*
* @param[in] pCalculator - Calculator instance.
* @param[out] pInstance - Variable that holds the sum of all enlisted Variables
* @return error code or 0 (success)
*/
typedef CalculatorResult (*PCalculatorCalculator_AddPtr) (Calculator_Calculator pCalculator, Calculator_Variable * pInstance);

/*************************************************************************************************************************
 Global functions
**************************************************************************************************************************/

/**
* retrieves the binary version of this library.
*
* @param[out] pMajor - returns the major version of this library
* @param[out] pMinor - returns the minor version of this library
* @param[out] pMicro - returns the micro version of this library
* @return error code or 0 (success)
*/
typedef CalculatorResult (*PCalculatorGetVersionPtr) (Calculator_uint32 * pMajor, Calculator_uint32 * pMinor, Calculator_uint32 * pMicro);

/**
* Returns the last error recorded on this object
*
* @param[in] pInstance - Instance Handle
* @param[in] nErrorMessageBufferSize - size of the buffer (including trailing 0)
* @param[out] pErrorMessageNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pErrorMessageBuffer -  buffer of Message of the last error, may be NULL
* @param[out] pHasError - Is there a last error to query
* @return error code or 0 (success)
*/
typedef CalculatorResult (*PCalculatorGetLastErrorPtr) (Calculator_Base pInstance, const Calculator_uint32 nErrorMessageBufferSize, Calculator_uint32* pErrorMessageNeededChars, char * pErrorMessageBuffer, bool * pHasError);

/**
* Releases shared ownership of an Instance
*
* @param[in] pInstance - Instance Handle
* @return error code or 0 (success)
*/
typedef CalculatorResult (*PCalculatorReleaseInstancePtr) (Calculator_Base pInstance);

/**
* Acquires shared ownership of an Instance
*
* @param[in] pInstance - Instance Handle
* @return error code or 0 (success)
*/
typedef CalculatorResult (*PCalculatorAcquireInstancePtr) (Calculator_Base pInstance);

/**
* Creates a new Variable instance
*
* @param[in] dInitialValue - Initial value of the new Variable
* @param[out] pInstance - New Variable instance
* @return error code or 0 (success)
*/
typedef CalculatorResult (*PCalculatorCreateVariablePtr) (Calculator_double dInitialValue, Calculator_Variable * pInstance);

/**
* Creates a new Calculator instance
*
* @param[out] pInstance - New Calculator instance
* @return error code or 0 (success)
*/
typedef CalculatorResult (*PCalculatorCreateCalculatorPtr) (Calculator_Calculator * pInstance);

/*************************************************************************************************************************
 Function Table Structure
**************************************************************************************************************************/

typedef struct {
	void * m_LibraryHandle;
	PCalculatorVariable_GetValuePtr m_Variable_GetValue;
	PCalculatorVariable_SetValuePtr m_Variable_SetValue;
	PCalculatorCalculator_EnlistVariablePtr m_Calculator_EnlistVariable;
	PCalculatorCalculator_GetEnlistedVariablePtr m_Calculator_GetEnlistedVariable;
	PCalculatorCalculator_ClearVariablesPtr m_Calculator_ClearVariables;
	PCalculatorCalculator_MultiplyPtr m_Calculator_Multiply;
	PCalculatorCalculator_AddPtr m_Calculator_Add;
	PCalculatorGetVersionPtr m_GetVersion;
	PCalculatorGetLastErrorPtr m_GetLastError;
	PCalculatorReleaseInstancePtr m_ReleaseInstance;
	PCalculatorAcquireInstancePtr m_AcquireInstance;
	PCalculatorCreateVariablePtr m_CreateVariable;
	PCalculatorCreateCalculatorPtr m_CreateCalculator;
} sCalculatorDynamicWrapperTable;

#endif // __CALCULATOR_DYNAMICHEADER_CPPTYPES

