// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by sidekick. DO NOT EDIT.

#[allow(unused_imports)]
use super::*;

impl std::fmt::Debug for super::Api {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("Api");
        debug_struct.field("name", &self.name);
        debug_struct.field("methods", &self.methods);
        debug_struct.field("options", &self.options);
        debug_struct.field("version", &self.version);
        debug_struct.field("source_context", &self.source_context);
        debug_struct.field("mixins", &self.mixins);
        debug_struct.field("syntax", &self.syntax);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::Method {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("Method");
        debug_struct.field("name", &self.name);
        debug_struct.field("request_type_url", &self.request_type_url);
        debug_struct.field("request_streaming", &self.request_streaming);
        debug_struct.field("response_type_url", &self.response_type_url);
        debug_struct.field("response_streaming", &self.response_streaming);
        debug_struct.field("options", &self.options);
        debug_struct.field("syntax", &self.syntax);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::Mixin {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("Mixin");
        debug_struct.field("name", &self.name);
        debug_struct.field("root", &self.root);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::FileDescriptorSet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("FileDescriptorSet");
        debug_struct.field("file", &self.file);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::FileDescriptorProto {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("FileDescriptorProto");
        debug_struct.field("name", &self.name);
        debug_struct.field("package", &self.package);
        debug_struct.field("dependency", &self.dependency);
        debug_struct.field("public_dependency", &self.public_dependency);
        debug_struct.field("weak_dependency", &self.weak_dependency);
        debug_struct.field("message_type", &self.message_type);
        debug_struct.field("enum_type", &self.enum_type);
        debug_struct.field("service", &self.service);
        debug_struct.field("extension", &self.extension);
        debug_struct.field("options", &self.options);
        debug_struct.field("source_code_info", &self.source_code_info);
        debug_struct.field("syntax", &self.syntax);
        debug_struct.field("edition", &self.edition);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::DescriptorProto {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("DescriptorProto");
        debug_struct.field("name", &self.name);
        debug_struct.field("field", &self.field);
        debug_struct.field("extension", &self.extension);
        debug_struct.field("nested_type", &self.nested_type);
        debug_struct.field("enum_type", &self.enum_type);
        debug_struct.field("extension_range", &self.extension_range);
        debug_struct.field("oneof_decl", &self.oneof_decl);
        debug_struct.field("options", &self.options);
        debug_struct.field("reserved_range", &self.reserved_range);
        debug_struct.field("reserved_name", &self.reserved_name);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::descriptor_proto::ExtensionRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("ExtensionRange");
        debug_struct.field("start", &self.start);
        debug_struct.field("end", &self.end);
        debug_struct.field("options", &self.options);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::descriptor_proto::ReservedRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("ReservedRange");
        debug_struct.field("start", &self.start);
        debug_struct.field("end", &self.end);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::ExtensionRangeOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("ExtensionRangeOptions");
        debug_struct.field("uninterpreted_option", &self.uninterpreted_option);
        debug_struct.field("declaration", &self.declaration);
        debug_struct.field("features", &self.features);
        debug_struct.field("verification", &self.verification);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::extension_range_options::Declaration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("Declaration");
        debug_struct.field("number", &self.number);
        debug_struct.field("full_name", &self.full_name);
        debug_struct.field("r#type", &self.r#type);
        debug_struct.field("reserved", &self.reserved);
        debug_struct.field("repeated", &self.repeated);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::FieldDescriptorProto {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("FieldDescriptorProto");
        debug_struct.field("name", &self.name);
        debug_struct.field("number", &self.number);
        debug_struct.field("label", &self.label);
        debug_struct.field("r#type", &self.r#type);
        debug_struct.field("type_name", &self.type_name);
        debug_struct.field("extendee", &self.extendee);
        debug_struct.field("default_value", &self.default_value);
        debug_struct.field("oneof_index", &self.oneof_index);
        debug_struct.field("json_name", &self.json_name);
        debug_struct.field("options", &self.options);
        debug_struct.field("proto3_optional", &self.proto3_optional);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::OneofDescriptorProto {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("OneofDescriptorProto");
        debug_struct.field("name", &self.name);
        debug_struct.field("options", &self.options);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::EnumDescriptorProto {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("EnumDescriptorProto");
        debug_struct.field("name", &self.name);
        debug_struct.field("value", &self.value);
        debug_struct.field("options", &self.options);
        debug_struct.field("reserved_range", &self.reserved_range);
        debug_struct.field("reserved_name", &self.reserved_name);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::enum_descriptor_proto::EnumReservedRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("EnumReservedRange");
        debug_struct.field("start", &self.start);
        debug_struct.field("end", &self.end);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::EnumValueDescriptorProto {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("EnumValueDescriptorProto");
        debug_struct.field("name", &self.name);
        debug_struct.field("number", &self.number);
        debug_struct.field("options", &self.options);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::ServiceDescriptorProto {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("ServiceDescriptorProto");
        debug_struct.field("name", &self.name);
        debug_struct.field("method", &self.method);
        debug_struct.field("options", &self.options);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::MethodDescriptorProto {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("MethodDescriptorProto");
        debug_struct.field("name", &self.name);
        debug_struct.field("input_type", &self.input_type);
        debug_struct.field("output_type", &self.output_type);
        debug_struct.field("options", &self.options);
        debug_struct.field("client_streaming", &self.client_streaming);
        debug_struct.field("server_streaming", &self.server_streaming);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::FileOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("FileOptions");
        debug_struct.field("java_package", &self.java_package);
        debug_struct.field("java_outer_classname", &self.java_outer_classname);
        debug_struct.field("java_multiple_files", &self.java_multiple_files);
        debug_struct.field(
            "java_generate_equals_and_hash",
            &self.java_generate_equals_and_hash,
        );
        debug_struct.field("java_string_check_utf8", &self.java_string_check_utf8);
        debug_struct.field("optimize_for", &self.optimize_for);
        debug_struct.field("go_package", &self.go_package);
        debug_struct.field("cc_generic_services", &self.cc_generic_services);
        debug_struct.field("java_generic_services", &self.java_generic_services);
        debug_struct.field("py_generic_services", &self.py_generic_services);
        debug_struct.field("deprecated", &self.deprecated);
        debug_struct.field("cc_enable_arenas", &self.cc_enable_arenas);
        debug_struct.field("objc_class_prefix", &self.objc_class_prefix);
        debug_struct.field("csharp_namespace", &self.csharp_namespace);
        debug_struct.field("swift_prefix", &self.swift_prefix);
        debug_struct.field("php_class_prefix", &self.php_class_prefix);
        debug_struct.field("php_namespace", &self.php_namespace);
        debug_struct.field("php_metadata_namespace", &self.php_metadata_namespace);
        debug_struct.field("ruby_package", &self.ruby_package);
        debug_struct.field("features", &self.features);
        debug_struct.field("uninterpreted_option", &self.uninterpreted_option);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::MessageOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("MessageOptions");
        debug_struct.field("message_set_wire_format", &self.message_set_wire_format);
        debug_struct.field(
            "no_standard_descriptor_accessor",
            &self.no_standard_descriptor_accessor,
        );
        debug_struct.field("deprecated", &self.deprecated);
        debug_struct.field("map_entry", &self.map_entry);
        debug_struct.field(
            "deprecated_legacy_json_field_conflicts",
            &self.deprecated_legacy_json_field_conflicts,
        );
        debug_struct.field("features", &self.features);
        debug_struct.field("uninterpreted_option", &self.uninterpreted_option);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::FieldOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("FieldOptions");
        debug_struct.field("ctype", &self.ctype);
        debug_struct.field("packed", &self.packed);
        debug_struct.field("jstype", &self.jstype);
        debug_struct.field("lazy", &self.lazy);
        debug_struct.field("unverified_lazy", &self.unverified_lazy);
        debug_struct.field("deprecated", &self.deprecated);
        debug_struct.field("weak", &self.weak);
        debug_struct.field("debug_redact", &self.debug_redact);
        debug_struct.field("retention", &self.retention);
        debug_struct.field("targets", &self.targets);
        debug_struct.field("edition_defaults", &self.edition_defaults);
        debug_struct.field("features", &self.features);
        debug_struct.field("feature_support", &self.feature_support);
        debug_struct.field("uninterpreted_option", &self.uninterpreted_option);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::field_options::EditionDefault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("EditionDefault");
        debug_struct.field("edition", &self.edition);
        debug_struct.field("value", &self.value);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::field_options::FeatureSupport {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("FeatureSupport");
        debug_struct.field("edition_introduced", &self.edition_introduced);
        debug_struct.field("edition_deprecated", &self.edition_deprecated);
        debug_struct.field("deprecation_warning", &self.deprecation_warning);
        debug_struct.field("edition_removed", &self.edition_removed);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::OneofOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("OneofOptions");
        debug_struct.field("features", &self.features);
        debug_struct.field("uninterpreted_option", &self.uninterpreted_option);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::EnumOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("EnumOptions");
        debug_struct.field("allow_alias", &self.allow_alias);
        debug_struct.field("deprecated", &self.deprecated);
        debug_struct.field(
            "deprecated_legacy_json_field_conflicts",
            &self.deprecated_legacy_json_field_conflicts,
        );
        debug_struct.field("features", &self.features);
        debug_struct.field("uninterpreted_option", &self.uninterpreted_option);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::EnumValueOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("EnumValueOptions");
        debug_struct.field("deprecated", &self.deprecated);
        debug_struct.field("features", &self.features);
        debug_struct.field("debug_redact", &self.debug_redact);
        debug_struct.field("feature_support", &self.feature_support);
        debug_struct.field("uninterpreted_option", &self.uninterpreted_option);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::ServiceOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("ServiceOptions");
        debug_struct.field("features", &self.features);
        debug_struct.field("deprecated", &self.deprecated);
        debug_struct.field("uninterpreted_option", &self.uninterpreted_option);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::MethodOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("MethodOptions");
        debug_struct.field("deprecated", &self.deprecated);
        debug_struct.field("idempotency_level", &self.idempotency_level);
        debug_struct.field("features", &self.features);
        debug_struct.field("uninterpreted_option", &self.uninterpreted_option);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::UninterpretedOption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("UninterpretedOption");
        debug_struct.field("name", &self.name);
        debug_struct.field("identifier_value", &self.identifier_value);
        debug_struct.field("positive_int_value", &self.positive_int_value);
        debug_struct.field("negative_int_value", &self.negative_int_value);
        debug_struct.field("double_value", &self.double_value);
        debug_struct.field("string_value", &self.string_value);
        debug_struct.field("aggregate_value", &self.aggregate_value);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::uninterpreted_option::NamePart {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("NamePart");
        debug_struct.field("name_part", &self.name_part);
        debug_struct.field("is_extension", &self.is_extension);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::FeatureSet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("FeatureSet");
        debug_struct.field("field_presence", &self.field_presence);
        debug_struct.field("enum_type", &self.enum_type);
        debug_struct.field("repeated_field_encoding", &self.repeated_field_encoding);
        debug_struct.field("utf8_validation", &self.utf8_validation);
        debug_struct.field("message_encoding", &self.message_encoding);
        debug_struct.field("json_format", &self.json_format);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::FeatureSetDefaults {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("FeatureSetDefaults");
        debug_struct.field("defaults", &self.defaults);
        debug_struct.field("minimum_edition", &self.minimum_edition);
        debug_struct.field("maximum_edition", &self.maximum_edition);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::feature_set_defaults::FeatureSetEditionDefault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("FeatureSetEditionDefault");
        debug_struct.field("edition", &self.edition);
        debug_struct.field("overridable_features", &self.overridable_features);
        debug_struct.field("fixed_features", &self.fixed_features);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::SourceCodeInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("SourceCodeInfo");
        debug_struct.field("location", &self.location);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::source_code_info::Location {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("Location");
        debug_struct.field("path", &self.path);
        debug_struct.field("span", &self.span);
        debug_struct.field("leading_comments", &self.leading_comments);
        debug_struct.field("trailing_comments", &self.trailing_comments);
        debug_struct.field("leading_detached_comments", &self.leading_detached_comments);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::GeneratedCodeInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("GeneratedCodeInfo");
        debug_struct.field("annotation", &self.annotation);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::generated_code_info::Annotation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("Annotation");
        debug_struct.field("path", &self.path);
        debug_struct.field("source_file", &self.source_file);
        debug_struct.field("begin", &self.begin);
        debug_struct.field("end", &self.end);
        debug_struct.field("semantic", &self.semantic);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::SourceContext {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("SourceContext");
        debug_struct.field("file_name", &self.file_name);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::Type {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("Type");
        debug_struct.field("name", &self.name);
        debug_struct.field("fields", &self.fields);
        debug_struct.field("oneofs", &self.oneofs);
        debug_struct.field("options", &self.options);
        debug_struct.field("source_context", &self.source_context);
        debug_struct.field("syntax", &self.syntax);
        debug_struct.field("edition", &self.edition);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::Field {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("Field");
        debug_struct.field("kind", &self.kind);
        debug_struct.field("cardinality", &self.cardinality);
        debug_struct.field("number", &self.number);
        debug_struct.field("name", &self.name);
        debug_struct.field("type_url", &self.type_url);
        debug_struct.field("oneof_index", &self.oneof_index);
        debug_struct.field("packed", &self.packed);
        debug_struct.field("options", &self.options);
        debug_struct.field("json_name", &self.json_name);
        debug_struct.field("default_value", &self.default_value);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::Enum {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("Enum");
        debug_struct.field("name", &self.name);
        debug_struct.field("enumvalue", &self.enumvalue);
        debug_struct.field("options", &self.options);
        debug_struct.field("source_context", &self.source_context);
        debug_struct.field("syntax", &self.syntax);
        debug_struct.field("edition", &self.edition);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::EnumValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("EnumValue");
        debug_struct.field("name", &self.name);
        debug_struct.field("number", &self.number);
        debug_struct.field("options", &self.options);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::Option {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("Option");
        debug_struct.field("name", &self.name);
        debug_struct.field("value", &self.value);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}
